/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.circuits.Impedance;
import flanagan.complex.Complex;
import flanagan.math.Fmath;
import flanagan.math.VectorMaths;
import java.io.IOException;

public class Phasor {
    private double magnitude = 0.0;
    private double phaseInDeg = 0.0;
    private double phaseInRad = 0.0;
    private Complex rectangular = new Complex(0.0, 0.0);
    private static double frequency = Double.NaN;
    private static double omega = Double.NaN;

    public Phasor() {
    }

    public Phasor(double d, double d2) {
        this.magnitude = d;
        this.phaseInDeg = d2;
        this.phaseInRad = Math.toRadians(d2);
        this.rectangular.polar(this.magnitude, this.phaseInRad);
    }

    public Phasor(double d) {
        this.magnitude = d;
        this.rectangular.polar(this.magnitude, this.phaseInRad);
    }

    public static void setFrequency(double d) {
        if (!Fmath.isNaN(frequency)) {
            throw new IllegalArgumentException("You have already entered a value for the frequency, " + frequency + ", that differs from the one you are now attempting to enter, " + d);
        }
        frequency = d;
        omega = Math.PI * 2 * d;
    }

    public static void setRadialFrequency(double d) {
        if (!Fmath.isNaN(omega)) {
            throw new IllegalArgumentException("You have already entered a value for the radial frequency, omega, " + omega + ", that differs from the one you are now attempting to enter, " + d);
        }
        omega = d;
        frequency = omega / (Math.PI * 2);
    }

    public void setMagnitude(double d) {
        this.magnitude = d;
        this.rectangular.polar(this.magnitude, this.phaseInRad);
    }

    public void setPhaseInDegrees(double d) {
        this.phaseInDeg = d;
        this.phaseInRad = Math.toRadians(d);
        this.rectangular.polar(this.magnitude, this.phaseInRad);
    }

    public void reset(double d, double d2) {
        this.magnitude = d;
        this.phaseInDeg = d2;
        this.phaseInRad = Math.toRadians(d2);
        this.rectangular.polar(this.magnitude, this.phaseInRad);
    }

    public static double getFrequency() {
        return frequency;
    }

    public static double setRadialFrequency() {
        return omega;
    }

    public double getMagnitude() {
        return this.magnitude;
    }

    public double getPhaseInDegrees() {
        return this.phaseInDeg;
    }

    public double getPhaseInRadians() {
        return this.phaseInRad;
    }

    public double getReal() {
        return this.magnitude * Math.cos(this.phaseInRad);
    }

    public double getImag() {
        return this.magnitude * Math.sin(this.phaseInRad);
    }

    public static Phasor toPhasor(Complex complex) {
        Phasor phasor = new Phasor();
        phasor.magnitude = complex.abs();
        phasor.phaseInRad = complex.argRad();
        phasor.phaseInDeg = complex.argDeg();
        phasor.rectangular = complex;
        return phasor;
    }

    public Complex toRectangular() {
        Complex complex = new Complex();
        complex.polar(this.magnitude, this.phaseInRad);
        return complex;
    }

    public static Complex toRectangular(Phasor phasor) {
        Complex complex = new Complex();
        complex.polar(phasor.magnitude, phasor.phaseInRad);
        return complex;
    }

    public Complex toComplex() {
        Complex complex = new Complex();
        complex.polar(this.magnitude, this.phaseInRad);
        return complex;
    }

    public static Complex toComplex(Phasor phasor) {
        Complex complex = new Complex();
        complex.polar(phasor.magnitude, phasor.phaseInRad);
        return complex;
    }

    public VectorMaths toVectorMaths() {
        double d = this.magnitude * Math.sin(this.phaseInRad);
        double d2 = this.magnitude * Math.cos(this.phaseInRad);
        VectorMaths vectorMaths = new VectorMaths(d, d2);
        return vectorMaths;
    }

    public static VectorMaths toVectorMaths(Phasor phasor) {
        double d = phasor.magnitude * Math.sin(phasor.phaseInRad);
        double d2 = phasor.magnitude * Math.cos(phasor.phaseInRad);
        VectorMaths vectorMaths = new VectorMaths(d, d2);
        return vectorMaths;
    }

    public String toString() {
        return this.magnitude + "<" + this.phaseInDeg + "deg";
    }

    public static String toString(Phasor phasor) {
        return phasor.magnitude + "<" + phasor.phaseInDeg + "deg";
    }

    public static Phasor parsePhasor(String string) {
        int n;
        Phasor phasor = new Phasor();
        int n2 = (string = string.trim()).indexOf(60);
        if (n2 == -1 && (n2 = string.indexOf(76)) == -1) {
            throw new IllegalArgumentException("no angle symbol, <, in the string, ss");
        }
        int n3 = string.indexOf(100);
        if (n3 == -1) {
            n3 = string.indexOf(68);
        }
        if ((n = string.indexOf(114)) == -1) {
            n3 = string.indexOf(82);
        }
        String string2 = string.substring(0, n2);
        phasor.magnitude = Double.parseDouble(string2);
        String string3 = null;
        if (n3 != -1) {
            string3 = string.substring(n2 + 1, n3);
            phasor.phaseInDeg = Double.parseDouble(string2);
            phasor.phaseInRad = Math.toRadians(phasor.phaseInDeg);
        }
        if (n3 == -1 && n == -1) {
            string3 = string.substring(n2 + 1);
            phasor.phaseInDeg = Double.parseDouble(string3);
            phasor.phaseInRad = Math.toRadians(phasor.phaseInDeg);
        }
        if (n != -1) {
            string3 = string.substring(n2 + 1, n);
            phasor.phaseInRad = Double.parseDouble(string3);
            phasor.phaseInDeg = Math.toDegrees(phasor.phaseInRad);
        }
        phasor.rectangular.polar(phasor.magnitude, phasor.phaseInRad);
        return phasor;
    }

    public static Phasor valueOf(String string) {
        return Phasor.parsePhasor(string);
    }

    public static final synchronized Phasor readPhasor(String string) {
        int n = 32;
        String string2 = "";
        boolean bl = false;
        System.out.print(string + " ");
        System.out.flush();
        while (!bl) {
            try {
                n = System.in.read();
                if (n < 0 || (char)n == '\n') {
                    bl = true;
                    continue;
                }
                string2 = string2 + (char)n;
            }
            catch (IOException iOException) {
                bl = true;
            }
        }
        return Phasor.parsePhasor(string2);
    }

    public static final synchronized Phasor readPhasor(String string, String string2) {
        int n = 32;
        String string3 = "";
        boolean bl = false;
        System.out.print(string + " [default value = " + string2 + "]  ");
        System.out.flush();
        int n2 = 0;
        while (!bl) {
            try {
                n = System.in.read();
                if (n < 0 || (char)n == '\n' || (char)n == '\r') {
                    if (n2 == 0) {
                        string3 = string2;
                        if ((char)n == '\r') {
                            n = System.in.read();
                        }
                    }
                    bl = true;
                    continue;
                }
                string3 = string3 + (char)n;
                ++n2;
            }
            catch (IOException iOException) {
                bl = true;
            }
        }
        return Phasor.parsePhasor(string3);
    }

    public static final synchronized Phasor readPhasor(String string, Phasor phasor) {
        int n = 32;
        String string2 = "";
        boolean bl = false;
        System.out.print(string + " [default value = " + phasor + "]  ");
        System.out.flush();
        int n2 = 0;
        while (!bl) {
            try {
                n = System.in.read();
                if (n < 0 || (char)n == '\n' || (char)n == '\r') {
                    if (n2 == 0) {
                        if ((char)n == '\r') {
                            n = System.in.read();
                        }
                        return phasor;
                    }
                    bl = true;
                    continue;
                }
                string2 = string2 + (char)n;
                ++n2;
            }
            catch (IOException iOException) {
                bl = true;
            }
        }
        return Phasor.parsePhasor(string2);
    }

    public static final synchronized Phasor readPhasor() {
        int n = 32;
        String string = "";
        boolean bl = false;
        System.out.print(" ");
        System.out.flush();
        while (!bl) {
            try {
                n = System.in.read();
                if (n < 0 || (char)n == '\n') {
                    bl = true;
                    continue;
                }
                string = string + (char)n;
            }
            catch (IOException iOException) {
                bl = true;
            }
        }
        return Phasor.parsePhasor(string);
    }

    public void println(String string) {
        System.out.println(string + " " + this.toString());
    }

    public void println() {
        System.out.println(" " + this.toString());
    }

    public void print(String string) {
        System.out.print(string + " " + this.toString());
    }

    public void print() {
        System.out.print(" " + this.toString());
    }

    public static void println(String string, Phasor[] phasorArray) {
        System.out.println(string);
        for (int i = 0; i < phasorArray.length; ++i) {
            System.out.println(phasorArray[i].toString() + "  ");
        }
    }

    public static void println(Phasor[] phasorArray) {
        for (int i = 0; i < phasorArray.length; ++i) {
            System.out.println(phasorArray[i].toString() + "  ");
        }
    }

    public static void print(String string, Phasor[] phasorArray) {
        System.out.print(string + " ");
        for (int i = 0; i < phasorArray.length; ++i) {
            System.out.print(phasorArray[i].toString() + "   ");
        }
        System.out.println();
    }

    public static void print(Phasor[] phasorArray) {
        for (int i = 0; i < phasorArray.length; ++i) {
            System.out.print(phasorArray[i].toString() + "  ");
        }
        System.out.println();
    }

    public Phasor truncate(int n) {
        if (n < 0) {
            return this;
        }
        double d = this.magnitude;
        double d2 = this.phaseInDeg;
        double d3 = this.phaseInRad;
        Complex complex = this.rectangular;
        Phasor phasor = new Phasor();
        phasor.magnitude = Fmath.truncate(d, n);
        phasor.phaseInDeg = Fmath.truncate(d2, n);
        phasor.phaseInRad = Fmath.truncate(d3, n);
        phasor.rectangular = Complex.truncate(complex, n);
        return phasor;
    }

    public static Phasor truncate(Phasor phasor, int n) {
        if (n < 0) {
            return phasor;
        }
        double d = phasor.magnitude;
        double d2 = phasor.phaseInDeg;
        double d3 = phasor.phaseInRad;
        Complex complex = phasor.rectangular;
        Phasor phasor2 = new Phasor();
        phasor2.magnitude = Fmath.truncate(d, n);
        phasor2.phaseInDeg = Fmath.truncate(d2, n);
        phasor2.phaseInRad = Fmath.truncate(d3, n);
        phasor2.rectangular = Complex.truncate(complex, n);
        return phasor2;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.magnitude);
        long l2 = Double.doubleToLongBits(this.phaseInDeg);
        int n = (int)(l ^ l >>> 32);
        int n2 = (int)(l2 ^ l2 >>> 32);
        return 6 * (n / 10) + 4 * (n2 / 10);
    }

    public static Phasor[] oneDarray(int n) {
        Phasor[] phasorArray = new Phasor[n];
        Phasor phasor = new Phasor();
        phasor.reset(1.0, 0.0);
        for (int i = 0; i < n; ++i) {
            phasorArray[i] = phasor;
        }
        return phasorArray;
    }

    public static Phasor[] oneDarray(int n, double d, double d2) {
        Phasor[] phasorArray = new Phasor[n];
        Phasor phasor = new Phasor();
        phasor.reset(d, d2);
        for (int i = 0; i < n; ++i) {
            phasorArray[i] = phasor;
        }
        return phasorArray;
    }

    public static Phasor[] oneDarray(int n, Phasor phasor) {
        Phasor[] phasorArray = new Phasor[n];
        for (int i = 0; i < n; ++i) {
            phasorArray[i] = phasor.copy();
        }
        return phasorArray;
    }

    public static Phasor[][] twoDarray(int n, int n2) {
        Phasor[][] phasorArray = new Phasor[n][n2];
        Phasor phasor = new Phasor();
        phasor.reset(1.0, 0.0);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                phasorArray[i][j] = phasor;
            }
        }
        return phasorArray;
    }

    public static Phasor[][] twoDarray(int n, int n2, double d, double d2) {
        Phasor[][] phasorArray = new Phasor[n][n2];
        Phasor phasor = new Phasor();
        phasor.reset(d, d2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                phasorArray[i][j] = phasor;
            }
        }
        return phasorArray;
    }

    public static Phasor[][] twoDarray(int n, int n2, Phasor phasor) {
        Phasor[][] phasorArray = new Phasor[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                phasorArray[i][j] = phasor.copy();
            }
        }
        return phasorArray;
    }

    public static Phasor[][][] threeDarray(int n, int n2, int n3) {
        Phasor[][][] phasorArray = new Phasor[n][n2][n3];
        Phasor phasor = new Phasor();
        phasor.reset(1.0, 0.0);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    phasorArray[i][j][k] = phasor;
                }
            }
        }
        return phasorArray;
    }

    public static Phasor[][][] threeDarray(int n, int n2, int n3, double d, double d2) {
        Phasor[][][] phasorArray = new Phasor[n][n2][n3];
        Phasor phasor = new Phasor();
        phasor.reset(d, d2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    phasorArray[i][j][k] = phasor;
                }
            }
        }
        return phasorArray;
    }

    public static Phasor[][][] threeDarray(int n, int n2, int n3, Phasor phasor) {
        Phasor[][][] phasorArray = new Phasor[n][n2][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    phasorArray[i][j][k] = phasor.copy();
                }
            }
        }
        return phasorArray;
    }

    public Phasor copy() {
        if (this == null) {
            return null;
        }
        Phasor phasor = new Phasor();
        phasor.magnitude = this.magnitude;
        phasor.phaseInDeg = this.phaseInDeg;
        phasor.phaseInRad = this.phaseInRad;
        return phasor;
    }

    public static Phasor copy(Phasor phasor) {
        if (phasor == null) {
            return null;
        }
        Phasor phasor2 = new Phasor();
        phasor2.magnitude = phasor.magnitude;
        phasor2.phaseInDeg = phasor.phaseInDeg;
        phasor2.phaseInRad = phasor.phaseInRad;
        return phasor2;
    }

    public static Phasor[] copy(Phasor[] phasorArray) {
        if (phasorArray == null) {
            return null;
        }
        int n = phasorArray.length;
        Phasor[] phasorArray2 = Phasor.oneDarray(n);
        for (int i = 0; i < n; ++i) {
            phasorArray2[i] = phasorArray[i].copy();
        }
        return phasorArray2;
    }

    public static Phasor[][] copy(Phasor[][] phasorArray) {
        if (phasorArray == null) {
            return null;
        }
        int n = phasorArray.length;
        int n2 = phasorArray[0].length;
        Phasor[][] phasorArray2 = Phasor.twoDarray(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                phasorArray2[i][j] = phasorArray[i][j].copy();
            }
        }
        return phasorArray2;
    }

    public static Phasor[][][] copy(Phasor[][][] phasorArray) {
        if (phasorArray == null) {
            return null;
        }
        int n = phasorArray.length;
        int n2 = phasorArray[0].length;
        int n3 = phasorArray[0][0].length;
        Phasor[][][] phasorArray2 = Phasor.threeDarray(n, n2, n3);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    phasorArray2[i][j][k] = phasorArray[i][j][k].copy();
                }
            }
        }
        return phasorArray2;
    }

    public Object clone() {
        Phasor phasor = null;
        if (this != null) {
            Phasor phasor2 = new Phasor();
            phasor2.magnitude = this.magnitude;
            phasor2.phaseInDeg = this.phaseInDeg;
            phasor2.phaseInRad = this.phaseInRad;
            phasor = phasor2;
        }
        return phasor;
    }

    public Phasor plus(Phasor phasor) {
        Complex complex = this.toRectangular();
        Complex complex2 = phasor.toRectangular();
        Complex complex3 = complex.plus(complex2);
        return Phasor.toPhasor(complex3);
    }

    public Phasor plus(Complex complex) {
        Phasor phasor = new Phasor();
        Complex complex2 = this.toRectangular();
        Complex complex3 = complex.plus(complex2);
        return Phasor.toPhasor(complex3);
    }

    public void plusEquals(Phasor phasor) {
        Complex complex = this.toRectangular();
        Complex complex2 = phasor.toRectangular();
        Complex complex3 = complex.plus(complex2);
        Phasor phasor2 = Phasor.toPhasor(complex3);
        this.magnitude = phasor2.magnitude;
        this.phaseInDeg = phasor2.phaseInDeg;
        this.phaseInRad = phasor2.phaseInRad;
    }

    public void plusEquals(Complex complex) {
        Complex complex2 = this.toRectangular();
        Complex complex3 = complex.plus(complex2);
        Phasor phasor = Phasor.toPhasor(complex3);
        this.magnitude += phasor.magnitude;
        this.phaseInDeg += phasor.phaseInDeg;
        this.phaseInRad += phasor.phaseInRad;
    }

    public Phasor minus(Phasor phasor) {
        Complex complex = this.toRectangular();
        Complex complex2 = phasor.toRectangular();
        Complex complex3 = complex.minus(complex2);
        return Phasor.toPhasor(complex3);
    }

    public Phasor minus(Complex complex) {
        Phasor phasor = new Phasor();
        Complex complex2 = this.toRectangular();
        Complex complex3 = complex.minus(complex2);
        return Phasor.toPhasor(complex3);
    }

    public void minusEquals(Phasor phasor) {
        Complex complex = this.toRectangular();
        Complex complex2 = phasor.toRectangular();
        Complex complex3 = complex.plus(complex2);
        Phasor phasor2 = Phasor.toPhasor(complex3);
        this.magnitude = phasor2.magnitude;
        this.phaseInDeg = phasor2.phaseInDeg;
        this.phaseInRad = phasor2.phaseInRad;
    }

    public void minusEquals(Complex complex) {
        Complex complex2 = this.toRectangular();
        Complex complex3 = complex.plus(complex2);
        Phasor phasor = Phasor.toPhasor(complex3);
        this.magnitude = phasor.magnitude;
        this.phaseInDeg = phasor.phaseInDeg;
        this.phaseInRad = phasor.phaseInRad;
    }

    public Phasor times(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        double d = this.magnitude * phasor.magnitude;
        double d2 = this.phaseInDeg + phasor.phaseInDeg;
        phasor2.reset(d, d2);
        return phasor2;
    }

    public Phasor times(Complex complex) {
        Phasor phasor = Phasor.toPhasor(complex);
        Phasor phasor2 = new Phasor();
        double d = this.magnitude * phasor.magnitude;
        double d2 = this.phaseInDeg + phasor.phaseInDeg;
        phasor2.reset(d, d2);
        return phasor2;
    }

    public Phasor times(double d) {
        Phasor phasor = new Phasor();
        double d2 = this.magnitude * d;
        double d3 = this.phaseInDeg;
        phasor.reset(d2, d3);
        return phasor;
    }

    public Phasor times(int n) {
        Phasor phasor = new Phasor();
        double d = this.magnitude * (double)n;
        double d2 = this.phaseInDeg;
        phasor.reset(d, d2);
        return phasor;
    }

    public Phasor timesExpOmegaTime(double d, double d2) {
        if (!Fmath.isNaN(omega)) {
            throw new IllegalArgumentException("You have already entered a value for the radial frequency, omega, " + omega + ", that differs from the one you are now attempting to enter, " + d);
        }
        omega = d;
        frequency = omega / (Math.PI * 2);
        Phasor phasor = new Phasor();
        phasor.reset(this.magnitude, this.phaseInDeg + Math.toDegrees(d * d2));
        return phasor;
    }

    public Phasor timesExpTwoPiFreqTime(double d, double d2) {
        if (!Fmath.isNaN(frequency)) {
            throw new IllegalArgumentException("You have already entered a value for the frequency, " + frequency + ", that differs from the one you are now attempting to enter, " + d);
        }
        frequency = d;
        omega = frequency * 2.0 * Math.PI;
        Phasor phasor = new Phasor();
        phasor.reset(this.magnitude, this.phaseInDeg + Math.toDegrees(Math.PI * 2 * d * d2));
        return phasor;
    }

    public void timesEquals(Phasor phasor) {
        this.magnitude *= phasor.magnitude;
        this.phaseInDeg += phasor.phaseInDeg;
        this.phaseInRad += phasor.phaseInRad;
    }

    public void timesEquals(Complex complex) {
        Phasor phasor = Phasor.toPhasor(complex);
        this.magnitude *= phasor.magnitude;
        this.phaseInDeg += phasor.phaseInDeg;
        this.phaseInRad += phasor.phaseInRad;
    }

    public void timesEquals(double d) {
        this.magnitude *= d;
    }

    public void timesEquals(int n) {
        this.magnitude *= (double)n;
    }

    public void timesEqualsOmegaTime(double d, double d2) {
        if (!Fmath.isNaN(omega)) {
            throw new IllegalArgumentException("You have already entered a value for radial frequency, omega, " + omega + ", that differs from the one you are now attempting to enter, " + d);
        }
        omega = d;
        frequency = omega / (Math.PI * 2);
        this.phaseInRad += d * d2;
        this.phaseInDeg = Math.toDegrees(this.phaseInRad);
    }

    public void timesEqualsTwoPiFreqTime(double d, double d2) {
        if (!Fmath.isNaN(frequency)) {
            throw new IllegalArgumentException("You have already entered a value for the frequency, " + frequency + ", that differs from the one you are now attempting to enter, " + d);
        }
        frequency = d;
        omega = frequency * 2.0 * Math.PI;
        this.phaseInRad += Math.PI * 2 * d * d2;
        this.phaseInDeg = Math.toDegrees(this.phaseInRad);
    }

    public Phasor over(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        double d = this.magnitude / phasor.magnitude;
        double d2 = this.phaseInDeg - phasor.phaseInDeg;
        phasor2.reset(d, d2);
        return phasor2;
    }

    public Phasor over(Complex complex) {
        Phasor phasor = Phasor.toPhasor(complex);
        Phasor phasor2 = new Phasor();
        double d = this.magnitude / phasor.magnitude;
        double d2 = this.phaseInDeg - phasor.phaseInDeg;
        phasor2.reset(d, d2);
        return phasor2;
    }

    public Phasor over(double d) {
        Phasor phasor = new Phasor();
        double d2 = this.magnitude / d;
        double d3 = this.phaseInDeg;
        phasor.reset(d2, d3);
        return phasor;
    }

    public Phasor over(int n) {
        Phasor phasor = new Phasor();
        double d = this.magnitude / (double)n;
        double d2 = this.phaseInDeg;
        phasor.reset(d, d2);
        return phasor;
    }

    public void overEquals(Phasor phasor) {
        this.magnitude /= phasor.magnitude;
        this.phaseInDeg -= phasor.phaseInDeg;
        this.phaseInRad -= phasor.phaseInRad;
    }

    public void overEquals(Complex complex) {
        Phasor phasor = Phasor.toPhasor(complex);
        this.magnitude /= phasor.magnitude;
        this.phaseInDeg -= phasor.phaseInDeg;
        this.phaseInRad -= phasor.phaseInRad;
    }

    public void overEquals(double d) {
        this.magnitude /= d;
    }

    public void overEquals(int n) {
        this.magnitude /= (double)n;
    }

    public double abs() {
        return Math.abs(this.magnitude);
    }

    public double argInRadians() {
        return this.phaseInRad;
    }

    public double argInDegrees() {
        return this.phaseInDeg;
    }

    public Phasor negate() {
        Phasor phasor = new Phasor();
        phasor.reset(-this.magnitude, this.phaseInDeg);
        return phasor;
    }

    public Phasor conjugate() {
        Phasor phasor = new Phasor();
        phasor.reset(this.magnitude, -this.phaseInDeg);
        return phasor;
    }

    public Phasor inverse() {
        Phasor phasor = new Phasor();
        phasor.reset(1.0 / this.magnitude, -this.phaseInDeg);
        return phasor;
    }

    public static Phasor sqrt(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        phasor2.reset(Math.sqrt(phasor.magnitude), phasor.phaseInDeg / 2.0);
        return phasor2;
    }

    public static Phasor nthRoot(Phasor phasor, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The root, " + n + ", must be greater than zero");
        }
        Phasor phasor2 = new Phasor();
        phasor2.reset(Math.pow(phasor.magnitude, 1.0 / (double)n), phasor.phaseInDeg / (double)n);
        return phasor2;
    }

    public static Phasor square(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        phasor2.reset(Fmath.square(phasor.magnitude), 2.0 * phasor.phaseInDeg);
        return phasor2;
    }

    public static Phasor pow(Phasor phasor, int n) {
        Phasor phasor2 = new Phasor();
        phasor2.reset(Math.pow(phasor.magnitude, n), (double)n * phasor.phaseInDeg);
        return phasor2;
    }

    public static Phasor pow(Phasor phasor, double d) {
        Phasor phasor2 = new Phasor();
        phasor2.reset(Math.pow(phasor.magnitude, d), d * phasor.phaseInDeg);
        return phasor2;
    }

    public static Phasor pow(Phasor phasor, Complex complex) {
        Complex complex2 = phasor.toRectangular();
        Complex complex3 = Complex.pow(complex2, complex);
        Phasor phasor2 = Phasor.toPhasor(complex3);
        return phasor2;
    }

    public static Phasor pow(Phasor phasor, Phasor phasor2) {
        Complex complex = phasor.toRectangular();
        Complex complex2 = phasor2.toRectangular();
        Complex complex3 = Complex.pow(complex, complex2);
        Phasor phasor3 = Phasor.toPhasor(complex3);
        return phasor3;
    }

    public static Phasor exp(Phasor phasor) {
        Complex complex = phasor.toRectangular();
        complex = Complex.exp(complex);
        Phasor phasor2 = Phasor.toPhasor(complex);
        return phasor2;
    }

    public static Phasor log(Phasor phasor) {
        Complex complex = new Complex(Math.log(phasor.magnitude), phasor.phaseInDeg);
        Phasor phasor2 = Phasor.toPhasor(complex);
        return phasor2;
    }

    public Phasor sin(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Math.sin(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.sin(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor cos(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Math.cos(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.cos(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor tan(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Math.tan(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.tan(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor cot(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.cot(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.cot(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor sec(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.sec(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.sec(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor csc(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.csc(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.csc(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor exsec(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.exsec(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.exsec(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor vers(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.vers(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.vers(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor covers(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.covers(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.covers(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor hav(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.hav(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.hav(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor sinh(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.sinh(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.sinh(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor cosh(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.cosh(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.cosh(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor sech(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.sech(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.sech(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor csch(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.csch(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.csch(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor asin(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Math.asin(phasor.getMagnitude()), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.asin(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor acos(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Math.acos(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.acos(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor atan(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Math.atan(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.atan(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor acot(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.acot(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.acot(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor asec(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.asec(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.asec(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor acsc(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.acsc(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.acsc(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor aexsec(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.aexsec(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.aexsec(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor avers(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.avers(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.avers(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor acovers(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.acovers(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.acovers(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor ahav(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.ahav(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.ahav(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor asinh(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.asinh(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.asinh(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor acosh(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.acosh(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.acosh(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor asech(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.asech(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.asech(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public Phasor acsch(Phasor phasor) {
        Phasor phasor2 = new Phasor();
        if (phasor.phaseInDeg == 0.0) {
            phasor2.reset(Fmath.acsch(phasor.magnitude), 0.0);
        } else {
            Complex complex = phasor.toRectangular();
            complex = Complex.acsch(complex);
            phasor2 = Phasor.toPhasor(complex);
        }
        return phasor2;
    }

    public boolean isReal() {
        boolean bl = false;
        if (Math.abs(this.phaseInDeg) == 0.0) {
            bl = true;
        }
        return bl;
    }

    public boolean isZero() {
        boolean bl = false;
        if (Math.abs(this.magnitude) == 0.0 || this.phaseInDeg == Double.NEGATIVE_INFINITY) {
            bl = true;
        }
        return bl;
    }

    public boolean isPlusInfinity() {
        boolean bl = false;
        if (this.magnitude == Double.POSITIVE_INFINITY || this.phaseInDeg == Double.POSITIVE_INFINITY) {
            bl = true;
        }
        return bl;
    }

    public boolean isMinusInfinity() {
        boolean bl = false;
        if (this.magnitude == Double.NEGATIVE_INFINITY) {
            bl = true;
        }
        return bl;
    }

    public boolean isNaN() {
        boolean bl = false;
        if (this.magnitude != this.magnitude || this.phaseInDeg != this.phaseInDeg) {
            bl = true;
        }
        return bl;
    }

    public boolean equals(Phasor phasor) {
        boolean bl = false;
        if (this.isNaN() && phasor.isNaN()) {
            bl = true;
        } else if (this.magnitude == phasor.magnitude && this.phaseInDeg == phasor.phaseInDeg) {
            bl = true;
        }
        return bl;
    }

    public boolean equalsWithinLimits(Phasor phasor, double d) {
        boolean bl = false;
        double d2 = this.magnitude;
        double d3 = phasor.magnitude;
        double d4 = this.phaseInDeg;
        double d5 = phasor.phaseInDeg;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        if (d2 == 0.0 && d4 == 0.0 && d3 == 0.0 && d5 == 0.0) {
            bl = true;
        }
        if (!bl) {
            d6 = Math.abs(d2);
            if (Math.abs(d3) > d6) {
                d6 = Math.abs(d3);
            }
            d8 = d6 == 0.0 ? 0.0 : Math.abs(d3 - d2) / d6;
            d7 = Math.abs(d4);
            if (Math.abs(d5) > d7) {
                d7 = Math.abs(d5);
            }
            d9 = d7 == 0.0 ? 0.0 : Math.abs(d5 - d4) / d7;
            if (d8 < d && d9 < d) {
                bl = true;
            }
        }
        return bl;
    }

    public static Phasor zero() {
        Phasor phasor = new Phasor();
        phasor.magnitude = 0.0;
        phasor.phaseInDeg = 0.0;
        phasor.phaseInRad = 0.0;
        phasor.rectangular.polar(phasor.magnitude, phasor.phaseInRad);
        return phasor;
    }

    public static Phasor plusOne() {
        Phasor phasor = new Phasor();
        phasor.magnitude = 1.0;
        phasor.phaseInDeg = 0.0;
        phasor.phaseInRad = 0.0;
        phasor.rectangular.polar(phasor.magnitude, phasor.phaseInRad);
        return phasor;
    }

    public static Phasor minusOne() {
        Phasor phasor = new Phasor();
        phasor.magnitude = -1.0;
        phasor.phaseInDeg = 0.0;
        phasor.phaseInRad = 0.0;
        phasor.rectangular.polar(phasor.magnitude, phasor.phaseInRad);
        return phasor;
    }

    public static Phasor magnitudeZeroPhase(double d) {
        Phasor phasor = new Phasor();
        phasor.magnitude = d;
        phasor.phaseInDeg = 0.0;
        phasor.phaseInRad = 0.0;
        phasor.rectangular.polar(phasor.magnitude, phasor.phaseInRad);
        return phasor;
    }

    public static Phasor plusInfinity() {
        Phasor phasor = new Phasor();
        phasor.magnitude = Double.POSITIVE_INFINITY;
        phasor.phaseInDeg = 0.0;
        phasor.phaseInRad = 0.0;
        phasor.rectangular = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        return phasor;
    }

    public static Phasor minusInfinity() {
        Phasor phasor = new Phasor();
        phasor.magnitude = Double.NEGATIVE_INFINITY;
        phasor.phaseInDeg = 0.0;
        phasor.phaseInRad = 0.0;
        phasor.rectangular = new Complex(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        return phasor;
    }

    public static Phasor resistancePhasor(double d) {
        Phasor phasor = new Phasor(d);
        return phasor;
    }

    public static Phasor inductancePhasor(double d, double d2) {
        if (!Fmath.isNaN(frequency)) {
            throw new IllegalArgumentException("You have already entered a value for the frequency, " + frequency + ", that differs from the one you are now attempting to enter, " + d2);
        }
        frequency = d2;
        omega = frequency * 2.0 * Math.PI;
        Complex complex = Impedance.inductanceImpedance(d, omega);
        Phasor phasor = new Phasor();
        return Phasor.toPhasor(complex);
    }

    public static Phasor capacitancePhasor(double d, double d2) {
        if (!Fmath.isNaN(frequency)) {
            throw new IllegalArgumentException("You have already entered a value for the frequency, " + frequency + ", that differs from the one you are now attempting to enter, " + d2);
        }
        frequency = d2;
        omega = frequency * 2.0 * Math.PI;
        Complex complex = Impedance.capacitanceImpedance(d, omega);
        Phasor phasor = new Phasor();
        return Phasor.toPhasor(complex);
    }

    public static Phasor infiniteWarburgPhasor(double d, double d2) {
        if (!Fmath.isNaN(frequency)) {
            throw new IllegalArgumentException("You have already entered a value for the frequency, " + frequency + ", that differs from the one you are now attempting to enter, " + d2);
        }
        frequency = d2;
        omega = frequency * 2.0 * Math.PI;
        Complex complex = Impedance.infiniteWarburgImpedance(d, omega);
        Phasor phasor = new Phasor();
        return Phasor.toPhasor(complex);
    }

    public static Phasor finiteWarburgPhasor(double d, double d2, double d3) {
        if (!Fmath.isNaN(frequency)) {
            throw new IllegalArgumentException("You have already entered a value for the frequency, " + frequency + ", that differs from the one you are now attempting to enter, " + d3);
        }
        frequency = d3;
        omega = frequency * 2.0 * Math.PI;
        Complex complex = Impedance.finiteWarburgImpedance(d, d2, omega);
        Phasor phasor = new Phasor();
        return Phasor.toPhasor(complex);
    }

    public static Phasor constantPhaseElementPhasor(double d, double d2, double d3) {
        if (!Fmath.isNaN(frequency)) {
            throw new IllegalArgumentException("You have already entered a value for the frequency, " + frequency + ", that differs from the one you are now attempting to enter, " + d3);
        }
        frequency = d3;
        omega = frequency * 2.0 * Math.PI;
        Complex complex = Impedance.constantPhaseElementImpedance(d, d2, omega);
        Phasor phasor = new Phasor();
        return Phasor.toPhasor(complex);
    }
}

