/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.complex.Complex;
import flanagan.math.Fmath;

public class Impedance {
    protected static int numberOfModels = 44;

    public static Complex resistanceImpedance(double d) {
        return new Complex(d, 0.0);
    }

    public static Complex capacitanceImpedance(double d, double d2) {
        return new Complex(0.0, -1.0 / (d * d2));
    }

    public static Complex inductanceImpedance(double d, double d2) {
        return new Complex(0.0, d * d2);
    }

    public static Complex infiniteWarburgImpedance(double d, double d2) {
        double d3 = d / Math.sqrt(d2);
        return new Complex(d3, -d3);
    }

    public static Complex finiteWarburgImpedance(double d, double d2, double d3) {
        Complex complex = new Complex(d * Math.sqrt(d3), 0.0);
        Complex complex2 = new Complex(d2, 0.0);
        Complex complex3 = new Complex(0.0, d3);
        Complex complex4 = Complex.sqrt(complex3);
        Complex complex5 = complex2.times(complex4);
        Complex complex6 = Complex.tanh(complex5);
        Complex complex7 = complex.times(complex6);
        Complex complex8 = Complex.plusOne().minus(Complex.plusJay());
        return complex8.times(complex7);
    }

    public static Complex constantPhaseElementImpedance(double d, double d2, double d3) {
        Complex complex = new Complex(0.0, d3);
        Complex complex2 = Complex.pow(complex, -d2);
        Complex complex3 = new Complex(d, 0.0);
        return complex3.times(complex2);
    }

    public static Complex impedanceInSeries(Complex complex, Complex complex2) {
        return complex.plus(complex2);
    }

    public static Complex impedanceInSeries(double d, Complex complex) {
        return complex.plus(d);
    }

    public static Complex impedanceInSeries(Complex complex, double d) {
        return complex.plus(d);
    }

    public static Complex impedanceInSeries(double d, double d2) {
        return new Complex(d + d2, 0.0);
    }

    public static Complex rInSeriesWithC(double d, double d2, double d3) {
        Complex complex = new Complex(d, -1.0 / (d2 * d3));
        return complex;
    }

    public static Complex rInSeriesWithL(double d, double d2, double d3) {
        Complex complex = new Complex(d, d2 * d3);
        return complex;
    }

    public static Complex cInSeriesWithL(double d, double d2, double d3) {
        Complex complex = new Complex(0.0, -1.0 / (d * d3));
        Complex complex2 = new Complex(0.0, d2 * d3);
        return complex.plus(complex2);
    }

    public static Complex impedanceInParallel(Complex complex, Complex complex2) {
        Complex complex3 = complex.times(complex2);
        return complex3.over(complex.plus(complex2));
    }

    public static Complex impedanceInParallel(Complex complex, double d) {
        Complex complex2 = complex.times(d);
        return complex2.over(complex.plus(d));
    }

    public static Complex impedanceInParallel(double d, Complex complex) {
        Complex complex2 = complex.times(d);
        return complex2.over(complex.plus(d));
    }

    public static Complex impedanceInParallel(double d, double d2) {
        return new Complex(d * d2 / (d + d2), 0.0);
    }

    public static Complex rInParallelWithC(double d, double d2, double d3) {
        Complex complex = new Complex(0.0, -1.0 / (d2 * d3));
        Complex complex2 = new Complex(d, 0.0);
        Complex complex3 = complex.times(complex2);
        return complex3.over(complex.plus(complex2));
    }

    public static Complex rInParallelWithL(double d, double d2, double d3) {
        Complex complex = new Complex(0.0, d2 * d3);
        Complex complex2 = new Complex(d, 0.0);
        Complex complex3 = complex.times(complex2);
        return complex3.over(complex.plus(complex2));
    }

    public static Complex cInParallelWithL(double d, double d2, double d3) {
        Complex complex = new Complex(0.0, -1.0 / (d * d3));
        Complex complex2 = new Complex(0.0, d2 * d3);
        Complex complex3 = complex.plus(complex2);
        Complex complex4 = complex.times(complex2);
        return complex4.over(complex3);
    }

    public static String[] modelComponents(int n) {
        String[][] stringArrayArray = new String[][]{{" "}, {"R1"}, {"C1"}, {"L1"}, {"W1"}, {"Fsigma1", "Fdelta1"}, {"Qsigma1", "Qalpha1"}, {"R1", "C1"}, {"R1", "L1"}, {"L1", "C1"}, {"R1", "C1"}, {"R1", "L1"}, {"L1", "C1"}, {"R1", "C1", "R2"}, {"R1", "C1", "R2", "L1"}, {"R1", "C1", "R2", "L1"}, {"R1", "C1", "C2"}, {"R1", "C1", "C2"}, {"R1", "C1", "R2", "C2"}, {"R1", "C1", "R2", "C2"}, {"R1", "C1", "R2", "C2", "R3"}, {"R1", "C1", "R2", "C2", "R3"}, {"R1", "C1", "R2", "C2", "R3", "C3"}, {"R1", "C1", "R2", "C2", "R3", "C3", "R4"}, {"R1", "C1", "W1", "R2"}, {"R1", "C1", "Fsigma1", "Fdelta1", "R2"}, {"R1", "C1", "Qsigma1", "Qalpha1", "R2"}, {"R1", "C1", "R2", "C2", "W1"}, {"R1", "C1", "R2", "C2", "W3", "C3", "R4"}, {"R1", "C1", "R2", "Qsigma1", "Qalpha1"}, {"R1", "C1", "R2", "Qsigma1", "Qalpha1", "R3"}, {"R1", "Qsigma1", "Qalpha1", "R2", "Qsigma2", "Qalpha2", "R3", "Qsigma3", "Qalpha3"}, {"R1", "Qsigma1", "Qalpha1", "R2", "Qsigma2", "Qalpha2", "R3", "Qsigma3", "Qalpha3", "R4"}, {"R1", "Qsigma1", "Qalpha1", "R2", "Qsigma2", "Qalpha2", "R3", "Qsigma3", "Qalpha3", "R4", "C1"}, {"C1", "Qsigma1", "Qalpha1", "C2", "Qsigma2", "Qalpha2", "C3", "Qsigma3", "Qalpha3"}, {"C1", "Qsigma1", "Qalpha1", "C2", "Qsigma2", "Qalpha2", "C3", "Qsigma3", "Qalpha3", "R1"}, {"R1", "Qsigma1", "Qalpha1", "C1", "R2", "Qsigma2", "Qalpha2", "C2", "R3", "Qsigma3", "Qalpha3", "C3"}, {"R1", "Qsigma1", "Qalpha1", "C1", "R2", "Qsigma2", "Qalpha2", "C2", "R3", "Qsigma3", "Qalpha3", "C3", "R4"}, {"R1", "Qsigma1", "Qalpha1", "C1", "R2", "Qsigma2", "Qalpha2", "C2"}, {"R1", "Qsigma1", "Qalpha1", "C1", "R2", "Qsigma2", "Qalpha2", "C2", "R3"}, {"R1", "Qsigma1", "Qalpha1", "R2", "Qsigma2", "Qalpha2", "R3", "Qsigma3", "Qalpha3", "R4", "C1"}, {"R1", "Qsigma1", "Qalpha1", "R2", "C2", "R3", "Qsigma3", "Qalpha3", "R4", "C1"}, {"R1", "Qsigma1", "Qalpha1", "R2", "C2", "R3", "Qsigma3", "Qalpha3", "R4"}, {"R1", "Qsigma1", "Qalpha1", "R2", "Qsigma2", "Qalpha2", "R3", "Qsigma3", "Qalpha3", "R4", "C1"}, {"R1", "Qsigma1", "Qalpha1", "R2", "Qsigma2", "Qalpha2", "R3", "C1"}};
        return stringArrayArray[n];
    }

    public static Complex modelImpedance(double[] dArray, double d, int n) {
        Complex complex = null;
        Complex complex2 = null;
        Complex complex3 = null;
        Complex complex4 = null;
        Complex complex5 = null;
        switch (n) {
            case 1: {
                complex = Impedance.resistanceImpedance(dArray[0]);
                break;
            }
            case 2: {
                complex = Impedance.capacitanceImpedance(dArray[0], d);
                break;
            }
            case 3: {
                complex = Impedance.inductanceImpedance(dArray[0], d);
                break;
            }
            case 4: {
                complex = Impedance.infiniteWarburgImpedance(dArray[0], d);
                break;
            }
            case 5: {
                complex = Impedance.finiteWarburgImpedance(dArray[0], dArray[1], d);
                break;
            }
            case 6: {
                complex = Impedance.constantPhaseElementImpedance(dArray[0], dArray[1], d);
                break;
            }
            case 7: {
                complex = Impedance.rInSeriesWithC(dArray[0], dArray[1], d);
                break;
            }
            case 8: {
                complex = new Complex(dArray[0], dArray[1] * d);
                break;
            }
            case 9: {
                complex2 = new Complex(0.0, -1.0 / (dArray[0] * d));
                complex3 = new Complex(0.0, dArray[1] * d);
                complex = Impedance.impedanceInSeries(complex2, complex3);
                break;
            }
            case 10: {
                complex = Impedance.rInParallelWithC(dArray[0], dArray[1], d);
                break;
            }
            case 11: {
                complex2 = new Complex(dArray[0], 0.0);
                complex3 = new Complex(0.0, dArray[1] * d);
                complex = Impedance.impedanceInParallel(complex2, complex3);
                break;
            }
            case 12: {
                complex2 = new Complex(0.0, -1.0 / (dArray[0] * d));
                complex3 = new Complex(0.0, dArray[1] * d);
                complex = Impedance.impedanceInParallel(complex2, complex3);
                break;
            }
            case 13: {
                complex = Impedance.rInParallelWithC(dArray[0], dArray[1], d);
                complex = complex.plus(dArray[2]);
                break;
            }
            case 14: {
                complex = Impedance.rInParallelWithC(dArray[0], dArray[1], d);
                complex = complex.plus(dArray[2]);
                complex2 = new Complex(0.0, dArray[3] * d);
                complex = complex.plus(complex2);
                break;
            }
            case 15: {
                complex = Impedance.rInParallelWithC(dArray[0], dArray[1], d);
                complex = complex.plus(dArray[2]);
                complex2 = new Complex(0.0, dArray[3] * d);
                complex = Impedance.impedanceInParallel(complex, complex2);
                break;
            }
            case 16: {
                complex = Impedance.rInParallelWithC(dArray[0], dArray[1], d);
                complex3 = new Complex(0.0, -1.0 / (dArray[2] * d));
                complex = complex.plus(complex3);
                break;
            }
            case 17: {
                complex2 = new Complex(dArray[0], -1.0 / (dArray[1] * d));
                complex3 = new Complex(0.0, -1.0 / (dArray[2] * d));
                complex = complex2.times(complex3).over(complex3.plus(complex2));
                break;
            }
            case 18: {
                complex2 = Impedance.rInParallelWithC(dArray[0], dArray[1], d);
                complex3 = new Complex(dArray[2], -1.0 / (dArray[3] * d));
                complex = complex2.plus(complex3);
                break;
            }
            case 19: {
                complex2 = Impedance.rInParallelWithC(dArray[0], dArray[1], d);
                complex3 = Impedance.rInParallelWithC(dArray[2], dArray[3], d);
                complex = complex2.plus(complex3);
                break;
            }
            case 20: {
                complex2 = Impedance.rInParallelWithC(dArray[0], dArray[1], d);
                complex3 = Impedance.rInParallelWithC(dArray[2], dArray[3], d);
                complex = complex2.plus(complex3);
                complex = complex.plus(dArray[4]);
                break;
            }
            case 21: {
                complex2 = Impedance.rInParallelWithC(dArray[0], dArray[1], d);
                complex3 = complex2.plus(dArray[2]);
                complex4 = new Complex(0.0, -1.0 / (dArray[3] * d));
                complex5 = Impedance.impedanceInParallel(complex3, complex4);
                complex = complex5.plus(dArray[4]);
                break;
            }
            case 22: {
                complex2 = Impedance.rInParallelWithC(dArray[0], dArray[1], d);
                complex3 = Impedance.rInParallelWithC(dArray[2], dArray[3], d);
                complex = complex2.plus(complex3);
                complex4 = Impedance.rInParallelWithC(dArray[4], dArray[5], d);
                complex = complex.plus(complex4);
                break;
            }
            case 23: {
                complex2 = Impedance.rInParallelWithC(dArray[0], dArray[1], d);
                complex3 = Impedance.rInParallelWithC(dArray[2], dArray[3], d);
                complex = complex2.plus(complex3);
                complex4 = Impedance.rInParallelWithC(dArray[4], dArray[5], d);
                complex = complex.plus(complex4);
                complex = complex.plus(dArray[6]);
                break;
            }
            case 24: {
                complex2 = Impedance.infiniteWarburgImpedance(dArray[2], d);
                complex3 = Impedance.impedanceInSeries(dArray[0], complex2);
                complex4 = Impedance.capacitanceImpedance(dArray[1], d);
                complex5 = Impedance.impedanceInParallel(complex3, complex4);
                complex = Impedance.impedanceInSeries(complex5, dArray[3]);
                break;
            }
            case 25: {
                complex2 = Impedance.finiteWarburgImpedance(dArray[2], dArray[3], d);
                complex3 = Impedance.impedanceInSeries(dArray[0], complex2);
                complex4 = Impedance.capacitanceImpedance(dArray[1], d);
                complex5 = Impedance.impedanceInParallel(complex3, complex4);
                complex = Impedance.impedanceInSeries(complex5, dArray[4]);
                break;
            }
            case 26: {
                complex2 = Impedance.constantPhaseElementImpedance(dArray[2], dArray[3], d);
                complex3 = Impedance.impedanceInSeries(dArray[0], complex2);
                complex4 = Impedance.capacitanceImpedance(dArray[1], d);
                complex5 = Impedance.impedanceInParallel(complex3, complex4);
                complex = Impedance.impedanceInSeries(complex5, dArray[4]);
                break;
            }
            case 27: {
                complex2 = Impedance.rInParallelWithC(dArray[0], dArray[1], d);
                complex3 = Impedance.rInParallelWithC(dArray[2], dArray[3], d);
                complex = complex2.plus(complex3);
                complex4 = Impedance.infiniteWarburgImpedance(dArray[4], d);
                complex = complex.plus(complex4);
                break;
            }
            case 28: {
                complex2 = Impedance.rInParallelWithC(dArray[0], dArray[1], d);
                complex3 = Impedance.rInParallelWithC(dArray[2], dArray[3], d);
                complex = complex2.plus(complex3);
                complex4 = Impedance.infiniteWarburgImpedance(dArray[4], d);
                complex5 = new Complex(0.0, -1.0 / (dArray[5] * d));
                complex5 = Impedance.impedanceInParallel(complex4, complex5);
                complex = complex.plus(complex5);
                complex = complex.plus(dArray[6]);
                break;
            }
            case 29: {
                complex2 = Impedance.rInParallelWithC(dArray[0], dArray[1], d);
                complex3 = Impedance.constantPhaseElementImpedance(dArray[3], dArray[4], d);
                complex4 = Impedance.impedanceInParallel(complex3, dArray[2]);
                complex = complex2.plus(complex4);
                break;
            }
            case 30: {
                complex2 = Impedance.rInParallelWithC(dArray[0], dArray[1], d);
                complex3 = Impedance.constantPhaseElementImpedance(dArray[3], dArray[4], d);
                complex4 = Impedance.impedanceInParallel(complex3, dArray[2]);
                complex = complex2.plus(complex4);
                complex = complex.plus(dArray[5]);
                break;
            }
            case 31: {
                complex2 = Impedance.constantPhaseElementImpedance(dArray[1], dArray[2], d);
                complex = Impedance.impedanceInParallel(complex2, dArray[0]);
                complex2 = Impedance.constantPhaseElementImpedance(dArray[4], dArray[5], d);
                complex3 = Impedance.impedanceInParallel(complex2, dArray[3]);
                complex = complex.plus(complex3);
                complex2 = Impedance.constantPhaseElementImpedance(dArray[7], dArray[8], d);
                complex3 = Impedance.impedanceInParallel(complex2, dArray[6]);
                complex = complex.plus(complex3);
                break;
            }
            case 32: {
                complex2 = Impedance.constantPhaseElementImpedance(dArray[1], dArray[2], d);
                complex = Impedance.impedanceInParallel(complex2, dArray[0]);
                complex2 = Impedance.constantPhaseElementImpedance(dArray[4], dArray[5], d);
                complex3 = Impedance.impedanceInParallel(complex2, dArray[3]);
                complex = complex.plus(complex3);
                complex2 = Impedance.constantPhaseElementImpedance(dArray[7], dArray[8], d);
                complex3 = Impedance.impedanceInParallel(complex2, dArray[6]);
                complex = complex.plus(complex3);
                complex = complex.plus(dArray[9]);
                break;
            }
            case 33: {
                complex2 = Impedance.constantPhaseElementImpedance(dArray[1], dArray[2], d);
                complex = Impedance.impedanceInParallel(complex2, dArray[0]);
                complex2 = Impedance.constantPhaseElementImpedance(dArray[4], dArray[5], d);
                complex3 = Impedance.impedanceInParallel(complex2, dArray[3]);
                complex = complex.plus(complex3);
                complex2 = Impedance.constantPhaseElementImpedance(dArray[7], dArray[8], d);
                complex3 = Impedance.impedanceInParallel(complex2, dArray[6]);
                complex = complex.plus(complex3);
                complex = complex.plus(dArray[9]);
                complex4 = new Complex(0.0, -1.0 / (dArray[10] * d));
                complex = Impedance.impedanceInParallel(complex, complex4);
                break;
            }
            case 34: {
                complex2 = new Complex(0.0, -1.0 / (dArray[0] * d));
                complex3 = Impedance.constantPhaseElementImpedance(dArray[1], dArray[2], d);
                complex = Impedance.impedanceInParallel(complex2, complex3);
                complex2 = new Complex(0.0, -1.0 / (dArray[3] * d));
                complex3 = Impedance.constantPhaseElementImpedance(dArray[4], dArray[5], d);
                complex4 = Impedance.impedanceInParallel(complex2, complex3);
                complex = complex.plus(complex4);
                complex2 = new Complex(0.0, -1.0 / (dArray[6] * d));
                complex3 = Impedance.constantPhaseElementImpedance(dArray[7], dArray[8], d);
                complex4 = Impedance.impedanceInParallel(complex2, complex3);
                complex = complex.plus(complex4);
                break;
            }
            case 35: {
                complex2 = new Complex(0.0, -1.0 / (dArray[0] * d));
                complex3 = Impedance.constantPhaseElementImpedance(dArray[1], dArray[2], d);
                complex = Impedance.impedanceInParallel(complex2, complex3);
                complex2 = new Complex(0.0, -1.0 / (dArray[3] * d));
                complex3 = Impedance.constantPhaseElementImpedance(dArray[4], dArray[5], d);
                complex4 = Impedance.impedanceInParallel(complex2, complex3);
                complex = complex.plus(complex4);
                complex2 = new Complex(0.0, -1.0 / (dArray[6] * d));
                complex3 = Impedance.constantPhaseElementImpedance(dArray[7], dArray[8], d);
                complex4 = Impedance.impedanceInParallel(complex2, complex3);
                complex = complex.plus(complex4);
                complex = complex.plus(dArray[9]);
                break;
            }
            case 36: {
                complex2 = Impedance.constantPhaseElementImpedance(dArray[1], dArray[2], d);
                complex3 = complex2.plus(dArray[0]);
                complex4 = new Complex(0.0, -1.0 / (dArray[3] * d));
                complex = Impedance.impedanceInParallel(complex3, complex4);
                complex2 = Impedance.constantPhaseElementImpedance(dArray[5], dArray[6], d);
                complex3 = complex2.plus(dArray[4]);
                complex4 = new Complex(0.0, -1.0 / (dArray[7] * d));
                complex5 = Impedance.impedanceInParallel(complex3, complex4);
                complex = complex.plus(complex5);
                complex2 = Impedance.constantPhaseElementImpedance(dArray[9], dArray[10], d);
                complex3 = complex2.plus(dArray[8]);
                complex4 = new Complex(0.0, -1.0 / (dArray[11] * d));
                complex5 = Impedance.impedanceInParallel(complex3, complex4);
                complex = complex.plus(complex5);
                break;
            }
            case 37: {
                complex2 = Impedance.constantPhaseElementImpedance(dArray[1], dArray[2], d);
                complex3 = complex2.plus(dArray[0]);
                complex4 = new Complex(0.0, -1.0 / (dArray[3] * d));
                complex = Impedance.impedanceInParallel(complex3, complex4);
                complex2 = Impedance.constantPhaseElementImpedance(dArray[5], dArray[6], d);
                complex3 = complex2.plus(dArray[4]);
                complex4 = new Complex(0.0, -1.0 / (dArray[7] * d));
                complex5 = Impedance.impedanceInParallel(complex3, complex4);
                complex = complex.plus(complex5);
                complex2 = Impedance.constantPhaseElementImpedance(dArray[9], dArray[10], d);
                complex3 = complex2.plus(dArray[8]);
                complex4 = new Complex(0.0, -1.0 / (dArray[11] * d));
                complex5 = Impedance.impedanceInParallel(complex3, complex4);
                complex = complex.plus(complex5);
                complex = complex.plus(dArray[12]);
                break;
            }
            case 38: {
                complex2 = Impedance.constantPhaseElementImpedance(dArray[1], dArray[2], d);
                complex3 = complex2.plus(dArray[0]);
                complex4 = new Complex(0.0, -1.0 / (dArray[3] * d));
                complex = Impedance.impedanceInParallel(complex3, complex4);
                complex2 = Impedance.constantPhaseElementImpedance(dArray[5], dArray[6], d);
                complex3 = complex2.plus(dArray[4]);
                complex4 = new Complex(0.0, -1.0 / (dArray[7] * d));
                complex5 = Impedance.impedanceInParallel(complex3, complex4);
                complex = complex.plus(complex5);
                break;
            }
            case 39: {
                complex2 = Impedance.constantPhaseElementImpedance(dArray[1], dArray[2], d);
                complex3 = complex2.plus(dArray[0]);
                complex4 = new Complex(0.0, -1.0 / (dArray[3] * d));
                complex = Impedance.impedanceInParallel(complex3, complex4);
                complex2 = Impedance.constantPhaseElementImpedance(dArray[5], dArray[6], d);
                complex3 = complex2.plus(dArray[4]);
                complex4 = new Complex(0.0, -1.0 / (dArray[7] * d));
                complex5 = Impedance.impedanceInParallel(complex3, complex4);
                complex = complex.plus(complex5);
                complex = complex5.plus(dArray[8]);
                break;
            }
            case 40: {
                complex2 = Impedance.constantPhaseElementImpedance(dArray[1], dArray[2], d);
                complex = Impedance.impedanceInParallel(complex2, dArray[0]);
                complex2 = Impedance.constantPhaseElementImpedance(dArray[4], dArray[5], d);
                complex3 = Impedance.impedanceInParallel(complex2, dArray[3]);
                complex = complex.plus(complex3);
                complex2 = Impedance.constantPhaseElementImpedance(dArray[7], dArray[8], d);
                complex3 = Impedance.impedanceInParallel(complex2, dArray[6]);
                complex = complex.plus(complex3);
                complex4 = new Complex(0.0, -1.0 / (dArray[10] * d));
                complex = Impedance.impedanceInParallel(complex, complex4);
                complex = complex.plus(dArray[9]);
                break;
            }
            case 41: {
                complex2 = Impedance.constantPhaseElementImpedance(dArray[1], dArray[2], d);
                complex = Impedance.impedanceInParallel(complex2, dArray[0]);
                complex2 = new Complex(0.0, -1.0 / (dArray[4] * d));
                complex3 = Impedance.impedanceInParallel(complex2, dArray[3]);
                complex = complex.plus(complex3);
                complex2 = Impedance.constantPhaseElementImpedance(dArray[6], dArray[7], d);
                complex3 = Impedance.impedanceInParallel(complex2, dArray[5]);
                complex = complex.plus(complex3);
                complex4 = new Complex(0.0, -1.0 / (dArray[9] * d));
                complex = Impedance.impedanceInParallel(complex, complex4);
                complex = complex.plus(dArray[8]);
                break;
            }
            case 42: {
                complex2 = Impedance.constantPhaseElementImpedance(dArray[1], dArray[2], d);
                complex = Impedance.impedanceInParallel(complex2, dArray[0]);
                complex2 = new Complex(0.0, -1.0 / (dArray[4] * d));
                complex3 = Impedance.impedanceInParallel(complex2, dArray[3]);
                complex = complex.plus(complex3);
                complex2 = Impedance.constantPhaseElementImpedance(dArray[6], dArray[7], d);
                complex3 = Impedance.impedanceInParallel(complex2, dArray[5]);
                complex = complex.plus(complex3);
                complex = complex.plus(dArray[8]);
                break;
            }
            case 43: {
                complex2 = Impedance.constantPhaseElementImpedance(dArray[1], dArray[2], d);
                complex = Impedance.impedanceInParallel(complex2, dArray[0]);
                complex2 = Impedance.constantPhaseElementImpedance(dArray[4], dArray[5], d);
                complex3 = Impedance.impedanceInParallel(complex2, dArray[3]);
                complex = complex.plus(complex3);
                complex2 = Impedance.constantPhaseElementImpedance(dArray[7], dArray[8], d);
                complex3 = Impedance.impedanceInParallel(complex2, dArray[6]);
                complex = complex.plus(complex3);
                complex = complex.plus(dArray[9]);
                complex4 = new Complex(0.0, -1.0 / (dArray[10] * d));
                complex = Impedance.impedanceInParallel(complex, complex4);
                break;
            }
            case 44: {
                complex2 = Impedance.constantPhaseElementImpedance(dArray[1], dArray[2], d);
                complex = Impedance.impedanceInParallel(complex2, dArray[0]);
                complex2 = Impedance.constantPhaseElementImpedance(dArray[4], dArray[5], d);
                complex3 = Impedance.impedanceInParallel(complex2, dArray[3]);
                complex = complex.plus(complex3);
                complex = complex.plus(dArray[6]);
                complex4 = new Complex(0.0, -1.0 / (dArray[7] * d));
                complex = Impedance.impedanceInParallel(complex, complex4);
                break;
            }
            default: {
                throw new IllegalArgumentException("No model " + n + " exists");
            }
        }
        return complex;
    }

    public static double warburgSigma(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        double d7 = 8.31447215 * (d6 - -273.15) / (Fmath.square((double)n * 96485.341539) * d * Math.sqrt(2.0));
        double d8 = 1.0 / (d3 * Math.sqrt(d2));
        double d9 = 1.0 / (d5 * Math.sqrt(d4));
        return d7 * (d8 + d9);
    }

    public static double parallelPlateCapacitance(double d, double d2, double d3) {
        return d * d3 * 8.854187817E-12 / d2;
    }

    public static double parallelPlateCapacitance(double d, double d2, double d3, double d4) {
        return d * d2 * d4 * 8.854187817E-12 / d3;
    }

    public static double coaxialCapacitance(double d, double d2, double d3, double d4) {
        return Math.PI * 2 * d4 * 8.854187817E-12 * d / Math.log(d3 / d2);
    }

    public static double parallelWiresCapacitance(double d, double d2, double d3, double d4) {
        return Math.PI * d4 * 8.854187817E-12 * d / Math.log((d3 - d2) / d2);
    }

    public static double parallelPlateInductance(double d, double d2, double d3, double d4) {
        return d4 * 1.2566370614359173E-6 * d3 * d / d2;
    }

    public static double coaxialInductance(double d, double d2, double d3, double d4) {
        return d4 * 1.2566370614359173E-6 * d * Math.log(d3 / d2) / (Math.PI * 2);
    }

    public static double parallelWiresInductance(double d, double d2, double d3, double d4) {
        return d4 * 1.2566370614359173E-6 * d * Math.log((d3 - d2) / d2) / Math.PI;
    }

    public static double getMagnitude(Complex complex) {
        return complex.abs();
    }

    public static double getPhaseRad(Complex complex) {
        return complex.argRad();
    }

    public static double getPhaseDeg(Complex complex) {
        return complex.argDeg();
    }

    public static Complex polarRad(double d, double d2) {
        Complex complex = new Complex();
        complex.polarRad(d, d2);
        return complex;
    }

    public static Complex polarDeg(double d, double d2) {
        Complex complex = new Complex();
        complex.polarDeg(d, d2);
        return complex;
    }

    public static double frequencyToRadialFrequency(double d) {
        return Math.PI * 2 * d;
    }

    public static double radialFrequencyToFrequency(double d) {
        return d / (Math.PI * 2);
    }

    public static double resistanceAluminium(double d, double d2, double d3) {
        double d4 = 2.824E-8;
        double d5 = 0.0039;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceAluminum(double d, double d2, double d3) {
        double d4 = 2.824E-8;
        double d5 = 0.0039;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceHardDrawnCopper(double d, double d2, double d3) {
        double d4 = 1.771E-8;
        double d5 = 0.00382;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceAnnealedCopper(double d, double d2, double d3) {
        double d4 = 1.7241E-8;
        double d5 = 0.00393;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceIron(double d, double d2, double d3) {
        double d4 = 1.0E-7;
        double d5 = 0.005;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceManganeseSteel(double d, double d2, double d3) {
        double d4 = 7.0E-7;
        double d5 = 0.001;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceSiemensMartinSteel(double d, double d2, double d3) {
        double d4 = 1.8E-7;
        double d5 = 0.003;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceBBSteel(double d, double d2, double d3) {
        double d4 = 1.19E-7;
        double d5 = 0.004;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceEBBSteel(double d, double d2, double d3) {
        double d4 = 1.04E-7;
        double d5 = 0.005;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceBrass(double d, double d2, double d3) {
        double d4 = 7.4E-8;
        double d5 = 0.002;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceDrawnTunsten(double d, double d2, double d3) {
        double d4 = 5.6E-8;
        double d5 = 0.0045;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceSilver(double d, double d2, double d3) {
        double d4 = 1.59E-8;
        double d5 = 0.0038;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceGold(double d, double d2, double d3) {
        double d4 = 2.84E-8;
        double d5 = 0.0034;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistancePlatinum(double d, double d2, double d3) {
        double d4 = 1.0E-7;
        double d5 = 0.003;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceNickel(double d, double d2, double d3) {
        double d4 = 7.8E-8;
        double d5 = 0.006;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceMolybdenum(double d, double d2, double d3) {
        double d4 = 5.7E-8;
        double d5 = 0.004;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistancePhosphorBronze(double d, double d2, double d3) {
        double d4 = 1.1E-7;
        double d5 = 0.0033;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceTin(double d, double d2, double d3) {
        double d4 = 1.15E-7;
        double d5 = 0.0042;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceNichrome(double d, double d2, double d3) {
        double d4 = 1.0E-6;
        double d5 = 4.0E-4;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistancePalladium(double d, double d2, double d3) {
        double d4 = 1.1E-7;
        double d5 = 0.0033;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceTantalum(double d, double d2, double d3) {
        double d4 = 1.55E-7;
        double d5 = 0.0031;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceTherlo(double d, double d2, double d3) {
        double d4 = 4.7E-7;
        double d5 = 1.0E-5;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceMonelMetal(double d, double d2, double d3) {
        double d4 = 4.2E-7;
        double d5 = 0.002;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceManganan(double d, double d2, double d3) {
        double d4 = 4.4E-7;
        double d5 = 1.0E-5;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceConstantan(double d, double d2, double d3) {
        double d4 = 4.9E-7;
        double d5 = 1.0E-5;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceAntimony(double d, double d2, double d3) {
        double d4 = 4.17E-7;
        double d5 = 0.0036;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceCobalt(double d, double d2, double d3) {
        double d4 = 9.8E-8;
        double d5 = 0.0033;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceMagnesium(double d, double d2, double d3) {
        double d4 = 4.6E-8;
        double d5 = 0.004;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceZinc(double d, double d2, double d3) {
        double d4 = 5.8E-8;
        double d5 = 0.0037;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceMercury(double d, double d2, double d3) {
        double d4 = 9.5738E-7;
        double d5 = 8.9E-4;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceLead(double d, double d2, double d3) {
        double d4 = 2.2E-7;
        double d5 = 0.0039;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistanceGermanSilver(double d, double d2, double d3) {
        double d4 = 3.3E-7;
        double d5 = 4.0E-4;
        double d6 = d4 * d / d2;
        return d6 * (1.0 + d5 * (d3 - 20.0));
    }

    public static double resistivityToResistance(double d, double d2, double d3, double d4, double d5) {
        double d6 = d * d3 / d4;
        return d6 * (1.0 + d2 * (d5 - 20.0));
    }

    public static double resistivityToResistance(double d, double d2, double d3) {
        return d * d2 / d3;
    }

    public static double resistanceToResistivity(double d, double d2, double d3) {
        return d * d3 / d2;
    }
}

