/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.circuits.ImpedSpecModel;
import flanagan.circuits.Impedance;
import flanagan.complex.Complex;
import flanagan.io.Db;
import flanagan.io.FileOutput;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.plot.PlotGraph;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class ImpedSpecSimulation {
    private double lowestFrequency = 0.0;
    private double lowestOmega = 0.0;
    private boolean lowestSet = false;
    private double highestFrequency = 0.0;
    private double highestOmega = 0.0;
    private boolean highestSet = false;
    private boolean logOrLinear = true;
    private double increment = 0.0;
    private double[] frequencies = null;
    private double[] omegas = null;
    private double[] log10frequencies = null;
    private double[] log10omegas = null;
    private int numberOfFrequencies = 800;
    private boolean numberSet = true;
    private boolean frequenciesSet = false;
    private int modelNumber = 0;
    private double[] parameters = null;
    private int numberOfParameters = 0;
    private String[] modelParameterSymbols = null;
    private boolean parametersSet = false;
    private boolean modelSet = false;
    private Complex[] impedances = null;
    private double[] magnitudesZ = null;
    private double[] phasesRadZ = null;
    private double[] phasesDegZ = null;
    private double[] realZ = null;
    private double[] imagZ = null;
    private boolean impedancesSet = false;
    private Complex[] voltages = null;
    private double[] magnitudesV = null;
    private double[] phasesRadV = null;
    private double[] phasesDegV = null;
    private double[] realV = null;
    private double[] imagV = null;
    private ImpedSpecModel userModel = null;
    private String simulationTitle = null;
    private boolean fileType = false;
    private Complex appliedVoltage = null;
    private boolean voltageSet = false;
    private Complex referenceImpedance = null;
    private boolean referenceSet = false;

    public ImpedSpecSimulation() {
        this.simulationTitle = "  ";
    }

    public ImpedSpecSimulation(String string) {
        this.simulationTitle = string;
    }

    public void setScanRangeHz(double d, double d2) {
        this.lowestFrequency = d;
        this.lowestOmega = Math.PI * 2 * d;
        this.highestFrequency = d2;
        this.highestOmega = Math.PI * 2 * d2;
        this.calculateFrequencies();
    }

    public void setScanRangeRadians(double d, double d2) {
        this.lowestFrequency = d / (Math.PI * 2);
        this.lowestOmega = d;
        this.highestFrequency = d2 / (Math.PI * 2);
        this.highestOmega = d2;
        this.calculateFrequencies();
    }

    public void setLowFrequency(double d) {
        this.lowestFrequency = d;
        this.lowestOmega = Math.PI * 2 * d;
        this.lowestSet = true;
        if (this.highestSet && this.numberSet) {
            this.calculateFrequencies();
        }
    }

    public void setLowRadialFrequency(double d) {
        this.lowestOmega = d;
        this.lowestFrequency = d / (Math.PI * 2);
        this.lowestSet = true;
        if (this.highestSet && this.numberSet) {
            this.calculateFrequencies();
        }
    }

    public void setHighFrequency(double d) {
        this.highestFrequency = d;
        this.highestOmega = Math.PI * 2 * d;
        this.highestSet = true;
        if (this.lowestSet && this.numberSet) {
            this.calculateFrequencies();
        }
    }

    public void setHighRadialFrequency(double d) {
        this.highestOmega = d;
        this.highestFrequency = d / (Math.PI * 2);
        this.highestSet = true;
        if (this.lowestSet && this.numberSet) {
            this.calculateFrequencies();
        }
    }

    private void calculateFrequencies() {
        if (this.logOrLinear) {
            int n;
            double d = Fmath.log10(this.lowestFrequency);
            double d2 = Fmath.log10(this.highestFrequency);
            this.increment = (d2 - d) / (double)(this.numberOfFrequencies - 1);
            this.frequencies = new double[this.numberOfFrequencies];
            this.log10frequencies = new double[this.numberOfFrequencies];
            this.omegas = new double[this.numberOfFrequencies];
            this.log10omegas = new double[this.numberOfFrequencies];
            this.log10frequencies[0] = d;
            this.log10frequencies[this.numberOfFrequencies - 1] = d2;
            for (n = 1; n < this.numberOfFrequencies - 1; ++n) {
                this.log10frequencies[n] = this.log10frequencies[n - 1] + this.increment;
            }
            for (n = 0; n < this.numberOfFrequencies; ++n) {
                this.frequencies[n] = Math.pow(10.0, this.log10frequencies[n]);
                this.omegas[n] = this.frequencies[n] * 2.0 * Math.PI;
                this.log10omegas[n] = Fmath.log10(this.omegas[n]);
            }
        } else {
            int n;
            this.increment = (this.highestFrequency - this.lowestFrequency) / (double)(this.numberOfFrequencies - 1);
            this.frequencies = new double[this.numberOfFrequencies];
            this.frequencies[0] = this.lowestFrequency;
            this.log10frequencies = new double[this.numberOfFrequencies];
            this.omegas = new double[this.numberOfFrequencies];
            this.log10omegas = new double[this.numberOfFrequencies];
            this.frequencies[this.numberOfFrequencies - 1] = this.highestFrequency;
            for (n = 1; n < this.numberOfFrequencies - 1; ++n) {
                this.frequencies[n] = this.frequencies[n - 1] + this.increment;
            }
            for (n = 0; n < this.numberOfFrequencies; ++n) {
                this.log10frequencies[n] = Fmath.log10(this.frequencies[n]);
                this.omegas[n] = this.frequencies[n] * 2.0 * Math.PI;
                this.log10omegas[n] = Fmath.log10(this.omegas[n]);
            }
        }
        this.frequenciesSet = true;
    }

    public void setLinearPlot() {
        this.logOrLinear = false;
        if (this.lowestSet && this.highestSet && this.numberSet) {
            this.calculateFrequencies();
        }
    }

    public void setLog10Plot() {
        this.logOrLinear = true;
        if (this.lowestSet && this.highestSet && this.numberSet) {
            this.calculateFrequencies();
        }
    }

    public void setAppliedVoltage(double d) {
        this.appliedVoltage = new Complex(d, 0.0);
        this.voltageSet = true;
    }

    public void setReferenceImpedance(double d) {
        this.referenceImpedance = new Complex(d, 0.0);
        this.referenceSet = true;
    }

    public void setReferenceImpedance(double d, double d2) {
        this.referenceImpedance = new Complex(d, d2);
        this.referenceSet = true;
    }

    public void setReferenceImpedance(Complex complex) {
        this.referenceImpedance = complex;
        this.referenceSet = true;
    }

    public void setModel(int n, double[] dArray) {
        if (n == 0 || n > Impedance.numberOfModels) {
            throw new IllegalArgumentException("The model number, " + n + ", must lie between 1 and " + Impedance.numberOfModels + " inclusive");
        }
        this.modelNumber = n;
        this.parameters = dArray;
        this.modelParameterSymbols = Impedance.modelComponents(n);
        this.numberOfParameters = this.modelParameterSymbols.length;
        if (this.numberOfParameters != this.parameters.length) {
            throw new IllegalArgumentException("The number of model parametes passed, " + dArray.length + ", does not match the number required, " + this.numberOfParameters + ", by model number " + n);
        }
        this.parametersSet = true;
        this.modelSet = true;
    }

    public void setModel(int n, double[] dArray, String[] stringArray) {
        if (n == 0 || n > Impedance.numberOfModels) {
            throw new IllegalArgumentException("The model number, " + n + ", must lie between 1 and " + Impedance.numberOfModels + " inclusive");
        }
        this.modelNumber = n;
        this.parameters = dArray;
        this.modelParameterSymbols = Impedance.modelComponents(n);
        this.numberOfParameters = this.modelParameterSymbols.length;
        if (this.numberOfParameters != this.parameters.length) {
            throw new IllegalArgumentException("The number of model parametes passed, " + dArray.length + ", does not match the numbber required, " + this.numberOfParameters + ", by model number " + n);
        }
        if (this.numberOfParameters != stringArray.length) {
            throw new IllegalArgumentException("The number of model symbols passed, " + stringArray.length + ", does not match the number required, " + this.numberOfParameters + ", by model number " + n);
        }
        this.modelParameterSymbols = stringArray;
        this.parametersSet = true;
        this.modelSet = true;
    }

    public void setModel(int n) {
        if (n == 0 || n > Impedance.numberOfModels) {
            throw new IllegalArgumentException("The model number, " + n + ", must lie between 1 and " + Impedance.numberOfModels + " inclusive");
        }
        this.modelNumber = n;
        this.modelSet = true;
        this.modelParameterSymbols = Impedance.modelComponents(n);
        this.numberOfParameters = this.modelParameterSymbols.length;
        this.parameters = new double[this.numberOfParameters];
        int n2 = 0;
        String string = null;
        while (n2 < this.numberOfParameters) {
            string = this.modelParameterSymbols[n2];
            if (string.trim().charAt(0) == 'R') {
                this.parameters[n2] = Db.readDouble("Enter resistance " + string.trim() + " [ohms]");
                ++n2;
                continue;
            }
            if (string.trim().charAt(0) == 'C') {
                this.parameters[n2] = Db.readDouble("Enter capacitance " + string.trim() + " [farads]");
                ++n2;
                continue;
            }
            if (string.trim().charAt(0) == 'L') {
                this.parameters[n2] = Db.readDouble("Enter inductance " + string.trim() + " [henries]");
                ++n2;
                continue;
            }
            if (string.trim().charAt(0) == 'W') {
                this.parameters[n2] = Db.readDouble("Enter 'infinite' Warburg constant, sigma, " + string.trim() + " [ohms*sqrt(radians)]");
                ++n2;
                continue;
            }
            if (string.trim().charAt(0) == 'F') {
                this.parameters[n2] = Db.readDouble("Enter 'finite' Warburg constant, sigma, " + string.trim() + " [SI units]");
                this.parameters[++n2] = Db.readDouble("Enter 'finite' Warburg power, alpha, " + string.trim());
                ++n2;
                continue;
            }
            if (string.trim().charAt(0) != 'Q') continue;
            this.parameters[n2] = Db.readDouble("Enter CPE constant, sigma, " + string.trim() + " [SI units]");
            this.parameters[++n2] = Db.readDouble("Enter CPE power, alpha, " + string.trim());
            ++n2;
        }
        this.parametersSet = true;
    }

    public void setModel(ImpedSpecModel impedSpecModel, double[] dArray) {
        this.userModel = impedSpecModel;
        this.parameters = dArray;
        this.numberOfParameters = dArray.length;
        this.modelParameterSymbols = new String[this.numberOfParameters];
        for (int i = 0; i < this.numberOfParameters; ++i) {
            this.modelParameterSymbols[i] = "P" + (i + 1);
        }
        this.parametersSet = true;
    }

    public void setModel(ImpedSpecModel impedSpecModel, double[] dArray, String[] stringArray) {
        this.userModel = impedSpecModel;
        this.parameters = dArray;
        this.modelParameterSymbols = stringArray;
        this.numberOfParameters = dArray.length;
        this.parametersSet = true;
    }

    public Complex[] calculateImpedances() {
        int n;
        if (!this.parametersSet) {
            throw new IllegalArgumentException("model parameters values have not been entered");
        }
        if (!this.frequenciesSet) {
            throw new IllegalArgumentException("frequency values have not been entered");
        }
        this.impedances = Complex.oneDarray(this.numberOfFrequencies);
        if (this.modelSet) {
            for (n = 0; n < this.numberOfFrequencies; ++n) {
                this.impedances[n] = Impedance.modelImpedance(this.parameters, this.omegas[n], this.modelNumber);
            }
        } else {
            for (n = 0; n < this.numberOfFrequencies; ++n) {
                this.impedances[n] = this.userModel.modelImpedance(this.parameters, this.omegas[n]);
            }
        }
        this.magnitudesZ = new double[this.numberOfFrequencies];
        this.phasesRadZ = new double[this.numberOfFrequencies];
        this.phasesDegZ = new double[this.numberOfFrequencies];
        this.realZ = new double[this.numberOfFrequencies];
        this.imagZ = new double[this.numberOfFrequencies];
        this.magnitudesV = new double[this.numberOfFrequencies];
        this.phasesRadV = new double[this.numberOfFrequencies];
        this.phasesDegV = new double[this.numberOfFrequencies];
        this.realV = new double[this.numberOfFrequencies];
        this.imagV = new double[this.numberOfFrequencies];
        this.voltages = Complex.oneDarray(this.numberOfFrequencies);
        for (n = 0; n < this.numberOfFrequencies; ++n) {
            this.magnitudesZ[n] = Complex.abs(this.impedances[n]);
            this.phasesRadZ[n] = Complex.arg(this.impedances[n]);
            this.phasesDegZ[n] = Math.toDegrees(this.phasesRadZ[n]);
            this.realZ[n] = this.impedances[n].getReal();
            this.imagZ[n] = this.impedances[n].getImag();
            if (!this.voltageSet || !this.referenceSet) continue;
            this.voltages[n] = this.appliedVoltage.times(this.impedances[n].over(this.impedances[n].plus(this.referenceImpedance)));
            this.magnitudesV[n] = Complex.abs(this.voltages[n]);
            this.phasesRadV[n] = Complex.arg(this.voltages[n]);
            this.phasesDegV[n] = Math.toDegrees(this.phasesRadV[n]);
            this.realV[n] = this.voltages[n].getReal();
            this.imagV[n] = this.voltages[n].getImag();
        }
        this.impedancesSet = true;
        return this.impedances;
    }

    public ArrayList<Object> getSimulationResultsAsArrayList(int n) {
        int n2;
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        if (n > this.numberOfFrequencies) {
            n = this.numberOfFrequencies;
        }
        int n3 = (int)Math.round((double)this.numberOfFrequencies / (double)n);
        int[] nArray = new int[n];
        nArray[0] = 0;
        for (int i = 1; i < n; ++i) {
            nArray[i] = nArray[i - 1] + n3;
        }
        if (nArray[n - 1] != this.numberOfFrequencies - 1) {
            nArray[n - 1] = this.numberOfFrequencies - 1;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Complex[] complexArray = Complex.oneDarray(n);
        for (int i = 0; i < n; ++i) {
            complexArray[i] = this.impedances[nArray[i]];
        }
        arrayList.add(Complex.copy(complexArray));
        double[] dArray = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = this.realZ[nArray[n2]];
        }
        arrayList.add(Conv.copy(dArray));
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = this.imagZ[nArray[n2]];
        }
        arrayList.add(Conv.copy(dArray));
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = this.magnitudesZ[nArray[n2]];
        }
        arrayList.add(Conv.copy(dArray));
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = this.phasesDegZ[nArray[n2]];
        }
        arrayList.add(Conv.copy(dArray));
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = this.phasesRadZ[nArray[n2]];
        }
        arrayList.add(Conv.copy(dArray));
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = this.frequencies[nArray[n2]];
        }
        arrayList.add(Conv.copy(dArray));
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = this.log10frequencies[nArray[n2]];
        }
        arrayList.add(Conv.copy(dArray));
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = this.omegas[nArray[n2]];
        }
        arrayList.add(Conv.copy(dArray));
        if (this.voltageSet && this.referenceSet) {
            arrayList.add(new Double(this.appliedVoltage.getReal()));
            arrayList.add(this.referenceImpedance);
            for (n2 = 0; n2 < n; ++n2) {
                complexArray[n2] = this.voltages[nArray[n2]];
            }
            arrayList.add(Complex.copy(complexArray));
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = this.realV[nArray[n2]];
            }
            arrayList.add(Conv.copy(dArray));
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = this.imagV[nArray[n2]];
            }
            arrayList.add(Conv.copy(dArray));
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = this.magnitudesV[nArray[n2]];
            }
            arrayList.add(Conv.copy(dArray));
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = this.phasesDegV[nArray[n2]];
            }
            arrayList.add(Conv.copy(dArray));
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = this.phasesRadV[nArray[n2]];
            }
            arrayList.add(Conv.copy(dArray));
        } else {
            for (n2 = 0; n2 < 8; ++n2) {
                arrayList.add(null);
            }
        }
        return arrayList;
    }

    public Vector<Object> getSimulationResultsAsVector(int n) {
        int n2;
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        if (n > this.numberOfFrequencies) {
            n = this.numberOfFrequencies;
        }
        int n3 = (int)Math.round((double)this.numberOfFrequencies / (double)n);
        int[] nArray = new int[n];
        nArray[0] = 0;
        for (int i = 1; i < n; ++i) {
            nArray[i] = nArray[i - 1] + n3;
        }
        if (nArray[n - 1] != this.numberOfFrequencies - 1) {
            nArray[n - 1] = this.numberOfFrequencies - 1;
        }
        Vector<Object> vector = new Vector<Object>();
        Complex[] complexArray = Complex.oneDarray(n);
        for (int i = 0; i < n; ++i) {
            complexArray[i] = this.impedances[nArray[i]];
        }
        vector.addElement(Complex.copy(complexArray));
        double[] dArray = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = this.realZ[nArray[n2]];
        }
        vector.addElement(Conv.copy(dArray));
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = this.imagZ[nArray[n2]];
        }
        vector.addElement(Conv.copy(dArray));
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = this.magnitudesZ[nArray[n2]];
        }
        vector.addElement(Conv.copy(dArray));
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = this.phasesDegZ[nArray[n2]];
        }
        vector.addElement(Conv.copy(dArray));
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = this.phasesRadZ[nArray[n2]];
        }
        vector.addElement(Conv.copy(dArray));
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = this.frequencies[nArray[n2]];
        }
        vector.addElement(Conv.copy(dArray));
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = this.log10frequencies[nArray[n2]];
        }
        vector.addElement(Conv.copy(dArray));
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = this.omegas[nArray[n2]];
        }
        vector.addElement(Conv.copy(dArray));
        if (this.voltageSet && this.referenceSet) {
            vector.addElement(new Double(this.appliedVoltage.getReal()));
            vector.addElement(this.referenceImpedance);
            for (n2 = 0; n2 < n; ++n2) {
                complexArray[n2] = this.voltages[nArray[n2]];
            }
            vector.addElement(Complex.copy(complexArray));
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = this.realV[nArray[n2]];
            }
            vector.addElement(Conv.copy(dArray));
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = this.imagV[nArray[n2]];
            }
            vector.addElement(Conv.copy(dArray));
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = this.magnitudesV[nArray[n2]];
            }
            vector.addElement(Conv.copy(dArray));
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = this.phasesDegV[nArray[n2]];
            }
            vector.addElement(Conv.copy(dArray));
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = this.phasesRadV[nArray[n2]];
            }
            vector.addElement(Conv.copy(dArray));
        } else {
            for (n2 = 0; n2 < 8; ++n2) {
                vector.addElement(null);
            }
        }
        return vector;
    }

    public Vector<Object> getSimulationResults(int n) {
        return this.getSimulationResultsAsVector(n);
    }

    public void plotImpedanceMagnitudes() {
        this.plotImpedanceMagnitudeVersusFrequency();
    }

    public void plotImpedanceMagnitudeVersusFrequency() {
        String[] stringArray = this.dateAndTime();
        String string = "ImpedSpecSimulation program:  Impedance Magnitude versus Frequency   [" + stringArray[0] + "    " + stringArray[1] + "]";
        String string2 = this.simulationTitle;
        if (this.logOrLinear) {
            this.impedanceMagnitudeVersusLogFrequencyPlot(string, string2);
        } else {
            this.impedanceMagnitudeVersusFrequencyPlot(string, string2);
        }
    }

    public void plotMagnitudeVersusFrequency() {
        this.plotImpedanceMagnitudeVersusFrequency();
    }

    private void impedanceMagnitudeVersusLogFrequencyPlot(String string, String string2) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        double[][] dArray = new double[2][this.numberOfFrequencies];
        dArray[0] = this.log10frequencies;
        dArray[1] = this.magnitudesZ;
        PlotGraph plotGraph = new PlotGraph(dArray);
        plotGraph.setLine(3);
        plotGraph.setPoint(0);
        plotGraph.setGraphTitle(string);
        plotGraph.setGraphTitle2(string2);
        plotGraph.setXaxisLegend("Log10[Frequency / Hz]");
        plotGraph.setYaxisLegend("Impedance Magnitude");
        plotGraph.plot();
    }

    private void impedanceMagnitudeVersusFrequencyPlot(String string, String string2) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        double[][] dArray = new double[2][this.numberOfFrequencies];
        dArray[0] = this.frequencies;
        dArray[1] = this.magnitudesZ;
        PlotGraph plotGraph = new PlotGraph(dArray);
        plotGraph.setLine(3);
        plotGraph.setPoint(0);
        plotGraph.setGraphTitle(string);
        plotGraph.setGraphTitle2(string2);
        plotGraph.setXaxisLegend("Frequency");
        plotGraph.setXaxisUnitsName("Hz");
        plotGraph.setYaxisLegend("Impedance Magnitude");
        plotGraph.plot();
    }

    public void plotImpedancePhases() {
        this.plotImpedancePhaseVersusFrequency();
    }

    public void plotImpedancePhaseVersusFrequency() {
        String[] stringArray = this.dateAndTime();
        String string = "ImpedSpecSimulation program:  Impedance Phase versus Frequency   [" + stringArray[0] + "    " + stringArray[1] + "]";
        String string2 = this.simulationTitle;
        if (this.logOrLinear) {
            this.impedancePhaseVersusLogFrequencyPlot(string, string2);
        } else {
            this.impedancePhaseVersusFrequencyPlot(string, string2);
        }
    }

    public void plotPhaseVersusFrequency() {
        this.plotImpedancePhaseVersusFrequency();
    }

    private void impedancePhaseVersusLogFrequencyPlot(String string, String string2) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        double[][] dArray = new double[2][this.numberOfFrequencies];
        dArray[0] = this.log10frequencies;
        dArray[1] = this.phasesDegZ;
        PlotGraph plotGraph = new PlotGraph(dArray);
        plotGraph.setLine(3);
        plotGraph.setPoint(0);
        plotGraph.setGraphTitle(string);
        plotGraph.setGraphTitle2(string2);
        plotGraph.setXaxisLegend("Log10[Frequency / Hz]");
        plotGraph.setYaxisLegend("Impedance Phase");
        plotGraph.setYaxisUnitsName("degrees");
        plotGraph.plot();
    }

    private void impedancePhaseVersusFrequencyPlot(String string, String string2) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        double[][] dArray = new double[2][this.numberOfFrequencies];
        dArray[0] = this.frequencies;
        dArray[1] = this.phasesDegZ;
        PlotGraph plotGraph = new PlotGraph(dArray);
        plotGraph.setLine(3);
        plotGraph.setPoint(0);
        plotGraph.setGraphTitle(string);
        plotGraph.setGraphTitle2(string2);
        plotGraph.setXaxisLegend("Frequency");
        plotGraph.setXaxisUnitsName("Hz");
        plotGraph.setYaxisLegend("Impedance Phase");
        plotGraph.setYaxisUnitsName("degrees");
        plotGraph.plot();
    }

    public void plotColeCole() {
        String[] stringArray = this.dateAndTime();
        String string = "ImpedSpecSimulation program:  Cole - Cole plot   [" + stringArray[0] + "    " + stringArray[1] + "]";
        String string2 = this.simulationTitle;
        this.coleColePlot(string, string2);
    }

    private void coleColePlot(String string, String string2) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        double[][] dArray = new double[2][this.numberOfFrequencies];
        for (int i = 0; i < this.numberOfFrequencies; ++i) {
            dArray[0][i] = this.realZ[this.numberOfFrequencies - i - 1];
            dArray[1][i] = -this.imagZ[this.numberOfFrequencies - i - 1];
        }
        PlotGraph plotGraph = new PlotGraph(dArray);
        plotGraph.setLine(3);
        plotGraph.setPoint(0);
        plotGraph.setGraphTitle(string);
        plotGraph.setGraphTitle2(string2);
        plotGraph.setXaxisLegend("Real[Impedance / ohms]");
        plotGraph.setYaxisLegend("-Imag[Impedance / ohms]");
        plotGraph.plot();
    }

    public void plotVoltageMagnitudes() {
        this.plotVoltageMagnitudeVersusFrequency();
    }

    public void plotVoltageMagnitudeVersusFrequency() {
        if (this.voltageSet && this.referenceSet) {
            String[] stringArray = this.dateAndTime();
            String string = "ImpedSpecSimulation program:  Voltage Magnitude versus Frequency   [" + stringArray[0] + "    " + stringArray[1] + "]";
            String string2 = this.simulationTitle;
            if (this.logOrLinear) {
                this.voltageMagnitudeVersusLogFrequencyPlot(string, string2);
            } else {
                this.voltageMagnitudeVersusFrequencyPlot(string, string2);
            }
        } else {
            System.out.println("A Voltage phase plot cannot be displayed, either no applied");
            System.out.println("voltage and/or reference impedance has been entered");
        }
    }

    private void voltageMagnitudeVersusLogFrequencyPlot(String string, String string2) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        double[][] dArray = new double[2][this.numberOfFrequencies];
        dArray[0] = this.log10frequencies;
        dArray[1] = this.magnitudesV;
        PlotGraph plotGraph = new PlotGraph(dArray);
        plotGraph.setLine(3);
        plotGraph.setPoint(0);
        plotGraph.setGraphTitle(string);
        plotGraph.setGraphTitle2(string2);
        plotGraph.setXaxisLegend("Log10[Frequency / Hz]");
        plotGraph.setYaxisLegend("Voltage Magnitude");
        plotGraph.plot();
    }

    private void voltageMagnitudeVersusFrequencyPlot(String string, String string2) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        double[][] dArray = new double[2][this.numberOfFrequencies];
        dArray[0] = this.frequencies;
        dArray[1] = this.magnitudesV;
        PlotGraph plotGraph = new PlotGraph(dArray);
        plotGraph.setLine(3);
        plotGraph.setPoint(0);
        plotGraph.setGraphTitle(string);
        plotGraph.setGraphTitle2(string2);
        plotGraph.setXaxisLegend("Frequency");
        plotGraph.setXaxisUnitsName("Hz");
        plotGraph.setYaxisLegend("Voltage Magnitude");
        plotGraph.plot();
    }

    public void plotVoltagePhases() {
        this.plotVoltagePhaseVersusFrequency();
    }

    public void plotVoltagePhaseVersusFrequency() {
        if (this.voltageSet && this.referenceSet) {
            String[] stringArray = this.dateAndTime();
            String string = "ImpedSpecSimulation program:  Voltage Phase versus Frequency   [" + stringArray[0] + "    " + stringArray[1] + "]";
            String string2 = this.simulationTitle;
            if (this.logOrLinear) {
                this.voltagePhaseVersusLogFrequencyPlot(string, string2);
            } else {
                this.voltagePhaseVersusFrequencyPlot(string, string2);
            }
        } else {
            System.out.println("A Voltage phase plot cannot be displayed, either no applied");
            System.out.println("voltage and/or reference impedance has been entered");
        }
    }

    private void voltagePhaseVersusLogFrequencyPlot(String string, String string2) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        double[][] dArray = new double[2][this.numberOfFrequencies];
        dArray[0] = this.log10frequencies;
        dArray[1] = this.phasesDegV;
        PlotGraph plotGraph = new PlotGraph(dArray);
        plotGraph.setLine(3);
        plotGraph.setPoint(0);
        plotGraph.setGraphTitle(string);
        plotGraph.setGraphTitle2(string2);
        plotGraph.setXaxisLegend("Log10[Frequency / Hz]");
        plotGraph.setYaxisLegend("Voltage Phase");
        plotGraph.setYaxisUnitsName("degrees");
        plotGraph.plot();
    }

    private void voltagePhaseVersusFrequencyPlot(String string, String string2) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        double[][] dArray = new double[2][this.numberOfFrequencies];
        dArray[0] = this.frequencies;
        dArray[1] = this.phasesDegV;
        PlotGraph plotGraph = new PlotGraph(dArray);
        plotGraph.setLine(3);
        plotGraph.setPoint(0);
        plotGraph.setGraphTitle(string);
        plotGraph.setGraphTitle2(string2);
        plotGraph.setXaxisLegend("Frequency");
        plotGraph.setXaxisUnitsName("Hz");
        plotGraph.setYaxisLegend("Voltage Phase");
        plotGraph.setYaxisUnitsName("degrees");
        plotGraph.plot();
    }

    public String[] dateAndTime() {
        Date date = new Date();
        String[] stringArray = new String[]{DateFormat.getDateInstance().format(date), DateFormat.getTimeInstance().format(date)};
        return stringArray;
    }

    public void printToTextFile(int n) {
        String string = "ImpedSpecSimulationOutput.txt";
        this.fileType = true;
        this.printToTextFile(string, n);
    }

    public void print(int n) {
        String string = "ImpedSpecSimulationOutput.txt";
        this.fileType = true;
        this.printToTextFile(string, n);
    }

    public void print(String string, int n) {
        this.printToTextFile(string, n);
    }

    public void printToTextFile(String string, int n) {
        int n2;
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        int n3 = 10;
        int n4 = 4;
        int n5 = (string = string.trim()).indexOf(46);
        if (n5 == -1) {
            string = string + ".txt";
        }
        if (n > this.numberOfFrequencies) {
            n = this.numberOfFrequencies;
        }
        int n6 = (int)Math.round((double)this.numberOfFrequencies / (double)n);
        int[] nArray = new int[n];
        nArray[0] = 0;
        for (int i = 1; i < n; ++i) {
            nArray[i] = nArray[i - 1] + n6;
        }
        if (nArray[n - 1] != this.numberOfFrequencies - 1) {
            nArray[n - 1] = this.numberOfFrequencies - 1;
        }
        FileOutput fileOutput = null;
        fileOutput = this.fileType ? new FileOutput(string, 'n') : new FileOutput(string);
        fileOutput.println("ImpedSpecSimulation Program Output File:  " + this.simulationTitle);
        fileOutput.dateAndTimeln(string);
        fileOutput.println();
        if (this.modelSet) {
            fileOutput.println("Circuit - model number " + this.modelNumber);
        } else {
            fileOutput.println("Circuit supplied by the user");
        }
        fileOutput.println();
        fileOutput.println("Circuit Parameters");
        fileOutput.printtab("Parameters");
        fileOutput.println("Value (SI unit)");
        for (n2 = 0; n2 < this.numberOfParameters; ++n2) {
            fileOutput.printtab(this.modelParameterSymbols[n2], n3);
            fileOutput.println(this.parameters[n2]);
        }
        fileOutput.println();
        n3 = 14;
        fileOutput.println("Frequecy - Impedance data");
        fileOutput.print("Frequency", n3);
        fileOutput.print("Magnitude", n3);
        fileOutput.print("Phase", n3);
        fileOutput.print("Phase", n3);
        fileOutput.print("Real[Z]", n3);
        fileOutput.print("Imag[Z]", n3);
        fileOutput.print("Log10(freq)", n3);
        fileOutput.println("Radial frequency");
        fileOutput.print("/Hz [freq]", n3);
        fileOutput.print("  ", n3);
        fileOutput.print("/degrees", n3);
        fileOutput.print("/radians", n3);
        fileOutput.print("/ohms", n3);
        fileOutput.print("/ohms", n3);
        fileOutput.print("  ", n3);
        fileOutput.println("/radians");
        for (n2 = 0; n2 < n; ++n2) {
            fileOutput.print(Fmath.truncate(this.frequencies[nArray[n2]], n4), n3);
            fileOutput.print(Fmath.truncate(this.magnitudesZ[nArray[n2]], n4), n3);
            fileOutput.print(Fmath.truncate(this.phasesDegZ[nArray[n2]], n4), n3);
            fileOutput.print(Fmath.truncate(this.phasesRadZ[nArray[n2]], n4), n3);
            fileOutput.print(Fmath.truncate(this.realZ[nArray[n2]], n4), n3);
            fileOutput.print(Fmath.truncate(this.imagZ[nArray[n2]], n4), n3);
            fileOutput.print(Fmath.truncate(this.log10frequencies[nArray[n2]], n4), n3);
            fileOutput.println(Fmath.truncate(this.omegas[nArray[n2]], n4));
        }
        fileOutput.println();
        if (this.voltageSet && this.referenceSet) {
            fileOutput.println("Aplied voltage: " + this.appliedVoltage.getReal() + " volts");
            fileOutput.println();
            fileOutput.println("Reference impedance: " + this.referenceImpedance + " ohms");
            fileOutput.println();
            n3 = 14;
            fileOutput.println("Frequecy - Voltage data");
            fileOutput.print("Frequency", n3);
            fileOutput.print("Magnitude", n3);
            fileOutput.print("Phase", n3);
            fileOutput.print("Phase", n3);
            fileOutput.print("Real[V]", n3);
            fileOutput.print("Imag[V]", n3);
            fileOutput.print("Log10(freq)", n3);
            fileOutput.println("Radial frequency");
            fileOutput.print("/Hz [freq]", n3);
            fileOutput.print("  ", n3);
            fileOutput.print("/degrees", n3);
            fileOutput.print("/radians", n3);
            fileOutput.print("/volts", n3);
            fileOutput.print("/volts", n3);
            fileOutput.print("  ", n3);
            fileOutput.println("/radians");
            for (n2 = 0; n2 < n; ++n2) {
                fileOutput.print(Fmath.truncate(this.frequencies[nArray[n2]], n4), n3);
                fileOutput.print(Fmath.truncate(this.magnitudesV[nArray[n2]], n4), n3);
                fileOutput.print(Fmath.truncate(this.phasesDegV[nArray[n2]], n4), n3);
                fileOutput.print(Fmath.truncate(this.phasesRadV[nArray[n2]], n4), n3);
                fileOutput.print(Fmath.truncate(this.realV[nArray[n2]], n4), n3);
                fileOutput.print(Fmath.truncate(this.imagV[nArray[n2]], n4), n3);
                fileOutput.print(Fmath.truncate(this.log10frequencies[nArray[n2]], n4), n3);
                fileOutput.println(Fmath.truncate(this.omegas[nArray[n2]], n4));
            }
        }
        fileOutput.close();
    }

    public void printToExcelFile(int n) {
        String string = "ImpedSpecSimulationOutput.xls";
        this.fileType = true;
        this.printToExcelFile(string, n);
    }

    public void printForExcel(int n) {
        String string = "ImpedSpecSimulationOutput.xls";
        this.fileType = true;
        this.printToExcelFile(string, n);
    }

    public void printForExcel(String string, int n) {
        this.printToExcelFile(string, n);
    }

    public void printToExcelFile(String string, int n) {
        int n2;
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        int n3 = 10;
        int n4 = 4;
        int n5 = (string = string.trim()).indexOf(46);
        string = n5 == -1 ? string + ".xls" : string.substring(0, n5) + ".xls";
        if (n > this.numberOfFrequencies) {
            n = this.numberOfFrequencies;
        }
        int n6 = (int)Math.round((double)this.numberOfFrequencies / (double)n);
        int[] nArray = new int[n];
        nArray[0] = 0;
        for (int i = 1; i < n; ++i) {
            nArray[i] = nArray[i - 1] + n6;
        }
        if (nArray[n - 1] != this.numberOfFrequencies - 1) {
            nArray[n - 1] = this.numberOfFrequencies - 1;
        }
        FileOutput fileOutput = null;
        fileOutput = this.fileType ? new FileOutput(string, 'n') : new FileOutput(string);
        fileOutput.println("ImpedSpecSimulation Program Output File:  " + this.simulationTitle);
        fileOutput.dateAndTimeln(string);
        fileOutput.println();
        if (this.modelSet) {
            fileOutput.println("Circuit - model number " + this.modelNumber);
        } else {
            fileOutput.println("Circuit supplied by the user");
        }
        fileOutput.println();
        fileOutput.println("Circuit Parameters");
        fileOutput.printtab("Parameters");
        fileOutput.println("Value (SI unit)");
        for (n2 = 0; n2 < this.numberOfParameters; ++n2) {
            fileOutput.printtab(this.modelParameterSymbols[n2], n3);
            fileOutput.println(this.parameters[n2]);
        }
        fileOutput.println();
        n3 = 10;
        fileOutput.println("Frequecy - Impedance data");
        fileOutput.printtab("Frequency", n3);
        fileOutput.printtab("Magnitude", n3);
        fileOutput.printtab("Phase", n3);
        fileOutput.printtab("Phase", n3);
        fileOutput.printtab("Real[Z]", n3);
        fileOutput.printtab("Imag[Z]", n3);
        fileOutput.printtab("Log10(freq)", n3);
        fileOutput.println("Radial frequency");
        fileOutput.printtab("/Hz [freq]", n3);
        fileOutput.printtab("  ", n3);
        fileOutput.printtab("/degrees", n3);
        fileOutput.printtab("/radians", n3);
        fileOutput.printtab("/ohms", n3);
        fileOutput.printtab("/ohms", n3);
        fileOutput.printtab("  ", n3);
        fileOutput.println("/radians");
        for (n2 = 0; n2 < n; ++n2) {
            fileOutput.printtab(Fmath.truncate(this.frequencies[nArray[n2]], n4), n3);
            fileOutput.printtab(Fmath.truncate(this.magnitudesZ[nArray[n2]], n4), n3);
            fileOutput.printtab(Fmath.truncate(this.phasesDegZ[nArray[n2]], n4), n3);
            fileOutput.printtab(Fmath.truncate(this.phasesRadZ[nArray[n2]], n4), n3);
            fileOutput.printtab(Fmath.truncate(this.realZ[nArray[n2]], n4), n3);
            fileOutput.printtab(Fmath.truncate(this.imagZ[nArray[n2]], n4), n3);
            fileOutput.printtab(Fmath.truncate(this.log10frequencies[nArray[n2]], n4), n3);
            fileOutput.println(Fmath.truncate(this.omegas[nArray[n2]], n4));
        }
        fileOutput.println();
        if (this.voltageSet && this.referenceSet) {
            fileOutput.println("Aplied voltage: " + this.appliedVoltage.getReal() + " volts");
            fileOutput.println();
            fileOutput.println("Reference impedance: " + this.referenceImpedance + " ohms");
            fileOutput.println();
            n3 = 14;
            fileOutput.println("Frequecy - Voltage data");
            fileOutput.printtab("Frequency", n3);
            fileOutput.printtab("Magnitude", n3);
            fileOutput.printtab("Phase", n3);
            fileOutput.printtab("Phase", n3);
            fileOutput.printtab("Real[V]", n3);
            fileOutput.printtab("Imag[V]", n3);
            fileOutput.printtab("Log10(freq)", n3);
            fileOutput.println("Radial frequency");
            fileOutput.printtab("/Hz [freq]", n3);
            fileOutput.printtab("  ", n3);
            fileOutput.printtab("/degrees", n3);
            fileOutput.printtab("/radians", n3);
            fileOutput.printtab("/volts", n3);
            fileOutput.printtab("/volts", n3);
            fileOutput.printtab("  ", n3);
            fileOutput.println("/radians");
            for (n2 = 0; n2 < n; ++n2) {
                fileOutput.printtab(Fmath.truncate(this.frequencies[nArray[n2]], n4), n3);
                fileOutput.printtab(Fmath.truncate(this.magnitudesV[nArray[n2]], n4), n3);
                fileOutput.printtab(Fmath.truncate(this.phasesDegV[nArray[n2]], n4), n3);
                fileOutput.printtab(Fmath.truncate(this.phasesRadV[nArray[n2]], n4), n3);
                fileOutput.printtab(Fmath.truncate(this.realV[nArray[n2]], n4), n3);
                fileOutput.printtab(Fmath.truncate(this.imagV[nArray[n2]], n4), n3);
                fileOutput.printtab(Fmath.truncate(this.log10frequencies[nArray[n2]], n4), n3);
                fileOutput.println(Fmath.truncate(this.omegas[nArray[n2]], n4));
            }
        }
        fileOutput.close();
    }
}

