/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.circuits.Impedance;
import flanagan.circuits.TransmissionLine;

public class CoaxialLine
extends TransmissionLine {
    private double innerRadius = -1.0;
    private double outerRadius = -1.0;
    private boolean radiiSet = false;
    private double relativePermittivity = 1.0;
    private double relativePermeability = 1.0;

    public CoaxialLine() {
        this.title = "Coaxial Line";
    }

    public CoaxialLine(String string) {
        this.title = string;
    }

    public void setRadii(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("The inner radius, " + d + ", must be greater than zero");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("The outer radius, " + d2 + ", must be greater than zero");
        }
        if (d >= d2) {
            throw new IllegalArgumentException("The inner radius, " + d + ", must be less than the outer radius, " + d2);
        }
        this.innerRadius = d;
        this.outerRadius = d2;
        this.radiiSet = true;
        this.calculateDistributedCapacitanceAndInductance();
    }

    public void setInnerRadius(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("The inner radius, " + d + ", must be greater than zero");
        }
        if (this.outerRadius != -1.0 && this.outerRadius <= d) {
            throw new IllegalArgumentException("The inner radius, " + d + ", must be less than the outer radius, " + this.outerRadius);
        }
        this.innerRadius = d;
        if (this.outerRadius != -1.0) {
            this.radiiSet = true;
        }
        if (this.radiiSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    public void setOuterRadius(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("The outer radius, " + d + ", must be greater than zero");
        }
        if (this.innerRadius != -1.0 && this.innerRadius >= d) {
            throw new IllegalArgumentException("The outer radius, " + d + ", must be greater than the inner radius, " + this.innerRadius);
        }
        this.outerRadius = d;
        if (this.innerRadius != -1.0) {
            this.radiiSet = true;
        }
        if (this.radiiSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    public void setRelativePermittivity(double d) {
        this.relativePermittivity = d;
        if (this.radiiSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    public void setRelativePermeability(double d) {
        this.relativePermeability = d;
        if (this.radiiSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    private void calculateDistributedCapacitanceAndInductance() {
        this.distributedCapacitance = Impedance.coaxialCapacitance(1.0, this.innerRadius, this.outerRadius, this.relativePermittivity);
        this.distributedInductance = Impedance.coaxialInductance(1.0, this.innerRadius, this.outerRadius, this.relativePermeability);
    }

    @Override
    public CoaxialLine copy() {
        if (this == null) {
            return null;
        }
        CoaxialLine coaxialLine = new CoaxialLine();
        coaxialLine.innerRadius = this.innerRadius;
        coaxialLine.outerRadius = this.outerRadius;
        coaxialLine.radiiSet = this.radiiSet;
        coaxialLine.relativePermittivity = this.relativePermittivity;
        coaxialLine.relativePermeability = this.relativePermeability;
        coaxialLine.title = this.title;
        coaxialLine.distributedResistance = this.distributedResistance;
        coaxialLine.distributedConductance = this.distributedConductance;
        coaxialLine.distributedCapacitance = this.distributedCapacitance;
        coaxialLine.distributedInductance = this.distributedInductance;
        coaxialLine.distributedImpedance = this.distributedImpedance.copy();
        coaxialLine.distributedAdmittance = this.distributedAdmittance.copy();
        coaxialLine.loadImpedance = this.loadImpedance.copy();
        coaxialLine.lineLength = this.lineLength;
        coaxialLine.segmentLength = this.segmentLength;
        coaxialLine.frequency = this.frequency;
        coaxialLine.segmentLength = this.segmentLength;
        coaxialLine.omega = this.omega;
        coaxialLine.inputVoltage = this.inputVoltage.copy();
        coaxialLine.inputCurrent = this.inputCurrent.copy();
        coaxialLine.outputVoltage = this.outputVoltage.copy();
        coaxialLine.outputCurrent = this.outputCurrent.copy();
        coaxialLine.idealWavelength = this.idealWavelength;
        coaxialLine.generalWavelength = this.generalWavelength;
        coaxialLine.lowLossWavelength = this.lowLossWavelength;
        coaxialLine.idealPhaseVelocity = this.idealPhaseVelocity;
        coaxialLine.generalPhaseVelocity = this.generalPhaseVelocity;
        coaxialLine.lowLossPhaseVelocity = this.lowLossPhaseVelocity;
        coaxialLine.idealGroupVelocity = this.idealGroupVelocity;
        coaxialLine.generalGroupVelocity = this.generalGroupVelocity;
        coaxialLine.lowLossGroupVelocity = this.lowLossGroupVelocity;
        coaxialLine.delta = this.delta;
        coaxialLine.idealAttenuationConstant = this.idealAttenuationConstant;
        coaxialLine.generalAttenuationConstant = this.generalAttenuationConstant;
        coaxialLine.lowLossAttenuationConstant = this.lowLossAttenuationConstant;
        coaxialLine.idealPhaseConstant = this.idealPhaseConstant;
        coaxialLine.generalPhaseConstant = this.generalPhaseConstant;
        coaxialLine.lowLossPhaseConstant = this.lowLossPhaseConstant;
        coaxialLine.idealPropagationConstant = this.idealPropagationConstant.copy();
        coaxialLine.loadImpedance = this.loadImpedance.copy();
        coaxialLine.loadImpedance = this.loadImpedance.copy();
        coaxialLine.loadImpedance = this.loadImpedance.copy();
        coaxialLine.generalPropagationConstant = this.generalPropagationConstant.copy();
        coaxialLine.lowLossPropagationConstant = this.lowLossPropagationConstant.copy();
        coaxialLine.idealCharacteristicImpedance = this.idealCharacteristicImpedance.copy();
        coaxialLine.idealRealCharacteristicImpedance = this.idealRealCharacteristicImpedance;
        coaxialLine.generalCharacteristicImpedance = this.generalCharacteristicImpedance.copy();
        coaxialLine.lowLossCharacteristicImpedance = this.lowLossCharacteristicImpedance.copy();
        coaxialLine.idealInputImpedance = this.idealInputImpedance.copy();
        coaxialLine.generalInputImpedance = this.generalInputImpedance.copy();
        coaxialLine.lowLossInputImpedance = this.lowLossInputImpedance.copy();
        coaxialLine.idealShortedLineImpedance = this.idealShortedLineImpedance.copy();
        coaxialLine.generalShortedLineImpedance = this.generalShortedLineImpedance.copy();
        coaxialLine.lowLossShortedLineImpedance = this.lowLossShortedLineImpedance.copy();
        coaxialLine.idealOpenLineImpedance = this.idealOpenLineImpedance.copy();
        coaxialLine.generalOpenLineImpedance = this.generalOpenLineImpedance.copy();
        coaxialLine.lowLossOpenLineImpedance = this.lowLossOpenLineImpedance.copy();
        coaxialLine.idealQuarterWaveLineImpedance = this.idealQuarterWaveLineImpedance.copy();
        coaxialLine.generalQuarterWaveLineImpedance = this.generalQuarterWaveLineImpedance.copy();
        coaxialLine.lowLossQuarterWaveLineImpedance = this.lowLossQuarterWaveLineImpedance.copy();
        coaxialLine.idealHalfWaveLineImpedance = this.idealHalfWaveLineImpedance.copy();
        coaxialLine.generalHalfWaveLineImpedance = this.generalHalfWaveLineImpedance.copy();
        coaxialLine.lowLossHalfWaveLineImpedance = this.lowLossHalfWaveLineImpedance.copy();
        coaxialLine.idealRefectionCoefficient = this.idealRefectionCoefficient.copy();
        coaxialLine.generalRefectionCoefficient = this.generalRefectionCoefficient.copy();
        coaxialLine.lowLossRefectionCoefficient = this.lowLossRefectionCoefficient.copy();
        coaxialLine.idealStandingWaveRatio = this.idealStandingWaveRatio;
        coaxialLine.generalStandingWaveRatio = this.generalStandingWaveRatio;
        coaxialLine.lowLossStandingWaveRatio = this.lowLossStandingWaveRatio;
        coaxialLine.idealABCDmatrix = this.idealABCDmatrix.copy();
        coaxialLine.generalABCDmatrix = this.generalABCDmatrix.copy();
        coaxialLine.lowLossABCDmatrix = this.lowLossABCDmatrix.copy();
        coaxialLine.numberOfPoints = this.numberOfPoints;
        return coaxialLine;
    }

    @Override
    public Object clone() {
        CoaxialLine coaxialLine = null;
        if (this != null) {
            CoaxialLine coaxialLine2 = new CoaxialLine();
            coaxialLine2.innerRadius = this.innerRadius;
            coaxialLine2.outerRadius = this.outerRadius;
            coaxialLine2.radiiSet = this.radiiSet;
            coaxialLine2.relativePermittivity = this.relativePermittivity;
            coaxialLine2.relativePermeability = this.relativePermeability;
            coaxialLine2.title = this.title;
            coaxialLine2.distributedResistance = this.distributedResistance;
            coaxialLine2.distributedConductance = this.distributedConductance;
            coaxialLine2.distributedCapacitance = this.distributedCapacitance;
            coaxialLine2.distributedInductance = this.distributedInductance;
            coaxialLine2.distributedImpedance = this.distributedImpedance.copy();
            coaxialLine2.distributedAdmittance = this.distributedAdmittance.copy();
            coaxialLine2.loadImpedance = this.loadImpedance.copy();
            coaxialLine2.lineLength = this.lineLength;
            coaxialLine2.segmentLength = this.segmentLength;
            coaxialLine2.frequency = this.frequency;
            coaxialLine2.segmentLength = this.segmentLength;
            coaxialLine2.omega = this.omega;
            coaxialLine2.inputVoltage = this.inputVoltage.copy();
            coaxialLine2.inputCurrent = this.inputCurrent.copy();
            coaxialLine2.outputVoltage = this.outputVoltage.copy();
            coaxialLine2.outputCurrent = this.outputCurrent.copy();
            coaxialLine2.idealWavelength = this.idealWavelength;
            coaxialLine2.generalWavelength = this.generalWavelength;
            coaxialLine2.lowLossWavelength = this.lowLossWavelength;
            coaxialLine2.idealPhaseVelocity = this.idealPhaseVelocity;
            coaxialLine2.generalPhaseVelocity = this.generalPhaseVelocity;
            coaxialLine2.lowLossPhaseVelocity = this.lowLossPhaseVelocity;
            coaxialLine2.idealGroupVelocity = this.idealGroupVelocity;
            coaxialLine2.generalGroupVelocity = this.generalGroupVelocity;
            coaxialLine2.lowLossGroupVelocity = this.lowLossGroupVelocity;
            coaxialLine2.delta = this.delta;
            coaxialLine2.idealAttenuationConstant = this.idealAttenuationConstant;
            coaxialLine2.generalAttenuationConstant = this.generalAttenuationConstant;
            coaxialLine2.lowLossAttenuationConstant = this.lowLossAttenuationConstant;
            coaxialLine2.idealPhaseConstant = this.idealPhaseConstant;
            coaxialLine2.generalPhaseConstant = this.generalPhaseConstant;
            coaxialLine2.lowLossPhaseConstant = this.lowLossPhaseConstant;
            coaxialLine2.idealPropagationConstant = this.idealPropagationConstant.copy();
            coaxialLine2.loadImpedance = this.loadImpedance.copy();
            coaxialLine2.loadImpedance = this.loadImpedance.copy();
            coaxialLine2.loadImpedance = this.loadImpedance.copy();
            coaxialLine2.generalPropagationConstant = this.generalPropagationConstant.copy();
            coaxialLine2.lowLossPropagationConstant = this.lowLossPropagationConstant.copy();
            coaxialLine2.idealCharacteristicImpedance = this.idealCharacteristicImpedance.copy();
            coaxialLine2.idealRealCharacteristicImpedance = this.idealRealCharacteristicImpedance;
            coaxialLine2.generalCharacteristicImpedance = this.generalCharacteristicImpedance.copy();
            coaxialLine2.lowLossCharacteristicImpedance = this.lowLossCharacteristicImpedance.copy();
            coaxialLine2.idealInputImpedance = this.idealInputImpedance.copy();
            coaxialLine2.generalInputImpedance = this.generalInputImpedance.copy();
            coaxialLine2.lowLossInputImpedance = this.lowLossInputImpedance.copy();
            coaxialLine2.idealShortedLineImpedance = this.idealShortedLineImpedance.copy();
            coaxialLine2.generalShortedLineImpedance = this.generalShortedLineImpedance.copy();
            coaxialLine2.lowLossShortedLineImpedance = this.lowLossShortedLineImpedance.copy();
            coaxialLine2.idealOpenLineImpedance = this.idealOpenLineImpedance.copy();
            coaxialLine2.generalOpenLineImpedance = this.generalOpenLineImpedance.copy();
            coaxialLine2.lowLossOpenLineImpedance = this.lowLossOpenLineImpedance.copy();
            coaxialLine2.idealQuarterWaveLineImpedance = this.idealQuarterWaveLineImpedance.copy();
            coaxialLine2.generalQuarterWaveLineImpedance = this.generalQuarterWaveLineImpedance.copy();
            coaxialLine2.lowLossQuarterWaveLineImpedance = this.lowLossQuarterWaveLineImpedance.copy();
            coaxialLine2.idealHalfWaveLineImpedance = this.idealHalfWaveLineImpedance.copy();
            coaxialLine2.generalHalfWaveLineImpedance = this.generalHalfWaveLineImpedance.copy();
            coaxialLine2.lowLossHalfWaveLineImpedance = this.lowLossHalfWaveLineImpedance.copy();
            coaxialLine2.idealRefectionCoefficient = this.idealRefectionCoefficient.copy();
            coaxialLine2.generalRefectionCoefficient = this.generalRefectionCoefficient.copy();
            coaxialLine2.lowLossRefectionCoefficient = this.lowLossRefectionCoefficient.copy();
            coaxialLine2.idealStandingWaveRatio = this.idealStandingWaveRatio;
            coaxialLine2.generalStandingWaveRatio = this.generalStandingWaveRatio;
            coaxialLine2.lowLossStandingWaveRatio = this.lowLossStandingWaveRatio;
            coaxialLine2.idealABCDmatrix = this.idealABCDmatrix.copy();
            coaxialLine2.generalABCDmatrix = this.generalABCDmatrix.copy();
            coaxialLine2.lowLossABCDmatrix = this.lowLossABCDmatrix.copy();
            coaxialLine2.numberOfPoints = this.numberOfPoints;
            coaxialLine = coaxialLine2;
        }
        return coaxialLine;
    }
}

