/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.interpolation.TriCubicSpline;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import flanagan.plot.PlotGraph;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ThreeDimensionalSmooth {
    private double[] xData = null;
    private double[] yData = null;
    private double[] zData = null;
    private double[][][] vData = null;
    private BigDecimal[] xBDdata = null;
    private BigDecimal[] yBDdata = null;
    private BigDecimal[] zBDdata = null;
    private BigDecimal[][][] vBDdata = null;
    private int nPointsX = 0;
    private int nPointsY = 0;
    private int nPointsZ = 0;
    private int nPoints = 0;
    private boolean arbprec = false;
    private double[][][] vDataMovAv = null;
    private BigDecimal[][][] vDataMovAvBD = null;
    private double[][][] vDataSavGol = null;
    private double[][][] derivSavGol = null;
    private int[][] sgCoeffIndices = null;
    private int nSGcoeff = 0;
    private int lastMethod = 0;
    private int nMethods = 2;
    private int maWindowWidthx = 0;
    private int maWindowWidthy = 0;
    private int maWindowWidthz = 0;
    private int sgWindowWidthx = 0;
    private int sgWindowWidthy = 0;
    private int sgWindowWidthz = 0;
    private int sgPolyDeg = 4;
    private double[][] sgArrayC = null;
    private boolean calcSavGol = false;
    private boolean calcMovAv = false;
    private boolean nthSet = false;
    private double extentMovAv = -1.0;
    private double extentSavGol = -1.0;
    private TriCubicSpline tcsSavGol = null;
    private TriCubicSpline tcsMovAv = null;
    private int trunc = 4;

    public ThreeDimensionalSmooth(double[] dArray, double[] dArray2, double[] dArray3, double[][][] dArray4) {
        this.xData = dArray;
        this.yData = dArray2;
        this.zData = dArray3;
        this.vData = dArray4;
        this.polyIndices();
        this.check();
        this.ascend();
    }

    public ThreeDimensionalSmooth(double[][][] dArray) {
        int n;
        int n2 = dArray.length;
        this.vData = dArray;
        this.yData = new double[n2];
        for (n = 0; n < n2; ++n) {
            this.yData[n] = n;
        }
        n2 = dArray[0].length;
        this.xData = new double[n2];
        for (n = 0; n < n2; ++n) {
            this.xData[n] = n;
        }
        n2 = dArray[0][0].length;
        this.zData = new double[n2];
        for (n = 0; n < n2; ++n) {
            this.zData[n] = n;
        }
        this.polyIndices();
        this.check();
    }

    public ThreeDimensionalSmooth(float[] fArray, float[] fArray2, float[] fArray3, float[][][] fArray4) {
        ArrayMaths arrayMaths = new ArrayMaths(fArray);
        this.xData = arrayMaths.array();
        arrayMaths = new ArrayMaths(fArray2);
        this.yData = arrayMaths.array();
        arrayMaths = new ArrayMaths(fArray);
        this.zData = arrayMaths.array();
        int n = fArray4.length;
        int n2 = fArray4[0].length;
        int n3 = fArray4[0][0].length;
        this.vData = new double[n][n2][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    this.vData[i][j][k] = Conv.convert_float_to_double(fArray4[i][j][k]);
                }
            }
        }
        this.polyIndices();
        this.check();
        this.ascend();
    }

    public ThreeDimensionalSmooth(float[][][] fArray) {
        int n;
        int n2 = fArray.length;
        int n3 = fArray[0].length;
        int n4 = fArray[0][0].length;
        this.vData = new double[n2][n3][n4];
        this.xData = new double[n2];
        this.yData = new double[n3];
        this.zData = new double[n4];
        for (n = 0; n < n2; ++n) {
            this.xData[n] = n;
        }
        for (n = 0; n < n3; ++n) {
            this.yData[n] = n;
        }
        for (n = 0; n < n4; ++n) {
            this.zData[n] = n;
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    this.vData[n][i][j] = Conv.convert_float_to_double(fArray[n][i][j]);
                }
            }
        }
        this.polyIndices();
        this.check();
    }

    public ThreeDimensionalSmooth(long[] lArray, long[] lArray2, long[] lArray3, long[][][] lArray4) {
        ArrayMaths arrayMaths = new ArrayMaths(lArray);
        this.xData = arrayMaths.array();
        arrayMaths = new ArrayMaths(lArray2);
        this.yData = arrayMaths.array();
        arrayMaths = new ArrayMaths(lArray);
        this.zData = arrayMaths.array();
        int n = lArray4.length;
        int n2 = lArray4[0].length;
        int n3 = lArray4[0][0].length;
        this.vData = new double[n][n2][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    this.vData[i][j][k] = Conv.convert_long_to_double(lArray4[i][j][k]);
                }
            }
        }
        this.polyIndices();
        this.check();
        this.ascend();
    }

    public ThreeDimensionalSmooth(long[][][] lArray) {
        int n;
        int n2 = lArray.length;
        int n3 = lArray[0].length;
        int n4 = lArray[0][0].length;
        this.vData = new double[n2][n3][n4];
        this.xData = new double[n2];
        this.yData = new double[n3];
        this.zData = new double[n4];
        for (n = 0; n < n2; ++n) {
            this.xData[n] = n;
        }
        for (n = 0; n < n3; ++n) {
            this.yData[n] = n;
        }
        for (n = 0; n < n4; ++n) {
            this.zData[n] = n;
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    this.vData[n][i][j] = Conv.convert_long_to_double(lArray[n][i][j]);
                }
            }
        }
        this.polyIndices();
        this.check();
    }

    public ThreeDimensionalSmooth(int[] nArray, int[] nArray2, int[] nArray3, int[][][] nArray4) {
        ArrayMaths arrayMaths = new ArrayMaths(nArray);
        this.xData = arrayMaths.array();
        arrayMaths = new ArrayMaths(nArray2);
        this.yData = arrayMaths.array();
        arrayMaths = new ArrayMaths(nArray);
        this.zData = arrayMaths.array();
        int n = nArray4.length;
        int n2 = nArray4[0].length;
        int n3 = nArray4[0][0].length;
        this.vData = new double[n][n2][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    this.vData[i][j][k] = Conv.convert_long_to_int(nArray4[i][j][k]);
                }
            }
        }
        this.polyIndices();
        this.check();
        this.ascend();
    }

    public ThreeDimensionalSmooth(int[][][] nArray) {
        int n;
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        int n4 = nArray[0][0].length;
        this.vData = new double[n2][n3][n4];
        this.xData = new double[n2];
        this.yData = new double[n3];
        this.zData = new double[n4];
        for (n = 0; n < n2; ++n) {
            this.xData[n] = n;
        }
        for (n = 0; n < n3; ++n) {
            this.yData[n] = n;
        }
        for (n = 0; n < n4; ++n) {
            this.zData[n] = n;
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    this.vData[n][i][j] = Conv.convert_int_to_double(nArray[n][i][j]);
                }
            }
        }
        this.polyIndices();
        this.check();
    }

    public ThreeDimensionalSmooth(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2, BigDecimal[] bigDecimalArray3, BigDecimal[][][] bigDecimalArray4) {
        ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray);
        this.xData = arrayMaths.array();
        this.xBDdata = bigDecimalArray;
        arrayMaths = new ArrayMaths(bigDecimalArray2);
        this.yData = arrayMaths.array();
        this.yBDdata = bigDecimalArray2;
        arrayMaths = new ArrayMaths(bigDecimalArray3);
        this.zData = arrayMaths.array();
        this.zBDdata = bigDecimalArray3;
        int n = bigDecimalArray4.length;
        int n2 = bigDecimalArray4[0].length;
        int n3 = bigDecimalArray4[0][0].length;
        this.vData = new double[n][n2][n3];
        this.vData = new double[n][n2][n3];
        this.vBDdata = new BigDecimal[n][n2][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    this.vBDdata[i][j][k] = bigDecimalArray4[i][j][k];
                    this.vData[i][j][k] = this.vBDdata[i][j][k].doubleValue();
                }
            }
        }
        this.polyIndices();
        this.check();
        this.ascend();
    }

    public ThreeDimensionalSmooth(BigDecimal[][][] bigDecimalArray) {
        int n;
        int n2 = bigDecimalArray.length;
        int n3 = bigDecimalArray[0].length;
        int n4 = bigDecimalArray[0][0].length;
        this.vData = new double[n2][n3][n4];
        this.vBDdata = new BigDecimal[n2][n3][n4];
        this.xData = new double[n2];
        this.yData = new double[n3];
        this.zData = new double[n4];
        this.xBDdata = new BigDecimal[n2];
        this.yBDdata = new BigDecimal[n3];
        this.zBDdata = new BigDecimal[n4];
        for (n = 0; n < n2; ++n) {
            this.xData[n] = n;
            this.xBDdata[n] = new BigDecimal(new Integer(n).toString());
        }
        for (n = 0; n < n3; ++n) {
            this.yData[n] = n;
            this.yBDdata[n] = new BigDecimal(new Integer(n).toString());
        }
        for (n = 0; n < n4; ++n) {
            this.zData[n] = n;
            this.zBDdata[n] = new BigDecimal(new Integer(n).toString());
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    this.vBDdata[n][i][j] = bigDecimalArray[n][i][j];
                    this.vData[n][i][j] = Conv.convert_BigDecimal_to_double(bigDecimalArray[n][i][j]);
                }
            }
        }
        this.polyIndices();
        this.check();
    }

    public ThreeDimensionalSmooth(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2, BigInteger[] bigIntegerArray3, BigInteger[][][] bigIntegerArray4) {
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        this.xData = arrayMaths.array();
        this.xBDdata = arrayMaths.array_as_BigDecimal();
        arrayMaths = new ArrayMaths(bigIntegerArray2);
        this.yData = arrayMaths.array();
        this.yBDdata = arrayMaths.array_as_BigDecimal();
        arrayMaths = new ArrayMaths(bigIntegerArray3);
        this.zData = arrayMaths.array();
        this.zBDdata = arrayMaths.array_as_BigDecimal();
        int n = bigIntegerArray4.length;
        int n2 = bigIntegerArray4[0].length;
        int n3 = bigIntegerArray4[0][0].length;
        this.vData = new double[n][n2][n3];
        this.vBDdata = new BigDecimal[n][n2][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    this.vBDdata[i][j][k] = new BigDecimal(bigIntegerArray4[i][j][k]);
                    this.vData[i][j][k] = this.vBDdata[i][j][k].doubleValue();
                }
            }
        }
        this.polyIndices();
        this.check();
        this.ascend();
    }

    public ThreeDimensionalSmooth(BigInteger[][][] bigIntegerArray) {
        int n;
        int n2 = bigIntegerArray.length;
        int n3 = bigIntegerArray[0].length;
        int n4 = bigIntegerArray[0][0].length;
        this.vData = new double[n2][n3][n4];
        this.vBDdata = new BigDecimal[n2][n3][n4];
        this.xData = new double[n2];
        this.yData = new double[n3];
        this.zData = new double[n4];
        this.xBDdata = new BigDecimal[n2];
        this.yBDdata = new BigDecimal[n3];
        this.zBDdata = new BigDecimal[n4];
        for (n = 0; n < n2; ++n) {
            this.xData[n] = n;
            this.xBDdata[n] = new BigDecimal(new Integer(n).toString());
        }
        for (n = 0; n < n3; ++n) {
            this.yData[n] = n;
            this.yBDdata[n] = new BigDecimal(new Integer(n).toString());
        }
        for (n = 0; n < n4; ++n) {
            this.zData[n] = n;
            this.zBDdata[n] = new BigDecimal(new Integer(n).toString());
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    this.vBDdata[n][i][j] = new BigDecimal(bigIntegerArray[n][i][j]);
                    this.vData[n][i][j] = Conv.convert_BigInteger_to_double(bigIntegerArray[n][i][j]);
                }
            }
        }
        this.polyIndices();
        this.check();
    }

    public ThreeDimensionalSmooth() {
    }

    private void polyIndices() {
        int n;
        int n2;
        this.nSGcoeff = 0;
        for (n2 = 1; n2 <= this.sgPolyDeg + 1; ++n2) {
            for (n = 1; n <= n2; ++n) {
                this.nSGcoeff += n;
            }
        }
        this.sgCoeffIndices = new int[this.nSGcoeff][3];
        n2 = 0;
        for (n = 0; n <= this.sgPolyDeg; ++n) {
            for (int i = 0; i <= this.sgPolyDeg - n; ++i) {
                int n3 = 0;
                while (n3 <= this.sgPolyDeg - i - n) {
                    this.sgCoeffIndices[n2][0] = n;
                    this.sgCoeffIndices[n2][1] = i;
                    this.sgCoeffIndices[n2++][2] = n3++;
                }
            }
        }
    }

    private void check() {
        int n;
        int n2;
        int n3;
        double[][][] dArray;
        this.nPointsZ = this.zData.length;
        this.nPointsY = this.yData.length;
        this.nPointsX = this.xData.length;
        this.nPoints = this.nPointsX * this.nPointsY * this.nPointsY;
        int n4 = this.vData.length;
        int n5 = this.vData[0].length;
        int n6 = this.vData[0][0].length;
        int n7 = -1;
        boolean bl = false;
        if (this.nPointsZ == n4 && this.nPointsY == n5 && this.nPointsX == n6) {
            bl = true;
        } else if (this.nPointsZ == n5 && this.nPointsY == n4 && this.nPointsX == n6) {
            dArray = this.copy3D(this.vData);
            this.vData = new double[n5][n4][n6];
            for (n3 = 0; n3 < n6; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    for (n = 0; n < n4; ++n) {
                        this.vData[n2][n][n3] = dArray[n][n2][n3];
                    }
                }
            }
            bl = true;
            System.out.println("vData transposed to match the dimensions of the yData and zData");
        } else if (this.nPointsZ == n4 && this.nPointsY == n6 && this.nPointsX == n5) {
            dArray = this.copy3D(this.vData);
            this.vData = new double[n4][n6][n5];
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n6; ++n2) {
                    for (n = 0; n < n5; ++n) {
                        this.vData[n3][n2][n] = dArray[n3][n][n2];
                    }
                }
            }
            bl = true;
            System.out.println("vData transposed to match the dimensions of the xData and yData");
        } else {
            if (this.nPointsZ == n6 && this.nPointsY == n5 && this.nPointsX == n4) {
                dArray = this.copy3D(this.vData);
                this.vData = new double[n6][n5][n4];
                for (n3 = 0; n3 < n6; ++n3) {
                    for (n2 = 0; n2 < n4; ++n2) {
                        for (n = 0; n < n5; ++n) {
                            this.vData[n2][n3][n] = dArray[n3][n][n2];
                        }
                    }
                }
            }
            bl = true;
            System.out.println("vData transposed to match the dimensions of the xData and zData");
        }
        if (!bl) {
            throw new IllegalArgumentException("The lengths of the x, y, and z data arrays, " + this.nPointsX + ", " + this.nPointsY + " and " + this.nPointsZ + ", do not match the dimensions of the z data matrix, " + n6 + ", " + n5 + " and " + n4);
        }
        if (!this.arbprec) {
            int n8;
            this.xBDdata = new BigDecimal[this.nPointsX];
            this.yBDdata = new BigDecimal[this.nPointsY];
            this.zBDdata = new BigDecimal[this.nPointsZ];
            for (n8 = 0; n8 < this.nPointsX; ++n8) {
                this.xBDdata[n8] = new BigDecimal(new Double(this.xData[n8]).toString());
            }
            for (n8 = 0; n8 < this.nPointsY; ++n8) {
                this.yBDdata[n8] = new BigDecimal(new Double(this.yData[n8]).toString());
            }
            for (n8 = 0; n8 < this.nPointsZ; ++n8) {
                this.zBDdata[n8] = new BigDecimal(new Double(this.zData[n8]).toString());
            }
        }
    }

    private double[][][] copy3D(double[][][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray[0][0].length;
        double[][][] dArray2 = new double[n][n2][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    dArray2[i][j][k] = dArray[i][j][k];
                }
            }
        }
        return dArray2;
    }

    private void ascend() {
        int n;
        int n2;
        int n3;
        BigDecimal[][][] bigDecimalArray;
        BigDecimal[] bigDecimalArray2;
        double[][][] dArray;
        double[] dArray2;
        int[] nArray;
        ArrayMaths arrayMaths;
        boolean bl = true;
        boolean bl2 = true;
        int n4 = 1;
        while (bl) {
            if (this.zData[n4] < this.zData[n4 - 1]) {
                bl = false;
                bl2 = false;
                continue;
            }
            if (++n4 < this.nPointsZ) continue;
            bl = false;
        }
        if (!bl2) {
            arrayMaths = new ArrayMaths(this.zData);
            arrayMaths = arrayMaths.sort();
            nArray = arrayMaths.originalIndices();
            dArray2 = new double[this.nPointsZ];
            dArray = new double[this.nPointsZ][this.nPointsY][this.nPointsX];
            bigDecimalArray2 = new BigDecimal[this.nPointsZ];
            bigDecimalArray = null;
            if (this.arbprec) {
                bigDecimalArray = new BigDecimal[this.nPointsZ][this.nPointsY][this.nPointsX];
            }
            for (n3 = 0; n3 < this.nPointsZ; ++n3) {
                dArray2[n3] = this.zData[nArray[n3]];
                bigDecimalArray2[n3] = this.zBDdata[nArray[n3]];
                for (n2 = 0; n2 < this.nPointsY; ++n2) {
                    for (n = 0; n < this.nPointsX; ++n) {
                        dArray[n3][n2][n] = this.vData[nArray[n3]][n2][n];
                        if (!this.arbprec) continue;
                        bigDecimalArray[n3][n2][n] = this.vBDdata[nArray[n3]][n2][n];
                    }
                }
            }
            for (n3 = 0; n3 < this.nPointsZ; ++n3) {
                this.zData[n3] = dArray2[n3];
                this.zBDdata[n3] = bigDecimalArray2[n3];
                for (n2 = 0; n2 < this.nPointsY; ++n2) {
                    for (n = 0; n < this.nPointsX; ++n) {
                        this.vData[n3][n2][n] = dArray[n3][n2][n];
                        if (!this.arbprec) continue;
                        this.vBDdata[n3][n2][n] = bigDecimalArray[n3][n2][n];
                    }
                }
            }
        }
        bl = true;
        bl2 = true;
        n4 = 1;
        while (bl) {
            if (this.yData[n4] < this.yData[n4 - 1]) {
                bl = false;
                bl2 = false;
                continue;
            }
            if (++n4 < this.nPointsY) continue;
            bl = false;
        }
        if (!bl2) {
            arrayMaths = new ArrayMaths(this.yData);
            arrayMaths = arrayMaths.sort();
            nArray = arrayMaths.originalIndices();
            dArray2 = new double[this.nPointsY];
            dArray = new double[this.nPointsZ][this.nPointsY][this.nPointsX];
            bigDecimalArray2 = new BigDecimal[this.nPointsY];
            bigDecimalArray = null;
            if (this.arbprec) {
                bigDecimalArray = new BigDecimal[this.nPointsZ][this.nPointsY][this.nPointsX];
            }
            for (n3 = 0; n3 < this.nPointsY; ++n3) {
                dArray2[n3] = this.yData[nArray[n3]];
                bigDecimalArray2[n3] = this.yBDdata[nArray[n3]];
                for (n2 = 0; n2 < this.nPointsZ; ++n2) {
                    for (n = 0; n < this.nPointsX; ++n) {
                        dArray[n2][n3][n] = this.vData[n2][nArray[n3]][n];
                        if (!this.arbprec) continue;
                        bigDecimalArray[n2][n3][n] = this.vBDdata[n2][nArray[n3]][n];
                    }
                }
            }
            for (n3 = 0; n3 < this.nPointsY; ++n3) {
                this.yData[n3] = dArray2[n3];
                this.yBDdata[n3] = bigDecimalArray2[n3];
                for (n2 = 0; n2 < this.nPointsZ; ++n2) {
                    for (n = 0; n < this.nPointsX; ++n) {
                        this.vData[n2][n3][n] = dArray[n2][n3][n];
                        if (!this.arbprec) continue;
                        this.vBDdata[n2][n3][n] = bigDecimalArray[n2][n3][n];
                    }
                }
            }
        }
        bl = true;
        bl2 = true;
        n4 = 1;
        while (bl) {
            if (this.xData[n4] < this.xData[n4 - 1]) {
                bl = false;
                bl2 = false;
                continue;
            }
            if (++n4 < this.nPointsX) continue;
            bl = false;
        }
        if (!bl2) {
            arrayMaths = new ArrayMaths(this.xData);
            arrayMaths = arrayMaths.sort();
            nArray = arrayMaths.originalIndices();
            dArray2 = new double[this.nPointsX];
            dArray = new double[this.nPointsZ][this.nPointsY][this.nPointsX];
            bigDecimalArray2 = new BigDecimal[this.nPointsX];
            bigDecimalArray = null;
            if (this.arbprec) {
                bigDecimalArray = new BigDecimal[this.nPointsZ][this.nPointsY][this.nPointsX];
            }
            for (n3 = 0; n3 < this.nPointsX; ++n3) {
                dArray2[n3] = this.xData[nArray[n3]];
                bigDecimalArray2[n3] = this.xBDdata[nArray[n3]];
                for (n2 = 0; n2 < this.nPointsZ; ++n2) {
                    for (n = 0; n < this.nPointsY; ++n) {
                        dArray[n2][n][nArray[n3]] = this.vData[n2][n][nArray[n3]];
                        if (!this.arbprec) continue;
                        bigDecimalArray[n2][n][nArray[n3]] = this.vBDdata[n2][n][nArray[n3]];
                    }
                }
            }
            for (n3 = 0; n3 < this.nPointsX; ++n3) {
                this.xData[n3] = dArray2[n3];
                this.xBDdata[n3] = bigDecimalArray2[n3];
                for (n2 = 0; n2 < this.nPointsZ; ++n2) {
                    for (n = 0; n < this.nPointsY; ++n) {
                        this.vData[n2][n][n3] = dArray[n2][n][n3];
                        if (!this.arbprec) continue;
                        this.vBDdata[n2][n][n3] = bigDecimalArray[n2][n][n3];
                    }
                }
            }
        }
    }

    public double[][][] movingAverage(int n, int n2, int n3) {
        this.lastMethod = 1;
        this.vDataMovAv = new double[this.nPointsZ][this.nPointsY][this.nPointsX];
        this.vDataMovAvBD = new BigDecimal[this.nPointsZ][this.nPointsY][this.nPointsX];
        this.maWindowWidthx = this.windowLength(n);
        int n4 = (this.maWindowWidthx - 1) / 2;
        this.maWindowWidthy = this.windowLength(n2);
        int n5 = (this.maWindowWidthy - 1) / 2;
        this.maWindowWidthz = this.windowLength(n3);
        int n6 = (this.maWindowWidthz - 1) / 2;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        for (int i = 0; i < this.nPointsX; ++i) {
            n7 = i >= n4 ? i - n4 : 0;
            n8 = i <= this.nPointsX - n4 - 1 ? i + n4 : this.nPointsX - 1;
            int n13 = n8 - n7 + 1;
            for (int j = 0; j < this.nPointsY; ++j) {
                n9 = j >= n5 ? j - n5 : 0;
                n10 = j <= this.nPointsY - n5 - 1 ? j + n5 : this.nPointsY - 1;
                int n14 = n10 - n9 + 1;
                for (int k = 0; k < this.nPointsZ; ++k) {
                    int n15;
                    n11 = k >= n6 ? k - n6 : 0;
                    n12 = k <= this.nPointsZ - n5 - 1 ? k + n6 : this.nPointsZ - 1;
                    int n16 = n12 - n11 + 1;
                    if (this.arbprec) {
                        BigDecimal bigDecimal = new BigDecimal("0.0");
                        for (int i2 = n7; i2 <= n8; ++i2) {
                            for (int i3 = n9; i3 <= n10; ++i3) {
                                for (n15 = n11; n15 <= n12; ++n15) {
                                    bigDecimal = bigDecimal.add(this.vBDdata[n15][i3][i2]);
                                }
                            }
                        }
                        String string = new Integer(n13 * n14 + n16).toString();
                        this.vDataMovAvBD[k][j][i] = bigDecimal.divide(new BigDecimal(string), 4);
                        this.vDataMovAv[k][j][i] = this.vDataMovAvBD[k][j][i].doubleValue();
                        continue;
                    }
                    double d = 0.0;
                    for (int i4 = n7; i4 <= n8; ++i4) {
                        for (n15 = n9; n15 <= n10; ++n15) {
                            for (int i5 = n11; i5 <= n12; ++i5) {
                                d += this.vData[i5][n15][i4];
                            }
                        }
                    }
                    this.vDataMovAv[k][j][i] = d / (double)(n13 * n14 * n16);
                    String string = new Double(this.vDataMovAv[k][j][i]).toString();
                    this.vDataMovAvBD[k][j][i] = new BigDecimal(string);
                }
            }
        }
        this.tcsMovAv = new TriCubicSpline(this.zData, this.yData, this.xData, this.vDataMovAv);
        this.calcMovAv = true;
        return Conv.copy(this.vDataMovAv);
    }

    public double[][][] movingAverage(int n) {
        return this.movingAverage(n, n, n);
    }

    public BigDecimal[][][] movingAverageAsBigDecimal(int n, int n2, int n3) {
        this.movingAverage(n, n2, n);
        return Conv.copy(this.vDataMovAvBD);
    }

    public BigDecimal[][][] movingAverageAsBigDecimal(int n) {
        this.movingAverage(n, n, n);
        return Conv.copy(this.vDataMovAvBD);
    }

    private int windowLength(int n) {
        int n2 = 0;
        n2 = Fmath.isEven(n) ? n + 1 : n;
        return n2;
    }

    public double[][][] savitzkyGolay(int n, int n2, int n3) {
        this.lastMethod = 2;
        this.vDataSavGol = new double[this.nPointsZ][this.nPointsY][this.nPointsX];
        this.sgWindowWidthx = this.windowLength(n);
        this.sgWindowWidthy = this.windowLength(n2);
        this.sgWindowWidthz = this.windowLength(n3);
        this.savitzkyGolayCommon(this.sgWindowWidthx, this.sgWindowWidthy, this.sgWindowWidthz);
        this.tcsSavGol = new TriCubicSpline(this.zData, this.yData, this.xData, Conv.copy(this.vDataSavGol));
        this.calcSavGol = true;
        return Conv.copy(this.vDataSavGol);
    }

    public double[][][] savitzkyGolay(int n) {
        return this.savitzkyGolay(n, n, n);
    }

    private double[][][] savitzkyGolayCommon(int n, int n2, int n3) {
        int n4 = (n - 1) / 2;
        int n5 = (n2 - 1) / 2;
        int n6 = (n3 - 1) / 2;
        double[] dArray = this.savitzkyGolayFilter(n4, n4, n5, n5, n6, n6)[0];
        double[][][] dArray2 = this.padData(this.vData, n4, n5, n6);
        for (int i = n6; i < this.nPointsZ + n6; ++i) {
            for (int j = n5; j < this.nPointsY + n5; ++j) {
                for (int k = n4; k < this.nPointsX + n4; ++k) {
                    double d = 0.0;
                    int n7 = 0;
                    for (int i2 = i - n6; i2 <= i + n6; ++i2) {
                        for (int i3 = j - n5; i3 <= j + n5; ++i3) {
                            for (int i4 = k - n4; i4 <= k + n4; ++i4) {
                                d += dArray2[i2][i3][i4] * dArray[n7++];
                            }
                        }
                    }
                    this.vDataSavGol[i - n6][j - n5][k - n4] = d;
                }
            }
        }
        return this.vDataSavGol;
    }

    private double[][][] padData(double[][][] dArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = dArray.length;
        int n8 = dArray[0].length;
        int n9 = dArray[0][0].length;
        double[][][] dArray2 = new double[n7 + 2 * n3][n8 + 2 * n2][n9 + 2 * n];
        for (n6 = 0; n6 < n7; ++n6) {
            for (n5 = 0; n5 < n8; ++n5) {
                for (n4 = 0; n4 < n9; ++n4) {
                    dArray2[n6 + n3][n5 + n2][n4 + n] = dArray[n6][n5][n4];
                }
            }
        }
        for (n6 = 0; n6 < n; ++n6) {
            for (n5 = n2; n5 < n8 + n2; ++n5) {
                for (n4 = n3; n4 < n7 + n3; ++n4) {
                    dArray2[n4][n5][n6] = dArray2[n4][n5][n];
                }
            }
        }
        for (n6 = n9 + n; n6 < n9 + 2 * n; ++n6) {
            for (n5 = n2; n5 < n8 + n2; ++n5) {
                for (n4 = n3; n4 < n7 + n3; ++n4) {
                    dArray2[n4][n5][n6] = dArray2[n4][n5][n9 + n - 1];
                }
            }
        }
        for (n6 = 0; n6 < n2; ++n6) {
            for (n5 = n; n5 < n9 + n; ++n5) {
                for (n4 = n3; n4 < n7 + n3; ++n4) {
                    dArray2[n4][n6][n5] = dArray2[n4][n2][n5];
                }
            }
        }
        for (n6 = n8 + n2; n6 < n8 + 2 * n2; ++n6) {
            for (n5 = n; n5 < n9 + n; ++n5) {
                for (n4 = n3; n4 < n7 + n3; ++n4) {
                    dArray2[n4][n6][n5] = dArray2[n4][n8 + n2 - 1][n5];
                }
            }
        }
        for (n6 = 0; n6 < n3; ++n6) {
            for (n5 = n; n5 < n9 + n; ++n5) {
                for (n4 = n2; n4 < n8 + n2; ++n4) {
                    dArray2[n6][n4][n5] = dArray2[n3][n4][n5];
                }
            }
        }
        for (n6 = n7 + n3; n6 < n7 + 2 * n3; ++n6) {
            for (n5 = n; n5 < n9 + n; ++n5) {
                for (n4 = n2; n4 < n8 + n2; ++n4) {
                    dArray2[n6][n4][n5] = dArray2[n7 + n3 - 1][n4][n5];
                }
            }
        }
        for (n6 = 0; n6 < n3; ++n6) {
            for (n5 = 0; n5 < n2; ++n5) {
                for (n4 = 0; n4 < n; ++n4) {
                    dArray2[n6][n5][n4] = dArray2[n3][n2][n];
                }
            }
        }
        for (n6 = n7 + n3; n6 < n7 + 2 * n3; ++n6) {
            for (n5 = 0; n5 < n2; ++n5) {
                for (n4 = 0; n4 < n; ++n4) {
                    dArray2[n6][n5][n4] = dArray2[n7 + n3 - 1][n2][n];
                }
            }
        }
        for (n6 = 0; n6 < n3; ++n6) {
            for (n5 = n8 + n2; n5 < n8 + 2 * n2; ++n5) {
                for (n4 = 0; n4 < n; ++n4) {
                    dArray2[n6][n5][n4] = dArray2[n3][n8 + n2 - 1][n];
                }
            }
        }
        for (n6 = 0; n6 < n3; ++n6) {
            for (n5 = 0; n5 < n2; ++n5) {
                for (n4 = n9 + n; n4 < n9 + 2 * n; ++n4) {
                    dArray2[n6][n5][n4] = dArray2[n3][n2][n9 + n - 1];
                }
            }
        }
        for (n6 = n7 + n3; n6 < n7 + 2 * n3; ++n6) {
            for (n5 = n8 + n2; n5 < n8 + 2 * n2; ++n5) {
                for (n4 = n9 + n; n4 < n9 + 2 * n; ++n4) {
                    dArray2[n6][n5][n4] = dArray2[n7 + n3][n8 + n2][n9 + n];
                }
            }
        }
        for (n6 = 0; n6 < n3; ++n6) {
            for (n5 = n8 + n2; n5 < n8 + 2 * n2; ++n5) {
                for (n4 = n9 + n; n4 < n9 + 2 * n; ++n4) {
                    dArray2[n6][n5][n4] = dArray2[n3][n8 + n2][n9 + n];
                }
            }
        }
        for (n6 = n7 + n3; n6 < n7 + 2 * n3; ++n6) {
            for (n5 = 0; n5 < n2; ++n5) {
                for (n4 = n9 + n; n4 < n9 + 2 * n; ++n4) {
                    dArray2[n6][n5][n4] = dArray2[n7 + n3][n2][n9 + n];
                }
            }
        }
        for (n6 = n7 + n3; n6 < n7 + 2 * n3; ++n6) {
            for (n5 = n8 + n2; n5 < n8 + 2 * n2; ++n5) {
                for (n4 = 0; n4 < n; ++n4) {
                    dArray2[n6][n5][n4] = dArray2[n7 + n3][n8 + n2][n];
                }
            }
        }
        return dArray2;
    }

    public double[][][][] savitzkyGolay(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 + n4 + n6 > this.sgPolyDeg) {
            throw new IllegalArgumentException("The sum of the derivative orders " + n4 + " plus " + n5 + " plus " + n6 + ", must be less than or equal to the polynomial degree, " + this.sgPolyDeg + ".");
        }
        this.lastMethod = 2;
        double[][][][] dArray = new double[2][this.nPointsZ][this.nPointsY][this.nPointsX];
        this.sgWindowWidthx = this.windowLength(n);
        int n7 = (this.sgWindowWidthx - 1) / 2;
        this.sgWindowWidthy = this.windowLength(n2);
        int n8 = (this.sgWindowWidthy - 1) / 2;
        this.sgWindowWidthz = this.windowLength(n3);
        int n9 = (this.sgWindowWidthz - 1) / 2;
        if (!this.calcSavGol) {
            this.savitzkyGolay(n, n2, n3);
        }
        dArray[0] = this.vDataSavGol;
        int n10 = 0;
        boolean bl = true;
        int n11 = this.sgCoeffIndices.length;
        while (bl) {
            if (this.sgCoeffIndices[n10][0] == n4 && this.sgCoeffIndices[n10][1] == n5) {
                bl = false;
            }
            if (++n10 < n11) continue;
            throw new IllegalArgumentException("It should not have been possible to reach this situation, m = " + n4 + ", n = " + n5);
        }
        double[] dArray2 = this.sgArrayC[n10];
        double[][][] dArray3 = this.padData(this.vData, n7, n8, n9);
        for (int i = n9; i < this.nPointsZ + n9; ++i) {
            for (int j = n8; j < this.nPointsY + n8; ++j) {
                for (int k = n7; k < this.nPointsX + n7; ++k) {
                    double d = 0.0;
                    int n12 = 0;
                    for (int i2 = i - n9; i2 <= i + n9; ++i2) {
                        for (int i3 = j - n8; i3 <= j + n8; ++i3) {
                            for (int i4 = k - n7; i4 <= k + n7; ++i4) {
                                d += dArray3[i2][i3][i4] * dArray2[n12++];
                            }
                        }
                    }
                    dArray[1][i - n9][j - n8][k - n7] = d;
                }
            }
        }
        this.derivSavGol = dArray[1];
        this.nthSet = true;
        return dArray;
    }

    public double[][] savitzkyGolayFilter(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9 = n + n2 + 1;
        int n10 = n3 + n4 + 1;
        int n11 = n5 + n6 + 1;
        int n12 = n9 * n10 * n11;
        double[] dArray = new double[n12];
        int[][] nArray = new int[n12][3];
        int n13 = 0;
        for (int i = 0; i < n9; ++i) {
            for (n8 = 0; n8 < n10; ++n8) {
                for (n7 = 0; n7 < n11; ++n7) {
                    nArray[n13][0] = i - n;
                    nArray[n13][1] = n8 - n3;
                    nArray[n13++][2] = n7 - n5;
                }
            }
        }
        double[][] dArray2 = new double[n12][this.nSGcoeff];
        for (n8 = 0; n8 < n12; ++n8) {
            for (n7 = 0; n7 < this.nSGcoeff; ++n7) {
                dArray2[n8][n7] = Math.pow(nArray[n8][0], this.sgCoeffIndices[n7][0]) * Math.pow(nArray[n8][1], this.sgCoeffIndices[n7][1]) * Math.pow(nArray[n8][2], this.sgCoeffIndices[n7][2]);
            }
        }
        Matrix matrix = new Matrix(dArray2);
        Matrix matrix2 = matrix.transpose();
        Matrix matrix3 = matrix2.times(matrix);
        Matrix matrix4 = matrix3.inverse();
        Matrix matrix5 = matrix4.times(matrix2);
        this.sgArrayC = matrix5.getArrayCopy();
        return this.sgArrayC;
    }

    public static double[][] savitzkyGolayFilter(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        ThreeDimensionalSmooth threeDimensionalSmooth = new ThreeDimensionalSmooth();
        threeDimensionalSmooth.setSGpolyDegree(n7);
        return threeDimensionalSmooth.savitzkyGolayFilter(n, n2, n3, n4, n5, n6);
    }

    public double[][] getSGcoefficients() {
        if (this.sgArrayC == null) {
            throw new IllegalArgumentException("No Savitzky-Golay coefficients have been calculated");
        }
        return this.sgArrayC;
    }

    public int[][] getSGPolyIndices() {
        return this.sgCoeffIndices;
    }

    public static int[][] filterIndices(int n) {
        ThreeDimensionalSmooth threeDimensionalSmooth = new ThreeDimensionalSmooth();
        threeDimensionalSmooth.setSGpolyDegree(n);
        return threeDimensionalSmooth.getSGPolyIndices();
    }

    public void setSGpolyDegree(int n) {
        this.sgPolyDeg = n;
        this.polyIndices();
    }

    public int getSGpolyDegree() {
        return this.sgPolyDeg;
    }

    public double[][][] getMovingAverageValues() {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        return Conv.copy(this.vDataMovAv);
    }

    public BigDecimal[][][] getMovingAverageValuesAsBigDecimal() {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        return Conv.copy(this.vDataMovAvBD);
    }

    public double[][][] getSavitzkyGolaySmoothedValues() {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        return Conv.copy(this.vDataSavGol);
    }

    public double[][][] getSavitzkyDerivatives() {
        if (!this.nthSet) {
            throw new IllegalArgumentException("No Savitzky-Golay derivative smoothing method has been called");
        }
        return Conv.copy(this.derivSavGol);
    }

    public double extentMovingAverage() {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        this.extentMovAv = this.extent(this.vData, this.vDataMovAv);
        return this.extentMovAv;
    }

    public double extentSavitzkyGolay() {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        this.extentSavGol = this.extent(this.vData, this.vDataSavGol);
        return this.extentSavGol;
    }

    private double extent(double[][][] dArray, double[][][] dArray2) {
        ArrayMaths arrayMaths = new ArrayMaths((Object[])dArray);
        double d = arrayMaths.getMinimum();
        double d2 = arrayMaths.getMaximum();
        double d3 = d2 - d;
        double d4 = 0.0;
        for (int i = 0; i < this.nPointsX; ++i) {
            for (int j = 0; j < this.nPointsY; ++j) {
                for (int k = 0; k < this.nPointsZ; ++k) {
                    d4 += Math.abs(dArray[k][j][i] - dArray2[k][j][i]) / d3;
                }
            }
        }
        return d4 /= (double)this.nPoints;
    }

    public double interpolateSavitzkyGolay(double d, double d2, double d3) {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        return this.tcsSavGol.interpolate(d3, d2, d);
    }

    public double interpolateMovingAverage(double d, double d2, double d3) {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        return this.tcsMovAv.interpolate(d3, d2, d);
    }

    public void plotSavitzkyGolayX(int n, int n2) {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        if (n >= this.nPointsY) {
            throw new IllegalArgumentException("The index, " + n + ", must be less than the number of y values, " + this.nPointsY);
        }
        if (n2 >= this.nPointsZ) {
            throw new IllegalArgumentException("The index, " + n2 + ", must be less than the number of y values, " + this.nPointsZ);
        }
        int n3 = 0;
        double d = Fmath.truncate(this.yData[n], this.trunc);
        double d2 = Fmath.truncate(this.zData[n2], this.trunc);
        this.commonPlot(n3, n, n2, d, d2);
    }

    public void plotSavitzkyGolayX(double d, double d2) {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        int n = 0;
        int n2 = this.findValue(this.yData, d);
        d = Fmath.truncate(this.yData[n2], this.trunc);
        int n3 = this.findValue(this.zData, d2);
        d2 = Fmath.truncate(this.zData[n3], this.trunc);
        this.commonPlot(n, n2, n3, d, d2);
    }

    public void plotSavitzkyGolayY(int n, int n2) {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        if (n2 >= this.nPointsZ) {
            throw new IllegalArgumentException("The index, " + n2 + ", must be less than the number of y values, " + this.nPointsZ);
        }
        if (n >= this.nPointsX) {
            throw new IllegalArgumentException("The index, " + n + ", must be less than the number of x values, " + this.nPointsX);
        }
        int n3 = 1;
        double d = Fmath.truncate(this.yData[n2], this.trunc);
        double d2 = Fmath.truncate(this.xData[n], this.trunc);
        this.commonPlot(n3, n, n2, d2, d);
    }

    public void plotSavitzkyGolayY(double d, double d2) {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        int n = 1;
        int n2 = this.findValue(this.xData, d);
        d = Fmath.truncate(this.xData[n2], this.trunc);
        int n3 = this.findValue(this.zData, d2);
        d2 = Fmath.truncate(this.zData[n3], this.trunc);
        this.commonPlot(n, n2, n3, d, d2);
    }

    public void plotSavitzkyGolayZ(int n, int n2) {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        if (n2 >= this.nPointsY) {
            throw new IllegalArgumentException("The index, " + n2 + ", must be less than the number of y values, " + this.nPointsY);
        }
        if (n >= this.nPointsX) {
            throw new IllegalArgumentException("The index, " + n + ", must be less than the number of x values, " + this.nPointsX);
        }
        int n3 = 2;
        double d = Fmath.truncate(this.yData[n2], this.trunc);
        double d2 = Fmath.truncate(this.xData[n], this.trunc);
        this.commonPlot(n3, n, n2, d2, d);
    }

    public void plotSavitzkyGolayZ(double d, double d2) {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        int n = 2;
        int n2 = this.findValue(this.xData, d);
        d = Fmath.truncate(this.xData[n2], this.trunc);
        int n3 = this.findValue(this.yData, d2);
        d2 = Fmath.truncate(this.yData[n3], this.trunc);
        this.commonPlot(n, n2, n3, d, d2);
    }

    public void plotMovingAverageX(int n, int n2) {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        if (n >= this.nPointsY) {
            throw new IllegalArgumentException("The index, " + n + ", must be less than the number of y values, " + this.nPointsY);
        }
        if (n2 >= this.nPointsZ) {
            throw new IllegalArgumentException("The index, " + n2 + ", must be less than the number of z values, " + this.nPointsZ);
        }
        int n3 = 3;
        double d = Fmath.truncate(this.yData[n], this.trunc);
        double d2 = Fmath.truncate(this.zData[n2], this.trunc);
        this.commonPlot(n3, n, n2, d, d2);
    }

    public void plotMovingAverageX(double d, double d2) {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        int n = 3;
        int n2 = this.findValue(this.yData, d);
        d = Fmath.truncate(this.yData[n2], this.trunc);
        int n3 = this.findValue(this.zData, d2);
        d2 = Fmath.truncate(this.zData[n3], this.trunc);
        this.commonPlot(n, n2, n3, d, d2);
    }

    public void plotMovingAverageY(int n, int n2) {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        if (n2 >= this.nPointsY) {
            throw new IllegalArgumentException("The index, " + n2 + ", must be less than the number of y values, " + this.nPointsZ);
        }
        if (n >= this.nPointsX) {
            throw new IllegalArgumentException("The index, " + n + ", must be less than the number of x values, " + this.nPointsX);
        }
        int n3 = 4;
        double d = Fmath.truncate(this.yData[n2], this.trunc);
        double d2 = Fmath.truncate(this.yData[n], this.trunc);
        this.commonPlot(n3, n, n2, d2, d);
    }

    public void plotMovingAverageY(double d, double d2) {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        int n = 4;
        int n2 = this.findValue(this.xData, d);
        d = Fmath.truncate(this.xData[n2], this.trunc);
        int n3 = this.findValue(this.zData, d2);
        d2 = Fmath.truncate(this.zData[n3], this.trunc);
        this.commonPlot(n, n2, n3, d, d2);
    }

    public void plotMovingAverageZ(int n, int n2) {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        if (n2 >= this.nPointsY) {
            throw new IllegalArgumentException("The index, " + n2 + ", must be less than the number of y values, " + this.nPointsY);
        }
        if (n >= this.nPointsX) {
            throw new IllegalArgumentException("The index, " + n + ", must be less than the number of x values, " + this.nPointsX);
        }
        int n3 = 5;
        double d = Fmath.truncate(this.yData[n2], this.trunc);
        double d2 = Fmath.truncate(this.yData[n], this.trunc);
        this.commonPlot(n3, n, n2, d2, d);
    }

    public void plotMovingAverageZ(double d, double d2) {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving avrage smoothing method has been called");
        }
        int n = 5;
        int n2 = this.findValue(this.xData, d);
        d = Fmath.truncate(this.xData[n2], this.trunc);
        int n3 = this.findValue(this.yData, d2);
        d2 = Fmath.truncate(this.yData[n3], this.trunc);
        this.commonPlot(n, n2, n3, d, d2);
    }

    private int findValue(double[] dArray, double d) {
        int n = dArray.length;
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            if (Fmath.isEqualWithinLimits(dArray[n2], d, Math.abs(d) * 0.001)) {
                bl = false;
                continue;
            }
            if (++n2 < n) continue;
            throw new IllegalArgumentException("The entered plot value, " + d + ",  must equal an entered data value");
        }
        return n2;
    }

    private void commonPlot(int n, int n2, int n3, double d, double d2) {
        String string = null;
        String string2 = null;
        String string3 = ",  Original data - circles,  Smoothed data - squares";
        String string4 = null;
        String string5 = null;
        int[] nArray = new int[]{0, this.nPointsX / 4, this.nPointsX / 2, 3 * this.nPointsX / 4, this.nPointsX - 1};
        int[] nArray2 = new int[]{0, this.nPointsY / 4, this.nPointsY / 2, 3 * this.nPointsY / 4, this.nPointsY - 1};
        int[] nArray3 = new int[]{0, this.nPointsZ / 4, this.nPointsZ / 2, 3 * this.nPointsZ / 4, this.nPointsZ - 1};
        double[][] dArrayArray = new double[8][];
        double[] dArray = new double[5];
        double[] dArray2 = new double[5];
        double[] dArray3 = new double[5];
        double[] dArray4 = new double[5];
        double[] dArray5 = new double[5];
        double[] dArray6 = new double[5];
        switch (n) {
            case 0: {
                int n4;
                string = "Savitzky-Golay smoothing with an x by y by z window of " + this.maWindowWidthx + " x " + this.maWindowWidthy + " x " + this.maWindowWidthz + " points";
                string2 = "Plot of v versus x values for a y value of " + d + " a z value of " + d2 + string3;
                string4 = "x values";
                string5 = "v values";
                dArrayArray[0] = this.xData;
                dArrayArray[1] = this.vData[n3][n2];
                dArrayArray[2] = this.xData;
                dArrayArray[3] = this.vDataSavGol[n3][n2];
                for (n4 = 0; n4 < 5; ++n4) {
                    dArray[n4] = this.xData[nArray[n4]];
                    dArray3[n4] = this.vData[n3][n2][nArray[n4]];
                    dArray2[n4] = this.xData[nArray[n4]];
                    dArray4[n4] = this.vDataSavGol[n3][n2][nArray[n4]];
                }
                break;
            }
            case 1: {
                int n4;
                string = "Savitzky-Golay smoothing with an x by y by z window of " + this.maWindowWidthx + " x " + this.maWindowWidthy + " x " + this.maWindowWidthz + " points";
                string2 = "Plot of v versus y values for a x value of " + d + " a z value of " + d2 + string3;
                string4 = "y values";
                string5 = "v values";
                dArrayArray[0] = this.yData;
                dArrayArray[2] = this.yData;
                dArrayArray[1] = new double[this.nPointsY];
                dArrayArray[3] = new double[this.nPointsY];
                for (n4 = 0; n4 < this.nPointsZ; ++n4) {
                    dArrayArray[1][n4] = this.vData[n3][n4][n2];
                    dArrayArray[3][n4] = this.vDataSavGol[n3][n4][n2];
                }
                for (n4 = 0; n4 < 5; ++n4) {
                    dArray[n4] = this.yData[nArray2[n4]];
                    dArray3[n4] = dArrayArray[1][nArray2[n4]];
                    dArray2[n4] = this.yData[nArray2[n4]];
                    dArray4[n4] = dArrayArray[3][nArray2[n4]];
                }
                break;
            }
            case 2: {
                int n4;
                string = "Savitzky-Golay smoothing with an x by y by z window of " + this.maWindowWidthx + " x " + this.maWindowWidthy + " x " + this.maWindowWidthz + " points";
                string2 = "Plot of v versus z values for a x value of " + d + " a y value of " + d2 + string3;
                string4 = "z values";
                string5 = "v values";
                dArrayArray[0] = this.zData;
                dArrayArray[2] = this.zData;
                dArrayArray[1] = new double[this.nPointsZ];
                dArrayArray[3] = new double[this.nPointsZ];
                for (n4 = 0; n4 < this.nPointsZ; ++n4) {
                    dArrayArray[1][n4] = this.vData[n4][n3][n2];
                    dArrayArray[3][n4] = this.vDataSavGol[n4][n3][n2];
                }
                for (n4 = 0; n4 < 5; ++n4) {
                    dArray[n4] = this.zData[nArray3[n4]];
                    dArray3[n4] = dArrayArray[1][nArray3[n4]];
                    dArray2[n4] = this.zData[nArray3[n4]];
                    dArray4[n4] = dArrayArray[3][nArray3[n4]];
                }
                break;
            }
            case 3: {
                int n4;
                string = "Moving average smoothing with an x by y by z window of " + this.maWindowWidthx + " x " + this.maWindowWidthy + " x " + this.maWindowWidthz + " points";
                string2 = "Plot of v versus x values for a y value of " + d + " a z value of " + d2 + string3;
                string4 = "x values";
                string5 = "v values";
                dArrayArray[0] = this.xData;
                dArrayArray[1] = this.vData[n3][n2];
                dArrayArray[2] = this.xData;
                dArrayArray[3] = this.vDataMovAv[n3][n2];
                for (n4 = 0; n4 < 5; ++n4) {
                    dArray[n4] = this.xData[nArray[n4]];
                    dArray3[n4] = this.vData[n3][n2][nArray[n4]];
                    dArray2[n4] = this.xData[nArray[n4]];
                    dArray4[n4] = this.vDataMovAv[n3][n2][nArray[n4]];
                }
                break;
            }
            case 4: {
                int n4;
                string = "Moving average smoothing with an x by y by z window of " + this.maWindowWidthx + " x " + this.maWindowWidthy + " x " + this.maWindowWidthz + " points";
                string2 = "Plot of v versus y values for a x value of " + d + " a z value of " + d2 + string3;
                string4 = "y values";
                string5 = "v values";
                dArrayArray[0] = this.yData;
                dArrayArray[2] = this.yData;
                dArrayArray[1] = new double[this.nPointsY];
                dArrayArray[3] = new double[this.nPointsY];
                for (n4 = 0; n4 < this.nPointsZ; ++n4) {
                    dArrayArray[1][n4] = this.vData[n3][n4][n2];
                    dArrayArray[3][n4] = this.vDataMovAv[n3][n4][n2];
                }
                for (n4 = 0; n4 < 5; ++n4) {
                    dArray[n4] = this.yData[nArray2[n4]];
                    dArray3[n4] = dArrayArray[1][nArray2[n4]];
                    dArray2[n4] = this.yData[nArray2[n4]];
                    dArray4[n4] = dArrayArray[3][nArray2[n4]];
                }
                break;
            }
            case 5: {
                int n4;
                string = "Moving average smoothing with an x by y by z window of " + this.maWindowWidthx + " x " + this.maWindowWidthy + " x " + this.maWindowWidthz + " points";
                string2 = "Plot of v versus z values for a x value of " + d + " a y value of " + d2 + string3;
                string4 = "z values";
                string5 = "v values";
                dArrayArray[0] = this.yData;
                dArrayArray[2] = this.yData;
                dArrayArray[1] = new double[this.nPointsZ];
                dArrayArray[3] = new double[this.nPointsZ];
                for (n4 = 0; n4 < this.nPointsZ; ++n4) {
                    dArrayArray[1][n4] = this.vData[n4][n3][n2];
                    dArrayArray[3][n4] = this.vDataMovAv[n4][n3][n2];
                }
                for (n4 = 0; n4 < 5; ++n4) {
                    dArray[n4] = this.yData[nArray2[n4]];
                    dArray3[n4] = dArrayArray[1][nArray2[n4]];
                    dArray2[n4] = this.yData[nArray2[n4]];
                    dArray4[n4] = dArrayArray[3][nArray2[n4]];
                }
                break;
            }
        }
        dArrayArray[4] = dArray;
        dArrayArray[5] = dArray3;
        dArrayArray[6] = dArray2;
        dArrayArray[7] = dArray4;
        PlotGraph plotGraph = new PlotGraph(dArrayArray);
        int[] nArray4 = new int[]{0, 0, 1, 2};
        int[] nArray5 = new int[]{3, 3, 0, 0};
        plotGraph.setPoint(nArray4);
        plotGraph.setLine(nArray5);
        plotGraph.setGraphTitle(string);
        plotGraph.setGraphTitle2(string2);
        plotGraph.setXaxisLegend(string4);
        plotGraph.setYaxisLegend(string5);
        plotGraph.plot();
    }
}

