/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.ChiSquareFunct;
import flanagan.analysis.CorrCoeff;
import flanagan.analysis.CorrCoeffFunct;
import flanagan.analysis.CrigFunct;
import flanagan.analysis.EngsetLoad;
import flanagan.analysis.EngsetProb;
import flanagan.analysis.ErlangBfunct;
import flanagan.analysis.ErlangCfunct;
import flanagan.analysis.FdistribtionFunct;
import flanagan.analysis.GaussianFunct;
import flanagan.analysis.InverseGammaFunct;
import flanagan.analysis.LogNormalThreeParFunct;
import flanagan.analysis.Regression;
import flanagan.analysis.StudentsTvalueFunct;
import flanagan.circuits.Phasor;
import flanagan.complex.Complex;
import flanagan.integration.Integration;
import flanagan.interpolation.CubicSpline;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.PsRandom;
import flanagan.plot.PlotGraph;
import flanagan.roots.RealRoot;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;

public class Stat
extends ArrayMaths {
    private boolean nFactorOptionI = false;
    private boolean nFactorOptionIstored = false;
    private boolean nFactorReset = false;
    private boolean nEffOptionI = true;
    private boolean nEffReset = false;
    private boolean weightingOptionI = true;
    private boolean weightingReset = false;
    private ArrayMaths amWeights = null;
    private boolean weightsSupplied = false;
    private ArrayList<Object> upperOutlierDetails = new ArrayList();
    private boolean upperDone = false;
    private ArrayList<Object> lowerOutlierDetails = new ArrayList();
    private boolean lowerDone = false;
    private static boolean nFactorOptionS = false;
    private static boolean nFactorOptionSstored = false;
    private static boolean nEffOptionS = true;
    private static boolean weightingOptionS = true;
    private static int cfMaxIter = 500;
    private static double cfTol = 1.0E-8;
    public static final double FPMIN = 1.0E-300;
    private static boolean igSupress = false;
    private static int lgfN = 6;
    private static double[] lgfCoeff = new double[]{1.000000000190015, 76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    private static double lgfGamma = 5.0;
    private static int igfiter = 1000;
    private static double igfeps = 1.0E-8;
    private static double histTol = 1.0001;

    public Stat() {
    }

    public Stat(double[] dArray) {
        super(dArray);
        this.convertToHighest();
    }

    public Stat(Double[] doubleArray) {
        super(doubleArray);
        this.convertToHighest();
    }

    public Stat(float[] fArray) {
        super(fArray);
        this.convertToHighest();
    }

    public Stat(Float[] floatArray) {
        super(floatArray);
        this.convertToHighest();
    }

    public Stat(long[] lArray) {
        super(lArray);
        this.convertToHighest();
    }

    public Stat(Long[] longArray) {
        super(longArray);
        this.convertToHighest();
    }

    public Stat(int[] nArray) {
        super(nArray);
        this.convertToHighest();
    }

    public Stat(Integer[] integerArray) {
        super(integerArray);
        this.convertToHighest();
    }

    public Stat(short[] sArray) {
        super(sArray);
        this.convertToHighest();
    }

    public Stat(Short[] shortArray) {
        super(shortArray);
        this.convertToHighest();
    }

    public Stat(byte[] byArray) {
        super(byArray);
        this.convertToHighest();
    }

    public Stat(Byte[] byteArray) {
        super(byteArray);
        this.convertToHighest();
    }

    public Stat(BigDecimal[] bigDecimalArray) {
        super(bigDecimalArray);
    }

    public Stat(BigInteger[] bigIntegerArray) {
        super(bigIntegerArray);
        this.convertToHighest();
    }

    public Stat(Complex[] complexArray) {
        super(complexArray);
        this.convertToHighest();
    }

    public Stat(Phasor[] phasorArray) {
        super(phasorArray);
        this.convertToHighest();
    }

    public Stat(String[] stringArray) {
        super(stringArray);
        this.convertToHighest();
    }

    public Stat(Object[] objectArray) {
        super(objectArray);
        this.convertToHighest();
    }

    public Stat(Vector<Object> vector) {
        super(vector);
        this.convertToHighest();
    }

    public Stat(ArrayList<Object> arrayList) {
        super(arrayList);
        this.convertToHighest();
    }

    @Override
    public void convertToHighest() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                Double[] doubleArray = this.getArray_as_Double();
                this.array.clear();
                for (int i = 0; i < this.length; ++i) {
                    this.array.add(doubleArray[i]);
                }
                double[] dArray = new double[this.length];
                for (int i = 0; i < this.length; ++i) {
                    dArray[i] = 1.0;
                }
                this.amWeights = new ArrayMaths(dArray);
                this.type = 1;
                break;
            }
            case 12: 
            case 13: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                this.array.clear();
                for (int i = 0; i < this.length; ++i) {
                    this.array.add(bigDecimalArray[i]);
                }
                BigDecimal[] bigDecimalArray2 = new BigDecimal[this.length];
                for (int i = 0; i < this.length; ++i) {
                    bigDecimalArray2[i] = BigDecimal.ONE;
                }
                this.amWeights = new ArrayMaths(bigDecimalArray2);
                this.type = 12;
                bigDecimalArray = null;
                break;
            }
            case 14: 
            case 15: {
                Complex[] complexArray = this.getArray_as_Complex();
                this.array.clear();
                for (int i = 0; i < this.length; ++i) {
                    this.array.add(complexArray[i]);
                }
                Complex[] complexArray2 = new Complex[this.length];
                for (int i = 0; i < this.length; ++i) {
                    complexArray2[i] = Complex.plusOne();
                }
                this.amWeights = new ArrayMaths(complexArray2);
                this.type = 14;
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
    }

    public void setWeightsToBigW() {
        this.weightingOptionI = false;
        this.weightingReset = true;
    }

    public void setWeightsToLittleW() {
        this.weightingOptionI = true;
        this.weightingReset = true;
    }

    public void setDenominatorToN() {
        this.nFactorOptionI = true;
        this.nFactorReset = true;
    }

    public void setDenominatorToNminusOne() {
        this.nFactorOptionI = false;
        this.nFactorReset = true;
    }

    public boolean getDenominatorOption() {
        return this.nFactorOptionI;
    }

    public void useEffectiveN() {
        this.nEffOptionI = true;
        this.nEffReset = true;
    }

    public void useTrueN() {
        this.nEffOptionI = false;
        this.nEffReset = true;
    }

    public double effectiveSampleNumber() {
        return this.effectiveSampleNumber_as_double();
    }

    public double effectiveSampleNumber_as_double() {
        boolean bl = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                d = Stat.effectiveSampleNumber(dArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d = Stat.effectiveSampleNumber(bigDecimalArray).doubleValue();
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = bl;
        return d;
    }

    public BigDecimal effectiveSampleNumber_as_BigDecimal() {
        boolean bl = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                bigDecimal = Stat.effectiveSampleNumber(bigDecimalArray);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = bl;
        return bigDecimal;
    }

    public Complex effectiveSampleNumber_as_Complex() {
        boolean bl = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        Complex complex = Complex.zero();
        switch (this.type) {
            case 1: 
            case 12: 
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                complex = Stat.effectiveSampleNumber(complexArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = bl;
        return complex;
    }

    public int trueSampleNumber() {
        return this.length;
    }

    public int trueSampleNumber_as_int() {
        return this.length;
    }

    public double trueSampleNumber_as_double() {
        return this.length;
    }

    public BigDecimal trueSampleNumber_as_BigDecimal() {
        return new BigDecimal(new Integer(this.length).toString());
    }

    public Complex trueSampleNumber_as_Complex() {
        return new Complex(this.length, 0.0);
    }

    public void convertBigWtoLittleW() {
        if (!this.weightsSupplied) {
            System.out.println("convertBigWtoLittleW: no weights have been supplied - all weights set to unity");
        } else {
            this.amWeights = this.amWeights.oneOverSqrt();
        }
    }

    public void setWeights(double[] dArray) {
        if (this.length != dArray.length) {
            throw new IllegalArgumentException("Length of weights array, " + dArray.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        this.convertWeights(arrayMaths);
        this.weightsSupplied = true;
    }

    public void setWeights(Double[] doubleArray) {
        if (this.length != doubleArray.length) {
            throw new IllegalArgumentException("Length of weights array, " + doubleArray.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths arrayMaths = new ArrayMaths(doubleArray);
        this.convertWeights(arrayMaths);
        this.weightsSupplied = true;
    }

    public void setWeights(float[] fArray) {
        if (this.length != fArray.length) {
            throw new IllegalArgumentException("Length of weights array, " + fArray.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths arrayMaths = new ArrayMaths(fArray);
        this.convertWeights(arrayMaths);
        this.weightsSupplied = true;
    }

    public void setWeights(Float[] floatArray) {
        if (this.length != floatArray.length) {
            throw new IllegalArgumentException("Length of weights array, " + floatArray.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths arrayMaths = new ArrayMaths(floatArray);
        this.convertWeights(arrayMaths);
        this.weightsSupplied = true;
    }

    public void setWeights(long[] lArray) {
        if (this.length != lArray.length) {
            throw new IllegalArgumentException("Length of weights array, " + lArray.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths arrayMaths = new ArrayMaths(lArray);
        this.convertWeights(arrayMaths);
        this.weightsSupplied = true;
    }

    public void setWeights(Long[] longArray) {
        if (this.length != longArray.length) {
            throw new IllegalArgumentException("Length of weights array, " + longArray.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths arrayMaths = new ArrayMaths(longArray);
        this.convertWeights(arrayMaths);
        this.weightsSupplied = true;
    }

    public void setWeights(int[] nArray) {
        if (this.length != nArray.length) {
            throw new IllegalArgumentException("Length of weights array, " + nArray.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths arrayMaths = new ArrayMaths(nArray);
        this.convertWeights(arrayMaths);
        this.weightsSupplied = true;
    }

    public void setWeights(Integer[] integerArray) {
        if (this.length != integerArray.length) {
            throw new IllegalArgumentException("Length of weights array, " + integerArray.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths arrayMaths = new ArrayMaths(integerArray);
        this.convertWeights(arrayMaths);
        this.weightsSupplied = true;
    }

    public void setWeights(short[] sArray) {
        if (this.length != sArray.length) {
            throw new IllegalArgumentException("Length of weights array, " + sArray.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths arrayMaths = new ArrayMaths(sArray);
        this.convertWeights(arrayMaths);
        this.weightsSupplied = true;
    }

    public void setWeights(Short[] shortArray) {
        if (this.length != shortArray.length) {
            throw new IllegalArgumentException("Length of weights array, " + shortArray.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths arrayMaths = new ArrayMaths(shortArray);
        this.convertWeights(arrayMaths);
        this.weightsSupplied = true;
    }

    public void setWeights(byte[] byArray) {
        if (this.length != byArray.length) {
            throw new IllegalArgumentException("Length of weights array, " + byArray.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths arrayMaths = new ArrayMaths(byArray);
        this.convertWeights(arrayMaths);
        this.weightsSupplied = true;
    }

    public void setWeights(Byte[] byteArray) {
        if (this.length != byteArray.length) {
            throw new IllegalArgumentException("Length of weights array, " + byteArray.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths arrayMaths = new ArrayMaths(byteArray);
        this.convertWeights(arrayMaths);
        this.weightsSupplied = true;
    }

    public void setWeights(BigDecimal[] bigDecimalArray) {
        if (this.length != bigDecimalArray.length) {
            throw new IllegalArgumentException("Length of weights array, " + bigDecimalArray.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray);
        this.convertWeights(arrayMaths);
        this.weightsSupplied = true;
    }

    public void setWeights(BigInteger[] bigIntegerArray) {
        if (this.length != bigIntegerArray.length) {
            throw new IllegalArgumentException("Length of weights array, " + bigIntegerArray.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        this.convertWeights(arrayMaths);
        this.weightsSupplied = true;
    }

    public void setWeights(Complex[] complexArray) {
        if (this.length != complexArray.length) {
            throw new IllegalArgumentException("Length of weights array, " + complexArray.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        this.convertWeights(arrayMaths);
        this.weightsSupplied = true;
    }

    public void setWeights(Phasor[] phasorArray) {
        if (this.length != phasorArray.length) {
            throw new IllegalArgumentException("Length of weights array, " + phasorArray.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths arrayMaths = new ArrayMaths(phasorArray);
        this.convertWeights(arrayMaths);
        this.weightsSupplied = true;
    }

    public void setWeights(Object[] objectArray) {
        if (this.length != objectArray.length) {
            throw new IllegalArgumentException("Length of weights array, " + objectArray.length + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths arrayMaths = new ArrayMaths(objectArray);
        this.convertWeights(arrayMaths);
        this.weightsSupplied = true;
    }

    public void setWeights(Vector<Object> vector) {
        if (this.length != vector.size()) {
            throw new IllegalArgumentException("Length of weights array, " + vector.size() + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths arrayMaths = new ArrayMaths(vector);
        this.convertWeights(arrayMaths);
        this.weightsSupplied = true;
    }

    public void setWeights(ArrayList<Object> arrayList) {
        if (this.length != arrayList.size()) {
            throw new IllegalArgumentException("Length of weights array, " + arrayList.size() + ", must be the same as the length of the instance internal array, " + this.length);
        }
        ArrayMaths arrayMaths = new ArrayMaths(arrayList);
        this.convertWeights(arrayMaths);
        this.weightsSupplied = true;
    }

    private void convertWeights(ArrayMaths arrayMaths) {
        block0 : switch (this.type) {
            case 1: {
                switch (arrayMaths.typeIndex()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        Double[] doubleArray = arrayMaths.getArray_as_Double();
                        this.amWeights = new ArrayMaths(doubleArray);
                        break block0;
                    }
                    case 12: 
                    case 13: {
                        BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                        for (int i = 0; i < this.length; ++i) {
                            this.array.add(bigDecimalArray[i]);
                        }
                        BigDecimal[] bigDecimalArray2 = arrayMaths.getArray_as_BigDecimal();
                        this.amWeights = new ArrayMaths(bigDecimalArray2);
                        bigDecimalArray = null;
                        bigDecimalArray2 = null;
                        break block0;
                    }
                    case 14: 
                    case 15: {
                        Complex[] complexArray = this.getArray_as_Complex();
                        for (int i = 0; i < this.length; ++i) {
                            this.array.add(complexArray[i]);
                        }
                        Complex[] complexArray2 = arrayMaths.getArray_as_Complex();
                        this.amWeights = new ArrayMaths(complexArray2);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
            case 12: {
                switch (arrayMaths.typeIndex()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        BigDecimal[] bigDecimalArray = arrayMaths.getArray_as_BigDecimal();
                        this.amWeights = new ArrayMaths(bigDecimalArray);
                        bigDecimalArray = null;
                        break block0;
                    }
                    case 12: 
                    case 13: {
                        BigDecimal[] bigDecimalArray = arrayMaths.getArray_as_BigDecimal();
                        this.amWeights = new ArrayMaths(bigDecimalArray);
                        bigDecimalArray = null;
                        break block0;
                    }
                    case 14: 
                    case 15: {
                        Complex[] complexArray = this.getArray_as_Complex();
                        for (int i = 0; i < this.length; ++i) {
                            this.array.add(complexArray[i]);
                        }
                        Complex[] complexArray3 = arrayMaths.getArray_as_Complex();
                        this.amWeights = new ArrayMaths(complexArray3);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int i = 0; i < this.length; ++i) {
                    this.array.add(complexArray[i]);
                }
                Complex[] complexArray4 = arrayMaths.getArray_as_Complex();
                this.amWeights = new ArrayMaths(complexArray4);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
    }

    public double mean() {
        return this.mean_as_double();
    }

    public double mean_as_double() {
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                for (int i = 0; i < this.length; ++i) {
                    d += dArray[i];
                }
                d /= (double)this.length;
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                BigDecimal bigDecimal = BigDecimal.ZERO;
                for (int i = 0; i < this.length; ++i) {
                    bigDecimal = bigDecimal.add(bigDecimalArray[i]);
                }
                bigDecimal = bigDecimal.divide(new BigDecimal((double)this.length), 4);
                d = bigDecimal.doubleValue();
                bigDecimalArray = null;
                bigDecimal = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d;
    }

    public BigDecimal mean_as_BigDecimal() {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                double d = 0.0;
                for (int i = 0; i < this.length; ++i) {
                    d += dArray[i];
                }
                bigDecimal = new BigDecimal(d /= (double)this.length);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                for (int i = 0; i < this.length; ++i) {
                    bigDecimal = bigDecimal.add(bigDecimalArray[i]);
                }
                bigDecimal = bigDecimal.divide(new BigDecimal((double)this.length), 4);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return bigDecimal;
    }

    public Complex mean_as_Complex() {
        Complex complex = Complex.zero();
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                double d = 0.0;
                for (int i = 0; i < this.length; ++i) {
                    d += dArray[i];
                }
                complex = new Complex(d /= (double)this.length);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                BigDecimal bigDecimal = BigDecimal.ZERO;
                for (int i = 0; i < this.length; ++i) {
                    bigDecimal = bigDecimal.add(bigDecimalArray[i]);
                }
                bigDecimal = bigDecimal.divide(new BigDecimal((double)this.length), 4);
                complex = new Complex(bigDecimal.doubleValue());
                bigDecimalArray = null;
                bigDecimal = null;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int i = 0; i < this.length; ++i) {
                    complex = complex.plus(complexArray[i]);
                }
                complex = complex.over(new Complex(this.length));
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return complex;
    }

    public double weightedMean() {
        return this.weightedMean_as_double();
    }

    public double weightedMean_as_double() {
        if (!this.weightsSupplied) {
            System.out.println("weightedMean_as_double: no weights supplied - unweighted mean returned");
            return this.mean_as_double();
        }
        boolean bl = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                double[] dArray2 = this.amWeights.getArray_as_double();
                d = Stat.mean(dArray, dArray2);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                BigDecimal[] bigDecimalArray2 = this.amWeights.getArray_as_BigDecimal();
                d = Stat.mean(bigDecimalArray, bigDecimalArray2).doubleValue();
                bigDecimalArray = null;
                bigDecimalArray2 = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = bl;
        return d;
    }

    public BigDecimal weightedMean_as_BigDecimal() {
        if (!this.weightsSupplied) {
            System.out.println("weightedMean_as_BigDecimal: no weights supplied - unweighted mean returned");
            return this.mean_as_BigDecimal();
        }
        boolean bl = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                BigDecimal[] bigDecimalArray2 = this.amWeights.getArray_as_BigDecimal();
                bigDecimal = Stat.mean(bigDecimalArray, bigDecimalArray2);
                bigDecimalArray = null;
                bigDecimalArray2 = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = bl;
        return bigDecimal;
    }

    public Complex weightedMean_as_Complex() {
        if (!this.weightsSupplied) {
            System.out.println("weightedMean_as_Complex: no weights supplied - unweighted mean returned");
            return this.mean_as_Complex();
        }
        boolean bl = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        Complex complex = Complex.zero();
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                double[] dArray2 = this.amWeights.getArray_as_double();
                complex = new Complex(Stat.mean(dArray, dArray2));
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                BigDecimal[] bigDecimalArray2 = this.amWeights.getArray_as_BigDecimal();
                complex = new Complex(Stat.mean(bigDecimalArray, bigDecimalArray2).doubleValue());
                bigDecimalArray = null;
                bigDecimalArray2 = null;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                Complex[] complexArray2 = this.amWeights.getArray_as_Complex();
                complex = Stat.mean(complexArray, complexArray2);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = bl;
        return complex;
    }

    public double[] subtractMean() {
        return this.subtractMean_as_double();
    }

    public double[] subtractMean_as_double() {
        double[] dArray = new double[this.length];
        switch (this.type) {
            case 1: {
                double d = this.mean_as_double();
                ArrayMaths arrayMaths = this.minus(d);
                dArray = arrayMaths.getArray_as_double();
                break;
            }
            case 12: {
                BigDecimal bigDecimal = this.mean_as_BigDecimal();
                ArrayMaths arrayMaths = this.minus(bigDecimal);
                dArray = arrayMaths.getArray_as_double();
                bigDecimal = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return dArray;
    }

    public BigDecimal[] subtractMean_as_BigDecimal() {
        BigDecimal[] bigDecimalArray = new BigDecimal[this.length];
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal bigDecimal = this.mean_as_BigDecimal();
                ArrayMaths arrayMaths = this.minus(bigDecimal);
                bigDecimalArray = arrayMaths.getArray_as_BigDecimal();
                bigDecimal = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return bigDecimalArray;
    }

    public Complex[] subtractMean_as_Complex() {
        Complex[] complexArray = new Complex[this.length];
        switch (this.type) {
            case 1: {
                double d = this.mean_as_double();
                ArrayMaths arrayMaths = this.minus(d);
                complexArray = arrayMaths.getArray_as_Complex();
                break;
            }
            case 12: {
                BigDecimal bigDecimal = this.mean_as_BigDecimal();
                ArrayMaths arrayMaths = this.minus(bigDecimal);
                complexArray = arrayMaths.getArray_as_Complex();
                bigDecimal = null;
                break;
            }
            case 14: {
                Complex complex = this.mean_as_Complex();
                ArrayMaths arrayMaths = this.minus(complex);
                complexArray = arrayMaths.getArray_as_Complex();
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return complexArray;
    }

    public double[] subtractWeightedMean() {
        return this.subtractWeightedMean_as_double();
    }

    public double[] subtractWeightedMean_as_double() {
        if (!this.weightsSupplied) {
            System.out.println("subtractWeightedMean_as_double: no weights supplied - unweighted values returned");
            return this.subtractMean_as_double();
        }
        boolean bl = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double[] dArray = new double[this.length];
        switch (this.type) {
            case 1: {
                double d = this.weightedMean_as_double();
                ArrayMaths arrayMaths = this.minus(d);
                dArray = arrayMaths.getArray_as_double();
                break;
            }
            case 12: {
                BigDecimal bigDecimal = this.weightedMean_as_BigDecimal();
                ArrayMaths arrayMaths = this.minus(bigDecimal);
                dArray = arrayMaths.getArray_as_double();
                bigDecimal = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = bl;
        return dArray;
    }

    public BigDecimal[] subtractWeightedMean_as_BigDecimal() {
        if (!this.weightsSupplied) {
            System.out.println("subtractWeightedMean_as_BigDecimal: no weights supplied - unweighted values returned");
            return this.subtractMean_as_BigDecimal();
        }
        boolean bl = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        BigDecimal[] bigDecimalArray = new BigDecimal[this.length];
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal bigDecimal = this.weightedMean_as_BigDecimal();
                ArrayMaths arrayMaths = this.minus(bigDecimal);
                bigDecimalArray = arrayMaths.getArray_as_BigDecimal();
                bigDecimal = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = bl;
        return bigDecimalArray;
    }

    public Complex[] subtractWeightedMean_as_Complex() {
        if (!this.weightsSupplied) {
            System.out.println("subtractWeightedMean_as_Complex: no weights supplied - unweighted values returned");
            return this.subtractMean_as_Complex();
        }
        boolean bl = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        Complex[] complexArray = new Complex[this.length];
        switch (this.type) {
            case 1: {
                double d = this.weightedMean_as_double();
                ArrayMaths arrayMaths = this.minus(d);
                complexArray = arrayMaths.getArray_as_Complex();
                break;
            }
            case 12: {
                BigDecimal bigDecimal = this.weightedMean_as_BigDecimal();
                ArrayMaths arrayMaths = this.minus(bigDecimal);
                complexArray = arrayMaths.getArray_as_Complex();
                bigDecimal = null;
                break;
            }
            case 14: {
                Complex complex = this.weightedMean_as_Complex();
                ArrayMaths arrayMaths = this.minus(complex);
                complexArray = arrayMaths.getArray_as_Complex();
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = bl;
        return complexArray;
    }

    public double geometricMean() {
        return this.geometricMean_as_double();
    }

    public double geometricMean_as_double() {
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                d = Stat.geometricMean(dArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d = Stat.geometricMean(bigDecimalArray);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot  be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d;
    }

    public Complex geometricMean_as_Complex() {
        Complex complex = Complex.zero();
        switch (this.type) {
            case 1: 
            case 12: 
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                complex = Stat.geometricMean(complexArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return complex;
    }

    public double weightedGeometricMean() {
        return this.weightedGeometricMean_as_double();
    }

    public double weightedGeometricMean_as_double() {
        if (!this.weightsSupplied) {
            System.out.println("weightedGeometricMean_as_double: no weights supplied - unweighted value returned");
            return this.geometricMean_as_double();
        }
        boolean bl = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                double[] dArray2 = this.getArray_as_double();
                d = Stat.geometricMean(dArray, dArray2);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                BigDecimal[] bigDecimalArray2 = this.getArray_as_BigDecimal();
                d = Stat.geometricMean(bigDecimalArray, bigDecimalArray2);
                bigDecimalArray = null;
                bigDecimalArray2 = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot  be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = bl;
        return d;
    }

    public Complex weightedGeometricMean_as_Complex() {
        if (!this.weightsSupplied) {
            System.out.println("weightedGeometricMean_as_Complex: no weights supplied - unweighted value returned");
            return this.geometricMean_as_Complex();
        }
        boolean bl = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        Complex complex = Complex.zero();
        switch (this.type) {
            case 1: 
            case 12: 
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                Complex[] complexArray2 = this.getArray_as_Complex();
                complex = Stat.geometricMean(complexArray, complexArray2);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = bl;
        return complex;
    }

    public double harmonicMean() {
        return this.harmonicMean_as_double();
    }

    public double harmonicMean_as_double() {
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                d = Stat.harmonicMean(dArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d = Stat.harmonicMean(bigDecimalArray).doubleValue();
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d;
    }

    public BigDecimal harmonicMean_as_BigDecimal() {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                bigDecimal = Stat.harmonicMean(bigDecimalArray);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return bigDecimal;
    }

    public Complex harmonicMean_as_Complex() {
        Complex complex = Complex.zero();
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                complex = new Complex(Stat.harmonicMean(dArray));
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                complex = new Complex(Stat.harmonicMean(bigDecimalArray).doubleValue());
                bigDecimalArray = null;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                complex = Stat.harmonicMean(complexArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return complex;
    }

    public double weightedHarmonicMean() {
        return this.weightedHarmonicMean_as_double();
    }

    public double weightedHarmonicMean_as_double() {
        if (!this.weightsSupplied) {
            System.out.println("weightedHarmonicMean_as_double: no weights supplied - unweighted mean returned");
            return this.harmonicMean_as_double();
        }
        boolean bl = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                double[] dArray2 = this.amWeights.getArray_as_double();
                d = Stat.harmonicMean(dArray, dArray2);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                BigDecimal[] bigDecimalArray2 = this.amWeights.getArray_as_BigDecimal();
                d = Stat.harmonicMean(bigDecimalArray, bigDecimalArray2).doubleValue();
                bigDecimalArray = null;
                bigDecimalArray2 = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = bl;
        return d;
    }

    public BigDecimal weightedHarmonicMean_as_BigDecimal() {
        if (!this.weightsSupplied) {
            System.out.println("weightedHarmonicMean_as_BigDecimal: no weights supplied - unweighted mean returned");
            return this.harmonicMean_as_BigDecimal();
        }
        boolean bl = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                BigDecimal[] bigDecimalArray2 = this.amWeights.getArray_as_BigDecimal();
                bigDecimal = Stat.harmonicMean(bigDecimalArray, bigDecimalArray2);
                bigDecimalArray = null;
                bigDecimalArray2 = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = bl;
        return bigDecimal;
    }

    public Complex weightedHarmonicMean_as_Complex() {
        if (!this.weightsSupplied) {
            System.out.println("weightedHarmonicMean_as_Complex: no weights supplied - unweighted mean returned");
            return this.harmonicMean_as_Complex();
        }
        boolean bl = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        Complex complex = Complex.zero();
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                double[] dArray2 = this.amWeights.getArray_as_double();
                complex = new Complex(Stat.harmonicMean(dArray, dArray2));
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                BigDecimal[] bigDecimalArray2 = this.amWeights.getArray_as_BigDecimal();
                complex = new Complex(Stat.harmonicMean(bigDecimalArray, bigDecimalArray2).doubleValue());
                bigDecimalArray = null;
                bigDecimalArray2 = null;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                Complex[] complexArray2 = this.amWeights.getArray_as_Complex();
                complex = Stat.harmonicMean(complexArray, complexArray2);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = bl;
        return complex;
    }

    public double generalizedMean(double d) {
        return this.generalizedMean_as_double(d);
    }

    public double generalizedMean_as_double(double d) {
        double d2 = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                d2 = Stat.generalizedMean(dArray, d);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d2 = Stat.generalizedMean(bigDecimalArray, d);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d2;
    }

    public double generalizedMean(BigDecimal bigDecimal) {
        return this.generalizedMean_as_double(bigDecimal);
    }

    public double generalizedMean_as_double(BigDecimal bigDecimal) {
        double d = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d = Stat.generalizedMean(bigDecimalArray, bigDecimal);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d;
    }

    public Complex generalizedMean_as_Complex(double d) {
        Complex complex = Complex.zero();
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                complex = new Complex(Stat.generalizedMean(dArray, d));
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                complex = new Complex(Stat.generalizedMean(bigDecimalArray, d));
                bigDecimalArray = null;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                complex = Stat.generalizedMean(complexArray, d);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return complex;
    }

    public Complex generalizedMean_as_Complex(Complex complex) {
        Complex complex2 = Complex.zero();
        switch (this.type) {
            case 1: 
            case 12: 
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                complex2 = Stat.generalizedMean(complexArray, complex);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return complex2;
    }

    public double generalisedMean(double d) {
        return this.generalisedMean_as_double(d);
    }

    public double generalisedMean_as_double(double d) {
        double d2 = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                d2 = Stat.generalisedMean(dArray, d);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d2 = Stat.generalisedMean(bigDecimalArray, d);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d2;
    }

    public double generalisedMean(BigDecimal bigDecimal) {
        return this.generalisedMean_as_double(bigDecimal);
    }

    public double generalisedMean_as_double(BigDecimal bigDecimal) {
        double d = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d = Stat.generalisedMean(bigDecimalArray, bigDecimal);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d;
    }

    public Complex generalisedMean_as_Complex(double d) {
        Complex complex = Complex.zero();
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                complex = new Complex(Stat.generalisedMean(dArray, d));
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                complex = new Complex(Stat.generalisedMean(bigDecimalArray, d));
                bigDecimalArray = null;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                complex = Stat.generalisedMean(complexArray, d);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return complex;
    }

    public Complex generalisedMean_as_Complex(Complex complex) {
        Complex complex2 = Complex.zero();
        switch (this.type) {
            case 1: 
            case 12: 
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                complex2 = Stat.generalisedMean(complexArray, complex);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return complex2;
    }

    public double weightedGeneralizedMean(double d) {
        return this.weightedGeneralizedMean_as_double(d);
    }

    public double weightedGeneralizedMean_as_double(double d) {
        if (!this.weightsSupplied) {
            System.out.println("weightedGeneralizedMean_as_double: no weights supplied - unweighted mean returned");
            return this.generalizedMean_as_double(d);
        }
        boolean bl = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d2 = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                double[] dArray2 = this.amWeights.getArray_as_double();
                d2 = Stat.generalisedMean(dArray, dArray2, d);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                BigDecimal[] bigDecimalArray2 = this.amWeights.getArray_as_BigDecimal();
                d2 = Stat.generalisedMean(bigDecimalArray, bigDecimalArray2, d);
                bigDecimalArray = null;
                bigDecimalArray2 = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = bl;
        return d2;
    }

    public double weightedGeneralizedMean(BigDecimal bigDecimal) {
        return this.weightedGeneralizedMean_as_double(bigDecimal);
    }

    public double weightedGeneralizedMean_as_double(BigDecimal bigDecimal) {
        if (!this.weightsSupplied) {
            System.out.println("weightedGeneralizedMean_as_double: no weights supplied - unweighted mean returned");
            return this.generalizedMean_as_double(bigDecimal);
        }
        boolean bl = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                BigDecimal[] bigDecimalArray2 = this.amWeights.getArray_as_BigDecimal();
                d = Stat.generalisedMean(bigDecimalArray, bigDecimalArray2, bigDecimal);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = bl;
        return d;
    }

    public Complex weightedGeneralizedMean_as_Complex(double d) {
        if (!this.weightsSupplied) {
            System.out.println("weightedGeneralizedMean_as_Complex: no weights supplied - unweighted mean returned");
            return this.generalizedMean_as_Complex(d);
        }
        boolean bl = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        Complex complex = Complex.zero();
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                double[] dArray2 = this.amWeights.getArray_as_double();
                complex = new Complex(Stat.generalisedMean(dArray, dArray2, d));
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                BigDecimal[] bigDecimalArray2 = this.amWeights.getArray_as_BigDecimal();
                complex = new Complex(Stat.generalisedMean(bigDecimalArray, bigDecimalArray2, d));
                bigDecimalArray = null;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                Complex[] complexArray2 = this.amWeights.getArray_as_Complex();
                complex = Stat.generalisedMean(complexArray, complexArray2, d);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = bl;
        return complex;
    }

    public Complex weightedGeneralizedMean_as_Complex(Complex complex) {
        Complex complex2 = Complex.zero();
        if (!this.weightsSupplied) {
            System.out.println("weightedGeneralizedMean_as_dComplex: no weights supplied - unweighted mean returned");
            return this.generalizedMean_as_Complex(complex);
        }
        boolean bl = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        switch (this.type) {
            case 1: 
            case 12: 
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                Complex[] complexArray2 = this.amWeights.getArray_as_Complex();
                complex2 = Stat.generalisedMean(complexArray, complexArray2, complex);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = bl;
        return complex2;
    }

    public double weightedGeneralisedMean(double d) {
        return this.weightedGeneralizedMean_as_double(d);
    }

    public double weightedGeneralisedMean_as_double(double d) {
        return this.weightedGeneralizedMean_as_double(d);
    }

    public double weightedGeneralisedMean(BigDecimal bigDecimal) {
        return this.weightedGeneralizedMean_as_double(bigDecimal);
    }

    public double weightedGeneralisedMean_as_double(BigDecimal bigDecimal) {
        return this.weightedGeneralizedMean_as_double(bigDecimal);
    }

    public Complex weightedGeneralisedMean_as_Complex(double d) {
        return this.weightedGeneralizedMean_as_Complex(d);
    }

    public Complex weightedGeneralisedMean_as_Complex(Complex complex) {
        return this.weightedGeneralizedMean_as_Complex(complex);
    }

    public double interQuartileMean() {
        return this.interQuartileMean_as_double();
    }

    public double interQuartileMean_as_double() {
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                d = Stat.interQuartileMean(dArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d = Stat.interQuartileMean(bigDecimalArray).doubleValue();
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex interquartile mean is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d;
    }

    public BigDecimal interQuartileMean_as_BigDecimal() {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                bigDecimal = Stat.interQuartileMean(bigDecimalArray);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex interquartile mean is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return bigDecimal;
    }

    public double median() {
        return this.median_as_double();
    }

    public double median_as_double() {
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                d = Stat.median(dArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d = Stat.median(bigDecimalArray).doubleValue();
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex median value not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d;
    }

    public BigDecimal median_as_BigDecimal() {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                bigDecimal = Stat.median(bigDecimalArray);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex median value not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return bigDecimal;
    }

    public double rms() {
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                d = Stat.rms(dArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d = Stat.rms(bigDecimalArray);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex root mean square is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d;
    }

    public double weightedRms() {
        if (!this.weightsSupplied) {
            System.out.println("weightedRms: no weights supplied - unweighted rms returned");
            return this.rms();
        }
        boolean bl = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                double[] dArray2 = this.amWeights.getArray_as_double();
                d = Stat.rms(dArray, dArray2);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                BigDecimal[] bigDecimalArray2 = this.amWeights.getArray_as_BigDecimal();
                d = Stat.rms(bigDecimalArray, bigDecimalArray2);
                bigDecimalArray = null;
                bigDecimalArray2 = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex root mean square is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        weightingOptionS = bl;
        return d;
    }

    public double momentSkewness() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                d = Stat.momentSkewness(dArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d = Stat.momentSkewness(bigDecimalArray);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex skewness is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = bl;
        return d;
    }

    public double momentSkewness_as_double() {
        return this.momentSkewness();
    }

    public double medianSkewness() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                d = Stat.medianSkewness(dArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d = Stat.medianSkewness(bigDecimalArray);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex skewness is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = bl;
        return d;
    }

    public double medianSkewness_as_double() {
        return this.medianSkewness();
    }

    public double quartileSkewness() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                d = Stat.quartileSkewness(dArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d = Stat.quartileSkewness(bigDecimalArray).doubleValue();
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex skewness is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = bl;
        return d;
    }

    public double quartileSkewness_as_double() {
        return this.quartileSkewness();
    }

    public BigDecimal quartileSkewness_as_BigDecimal() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                bigDecimal = Stat.quartileSkewness(bigDecimalArray);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex skewness is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = bl;
        return bigDecimal;
    }

    public double kurtosis() {
        return this.kurtosis_as_double();
    }

    public double kurtosis_as_double() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                d = Stat.kurtosis(dArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d = Stat.kurtosis(bigDecimalArray).doubleValue();
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex kurtosis is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = bl;
        return d;
    }

    public double curtosis() {
        return this.kurtosis_as_double();
    }

    public double curtosis_as_double() {
        return this.kurtosis_as_double();
    }

    public double kurtosisExcess() {
        return this.kurtosisExcess_as_double();
    }

    public double excessKurtosis() {
        return this.kurtosisExcess_as_double();
    }

    public double excessCurtosis() {
        return this.kurtosisExcess_as_double();
    }

    public double kurtosisExcess_as_double() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                d = Stat.kurtosisExcess(dArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d = Stat.kurtosisExcess(bigDecimalArray).doubleValue();
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex kurtosis is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = bl;
        return d;
    }

    public double excessKurtosis_as_double() {
        return this.kurtosisExcess_as_double();
    }

    public double curtosisExcess() {
        return this.kurtosisExcess_as_double();
    }

    public double curtosisExcess_as_double() {
        return this.kurtosisExcess_as_double();
    }

    public double excessCurtosis_as_double() {
        return this.kurtosisExcess_as_double();
    }

    public BigDecimal kurtosis_as_BigDecimal() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                bigDecimal = Stat.kurtosis(bigDecimalArray);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex kurtosis is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = bl;
        return bigDecimal;
    }

    public BigDecimal curtosis_as_BigDecimal() {
        return this.kurtosis_as_BigDecimal();
    }

    public BigDecimal kurtosisExcess_as_BigDecimal() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                bigDecimal = Stat.kurtosisExcess(bigDecimalArray);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex kurtosis is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = bl;
        return bigDecimal;
    }

    public BigDecimal excessKurtosis_as_BigDecimal() {
        return this.kurtosisExcess_as_BigDecimal();
    }

    public BigDecimal curtosisExcess_as_BigDecimal() {
        return this.kurtosisExcess_as_BigDecimal();
    }

    public BigDecimal excessCurtosis_as_BigDecimal() {
        return this.kurtosisExcess_as_BigDecimal();
    }

    public double variance() {
        return this.variance_as_double();
    }

    public double variance_as_double() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                d = Stat.variance(dArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d = Stat.variance(bigDecimalArray).doubleValue();
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = bl;
        return d;
    }

    public BigDecimal variance_as_BigDecimal() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        switch (this.type) {
            case 1: 
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                bigDecimal = Stat.variance(bigDecimalArray);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = bl;
        return bigDecimal;
    }

    public Complex variance_as_Complex() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        Complex complex = Complex.zero();
        Complex[] complexArray = this.getArray_as_Complex();
        complex = Stat.variance(complexArray);
        nFactorOptionS = bl;
        return complex;
    }

    public double variance_as_Complex_ConjugateCalcn() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        Complex[] complexArray = this.getArray_as_Complex();
        double d = Stat.varianceConjugateCalcn(complexArray);
        nFactorOptionS = bl;
        return d;
    }

    public double variance_of_ComplexModuli() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double[] dArray = this.array_as_modulus_of_Complex();
        double d = Stat.variance(dArray);
        nFactorOptionS = bl;
        return d;
    }

    public double variance_of_ComplexRealParts() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double[] dArray = this.array_as_real_part_of_Complex();
        double d = Stat.variance(dArray);
        nFactorOptionS = bl;
        return d;
    }

    public double variance_of_ComplexImaginaryParts() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double[] dArray = this.array_as_imaginary_part_of_Complex();
        double d = Stat.variance(dArray);
        nFactorOptionS = bl;
        return d;
    }

    public double weightedVariance() {
        return this.weightedVariance_as_double();
    }

    public double weightedVariance_as_double() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean bl3 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedVariance_as_double: no weights supplied - unweighted value returned");
            d = this.variance_as_double();
        } else {
            double d2 = 0.0;
            switch (this.type) {
                case 1: {
                    double[] dArray = this.getArray_as_double();
                    double[] dArray2 = this.amWeights.getArray_as_double();
                    d2 = Stat.variance(dArray, dArray2);
                    break;
                }
                case 12: {
                    BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                    BigDecimal[] bigDecimalArray2 = this.amWeights.getArray_as_BigDecimal();
                    d2 = Stat.variance(bigDecimalArray, bigDecimalArray2).doubleValue();
                    bigDecimalArray = null;
                    bigDecimalArray2 = null;
                    break;
                }
                case 14: {
                    throw new IllegalArgumentException("Complex cannot be converted to double");
                }
                default: {
                    throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
                }
            }
            d = d2;
        }
        nFactorOptionS = bl;
        nEffOptionS = bl2;
        weightingOptionS = bl3;
        return d;
    }

    public BigDecimal weightedVariance_as_BigDecimal() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean bl3 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        if (!this.weightsSupplied) {
            System.out.println("weightedVariance_as_BigDecimal: no weights supplied - unweighted value returned");
            bigDecimal = this.variance_as_BigDecimal();
        } else {
            BigDecimal bigDecimal2 = BigDecimal.ZERO;
            switch (this.type) {
                case 1: 
                case 12: {
                    BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                    BigDecimal[] bigDecimalArray2 = this.amWeights.getArray_as_BigDecimal();
                    bigDecimal2 = Stat.variance(bigDecimalArray, bigDecimalArray2);
                    bigDecimalArray = null;
                    bigDecimalArray2 = null;
                    break;
                }
                case 14: {
                    throw new IllegalArgumentException("Complex cannot be converted to BigDecimal");
                }
                default: {
                    throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
                }
            }
            bigDecimal = bigDecimal2;
        }
        nFactorOptionS = bl;
        nEffOptionS = bl2;
        weightingOptionS = bl3;
        return bigDecimal;
    }

    public Complex weightedVariance_as_Complex() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean bl3 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        Complex complex = Complex.zero();
        if (!this.weightsSupplied) {
            System.out.println("weightedVariance_as_Complex: no weights supplied - unweighted value returned");
            complex = this.variance_as_Complex();
        } else {
            Complex complex2 = Complex.zero();
            Complex[] complexArray = this.getArray_as_Complex();
            Complex[] complexArray2 = this.amWeights.getArray_as_Complex();
            complex = complex2 = Stat.variance(complexArray, complexArray2);
        }
        nFactorOptionS = bl;
        nEffOptionS = bl2;
        weightingOptionS = bl3;
        return complex;
    }

    public double weightedVariance_as_Complex_ConjugateCalcn() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean bl3 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedVariance_as_Complex: no weights supplied - unweighted value returned");
            d = this.variance_as_Complex_ConjugateCalcn();
        } else {
            Complex[] complexArray = this.getArray_as_Complex();
            Complex[] complexArray2 = this.amWeights.getArray_as_Complex();
            d = Stat.varianceConjugateCalcn(complexArray, complexArray2);
        }
        nFactorOptionS = bl;
        nEffOptionS = bl2;
        weightingOptionS = bl3;
        return d;
    }

    public double weightedVariance_of_ComplexModuli() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean bl3 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedVariance_as_Complex: no weights supplied - unweighted value returned");
            d = this.variance_of_ComplexModuli();
        } else {
            double[] dArray = this.array_as_modulus_of_Complex();
            double[] dArray2 = this.amWeights.array_as_modulus_of_Complex();
            d = Stat.variance(dArray, dArray2);
        }
        nFactorOptionS = bl;
        nEffOptionS = bl2;
        weightingOptionS = bl3;
        return d;
    }

    public double weightedVariance_of_ComplexRealParts() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean bl3 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedVariance_as_Complex: no weights supplied - unweighted value returned");
            d = this.variance_of_ComplexRealParts();
        } else {
            double[] dArray = this.array_as_real_part_of_Complex();
            double[] dArray2 = this.amWeights.array_as_real_part_of_Complex();
            d = Stat.variance(dArray, dArray2);
        }
        nFactorOptionS = bl;
        nEffOptionS = bl2;
        weightingOptionS = bl3;
        return d;
    }

    public double weightedVariance_of_ComplexImaginaryParts() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean bl3 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedVariance_as_Complex: no weights supplied - unweighted value returned");
            d = this.variance_of_ComplexImaginaryParts();
        } else {
            double[] dArray = this.array_as_imaginary_part_of_Complex();
            double[] dArray2 = this.amWeights.array_as_imaginary_part_of_Complex();
            d = Stat.variance(dArray, dArray2);
        }
        nFactorOptionS = bl;
        nEffOptionS = bl2;
        weightingOptionS = bl3;
        return d;
    }

    public double standardDeviation() {
        return this.standardDeviation_as_double();
    }

    public double standardDeviation_as_double() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                d = Stat.variance(dArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d = Stat.variance(bigDecimalArray).doubleValue();
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = bl;
        return Math.sqrt(d);
    }

    public Complex standardDeviation_as_Complex() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        Complex complex = Complex.zero();
        Complex[] complexArray = this.getArray_as_Complex();
        complex = Stat.variance(complexArray);
        nFactorOptionS = bl;
        return Complex.sqrt(complex);
    }

    public double standardDeviation_as_Complex_ConjugateCalcn() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        Complex[] complexArray = this.getArray_as_Complex();
        double d = Stat.varianceConjugateCalcn(complexArray);
        nFactorOptionS = bl;
        return Math.sqrt(d);
    }

    public double standardDeviation_of_ComplexModuli() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double[] dArray = this.array_as_modulus_of_Complex();
        double d = Stat.standardDeviation(dArray);
        nFactorOptionS = bl;
        return d;
    }

    public double standardDeviation_of_ComplexRealParts() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double[] dArray = this.array_as_real_part_of_Complex();
        double d = Stat.standardDeviation(dArray);
        nFactorOptionS = bl;
        return d;
    }

    public double standardDeviation_of_ComplexImaginaryParts() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double[] dArray = this.array_as_imaginary_part_of_Complex();
        double d = Stat.standardDeviation(dArray);
        nFactorOptionS = bl;
        return d;
    }

    public double weightedStandardDeviation() {
        return this.weightedStandardDeviation_as_double();
    }

    public double weightedStandardDeviation_as_double() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = 0.0;
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardDeviation_as_double: no weights supplied - unweighted value returned");
            d = this.standardDeviation_as_double();
        } else {
            double d2 = 0.0;
            switch (this.type) {
                case 1: {
                    double[] dArray = this.getArray_as_double();
                    double[] dArray2 = this.amWeights.getArray_as_double();
                    d2 = Stat.variance(dArray, dArray2);
                    break;
                }
                case 12: {
                    BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                    BigDecimal[] bigDecimalArray2 = this.amWeights.getArray_as_BigDecimal();
                    d2 = Stat.variance(bigDecimalArray, bigDecimalArray2).doubleValue();
                    bigDecimalArray = null;
                    bigDecimalArray2 = null;
                    break;
                }
                case 14: {
                    throw new IllegalArgumentException("Complex cannot be converted to double");
                }
                default: {
                    throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
                }
            }
            d = Math.sqrt(d2);
        }
        nFactorOptionS = bl;
        weightingOptionS = bl2;
        return d;
    }

    public Complex weightedStandardDeviation_as_Complex() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        Complex complex = Complex.zero();
        if (!this.weightsSupplied) {
            System.out.println("weightedtandardDeviationS_as_Complex: no weights supplied - unweighted value returned");
            complex = this.standardDeviation_as_Complex();
        } else {
            Complex complex2 = Complex.zero();
            Complex[] complexArray = this.getArray_as_Complex();
            Complex[] complexArray2 = this.amWeights.getArray_as_Complex();
            complex2 = Stat.variance(complexArray, complexArray2);
            complex = Complex.sqrt(complex2);
        }
        nFactorOptionS = bl;
        weightingOptionS = bl2;
        return complex;
    }

    public double weightedStandardDeviation_as_Complex_ConjugateCalcn() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedtandardDeviationS_as_Complex: no weights supplied - unweighted value returned");
            d = this.standardDeviation_as_Complex_ConjugateCalcn();
        } else {
            double d2 = Double.NaN;
            Complex[] complexArray = this.getArray_as_Complex();
            Complex[] complexArray2 = this.amWeights.getArray_as_Complex();
            d2 = Stat.varianceConjugateCalcn(complexArray, complexArray2);
            d = Math.sqrt(d2);
        }
        nFactorOptionS = bl;
        weightingOptionS = bl2;
        return d;
    }

    public double weightedStandardDeviation_of_ComplexModuli() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean bl3 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardDeviation_as_Complex: no weights supplied - unweighted value returned");
            d = this.standardDeviation_of_ComplexModuli();
        } else {
            double[] dArray = this.array_as_modulus_of_Complex();
            double[] dArray2 = this.amWeights.array_as_modulus_of_Complex();
            d = Stat.standardDeviation(dArray, dArray2);
        }
        nFactorOptionS = bl;
        nEffOptionS = bl2;
        weightingOptionS = bl3;
        return d;
    }

    public double weightedStandardDeviation_of_ComplexRealParts() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean bl3 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardDeviation_as_Complex: no weights supplied - unweighted value returned");
            d = this.standardDeviation_of_ComplexRealParts();
        } else {
            double[] dArray = this.array_as_real_part_of_Complex();
            double[] dArray2 = this.amWeights.array_as_real_part_of_Complex();
            d = Stat.standardDeviation(dArray, dArray2);
        }
        nFactorOptionS = bl;
        nEffOptionS = bl2;
        weightingOptionS = bl3;
        return d;
    }

    public double weightedStandardDeviation_of_ComplexImaginaryParts() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean bl3 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardDeviation_as_Complex: no weights supplied - unweighted value returned");
            d = this.standardDeviation_of_ComplexImaginaryParts();
        } else {
            double[] dArray = this.array_as_imaginary_part_of_Complex();
            double[] dArray2 = this.amWeights.array_as_imaginary_part_of_Complex();
            d = Stat.standardDeviation(dArray, dArray2);
        }
        nFactorOptionS = bl;
        nEffOptionS = bl2;
        weightingOptionS = bl3;
        return d;
    }

    public double standardError() {
        return this.standardError_as_double();
    }

    public double standardError_as_double() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                d = Stat.standardError(dArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d = Stat.standardError(bigDecimalArray);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex cannot be converted to double");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = bl;
        return d;
    }

    public Complex standardError_as_Complex() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        Complex complex = Complex.zero();
        Complex[] complexArray = this.getArray_as_Complex();
        complex = Stat.standardError(complexArray);
        nFactorOptionS = bl;
        return complex;
    }

    public double standardError_as_Complex_ConjugateCalcn() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        Complex[] complexArray = this.getArray_as_Complex();
        double d = Stat.standardErrorConjugateCalcn(complexArray);
        nFactorOptionS = bl;
        return d;
    }

    public double standardError_of_ComplexModuli() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double[] dArray = this.array_as_modulus_of_Complex();
        double d = Stat.standardError(dArray);
        nFactorOptionS = bl;
        return d;
    }

    public double standardError_of_ComplexRealParts() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double[] dArray = this.array_as_real_part_of_Complex();
        double d = Stat.standardError(dArray);
        nFactorOptionS = bl;
        return d;
    }

    public double standardError_of_ComplexImaginaryParts() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double[] dArray = this.array_as_imaginary_part_of_Complex();
        double d = Stat.standardError(dArray);
        nFactorOptionS = bl;
        return d;
    }

    public double weightedStandardError() {
        return this.weightedStandardError_as_double();
    }

    public double weightedStandardError_as_double() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean bl3 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = 0.0;
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardError_as_double: no weights supplied - unweighted value returned");
            d = this.standardError_as_double();
        } else {
            switch (this.type) {
                case 1: {
                    double[] dArray = this.getArray_as_double();
                    double[] dArray2 = this.amWeights.getArray_as_double();
                    d = Stat.standardError(dArray, dArray2);
                    break;
                }
                case 12: {
                    BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                    BigDecimal[] bigDecimalArray2 = this.amWeights.getArray_as_BigDecimal();
                    d = Stat.standardError(bigDecimalArray, bigDecimalArray2);
                    bigDecimalArray = null;
                    bigDecimalArray2 = null;
                    break;
                }
                case 14: {
                    throw new IllegalArgumentException("Complex cannot be converted to double");
                }
                default: {
                    throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
                }
            }
            d = Math.sqrt(d);
        }
        nFactorOptionS = bl;
        nEffOptionS = bl2;
        weightingOptionS = bl3;
        return d;
    }

    public Complex weightedStandarError_as_Complex() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean bl3 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        Complex complex = Complex.zero();
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardError_as_Complex: no weights supplied - unweighted value returned");
            complex = this.standardError_as_Complex();
        } else {
            Complex[] complexArray = this.getArray_as_Complex();
            Complex[] complexArray2 = this.amWeights.getArray_as_Complex();
            complex = Stat.standardError(complexArray, complexArray2);
        }
        nFactorOptionS = bl;
        nEffOptionS = bl2;
        weightingOptionS = bl3;
        return complex;
    }

    public double weightedStandarError_as_Complex_ConjugateCalcn() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean bl3 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardError_as_Complex: no weights supplied - unweighted value returned");
            d = this.standardError_as_Complex_ConjugateCalcn();
        } else {
            Complex[] complexArray = this.getArray_as_Complex();
            Complex[] complexArray2 = this.amWeights.getArray_as_Complex();
            d = Stat.standardErrorConjugateCalcn(complexArray, complexArray2);
        }
        nFactorOptionS = bl;
        nEffOptionS = bl2;
        weightingOptionS = bl3;
        return d;
    }

    public double weightedStandardError_of_ComplexModuli() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean bl3 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardError_as_Complex: no weights supplied - unweighted value returned");
            d = this.standardError_of_ComplexModuli();
        } else {
            double[] dArray = this.array_as_modulus_of_Complex();
            double[] dArray2 = this.amWeights.array_as_modulus_of_Complex();
            d = Stat.standardError(dArray, dArray2);
        }
        nFactorOptionS = bl;
        nEffOptionS = bl2;
        weightingOptionS = bl3;
        return d;
    }

    public double weightedStandardError_of_ComplexRealParts() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean bl3 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardError_as_Complex: no weights supplied - unweighted value returned");
            d = this.standardError_of_ComplexRealParts();
        } else {
            double[] dArray = this.array_as_real_part_of_Complex();
            double[] dArray2 = this.amWeights.array_as_real_part_of_Complex();
            d = Stat.standardError(dArray, dArray2);
        }
        nFactorOptionS = bl;
        nEffOptionS = bl2;
        weightingOptionS = bl3;
        return d;
    }

    public double weightedStandardError_of_ComplexImaginaryParts() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = nEffOptionS;
        if (this.nEffReset) {
            nEffOptionS = this.nEffOptionI;
        }
        boolean bl3 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = Double.NaN;
        if (!this.weightsSupplied) {
            System.out.println("weightedStandardError_as_Complex: no weights supplied - unweighted value returned");
            d = this.standardError_of_ComplexImaginaryParts();
        } else {
            double[] dArray = this.array_as_imaginary_part_of_Complex();
            double[] dArray2 = this.amWeights.array_as_imaginary_part_of_Complex();
            d = Stat.standardError(dArray, dArray2);
        }
        nFactorOptionS = bl;
        nEffOptionS = bl2;
        weightingOptionS = bl3;
        return d;
    }

    public double[] standardize() {
        double[] dArray = null;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dArray2 = this.getArray_as_double();
                dArray = Stat.standardize(dArray2);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Standardisation of Complex is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return dArray;
    }

    public double[] standardise() {
        return this.standardize();
    }

    public double[] scale(double d, double d2) {
        double[] dArray = null;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dArray2 = this.getArray_as_double();
                dArray = Stat.scale(dArray2, d, d2);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Scaling of Complex is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return dArray;
    }

    public double volatilityLogChange() {
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                d = Stat.volatilityLogChange(dArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d = Stat.volatilityLogChange(bigDecimalArray);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex volatilty is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d;
    }

    public double volatilityPerCentChange() {
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                d = Stat.volatilityPerCentChange(dArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d = Stat.volatilityPerCentChange(bigDecimalArray);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex volatilty is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d;
    }

    public double coefficientOfVariation() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                d = Stat.coefficientOfVariation(dArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                d = Stat.coefficientOfVariation(bigDecimalArray);
                bigDecimalArray = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex coefficient of variation is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = bl;
        return d;
    }

    public double weightedCoefficientOfVariation() {
        boolean bl = nFactorOptionS;
        if (this.nFactorReset) {
            nFactorOptionS = this.nFactorOptionI;
        }
        boolean bl2 = weightingOptionS;
        if (this.weightingReset) {
            weightingOptionS = this.weightingOptionI;
        }
        double d = 0.0;
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                double[] dArray2 = this.amWeights.getArray_as_double();
                d = Stat.coefficientOfVariation(dArray, dArray2);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                BigDecimal[] bigDecimalArray2 = this.amWeights.getArray_as_BigDecimal();
                d = Stat.coefficientOfVariation(bigDecimalArray, bigDecimalArray2);
                bigDecimalArray = null;
                bigDecimalArray2 = null;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex coefficient of variation is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        nFactorOptionS = bl;
        weightingOptionS = bl2;
        return d;
    }

    public double shannonEntropy() {
        double d = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dArray = this.getArray_as_double();
                d = Stat.shannonEntropy(dArray);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Shannon Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d;
    }

    public double shannonEntropyBit() {
        double d = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dArray = this.getArray_as_double();
                d = Stat.shannonEntropy(dArray);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Shannon Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d;
    }

    public double shannonEntropyNat() {
        double d = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dArray = this.getArray_as_double();
                d = Stat.shannonEntropyNat(dArray);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Shannon Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d;
    }

    public double shannonEntropyDit() {
        double d = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dArray = this.getArray_as_double();
                d = Stat.shannonEntropyDit(dArray);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Shannon Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d;
    }

    public double renyiEntropy(double d) {
        double d2 = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dArray = this.getArray_as_double();
                d2 = Stat.renyiEntropy(dArray, d);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Renyi Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d2;
    }

    public double renyiEntropyBit(double d) {
        double d2 = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dArray = this.getArray_as_double();
                d2 = Stat.renyiEntropy(dArray, d);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Renyi Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d2;
    }

    public double renyiEntropyNat(double d) {
        double d2 = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dArray = this.getArray_as_double();
                d2 = Stat.renyiEntropyNat(dArray, d);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Renyi Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d2;
    }

    public double renyiEntropyDit(double d) {
        double d2 = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dArray = this.getArray_as_double();
                d2 = Stat.renyiEntropyDit(dArray, d);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Renyi Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d2;
    }

    public double tsallisEntropyNat(double d) {
        double d2 = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dArray = this.getArray_as_double();
                d2 = Stat.tsallisEntropyNat(dArray, d);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Tsallis Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d2;
    }

    public double generalizedEntropyOneNat(double d, double d2) {
        double d3 = 0.0;
        switch (this.type) {
            case 1: 
            case 12: {
                double[] dArray = this.getArray_as_double();
                d3 = Stat.generalizedEntropyOneNat(dArray, d, d2);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex Generalized Entropy is not meaningful");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        return d3;
    }

    public double generalisedEntropyOneNat(double d, double d2) {
        return this.generalizedEntropyOneNat(d, d2);
    }

    public ArrayList<Object> upperOutliersAnscombe(double d) {
        return this.upperOutliersAnscombe_as_double(d);
    }

    public ArrayList<Object> upperOutliersAnscombe_as_double(double d) {
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                this.upperOutlierDetails = Stat.upperOutliersAnscombeAsArrayList(dArray, d);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                ArrayList<Object> arrayList = new ArrayList();
                arrayList = Stat.upperOutliersAnscombeAsArrayList(bigDecimalArray, new BigDecimal(d));
                this.upperOutlierDetails.add((Integer)arrayList.get(0));
                BigDecimal[] bigDecimalArray2 = (BigDecimal[])arrayList.get(1);
                ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray2);
                this.upperOutlierDetails.add(arrayMaths.getArray_as_Double());
                this.upperOutlierDetails.add((int[])arrayList.get(2));
                BigDecimal[] bigDecimalArray3 = (BigDecimal[])arrayList.get(3);
                ArrayMaths arrayMaths2 = new ArrayMaths(bigDecimalArray3);
                this.upperOutlierDetails.add(arrayMaths2.getArray_as_Double());
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Outlier detection of Complex is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        this.upperDone = true;
        return this.upperOutlierDetails;
    }

    public ArrayList<Object> upperOutliersAnscombe(BigDecimal bigDecimal) {
        return this.upperOutliersAnscombe_as_BigDecimal(bigDecimal);
    }

    public ArrayList<Object> upperOutliersAnscombe_as_BigDecimal(BigDecimal bigDecimal) {
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                ArrayList<Object> arrayList = new ArrayList();
                arrayList = Stat.upperOutliersAnscombeAsArrayList(dArray, bigDecimal.doubleValue());
                this.upperOutlierDetails.add((Integer)arrayList.get(0));
                Double[] doubleArray = (Double[])arrayList.get(1);
                ArrayMaths arrayMaths = new ArrayMaths(doubleArray);
                this.upperOutlierDetails.add(arrayMaths.getArray_as_BigDecimal());
                this.upperOutlierDetails.add((int[])arrayList.get(2));
                Double[] doubleArray2 = (Double[])arrayList.get(3);
                ArrayMaths arrayMaths2 = new ArrayMaths(doubleArray2);
                this.upperOutlierDetails.add(arrayMaths2.getArray_as_BigDecimal());
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                this.upperOutlierDetails = Stat.upperOutliersAnscombeAsArrayList(bigDecimalArray, bigDecimal);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Outlier detection of Complex is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        this.upperDone = true;
        return this.upperOutlierDetails;
    }

    public ArrayList<Object> upperOutliersAnscombe(BigInteger bigInteger) {
        return this.upperOutliersAnscombe_as_BigDecimal(new BigDecimal(bigInteger));
    }

    public ArrayList<Object> upperOutliersAnscombe_as_BigDecimal(BigInteger bigInteger) {
        return this.upperOutliersAnscombe_as_BigDecimal(new BigDecimal(bigInteger));
    }

    public ArrayList<Object> lowerOutliersAnscombe(double d) {
        return this.lowerOutliersAnscombe_as_double(d);
    }

    public ArrayList<Object> lowerOutliersAnscombe_as_double(double d) {
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                this.lowerOutlierDetails = Stat.lowerOutliersAnscombeAsArrayList(dArray, d);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                ArrayList<Object> arrayList = new ArrayList();
                arrayList = Stat.lowerOutliersAnscombeAsArrayList(bigDecimalArray, new BigDecimal(d));
                this.lowerOutlierDetails.add((Integer)arrayList.get(0));
                BigDecimal[] bigDecimalArray2 = (BigDecimal[])arrayList.get(1);
                ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray2);
                this.lowerOutlierDetails.add(arrayMaths.getArray_as_Double());
                this.lowerOutlierDetails.add((int[])arrayList.get(2));
                BigDecimal[] bigDecimalArray3 = (BigDecimal[])arrayList.get(3);
                ArrayMaths arrayMaths2 = new ArrayMaths(bigDecimalArray3);
                this.lowerOutlierDetails.add(arrayMaths2.getArray_as_Double());
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Outlier detection of Complex is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        this.lowerDone = true;
        return this.lowerOutlierDetails;
    }

    public ArrayList<Object> lowerOutliersAnscombe(BigDecimal bigDecimal) {
        return this.lowerOutliersAnscombe_as_BigDecimal(bigDecimal);
    }

    public ArrayList<Object> lowerOutliersAnscombe_as_BigDecimal(BigDecimal bigDecimal) {
        switch (this.type) {
            case 1: {
                double[] dArray = this.getArray_as_double();
                ArrayList<Object> arrayList = new ArrayList();
                arrayList = Stat.lowerOutliersAnscombeAsArrayList(dArray, bigDecimal.doubleValue());
                this.lowerOutlierDetails.add((Integer)arrayList.get(0));
                Double[] doubleArray = (Double[])arrayList.get(1);
                ArrayMaths arrayMaths = new ArrayMaths(doubleArray);
                this.lowerOutlierDetails.add(arrayMaths.getArray_as_BigDecimal());
                this.lowerOutlierDetails.add((int[])arrayList.get(2));
                Double[] doubleArray2 = (Double[])arrayList.get(3);
                ArrayMaths arrayMaths2 = new ArrayMaths(doubleArray2);
                this.lowerOutlierDetails.add(arrayMaths2.getArray_as_BigDecimal());
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                this.lowerOutlierDetails = Stat.lowerOutliersAnscombeAsArrayList(bigDecimalArray, bigDecimal);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Outlier detection of Complex is not supported");
            }
            default: {
                throw new IllegalArgumentException("This type number, " + this.type + ", should not be possible here!!!!");
            }
        }
        this.lowerDone = true;
        return this.lowerOutlierDetails;
    }

    public ArrayList<Object> lowerOutliersAnscombe(BigInteger bigInteger) {
        return this.lowerOutliersAnscombe_as_BigDecimal(new BigDecimal(bigInteger));
    }

    public ArrayList<Object> lowerOutliersAnscombe_as_BigDecimal(BigInteger bigInteger) {
        return this.lowerOutliersAnscombe_as_BigDecimal(new BigDecimal(bigInteger));
    }

    public static void setStaticWeightsToBigW() {
        weightingOptionS = false;
    }

    public static void setStaticWeightsToLittleW() {
        weightingOptionS = true;
    }

    public static double[] convertBigWtoLittleW(double[] dArray) {
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        ArrayMaths arrayMaths2 = arrayMaths.oneOverSqrt();
        return arrayMaths2.getArray_as_double();
    }

    public static float[] convertBigWtoLittleW(float[] fArray) {
        ArrayMaths arrayMaths = new ArrayMaths(fArray);
        ArrayMaths arrayMaths2 = arrayMaths.oneOverSqrt();
        return arrayMaths2.getArray_as_float();
    }

    public static Complex[] convertBigWtoLittleW(Complex[] complexArray) {
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        ArrayMaths arrayMaths2 = arrayMaths.oneOverSqrt();
        return arrayMaths2.getArray_as_Complex();
    }

    public static double[] convertBigWtoLittleW(BigDecimal[] bigDecimalArray) {
        ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray);
        ArrayMaths arrayMaths2 = arrayMaths.oneOverSqrt();
        return arrayMaths2.getArray_as_double();
    }

    public static double[] convertBigWtoLittleW(BigInteger[] bigIntegerArray) {
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        ArrayMaths arrayMaths2 = arrayMaths.oneOverSqrt();
        return arrayMaths2.getArray_as_double();
    }

    private static double[] invertAndSquare(double[] dArray) {
        double[] dArray2 = Conv.copy(dArray);
        if (weightingOptionS) {
            ArrayMaths arrayMaths = new ArrayMaths(dArray);
            arrayMaths = arrayMaths.pow(2);
            arrayMaths = arrayMaths.invert();
            dArray2 = arrayMaths.array();
        }
        return dArray2;
    }

    private static float[] invertAndSquare(float[] fArray) {
        float[] fArray2 = Conv.copy(fArray);
        if (weightingOptionS) {
            ArrayMaths arrayMaths = new ArrayMaths(fArray);
            arrayMaths = arrayMaths.pow(2);
            arrayMaths = arrayMaths.invert();
            fArray2 = arrayMaths.array_as_float();
        }
        return fArray2;
    }

    private static Complex[] invertAndSquare(Complex[] complexArray) {
        Complex[] complexArray2 = Conv.copy(complexArray);
        if (weightingOptionS) {
            ArrayMaths arrayMaths = new ArrayMaths(complexArray);
            arrayMaths = arrayMaths.pow(2);
            arrayMaths = arrayMaths.invert();
            complexArray2 = arrayMaths.array_as_Complex();
        }
        return complexArray2;
    }

    private static BigDecimal[] invertAndSquare(BigDecimal[] bigDecimalArray) {
        BigDecimal[] bigDecimalArray2 = Conv.copy(bigDecimalArray);
        if (weightingOptionS) {
            ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray);
            arrayMaths = arrayMaths.pow(2);
            arrayMaths = arrayMaths.invert();
            bigDecimalArray2 = arrayMaths.array_as_BigDecimal();
        }
        return bigDecimalArray2;
    }

    private static BigDecimal[] invertAndSquare(BigInteger[] bigIntegerArray) {
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        BigDecimal[] bigDecimalArray = arrayMaths.array_as_BigDecimal();
        if (weightingOptionS) {
            arrayMaths = arrayMaths.pow(2);
            arrayMaths = arrayMaths.invert();
            bigDecimalArray = arrayMaths.array_as_BigDecimal();
        }
        return bigDecimalArray;
    }

    public static void setStaticDenominatorToN() {
        nFactorOptionS = true;
    }

    public static void setStaticDenominatorToNminusOne() {
        nFactorOptionS = false;
    }

    public static boolean getStaticDenominatorOption() {
        return nFactorOptionS;
    }

    public static void denominatorSwap() {
        nFactorOptionSstored = Stat.getStaticDenominatorOption();
        if (nFactorOptionSstored) {
            Stat.setStaticDenominatorToNminusOne();
        }
    }

    public static void denominatorUnswap() {
        nFactorOptionS = nFactorOptionSstored;
    }

    public static void useStaticEffectiveN() {
        nEffOptionS = true;
    }

    public static void useStaticTrueN() {
        nEffOptionS = false;
    }

    public static double effectiveSampleNumber(double[] dArray) {
        double[] dArray2 = Conv.copy(dArray);
        if (weightingOptionS) {
            ArrayMaths arrayMaths = new ArrayMaths(dArray);
            arrayMaths = arrayMaths.pow(2);
            arrayMaths = arrayMaths.invert();
            dArray2 = arrayMaths.array();
        }
        int n = dArray2.length;
        double d = n;
        if (nEffOptionS) {
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i = 0; i < n; ++i) {
                d2 += dArray2[i];
                d3 += dArray2[i] * dArray2[i];
            }
            d2 *= d2;
            d = d2 / d3;
        }
        return d;
    }

    public static float effectiveSampleNumber(float[] fArray) {
        float[] fArray2 = Conv.copy(fArray);
        if (weightingOptionS) {
            ArrayMaths arrayMaths = new ArrayMaths(fArray);
            arrayMaths = arrayMaths.pow(2);
            arrayMaths = arrayMaths.invert();
            fArray2 = arrayMaths.array_as_float();
        }
        int n = fArray2.length;
        float f = n;
        if (nEffOptionS) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            for (int i = 0; i < n; ++i) {
                f2 += fArray2[i];
                f3 += fArray2[i] * fArray2[i];
            }
            f2 *= f2;
            f = f2 / f3;
        }
        return f;
    }

    public static Complex effectiveSampleNumber(Complex[] complexArray) {
        Complex[] complexArray2 = Conv.copy(complexArray);
        if (weightingOptionS) {
            ArrayMaths arrayMaths = new ArrayMaths(complexArray);
            arrayMaths = arrayMaths.pow(2);
            arrayMaths = arrayMaths.invert();
            complexArray2 = arrayMaths.array_as_Complex();
        }
        int n = complexArray2.length;
        Complex complex = new Complex(n, 0.0);
        if (nEffOptionS) {
            Complex complex2 = Complex.zero();
            Complex complex3 = Complex.zero();
            for (int i = 0; i < n; ++i) {
                complex3 = complex3.plus(complexArray2[i]);
                complex2 = complex2.plus(complexArray2[i].times(complexArray2[i]));
            }
            complex3 = complex3.times(complex3);
            complex = complex3.over(complex2);
        }
        return complex;
    }

    public static double effectiveSampleNumberConjugateCalcn(Complex[] complexArray) {
        Complex[] complexArray2 = Conv.copy(complexArray);
        if (weightingOptionS) {
            ArrayMaths arrayMaths = new ArrayMaths(complexArray);
            arrayMaths = arrayMaths.pow(2);
            arrayMaths = arrayMaths.invert();
            complexArray2 = arrayMaths.array_as_Complex();
        }
        int n = complexArray2.length;
        double d = Double.NaN;
        if (nEffOptionS) {
            Complex complex = Complex.zero();
            Complex complex2 = Complex.zero();
            for (int i = 0; i < n; ++i) {
                complex2 = complex2.plus(complexArray2[i]);
                complex = complex.plus(complexArray2[i].times(complexArray2[i].conjugate()));
            }
            complex2 = complex2.times(complex2.conjugate());
            d = complex2.getReal() / complex.getReal();
        }
        return d;
    }

    public static BigDecimal effectiveSampleNumber(BigDecimal[] bigDecimalArray) {
        BigDecimal[] bigDecimalArray2 = Conv.copy(bigDecimalArray);
        if (weightingOptionS) {
            ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray);
            arrayMaths = arrayMaths.pow(2);
            arrayMaths = arrayMaths.invert();
            bigDecimalArray2 = arrayMaths.array_as_BigDecimal();
        }
        int n = bigDecimalArray2.length;
        BigDecimal bigDecimal = new BigDecimal(new Integer(n).toString());
        if (nEffOptionS) {
            BigDecimal bigDecimal2 = BigDecimal.ZERO;
            BigDecimal bigDecimal3 = BigDecimal.ZERO;
            for (int i = 0; i < n; ++i) {
                bigDecimal3 = bigDecimal3.add(bigDecimalArray2[i]);
                bigDecimal2 = bigDecimal2.add(bigDecimalArray2[i].multiply(bigDecimalArray2[i]));
            }
            bigDecimal3 = bigDecimal3.multiply(bigDecimal3);
            bigDecimal = bigDecimal3.divide(bigDecimal2, 4);
            bigDecimal2 = null;
            bigDecimal3 = null;
            bigDecimalArray2 = null;
        }
        return bigDecimal;
    }

    public static BigDecimal effectiveSampleNumber(BigInteger[] bigIntegerArray) {
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        BigDecimal[] bigDecimalArray = arrayMaths.array_as_BigDecimal();
        return Stat.effectiveSampleNumber(bigDecimalArray);
    }

    public static double mean(double[] dArray) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
        }
        return d / (double)n;
    }

    public static float mean(float[] fArray) {
        int n = fArray.length;
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            f += fArray[i];
        }
        return f / (float)n;
    }

    public static double mean(long[] lArray) {
        int n = lArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (double)lArray[i];
        }
        return d / (double)n;
    }

    public static double mean(int[] nArray) {
        int n = nArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (double)nArray[i];
        }
        return d / (double)n;
    }

    public static double mean(short[] sArray) {
        int n = sArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (double)sArray[i];
        }
        return d / (double)n;
    }

    public static double mean(byte[] byArray) {
        int n = byArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (double)byArray[i];
        }
        return d / (double)n;
    }

    public static Complex mean(Complex[] complexArray) {
        int n = complexArray.length;
        Complex complex = new Complex(0.0, 0.0);
        for (int i = 0; i < n; ++i) {
            complex = complex.plus(complexArray[i]);
        }
        return complex.over(n);
    }

    public static BigDecimal mean(BigDecimal[] bigDecimalArray) {
        int n = bigDecimalArray.length;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        for (int i = 0; i < n; ++i) {
            bigDecimal = bigDecimal.add(bigDecimalArray[i]);
        }
        return bigDecimal.divide(new BigDecimal((double)n), 4);
    }

    public static BigDecimal mean(BigInteger[] bigIntegerArray) {
        int n = bigIntegerArray.length;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        for (int i = 0; i < n; ++i) {
            bigDecimal2 = new BigDecimal(bigIntegerArray[i]);
            bigDecimal = bigDecimal.add(bigDecimal2);
        }
        bigDecimal2 = null;
        return bigDecimal.divide(new BigDecimal((double)n), 4);
    }

    public static double mean(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + dArray2.length + " are different");
        }
        double[] dArray3 = Conv.copy(dArray2);
        if (weightingOptionS) {
            ArrayMaths arrayMaths = new ArrayMaths(dArray2);
            arrayMaths = arrayMaths.pow(2);
            arrayMaths = arrayMaths.invert();
            dArray3 = arrayMaths.array();
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray3[i];
            d2 += dArray3[i];
        }
        return d / d2;
    }

    public static float mean(float[] fArray, float[] fArray2) {
        int n = fArray.length;
        if (n != fArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + fArray2.length + " are different");
        }
        float[] fArray3 = Conv.copy(fArray2);
        if (weightingOptionS) {
            ArrayMaths arrayMaths = new ArrayMaths(fArray2);
            arrayMaths = arrayMaths.pow(2);
            arrayMaths = arrayMaths.invert();
            fArray3 = arrayMaths.array_as_float();
        }
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            f += fArray[i] * fArray3[i];
            f2 += fArray3[i];
        }
        return f / f2;
    }

    public static Complex mean(Complex[] complexArray, Complex[] complexArray2) {
        Object object;
        int n = complexArray.length;
        if (n != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + complexArray2.length + " are different");
        }
        Complex[] complexArray3 = Conv.copy(complexArray2);
        if (weightingOptionS) {
            object = new ArrayMaths(complexArray2);
            object = ((ArrayMaths)object).pow(2);
            object = ((ArrayMaths)object).invert();
            complexArray3 = ((ArrayMaths)object).array_as_Complex();
        }
        object = Complex.zero();
        Complex complex = Complex.zero();
        for (int i = 0; i < n; ++i) {
            object = ((Complex)object).plus(complexArray[i].times(complexArray3[i]));
            complex = complex.plus(complexArray3[i]);
        }
        return ((Complex)object).over(complex);
    }

    public static BigDecimal mean(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2) {
        Object object;
        int n = bigDecimalArray.length;
        if (n != bigDecimalArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + bigDecimalArray2.length + " are different");
        }
        BigDecimal[] bigDecimalArray3 = Conv.copy(bigDecimalArray2);
        if (weightingOptionS) {
            object = new ArrayMaths(bigDecimalArray2);
            object = ((ArrayMaths)object).pow(2);
            object = ((ArrayMaths)object).invert();
            bigDecimalArray3 = ((ArrayMaths)object).array_as_BigDecimal();
        }
        object = BigDecimal.ZERO;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        for (int i = 0; i < n; ++i) {
            object = ((BigDecimal)object).add(bigDecimalArray[i].multiply(bigDecimalArray3[i]));
            bigDecimal = bigDecimal.add(bigDecimalArray3[i]);
        }
        object = ((BigDecimal)object).divide(bigDecimal, 4);
        bigDecimal = null;
        bigDecimalArray3 = null;
        return object;
    }

    public static BigDecimal mean(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        ArrayMaths arrayMaths2 = new ArrayMaths(bigIntegerArray2);
        return Stat.mean(arrayMaths.array_as_BigDecimal(), arrayMaths2.array_as_BigDecimal());
    }

    public static double[] subtractMean(double[] dArray) {
        int n = dArray.length;
        double d = Stat.mean(dArray);
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i] - d;
        }
        return dArray2;
    }

    public static float[] subtractMean(float[] fArray) {
        int n = fArray.length;
        float f = Stat.mean(fArray);
        float[] fArray2 = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray2[i] = fArray[i] - f;
        }
        return fArray2;
    }

    public static BigDecimal[] subtractMean(BigDecimal[] bigDecimalArray) {
        int n = bigDecimalArray.length;
        BigDecimal bigDecimal = Stat.mean(bigDecimalArray);
        BigDecimal[] bigDecimalArray2 = new BigDecimal[n];
        for (int i = 0; i < n; ++i) {
            bigDecimalArray2[i] = bigDecimalArray[i].subtract(bigDecimal);
        }
        bigDecimal = null;
        return bigDecimalArray2;
    }

    public static BigDecimal[] subtractMean(BigInteger[] bigIntegerArray) {
        int n = bigIntegerArray.length;
        BigDecimal bigDecimal = Stat.mean(bigIntegerArray);
        BigDecimal[] bigDecimalArray = new BigDecimal[n];
        for (int i = 0; i < n; ++i) {
            bigDecimalArray[i] = new BigDecimal(bigIntegerArray[i]).subtract(bigDecimal);
        }
        bigDecimal = null;
        return bigDecimalArray;
    }

    public static Complex[] subtractMean(Complex[] complexArray) {
        int n = complexArray.length;
        Complex complex = Stat.mean(complexArray);
        Complex[] complexArray2 = new Complex[n];
        for (int i = 0; i < n; ++i) {
            complexArray2[i] = complexArray[i].minus(complex);
        }
        return complexArray2;
    }

    public static double[] subtractMean(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double d = Stat.mean(dArray, dArray2);
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = dArray[i] - d;
        }
        return dArray3;
    }

    public static float[] subtractMean(float[] fArray, float[] fArray2) {
        int n = fArray.length;
        float f = Stat.mean(fArray, fArray2);
        float[] fArray3 = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray3[i] = fArray[i] - f;
        }
        return fArray3;
    }

    public static BigDecimal[] subtractMean(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2) {
        int n = bigDecimalArray.length;
        BigDecimal bigDecimal = Stat.mean(bigDecimalArray, bigDecimalArray2);
        BigDecimal[] bigDecimalArray3 = new BigDecimal[n];
        for (int i = 0; i < n; ++i) {
            bigDecimalArray3[i] = bigDecimalArray[i].subtract(bigDecimal);
        }
        bigDecimal = null;
        return bigDecimalArray3;
    }

    public static BigDecimal[] subtractMean(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        int n = bigIntegerArray.length;
        BigDecimal bigDecimal = Stat.mean(bigIntegerArray, bigIntegerArray2);
        BigDecimal[] bigDecimalArray = new BigDecimal[n];
        for (int i = 0; i < n; ++i) {
            bigDecimalArray[i] = new BigDecimal(bigIntegerArray[i]).subtract(bigDecimal);
        }
        bigDecimal = null;
        return bigDecimalArray;
    }

    public static Complex[] subtractMean(Complex[] complexArray, Complex[] complexArray2) {
        int n = complexArray.length;
        Complex complex = Stat.mean(complexArray, complexArray2);
        Complex[] complexArray3 = new Complex[n];
        for (int i = 0; i < n; ++i) {
            complexArray3[i] = complexArray[i].minus(complex);
        }
        return complexArray3;
    }

    public static double geometricMean(BigDecimal[] bigDecimalArray) {
        int n = bigDecimalArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += Math.log(bigDecimalArray[i].doubleValue());
        }
        return Math.exp(d / (double)n);
    }

    public static double geometricMean(BigInteger[] bigIntegerArray) {
        int n = bigIntegerArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += Math.log(bigIntegerArray[i].doubleValue());
        }
        return Math.exp(d / (double)n);
    }

    public static Complex geometricMean(Complex[] complexArray) {
        int n = complexArray.length;
        Complex complex = Complex.zero();
        for (int i = 0; i < n; ++i) {
            complex = complex.plus(Complex.log(complexArray[i]));
        }
        return Complex.exp(complex.over(n));
    }

    public static double geometricMean(double[] dArray) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += Math.log(dArray[i]);
        }
        return Math.exp(d / (double)n);
    }

    public static float geometricMean(float[] fArray) {
        int n = fArray.length;
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            f += (float)Math.log(fArray[i]);
        }
        return (float)Math.exp(f / (float)n);
    }

    public static Complex geometricMean(Complex[] complexArray, Complex[] complexArray2) {
        int n = complexArray.length;
        if (n != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + complexArray2.length + " are different");
        }
        Complex complex = Complex.zero();
        Complex[] complexArray3 = Stat.invertAndSquare(complexArray2);
        for (int i = 0; i < n; ++i) {
            complex = complex.plus(complexArray3[i]);
        }
        Complex complex2 = Complex.zero();
        for (int i = 0; i < n; ++i) {
            complex2 = complex2.plus(Complex.log(complexArray[i]).times(complexArray3[i]));
        }
        return Complex.exp(complex2.over(complex));
    }

    public static double geometricMean(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2) {
        int n = bigDecimalArray.length;
        if (n != bigDecimalArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + bigDecimalArray2.length + " are different");
        }
        ArrayMaths arrayMaths = new ArrayMaths(Stat.invertAndSquare(bigDecimalArray2));
        double[] dArray = arrayMaths.array();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
        }
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += Math.log(bigDecimalArray[i].doubleValue()) * dArray[i];
        }
        return Math.exp(d2 / d);
    }

    public static double geometricMean(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        ArrayMaths arrayMaths2 = new ArrayMaths(bigIntegerArray2);
        return Stat.geometricMean(arrayMaths.array_as_BigDecimal(), arrayMaths2.array_as_BigDecimal());
    }

    public static double geometricMean(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + dArray2.length + " are different");
        }
        double d = 0.0;
        double[] dArray3 = Stat.invertAndSquare(dArray2);
        for (int i = 0; i < n; ++i) {
            d += dArray3[i];
        }
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += Math.log(dArray[i]) * dArray3[i];
        }
        return Math.exp(d2 / d);
    }

    public static float geometricMean(float[] fArray, float[] fArray2) {
        int n = fArray.length;
        if (n != fArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + fArray2.length + " are different");
        }
        float f = 0.0f;
        float[] fArray3 = Stat.invertAndSquare(fArray2);
        for (int i = 0; i < n; ++i) {
            f += fArray3[i];
        }
        float f2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            f2 += (float)Math.log(fArray[i]) * fArray3[i];
        }
        return (float)Math.exp(f2 / f);
    }

    public static BigDecimal harmonicMean(BigDecimal[] bigDecimalArray) {
        int n = bigDecimalArray.length;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        for (int i = 0; i < n; ++i) {
            bigDecimal = bigDecimal.add(BigDecimal.ONE.divide(bigDecimalArray[i], 4));
        }
        bigDecimal = new BigDecimal((double)n).divide(bigDecimal, 4);
        return bigDecimal;
    }

    public static BigDecimal harmonicMean(BigInteger[] bigIntegerArray) {
        int n = bigIntegerArray.length;
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        BigDecimal[] bigDecimalArray = arrayMaths.getArray_as_BigDecimal();
        BigDecimal bigDecimal = BigDecimal.ZERO;
        for (int i = 0; i < n; ++i) {
            bigDecimal = bigDecimal.add(BigDecimal.ONE.divide(bigDecimalArray[i], 4));
        }
        bigDecimal = new BigDecimal((double)n).divide(bigDecimal, 4);
        bigDecimalArray = null;
        return bigDecimal;
    }

    public static Complex harmonicMean(Complex[] complexArray) {
        int n = complexArray.length;
        Complex complex = Complex.zero();
        for (int i = 0; i < n; ++i) {
            complex = complex.plus(Complex.plusOne().over(complexArray[i]));
        }
        complex = new Complex(n).over(complex);
        return complex;
    }

    public static double harmonicMean(double[] dArray) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += 1.0 / dArray[i];
        }
        return (double)n / d;
    }

    public static float harmonicMean(float[] fArray) {
        int n = fArray.length;
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            f += 1.0f / fArray[i];
        }
        return (float)n / f;
    }

    public static BigDecimal harmonicMean(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2) {
        int n;
        int n2 = bigDecimalArray.length;
        if (n2 != bigDecimalArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n2 + " and length of weight array, " + bigDecimalArray2.length + " are different");
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        BigDecimal[] bigDecimalArray3 = Stat.invertAndSquare(bigDecimalArray2);
        for (n = 0; n < n2; ++n) {
            bigDecimal2 = bigDecimal2.add(bigDecimalArray3[n]);
        }
        for (n = 0; n < n2; ++n) {
            bigDecimal = bigDecimal.add(bigDecimalArray3[n].divide(bigDecimalArray[n], 4));
        }
        bigDecimal = bigDecimal2.divide(bigDecimal, 4);
        bigDecimal2 = null;
        bigDecimalArray3 = null;
        return bigDecimal;
    }

    public static BigDecimal harmonicMean(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        int n = bigIntegerArray.length;
        if (n != bigIntegerArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + bigIntegerArray2.length + " are different");
        }
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        ArrayMaths arrayMaths2 = new ArrayMaths(bigIntegerArray2);
        return Stat.harmonicMean(arrayMaths.getArray_as_BigDecimal(), arrayMaths2.getArray_as_BigDecimal());
    }

    public static Complex harmonicMean(Complex[] complexArray, Complex[] complexArray2) {
        int n;
        int n2 = complexArray.length;
        if (n2 != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n2 + " and length of weight array, " + complexArray2.length + " are different");
        }
        Complex complex = Complex.zero();
        Complex complex2 = Complex.zero();
        Complex[] complexArray3 = Stat.invertAndSquare(complexArray2);
        for (n = 0; n < n2; ++n) {
            complex2 = complex2.plus(complexArray3[n]);
        }
        for (n = 0; n < n2; ++n) {
            complex = complex.plus(complexArray3[n].over(complexArray[n]));
        }
        return complex2.over(complex);
    }

    public static double harmonicMean(double[] dArray, double[] dArray2) {
        int n;
        int n2 = dArray.length;
        if (n2 != dArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n2 + " and length of weight array, " + dArray2.length + " are different");
        }
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray3 = Stat.invertAndSquare(dArray2);
        for (n = 0; n < n2; ++n) {
            d2 += dArray3[n];
        }
        for (n = 0; n < n2; ++n) {
            d += dArray3[n] / dArray[n];
        }
        return d2 / d;
    }

    public static float harmonicMean(float[] fArray, float[] fArray2) {
        int n;
        int n2 = fArray.length;
        if (n2 != fArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n2 + " and length of weight array, " + fArray2.length + " are different");
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float[] fArray3 = Stat.invertAndSquare(fArray2);
        for (n = 0; n < n2; ++n) {
            f2 += fArray3[n];
        }
        for (n = 0; n < n2; ++n) {
            f += fArray3[n] / fArray[n];
        }
        return f2 / f;
    }

    public static Complex generalizedMean(Complex[] complexArray, double d) {
        int n = complexArray.length;
        Complex complex = Complex.zero();
        if (d == 0.0) {
            for (int i = 0; i < n; ++i) {
                complex = complex.plus(Complex.log(complexArray[i]));
            }
            return Complex.exp(complex);
        }
        for (int i = 0; i < n; ++i) {
            complex = complex.plus(Complex.pow(complexArray[i], d));
        }
        return Complex.pow(complex.over(n), 1.0 / d);
    }

    public static Complex generalizedMean(Complex[] complexArray, Complex complex) {
        int n = complexArray.length;
        Complex complex2 = Complex.zero();
        if (complex.equals(Complex.zero())) {
            for (int i = 0; i < n; ++i) {
                complex2 = complex2.plus(Complex.log(complexArray[i]));
            }
            return Complex.exp(complex2);
        }
        for (int i = 0; i < n; ++i) {
            complex2 = complex2.plus(Complex.pow(complexArray[i], complex));
        }
        return Complex.pow(complex2.over(n), Complex.plusOne().over(complex));
    }

    public static double generalizedMean(BigDecimal[] bigDecimalArray, double d) {
        ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray);
        double[] dArray = arrayMaths.getArray_as_double();
        return Stat.generalizedMean(dArray, d);
    }

    public static double generalizedMean(BigDecimal[] bigDecimalArray, BigDecimal bigDecimal) {
        ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray);
        double[] dArray = arrayMaths.getArray_as_double();
        return Stat.generalizedMean(dArray, bigDecimal.doubleValue());
    }

    public static double generalizedMean(BigInteger[] bigIntegerArray, double d) {
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        double[] dArray = arrayMaths.getArray_as_double();
        return Stat.generalizedMean(dArray, d);
    }

    public static double generalizedMean(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        double[] dArray = arrayMaths.getArray_as_double();
        return Stat.generalizedMean(dArray, bigInteger.doubleValue());
    }

    public static double generalizedMean(double[] dArray, double d) {
        int n = dArray.length;
        double d2 = 0.0;
        if (d == 0.0) {
            for (int i = 0; i < n; ++i) {
                d2 += Math.log(dArray[i]);
            }
            return Math.exp(d2);
        }
        for (int i = 0; i < n; ++i) {
            d2 += Math.pow(dArray[i], d);
        }
        return Math.pow(d2 / (double)n, 1.0 / d);
    }

    public static float generalizedMean(float[] fArray, float f) {
        int n = fArray.length;
        float f2 = 0.0f;
        if (f == 0.0f) {
            for (int i = 0; i < n; ++i) {
                f2 += (float)Math.log(fArray[i]);
            }
            return (float)Math.exp(f2);
        }
        for (int i = 0; i < n; ++i) {
            f2 = (float)((double)f2 + Math.pow(fArray[i], f));
        }
        return (float)Math.pow(f2 / (float)n, 1.0f / f);
    }

    public static Complex generalisedMean(Complex[] complexArray, double d) {
        int n = complexArray.length;
        Complex complex = Complex.zero();
        if (d == 0.0) {
            for (int i = 0; i < n; ++i) {
                complex = complex.plus(Complex.log(complexArray[i]));
            }
            return Complex.exp(complex);
        }
        for (int i = 0; i < n; ++i) {
            complex = complex.plus(Complex.pow(complexArray[i], d));
        }
        return Complex.pow(complex.over(n), 1.0 / d);
    }

    public static Complex generalisedMean(Complex[] complexArray, Complex complex) {
        int n = complexArray.length;
        Complex complex2 = Complex.zero();
        if (complex.equals(Complex.zero())) {
            for (int i = 0; i < n; ++i) {
                complex2 = complex2.plus(Complex.log(complexArray[i]));
            }
            return Complex.exp(complex2);
        }
        for (int i = 0; i < n; ++i) {
            complex2 = complex2.plus(Complex.pow(complexArray[i], complex));
        }
        return Complex.pow(complex2.over(n), Complex.plusOne().over(complex));
    }

    public static double generalisedMean(BigDecimal[] bigDecimalArray, double d) {
        ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray);
        double[] dArray = arrayMaths.getArray_as_double();
        return Stat.generalisedMean(dArray, d);
    }

    public static double generalisedMean(BigDecimal[] bigDecimalArray, BigDecimal bigDecimal) {
        ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray);
        double[] dArray = arrayMaths.getArray_as_double();
        return Stat.generalisedMean(dArray, bigDecimal.doubleValue());
    }

    public static double generalisedMean(BigInteger[] bigIntegerArray, double d) {
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        double[] dArray = arrayMaths.getArray_as_double();
        return Stat.generalisedMean(dArray, d);
    }

    public static double generalisedMean(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        double[] dArray = arrayMaths.getArray_as_double();
        return Stat.generalisedMean(dArray, bigInteger.doubleValue());
    }

    public static double generalisedMean(double[] dArray, double d) {
        int n = dArray.length;
        double d2 = 0.0;
        if (d == 0.0) {
            for (int i = 0; i < n; ++i) {
                d2 += Math.log(dArray[i]);
            }
            return Math.exp(d2);
        }
        for (int i = 0; i < n; ++i) {
            d2 += Math.pow(dArray[i], d);
        }
        return Math.pow(d2 / (double)n, 1.0 / d);
    }

    public static float generalisedMean(float[] fArray, float f) {
        int n = fArray.length;
        float f2 = 0.0f;
        if (f == 0.0f) {
            for (int i = 0; i < n; ++i) {
                f2 += (float)Math.log(fArray[i]);
            }
            return (float)Math.exp(f2);
        }
        for (int i = 0; i < n; ++i) {
            f2 = (float)((double)f2 + Math.pow(fArray[i], f));
        }
        return (float)Math.pow(f2 / (float)n, 1.0f / f);
    }

    public static Complex generalisedMean(Complex[] complexArray, Complex[] complexArray2, double d) {
        int n;
        int n2 = complexArray.length;
        if (n2 != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n2 + " and length of weight array, " + complexArray2.length + " are different");
        }
        Complex complex = Complex.zero();
        Complex complex2 = Complex.zero();
        Complex[] complexArray3 = Stat.invertAndSquare(complexArray2);
        for (n = 0; n < n2; ++n) {
            complex2 = complex2.plus(complexArray3[n]);
        }
        if (d == 0.0) {
            for (n = 0; n < n2; ++n) {
                complex = complex.plus(Complex.log(complexArray3[n].times(complexArray[n])).over(complex2));
            }
            return Complex.exp(complex);
        }
        for (n = 0; n < n2; ++n) {
            complex = complex.plus(complexArray3[n].times(Complex.pow(complexArray[n], d)));
        }
        return Complex.pow(complex.over(complex2), 1.0 / d);
    }

    public static Complex generalisedMean(Complex[] complexArray, Complex[] complexArray2, Complex complex) {
        int n;
        int n2 = complexArray.length;
        if (n2 != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n2 + " and length of weight array, " + complexArray2.length + " are different");
        }
        Complex complex2 = Complex.zero();
        Complex complex3 = Complex.zero();
        Complex[] complexArray3 = Stat.invertAndSquare(complexArray2);
        for (n = 0; n < n2; ++n) {
            complex3 = complex3.plus(complexArray3[n]);
        }
        if (complex.equals(Complex.zero())) {
            for (n = 0; n < n2; ++n) {
                complex2 = complex2.plus(Complex.log(complexArray3[n].times(complexArray[n])).over(complex3));
            }
            return Complex.exp(complex2);
        }
        for (n = 0; n < n2; ++n) {
            complex2 = complex2.plus(complexArray3[n].times(Complex.pow(complexArray[n], complex)));
        }
        return Complex.pow(complex2.over(complex3), Complex.plusOne().over(complex));
    }

    public static double generalisedMean(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2, double d) {
        int n = bigDecimalArray.length;
        if (n != bigDecimalArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + bigDecimalArray2.length + " are different");
        }
        ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray);
        double[] dArray = arrayMaths.getArray_as_double();
        ArrayMaths arrayMaths2 = new ArrayMaths(bigDecimalArray2);
        double[] dArray2 = arrayMaths2.getArray_as_double();
        return Stat.generalisedMean(dArray, dArray2, d);
    }

    public static double generalisedMean(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2, BigDecimal bigDecimal) {
        int n = bigDecimalArray.length;
        if (n != bigDecimalArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + bigDecimalArray2.length + " are different");
        }
        ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray);
        double[] dArray = arrayMaths.getArray_as_double();
        ArrayMaths arrayMaths2 = new ArrayMaths(bigDecimalArray2);
        double[] dArray2 = arrayMaths2.getArray_as_double();
        return Stat.generalisedMean(dArray, dArray2, bigDecimal.doubleValue());
    }

    public static double generalisedMean(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2, double d) {
        int n = bigIntegerArray.length;
        if (n != bigIntegerArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + bigIntegerArray2.length + " are different");
        }
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        double[] dArray = arrayMaths.getArray_as_double();
        ArrayMaths arrayMaths2 = new ArrayMaths(bigIntegerArray2);
        double[] dArray2 = arrayMaths2.getArray_as_double();
        return Stat.generalisedMean(dArray, dArray2, d);
    }

    public static double generalisedMean(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2, BigInteger bigInteger) {
        int n = bigIntegerArray.length;
        if (n != bigIntegerArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + bigIntegerArray2.length + " are different");
        }
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        double[] dArray = arrayMaths.getArray_as_double();
        ArrayMaths arrayMaths2 = new ArrayMaths(bigIntegerArray2);
        double[] dArray2 = arrayMaths2.getArray_as_double();
        return Stat.generalisedMean(dArray, dArray2, bigInteger.doubleValue());
    }

    public static double generalisedMean(double[] dArray, double[] dArray2, double d) {
        int n;
        int n2 = dArray.length;
        if (n2 != dArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n2 + " and length of weight array, " + dArray2.length + " are different");
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray3 = Stat.invertAndSquare(dArray2);
        for (n = 0; n < n2; ++n) {
            d3 += dArray3[n];
        }
        if (d == 0.0) {
            for (n = 0; n < n2; ++n) {
                d2 += Math.log(dArray[n] * dArray3[n] / d3);
            }
            return Math.exp(d2);
        }
        for (n = 0; n < n2; ++n) {
            d2 += dArray3[n] * Math.pow(dArray[n], d);
        }
        return Math.pow(d2 / d3, 1.0 / d);
    }

    public static float generalisedMean(float[] fArray, float[] fArray2, float f) {
        int n;
        int n2 = fArray.length;
        if (n2 != fArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n2 + " and length of weight array, " + fArray2.length + " are different");
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float[] fArray3 = Stat.invertAndSquare(fArray2);
        for (n = 0; n < n2; ++n) {
            f3 += fArray3[n];
        }
        if (f == 0.0f) {
            for (n = 0; n < n2; ++n) {
                f2 += (float)Math.log(fArray[n]);
            }
            return (float)Math.exp(f2);
        }
        for (n = 0; n < n2; ++n) {
            f2 = (float)((double)f2 + Math.pow(fArray[n], f));
        }
        return (float)Math.pow(f2 / f3, 1.0f / f);
    }

    public static Complex weightedGeneralisedMean(Complex[] complexArray, Complex[] complexArray2, double d) {
        int n = complexArray.length;
        if (n != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + complexArray2.length + " are different");
        }
        return Stat.generalisedMean(complexArray, complexArray2, d);
    }

    public static Complex weightedGeneralisedMean(Complex[] complexArray, Complex[] complexArray2, Complex complex) {
        int n = complexArray.length;
        if (n != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + complexArray2.length + " are different");
        }
        return Stat.generalisedMean(complexArray, complexArray2, complex);
    }

    public static double weightedGeneralisedMean(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2, double d) {
        int n = bigDecimalArray.length;
        if (n != bigDecimalArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + bigDecimalArray2.length + " are different");
        }
        return Stat.generalisedMean(bigDecimalArray, bigDecimalArray2, d);
    }

    public static double weightedGeneralisedMean(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2, BigDecimal bigDecimal) {
        int n = bigDecimalArray.length;
        if (n != bigDecimalArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + bigDecimalArray2.length + " are different");
        }
        return Stat.generalisedMean(bigDecimalArray, bigDecimalArray2, bigDecimal);
    }

    public static double weightedGeneralisedMean(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2, double d) {
        int n = bigIntegerArray.length;
        if (n != bigIntegerArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + bigIntegerArray2.length + " are different");
        }
        return Stat.generalisedMean(bigIntegerArray, bigIntegerArray2, d);
    }

    public static double weightedGeneralisedMean(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2, BigInteger bigInteger) {
        int n = bigIntegerArray.length;
        if (n != bigIntegerArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + bigIntegerArray2.length + " are different");
        }
        return Stat.generalisedMean(bigIntegerArray, bigIntegerArray2, bigInteger);
    }

    public static double weightedGeneralisedMean(double[] dArray, double[] dArray2, double d) {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + dArray2.length + " are different");
        }
        return Stat.generalisedMean(dArray, dArray2, d);
    }

    public static float weightedGeneralisedMean(float[] fArray, float[] fArray2, float f) {
        int n = fArray.length;
        if (n != fArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + fArray2.length + " are different");
        }
        return Stat.generalisedMean(fArray, fArray2, f);
    }

    public static BigDecimal interQuartileMean(BigDecimal[] bigDecimalArray) {
        int n = bigDecimalArray.length;
        if (n < 4) {
            throw new IllegalArgumentException("At least 4 array elements needed");
        }
        ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray);
        ArrayMaths arrayMaths2 = arrayMaths.sort();
        BigDecimal[] bigDecimalArray2 = arrayMaths2.getArray_as_BigDecimal();
        BigDecimal bigDecimal = BigDecimal.ZERO;
        for (int i = n / 4; i < 3 * n / 4; ++i) {
            bigDecimal = bigDecimal.add(bigDecimalArray2[i]);
        }
        bigDecimal = bigDecimal.multiply(new BigDecimal(2.0 / (double)n));
        bigDecimalArray2 = null;
        return bigDecimal;
    }

    public static BigDecimal interQuartileMean(BigInteger[] bigIntegerArray) {
        int n = bigIntegerArray.length;
        if (n < 4) {
            throw new IllegalArgumentException("At least 4 array elements needed");
        }
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        ArrayMaths arrayMaths2 = arrayMaths.sort();
        BigDecimal[] bigDecimalArray = arrayMaths2.getArray_as_BigDecimal();
        BigDecimal bigDecimal = BigDecimal.ZERO;
        for (int i = n / 4; i < 3 * n / 4; ++i) {
            bigDecimal = bigDecimal.add(bigDecimalArray[i]);
        }
        bigDecimal = bigDecimal.multiply(new BigDecimal(2.0 / (double)n));
        bigDecimalArray = null;
        return bigDecimal;
    }

    public static double interQuartileMean(double[] dArray) {
        int n = dArray.length;
        if (n < 4) {
            throw new IllegalArgumentException("At least 4 array elements needed");
        }
        double[] dArray2 = Fmath.selectionSort(dArray);
        double d = 0.0;
        for (int i = n / 4; i < 3 * n / 4; ++i) {
            d += dArray2[i];
        }
        return 2.0 * d / (double)n;
    }

    public static float interQuartileMean(float[] fArray) {
        int n = fArray.length;
        if (n < 4) {
            throw new IllegalArgumentException("At least 4 array elements needed");
        }
        float[] fArray2 = Fmath.selectionSort(fArray);
        float f = 0.0f;
        for (int i = n / 4; i < 3 * n / 4; ++i) {
            f += fArray2[i];
        }
        return 2.0f * f / (float)n;
    }

    public static double rms(double[] dArray) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray[i];
        }
        return Math.sqrt(d / (double)n);
    }

    public static float rms(float[] fArray) {
        int n = fArray.length;
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            f += fArray[i] * fArray[i];
        }
        return (float)Math.sqrt(f /= (float)n);
    }

    public static double rms(BigDecimal[] bigDecimalArray) {
        int n = bigDecimalArray.length;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        for (int i = 0; i < n; ++i) {
            bigDecimal = bigDecimal.add(bigDecimalArray[i].multiply(bigDecimalArray[i]));
        }
        bigDecimal = bigDecimal.divide(new BigDecimal(n), 4);
        double d = Math.sqrt(bigDecimal.doubleValue());
        bigDecimal = null;
        return d;
    }

    public static double rms(BigInteger[] bigIntegerArray) {
        int n = bigIntegerArray.length;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        for (int i = 0; i < n; ++i) {
            bigDecimal2 = new BigDecimal(bigIntegerArray[i]);
            bigDecimal = bigDecimal.add(bigDecimal2.multiply(bigDecimal2));
        }
        bigDecimal = bigDecimal.divide(new BigDecimal(n), 4);
        double d = Math.sqrt(bigDecimal.doubleValue());
        bigDecimal2 = null;
        bigDecimal = null;
        return d;
    }

    public static double rms(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + dArray2.length + " are different");
        }
        double d = 0.0;
        double[] dArray3 = Stat.invertAndSquare(dArray2);
        for (int i = 0; i < n; ++i) {
            d += dArray3[i];
        }
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += dArray3[i] * dArray[i] * dArray[i];
        }
        return Math.sqrt(d2 / d);
    }

    public static float rms(float[] fArray, float[] fArray2) {
        int n = fArray.length;
        if (n != fArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + fArray2.length + " are different");
        }
        double d = 0.0;
        float[] fArray3 = Stat.invertAndSquare(fArray2);
        for (int i = 0; i < n; ++i) {
            d += (double)fArray3[i];
        }
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            f += fArray3[i] * fArray[i] * fArray[i];
        }
        return (float)Math.sqrt((double)f / d);
    }

    public static double rms(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2) {
        int n = bigDecimalArray.length;
        if (n != bigDecimalArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + bigDecimalArray2.length + " are different");
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal[] bigDecimalArray3 = Stat.invertAndSquare(bigDecimalArray2);
        for (int i = 0; i < n; ++i) {
            bigDecimal = bigDecimal.add(bigDecimalArray3[i]);
        }
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        for (int i = 0; i < n; ++i) {
            bigDecimal2 = bigDecimal2.add(bigDecimalArray[i].multiply(bigDecimalArray[i]).multiply(bigDecimalArray3[i]));
        }
        bigDecimal2 = bigDecimal2.divide(bigDecimal, 4);
        double d = Math.sqrt(bigDecimal2.doubleValue());
        bigDecimal2 = null;
        bigDecimalArray3 = null;
        return d;
    }

    public static double rms(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        int n = bigIntegerArray.length;
        if (n != bigIntegerArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + bigIntegerArray2.length + " are different");
        }
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        ArrayMaths arrayMaths2 = new ArrayMaths(bigIntegerArray2);
        return Stat.rms(arrayMaths.array_as_BigDecimal(), arrayMaths2.array_as_BigDecimal());
    }

    public static BigDecimal median(BigDecimal[] bigDecimalArray) {
        int n = bigDecimalArray.length;
        int n2 = n / 2;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray);
        ArrayMaths arrayMaths2 = arrayMaths.sort();
        BigDecimal[] bigDecimalArray2 = arrayMaths.getArray_as_BigDecimal();
        bigDecimal = Fmath.isOdd(n) ? bigDecimalArray2[n2] : bigDecimalArray2[n2 - 1].add(bigDecimalArray2[n2]).divide(new BigDecimal(2.0), 4);
        bigDecimalArray2 = null;
        return bigDecimal;
    }

    public static BigDecimal secondQuartile(BigDecimal[] bigDecimalArray) {
        return Stat.median(bigDecimalArray);
    }

    public static BigInteger median(BigInteger[] bigIntegerArray) {
        int n = bigIntegerArray.length;
        int n2 = n / 2;
        BigInteger bigInteger = BigInteger.ZERO;
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        ArrayMaths arrayMaths2 = arrayMaths.sort();
        BigInteger[] bigIntegerArray2 = arrayMaths.getArray_as_BigInteger();
        bigInteger = Fmath.isOdd(n) ? bigIntegerArray2[n2] : bigIntegerArray2[n2 - 1].add(bigIntegerArray2[n2]).divide(new BigInteger("2"));
        bigIntegerArray2 = null;
        return bigInteger;
    }

    public static BigInteger secondQuartile(BigInteger[] bigIntegerArray) {
        return Stat.median(bigIntegerArray);
    }

    public static double median(double[] dArray) {
        int n = dArray.length;
        int n2 = n / 2;
        double d = 0.0;
        double[] dArray2 = Fmath.selectionSort(dArray);
        d = Fmath.isOdd(n) ? dArray2[n2] : (dArray2[n2 - 1] + dArray2[n2]) / 2.0;
        return d;
    }

    public static double secondQuartile(double[] dArray) {
        return Stat.median(dArray);
    }

    public static float median(float[] fArray) {
        int n = fArray.length;
        int n2 = n / 2;
        float f = 0.0f;
        float[] fArray2 = Fmath.selectionSort(fArray);
        f = Fmath.isOdd(n) ? fArray2[n2] : (fArray2[n2 - 1] + fArray2[n2]) / 2.0f;
        return f;
    }

    public static float secondQuartile(float[] fArray) {
        return Stat.median(fArray);
    }

    public static double median(int[] nArray) {
        int n = nArray.length;
        int n2 = n / 2;
        double d = 0.0;
        int[] nArray2 = Fmath.selectionSort(nArray);
        d = Fmath.isOdd(n) ? (double)nArray2[n2] : (double)(nArray2[n2 - 1] + nArray2[n2]) / 2.0;
        return d;
    }

    public static double secondQuartile(int[] nArray) {
        return Stat.median(nArray);
    }

    public static double median(long[] lArray) {
        int n = lArray.length;
        int n2 = n / 2;
        double d = 0.0;
        long[] lArray2 = Fmath.selectionSort(lArray);
        d = Fmath.isOdd(n) ? (double)lArray2[n2] : (double)(lArray2[n2 - 1] + lArray2[n2]) / 2.0;
        return d;
    }

    public static double secondQuartile(long[] lArray) {
        return Stat.median(lArray);
    }

    public static double standardDeviation(BigDecimal[] bigDecimalArray) {
        return Math.sqrt(Stat.variance(bigDecimalArray).doubleValue());
    }

    public static double standardDeviation(BigInteger[] bigIntegerArray) {
        return Math.sqrt(Stat.variance(bigIntegerArray).doubleValue());
    }

    public static Complex standardDeviation(Complex[] complexArray) {
        return Complex.sqrt(Stat.variance(complexArray));
    }

    public static double standardDeviationConjugateCalcn(Complex[] complexArray) {
        return Math.sqrt(Stat.varianceConjugateCalcn(complexArray));
    }

    public static double standardDeviationModuli(Complex[] complexArray) {
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        double[] dArray = arrayMaths.array_as_modulus_of_Complex();
        double d = Stat.standardDeviation(dArray);
        return d;
    }

    public static double standardDeviationRealParts(Complex[] complexArray) {
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        double[] dArray = arrayMaths.array_as_real_part_of_Complex();
        double d = Stat.standardDeviation(dArray);
        return d;
    }

    public static double standardDeviationImaginaryParts(Complex[] complexArray) {
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        double[] dArray = arrayMaths.array_as_imaginary_part_of_Complex();
        double d = Stat.standardDeviation(dArray);
        return d;
    }

    public static double standardDeviation(double[] dArray) {
        return Math.sqrt(Stat.variance(dArray));
    }

    public static float standardDeviation(float[] fArray) {
        return (float)Math.sqrt(Stat.variance(fArray));
    }

    public static double standardDeviation(int[] nArray) {
        return Math.sqrt(Stat.variance(nArray));
    }

    public static double standardDeviation(long[] lArray) {
        return Math.sqrt(Stat.variance(lArray));
    }

    public static Complex standardDeviation(Complex[] complexArray, Complex[] complexArray2) {
        if (complexArray.length != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + complexArray.length + " and length of weight array, " + complexArray2.length + " are different");
        }
        return Complex.sqrt(Stat.variance(complexArray, complexArray2));
    }

    public static double standardDeviationConjugateCalcn(Complex[] complexArray, Complex[] complexArray2) {
        if (complexArray.length != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + complexArray.length + " and length of weight array, " + complexArray2.length + " are different");
        }
        return Math.sqrt(Stat.varianceConjugateCalcn(complexArray, complexArray2));
    }

    public static double standardDeviationModuli(Complex[] complexArray, Complex[] complexArray2) {
        int n = complexArray.length;
        if (n != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + complexArray2.length + " are different");
        }
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        double[] dArray = arrayMaths.array_as_modulus_of_Complex();
        ArrayMaths arrayMaths2 = new ArrayMaths(complexArray2);
        double[] dArray2 = arrayMaths2.array_as_modulus_of_Complex();
        double d = Stat.standardDeviation(dArray, dArray2);
        return d;
    }

    public static double standardDeviationRealParts(Complex[] complexArray, Complex[] complexArray2) {
        int n = complexArray.length;
        if (n != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + complexArray2.length + " are different");
        }
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        double[] dArray = arrayMaths.array_as_real_part_of_Complex();
        ArrayMaths arrayMaths2 = new ArrayMaths(complexArray2);
        double[] dArray2 = arrayMaths2.array_as_real_part_of_Complex();
        double d = Stat.standardDeviation(dArray, dArray2);
        return d;
    }

    public static double standardDeviationImaginaryParts(Complex[] complexArray, Complex[] complexArray2) {
        int n = complexArray.length;
        if (n != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + complexArray2.length + " are different");
        }
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        double[] dArray = arrayMaths.array_as_imaginary_part_of_Complex();
        ArrayMaths arrayMaths2 = new ArrayMaths(complexArray2);
        double[] dArray2 = arrayMaths2.array_as_imaginary_part_of_Complex();
        double d = Stat.standardDeviation(dArray, dArray2);
        return d;
    }

    public static double standardDeviation(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2) {
        if (bigDecimalArray.length != bigDecimalArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + bigDecimalArray.length + " and length of weight array, " + bigDecimalArray2.length + " are different");
        }
        return Math.sqrt(Stat.variance(bigDecimalArray, bigDecimalArray2).doubleValue());
    }

    public static double standardDeviation(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        if (bigIntegerArray.length != bigIntegerArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + bigIntegerArray.length + " and length of weight array, " + bigIntegerArray2.length + " are different");
        }
        return Math.sqrt(Stat.variance(bigIntegerArray, bigIntegerArray2).doubleValue());
    }

    public static double standardDeviation(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + dArray.length + " and length of weight array, " + dArray2.length + " are different");
        }
        return Math.sqrt(Stat.variance(dArray, dArray2));
    }

    public static float standardDeviation(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + fArray.length + " and length of weight array, " + fArray2.length + " are different");
        }
        return (float)Math.sqrt(Stat.variance(fArray, fArray2));
    }

    public static double volatilityLogChange(BigDecimal[] bigDecimalArray) {
        int n = bigDecimalArray.length - 1;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.log(bigDecimalArray[i + 1].divide(bigDecimalArray[i], 4).doubleValue());
        }
        return Stat.standardDeviation(dArray);
    }

    public static double volatilityLogChange(BigInteger[] bigIntegerArray) {
        int n = bigIntegerArray.length - 1;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.log(new BigDecimal(bigIntegerArray[i + 1]).divide(new BigDecimal(bigIntegerArray[i]), 4).doubleValue());
        }
        return Stat.standardDeviation(dArray);
    }

    public static double volatilityLogChange(double[] dArray) {
        int n = dArray.length - 1;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = Math.log(dArray[i + 1] / dArray[i]);
        }
        return Stat.standardDeviation(dArray2);
    }

    public static float volatilityLogChange(float[] fArray) {
        int n = fArray.length - 1;
        float[] fArray2 = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray2[i] = (float)Math.log(fArray[i + 1] / fArray[i]);
        }
        return Stat.standardDeviation(fArray2);
    }

    public static double volatilityPerCentChange(BigDecimal[] bigDecimalArray) {
        int n = bigDecimalArray.length - 1;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = bigDecimalArray[i + 1].add(bigDecimalArray[i]).multiply(new BigDecimal(100.0).divide(bigDecimalArray[i], 4)).doubleValue();
        }
        return Stat.standardDeviation(dArray);
    }

    public static double volatilityPerCentChange(BigInteger[] bigIntegerArray) {
        int n = bigIntegerArray.length - 1;
        double[] dArray = new double[n];
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        BigDecimal[] bigDecimalArray = arrayMaths.getArray_as_BigDecimal();
        for (int i = 0; i < n; ++i) {
            dArray[i] = bigDecimalArray[i + 1].add(bigDecimalArray[i]).multiply(new BigDecimal(100.0).divide(bigDecimalArray[i], 4)).doubleValue();
        }
        bigDecimalArray = null;
        return Stat.standardDeviation(dArray);
    }

    public static double volatilityPerCentChange(double[] dArray) {
        int n = dArray.length - 1;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = (dArray[i + 1] - dArray[i]) * 100.0 / dArray[i];
        }
        return Stat.standardDeviation(dArray2);
    }

    public static double volatilityPerCentChange(float[] fArray) {
        int n = fArray.length - 1;
        float[] fArray2 = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray2[i] = (fArray[i + 1] - fArray[i]) * 100.0f / fArray[i];
        }
        return Stat.standardDeviation(fArray2);
    }

    public static double coefficientOfVariation(BigInteger[] bigIntegerArray) {
        return 100.0 * Stat.standardDeviation(bigIntegerArray) / Math.abs(Stat.mean(bigIntegerArray).doubleValue());
    }

    public static double coefficientOfVariation(BigDecimal[] bigDecimalArray) {
        return 100.0 * Stat.standardDeviation(bigDecimalArray) / Math.abs(Stat.mean(bigDecimalArray).doubleValue());
    }

    public static double coefficientOfVariation(double[] dArray) {
        return 100.0 * Stat.standardDeviation(dArray) / Math.abs(Stat.mean(dArray));
    }

    public static float coefficientOfVariation(float[] fArray) {
        return 100.0f * Stat.standardDeviation(fArray) / Math.abs(Stat.mean(fArray));
    }

    public static double coefficientOfVariation(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        int n = bigIntegerArray.length;
        if (n != bigIntegerArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + bigIntegerArray2.length + " are different");
        }
        return 100.0 * Stat.standardDeviation(bigIntegerArray, bigIntegerArray2) / Math.abs(Stat.mean(bigIntegerArray, bigIntegerArray2).doubleValue());
    }

    public static double coefficientOfVariation(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2) {
        int n = bigDecimalArray.length;
        if (n != bigDecimalArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + bigDecimalArray2.length + " are different");
        }
        return 100.0 * Stat.standardDeviation(bigDecimalArray, bigDecimalArray2) / Math.abs(Stat.mean(bigDecimalArray, bigDecimalArray2).doubleValue());
    }

    public static double coefficientOfVariation(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + dArray2.length + " are different");
        }
        return 100.0 * Stat.standardDeviation(dArray, dArray2) / Math.abs(Stat.mean(dArray, dArray2));
    }

    public static float coefficientOfVariation(float[] fArray, float[] fArray2) {
        int n = fArray.length;
        if (n != fArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + fArray2.length + " are different");
        }
        return 100.0f * Stat.standardDeviation(fArray, fArray2) / Math.abs(Stat.mean(fArray, fArray2));
    }

    public static double[] standardize(double[] dArray) {
        double d = Stat.mean(dArray);
        double d2 = Stat.standardDeviation(dArray);
        int n = dArray.length;
        double[] dArray2 = new double[n];
        if (d2 == 0.0) {
            for (int i = 0; i < n; ++i) {
                dArray2[i] = 1.0;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                dArray2[i] = (dArray[i] - d) / d2;
            }
        }
        return dArray2;
    }

    public static double[] standardise(double[] dArray) {
        return Stat.standardize(dArray);
    }

    public static float[] standardize(float[] fArray) {
        float f = Stat.mean(fArray);
        float f2 = Stat.standardDeviation(fArray);
        int n = fArray.length;
        float[] fArray2 = new float[n];
        if ((double)f2 == 0.0) {
            for (int i = 0; i < n; ++i) {
                fArray2[i] = 1.0f;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                fArray2[i] = (fArray[i] - f) / f2;
            }
        }
        return fArray2;
    }

    public static float[] standardise(float[] fArray) {
        return Stat.standardize(fArray);
    }

    public static double[] standardize(long[] lArray) {
        double d = Stat.mean(lArray);
        double d2 = Stat.standardDeviation(lArray);
        int n = lArray.length;
        double[] dArray = new double[n];
        if (d2 == 0.0) {
            for (int i = 0; i < n; ++i) {
                dArray[i] = 1.0;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                dArray[i] = ((double)lArray[i] - d) / d2;
            }
        }
        return dArray;
    }

    public static double[] standardise(long[] lArray) {
        return Stat.standardize(lArray);
    }

    public static double[] standardize(int[] nArray) {
        double d = Stat.mean(nArray);
        double d2 = Stat.standardDeviation(nArray);
        int n = nArray.length;
        double[] dArray = new double[n];
        if (d2 == 0.0) {
            for (int i = 0; i < n; ++i) {
                dArray[i] = 1.0;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                dArray[i] = ((double)nArray[i] - d) / d2;
            }
        }
        return dArray;
    }

    public static double[] standardise(int[] nArray) {
        return Stat.standardize(nArray);
    }

    public static double[] standardize(BigDecimal[] bigDecimalArray) {
        double d = Stat.mean(bigDecimalArray).doubleValue();
        double d2 = Stat.standardDeviation(bigDecimalArray);
        int n = bigDecimalArray.length;
        double[] dArray = new double[n];
        if (d2 == 0.0) {
            for (int i = 0; i < n; ++i) {
                dArray[i] = 1.0;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                dArray[i] = (bigDecimalArray[i].doubleValue() - d) / d2;
            }
        }
        return dArray;
    }

    public static double[] standardise(BigDecimal[] bigDecimalArray) {
        return Stat.standardize(bigDecimalArray);
    }

    public static double[] standardize(BigInteger[] bigIntegerArray) {
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        BigDecimal[] bigDecimalArray = arrayMaths.getArray_as_BigDecimal();
        return Stat.standardize(bigDecimalArray);
    }

    public static double[] standardise(BigInteger[] bigIntegerArray) {
        return Stat.standardize(bigIntegerArray);
    }

    public static double[] scale(double[] dArray, double d, double d2) {
        double[] dArray2 = Stat.standardize(dArray);
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray2[i] * d2 + d;
        }
        return dArray2;
    }

    public static float[] scale(float[] fArray, float f, float f2) {
        float[] fArray2 = Stat.standardize(fArray);
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            fArray2[i] = fArray2[i] * f2 + f;
        }
        return fArray2;
    }

    public static double[] scale(long[] lArray, double d, double d2) {
        double[] dArray = Stat.standardize(lArray);
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = dArray[i] * d2 + d;
        }
        return dArray;
    }

    public static double[] scale(int[] nArray, double d, double d2) {
        double[] dArray = Stat.standardize(nArray);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = dArray[i] * d2 + d;
        }
        return dArray;
    }

    public static double[] scale(BigDecimal[] bigDecimalArray, double d, double d2) {
        double[] dArray = Stat.standardize(bigDecimalArray);
        int n = bigDecimalArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = dArray[i] * d2 + d;
        }
        return dArray;
    }

    public static double[] scale(BigInteger[] bigIntegerArray, double d, double d2) {
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        BigDecimal[] bigDecimalArray = arrayMaths.getArray_as_BigDecimal();
        return Stat.scale(bigDecimalArray, d, d2);
    }

    public static double momentSkewness(double[] dArray) {
        int n = dArray.length;
        double d = n - 1;
        if (nFactorOptionS) {
            d = n;
        }
        double d2 = 0.0;
        double d3 = Stat.mean(dArray);
        for (int i = 0; i < n; ++i) {
            d2 += Math.pow(dArray[i] - d3, 3.0);
        }
        return (d2 /= d) / Math.pow(Stat.standardDeviation(dArray), 3.0);
    }

    public static float momentSkewness(float[] fArray) {
        int n = fArray.length;
        float f = n - 1;
        if (nFactorOptionS) {
            f = n;
        }
        float f2 = 0.0f;
        float f3 = Stat.mean(fArray);
        for (int i = 0; i < n; ++i) {
            f2 = (float)((double)f2 + Math.pow(fArray[i] - f3, 3.0));
        }
        return (f2 /= f) / (float)Math.pow(Stat.standardDeviation(fArray), 3.0);
    }

    public static double momentSkewness(BigDecimal[] bigDecimalArray) {
        int n = bigDecimalArray.length;
        double d = n - 1;
        if (nFactorOptionS) {
            d = n;
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = Stat.mean(bigDecimalArray);
        double d2 = Stat.standardDeviation(bigDecimalArray);
        for (int i = 0; i < n; ++i) {
            BigDecimal bigDecimal3 = bigDecimalArray[i].subtract(bigDecimal2);
            bigDecimal = bigDecimal.add(bigDecimal3.multiply(bigDecimal3.multiply(bigDecimal3)));
        }
        bigDecimal = bigDecimal.multiply(new BigDecimal(1.0 / d));
        return bigDecimal.doubleValue() / Math.pow(d2, 3.0);
    }

    public static double momentSkewness(long[] lArray) {
        int n = lArray.length;
        double d = n - 1;
        if (nFactorOptionS) {
            d = n;
        }
        double d2 = 0.0;
        double d3 = Stat.mean(lArray);
        for (int i = 0; i < n; ++i) {
            d2 += Math.pow((double)lArray[i] - d3, 3.0);
        }
        return (d2 /= d) / Math.pow(Stat.standardDeviation(lArray), 3.0);
    }

    public static double momentSkewness(int[] nArray) {
        int n = nArray.length;
        double d = n - 1;
        if (nFactorOptionS) {
            d = n;
        }
        double d2 = 0.0;
        double d3 = Stat.mean(nArray);
        for (int i = 0; i < n; ++i) {
            d2 += Math.pow((double)nArray[i] - d3, 3.0);
        }
        return (d2 /= d) / Math.pow(Stat.standardDeviation(nArray), 3.0);
    }

    public static double medianSkewness(double[] dArray) {
        double d = Stat.mean(dArray);
        double d2 = Stat.median(dArray);
        double d3 = Stat.standardDeviation(dArray);
        return 3.0 * (d - d2) / d3;
    }

    public static float medianSkewness(float[] fArray) {
        float f = Stat.mean(fArray);
        float f2 = Stat.median(fArray);
        float f3 = Stat.standardDeviation(fArray);
        return 3.0f * (f - f2) / f3;
    }

    public static double medianSkewness(BigDecimal[] bigDecimalArray) {
        BigDecimal bigDecimal = Stat.mean(bigDecimalArray);
        BigDecimal bigDecimal2 = Stat.median(bigDecimalArray);
        double d = Stat.standardDeviation(bigDecimalArray);
        return 3.0 * bigDecimal.subtract(bigDecimal2).doubleValue() / d;
    }

    public static double medianSkewness(long[] lArray) {
        double d = Stat.mean(lArray);
        double d2 = Stat.median(lArray);
        double d3 = Stat.standardDeviation(lArray);
        return 3.0 * (d - d2) / d3;
    }

    public static double medianSkewness(int[] nArray) {
        double d = Stat.mean(nArray);
        double d2 = Stat.median(nArray);
        double d3 = Stat.standardDeviation(nArray);
        return 3.0 * (d - d2) / d3;
    }

    public static double quartileSkewness(double[] dArray) {
        double d;
        int n = dArray.length;
        double d2 = Stat.median(dArray);
        int n2 = 0;
        int n3 = 0;
        int n4 = n / 2 - 1;
        int n5 = n - 1;
        n3 = Fmath.isOdd(n) ? n4 + 2 : n4 + 1;
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        double[] dArray2 = arrayMaths.subarray_as_double(n2, n4);
        double[] dArray3 = arrayMaths.subarray_as_double(n3, n5);
        double d3 = Stat.median(dArray2);
        double d4 = (d3 - 2.0 * d2 + (d = Stat.median(dArray3))) / (d - d3);
        if (Fmath.isNaN(d4)) {
            d4 = 1.0;
        }
        return d4;
    }

    public static float quartileSkewness(float[] fArray) {
        float f;
        int n = fArray.length;
        float f2 = Stat.median(fArray);
        int n2 = 0;
        int n3 = 0;
        int n4 = n / 2 - 1;
        int n5 = n - 1;
        n3 = Fmath.isOdd(n) ? n4 + 2 : n4 + 1;
        ArrayMaths arrayMaths = new ArrayMaths(fArray);
        float[] fArray2 = arrayMaths.subarray_as_float(n2, n4);
        float[] fArray3 = arrayMaths.subarray_as_float(n3, n5);
        float f3 = Stat.median(fArray2);
        float f4 = (f3 - 2.0f * f2 + (f = Stat.median(fArray3))) / (f - f3);
        if (Fmath.isNaN(f4)) {
            f4 = 1.0f;
        }
        return f4;
    }

    public static BigDecimal quartileSkewness(BigDecimal[] bigDecimalArray) {
        BigDecimal bigDecimal;
        int n = bigDecimalArray.length;
        BigDecimal bigDecimal2 = Stat.median(bigDecimalArray);
        int n2 = 0;
        int n3 = 0;
        int n4 = n / 2 - 1;
        int n5 = n - 1;
        n3 = Fmath.isOdd(n) ? n4 + 2 : n4 + 1;
        ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray);
        BigDecimal[] bigDecimalArray2 = arrayMaths.subarray_as_BigDecimal(n2, n4);
        BigDecimal[] bigDecimalArray3 = arrayMaths.subarray_as_BigDecimal(n3, n5);
        BigDecimal bigDecimal3 = Stat.median(bigDecimalArray2);
        BigDecimal bigDecimal4 = Stat.median(bigDecimalArray3);
        BigDecimal bigDecimal5 = bigDecimal3.subtract(bigDecimal2.multiply(new BigDecimal(2.0))).add(bigDecimal4);
        BigDecimal bigDecimal6 = bigDecimal5.divide(bigDecimal = bigDecimal4.subtract(bigDecimal3), 4);
        if (Fmath.isNaN(bigDecimal6.doubleValue())) {
            bigDecimal6 = new BigDecimal(1.0);
        }
        bigDecimalArray2 = null;
        bigDecimalArray3 = null;
        bigDecimal3 = null;
        bigDecimal2 = null;
        bigDecimal4 = null;
        bigDecimal5 = null;
        bigDecimal = null;
        return bigDecimal6;
    }

    public static BigDecimal quartileSkewness(BigInteger[] bigIntegerArray) {
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        BigDecimal[] bigDecimalArray = arrayMaths.array_as_BigDecimal();
        return Stat.quartileSkewness(bigDecimalArray);
    }

    public static double quartileSkewness(long[] lArray) {
        double d;
        int n = lArray.length;
        double d2 = Stat.median(lArray);
        int n2 = 0;
        int n3 = 0;
        int n4 = n / 2 - 1;
        int n5 = n - 1;
        n3 = Fmath.isOdd(n) ? n4 + 2 : n4 + 1;
        ArrayMaths arrayMaths = new ArrayMaths(lArray);
        double[] dArray = arrayMaths.subarray_as_double(n2, n4);
        double[] dArray2 = arrayMaths.subarray_as_double(n3, n5);
        double d3 = Stat.median(dArray);
        double d4 = (d3 - 2.0 * d2 + (d = Stat.median(dArray2))) / (d - d3);
        if (Fmath.isNaN(d4)) {
            d4 = 1.0;
        }
        return d4;
    }

    public static double quartileSkewness(int[] nArray) {
        double d;
        int n = nArray.length;
        double d2 = Stat.median(nArray);
        int n2 = 0;
        int n3 = 0;
        int n4 = n / 2 - 1;
        int n5 = n - 1;
        n3 = Fmath.isOdd(n) ? n4 + 2 : n4 + 1;
        ArrayMaths arrayMaths = new ArrayMaths(nArray);
        double[] dArray = arrayMaths.subarray_as_double(n2, n4);
        double[] dArray2 = arrayMaths.subarray_as_double(n3, n5);
        double d3 = Stat.median(dArray);
        double d4 = (d3 - 2.0 * d2 + (d = Stat.median(dArray2))) / (d - d3);
        if (Fmath.isNaN(d4)) {
            d4 = 1.0;
        }
        return d4;
    }

    public static double kurtosis(double[] dArray) {
        int n = dArray.length;
        double d = n - 1;
        if (nFactorOptionS) {
            d = n;
        }
        double d2 = 0.0;
        double d3 = Stat.mean(dArray);
        for (int i = 0; i < n; ++i) {
            d2 += Math.pow(dArray[i] - d3, 4.0);
        }
        double d4 = (d2 /= d) / Fmath.square(Stat.variance(dArray));
        if (Fmath.isNaN(d4)) {
            d4 = 2.0 / d;
        }
        return d4;
    }

    public static double curtosis(double[] dArray) {
        return Stat.kurtosis(dArray);
    }

    public static double kurtosisExcess(double[] dArray) {
        return Stat.kurtosis(dArray) - 3.0;
    }

    public static double curtosisExcess(double[] dArray) {
        return Stat.kurtosisExcess(dArray);
    }

    public static double excessKurtosis(double[] dArray) {
        return Stat.kurtosisExcess(dArray);
    }

    public static double excessCurtosis(double[] dArray) {
        return Stat.kurtosisExcess(dArray);
    }

    public static float kurtosis(float[] fArray) {
        int n = fArray.length;
        float f = n - 1;
        if (nFactorOptionS) {
            f = n;
        }
        float f2 = 0.0f;
        float f3 = Stat.mean(fArray);
        for (int i = 0; i < n; ++i) {
            f2 = (float)((double)f2 + Math.pow(fArray[i] - f3, 4.0));
        }
        float f4 = (f2 /= f) / Fmath.square(Stat.variance(fArray));
        if (Fmath.isNaN(f4)) {
            f4 = 2.0f / f;
        }
        return f4;
    }

    public static float curtosis(float[] fArray) {
        return Stat.kurtosis(fArray);
    }

    public static float kurtosisExcess(float[] fArray) {
        return Stat.kurtosis(fArray) - 3.0f;
    }

    public static float curtosisExcess(float[] fArray) {
        return Stat.kurtosisExcess(fArray);
    }

    public static float excessKurtosis(float[] fArray) {
        return Stat.kurtosisExcess(fArray);
    }

    public static float excessCurtosis(float[] fArray) {
        return Stat.kurtosisExcess(fArray);
    }

    public static BigDecimal kurtosis(BigInteger[] bigIntegerArray) {
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        BigDecimal[] bigDecimalArray = arrayMaths.array_as_BigDecimal();
        return Stat.kurtosis(bigDecimalArray);
    }

    public static BigDecimal curtosis(BigInteger[] bigIntegerArray) {
        return Stat.kurtosis(bigIntegerArray);
    }

    public static BigDecimal kurtosisExcess(BigInteger[] bigIntegerArray) {
        return Stat.kurtosis(bigIntegerArray).subtract(new BigDecimal("3.0"));
    }

    public static BigDecimal curtosisExcess(BigInteger[] bigIntegerArray) {
        return Stat.kurtosisExcess(bigIntegerArray);
    }

    public static BigDecimal excessKurtosis(BigInteger[] bigIntegerArray) {
        return Stat.kurtosisExcess(bigIntegerArray);
    }

    public static BigDecimal excessCurtosis(BigInteger[] bigIntegerArray) {
        return Stat.kurtosisExcess(bigIntegerArray);
    }

    public static BigDecimal kurtosis(BigDecimal[] bigDecimalArray) {
        int n = bigDecimalArray.length;
        double d = n - 1;
        if (nFactorOptionS) {
            d = n;
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = Stat.mean(bigDecimalArray);
        for (int i = 0; i < n; ++i) {
            BigDecimal bigDecimal3 = bigDecimalArray[i].subtract(bigDecimal2);
            bigDecimal = bigDecimal.add(bigDecimal3.multiply(bigDecimal3.multiply(bigDecimal3.multiply(bigDecimal3))));
        }
        bigDecimal = bigDecimal.divide(new BigDecimal(d), 4);
        bigDecimal2 = Stat.variance(bigDecimalArray);
        bigDecimal = bigDecimal2.doubleValue() == 0.0 ? new BigDecimal(2.0 / d) : bigDecimal.divide(bigDecimal2.multiply(bigDecimal2), 4);
        bigDecimal2 = null;
        return bigDecimal;
    }

    public static BigDecimal curtosis(BigDecimal[] bigDecimalArray) {
        return Stat.kurtosis(bigDecimalArray);
    }

    public static BigDecimal kurtosisExcess(BigDecimal[] bigDecimalArray) {
        return Stat.kurtosis(bigDecimalArray).subtract(new BigDecimal("3.0"));
    }

    public static BigDecimal curtosisExcess(BigDecimal[] bigDecimalArray) {
        return Stat.kurtosisExcess(bigDecimalArray);
    }

    public static BigDecimal excessCurtosis(BigDecimal[] bigDecimalArray) {
        return Stat.kurtosisExcess(bigDecimalArray);
    }

    public static BigDecimal excessKurtosis(BigDecimal[] bigDecimalArray) {
        return Stat.kurtosisExcess(bigDecimalArray);
    }

    public static double kurtosis(long[] lArray) {
        int n = lArray.length;
        double d = n - 1;
        if (nFactorOptionS) {
            d = n;
        }
        double d2 = 0.0;
        double d3 = Stat.mean(lArray);
        for (int i = 0; i < n; ++i) {
            d2 += Math.pow((double)lArray[i] - d3, 4.0);
        }
        double d4 = (d2 /= d) / Fmath.square(Stat.variance(lArray));
        if (Fmath.isNaN(d4)) {
            d4 = 2.0 / d;
        }
        return d4;
    }

    public static double curtosis(long[] lArray) {
        return Stat.kurtosis(lArray);
    }

    public static double kurtosisExcess(long[] lArray) {
        return Stat.kurtosis(lArray) - 3.0;
    }

    public static double curtosisExcess(long[] lArray) {
        return Stat.kurtosisExcess(lArray);
    }

    public static double excessCurtosis(long[] lArray) {
        return Stat.kurtosisExcess(lArray);
    }

    public static double excessKurtosis(long[] lArray) {
        return Stat.kurtosisExcess(lArray);
    }

    public static double kurtosis(int[] nArray) {
        int n = nArray.length;
        double d = n - 1;
        if (nFactorOptionS) {
            d = n;
        }
        double d2 = 0.0;
        double d3 = Stat.mean(nArray);
        for (int i = 0; i < n; ++i) {
            d2 += Math.pow((double)nArray[i] - d3, 4.0);
        }
        double d4 = (d2 /= d) / Fmath.square(Stat.variance(nArray));
        if (Fmath.isNaN(d4)) {
            d4 = 2.0 / d;
        }
        return d4;
    }

    public static double curtosis(int[] nArray) {
        return Stat.kurtosis(nArray);
    }

    public static double kurtosisExcess(int[] nArray) {
        return Stat.kurtosis(nArray) - 3.0;
    }

    public static double curtosisExcess(int[] nArray) {
        return Stat.kurtosisExcess(nArray);
    }

    public static double excessCurtosis(int[] nArray) {
        return Stat.kurtosisExcess(nArray);
    }

    public static double excessKurtosis(int[] nArray) {
        return Stat.kurtosisExcess(nArray);
    }

    public static BigDecimal variance(BigDecimal[] bigDecimalArray) {
        int n = bigDecimalArray.length;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = Stat.mean(bigDecimalArray);
        for (int i = 0; i < n; ++i) {
            BigDecimal bigDecimal3 = bigDecimalArray[i].subtract(bigDecimal2);
            bigDecimal = bigDecimal.add(bigDecimal3.multiply(bigDecimal3));
        }
        BigDecimal bigDecimal4 = bigDecimal.divide(new BigDecimal((double)(n - 1)), 4);
        if (nFactorOptionS) {
            bigDecimal4 = bigDecimal.divide(new BigDecimal((double)n), 4);
        }
        bigDecimal = null;
        bigDecimal2 = null;
        return bigDecimal4;
    }

    public static BigDecimal variance(BigInteger[] bigIntegerArray) {
        int n;
        int n2 = bigIntegerArray.length;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        for (n = 0; n < n2; ++n) {
            bigDecimal = bigDecimal.add(new BigDecimal(bigIntegerArray[n]));
        }
        bigDecimal2 = bigDecimal.divide(new BigDecimal((double)n2), 4);
        bigDecimal = BigDecimal.ZERO;
        for (n = 0; n < n2; ++n) {
            BigDecimal bigDecimal3 = new BigDecimal(bigIntegerArray[n]).subtract(bigDecimal2);
            bigDecimal = bigDecimal.add(bigDecimal3.multiply(bigDecimal3));
        }
        BigDecimal bigDecimal4 = bigDecimal.divide(new BigDecimal((double)(n2 - 1)), 4);
        if (nFactorOptionS) {
            bigDecimal4 = bigDecimal.divide(new BigDecimal((double)n2), 4);
        }
        bigDecimal = null;
        bigDecimal2 = null;
        return bigDecimal4;
    }

    public static Complex variance(Complex[] complexArray) {
        int n = complexArray.length;
        Complex complex = Complex.zero();
        Complex complex2 = Stat.mean(complexArray);
        for (int i = 0; i < n; ++i) {
            Complex complex3 = new Complex(complexArray[i]).minus(complex2);
            complex = complex.plus(complex3.times(complex3));
        }
        Complex complex4 = complex.over(new Complex(n - 1));
        if (nFactorOptionS) {
            complex4 = complex.over(new Complex(n));
        }
        return complex4;
    }

    public static double varianceConjugateCalcn(Complex[] complexArray) {
        int n = complexArray.length;
        Complex complex = Complex.zero();
        Complex complex2 = Stat.mean(complexArray);
        for (int i = 0; i < n; ++i) {
            Complex complex3 = new Complex(complexArray[i]).minus(complex2);
            complex = complex.plus(complex3.times(complex3.conjugate()));
        }
        double d = complex.getReal() / (double)(n - 1);
        if (nFactorOptionS) {
            d = complex.getReal() / (double)n;
        }
        return d;
    }

    public static double varianceModuli(Complex[] complexArray) {
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        double[] dArray = arrayMaths.array_as_modulus_of_Complex();
        double d = Stat.variance(dArray);
        return d;
    }

    public static double varianceRealParts(Complex[] complexArray) {
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        double[] dArray = arrayMaths.array_as_real_part_of_Complex();
        double d = Stat.variance(dArray);
        return d;
    }

    public static double varianceImaginaryParts(Complex[] complexArray) {
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        double[] dArray = arrayMaths.array_as_imaginary_part_of_Complex();
        double d = Stat.variance(dArray);
        return d;
    }

    public static double variance(double[] dArray) {
        int n = dArray.length;
        double d = 0.0;
        double d2 = Stat.mean(dArray);
        d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += Fmath.square(dArray[i] - d2);
        }
        double d3 = d / (double)(n - 1);
        if (nFactorOptionS) {
            d3 = d / (double)n;
        }
        return d3;
    }

    public static float variance(float[] fArray) {
        int n = fArray.length;
        float f = 0.0f;
        float f2 = Stat.mean(fArray);
        for (int i = 0; i < n; ++i) {
            f += Fmath.square(fArray[i] - f2);
        }
        float f3 = f / (float)(n - 1);
        if (nFactorOptionS) {
            f3 = f / (float)n;
        }
        return f3;
    }

    public static double variance(int[] nArray) {
        int n = nArray.length;
        double d = 0.0;
        double d2 = Stat.mean(nArray);
        for (int i = 0; i < n; ++i) {
            d += Fmath.square((double)nArray[i] - d2);
        }
        double d3 = d / (double)(n - 1);
        if (nFactorOptionS) {
            d3 = d / (double)n;
        }
        return d3;
    }

    public static double variance(long[] lArray) {
        int n = lArray.length;
        double d = 0.0;
        double d2 = Stat.mean(lArray);
        for (int i = 0; i < n; ++i) {
            d += Fmath.square((double)lArray[i] - d2);
        }
        double d3 = d / (double)(n - 1);
        if (nFactorOptionS) {
            d3 = d / (double)n;
        }
        return d3;
    }

    public static double variance(double[] dArray, double[] dArray2) {
        int n;
        int n2 = dArray.length;
        if (n2 != dArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n2 + " and length of weight array, " + dArray2.length + " are different");
        }
        double d = Stat.effectiveSampleNumber(dArray2);
        double d2 = d / (d - 1.0);
        if (nFactorOptionS) {
            d2 = 1.0;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double[] dArray3 = Stat.invertAndSquare(dArray2);
        for (n = 0; n < n2; ++n) {
            d3 += dArray[n] * dArray3[n];
            d4 += dArray3[n];
        }
        d5 = d3 / d4;
        d3 = 0.0;
        for (n = 0; n < n2; ++n) {
            d3 += dArray3[n] * Fmath.square(dArray[n] - d5);
        }
        return d3 * d2 / d4;
    }

    public static float variance(float[] fArray, float[] fArray2) {
        int n;
        int n2 = fArray.length;
        if (n2 != fArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n2 + " and length of weight array, " + fArray2.length + " are different");
        }
        float f = Stat.effectiveSampleNumber(fArray2);
        float f2 = f / (f - 1.0f);
        if (nFactorOptionS) {
            f2 = 1.0f;
        }
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float[] fArray3 = Stat.invertAndSquare(fArray2);
        for (n = 0; n < n2; ++n) {
            f3 += fArray[n] * fArray3[n];
            f4 += fArray3[n];
        }
        f5 = f3 / f4;
        f3 = 0.0f;
        for (n = 0; n < n2; ++n) {
            f3 += fArray3[n] * Fmath.square(fArray[n] - f5);
        }
        return f3 * f2 / f4;
    }

    public static Complex variance(Complex[] complexArray, Complex[] complexArray2) {
        int n;
        int n2 = complexArray.length;
        if (n2 != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n2 + " and length of weight array, " + complexArray2.length + " are different");
        }
        Complex complex = Stat.effectiveSampleNumber(complexArray2);
        Complex complex2 = complex.over(complex.minus(1.0));
        if (nFactorOptionS) {
            complex2 = Complex.plusOne();
        }
        Complex complex3 = Complex.zero();
        Complex complex4 = Complex.zero();
        Complex complex5 = Complex.zero();
        Complex[] complexArray3 = Stat.invertAndSquare(complexArray2);
        for (n = 0; n < n2; ++n) {
            complex3 = complex3.plus(complexArray[n].times(complexArray3[n]));
            complex4 = complex4.plus(complexArray3[n]);
        }
        complex5 = complex3.over(complex4);
        complex3 = Complex.zero();
        for (n = 0; n < n2; ++n) {
            Complex complex6 = complexArray[n].minus(complex5);
            complex3 = complex3.plus(complexArray3[n].times(complex6).times(complex6));
        }
        return complex3.times(complex2).over(complex4);
    }

    public static double varianceConjugateCalcn(Complex[] complexArray, Complex[] complexArray2) {
        int n;
        int n2 = complexArray.length;
        if (n2 != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n2 + " and length of weight array, " + complexArray2.length + " are different");
        }
        double d = Stat.effectiveSampleNumberConjugateCalcn(complexArray2);
        double d2 = d / (d - 1.0);
        if (nFactorOptionS) {
            d2 = 1.0;
        }
        Complex complex = Complex.zero();
        Complex complex2 = Complex.zero();
        Complex complex3 = Complex.zero();
        Complex complex4 = Complex.zero();
        ArrayMaths arrayMaths = new ArrayMaths(complexArray2);
        arrayMaths = arrayMaths.invert();
        Complex[] complexArray3 = arrayMaths.array_as_Complex();
        for (n = 0; n < n2; ++n) {
            complex = complex.plus(complexArray[n].times(complexArray3[n].times(complexArray3[n])));
            complex2 = complex2.plus(complexArray3[n].times(complexArray3[n]));
            complex3 = complex3.plus(complexArray3[n].times(complexArray3[n].conjugate()));
        }
        complex4 = complex.over(complex2);
        complex = Complex.zero();
        for (n = 0; n < n2; ++n) {
            Complex complex5 = complexArray[n].minus(complex4);
            complex = complex.plus(complexArray3[n].times(complexArray3[n].conjugate()).times(complex5).times(complex5.conjugate()));
        }
        return d2 * complex.times(d2).over(complex3).getReal();
    }

    public static double varianceModuli(Complex[] complexArray, Complex[] complexArray2) {
        int n = complexArray.length;
        if (n != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + complexArray2.length + " are different");
        }
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        double[] dArray = arrayMaths.array_as_modulus_of_Complex();
        ArrayMaths arrayMaths2 = new ArrayMaths(complexArray2);
        double[] dArray2 = arrayMaths2.array_as_modulus_of_Complex();
        double d = Stat.variance(dArray, dArray2);
        return d;
    }

    public static double varianceRealParts(Complex[] complexArray, Complex[] complexArray2) {
        int n = complexArray.length;
        if (n != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + complexArray2.length + " are different");
        }
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        double[] dArray = arrayMaths.array_as_real_part_of_Complex();
        ArrayMaths arrayMaths2 = new ArrayMaths(complexArray2);
        double[] dArray2 = arrayMaths2.array_as_real_part_of_Complex();
        double d = Stat.variance(dArray, dArray2);
        return d;
    }

    public static double varianceImaginaryParts(Complex[] complexArray, Complex[] complexArray2) {
        int n = complexArray.length;
        if (n != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + complexArray2.length + " are different");
        }
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        double[] dArray = arrayMaths.array_as_imaginary_part_of_Complex();
        ArrayMaths arrayMaths2 = new ArrayMaths(complexArray2);
        double[] dArray2 = arrayMaths2.array_as_imaginary_part_of_Complex();
        double d = Stat.variance(dArray, dArray2);
        return d;
    }

    public static BigDecimal variance(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2) {
        int n;
        int n2 = bigDecimalArray.length;
        if (n2 != bigDecimalArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n2 + " and length of weight array, " + bigDecimalArray2.length + " are different");
        }
        BigDecimal bigDecimal = Stat.effectiveSampleNumber(bigDecimalArray2);
        BigDecimal bigDecimal2 = bigDecimal.divide(bigDecimal.subtract(BigDecimal.ONE), 4);
        if (nFactorOptionS) {
            bigDecimal2 = BigDecimal.ONE;
        }
        BigDecimal bigDecimal3 = BigDecimal.ZERO;
        BigDecimal bigDecimal4 = BigDecimal.ZERO;
        BigDecimal bigDecimal5 = BigDecimal.ZERO;
        BigDecimal[] bigDecimalArray3 = Stat.invertAndSquare(bigDecimalArray2);
        for (n = 0; n < n2; ++n) {
            bigDecimal3 = bigDecimal3.add(bigDecimalArray[n].multiply(bigDecimalArray3[n]));
            bigDecimal4 = bigDecimal4.add(bigDecimalArray3[n]);
        }
        bigDecimal5 = bigDecimal3.divide(bigDecimal4, 4);
        bigDecimal3 = BigDecimal.ZERO;
        for (n = 0; n < n2; ++n) {
            bigDecimal3 = bigDecimal3.add(bigDecimalArray3[n].multiply(bigDecimalArray[n].subtract(bigDecimal5)).multiply(bigDecimalArray[n].subtract(bigDecimal5)));
        }
        bigDecimal3 = bigDecimal3.multiply(bigDecimal2).divide(bigDecimal4, 4);
        bigDecimal4 = null;
        bigDecimal5 = null;
        bigDecimalArray3 = null;
        bigDecimal = null;
        bigDecimal2 = null;
        return bigDecimal3;
    }

    public static BigDecimal variance(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        int n = bigIntegerArray.length;
        if (n != bigIntegerArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + bigIntegerArray2.length + " are different");
        }
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        ArrayMaths arrayMaths2 = new ArrayMaths(bigIntegerArray2);
        return Stat.variance(arrayMaths.array_as_BigDecimal(), arrayMaths2.array_as_BigDecimal());
    }

    public static double standardError(BigDecimal[] bigDecimalArray) {
        return Math.sqrt(Stat.variance(bigDecimalArray).doubleValue() / (double)bigDecimalArray.length);
    }

    public static double standardError(BigInteger[] bigIntegerArray) {
        return Math.sqrt(Stat.variance(bigIntegerArray).doubleValue() / (double)bigIntegerArray.length);
    }

    public static Complex standardError(Complex[] complexArray) {
        return Complex.sqrt(Stat.variance(complexArray).over(complexArray.length));
    }

    public static double standardErrorConjugateCalcn(Complex[] complexArray) {
        return Math.sqrt(Stat.varianceConjugateCalcn(complexArray) / (double)complexArray.length);
    }

    public static double standardErrorModuli(Complex[] complexArray) {
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        double[] dArray = arrayMaths.array_as_modulus_of_Complex();
        return Stat.standardError(dArray);
    }

    public static double standardErrorRealParts(Complex[] complexArray) {
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        double[] dArray = arrayMaths.array_as_real_part_of_Complex();
        return Stat.standardError(dArray);
    }

    public static double standardErrorImaginaryParts(Complex[] complexArray) {
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        double[] dArray = arrayMaths.array_as_imaginary_part_of_Complex();
        return Stat.standardError(dArray);
    }

    public static double standardError(double[] dArray) {
        return Math.sqrt(Stat.variance(dArray) / (double)dArray.length);
    }

    public static float standardError(float[] fArray) {
        return (float)Math.sqrt(Stat.variance(fArray) / (float)fArray.length);
    }

    public static double standardError(int[] nArray) {
        return Math.sqrt(Stat.variance(nArray) / (double)nArray.length);
    }

    public static double standardError(long[] lArray) {
        return Math.sqrt(Stat.variance(lArray) / (double)lArray.length);
    }

    public static Complex standardError(Complex[] complexArray, Complex[] complexArray2) {
        if (complexArray.length != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + complexArray.length + " and length of weight array, " + complexArray2.length + " are different");
        }
        Complex complex = Stat.effectiveSampleNumber(complexArray2);
        return Complex.sqrt(Stat.variance(complexArray, complexArray2).over(complex));
    }

    public static double standardErrorConjugateCalcn(Complex[] complexArray, Complex[] complexArray2) {
        if (complexArray.length != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + complexArray.length + " and length of weight array, " + complexArray2.length + " are different");
        }
        double d = Stat.effectiveSampleNumberConjugateCalcn(complexArray2);
        return Math.sqrt(Stat.varianceConjugateCalcn(complexArray, complexArray2) / d);
    }

    public static double standardErrorModuli(Complex[] complexArray, Complex[] complexArray2) {
        int n = complexArray.length;
        if (n != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + complexArray2.length + " are different");
        }
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        double[] dArray = arrayMaths.array_as_modulus_of_Complex();
        ArrayMaths arrayMaths2 = new ArrayMaths(complexArray2);
        double[] dArray2 = arrayMaths2.array_as_modulus_of_Complex();
        return Stat.standardError(dArray, dArray2);
    }

    public static double standardErrorRealParts(Complex[] complexArray, Complex[] complexArray2) {
        int n = complexArray.length;
        if (n != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + complexArray2.length + " are different");
        }
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        double[] dArray = arrayMaths.array_as_real_part_of_Complex();
        ArrayMaths arrayMaths2 = new ArrayMaths(complexArray2);
        double[] dArray2 = arrayMaths2.array_as_real_part_of_Complex();
        return Stat.standardError(dArray, dArray2);
    }

    public static double standardErrorImaginaryParts(Complex[] complexArray, Complex[] complexArray2) {
        int n = complexArray.length;
        if (n != complexArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n + " and length of weight array, " + complexArray2.length + " are different");
        }
        ArrayMaths arrayMaths = new ArrayMaths(complexArray);
        double[] dArray = arrayMaths.array_as_imaginary_part_of_Complex();
        ArrayMaths arrayMaths2 = new ArrayMaths(complexArray2);
        double[] dArray2 = arrayMaths2.array_as_imaginary_part_of_Complex();
        return Stat.standardError(dArray, dArray2);
    }

    public static double standardError(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2) {
        if (bigDecimalArray.length != bigDecimalArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + bigDecimalArray.length + " and length of weight array, " + bigDecimalArray2.length + " are different");
        }
        double d = Stat.effectiveSampleNumber(bigDecimalArray2).doubleValue();
        return Math.sqrt(Stat.variance(bigDecimalArray, bigDecimalArray2).doubleValue() / d);
    }

    public static double standardError(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        if (bigIntegerArray.length != bigIntegerArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + bigIntegerArray.length + " and length of weight array, " + bigIntegerArray2.length + " are different");
        }
        double d = Stat.effectiveSampleNumber(bigIntegerArray2).doubleValue();
        return Math.sqrt(Stat.variance(bigIntegerArray, bigIntegerArray2).doubleValue() / d);
    }

    public static double standardError(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + dArray.length + " and length of weight array, " + dArray2.length + " are different");
        }
        double d = Stat.effectiveSampleNumber(dArray2);
        return Math.sqrt(Stat.variance(dArray, dArray2) / d);
    }

    public static float standardError(float[] fArray, float[] fArray2) {
        float f = Stat.effectiveSampleNumber(fArray2);
        return (float)Math.sqrt(Stat.variance(fArray, fArray2) / f);
    }

    public static double covariance(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new IllegalArgumentException("length of x variable array, " + n + " and length of y array, " + dArray2.length + " are different");
        }
        double d = n - 1;
        if (nFactorOptionS) {
            d = n;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += dArray[i];
            d4 += dArray2[i];
        }
        d3 = d2 / (double)n;
        d5 = d4 / (double)n;
        double d6 = 0.0;
        for (int i = 0; i < n; ++i) {
            d6 += (dArray[i] - d3) * (dArray2[i] - d5);
        }
        return d6 / d;
    }

    public static float covariance(float[] fArray, float[] fArray2) {
        int n = fArray.length;
        if (n != fArray2.length) {
            throw new IllegalArgumentException("length of x variable array, " + n + " and length of y array, " + fArray2.length + " are different");
        }
        float f = n - 1;
        if (nFactorOptionS) {
            f = n;
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        for (int i = 0; i < n; ++i) {
            f2 += fArray[i];
            f4 += fArray2[i];
        }
        f3 = f2 / (float)n;
        f5 = f4 / (float)n;
        float f6 = 0.0f;
        for (int i = 0; i < n; ++i) {
            f6 += (fArray[i] - f3) * (fArray2[i] - f5);
        }
        return f6 / f;
    }

    public static double covariance(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        if (n != nArray2.length) {
            throw new IllegalArgumentException("length of x variable array, " + n + " and length of y array, " + nArray2.length + " are different");
        }
        double d = n - 1;
        if (nFactorOptionS) {
            d = n;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += (double)nArray[i];
            d4 += (double)nArray2[i];
        }
        d3 = d2 / (double)n;
        d5 = d4 / (double)n;
        double d6 = 0.0;
        for (int i = 0; i < n; ++i) {
            d6 += ((double)nArray[i] - d3) * ((double)nArray2[i] - d5);
        }
        return d6 / d;
    }

    public static double covariance(long[] lArray, long[] lArray2) {
        int n = lArray.length;
        if (n != lArray2.length) {
            throw new IllegalArgumentException("length of x variable array, " + n + " and length of y array, " + lArray2.length + " are different");
        }
        double d = n - 1;
        if (nFactorOptionS) {
            d = n;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += (double)lArray[i];
            d4 += (double)lArray2[i];
        }
        d3 = d2 / (double)n;
        d5 = d4 / (double)n;
        double d6 = 0.0;
        for (int i = 0; i < n; ++i) {
            d6 += ((double)lArray[i] - d3) * ((double)lArray2[i] - d5);
        }
        return d6 / d;
    }

    public static double covariance(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new IllegalArgumentException("length of x variable array, " + n + " and length of y array, " + dArray2.length + " are different");
        }
        if (n != dArray3.length) {
            throw new IllegalArgumentException("length of x variable array, " + n + " and length of weight array, " + dArray2.length + " are different");
        }
        double d = Stat.effectiveSampleNumber(dArray3);
        double d2 = d / (d - 1.0);
        if (nFactorOptionS) {
            d2 = 1.0;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double[] dArray4 = Stat.invertAndSquare(dArray3);
        for (int i = 0; i < n; ++i) {
            d3 += dArray[i] * dArray4[i];
            d4 += dArray2[i] * dArray4[i];
            d5 += dArray4[i];
        }
        d6 = d3 / d5;
        d7 = d4 / d5;
        double d8 = 0.0;
        for (int i = 0; i < n; ++i) {
            d8 += dArray4[i] * (dArray[i] - d6) * (dArray2[i] - d7);
        }
        return d8 * d2 / d5;
    }

    public static double corrCoeff(double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = 0.0;
        int n = dArray.length;
        if (dArray2.length != n) {
            throw new IllegalArgumentException("array lengths must be equal");
        }
        int n2 = n - 1;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            d3 += dArray[i];
            d4 += dArray2[i];
        }
        d3 /= (double)n;
        d4 /= (double)n;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < n; ++i) {
            d5 += Fmath.square(dArray[i] - d3);
            d6 += Fmath.square(dArray2[i] - d4);
            d7 += (dArray[i] - d3) * (dArray2[i] - d4);
        }
        double d8 = d7 / Math.sqrt(d5 * d6);
        if (d8 > 1.0 && Fmath.isEqualWithinLimits(d8, 1.0, 0.001)) {
            d8 = 1.0;
        }
        if (d8 < -1.0 && Fmath.isEqualWithinLimits(Math.abs(d8), 1.0, 0.001)) {
            d8 = -1.0;
        }
        return d8;
    }

    public static float corrCoeff(float[] fArray, float[] fArray2) {
        int n = fArray.length;
        if (fArray2.length != n) {
            throw new IllegalArgumentException("array lengths must be equal");
        }
        int n2 = fArray.length;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = fArray[i];
            dArray2[i] = fArray2[i];
        }
        return (float)Stat.corrCoeff(dArray, dArray2);
    }

    public static double corrCoeff(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        if (nArray2.length != n) {
            throw new IllegalArgumentException("array lengths must be equal");
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = nArray[i];
            dArray2[i] = nArray2[i];
        }
        return Stat.corrCoeff(dArray, dArray2);
    }

    public static double corrCoeff(double[] dArray, double[] dArray2, double[] dArray3) {
        double d;
        double d2;
        int n = dArray.length;
        if (dArray2.length != n) {
            throw new IllegalArgumentException("x and y array lengths must be equal");
        }
        if (dArray3.length != n) {
            throw new IllegalArgumentException("x and weight array lengths must be equal");
        }
        double d3 = Stat.covariance(dArray, dArray2, dArray3);
        double d4 = d3 / Math.sqrt((d2 = Stat.variance(dArray, dArray3)) * (d = Stat.variance(dArray2, dArray3)));
        if (d4 > 1.0 && Fmath.isEqualWithinLimits(d4, 1.0, 0.001)) {
            d4 = 1.0;
        }
        if (d4 < -1.0 && Fmath.isEqualWithinLimits(Math.abs(d4), 1.0, 0.001)) {
            d4 = -1.0;
        }
        return d4;
    }

    public static double corrCoeff(int n, int n2, int n3, int n4) {
        double d = (double)(n * n4 - n2 * n3) / Math.sqrt((n + n2) * (n3 + n4) * (n + n3) * (n2 + n4));
        if (d > 1.0 && Fmath.isEqualWithinLimits(d, 1.0, 0.001)) {
            d = 1.0;
        }
        if (d < -1.0 && Fmath.isEqualWithinLimits(Math.abs(d), 1.0, 0.001)) {
            d = -1.0;
        }
        return d;
    }

    public static double corrCoeff(int[][] nArray) {
        double d = nArray[0][0];
        double d2 = nArray[1][1];
        double d3 = nArray[0][1];
        double d4 = nArray[1][0];
        double d5 = (d * d2 - d3 * d4) / Math.sqrt((d + d3) * (d4 + d2) * (d + d4) * (d3 + d2));
        if (d5 > 1.0 && Fmath.isEqualWithinLimits(d5, 1.0, 0.001)) {
            d5 = 1.0;
        }
        if (d5 < -1.0 && Fmath.isEqualWithinLimits(Math.abs(d5), 1.0, 0.001)) {
            d5 = -1.0;
        }
        return d5;
    }

    public static double linearCorrCoeffProb(double d, int n) {
        return Stat.corrCoeffProb(d, n);
    }

    public static double corrCoeffCDF(double d, int n) {
        return Stat.corrCoeffProb(d, n);
    }

    public static double corrCoeffCDFtwoTailed(double d, int n) {
        return Stat.corrCoeffProb(d, n);
    }

    public static double corrCoeffCDFoneTailed(double d, int n) {
        return Stat.corrCoeffProb(d, n) / 2.0;
    }

    public static double corrCoeffProb(double d, int n) {
        if (Math.abs(d) > 1.0) {
            throw new IllegalArgumentException("|Correlation coefficient| > 1 :  " + d);
        }
        CorrCoeff corrCoeff = new CorrCoeff();
        corrCoeff.a = ((double)n - 2.0) / 2.0;
        double d2 = Integration.gaussQuad(corrCoeff, Math.abs(d), 1.0, 128);
        double d3 = 2.0 * Math.exp(Stat.logGamma(((double)n + 1.0) / 2.0) - Stat.logGamma((double)n / 2.0)) / Math.sqrt(Math.PI);
        return d3 * d2;
    }

    public static double linearCorrCoeff(double d, int n) {
        return Stat.corrCoeffPDF(d, n);
    }

    public static double corrCoeffPDF(double d, int n) {
        if (Math.abs(d) > 1.0) {
            throw new IllegalArgumentException("|Correlation coefficient| > 1 :  " + d);
        }
        double d2 = ((double)n - 2.0) / 2.0;
        double d3 = Math.pow(1.0 - Fmath.square(d), d2);
        double d4 = Math.exp(Stat.logGamma(((double)n + 1.0) / 2.0) - Stat.logGamma((double)n / 2.0)) / Math.sqrt(Math.PI);
        return d4 * d3;
    }

    public static double corrCoeffPdf(double d, int n) {
        if (Math.abs(d) > 1.0) {
            throw new IllegalArgumentException("|Correlation coefficient| > 1 :  " + d);
        }
        double d2 = ((double)n - 2.0) / 2.0;
        double d3 = Math.pow(1.0 - Fmath.square(d), d2);
        double d4 = Math.exp(Stat.logGamma(((double)n + 1.0) / 2.0) - Stat.logGamma((double)n / 2.0)) / Math.sqrt(Math.PI);
        return d4 * d3;
    }

    public static double corrCoeffInverseCDFoneTailed(double d, int n) {
        return Stat.corrCoeffInverseCDF(2.0 * d, n);
    }

    public static double corrCoeffInverseCDFtwoTailed(double d, int n) {
        return Stat.corrCoeffInverseCDF(d, n);
    }

    public static double corrCoeffInverseCDF(double d, int n) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Entered probability value, " + d + ", must lie between 0 and 1 inclusive");
        }
        double d2 = 0.0;
        if (d == 0.0) {
            d2 = 1.0;
        } else if (d == 1.0) {
            d2 = 0.0;
        } else {
            CorrCoeffFunct corrCoeffFunct = new CorrCoeffFunct();
            corrCoeffFunct.nu = n;
            double d3 = 1.0E-12;
            double d4 = 0.0;
            double d5 = 1.0;
            RealRoot realRoot = new RealRoot();
            realRoot.noBoundsExtensions();
            realRoot.setLowerBound(0.0);
            realRoot.setUpperBound(1.0);
            realRoot.setTolerance(d3);
            realRoot.resetNaNexceptionToTrue();
            realRoot.suppressLimitReachedMessage();
            realRoot.suppressNaNmessage();
            corrCoeffFunct.cfd = d;
            d2 = realRoot.bisect(corrCoeffFunct, d4, d5);
        }
        return d2;
    }

    public static double shannonEntropy(double[] dArray) {
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        double d = arrayMaths.getMaximum_as_double();
        if (d > 1.0) {
            throw new IllegalArgumentException("All probabilites must be less than or equal to 1; the maximum supplied probabilty is " + d);
        }
        double d2 = arrayMaths.getMinimum_as_double();
        if (d2 < 0.0) {
            throw new IllegalArgumentException("All probabilites must be greater than or equal to 0; the minimum supplied probabilty is " + d2);
        }
        double d3 = arrayMaths.getSum_as_double();
        if (!Fmath.isEqualWithinPerCent(d3, 1.0, 0.1)) {
            throw new IllegalArgumentException("the probabilites must add up to 1 within an error of 0.1%; they add up to " + d3);
        }
        return arrayMaths.minusxLog2x().getSum_as_double();
    }

    public static double shannonEntropyBit(double[] dArray) {
        return Stat.shannonEntropy(dArray);
    }

    public static double shannonEntropyNat(double[] dArray) {
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        double d = arrayMaths.getMaximum_as_double();
        if (d > 1.0) {
            throw new IllegalArgumentException("All probabilites must be less than or equal to 1; the maximum supplied probabilty is " + d);
        }
        double d2 = arrayMaths.getMinimum_as_double();
        if (d2 < 0.0) {
            throw new IllegalArgumentException("All probabilites must be greater than or equal to 0; the minimum supplied probabilty is " + d2);
        }
        double d3 = arrayMaths.getSum_as_double();
        if (!Fmath.isEqualWithinPerCent(d3, 1.0, 0.1)) {
            throw new IllegalArgumentException("the probabilites must add up to 1 within an error of 0.1%; they add up to " + d3);
        }
        return arrayMaths.minusxLogEx().getSum_as_double();
    }

    public static double shannonEntropyDit(double[] dArray) {
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        double d = arrayMaths.getMaximum_as_double();
        if (d > 1.0) {
            throw new IllegalArgumentException("All probabilites must be less than or equal to 1; the maximum supplied probabilty is " + d);
        }
        double d2 = arrayMaths.getMinimum_as_double();
        if (d2 < 0.0) {
            throw new IllegalArgumentException("All probabilites must be greater than or equal to 0; the minimum supplied probabilty is " + d2);
        }
        double d3 = arrayMaths.getSum_as_double();
        if (!Fmath.isEqualWithinPerCent(d3, 1.0, 0.1)) {
            throw new IllegalArgumentException("the probabilites must add up to 1 within an error of 0.1%; they add up to " + d3);
        }
        return arrayMaths.minusxLog10x().getSum_as_double();
    }

    public static double binaryShannonEntropy(double d) {
        if (d > 1.0) {
            throw new IllegalArgumentException("The probabiliy, " + d + ",  must be less than or equal to 1");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("The probabiliy, " + d + ",  must be greater than or equal to 0");
        }
        double d2 = 0.0;
        if (d > 0.0 && d < 1.0) {
            d2 = -d * Fmath.log2(d) - (1.0 - d) * Fmath.log2(1.0 - d);
        }
        return d2;
    }

    public static double binaryShannonEntropyBit(double d) {
        return Stat.binaryShannonEntropy(d);
    }

    public static double binaryShannonEntropyNat(double d) {
        if (d > 1.0) {
            throw new IllegalArgumentException("The probabiliy, " + d + ",  must be less than or equal to 1");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("The probabiliy, " + d + ",  must be greater than or equal to 0");
        }
        double d2 = 0.0;
        if (d > 0.0 && d < 1.0) {
            d2 = -d * Math.log(d) - (1.0 - d) * Math.log(1.0 - d);
        }
        return d2;
    }

    public static double binaryShannonEntropyDit(double d) {
        if (d > 1.0) {
            throw new IllegalArgumentException("The probabiliy, " + d + ",  must be less than or equal to 1");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("The probabiliy, " + d + ",  must be greater than or equal to 0");
        }
        double d2 = 0.0;
        if (d > 0.0 && d < 1.0) {
            d2 = -d * Math.log10(d) - (1.0 - d) * Math.log10(1.0 - d);
        }
        return d2;
    }

    public static double renyiEntropy(double[] dArray, double d) {
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        double d2 = arrayMaths.getMaximum_as_double();
        if (d2 > 1.0) {
            throw new IllegalArgumentException("All probabilites must be less than or equal to 1; the maximum supplied probabilty is " + d2);
        }
        double d3 = arrayMaths.getMinimum_as_double();
        if (d3 < 0.0) {
            throw new IllegalArgumentException("All probabilites must be greater than or equal to 0; the minimum supplied probabilty is " + d3);
        }
        double d4 = arrayMaths.getSum_as_double();
        if (!Fmath.isEqualWithinPerCent(d4, 1.0, 0.1)) {
            throw new IllegalArgumentException("the probabilites must add up to 1 within an error of 0.1%; they add up to " + d4);
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("alpha, " + d + ", must be greater than or equal to 0");
        }
        double d5 = 0.0;
        if (d == 0.0) {
            d5 = Fmath.log2(dArray.length);
        } else if (d == 1.0) {
            d5 = Stat.shannonEntropy(dArray);
        } else if (Fmath.isPlusInfinity(d)) {
            d5 = -Fmath.log2(d2);
        } else if (d <= 3000.0) {
            arrayMaths = arrayMaths.pow(d);
            boolean bl = false;
            if (arrayMaths.getMaximum_as_double() == Double.MIN_VALUE) {
                bl = true;
            }
            if (Fmath.isPlusInfinity(d5 = Fmath.log2(arrayMaths.getSum_as_double()) / (1.0 - d)) || bl) {
                Object object;
                double d6;
                double d7 = d5 = -Fmath.log2(d2);
                System.out.println("Stat: renyiEntropy/renyiEntopyBit: underflow or overflow in calculating the entropy");
                boolean bl2 = true;
                boolean bl3 = true;
                boolean bl4 = true;
                int n = 0;
                double d8 = d / 2.0;
                double d9 = 0.0;
                while (bl4) {
                    while (bl2) {
                        ArrayMaths arrayMaths2 = new ArrayMaths(dArray);
                        d9 = Fmath.log2((arrayMaths2 = arrayMaths2.pow(d8)).getSum_as_double()) / (1.0 - d8);
                        if (Fmath.isPlusInfinity(d9)) {
                            d8 /= 2.0;
                            if (++n != 100000) continue;
                            bl2 = false;
                            bl3 = false;
                            continue;
                        }
                        bl2 = false;
                    }
                    d6 = d8 + 40.0 * d / 1000.0;
                    ArrayMaths arrayMaths3 = new ArrayMaths(dArray);
                    double d10 = Fmath.log2((arrayMaths3 = arrayMaths3.pow(d6)).getSum_as_double()) / (1.0 - d6);
                    if (!Fmath.isPlusInfinity(d10)) {
                        bl4 = false;
                        continue;
                    }
                    d8 /= 2.0;
                }
                d6 = d9;
                double d11 = d8;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                if (bl3) {
                    double d12 = d8 / 1000.0;
                    bl2 = true;
                    while (bl2) {
                        arrayList.add(new Double(d8));
                        arrayList.add(new Double(d9));
                        d6 = d9;
                        d11 = d8;
                        object = new ArrayMaths(dArray);
                        if (!Fmath.isPlusInfinity(d9 = Fmath.log2(((ArrayMaths)(object = ((ArrayMaths)object).pow(d8 += d12))).getSum_as_double()) / (1.0 - d8))) continue;
                        bl2 = false;
                        d9 = d6;
                        d8 = d11;
                    }
                }
                int n2 = arrayList.size() / 2 - 20;
                double[] dArray2 = new double[n2];
                object = new double[n2];
                int n3 = -1;
                for (int i = 0; i < n2; ++i) {
                    dArray2[i] = (Double)arrayList.get(++n3);
                    object[i] = Math.log((Double)arrayList.get(++n3) - d7);
                }
                Regression regression = new Regression(dArray2, (double[])object);
                regression.linear();
                double[] dArray3 = regression.getCoeff();
                d5 = Math.exp(dArray3[0] + dArray3[1] * d) + d7;
                System.out.println("An interpolated entropy of " + d5 + " returned (see documentation for exponential interpolation)");
                System.out.println("Lowest calculable value =  " + (Math.exp((double)object[n2 - 1]) + d7) + ", alpha = " + dArray2[n2 - 1]);
                System.out.println("Minimum entropy value =  " + d7 + ", alpha = infinity");
            }
        } else {
            d5 = -Fmath.log2(d2);
            System.out.println("Stat: renyiEntropy/renyiEntropyBit: underflow or overflow in calculating the entropy");
            System.out.println("An interpolated entropy of " + d5 + " returned (see documentation for exponential interpolation)");
        }
        return d5;
    }

    public static double renyiEntropyNat(double[] dArray, double d) {
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        double d2 = arrayMaths.getMaximum_as_double();
        if (d2 > 1.0) {
            throw new IllegalArgumentException("All probabilites must be less than or equal to 1; the maximum supplied probabilty is " + d2);
        }
        double d3 = arrayMaths.getMinimum_as_double();
        if (d3 < 0.0) {
            throw new IllegalArgumentException("All probabilites must be greater than or equal to 0; the minimum supplied probabilty is " + d3);
        }
        double d4 = arrayMaths.getSum_as_double();
        if (!Fmath.isEqualWithinPerCent(d4, 1.0, 0.1)) {
            throw new IllegalArgumentException("the probabilites must add up to 1 within an error of 0.1%; they add up to " + d4);
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("alpha, " + d + ", must be greater than or equal to 0");
        }
        double d5 = 0.0;
        if (d == 0.0) {
            d5 = Math.log(dArray.length);
        } else if (d == 1.0) {
            d5 = Stat.shannonEntropy(dArray);
        } else if (Fmath.isPlusInfinity(d)) {
            d5 = -Math.log(d2);
        } else if (d <= 3000.0) {
            arrayMaths = arrayMaths.pow(d);
            boolean bl = false;
            if (arrayMaths.getMaximum_as_double() == Double.MIN_VALUE) {
                bl = true;
            }
            if (Fmath.isPlusInfinity(d5 = Math.log(arrayMaths.getSum_as_double()) / (1.0 - d)) || bl) {
                Object object;
                double d6;
                double d7 = d5 = -Math.log(d2);
                System.out.println("Stat: renyiEntropyNat: underflow or overflow in calculating the entropy");
                boolean bl2 = true;
                boolean bl3 = true;
                boolean bl4 = true;
                int n = 0;
                double d8 = d / 2.0;
                double d9 = 0.0;
                while (bl4) {
                    while (bl2) {
                        ArrayMaths arrayMaths2 = new ArrayMaths(dArray);
                        d9 = Math.log((arrayMaths2 = arrayMaths2.pow(d8)).getSum_as_double()) / (1.0 - d8);
                        if (Fmath.isPlusInfinity(d9)) {
                            d8 /= 2.0;
                            if (++n != 100000) continue;
                            bl2 = false;
                            bl3 = false;
                            continue;
                        }
                        bl2 = false;
                    }
                    d6 = d8 + 40.0 * d / 1000.0;
                    ArrayMaths arrayMaths3 = new ArrayMaths(dArray);
                    double d10 = Math.log((arrayMaths3 = arrayMaths3.pow(d6)).getSum_as_double()) / (1.0 - d6);
                    if (!Fmath.isPlusInfinity(d10)) {
                        bl4 = false;
                        continue;
                    }
                    d8 /= 2.0;
                }
                d6 = d9;
                double d11 = d8;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                if (bl3) {
                    double d12 = d8 / 1000.0;
                    bl2 = true;
                    while (bl2) {
                        arrayList.add(new Double(d8));
                        arrayList.add(new Double(d9));
                        d6 = d9;
                        d11 = d8;
                        object = new ArrayMaths(dArray);
                        if (!Fmath.isPlusInfinity(d9 = Math.log(((ArrayMaths)(object = ((ArrayMaths)object).pow(d8 += d12))).getSum_as_double()) / (1.0 - d8))) continue;
                        bl2 = false;
                        d9 = d6;
                        d8 = d11;
                    }
                }
                int n2 = arrayList.size() / 2 - 20;
                double[] dArray2 = new double[n2];
                object = new double[n2];
                int n3 = -1;
                for (int i = 0; i < n2; ++i) {
                    dArray2[i] = (Double)arrayList.get(++n3);
                    object[i] = Math.log((Double)arrayList.get(++n3) - d7);
                }
                Regression regression = new Regression(dArray2, (double[])object);
                regression.linear();
                double[] dArray3 = regression.getCoeff();
                d5 = Math.exp(dArray3[0] + dArray3[1] * d) + d7;
                System.out.println("An interpolated entropy of " + d5 + " returned (see documentation for exponential interpolation)");
                System.out.println("Lowest calculable value =  " + (Math.exp((double)object[n2 - 1]) + d7) + ", alpha = " + dArray2[n2 - 1]);
                System.out.println("Minimum entropy value =  " + d7 + ", alpha = infinity");
            }
        } else {
            d5 = -Math.log(d2);
            System.out.println("Stat: renyiEntropyNat: underflow or overflow in calculating the entropy");
            System.out.println("An interpolated entropy of " + d5 + " returned (see documentation for exponential interpolation)");
        }
        return d5;
    }

    public static double renyiEntropyDit(double[] dArray, double d) {
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        double d2 = arrayMaths.getMaximum_as_double();
        if (d2 > 1.0) {
            throw new IllegalArgumentException("All probabilites must be less than or equal to 1; the maximum supplied probabilty is " + d2);
        }
        double d3 = arrayMaths.getMinimum_as_double();
        if (d3 < 0.0) {
            throw new IllegalArgumentException("All probabilites must be greater than or equal to 0; the minimum supplied probabilty is " + d3);
        }
        double d4 = arrayMaths.getSum_as_double();
        if (!Fmath.isEqualWithinPerCent(d4, 1.0, 0.1)) {
            throw new IllegalArgumentException("the probabilites must add up to 1 within an error of 0.1%; they add up to " + d4);
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("alpha, " + d + ", must be greater than or equal to 0");
        }
        double d5 = 0.0;
        if (d == 0.0) {
            d5 = Math.log10(dArray.length);
        } else if (d == 1.0) {
            d5 = Stat.shannonEntropy(dArray);
        } else if (Fmath.isPlusInfinity(d)) {
            d5 = -Math.log10(d2);
        } else if (d <= 3000.0) {
            arrayMaths = arrayMaths.pow(d);
            boolean bl = false;
            if (arrayMaths.getMaximum_as_double() == Double.MIN_VALUE) {
                bl = true;
            }
            if (Fmath.isPlusInfinity(d5 = Math.log10(arrayMaths.getSum_as_double()) / (1.0 - d)) || bl) {
                Object object;
                double d6;
                double d7 = d5 = -Math.log10(d2);
                System.out.println("Stat: renyiEntropyDit: underflow or overflow in calculating the entropy");
                boolean bl2 = true;
                boolean bl3 = true;
                boolean bl4 = true;
                int n = 0;
                double d8 = d / 2.0;
                double d9 = 0.0;
                while (bl4) {
                    while (bl2) {
                        ArrayMaths arrayMaths2 = new ArrayMaths(dArray);
                        d9 = Math.log10((arrayMaths2 = arrayMaths2.pow(d8)).getSum_as_double()) / (1.0 - d8);
                        if (Fmath.isPlusInfinity(d9)) {
                            d8 /= 2.0;
                            if (++n != 100000) continue;
                            bl2 = false;
                            bl3 = false;
                            continue;
                        }
                        bl2 = false;
                    }
                    d6 = d8 + 40.0 * d / 1000.0;
                    ArrayMaths arrayMaths3 = new ArrayMaths(dArray);
                    double d10 = Math.log10((arrayMaths3 = arrayMaths3.pow(d6)).getSum_as_double()) / (1.0 - d6);
                    if (!Fmath.isPlusInfinity(d10)) {
                        bl4 = false;
                        continue;
                    }
                    d8 /= 2.0;
                }
                d6 = d9;
                double d11 = d8;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                if (bl3) {
                    double d12 = d8 / 1000.0;
                    bl2 = true;
                    while (bl2) {
                        arrayList.add(new Double(d8));
                        arrayList.add(new Double(d9));
                        d6 = d9;
                        d11 = d8;
                        object = new ArrayMaths(dArray);
                        if (!Fmath.isPlusInfinity(d9 = Math.log10(((ArrayMaths)(object = ((ArrayMaths)object).pow(d8 += d12))).getSum_as_double()) / (1.0 - d8))) continue;
                        bl2 = false;
                        d9 = d6;
                        d8 = d11;
                    }
                }
                int n2 = arrayList.size() / 2 - 20;
                double[] dArray2 = new double[n2];
                object = new double[n2];
                int n3 = -1;
                for (int i = 0; i < n2; ++i) {
                    dArray2[i] = (Double)arrayList.get(++n3);
                    object[i] = Math.log10((Double)arrayList.get(++n3) - d7);
                }
                Regression regression = new Regression(dArray2, (double[])object);
                regression.linear();
                double[] dArray3 = regression.getCoeff();
                d5 = Math.exp(dArray3[0] + dArray3[1] * d) + d7;
                System.out.println("An interpolated entropy of " + d5 + " returned (see documentation for exponential interpolation)");
                System.out.println("Lowest calculable value =  " + (Math.exp((double)object[n2 - 1]) + d7) + ", alpha = " + dArray2[n2 - 1]);
                System.out.println("Minimum entropy value =  " + d7 + ", alpha = infinity");
            }
        } else {
            d5 = -Math.log10(d2);
            System.out.println("Stat: renyiEntropyDit: underflow or overflow in calculating the entropy");
            System.out.println("An interpolated entropy of " + d5 + " returned (see documentation for exponential interpolation)");
        }
        return d5;
    }

    public static double renyiEntropyBit(double[] dArray, double d) {
        return Stat.renyiEntropy(dArray, d);
    }

    public static double tsallisEntropyNat(double[] dArray, double d) {
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        double d2 = arrayMaths.getMaximum_as_double();
        if (d2 > 1.0) {
            throw new IllegalArgumentException("All probabilites must be less than or equal to 1; the maximum supplied probabilty is " + d2);
        }
        double d3 = arrayMaths.getMinimum_as_double();
        if (d3 < 0.0) {
            throw new IllegalArgumentException("All probabilites must be greater than or equal to 0; the minimum supplied probabilty is " + d3);
        }
        double d4 = arrayMaths.getSum_as_double();
        if (!Fmath.isEqualWithinPerCent(d4, 1.0, 0.1)) {
            throw new IllegalArgumentException("the probabilites must add up to 1 within an error of 0.1%; they add up to " + d4);
        }
        if (d == 1.0) {
            return Stat.shannonEntropyNat(dArray);
        }
        arrayMaths = arrayMaths.pow(d);
        return (1.0 - arrayMaths.getSum_as_double()) / (d - 1.0);
    }

    public static double generalizedEntropyOneNat(double[] dArray, double d, double d2) {
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        double d3 = arrayMaths.getMaximum_as_double();
        if (d3 > 1.0) {
            throw new IllegalArgumentException("All probabilites must be less than or equal to 1; the maximum supplied probabilty is " + d3);
        }
        double d4 = arrayMaths.getMinimum_as_double();
        if (d4 < 0.0) {
            throw new IllegalArgumentException("All probabilites must be greater than or equal to 0; the minimum supplied probabilty is " + d4);
        }
        double d5 = arrayMaths.getSum_as_double();
        if (!Fmath.isEqualWithinPerCent(d5, 1.0, 0.1)) {
            throw new IllegalArgumentException("the probabilites must add up to 1 within an error of 0.1%; they add up to " + d5);
        }
        if (d2 == 0.0) {
            return Stat.renyiEntropyNat(dArray, d);
        }
        if (d2 == 1.0) {
            return Stat.tsallisEntropyNat(dArray, d);
        }
        if (d == 1.0) {
            Object object;
            int n;
            double[] dArray2 = new double[10];
            double[] dArray3 = new double[10];
            double d6 = 0.995;
            for (n = 0; n < 5; ++n) {
                object = arrayMaths.pow(d6);
                dArray2[n] = (1.0 - Math.pow(((ArrayMaths)object).getSum_as_double(), d2)) / (d2 * (d6 - 1.0));
                dArray3[n] = d6;
                d6 += 0.001;
            }
            d6 = 1.001;
            for (n = 5; n < 10; ++n) {
                object = arrayMaths.pow(d6);
                dArray2[n] = (1.0 - Math.pow(((ArrayMaths)object).getSum_as_double(), d2)) / (d2 * (d6 - 1.0));
                dArray3[n] = d6;
                d6 += 0.001;
            }
            Regression regression = new Regression(dArray3, dArray2);
            regression.polynomial(2);
            object = regression.getCoeff();
            return (double)(object[0] + object[1] + object[2]);
        }
        arrayMaths = arrayMaths.pow(d);
        return (1.0 - Math.pow(arrayMaths.getSum_as_double(), d2)) / (d2 * (d - 1.0));
    }

    public static double generalisedEntropyOneNat(double[] dArray, double d, double d2) {
        return Stat.generalizedEntropyOneNat(dArray, d, d2);
    }

    public static double[][] histogramBins(double[] dArray, double d, double d2, double d3) {
        int n = 0;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            if (!(dArray[i] <= d3)) continue;
            ++n;
        }
        if (n != n2) {
            double[] dArray2 = new double[n];
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                if (!(dArray[i] <= d3)) continue;
                dArray2[n3] = dArray[i];
                ++n3;
            }
            System.out.println(n2 - n + " data points, above histogram upper limit, excluded in Stat.histogramBins");
            return Stat.histogramBins(dArray2, d, d2);
        }
        return Stat.histogramBins(dArray, d, d2);
    }

    public static double[][] histogramBins(double[] dArray, double d, double d2) {
        int n;
        int n2;
        int n3;
        double d3 = Fmath.maximum(dArray);
        int n4 = (int)Math.ceil((d3 - d2) / d);
        if (d2 + (double)n4 * d > d3) {
            ++n4;
        }
        int n5 = dArray.length;
        int[] nArray = new int[n5];
        for (int i = 0; i < n5; ++i) {
            nArray[i] = 0;
        }
        double[] dArray2 = new double[n4 + 1];
        dArray2[0] = d2;
        for (int i = 1; i <= n4; ++i) {
            dArray2[i] = dArray2[i - 1] + d;
        }
        double[][] dArray3 = new double[2][n4];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray3[0][n3] = (dArray2[n3] + dArray2[n3 + 1]) / 2.0;
            dArray3[1][n3] = 0.0;
        }
        n3 = 1;
        for (n2 = 0; n2 < n5; ++n2) {
            n3 = 1;
            n = 0;
            while (n3 != 0) {
                if (n == n4 - 1) {
                    if (dArray[n2] >= dArray2[n] && dArray[n2] <= dArray2[n + 1] * (1.0 + histTol)) {
                        double[] dArray4 = dArray3[1];
                        int n6 = n;
                        dArray4[n6] = dArray4[n6] + 1.0;
                        nArray[n2] = 1;
                        n3 = 0;
                    }
                } else if (dArray[n2] >= dArray2[n] && dArray[n2] < dArray2[n + 1]) {
                    double[] dArray5 = dArray3[1];
                    int n7 = n;
                    dArray5[n7] = dArray5[n7] + 1.0;
                    nArray[n2] = 1;
                    n3 = 0;
                }
                if (n3 == 0) continue;
                if (n == n4 - 1) {
                    n3 = 0;
                    continue;
                }
                ++n;
            }
        }
        n2 = 0;
        for (n = 0; n < n5; ++n) {
            if (nArray[n] != 0) continue;
            ++n2;
            System.out.println("p " + n + " " + dArray[n] + " " + dArray2[0] + " " + dArray2[n4]);
        }
        if (n2 > 0) {
            System.out.println(n2 + " data points, outside histogram limits, excluded in Stat.histogramBins");
        }
        return dArray3;
    }

    public static double[][] histogramBins(double[] dArray, double d) {
        double d2 = Fmath.minimum(dArray);
        double d3 = Fmath.maximum(dArray);
        double d4 = d3 - d2;
        double d5 = d2;
        int n = (int)Math.ceil(d4 / d);
        double d6 = (double)n * d;
        double d7 = d6 - d4;
        if (d7 >= 0.0) {
            d5 -= d7 / 2.0;
        } else if (Math.abs(d7) / d4 > histTol) {
            boolean bl = true;
            double d8 = histTol / (double)n;
            int n2 = 0;
            while (bl) {
                d6 = (double)n * (d += d8);
                d7 = d6 - d4;
                if (d7 < 0.0) {
                    if (++n2 <= 1000) continue;
                    bl = false;
                    System.out.println("histogram method could not encompass all data within histogram\nContact Michael thomas Flanagan");
                    continue;
                }
                bl = false;
            }
        }
        return Stat.histogramBins(dArray, d, d5);
    }

    public static double[][] histogramBinsPlot(double[] dArray, double d, double d2, double d3) {
        String string = null;
        return Stat.histogramBinsPlot(dArray, d, d2, d3, string);
    }

    public static double[][] histogramBinsPlot(double[] dArray, double d, double d2, double d3, String string) {
        int n = 0;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            if (!(dArray[i] <= d3)) continue;
            ++n;
        }
        if (n != n2) {
            double[] dArray2 = new double[n];
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                if (!(dArray[i] <= d3)) continue;
                dArray2[n3] = dArray[i];
                ++n3;
            }
            System.out.println(n2 - n + " data points, above histogram upper limit, excluded in Stat.histogramBins");
            return Stat.histogramBinsPlot(dArray2, d, d2, string);
        }
        return Stat.histogramBinsPlot(dArray, d, d2, string);
    }

    public static double[][] histogramBinsPlot(double[] dArray, double d, double d2) {
        String string = null;
        return Stat.histogramBinsPlot(dArray, d, d2, string);
    }

    public static double[][] histogramBinsPlot(double[] dArray, double d, double d2, String string) {
        double[][] dArray2 = Stat.histogramBins(dArray, d, d2);
        int n = dArray2[0].length;
        int n2 = n * 3 + 1;
        double[][] dArray3 = PlotGraph.data(1, n2);
        dArray3[0][0] = d2;
        dArray3[1][0] = 0.0;
        int n3 = 1;
        for (int i = 0; i < n; ++i) {
            dArray3[0][n3] = dArray3[0][n3 - 1];
            dArray3[1][n3] = dArray2[1][i];
            dArray3[0][++n3] = dArray3[0][n3 - 1] + d;
            dArray3[1][n3] = dArray2[1][i];
            dArray3[0][++n3] = dArray3[0][n3 - 1];
            dArray3[1][n3] = 0.0;
            ++n3;
        }
        PlotGraph plotGraph = new PlotGraph(dArray3);
        plotGraph.setGraphTitle("Histogram:  Bin Width = " + d);
        plotGraph.setLine(3);
        plotGraph.setPoint(0);
        plotGraph.setYaxisLegend("Frequency");
        if (string != null) {
            plotGraph.setXaxisLegend(string);
        }
        plotGraph.plot();
        return dArray2;
    }

    public static double[][] histogramBinsPlot(double[] dArray, double d) {
        String string = null;
        return Stat.histogramBinsPlot(dArray, d, string);
    }

    public static double[][] histogramBinsPlot(double[] dArray, double d, String string) {
        double d2 = Fmath.minimum(dArray);
        double d3 = Fmath.maximum(dArray);
        double d4 = d3 - d2;
        int n = (int)Math.ceil(d4 / d);
        double d5 = (double)n * d - d4;
        double d6 = d2 - d5 / 2.0;
        return Stat.histogramBinsPlot(dArray, d, d6, string);
    }

    public static double[] uniformOrderStatisticMedians(int n) {
        double d = n;
        double[] dArray = new double[n];
        dArray[n - 1] = Math.pow(0.5, 1.0 / d);
        dArray[0] = 1.0 - dArray[n - 1];
        for (int i = 1; i < n - 1; ++i) {
            dArray[i] = ((double)(i + 1) - 0.3175) / (d + 0.365);
        }
        return dArray;
    }

    public static double gammaCDF(double d, double d2, double d3, double d4) {
        if (d4 < d) {
            throw new IllegalArgumentException("The upper limit, " + d4 + "must be equal to or greater than the location parameter, " + d);
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("The scale parameter, " + d2 + "must be greater than zero");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + d3 + "must be greater than zero");
        }
        double d5 = (d4 - d) / d2;
        return Stat.regularisedGammaFunction(d3, d5);
    }

    public static double gammaCDF(double d, double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The upper limit, " + d2 + "must be equal to or greater than zero");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + d + "must be greater than zero");
        }
        return Stat.regularisedGammaFunction(d, d2);
    }

    public static double gammaPDF(double d, double d2, double d3, double d4) {
        if (d4 < d) {
            throw new IllegalArgumentException("The variable, x, " + d4 + "must be equal to or greater than the location parameter, " + d);
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("The scale parameter, " + d2 + "must be greater than zero");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + d3 + "must be greater than zero");
        }
        double d5 = (d4 - d) / d2;
        return Math.pow(d5, d3 - 1.0) * Math.exp(-d5) / (d2 * Stat.gammaFunction(d3));
    }

    public static double gammaPDF(double d, double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The variable, x, " + d2 + "must be equal to or greater than zero");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + d + "must be greater than zero");
        }
        return Math.pow(d2, d - 1.0) * Math.exp(-d2) / Stat.gammaFunction(d);
    }

    public static double gammaMean(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("The scale parameter, " + d2 + "must be greater than zero");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + d3 + "must be greater than zero");
        }
        return d3 * d2 - d;
    }

    public static double gammaMode(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("The scale parameter, " + d2 + "must be greater than zero");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + d3 + "must be greater than zero");
        }
        double d4 = Double.NaN;
        if (d3 >= 1.0) {
            d4 = (d3 - 1.0) * d2 - d;
        }
        return d4;
    }

    public static double gammaStandardDeviation(double d, double d2, double d3) {
        return Stat.gammaStandDev(d, d2, d3);
    }

    public static double gammaStandDev(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("The scale parameter, " + d2 + "must be greater than zero");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + d3 + "must be greater than zero");
        }
        return Math.sqrt(d3) * d2;
    }

    public static double[] gammaRand(double d, double d2, double d3, int n) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("The scale parameter, " + d2 + "must be greater than zero");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + d3 + "must be greater than zero");
        }
        PsRandom psRandom = new PsRandom();
        return psRandom.gammaArray(d, d2, d3, n);
    }

    public static double[] gammaRand(double d, double d2, double d3, int n, long l) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("The scale parameter, " + d2 + "must be greater than zero");
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + d3 + "must be greater than zero");
        }
        PsRandom psRandom = new PsRandom(l);
        return psRandom.gammaArray(d, d2, d3, n);
    }

    public static double gammaFunction(double d) {
        double d2 = d;
        double d3 = d + lgfGamma + 0.5;
        double d4 = lgfCoeff[0];
        double d5 = 0.0;
        if (d >= 0.0) {
            d3 = Math.pow(d3, d + 0.5) * Math.exp(-d3);
            for (int i = 1; i <= lgfN; ++i) {
                d4 += lgfCoeff[i] / (d2 += 1.0);
            }
            d5 = d3 * Math.sqrt(Math.PI * 2) * d4 / d;
        } else {
            d5 = -Math.PI / (d * Stat.gamma(-d) * Math.sin(Math.PI * d));
        }
        return d5;
    }

    public static double gamma(double d) {
        double d2 = d;
        double d3 = d + lgfGamma + 0.5;
        double d4 = lgfCoeff[0];
        double d5 = 0.0;
        if (d >= 0.0) {
            d3 = Math.pow(d3, d + 0.5) * Math.exp(-d3);
            for (int i = 1; i <= lgfN; ++i) {
                d4 += lgfCoeff[i] / (d2 += 1.0);
            }
            d5 = d3 * Math.sqrt(Math.PI * 2) * d4 / d;
        } else {
            d5 = -Math.PI / (d * Stat.gamma(-d) * Math.sin(Math.PI * d));
        }
        return d5;
    }

    public static double getLanczosGamma() {
        return lgfGamma;
    }

    public static int getLanczosN() {
        return lgfN;
    }

    public static double[] getLanczosCoeff() {
        int n = Stat.getLanczosN() + 1;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = lgfCoeff[i];
        }
        return dArray;
    }

    public static double getFpmin() {
        return 1.0E-300;
    }

    public static double logGammaFunction(double d) {
        double d2 = d;
        double d3 = 0.0;
        double d4 = d + lgfGamma + 0.5;
        double d5 = lgfCoeff[0];
        if (d >= 0.0) {
            d4 -= (d + 0.5) * Math.log(d4);
            for (int i = 1; i <= lgfN; ++i) {
                d5 += lgfCoeff[i] / (d2 += 1.0);
            }
            d3 = Math.log(Math.sqrt(Math.PI * 2) * d5 / d) - d4;
        } else {
            d3 = Math.PI / (Stat.gamma(1.0 - d) * Math.sin(Math.PI * d));
            if (d3 != Double.POSITIVE_INFINITY && d3 != Double.NEGATIVE_INFINITY) {
                if (d3 < 0.0) {
                    throw new IllegalArgumentException("\nThe gamma function is negative");
                }
                d3 = Math.log(d3);
            }
        }
        return d3;
    }

    public static double logGamma(double d) {
        double d2 = d;
        double d3 = 0.0;
        double d4 = d + lgfGamma + 0.5;
        double d5 = lgfCoeff[0];
        if (d >= 0.0) {
            d4 -= (d + 0.5) * Math.log(d4);
            for (int i = 1; i <= lgfN; ++i) {
                d5 += lgfCoeff[i] / (d2 += 1.0);
            }
            d3 = Math.log(Math.sqrt(Math.PI * 2) * d5 / d) - d4;
        } else {
            d3 = Math.PI / (Stat.gamma(1.0 - d) * Math.sin(Math.PI * d));
            if (d3 != Double.POSITIVE_INFINITY && d3 != Double.NEGATIVE_INFINITY) {
                if (d3 < 0.0) {
                    throw new IllegalArgumentException("\nThe gamma function is negative");
                }
                d3 = Math.log(d3);
            }
        }
        return d3;
    }

    public static double[] inverseGammaFunction(double d) {
        double d2;
        double d3;
        InverseGammaFunct inverseGammaFunct;
        double d4 = 0.8856031944108839;
        double d5 = 1.4616321399961483;
        if (d < d4) {
            throw new IllegalArgumentException("Entered argument (gamma) value, " + d + ", must be equal to or greater than 0.8856031944108839 - this method does not handle the negative domain");
        }
        double[] dArray = new double[2];
        double d6 = 1.0E-12;
        if (d == 1.0) {
            dArray[0] = 1.0;
        } else if (d == d4) {
            dArray[0] = d5;
        } else {
            inverseGammaFunct = new InverseGammaFunct();
            inverseGammaFunct.gamma = d;
            d3 = 0.0;
            d2 = d5;
            RealRoot realRoot = new RealRoot();
            realRoot.noBoundsExtensions();
            realRoot.setTolerance(d6);
            realRoot.resetNaNexceptionToTrue();
            realRoot.suppressLimitReachedMessage();
            realRoot.suppressNaNmessage();
            dArray[0] = realRoot.bisect(inverseGammaFunct, d3, d2);
        }
        if (d == 1.0) {
            dArray[1] = 2.0;
        } else if (d == d4) {
            dArray[1] = d5;
        } else {
            inverseGammaFunct = new InverseGammaFunct();
            inverseGammaFunct.gamma = d;
            d3 = d5;
            d2 = 2.0;
            double d7 = 2.0;
            double d8 = Stat.gamma(d7);
            if (d > d8) {
                boolean bl = true;
                while (bl) {
                    d8 = Stat.gamma(d7 += 1.0);
                    if (!(d <= d8)) continue;
                    d2 = d7;
                    d3 = d7 - 1.0;
                    bl = false;
                }
            }
            RealRoot realRoot = new RealRoot();
            realRoot.noBoundsExtensions();
            realRoot.setTolerance(d6);
            realRoot.resetNaNexceptionToTrue();
            realRoot.suppressLimitReachedMessage();
            realRoot.suppressNaNmessage();
            dArray[1] = realRoot.bisect(inverseGammaFunct, d3, d2);
        }
        return dArray;
    }

    public static double[] gammaFunctionMinimum() {
        double[] dArray = new double[]{0.8856031944108839, 1.4616321399961483};
        return dArray;
    }

    public static double regularisedGammaFunction(double d, double d2) {
        if (d < 0.0 || d2 < 0.0) {
            throw new IllegalArgumentException("\nFunction defined only for a >= 0 and x>=0");
        }
        boolean bl = igSupress;
        igSupress = true;
        double d3 = 0.0;
        if (d2 != 0.0 && (d3 = d2 < d + 1.0 ? Stat.incompleteGammaSer(d, d2) : Stat.incompleteGammaFract(d, d2)) != d3) {
            d3 = 1.0 - Stat.crigfGaussQuad(d, d2);
        }
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        igSupress = bl;
        return d3;
    }

    public static double regularizedGammaFunction(double d, double d2) {
        return Stat.regularisedGammaFunction(d, d2);
    }

    public static double regIncompleteGamma(double d, double d2) {
        return Stat.regularisedGammaFunction(d, d2);
    }

    public static double incompleteGamma(double d, double d2) {
        return Stat.regularisedGammaFunction(d, d2);
    }

    public static double complementaryRegularisedGammaFunction(double d, double d2) {
        if (d < 0.0 || d2 < 0.0) {
            throw new IllegalArgumentException("\nFunction defined only for a >= 0 and x>=0");
        }
        boolean bl = igSupress;
        igSupress = true;
        double d3 = 1.0;
        if (d2 != 0.0) {
            d3 = d2 == Double.POSITIVE_INFINITY ? 0.0 : (d2 < d + 1.0 ? 1.0 - Stat.incompleteGammaSer(d, d2) : 1.0 - Stat.incompleteGammaFract(d, d2));
        }
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        igSupress = bl;
        return d3;
    }

    public static double complementaryRegularizedGammaFunction(double d, double d2) {
        return Stat.complementaryRegularisedGammaFunction(d, d2);
    }

    public static double incompleteGammaComplementary(double d, double d2) {
        return Stat.complementaryRegularisedGammaFunction(d, d2);
    }

    public static double regIncompleteGammaComplementary(double d, double d2) {
        return Stat.complementaryRegularisedGammaFunction(d, d2);
    }

    public static double incompleteGammaSer(double d, double d2) {
        if (d < 0.0 || d2 < 0.0) {
            throw new IllegalArgumentException("\nFunction defined only for a >= 0 and x>=0");
        }
        if (d2 >= d + 1.0) {
            throw new IllegalArgumentException("\nx >= a+1   use Continued Fraction Representation");
        }
        double d3 = 0.0;
        if (d2 != 0.0) {
            double d4;
            int n = 0;
            boolean bl = true;
            double d5 = d;
            double d6 = d4 = 1.0 / d;
            double d7 = Stat.logGamma(d);
            while (bl) {
                ++n;
                d4 += (d6 *= d2 / (d += 1.0));
                if (Math.abs(d6) < Math.abs(d4) * igfeps) {
                    d3 = d4 * Math.exp(-d2 + d5 * Math.log(d2) - d7);
                    bl = false;
                }
                if (n < igfiter) continue;
                bl = false;
                d3 = Double.NaN;
                if (igSupress) continue;
                System.out.println("\nMaximum number of iterations were exceeded in Stat.incompleteGammaSer().");
                System.out.println("NaN returned.\nIncrement = " + String.valueOf(d6) + ".");
                System.out.println("Sum = " + String.valueOf(d4) + ".\nTolerance =  " + String.valueOf(igfeps));
            }
        }
        return d3;
    }

    public static double incompleteGammaFract(double d, double d2) {
        if (d < 0.0 || d2 < 0.0) {
            throw new IllegalArgumentException("\nFunction defined only for a >= 0 and x>=0");
        }
        if (d2 < d + 1.0) {
            throw new IllegalArgumentException("\nx < a+1   Use Series Representation");
        }
        double d3 = 0.0;
        if (d2 != 0.0) {
            int n = 0;
            double d4 = 0.0;
            boolean bl = true;
            double d5 = Stat.logGamma(d);
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = d2 - d + 1.0;
            double d9 = 1.0 / d8;
            double d10 = 9.999999999999999E299;
            double d11 = d9;
            while (bl) {
                if (Math.abs(d9 = (d6 = -(d4 = (double)(++n)) * (d4 - d)) * d9 + (d8 += 2.0)) < 1.0E-300) {
                    d9 = 1.0E-300;
                }
                if (Math.abs(d10 = d8 + d6 / d10) < 1.0E-300) {
                    d10 = 1.0E-300;
                }
                d9 = 1.0 / d9;
                d7 = d9 * d10;
                d11 *= d7;
                if (Math.abs(d7 - 1.0) < igfeps) {
                    bl = false;
                }
                if (n < igfiter) continue;
                bl = false;
                d3 = Double.NaN;
                if (igSupress) continue;
                System.out.println("\nMaximum number of iterations were exceeded in Stat.incompleteGammaFract().");
                System.out.println("NaN returned.\nIncrement - 1 = " + String.valueOf(d7 - 1.0) + ".");
                System.out.println("Tolerance =  " + String.valueOf(igfeps));
            }
            d3 = 1.0 - Math.exp(-d2 + d * Math.log(d2) - d5) * d11;
        }
        return d3;
    }

    private static double crigfGaussQuad(double d, double d2) {
        double d3 = 0.0;
        double d4 = 100.0 * d;
        double d5 = d4 - d2;
        double d6 = 0.0;
        if (d4 > d2 && d5 > 100.0) {
            d6 = d5 / 1000.0;
        } else {
            d4 = d2 + 100.0;
            d5 = 100.0;
            d6 = 0.1;
        }
        int n = (int)Math.round(d5 / d6);
        d6 = d5 / (double)n;
        CrigFunct crigFunct = new CrigFunct();
        crigFunct.setA(d);
        crigFunct.setB(Stat.logGammaFunction(d));
        Integration integration = new Integration(crigFunct);
        double d7 = d2;
        double d8 = d2 + d6;
        integration.setLimits(d7, d8);
        d3 = integration.gaussQuad(64);
        boolean bl = true;
        for (int i = 1; i < n; ++i) {
            d7 = d8;
            d8 = d7 + d6;
            integration.setLimits(d7, d8);
            d3 += integration.gaussQuad(64);
        }
        return d3;
    }

    public static void igSupress() {
        igSupress = true;
    }

    public static void setIncGammaMaxIter(int n) {
        igfiter = n;
    }

    public static int getIncGammaMaxIter() {
        return igfiter;
    }

    public static void setIncGammaTol(double d) {
        igfeps = d;
    }

    public static double getIncGammaTol() {
        return igfeps;
    }

    public static int factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be a positive integer");
        }
        if (n > 12) {
            throw new IllegalArgumentException("n must less than 13 to avoid integer overflow\nTry long or double argument");
        }
        int n2 = 1;
        for (int i = 2; i <= n; ++i) {
            n2 *= i;
        }
        return n2;
    }

    public static long factorial(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("n must be a positive integer");
        }
        if (l > 20L) {
            throw new IllegalArgumentException("n must less than 21 to avoid long integer overflow\nTry double argument");
        }
        long l2 = 1L;
        for (long i = 2L; i <= l; ++i) {
            l2 *= i;
        }
        return l2;
    }

    public static BigInteger factorial(BigInteger bigInteger) {
        BigInteger bigInteger2;
        if (bigInteger.compareTo(BigInteger.ZERO) == -1) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        BigInteger bigInteger3 = bigInteger2 = BigInteger.ONE;
        BigInteger bigInteger4 = new BigInteger("2");
        while (bigInteger4.compareTo(bigInteger) != 1) {
            bigInteger3 = bigInteger3.multiply(bigInteger4);
            bigInteger4 = bigInteger4.add(bigInteger2);
        }
        bigInteger2 = null;
        bigInteger4 = null;
        return bigInteger3;
    }

    public static double factorial(double d) {
        if (d < 0.0 || d - Math.floor(d) != 0.0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double d2 = 1.0;
        for (double d3 = 2.0; d3 <= d; d3 += 1.0) {
            d2 *= d3;
        }
        return d2;
    }

    public static BigDecimal factorial(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2;
        if (bigDecimal.compareTo(BigDecimal.ZERO) == -1 || !Fmath.isInteger(bigDecimal)) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        BigDecimal bigDecimal3 = bigDecimal2 = BigDecimal.ONE;
        BigDecimal bigDecimal4 = new BigDecimal(2.0);
        while (bigDecimal4.compareTo(bigDecimal) != 1) {
            bigDecimal3 = bigDecimal3.multiply(bigDecimal4);
            bigDecimal4 = bigDecimal4.add(bigDecimal2);
        }
        bigDecimal2 = null;
        bigDecimal4 = null;
        return bigDecimal3;
    }

    public static double logFactorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("\nn, " + n + ", must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double d = 0.0;
        for (int i = 2; i <= n; ++i) {
            d += Math.log(i);
        }
        return d;
    }

    public static double logFactorial(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("\nn, " + l + ", must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double d = 0.0;
        for (long i = 2L; i <= l; ++i) {
            d += Math.log(i);
        }
        return d;
    }

    public static double logFactorial(double d) {
        if (d < 0.0 || d - Math.floor(d) != 0.0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double d2 = 0.0;
        for (double d3 = 2.0; d3 <= d; d3 += 1.0) {
            d2 += Math.log(d3);
        }
        return d2;
    }

    public static double erlangCDF(double d, int n, double d2) {
        return Stat.gammaCDF(0.0, 1.0 / d, n, d2);
    }

    public static double erlangCDF(double d, long l, double d2) {
        return Stat.gammaCDF(0.0, 1.0 / d, l, d2);
    }

    public static double erlangCDF(double d, double d2, double d3) {
        if (d2 - (double)Math.round(d2) != 0.0) {
            throw new IllegalArgumentException("kay must, mathematically, be an integer even though it may be entered as a double\nTry the Gamma distribution instead of the Erlang distribution");
        }
        return Stat.gammaCDF(0.0, 1.0 / d, d2, d3);
    }

    public static double erlangPDF(double d, int n, double d2) {
        return Stat.gammaPDF(0.0, 1.0 / d, n, d2);
    }

    public static double erlangPDF(double d, long l, double d2) {
        return Stat.gammaPDF(0.0, 1.0 / d, l, d2);
    }

    public static double erlangPDF(double d, double d2, double d3) {
        if (d2 - (double)Math.round(d2) != 0.0) {
            throw new IllegalArgumentException("kay must, mathematically, be an integer even though it may be entered as a double\nTry the Gamma distribution instead of the Erlang distribution");
        }
        return Stat.gammaPDF(0.0, 1.0 / d, d2, d3);
    }

    public static double erlangMean(double d, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("The rate parameter, " + n + "must be equal to or greater than one");
        }
        return (double)n / d;
    }

    public static double erlangMean(double d, long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("The rate parameter, " + l + "must be equal to or greater than one");
        }
        return (double)l / d;
    }

    public static double erlangMean(double d, double d2) {
        if (d2 - (double)Math.round(d2) != 0.0) {
            throw new IllegalArgumentException("kay must, mathematically, be an integer even though it may be entered as a double\nTry the Gamma distribution instead of the Erlang distribution");
        }
        if (d2 < 1.0) {
            throw new IllegalArgumentException("The rate parameter, " + d2 + "must be equal to or greater than one");
        }
        return d2 / d;
    }

    public static double erlangMode(double d, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("The rate parameter, " + n + "must be equal to or greater than one");
        }
        double d2 = Double.NaN;
        if (n >= 1) {
            d2 = ((double)n - 1.0) / d;
        }
        return d2;
    }

    public static double erlangMode(double d, long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("The rate parameter, " + l + "must be equal to or greater than one");
        }
        double d2 = Double.NaN;
        if (l >= 1L) {
            d2 = ((double)l - 1.0) / d;
        }
        return d2;
    }

    public static double erlangMode(double d, double d2) {
        if (d2 < 1.0) {
            throw new IllegalArgumentException("The rate parameter, " + d2 + "must be equal to or greater than one");
        }
        if (d2 - (double)Math.round(d2) != 0.0) {
            throw new IllegalArgumentException("kay must, mathematically, be an integer even though it may be entered as a double\nTry the Gamma distribution instead of the Erlang distribution");
        }
        double d3 = Double.NaN;
        if (d2 >= 1.0) {
            d3 = (d2 - 1.0) / d;
        }
        return d3;
    }

    public static double erlangStandardDeviation(double d, int n) {
        return Stat.erlangStandDev(d, n);
    }

    public static double erlangStandardDeviation(double d, long l) {
        return Stat.erlangStandDev(d, l);
    }

    public static double erlangStandardDeviation(double d, double d2) {
        return Stat.erlangStandDev(d, d2);
    }

    public static double erlangStandDev(double d, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("The rate parameter, " + n + "must be equal to or greater than one");
        }
        return Math.sqrt(n) / d;
    }

    public static double erlangStandDev(double d, long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("The rate parameter, " + l + "must be equal to or greater than one");
        }
        return Math.sqrt(l) / d;
    }

    public static double erlangStandDev(double d, double d2) {
        if (d2 < 1.0) {
            throw new IllegalArgumentException("The rate parameter, " + d2 + "must be equal to or greater than one");
        }
        if (d2 - (double)Math.round(d2) != 0.0) {
            throw new IllegalArgumentException("kay must, mathematically, be an integer even though it may be entered as a double\nTry the Gamma distribution instead of the Erlang distribution");
        }
        return Math.sqrt(d2) / d;
    }

    public static double[] erlangRand(double d, int n, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException("The rate parameter, " + n + "must be equal to or greater than one");
        }
        return Stat.gammaRand(0.0, 1.0 / d, n, n2);
    }

    public static double[] erlangRand(double d, long l, int n) {
        if (l < 1L) {
            throw new IllegalArgumentException("The rate parameter, " + l + "must be equal to or greater than one");
        }
        return Stat.gammaRand(0.0, 1.0 / d, l, n);
    }

    public static double[] erlangRand(double d, double d2, int n) {
        if (d2 < 1.0) {
            throw new IllegalArgumentException("The rate parameter, " + d2 + "must be equal to or greater than one");
        }
        if (d2 - (double)Math.round(d2) != 0.0) {
            throw new IllegalArgumentException("kay must, mathematically, be an integer even though it may be entered as a double\nTry the Gamma distribution instead of the Erlang distribution");
        }
        return Stat.gammaRand(0.0, 1.0 / d, d2, n);
    }

    public static double[] erlangRand(double d, int n, int n2, long l) {
        if (n < 1) {
            throw new IllegalArgumentException("The rate parameter, " + n + "must be equal to or greater than one");
        }
        return Stat.gammaRand(0.0, 1.0 / d, n, n2, l);
    }

    public static double[] erlangRand(double d, long l, int n, long l2) {
        if (l < 1L) {
            throw new IllegalArgumentException("The rate parameter, " + l + "must be equal to or greater than one");
        }
        return Stat.gammaRand(0.0, 1.0 / d, l, n, l2);
    }

    public static double[] erlangRand(double d, double d2, int n, long l) {
        if (d2 < 1.0) {
            throw new IllegalArgumentException("The rate parameter, " + d2 + "must be equal to or greater than one");
        }
        if (d2 - (double)Math.round(d2) != 0.0) {
            throw new IllegalArgumentException("kay must, mathematically, be an integer even though it may be entered as a double\nTry the Gamma distribution instead of the Erlang distribution");
        }
        return Stat.gammaRand(0.0, 1.0 / d, d2, n, l);
    }

    public static double erlangMprobability(double d, double d2, double d3) {
        double d4 = 0.0;
        if (d > 0.0) {
            double d5 = d2 * Math.log(d3) - Fmath.logFactorial(d3);
            double d6 = 1.0;
            double d7 = 1.0;
            int n = 1;
            while ((double)n <= d2) {
                d7 = d7 * d / (double)n;
                d6 += d7;
                ++n;
            }
            d6 = Math.log(d6);
            d4 = d5 - d6;
            d4 = Math.exp(d4);
        }
        return d4;
    }

    public static double erlangMprobability(double d, long l, long l2) {
        return Stat.erlangMprobability(d, (double)l, (double)l2);
    }

    public static double erlangMprobability(double d, int n, int n2) {
        return Stat.erlangMprobability(d, (double)n, (double)n2);
    }

    public static double erlangBprobability(double d, double d2) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Total traffic, " + d + ", must be greater than or equal to zero");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Total resources, " + d2 + ", must be greater than or equal to zero");
        }
        double d3 = 0.0;
        if (d2 == 0.0) {
            d3 = 1.0;
        } else if (d == 0.0) {
            d3 = 0.0;
        } else if (Fmath.isInteger(d2)) {
            d3 = 1.0;
            double d4 = 0.0;
            for (double d5 = 1.0; d5 <= d2; d5 += 1.0) {
                d4 = d3 * d;
                d3 = d4 / (d5 + d4);
            }
        } else {
            d3 = Stat.erlangBprobabilityNIR(d, d2);
        }
        return d3;
    }

    public static double erlangBprobability(double d, long l) {
        return Stat.erlangBprobability(d, (double)l);
    }

    public static double erlangBprobability(double d, int n) {
        return Stat.erlangBprobability(d, (double)n);
    }

    public static double erlangBprobabilityNIR(double d, double d2) {
        double d3 = 0.0;
        double d4 = d2 * Math.log(d) - d;
        double d5 = 1.0 + d2;
        double d6 = Stat.complementaryRegularisedGammaFunction(d5, d);
        if (d6 != d6 || d6 == 0.0) {
            int n = (int)Math.floor(d2) - 2;
            if (n < 0) {
                n = 0;
            }
            int n2 = 6;
            int[] nArray = new int[n2];
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = n + i;
                dArray[i] = nArray[i];
                dArray2[i] = Stat.erlangBprobability(d, nArray[i]);
            }
            CubicSpline cubicSpline = new CubicSpline(dArray, dArray2);
            d3 = cubicSpline.interpolate(d2);
        } else {
            double d7 = Math.log(d6) + Stat.logGammaFunction(d5);
            d3 = Math.exp(d4 - d7);
        }
        return d3;
    }

    public static double erlangBprobabilityNonIntRes(double d, double d2) {
        return Stat.erlangBprobability(d, d2);
    }

    public static double erlangBload(double d, double d2) {
        ErlangBfunct erlangBfunct = new ErlangBfunct();
        erlangBfunct.blockingProbability = d;
        erlangBfunct.totalResources = d2;
        double d3 = 0.0;
        double d4 = 20.0;
        double d5 = 1.0E-6;
        RealRoot realRoot = new RealRoot();
        realRoot.setTolerance(d5);
        realRoot.noLowerBoundExtension();
        realRoot.suppressLimitReachedMessage();
        double d6 = realRoot.bisect(erlangBfunct, d3, d4);
        return d6;
    }

    public static double erlangBload(double d, long l) {
        return Stat.erlangBload(d, (double)l);
    }

    public static double erlangBload(double d, int n) {
        return Stat.erlangBload(d, (double)n);
    }

    public static double[] erlangBresources(double d, double d2) {
        double[] dArray = new double[8];
        long l = 1L;
        double d3 = Double.NaN;
        double d4 = Double.NaN;
        boolean bl = true;
        while (bl) {
            d4 = Stat.erlangBprobability(d2, l);
            if (d4 <= d) {
                dArray[0] = l;
                dArray[1] = d4;
                dArray[2] = Stat.erlangBload(d, l);
                dArray[3] = l - 1L;
                dArray[4] = d3;
                dArray[5] = Stat.erlangBload(d, l - 1L);
                dArray[6] = d;
                dArray[7] = d2;
                bl = false;
                continue;
            }
            d3 = d4;
            if (++l != Integer.MAX_VALUE) continue;
            System.out.println("Method erlangBresources: no solution found below 9223372036854775807resources");
            for (int i = 0; i < 8; ++i) {
                dArray[i] = Double.NaN;
            }
            bl = false;
        }
        return dArray;
    }

    public static double erlangCprobability(double d, double d2) {
        double d3 = 0.0;
        if (d > 0.0) {
            double d4 = Stat.erlangBprobability(d, d2);
            d3 = 1.0 + (1.0 / d4 - 1.0) * (d2 - d) / d2;
            d3 = 1.0 / d3;
        }
        return d3;
    }

    public static double erlangCprobability(double d, long l) {
        return Stat.erlangCprobability(d, (double)l);
    }

    public static double erlangCprobability(double d, int n) {
        return Stat.erlangCprobability(d, (double)n);
    }

    public static double erlangCload(double d, double d2) {
        ErlangCfunct erlangCfunct = new ErlangCfunct();
        erlangCfunct.nonZeroDelayProbability = d;
        erlangCfunct.totalResources = d2;
        double d3 = 0.0;
        double d4 = 10.0;
        double d5 = 1.0E-6;
        RealRoot realRoot = new RealRoot();
        realRoot.setTolerance(d5);
        realRoot.suppressLimitReachedMessage();
        realRoot.noLowerBoundExtension();
        double d6 = realRoot.bisect(erlangCfunct, d3, d4);
        return d6;
    }

    public static double erlangCload(double d, long l) {
        return Stat.erlangCload(d, (double)l);
    }

    public static double erlangCload(double d, int n) {
        return Stat.erlangCload(d, (double)n);
    }

    public static double[] erlangCresources(double d, double d2) {
        double[] dArray = new double[8];
        long l = 1L;
        double d3 = Double.NaN;
        double d4 = Double.NaN;
        boolean bl = true;
        while (bl) {
            d4 = Stat.erlangCprobability(d2, l);
            if (d4 <= d) {
                dArray[0] = l;
                dArray[1] = d4;
                dArray[2] = Stat.erlangCload(d, l);
                dArray[3] = l - 1L;
                dArray[4] = d3;
                dArray[5] = Stat.erlangCload(d, l - 1L);
                dArray[6] = d;
                dArray[7] = d2;
                bl = false;
                continue;
            }
            d3 = d4;
            if (++l != Integer.MAX_VALUE) continue;
            System.out.println("Method erlangCresources: no solution found below 9223372036854775807resources");
            for (int i = 0; i < 8; ++i) {
                dArray[i] = Double.NaN;
            }
            bl = false;
        }
        return dArray;
    }

    public static double engsetProbability(double d, double d2, double d3) {
        if (d2 < 1.0) {
            throw new IllegalArgumentException("Total resources, " + d2 + ", must be an integer greater than or equal to 1");
        }
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("Total resources, " + d2 + ", must be, arithmetically, an integer");
        }
        if (d3 < 1.0) {
            throw new IllegalArgumentException("number of sources, " + d3 + ", must be an integer greater than or equal to 1");
        }
        if (!Fmath.isInteger(d3)) {
            throw new IllegalArgumentException("number of sources, " + d3 + ", must be, arithmetically, an integer");
        }
        if (d2 > d3 - 1.0) {
            throw new IllegalArgumentException("total resources, " + d2 + ", must be less than or  equal to the number of sources minus one, " + (d3 - 1.0));
        }
        if (d >= d3) {
            throw new IllegalArgumentException("Number of sources, " + d3 + ", must be greater than the offered traffic, " + d);
        }
        double d4 = 0.0;
        if (d2 == 0.0) {
            d4 = 1.0;
        } else if (d == 0.0) {
            d4 = 0.0;
        } else {
            double d5 = 0.0;
            double d6 = 1.0;
            EngsetProb engsetProb = new EngsetProb();
            engsetProb.offeredTraffic = d;
            engsetProb.totalResources = d2;
            engsetProb.numberOfSources = d3;
            RealRoot realRoot = new RealRoot();
            realRoot.suppressLimitReachedMessage();
            d4 = realRoot.bisect(engsetProb, d5, d6);
        }
        return d4;
    }

    public static double engsetProbability(double d, long l, long l2) {
        return Stat.engsetProbability(d, (double)l, (double)l2);
    }

    public static double engsetProbability(double d, int n, int n2) {
        return Stat.engsetProbability(d, (double)n, (double)n2);
    }

    public static double engsetLoad(double d, double d2, double d3) {
        if (d2 < 1.0) {
            throw new IllegalArgumentException("Total resources, " + d2 + ", must be an integer greater than or equal to 1");
        }
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("Total resources, " + d2 + ", must be, arithmetically, an integer");
        }
        if (d3 < 1.0) {
            throw new IllegalArgumentException("number of sources, " + d3 + ", must be an integer greater than or equal to 1");
        }
        if (!Fmath.isInteger(d3)) {
            throw new IllegalArgumentException("number of sources, " + d3 + ", must be, arithmetically, an integer");
        }
        if (d2 > d3 - 1.0) {
            throw new IllegalArgumentException("total resources, " + d2 + ", must be less than or  equal to the number of sources minus one, " + (d3 - 1.0));
        }
        EngsetLoad engsetLoad = new EngsetLoad();
        engsetLoad.blockingProbability = d;
        engsetLoad.totalResources = d2;
        engsetLoad.numberOfSources = d3;
        double d4 = 0.0;
        double d5 = d3 * 0.999999999;
        double d6 = 1.0E-6;
        RealRoot realRoot = new RealRoot();
        realRoot.setTolerance(d6);
        realRoot.noLowerBoundExtension();
        realRoot.noUpperBoundExtension();
        realRoot.suppressLimitReachedMessage();
        double d7 = realRoot.bisect(engsetLoad, d4, d5);
        return d7;
    }

    public static double engsetLoad(double d, long l, long l2) {
        return Stat.engsetLoad(d, (double)l, (double)l2);
    }

    public static double engsetLoad(double d, int n, int n2) {
        return Stat.engsetLoad(d, (double)n, (double)n2);
    }

    public static double[] engsetResources(double d, double d2, double d3) {
        if (d3 < 1.0) {
            throw new IllegalArgumentException("number of sources, " + d3 + ", must be an integer greater than or equal to 1");
        }
        if (!Fmath.isInteger(d3)) {
            throw new IllegalArgumentException("number of sources, " + d3 + ", must be, arithmetically, an integer");
        }
        double[] dArray = new double[9];
        long l = 1L;
        double d4 = Double.NaN;
        double d5 = Double.NaN;
        boolean bl = true;
        while (bl) {
            d5 = Stat.engsetProbability(d2, (double)l, d3);
            if (d5 <= d) {
                dArray[0] = l;
                dArray[1] = d5;
                dArray[2] = Stat.engsetLoad(d, (double)l, d3);
                dArray[3] = l - 1L;
                dArray[4] = d4;
                dArray[5] = Stat.engsetLoad(d, (double)(l - 1L), d3);
                dArray[6] = d;
                dArray[7] = d2;
                dArray[8] = d3;
                bl = false;
                continue;
            }
            d4 = d5;
            if (++l <= (long)d3 - 1L) continue;
            System.out.println("Method engsetResources: no solution found below the (sources-1), " + (d3 - 1.0));
            for (int i = 0; i < 8; ++i) {
                dArray[i] = Double.NaN;
            }
            bl = false;
        }
        return dArray;
    }

    public static double[] engsetResources(double d, double d2, long l) {
        return Stat.engsetResources(d, d2, (double)l);
    }

    public static double[] engsetResources(double d, double d2, int n) {
        return Stat.engsetResources(d, d2, (double)n);
    }

    public static double[] engsetSources(double d, double d2, double d3) {
        if (d3 < 1.0) {
            throw new IllegalArgumentException("resources, " + d3 + ", must be an integer greater than or equal to 1");
        }
        if (!Fmath.isInteger(d3)) {
            throw new IllegalArgumentException("resources, " + d3 + ", must be, arithmetically, an integer");
        }
        double[] dArray = new double[9];
        long l = (long)d3 + 1L;
        double d4 = Double.NaN;
        double d5 = Double.NaN;
        boolean bl = true;
        while (bl) {
            d5 = Stat.engsetProbability(d2, d3, (double)l);
            if (d5 >= d) {
                dArray[0] = l;
                dArray[1] = d5;
                dArray[2] = Stat.engsetLoad(d, d3, (double)l);
                dArray[3] = l - 1L;
                dArray[4] = d4;
                dArray[5] = l - 1L >= (long)(d3 + 1.0) ? Stat.engsetLoad(d, d3, (double)(l - 1L)) : Double.NaN;
                dArray[6] = d;
                dArray[7] = d2;
                dArray[8] = d3;
                bl = false;
                continue;
            }
            d4 = d5;
            if (++l < Long.MAX_VALUE) continue;
            System.out.println("Method engsetResources: no solution found below 9223372036854775807sources");
            for (int i = 0; i < 8; ++i) {
                dArray[i] = Double.NaN;
            }
            bl = false;
        }
        return dArray;
    }

    public static double[] engsetSources(double d, double d2, long l) {
        return Stat.engsetSources(d, d2, (double)l);
    }

    public static double[] engsetSources(double d, double d2, int n) {
        return Stat.engsetSources(d, d2, (double)n);
    }

    public static double betaCDF(double d, double d2, double d3) {
        return Stat.betaCDF(0.0, 1.0, d, d2, d3);
    }

    public static double betaCDF(double d, double d2, double d3, double d4, double d5) {
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + d3 + "must be greater than zero");
        }
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, beta, " + d4 + "must be greater than zero");
        }
        if (d5 < d) {
            throw new IllegalArgumentException("limit, " + d5 + ", must be greater than or equal to the minimum value, " + d);
        }
        if (d5 > d2) {
            throw new IllegalArgumentException("limit, " + d5 + ", must be less than or equal to the maximum value, " + d2);
        }
        return Stat.regularisedBetaFunction(d3, d4, (d5 - d) / (d2 - d));
    }

    public static double betaPDF(double d, double d2, double d3) {
        return Stat.betaPDF(0.0, 1.0, d, d2, d3);
    }

    public static double betaPDF(double d, double d2, double d3, double d4, double d5) {
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + d3 + "must be greater than zero");
        }
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, beta, " + d4 + "must be greater than zero");
        }
        if (d5 < d) {
            throw new IllegalArgumentException("x, " + d5 + ", must be greater than or equal to the minimum value, " + d);
        }
        if (d5 > d2) {
            throw new IllegalArgumentException("x, " + d5 + ", must be less than or equal to the maximum value, " + d2);
        }
        double d6 = Math.pow(d5 - d, d3 - 1.0) * Math.pow(d2 - d5, d4 - 1.0) / Math.pow(d2 - d, d3 + d4 - 1.0);
        return d6 / Stat.betaFunction(d3, d4);
    }

    public static double[] betaRand(double d, double d2, int n) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + d + "must be greater than zero");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, beta, " + d2 + "must be greater than zero");
        }
        PsRandom psRandom = new PsRandom();
        return psRandom.betaArray(d, d2, n);
    }

    public static double[] betaRand(double d, double d2, double d3, double d4, int n) {
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + d3 + "must be greater than zero");
        }
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, beta, " + d4 + "must be greater than zero");
        }
        PsRandom psRandom = new PsRandom();
        return psRandom.betaArray(d, d2, d3, d4, n);
    }

    public static double[] betaRand(double d, double d2, int n, long l) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + d + "must be greater than zero");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter,  beta, " + d2 + "must be greater than zero");
        }
        PsRandom psRandom = new PsRandom(l);
        return psRandom.betaArray(d, d2, n);
    }

    public static double[] betaRand(double d, double d2, double d3, double d4, int n, long l) {
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + d3 + "must be greater than zero");
        }
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter,  beta, " + d4 + "must be greater than zero");
        }
        PsRandom psRandom = new PsRandom(l);
        return psRandom.betaArray(d, d2, d3, d4, n);
    }

    public static double betaMean(double d, double d2) {
        return Stat.betaMean(0.0, 1.0, d, d2);
    }

    public static double betaMean(double d, double d2, double d3, double d4) {
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + d3 + "must be greater than zero");
        }
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, beta, " + d4 + "must be greater than zero");
        }
        return d + d3 * (d2 - d) / (d3 + d4);
    }

    public static double betaMode(double d, double d2) {
        return Stat.betaMode(0.0, 1.0, d, d2);
    }

    public static double betaMode(double d, double d2, double d3, double d4) {
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + d3 + "must be greater than zero");
        }
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, beta, " + d4 + "must be greater than zero");
        }
        double d5 = Double.NaN;
        if (d3 > 1.0) {
            d5 = d4 > 1.0 ? d + (d3 + d4) * (d2 - d) / (d3 + d4 - 2.0) : d2;
        } else if (d3 == 1.0) {
            d5 = d4 > 1.0 ? d : (d4 == 1.0 ? Double.NaN : d2);
        } else if (d4 >= 1.0) {
            d5 = d;
        } else {
            System.out.println("Class Stat; method betaMode; distribution is bimodal wirh modes at " + d + " and " + d2);
            System.out.println("NaN returned");
        }
        return d5;
    }

    public static double betaStandardDeviation(double d, double d2) {
        return Stat.betaStandDev(d, d2);
    }

    public static double betaStandDev(double d, double d2) {
        return Stat.betaStandDev(0.0, 1.0, d, d2);
    }

    public static double betaStandardDeviation(double d, double d2, double d3, double d4) {
        return Stat.betaStandDev(d, d2, d3, d4);
    }

    public static double betaStandDev(double d, double d2, double d3, double d4) {
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + d3 + "must be greater than zero");
        }
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, beta, " + d4 + "must be greater than zero");
        }
        return (d2 - d) / (d3 + d4) * Math.sqrt(d3 * d4 / (d3 + d4 + 1.0));
    }

    public static double betaFunction(double d, double d2) {
        return Math.exp(Stat.logGamma(d) + Stat.logGamma(d2) - Stat.logGamma(d + d2));
    }

    public static double beta(double d, double d2) {
        return Math.exp(Stat.logGamma(d) + Stat.logGamma(d2) - Stat.logGamma(d + d2));
    }

    public static double regularisedBetaFunction(double d, double d2, double d3) {
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("Argument x, " + d3 + ", must be lie between 0 and 1 (inclusive)");
        }
        double d4 = 0.0;
        if (d3 == 0.0) {
            d4 = 0.0;
        } else if (d3 == 1.0) {
            d4 = 1.0;
        } else {
            d4 = Math.exp(Stat.logGamma(d + d2) - Stat.logGamma(d) - Stat.logGamma(d2) + d * Math.log(d3) + d2 * Math.log(1.0 - d3));
            d4 = d3 < (d + 1.0) / (d + d2 + 2.0) ? d4 * Stat.contFract(d, d2, d3) / d : 1.0 - d4 * Stat.contFract(d2, d, 1.0 - d3) / d2;
        }
        return d4;
    }

    public static double regularizedBetaFunction(double d, double d2, double d3) {
        return Stat.regularisedBetaFunction(d, d2, d3);
    }

    public static double incompleteBeta(double d, double d2, double d3) {
        return Stat.regularisedBetaFunction(d, d2, d3);
    }

    public static double contFract(double d, double d2, double d3) {
        double d4 = d + d2;
        double d5 = d + 1.0;
        double d6 = d - 1.0;
        double d7 = 1.0;
        double d8 = 1.0 - d4 * d3 / d5;
        if (Math.abs(d8) < 1.0E-300) {
            d8 = 1.0E-300;
        }
        double d9 = d8 = 1.0 / d8;
        double d10 = 0.0;
        double d11 = 0.0;
        int n = 1;
        int n2 = 0;
        boolean bl = true;
        while (bl) {
            n2 = 2 * n;
            d10 = (double)n * (d2 - (double)n) * d3 / ((d6 + (double)n2) * (d + (double)n2));
            if (Math.abs(d8 = 1.0 + d10 * d8) < 1.0E-300) {
                d8 = 1.0E-300;
            }
            if (Math.abs(d7 = 1.0 + d10 / d7) < 1.0E-300) {
                d7 = 1.0E-300;
            }
            d8 = 1.0 / d8;
            d9 *= d8 * d7;
            d10 = -(d + (double)n) * (d4 + (double)n) * d3 / ((d + (double)n2) * (d5 + (double)n2));
            if (Math.abs(d8 = 1.0 + d10 * d8) < 1.0E-300) {
                d8 = 1.0E-300;
            }
            if (Math.abs(d7 = 1.0 + d10 / d7) < 1.0E-300) {
                d7 = 1.0E-300;
            }
            d8 = 1.0 / d8;
            d11 = d8 * d7;
            d9 *= d11;
            ++n;
            if (Math.abs(d11 - 1.0) < cfTol) {
                bl = false;
            }
            if (n <= cfMaxIter) continue;
            bl = false;
            System.out.println("Maximum number of iterations (" + cfMaxIter + ") exceeded in Stat.contFract in Stat.incompleteBeta");
        }
        return d9;
    }

    public static void resetCFmaxIter(int n) {
        cfMaxIter = n;
    }

    public static int getCFmaxIter() {
        return cfMaxIter;
    }

    public static void resetCFtolerance(double d) {
        cfTol = d;
    }

    public static double getCFtolerance() {
        return cfTol;
    }

    public static double erf(double d) {
        double d2 = 0.0;
        if (d != 0.0) {
            d2 = d == Double.POSITIVE_INFINITY ? 1.0 : (d >= 0.0 ? Stat.incompleteGamma(0.5, d * d) : -Stat.incompleteGamma(0.5, d * d));
        }
        return d2;
    }

    public static double erfc(double d) {
        double d2 = 1.0;
        if (d != 0.0) {
            d2 = d == Double.POSITIVE_INFINITY ? 0.0 : (d >= 0.0 ? 1.0 - Stat.incompleteGamma(0.5, d * d) : 1.0 + Stat.incompleteGamma(0.5, d * d));
        }
        return d2;
    }

    public static double normalCDF(double d, double d2, double d3) {
        double d4 = Double.NaN;
        if (d3 == Double.POSITIVE_INFINITY) {
            d4 = 1.0;
        } else if (d3 == Double.NEGATIVE_INFINITY) {
            d4 = 0.0;
        } else {
            double d5 = (d3 - d) / (d2 * Math.sqrt(2.0));
            d4 = (1.0 + Stat.erf(d5)) / 2.0;
        }
        if (Fmath.isNaN(d4)) {
            d4 = d3 > d ? 1.0 : 0.0;
        }
        return d4;
    }

    public static double normalProb(double d, double d2, double d3) {
        if (d3 == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (d3 == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        double d4 = (d3 - d) / (d2 * Math.sqrt(2.0));
        return (1.0 + Stat.erf(d4)) / 2.0;
    }

    public static double gaussianCDF(double d, double d2, double d3) {
        return Stat.normalCDF(d, d2, d3);
    }

    public static double gaussianProb(double d, double d2, double d3) {
        return Stat.normalCDF(d, d2, d3);
    }

    public static double normalCDF(double d, double d2, double d3, double d4) {
        return Stat.normalCDF(d, d2, d4) - Stat.normalCDF(d, d2, d3);
    }

    public static double normalProb(double d, double d2, double d3, double d4) {
        return Stat.normalCDF(d, d2, d4) - Stat.normalCDF(d, d2, d3);
    }

    public static double gaussianCDF(double d, double d2, double d3, double d4) {
        return Stat.normalCDF(d, d2, d4) - Stat.normalCDF(d, d2, d3);
    }

    public static double gaussianProb(double d, double d2, double d3, double d4) {
        return Stat.normalCDF(d, d2, d4) - Stat.normalCDF(d, d2, d3);
    }

    public static double gaussianInverseCDF(double d, double d2, double d3) {
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + d3 + ", must lie between 0 and 1 inclusive");
        }
        double d4 = 0.0;
        if (d3 == 0.0) {
            d4 = Double.NEGATIVE_INFINITY;
        } else if (d3 == 1.0) {
            d4 = Double.POSITIVE_INFINITY;
        } else {
            GaussianFunct gaussianFunct = new GaussianFunct();
            gaussianFunct.mean = d;
            gaussianFunct.sd = d2;
            double d5 = 1.0E-12;
            double d6 = d - 10.0 * d2;
            double d7 = d + 10.0 * d2;
            RealRoot realRoot = new RealRoot();
            realRoot.setTolerance(d5);
            realRoot.resetNaNexceptionToTrue();
            realRoot.suppressLimitReachedMessage();
            realRoot.suppressNaNmessage();
            gaussianFunct.cfd = d3;
            d4 = realRoot.bisect(gaussianFunct, d6, d7);
        }
        return d4;
    }

    public static double inverseGaussianCDF(double d, double d2, double d3) {
        return Stat.gaussianInverseCDF(d, d2, d3);
    }

    public static double normalInverseCDF(double d, double d2, double d3) {
        return Stat.gaussianInverseCDF(d, d2, d3);
    }

    public static double inverseNormalCDF(double d, double d2, double d3) {
        return Stat.gaussianInverseCDF(d, d2, d3);
    }

    public static double gaussianInverseCDF(double d) {
        return Stat.gaussianInverseCDF(0.0, 1.0, d);
    }

    public static double inverseGaussianCDF(double d) {
        return Stat.gaussianInverseCDF(0.0, 1.0, d);
    }

    public static double normalInverseCDF(double d) {
        return Stat.gaussianInverseCDF(0.0, 1.0, d);
    }

    public static double inverseNormalCDF(double d) {
        return Stat.gaussianInverseCDF(0.0, 1.0, d);
    }

    public static double[] meanConfidenceLimits(double d, double d2, double d3) {
        double[] dArray = new double[2];
        double d4 = d3 / 2.0 + 0.5;
        double d5 = Stat.gaussianInverseCDF(d, d2, d4);
        dArray[0] = 2.0 * d - d5;
        dArray[1] = d5;
        return dArray;
    }

    public double[] meanConfidenceLimits(double d) {
        double[] dArray = new double[2];
        double d2 = d / 2.0 + 0.5;
        double d3 = this.mean();
        double d4 = this.standardDeviation();
        double d5 = Stat.gaussianInverseCDF(d3, d4, d2);
        dArray[0] = 2.0 * d3 - d5;
        dArray[1] = d5;
        return dArray;
    }

    public static double[] gaussianOrderStatisticMedians(double d, double d2, int n) {
        double d3 = n;
        double[] dArray = new double[n];
        double[] dArray2 = Stat.uniformOrderStatisticMedians(n);
        for (int i = 0; i < n; ++i) {
            dArray[i] = Stat.inverseGaussianCDF(d, d2, dArray2[i]);
        }
        dArray = Stat.scale(dArray, d, d2);
        return dArray;
    }

    public static double[] normalOrderStatisticMedians(double d, double d2, int n) {
        return Stat.gaussianOrderStatisticMedians(d, d2, n);
    }

    public static double[] gaussianOrderStatisticMedians(int n) {
        return Stat.gaussianOrderStatisticMedians(0.0, 1.0, n);
    }

    public static double[] normalOrderStatisticMedians(int n) {
        return Stat.gaussianOrderStatisticMedians(0.0, 1.0, n);
    }

    public static double normalPDF(double d, double d2, double d3) {
        return Math.exp(-Fmath.square((d3 - d) / d2) / 2.0) / (d2 * Math.sqrt(Math.PI * 2));
    }

    public static double normal(double d, double d2, double d3) {
        return Math.exp(-Fmath.square((d3 - d) / d2) / 2.0) / (d2 * Math.sqrt(Math.PI * 2));
    }

    public static double gaussianPDF(double d, double d2, double d3) {
        return Math.exp(-Fmath.square((d3 - d) / d2) / 2.0) / (d2 * Math.sqrt(Math.PI * 2));
    }

    public static double gaussian(double d, double d2, double d3) {
        return Math.exp(-Fmath.square((d3 - d) / d2) / 2.0) / (d2 * Math.sqrt(Math.PI * 2));
    }

    public static double[] normalRand(double d, double d2, int n) {
        int n2;
        double[] dArray = new double[n];
        Random random = new Random();
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = random.nextGaussian();
        }
        dArray = Stat.standardize(dArray);
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = dArray[n2] * d2 + d;
        }
        return dArray;
    }

    public static double[] gaussianRand(double d, double d2, int n) {
        return Stat.normalRand(d, d2, n);
    }

    public static double[] normalRand(double d, double d2, int n, long l) {
        int n2;
        double[] dArray = new double[n];
        Random random = new Random(l);
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = random.nextGaussian();
        }
        dArray = Stat.standardize(dArray);
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = dArray[n2] * d2 + d;
        }
        return dArray;
    }

    public static double[] gaussianRand(double d, double d2, int n, long l) {
        return Stat.normalRand(d, d2, n, l);
    }

    public static double logNormalCDF(double d, double d2, double d3) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The parameter sigma, " + d2 + ", must be greater than or equal to zero");
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        return 0.5 * (1.0 + Stat.erf((Math.log(d3) - d) / (d2 * Math.sqrt(2.0))));
    }

    public static double logNormalTwoParCDF(double d, double d2, double d3) {
        return Stat.logNormalCDF(d, d2, d3);
    }

    public static double logNormalCDF(double d, double d2, double d3, double d4) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The parameter sigma, " + d2 + ", must be greater than or equal to zero");
        }
        if (d4 < d3) {
            throw new IllegalArgumentException("The upper limit, " + d4 + ", must be greater than the " + d3);
        }
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        if (d3 != d4) {
            if (d4 > 0.0) {
                d5 = 0.5 * (1.0 + Stat.erf((Math.log(d4) - d) / (d2 * Math.sqrt(2.0))));
            }
            if (d3 > 0.0) {
                d6 = 0.5 * (1.0 + Stat.erf((Math.log(d3) - d) / (d2 * Math.sqrt(2.0))));
            }
            d7 = d5 - d6;
        }
        return d7;
    }

    public static double logNormalTwoParCDF(double d, double d2, double d3, double d4) {
        return Stat.logNormalCDF(d, d2, d3, d4);
    }

    public static double logNormalInverseCDF(double d, double d2, double d3) {
        double d4 = 0.0;
        double d5 = d2;
        double d6 = Math.exp(d);
        return Stat.logNormalInverseCDF(d4, d5, d6, d3);
    }

    public static double logNormaltwoParInverseCDF(double d, double d2, double d3) {
        double d4 = 0.0;
        double d5 = d2;
        double d6 = Math.exp(d);
        return Stat.logNormalInverseCDF(d4, d5, d6, d3);
    }

    public static double logNormalPDF(double d, double d2, double d3) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The parameter sigma, " + d2 + ", must be greater than or equal to zero");
        }
        if (d3 < 0.0) {
            return 0.0;
        }
        return Math.exp(-0.5 * Fmath.square((Math.log(d3) - d) / d2)) / (d3 * d2 * Math.sqrt(Math.PI * 2));
    }

    public static double logNormalTwoParPDF(double d, double d2, double d3) {
        return Stat.logNormalPDF(d, d2, d3);
    }

    public static double logNormalMean(double d, double d2) {
        return Math.exp(d + d2 * d2 / 2.0);
    }

    public static double logNormalTwoParMean(double d, double d2) {
        return Math.exp(d + d2 * d2 / 2.0);
    }

    public static double logNormalStandardDeviation(double d, double d2) {
        return Stat.logNormalStandDev(d, d2);
    }

    public static double logNormalStandDev(double d, double d2) {
        double d3 = d2 * d2;
        return Math.sqrt((Math.exp(d3) - 1.0) * Math.exp(2.0 * d + d3));
    }

    public static double logNormalTwoParStandardDeviation(double d, double d2) {
        return Stat.logNormalTwoParStandDev(d, d2);
    }

    public static double logNormalTwoParStandDev(double d, double d2) {
        double d3 = d2 * d2;
        return Math.sqrt((Math.exp(d3) - 1.0) * Math.exp(2.0 * d + d3));
    }

    public static double logNormalMode(double d, double d2) {
        return Math.exp(d - d2 * d2);
    }

    public static double logNormalTwoParMode(double d, double d2) {
        return Math.exp(d - d2 * d2);
    }

    public static double logNormalMedian(double d) {
        return Math.exp(d);
    }

    public static double logNormalTwoParMedian(double d) {
        return Math.exp(d);
    }

    public static double[] logNormalRand(double d, double d2, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The number of random deviates required, " + n + ", must be greater than zero");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The parameter sigma, " + d2 + ", must be greater than or equal to zero");
        }
        PsRandom psRandom = new PsRandom();
        return psRandom.logNormalArray(d, d2, n);
    }

    public static double[] logNormalTwoParRand(double d, double d2, int n) {
        return Stat.logNormalRand(d, d2, n);
    }

    public static double[] logNormalOrderStatisticMedians(double d, double d2, int n) {
        double d3 = 0.0;
        double d4 = d2;
        double d5 = Math.exp(d);
        return Stat.logNormalOrderStatisticMedians(d3, d4, d5, n);
    }

    public static double[] logNormalTwoParOrderStatisticMedians(double d, double d2, int n) {
        return Stat.logNormalOrderStatisticMedians(d, d2, n);
    }

    public static double[] logNormalRand(double d, double d2, int n, long l) {
        if (n <= 0) {
            throw new IllegalArgumentException("The number of random deviates required, " + n + ", must be greater than zero");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The parameter sigma, " + d2 + ", must be greater than or equal to zero");
        }
        PsRandom psRandom = new PsRandom(l);
        return psRandom.logNormalArray(d, d2, n);
    }

    public static double[] logNormalTwoParRand(double d, double d2, int n, long l) {
        return Stat.logNormalRand(d, d2, n, l);
    }

    public static double logNormalThreeParCDF(double d, double d2, double d3, double d4) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The parameter beta, " + d2 + ", must be greater than or equal to zero");
        }
        if (d4 <= d) {
            return 0.0;
        }
        return 0.5 * (1.0 + Stat.erf(Math.log((d4 - d) / d3) / (d2 * Math.sqrt(2.0))));
    }

    public static double logNormalThreeParCDF(double d, double d2, double d3, double d4, double d5) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The parameter beta, " + d2 + ", must be greater than or equal to zero");
        }
        if (d5 < d4) {
            throw new IllegalArgumentException("The upper limit, " + d5 + ", must be greater than the " + d4);
        }
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        if (d4 != d5) {
            if (d5 > d) {
                d6 = 0.5 * (1.0 + Stat.erf(Math.log((d5 - d) / d3) / (d2 * Math.sqrt(2.0))));
            }
            if (d4 > d) {
                d7 = 0.5 * (1.0 + Stat.erf(Math.log((d4 - d) / d3) / (d2 * Math.sqrt(2.0))));
            }
            d8 = d6 - d7;
        }
        return d8;
    }

    public static double logNormalInverseCDF(double d, double d2, double d3, double d4) {
        if (d4 < 0.0 || d4 > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + d4 + ", must lie between 0 and 1 inclusive");
        }
        double d5 = 0.0;
        if (d4 == 0.0) {
            d5 = d;
        } else if (d4 == 1.0) {
            d5 = Double.POSITIVE_INFINITY;
        } else {
            LogNormalThreeParFunct logNormalThreeParFunct = new LogNormalThreeParFunct();
            logNormalThreeParFunct.alpha = d;
            logNormalThreeParFunct.beta = d2;
            logNormalThreeParFunct.gamma = d3;
            double d6 = 1.0E-12;
            double d7 = d;
            double d8 = Stat.logNormalThreeParMean(d, d2, d3) + 5.0 * Stat.logNormalThreeParStandardDeviation(d, d2, d3);
            RealRoot realRoot = new RealRoot();
            realRoot.noLowerBoundExtension();
            realRoot.setTolerance(d6);
            realRoot.resetNaNexceptionToTrue();
            realRoot.suppressLimitReachedMessage();
            realRoot.suppressNaNmessage();
            logNormalThreeParFunct.cfd = d4;
            d5 = realRoot.bisect(logNormalThreeParFunct, d7, d8);
        }
        return d5;
    }

    public static double logNormalThreeParInverseCDF(double d, double d2, double d3, double d4) {
        return Stat.logNormalInverseCDF(d, d2, d3, d4);
    }

    public static double logNormalThreeParPDF(double d, double d2, double d3, double d4) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The parameter beta, " + d2 + ", must be greater than or equal to zero");
        }
        if (d4 <= d) {
            return 0.0;
        }
        return Math.exp(-0.5 * Fmath.square(Math.log((d4 - d) / d3) / d2)) / ((d4 - d3) * d2 * Math.sqrt(Math.PI * 2));
    }

    public static double[] logNormalThreeParRand(double d, double d2, double d3, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The number of random deviates required, " + n + ", must be greater than zero");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The parameter beta, " + d2 + ", must be greater than or equal to zero");
        }
        PsRandom psRandom = new PsRandom();
        return psRandom.logNormalThreeParArray(d, d2, d3, n);
    }

    public static double[] logNormalThreeParRand(double d, double d2, double d3, int n, long l) {
        if (n <= 0) {
            throw new IllegalArgumentException("The number of random deviates required, " + n + ", must be greater than zero");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The parameter beta, " + d2 + ", must be greater than or equal to zero");
        }
        PsRandom psRandom = new PsRandom(l);
        return psRandom.logNormalThreeParArray(d, d2, d3, n);
    }

    public static double[] logNormalOrderStatisticMedians(double d, double d2, double d3, int n) {
        double d4 = n;
        double[] dArray = new double[n];
        double[] dArray2 = Stat.uniformOrderStatisticMedians(n);
        for (int i = 0; i < n; ++i) {
            dArray[i] = Stat.logNormalThreeParInverseCDF(d, d2, d3, dArray2[i]);
        }
        dArray = Stat.scale(dArray, Stat.logNormalThreeParMean(d, d2, d3), Stat.logNormalThreeParStandardDeviation(d, d2, d3));
        return dArray;
    }

    public static double[] logNormalThreeParOrderStatisticMedians(double d, double d2, double d3, int n) {
        return Stat.logNormalOrderStatisticMedians(d, d2, d3, n);
    }

    public static double logNormalThreeParMean(double d, double d2, double d3) {
        return d3 * Math.exp(d2 * d2 / 2.0) + d;
    }

    public static double logNormalThreeParStandardDeviation(double d, double d2, double d3) {
        return Stat.logNormalThreeParStandDev(d, d2, d3);
    }

    public static double logNormalThreeParStandDev(double d, double d2, double d3) {
        double d4 = d2 * d2;
        return Math.sqrt((Math.exp(d4) - 1.0) * Math.exp(2.0 * Math.log(d3) + d4));
    }

    public static double logNormalThreeParMode(double d, double d2, double d3) {
        return d3 * Math.exp(-d2 * d2) + d;
    }

    public static double logNormalThreeParMedian(double d, double d2) {
        return d2 + d;
    }

    public static double logisticCDF(double d, double d2, double d3) {
        return 0.5 * (1.0 + Math.tanh((d3 - d) / (2.0 * d2)));
    }

    public static double logisticTwoParCDF(double d, double d2, double d3) {
        return 0.5 * (1.0 + Math.tanh((d3 - d) / (2.0 * d2)));
    }

    public static double logisticProb(double d, double d2, double d3) {
        return 0.5 * (1.0 + Math.tanh((d3 - d) / (2.0 * d2)));
    }

    public static double logisticCDF(double d, double d2, double d3, double d4) {
        double d5 = 0.5 * (1.0 + Math.tanh((d3 - d) / (2.0 * d2)));
        double d6 = 0.5 * (1.0 + Math.tanh((d4 - d) / (2.0 * d2)));
        return d6 - d5;
    }

    public static double logisticTwoParCDF(double d, double d2, double d3, double d4) {
        double d5 = 0.5 * (1.0 + Math.tanh((d3 - d) / (2.0 * d2)));
        double d6 = 0.5 * (1.0 + Math.tanh((d4 - d) / (2.0 * d2)));
        return d6 - d5;
    }

    public static double logisticProb(double d, double d2, double d3, double d4) {
        double d5 = 0.5 * (1.0 + Math.tanh((d3 - d) / (2.0 * d2)));
        double d6 = 0.5 * (1.0 + Math.tanh((d4 - d) / (2.0 * d2)));
        return d6 - d5;
    }

    public static double logisticTwoParInverseCDF(double d, double d2, double d3) {
        return Stat.logisticInverseCDF(d, d2, d3);
    }

    public static double logisticInverseCDF(double d, double d2, double d3) {
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + d3 + ", must lie between 0 and 1 inclusive");
        }
        double d4 = 0.0;
        d4 = d3 == 0.0 ? Double.NEGATIVE_INFINITY : (d3 == 1.0 ? Double.POSITIVE_INFINITY : d - d2 * Math.log(1.0 / d3 - 1.0));
        return d4;
    }

    public static double logisticPDF(double d, double d2, double d3) {
        return Fmath.square(Fmath.sech((d3 - d) / (2.0 * d2))) / (4.0 * d2);
    }

    public static double logisticTwoParPDF(double d, double d2, double d3) {
        return Fmath.square(Fmath.sech((d3 - d) / (2.0 * d2))) / (4.0 * d2);
    }

    public static double logistic(double d, double d2, double d3) {
        return Fmath.square(Fmath.sech((d3 - d) / (2.0 * d2))) / (4.0 * d2);
    }

    public static double[] logisticTwoParRand(double d, double d2, int n) {
        return Stat.logisticRand(d, d2, n);
    }

    public static double[] logisticRand(double d, double d2, int n) {
        double[] dArray = new double[n];
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            dArray[i] = 2.0 * d2 * Fmath.atanh(2.0 * random.nextDouble() - 1.0) + d;
        }
        return dArray;
    }

    public static double[] logisticTwoParRand(double d, double d2, int n, long l) {
        return Stat.logisticRand(d, d2, n, l);
    }

    public static double[] logisticRand(double d, double d2, int n, long l) {
        double[] dArray = new double[n];
        Random random = new Random(l);
        for (int i = 0; i < n; ++i) {
            dArray[i] = 2.0 * d2 * Fmath.atanh(2.0 * random.nextDouble() - 1.0) + d;
        }
        return dArray;
    }

    public static double[] logisticOrderStatisticMedians(double d, double d2, int n) {
        double d3 = n;
        double[] dArray = new double[n];
        double[] dArray2 = Stat.uniformOrderStatisticMedians(n);
        for (int i = 0; i < n; ++i) {
            dArray[i] = Stat.logisticInverseCDF(d, d2, dArray2[i]);
        }
        return dArray;
    }

    public static double[] logisticTwoParOrderStatisticMedians(double d, double d2, int n) {
        double d3 = n;
        double[] dArray = new double[n];
        double[] dArray2 = Stat.uniformOrderStatisticMedians(n);
        for (int i = 0; i < n; ++i) {
            dArray[i] = Stat.logisticInverseCDF(d, d2, dArray2[i]);
        }
        return dArray;
    }

    public static double logisticMean(double d) {
        return d;
    }

    public static double logisticTwoParMean(double d) {
        return d;
    }

    public static double logisticStandardDeviation(double d) {
        return Stat.logisticStandDev(d);
    }

    public static double logisticStandDev(double d) {
        return Math.sqrt(Fmath.square(Math.PI * d) / 3.0);
    }

    public static double logisticTwoParStandardDeviation(double d) {
        return Math.sqrt(Fmath.square(Math.PI * d) / 3.0);
    }

    public static double logisticMode(double d) {
        return d;
    }

    public static double logisticTwoParMode(double d) {
        return d;
    }

    public static double logisticMedian(double d) {
        return d;
    }

    public static double logisticTwoParMedian(double d) {
        return d;
    }

    public static double lorentzianProb(double d, double d2, double d3) {
        double d4 = (d3 - d) / (d2 / 2.0);
        return 0.3183098861837907 * (Math.atan(d4) + 1.5707963267948966);
    }

    public static double lorentzianCDF(double d, double d2, double d3, double d4) {
        double d5 = (d4 - d) / (d2 / 2.0);
        double d6 = (d3 - d) / (d2 / 2.0);
        return 0.3183098861837907 * (Math.atan(d5) - Math.atan(d6));
    }

    public static double lorentzianProb(double d, double d2, double d3, double d4) {
        double d5 = (d4 - d) / (d2 / 2.0);
        double d6 = (d3 - d) / (d2 / 2.0);
        return 0.3183098861837907 * (Math.atan(d5) - Math.atan(d6));
    }

    public static double lorentzianInverseCDF(double d, double d2, double d3) {
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + d3 + ", must lie between 0 and 1 inclusive");
        }
        double d4 = 0.0;
        d4 = d3 == 0.0 ? Double.NEGATIVE_INFINITY : (d3 == 1.0 ? Double.POSITIVE_INFINITY : d + d2 * Math.tan(Math.PI * (d3 - 0.5)) / 2.0);
        return d4;
    }

    public static double lorentzianPDF(double d, double d2, double d3) {
        double d4 = d2 / 2.0;
        return 0.3183098861837907 * d4 / (Fmath.square(d - d3) + d4 * d4);
    }

    public static double lorentzian(double d, double d2, double d3) {
        double d4 = d2 / 2.0;
        return 0.3183098861837907 * d4 / (Fmath.square(d - d3) + d4 * d4);
    }

    public static double[] lorentzianRand(double d, double d2, int n) {
        double[] dArray = new double[n];
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.tan((random.nextDouble() - 0.5) * Math.PI);
            dArray[i] = dArray[i] * d2 / 2.0 + d;
        }
        return dArray;
    }

    public static double[] lorentzianRand(double d, double d2, int n, long l) {
        double[] dArray = new double[n];
        Random random = new Random(l);
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.tan((random.nextDouble() - 0.5) * Math.PI);
            dArray[i] = dArray[i] * d2 / 2.0 + d;
        }
        return dArray;
    }

    public static double[] lorentzianOrderStatisticMedians(double d, double d2, int n) {
        double d3 = n;
        double[] dArray = new double[n];
        double[] dArray2 = Stat.uniformOrderStatisticMedians(n);
        for (int i = 0; i < n; ++i) {
            dArray[i] = Stat.lorentzianInverseCDF(d, d2, dArray2[i]);
        }
        return dArray;
    }

    public static double poissonCDF(int n, double d) {
        if (n < 1) {
            throw new IllegalArgumentException("k must be an integer greater than or equal to 1");
        }
        return Stat.incompleteGammaComplementary(n, d);
    }

    public static double poissonProb(int n, double d) {
        if (n < 1) {
            throw new IllegalArgumentException("k must be an integer greater than or equal to 1");
        }
        return Stat.incompleteGammaComplementary(n, d);
    }

    public static double poissonPDF(int n, double d) {
        if (n < 0) {
            throw new IllegalArgumentException("k must be an integer greater than or equal to 0");
        }
        return Math.pow(d, n) * Math.exp(-d) / Stat.factorial((double)n);
    }

    public static double poisson(int n, double d) {
        if (n < 0) {
            throw new IllegalArgumentException("k must be an integer greater than or equal to 0");
        }
        return Math.pow(d, n) * Math.exp(-d) / Stat.factorial((double)n);
    }

    public static double[] poissonRand(double d, int n) {
        Random random = new Random();
        double[] dArray = Stat.poissonRandCalc(random, d, n);
        return dArray;
    }

    public static double[] poissonRand(double d, int n, long l) {
        Random random = new Random(l);
        double[] dArray = Stat.poissonRandCalc(random, d, n);
        return dArray;
    }

    private static double[] poissonRandCalc(Random random, double d, int n) {
        double[] dArray = new double[n];
        double d2 = -1.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        if (d < 12.0) {
            for (int i = 0; i < n; ++i) {
                if (d != d2) {
                    d2 = d;
                    d3 = Math.exp(-d);
                }
                d4 = -1.0;
                d5 = 1.0;
                do {
                    d4 += 1.0;
                } while ((d5 *= random.nextDouble()) > d3);
                dArray[i] = d4;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (d != d2) {
                    d2 = d;
                    d6 = Math.sqrt(2.0 * d);
                    d7 = Math.log(d);
                    d3 = d7 - Stat.logGamma(d + 1.0);
                }
                while (true) {
                    if ((d4 = d6 * (d8 = Math.tan(Math.PI * random.nextDouble())) + d) < 0.0) {
                        continue;
                    }
                    d4 = Math.floor(d4);
                    d5 = 0.9 * (1.0 + d8 * d8) * Math.exp(d4 * d7 - Stat.logGamma(d4 + 1.0) - d3);
                    if (!(random.nextDouble() > d5)) break;
                }
                dArray[i] = d4;
            }
        }
        return dArray;
    }

    public static double chiSquareCDF(double d, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + n + ", must be greater than zero");
        }
        return Stat.incompleteGamma((double)n / 2.0, d / 2.0);
    }

    public static double chiSquareProb(double d, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + n + ", must be greater than zero");
        }
        return Stat.incompleteGamma((double)n / 2.0, d / 2.0);
    }

    public static double chiSquareInverseCDF(int n, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + d + ", must lie between 0 and 1 inclusive");
        }
        double d2 = 0.0;
        if (d == 0.0) {
            d2 = 0.0;
        } else if (d == 1.0) {
            d2 = Double.POSITIVE_INFINITY;
        } else {
            ChiSquareFunct chiSquareFunct = new ChiSquareFunct();
            chiSquareFunct.nu = n;
            double d3 = 1.0E-12;
            double d4 = 0.0;
            double d5 = (double)n + 10.0 * Math.sqrt(2.0 * (double)n);
            RealRoot realRoot = new RealRoot();
            realRoot.noLowerBoundExtension();
            realRoot.setTolerance(d3);
            realRoot.resetNaNexceptionToTrue();
            realRoot.suppressLimitReachedMessage();
            realRoot.suppressNaNmessage();
            chiSquareFunct.cfd = d;
            d2 = realRoot.bisect(chiSquareFunct, d4, d5);
        }
        return d2;
    }

    public static double inverseChiSquareCDF(int n, double d) {
        return Stat.chiSquareInverseCDF(n, d);
    }

    public static double chiSquarePDF(double d, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + n + ", must be greater than zero");
        }
        double d2 = n;
        return Math.pow(0.5, d2 / 2.0) * Math.pow(d, d2 / 2.0 - 1.0) * Math.exp(-d / 2.0) / Stat.gammaFunction(d2 / 2.0);
    }

    public static double[] chiSquareRand(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + n + ", must be greater than zero");
        }
        PsRandom psRandom = new PsRandom();
        return psRandom.chiSquareArray(n, n2);
    }

    public static double[] chiSquareRand(int n, int n2, long l) {
        if (n <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + n + ", must be greater than zero");
        }
        PsRandom psRandom = new PsRandom(l);
        return psRandom.chiSquareArray(n, n2);
    }

    public static double chiSquareMean(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + n + ", must be greater than zero");
        }
        return n;
    }

    public static double chiSquareMode(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + n + ", must be greater than zero");
        }
        double d = 0.0;
        if (n >= 2) {
            d = (double)n - 2.0;
        }
        return d;
    }

    public static double chiSquareStandardDeviation(int n) {
        return Stat.chiSquareStandDev(n);
    }

    public static double chiSquareStandDev(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + n + ", must be greater than zero");
        }
        double d = n;
        return Math.sqrt(2.0 * d);
    }

    public static double chiSquare(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = dArray3.length;
        if (n != n2) {
            throw new IllegalArgumentException("observed array length does not equal the expected array length");
        }
        if (n != n3) {
            throw new IllegalArgumentException("observed array length does not equal the variance array length");
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += Fmath.square(dArray[i] - dArray2[i]) / dArray3[i];
        }
        return d;
    }

    public static double chiSquareFreq(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = dArray2.length;
        if (n != n2) {
            throw new IllegalArgumentException("observed array length does not equal the expected array length");
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += Fmath.square(dArray[i] - dArray2[i]) / dArray2[i];
        }
        return d;
    }

    public static double chiSquareFreq(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = nArray2.length;
        if (n != n2) {
            throw new IllegalArgumentException("observed array length does not equal the expected array length");
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = nArray[i];
            dArray2[i] = nArray2[i];
        }
        return Stat.chiSquareFreq(dArray, dArray2);
    }

    public static double wilsonHilferty(double d, int n) {
        double d2 = 2.0 / (9.0 * (double)n);
        return (Math.pow(d / (double)n, 0.3333333333333333) - (1.0 - d2)) / Math.sqrt(d2);
    }

    public static double wilsonHilferty(double d, double d2) {
        double d3 = 3.0 / Math.sqrt(d2);
        return (Math.pow(d, 0.3333333333333333) - 1.0) * d3 + 1.0 / d3;
    }

    public static double binomialCDF(double d, int n, int n2) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("\np must lie between 0 and 1");
        }
        if (n2 < 0 || n < 0) {
            throw new IllegalArgumentException("\nn and k must be greater than or equal to zero");
        }
        if (n2 > n) {
            throw new IllegalArgumentException("\nk is greater than n");
        }
        return Stat.regularisedBetaFunction(n2, n - n2 + 1, d);
    }

    public static double binomialProb(double d, int n, int n2) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("\np must lie between 0 and 1");
        }
        if (n2 < 0 || n < 0) {
            throw new IllegalArgumentException("\nn and k must be greater than or equal to zero");
        }
        if (n2 > n) {
            throw new IllegalArgumentException("\nk is greater than n");
        }
        return Stat.regularisedBetaFunction(n2, n - n2 + 1, d);
    }

    public static double binomialPDF(double d, int n, int n2) {
        if (n2 < 0 || n < 0) {
            throw new IllegalArgumentException("\nn and k must be greater than or equal to zero");
        }
        if (n2 > n) {
            throw new IllegalArgumentException("\nk is greater than n");
        }
        return Math.floor(0.5 + Math.exp(Stat.logFactorial(n) - Stat.logFactorial(n2) - Stat.logFactorial(n - n2))) * Math.pow(d, n2) * Math.pow(1.0 - d, n - n2);
    }

    public static double binomial(double d, int n, int n2) {
        if (n2 < 0 || n < 0) {
            throw new IllegalArgumentException("\nn and k must be greater than or equal to zero");
        }
        if (n2 > n) {
            throw new IllegalArgumentException("\nk is greater than n");
        }
        return Math.floor(0.5 + Math.exp(Stat.logFactorial(n) - Stat.logFactorial(n2) - Stat.logFactorial(n - n2))) * Math.pow(d, n2) * Math.pow(1.0 - d, n - n2);
    }

    public static double binomialCoeff(int n, int n2) {
        if (n2 < 0 || n < 0) {
            throw new IllegalArgumentException("\nn and k must be greater than or equal to zero");
        }
        if (n2 > n) {
            throw new IllegalArgumentException("\nk is greater than n");
        }
        return Math.floor(0.5 + Math.exp(Stat.logFactorial(n) - Stat.logFactorial(n2) - Stat.logFactorial(n - n2)));
    }

    public double[] binomialRand(double d, int n, int n2) {
        if (n < n2) {
            throw new IllegalArgumentException("Number of deviates requested, " + n2 + ", must be less than the number of trials, " + n);
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("The probablity provided, " + d + ", must lie between 0 and 1)");
        }
        double[] dArray = new double[n2];
        Random random = new Random();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = -1.0;
        double d8 = -1.0;
        double d9 = -1.0;
        int n3 = -1;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = d;
        for (int i = 0; i < n2; ++i) {
            double d15;
            int n4;
            d = d14;
            d5 = d <= 0.5 ? d : 1.0 - d;
            d3 = (double)n * d5;
            if (n < 25) {
                d2 = 0.0;
                for (n4 = 1; n4 <= n; ++n4) {
                    if (!(random.nextDouble() < d5)) continue;
                    d2 += 1.0;
                }
            } else if (d3 < 1.0) {
                d15 = Math.exp(-d3);
                d4 = 1.0;
                for (n4 = 0; n4 <= n && !((d4 *= random.nextDouble()) < d15); ++n4) {
                }
                d2 = n4 <= n ? n4 : n;
            } else {
                if (n != n3) {
                    d10 = n;
                    d11 = Stat.logGamma(d10 + 1.0);
                    n3 = n;
                }
                if (d5 != d7) {
                    d8 = 1.0 - d5;
                    d6 = Math.log(d5);
                    d9 = Math.log(d8);
                    d7 = d5;
                }
                d15 = Math.sqrt(2.0 * d3 * d8);
                while (true) {
                    double d16;
                    if ((d13 = d15 * (d12 = Math.tan(d16 = Math.PI * random.nextDouble())) + d3) < 0.0 || d13 >= d10 + 1.0) {
                        continue;
                    }
                    d13 = Math.floor(d13);
                    d4 = 1.2 * d15 * (1.0 + d12 * d12) * Math.exp(d11 - Stat.logGamma(d13 + 1.0) - Stat.logGamma(d10 - d13 + 1.0) + d13 * d6 + (d10 - d13) * d9);
                    if (!(random.nextDouble() > d4)) break;
                }
                d2 = d13;
            }
            if (d5 != d) {
                d2 = (double)n - d2;
            }
            dArray[i] = d2;
        }
        return dArray;
    }

    public double[] binomialRand(double d, int n, int n2, long l) {
        if (n < n2) {
            throw new IllegalArgumentException("Number of deviates requested, " + n2 + ", must be less than the number of trials, " + n);
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("The probablity provided, " + d + ", must lie between 0 and 1)");
        }
        double[] dArray = new double[n2];
        Random random = new Random(l);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = -1.0;
        double d8 = -1.0;
        double d9 = -1.0;
        int n3 = -1;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = d;
        for (int i = 0; i < n2; ++i) {
            double d15;
            int n4;
            d = d14;
            d5 = d <= 0.5 ? d : 1.0 - d;
            d3 = (double)n * d5;
            if (n < 25) {
                d2 = 0.0;
                for (n4 = 1; n4 <= n; ++n4) {
                    if (!(random.nextDouble() < d5)) continue;
                    d2 += 1.0;
                }
            } else if (d3 < 1.0) {
                d15 = Math.exp(-d3);
                d4 = 1.0;
                for (n4 = 0; n4 <= n && !((d4 *= random.nextDouble()) < d15); ++n4) {
                }
                d2 = n4 <= n ? n4 : n;
            } else {
                if (n != n3) {
                    d10 = n;
                    d11 = Stat.logGamma(d10 + 1.0);
                    n3 = n;
                }
                if (d5 != d7) {
                    d8 = 1.0 - d5;
                    d6 = Math.log(d5);
                    d9 = Math.log(d8);
                    d7 = d5;
                }
                d15 = Math.sqrt(2.0 * d3 * d8);
                while (true) {
                    double d16;
                    if ((d13 = d15 * (d12 = Math.tan(d16 = Math.PI * random.nextDouble())) + d3) < 0.0 || d13 >= d10 + 1.0) {
                        continue;
                    }
                    d13 = Math.floor(d13);
                    d4 = 1.2 * d15 * (1.0 + d12 * d12) * Math.exp(d11 - Stat.logGamma(d13 + 1.0) - Stat.logGamma(d10 - d13 + 1.0) + d13 * d6 + (d10 - d13) * d9);
                    if (!(random.nextDouble() > d4)) break;
                }
                d2 = d13;
            }
            if (d5 != d) {
                d2 = (double)n - d2;
            }
            dArray[i] = d2;
        }
        return dArray;
    }

    public static double fCompCDF(double d, int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("the degrees of freedom, nu1, " + n + ", must be greater than zero");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("the degrees of freedom, nu2, " + n2 + ", must be greater than zero");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("the F-ratio, " + d + ", must be greater than or equal to zero");
        }
        double d2 = n;
        double d3 = n2;
        double d4 = d3 / (d3 + d2 * d);
        return Stat.regularisedBetaFunction((double)n2 / 2.0, (double)n / 2.0, d4);
    }

    public static double fTestProb(double d, int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("the degrees of freedom, nu1, " + n + ", must be greater than zero");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("the degrees of freedom, nu2, " + n2 + ", must be greater than zero");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("the F-ratio, " + d + ", must be greater than or equal to zero");
        }
        double d2 = n;
        double d3 = n2;
        double d4 = d3 / (d3 + d2 * d);
        return Stat.regularisedBetaFunction((double)n2 / 2.0, (double)n / 2.0, d4);
    }

    public static double fCompCDF(double d, int n, double d2, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("the degrees of freedom, nu1, " + n + ", must be greater than zero");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("the degrees of freedom, nu2, " + n2 + ", must be greater than zero");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("the variance, var1" + d + ", must be greater than or equal to zero");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("the variance, var2" + d2 + ", must be greater than zero");
        }
        double d3 = d / d2;
        double d4 = n;
        double d5 = n2;
        double d6 = d5 / (d5 + d4 * d3);
        return Stat.regularisedBetaFunction((double)n2 / 2.0, (double)n / 2.0, d6);
    }

    public static double fTestProb(double d, int n, double d2, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("the degrees of freedom, nu1, " + n + ", must be greater than zero");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("the degrees of freedom, nu2, " + n2 + ", must be greater than zero");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("the variance, var1" + d + ", must be greater than or equal to zero");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("the variance, var2" + d2 + ", must be greater than zero");
        }
        double d3 = d / d2;
        double d4 = n;
        double d5 = n2;
        double d6 = d5 / (d5 + d4 * d3);
        return Stat.regularisedBetaFunction((double)n2 / 2.0, (double)n / 2.0, d6);
    }

    public static double fDistributionInverseCDF(int n, int n2, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + d + ", must lie between 0 and 1 inclusive");
        }
        double d2 = 0.0;
        if (d == 0.0) {
            d2 = 0.0;
        } else if (d == 1.0) {
            d2 = Double.POSITIVE_INFINITY;
        } else {
            FdistribtionFunct fdistribtionFunct = new FdistribtionFunct();
            fdistribtionFunct.nu1 = n;
            fdistribtionFunct.nu2 = n2;
            double d3 = 1.0E-12;
            double d4 = 0.0;
            double d5 = 2.0;
            RealRoot realRoot = new RealRoot();
            realRoot.noLowerBoundExtension();
            realRoot.setTolerance(d3);
            realRoot.resetNaNexceptionToTrue();
            realRoot.suppressLimitReachedMessage();
            realRoot.suppressNaNmessage();
            fdistribtionFunct.cfd = d;
            d2 = realRoot.bisect(fdistribtionFunct, d4, d5);
        }
        return d2;
    }

    public static double[] fDistributionOrderStatisticMedians(int n, int n2, int n3) {
        double d = n3;
        double[] dArray = new double[n3];
        double[] dArray2 = Stat.uniformOrderStatisticMedians(n3);
        for (int i = 0; i < n3; ++i) {
            dArray[i] = Stat.fDistributionInverseCDF(n, n2, dArray2[i]);
        }
        Stat stat = new Stat(dArray);
        double d2 = stat.mean();
        double d3 = stat.standardDeviation();
        dArray = Stat.scale(dArray, d2, d3);
        return dArray;
    }

    public static double fTestValueGivenFprob(double d, int n, int n2) {
        int n3 = 100;
        double[] dArray = new double[n3];
        dArray[0] = 1.0E-4;
        dArray[n3 - 1] = 10000.0;
        double d2 = (Fmath.log10(dArray[n3 - 1]) - Fmath.log10(dArray[0])) / (double)(n3 - 1);
        for (int i = 1; i < n3 - 1; ++i) {
            dArray[i] = Math.pow(10.0, Fmath.log10(dArray[i - 1]) + d2);
        }
        double[] dArray2 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray2[i] = Stat.fTestProb(dArray[i], n, n2);
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        boolean bl = true;
        boolean bl2 = true;
        int n4 = 0;
        int n5 = 0;
        while (bl) {
            if (d == dArray2[n4]) {
                d3 = dArray[n4];
                bl = false;
                bl2 = false;
                continue;
            }
            if (d > dArray2[n4]) {
                bl = false;
                if (n4 > 0) {
                    d4 = dArray[n4 - 1];
                    d5 = dArray[n4];
                    n5 = -1;
                    continue;
                }
                d4 = dArray[n4] / 10.0;
                d5 = dArray[n4];
                continue;
            }
            if (++n4 <= n3 - 1) continue;
            bl = false;
            d4 = dArray[n4 - 1];
            d5 = 10.0 * dArray[n4 - 1];
            n5 = 1;
        }
        if (bl2) {
            d3 = Stat.fTestBisect(d, d4, d5, n, n2, n5);
        }
        return d3;
    }

    private static double fTestBisect(double d, double d2, double d3, int n, int n2, int n3) {
        double d4 = d - Stat.fTestProb(d2, n, n2);
        double d5 = d - Stat.fTestProb(d3, n, n2);
        double d6 = 0.0;
        double d7 = 0.0;
        int n4 = 0;
        int n5 = 1000;
        double d8 = d * 1.0E-6;
        boolean bl = true;
        boolean bl2 = true;
        while (bl) {
            if (d4 * d5 > 0.0) {
                if (n3 < 0) {
                    if (++n4 > 100) {
                        System.out.println("Class: Stats\nMethod: fTestBisect\nProbability higher than range covered\nF-test value is less than " + d2);
                        System.out.println("This value was returned");
                        d6 = d2;
                        bl = false;
                        bl2 = false;
                    }
                    d4 = d - Stat.fTestProb(d2 /= 10.0, n, n2);
                } else {
                    if (++n4 > 100) {
                        System.out.println("Class: Stats\nMethod: fTestBisect\nProbability lower than range covered\nF-test value is greater than " + d3);
                        System.out.println("This value was returned");
                        d6 = d3;
                        bl = false;
                        bl2 = false;
                    }
                    d5 = d - Stat.fTestProb(d3 *= 10.0, n, n2);
                }
            } else {
                bl = false;
            }
            int n6 = 0;
            while (bl2) {
                d6 = (d2 + d3) / 2.0;
                d7 = d - Stat.fTestProb(d6, n, n2);
                if (Math.abs(d7) < d8) {
                    bl2 = false;
                    continue;
                }
                if (++n6 > n5) {
                    System.out.println("Class: Stats\nMethod: fTestBisect\nmaximum number of iterations exceeded\ncurrent value of F-test value returned");
                    bl2 = false;
                }
                if (d7 * d5 > 0.0) {
                    d5 = d7;
                    d3 = d6;
                    continue;
                }
                d4 = d7;
                d2 = d6;
            }
        }
        return d6;
    }

    public double fPDF(double d, int n, int n2) {
        double d2 = Math.pow((double)n * d, n) * Math.pow(n2, n2);
        double d3 = n;
        double d4 = n2;
        d2 /= Math.pow(d3 * d + d4, d3 + d4);
        d2 = Math.sqrt(d2);
        double d5 = d * Stat.betaFunction(d3 / 2.0, d4 / 2.0);
        return d2 / d5;
    }

    public double fPDF(double d, int n, double d2, int n2) {
        return this.fPDF(d / d2, n, n2);
    }

    public static double[] fRand(int n, int n2, int n3) {
        if (n <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu1], " + n + ", must be greater than zero");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu2], " + n2 + ", must be greater than zero");
        }
        PsRandom psRandom = new PsRandom();
        return psRandom.fArray(n, n2, n3);
    }

    public static double[] fRand(int n, int n2, int n3, long l) {
        if (n <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu1], " + n + ", must be greater than zero");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu2], " + n2 + ", must be greater than zero");
        }
        PsRandom psRandom = new PsRandom(l);
        return psRandom.fArray(n, n2, n3);
    }

    public static double studentst(double d, int n) {
        return Stat.studentT(d, n);
    }

    public static double studentT(double d, int n) {
        if (d != d) {
            throw new IllegalArgumentException("argument tValue is not a number (NaN)");
        }
        double d2 = n;
        double d3 = (d2 + 1.0) / 2.0;
        return Stat.gamma(d3) / Stat.gamma(d2 / 2.0) / Math.sqrt(d2 * Math.PI) * Math.pow(1.0 + d * d / d2, -d3);
    }

    public static double studentstPDF(double d, int n) {
        return Stat.studentTpdf(d, n);
    }

    public static double studentTpdf(double d, int n) {
        if (d != d) {
            throw new IllegalArgumentException("argument tValue is not a number (NaN)");
        }
        double d2 = n;
        double d3 = (d2 + 1.0) / 2.0;
        return Stat.gamma(d3) / Stat.gamma(d2 / 2.0) / Math.sqrt(d2 * Math.PI) * Math.pow(1.0 + d * d / d2, -d3);
    }

    public static double studentTPDF(double d, int n) {
        if (d != d) {
            throw new IllegalArgumentException("argument tValue is not a number (NaN)");
        }
        double d2 = n;
        double d3 = (d2 + 1.0) / 2.0;
        return Stat.gamma(d3) / Stat.gamma(d2 / 2.0) / Math.sqrt(d2 * Math.PI) * Math.pow(1.0 + d * d / d2, -d3);
    }

    public static double studentstCDF(double d, int n) {
        return Stat.studentTcdf(d, n);
    }

    public static double studentTProb(double d, int n) {
        if (d != d) {
            throw new IllegalArgumentException("argument tValue is not a number (NaN)");
        }
        if (d == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        double d2 = n;
        double d3 = d2 / (d2 + d * d);
        return 0.5 * (1.0 + (Stat.regularisedBetaFunction(d2 / 2.0, 0.5, 1.0) - Stat.regularisedBetaFunction(d2 / 2.0, 0.5, d3)) * Fmath.sign(d));
    }

    public static double studentTcdf(double d, int n) {
        if (d != d) {
            throw new IllegalArgumentException("argument tValue is not a number (NaN)");
        }
        if (d == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        double d2 = n;
        double d3 = d2 / (d2 + d * d);
        return 0.5 * (1.0 + (Stat.regularisedBetaFunction(d2 / 2.0, 0.5, 1.0) - Stat.regularisedBetaFunction(d2 / 2.0, 0.5, d3)) * Fmath.sign(d));
    }

    public static double studentTCDF(double d, int n) {
        if (d != d) {
            throw new IllegalArgumentException("argument tValue is not a number (NaN)");
        }
        if (d == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        double d2 = n;
        double d3 = d2 / (d2 + d * d);
        return 0.5 * (1.0 + (Stat.regularisedBetaFunction(d2 / 2.0, 0.5, 1.0) - Stat.regularisedBetaFunction(d2 / 2.0, 0.5, d3)) * Fmath.sign(d));
    }

    public static double studentTcdf(double d, double d2, int n) {
        if (d != d) {
            throw new IllegalArgumentException("argument tLowerValue is not a number (NaN)");
        }
        if (d2 != d2) {
            throw new IllegalArgumentException("argument tUpperValue is not a number (NaN)");
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            if (d == Double.NEGATIVE_INFINITY) {
                return 1.0;
            }
            if (d == Double.POSITIVE_INFINITY) {
                return 0.0;
            }
            return 1.0 - Stat.studentTcdf(d, n);
        }
        if (d == Double.NEGATIVE_INFINITY) {
            if (d2 == Double.NEGATIVE_INFINITY) {
                return 0.0;
            }
            return Stat.studentTcdf(d2, n);
        }
        return Stat.studentTcdf(d2, n) - Stat.studentTcdf(d, n);
    }

    public static double pValue(double d, int n) {
        if (d != d) {
            throw new IllegalArgumentException("argument tValue is not a number (NaN)");
        }
        double d2 = Math.abs(d);
        return 1.0 - Stat.studentTcdf(-d2, d2, n);
    }

    public static double studentstValue(double d, int n) {
        StudentsTvalueFunct studentsTvalueFunct = new StudentsTvalueFunct();
        studentsTvalueFunct.setCfd(d);
        studentsTvalueFunct.setDof(n);
        RealRoot realRoot = new RealRoot();
        double d2 = 0.0;
        double d3 = 1.0;
        double d4 = 1.0E-10;
        realRoot.setTolerance(d4);
        return realRoot.bisect(studentsTvalueFunct, d2, d3);
    }

    public static double studentstMean(int n) {
        return Stat.studentTmean(n);
    }

    public static double studentTmean(int n) {
        double d = Double.NaN;
        if (n > 1) {
            d = 0.0;
        }
        return d;
    }

    public static double studentstMedian() {
        return 0.0;
    }

    public static double studentTmedian() {
        return 0.0;
    }

    public static double studentstMode() {
        return 0.0;
    }

    public static double studentTmode() {
        return 0.0;
    }

    public static double studentstStandardDeviation(int n) {
        return Stat.studentTstandDev(n);
    }

    public static double studentTstandDev(int n) {
        double d = Double.POSITIVE_INFINITY;
        if (n > 2) {
            d = Math.sqrt(n / (1 - n));
        }
        return d;
    }

    public static double probAtn(double d, int n) {
        double d2 = n;
        double d3 = d2 / (d2 + d * d);
        return 1.0 - Stat.regularisedBetaFunction(d2 / 2.0, 0.5, d3);
    }

    public static double[] studentstRand(int n, int n2) {
        return Stat.studentTRand(n, n2);
    }

    public static double[] studentTRand(int n, int n2) {
        PsRandom psRandom = new PsRandom();
        return psRandom.studentTarray(n, n2);
    }

    public static double[] studentTrand(int n, int n2) {
        PsRandom psRandom = new PsRandom();
        return psRandom.studentTarray(n, n2);
    }

    public static double[] studentstRand(int n, int n2, long l) {
        return Stat.studentTrand(n, n2, l);
    }

    public static double[] studentTrand(int n, int n2, long l) {
        PsRandom psRandom = new PsRandom(l);
        return psRandom.studentTarray(n, n2);
    }

    public static double[] studentTRand(int n, int n2, long l) {
        PsRandom psRandom = new PsRandom(l);
        return psRandom.studentTarray(n, n2);
    }

    public static double gumbelMinProbCDF(double d, double d2, double d3) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double d4 = -(d3 - d) / d2;
        return Math.exp(-Math.exp(d4));
    }

    public static double gumbelMinProb(double d, double d2, double d3) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double d4 = -(d3 - d) / d2;
        return Math.exp(-Math.exp(d4));
    }

    public static double gumbelMaxCDF(double d, double d2, double d3) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double d4 = -(d3 - d) / d2;
        return 1.0 - Math.exp(-Math.exp(d4));
    }

    public static double gumbelMaxProb(double d, double d2, double d3) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double d4 = -(d3 - d) / d2;
        return 1.0 - Math.exp(-Math.exp(d4));
    }

    public static double gumbelMaxInverseCDF(double d, double d2, double d3) {
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + d3 + ", must lie between 0 and 1 inclusive");
        }
        double d4 = 0.0;
        d4 = d3 == 0.0 ? Double.NEGATIVE_INFINITY : (d3 == 1.0 ? Double.POSITIVE_INFINITY : d - d2 * Math.log(Math.log(1.0 / d3)));
        return d4;
    }

    public static double gumbelMinCDF(double d, double d2, double d3, double d4) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double d5 = -(d3 - d) / d2;
        double d6 = -(d4 - d) / d2;
        double d7 = Math.exp(-Math.exp(d5));
        double d8 = Math.exp(-Math.exp(d6));
        return d8 - d7;
    }

    public static double gumbelMinProb(double d, double d2, double d3, double d4) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double d5 = -(d3 - d) / d2;
        double d6 = -(d4 - d) / d2;
        double d7 = Math.exp(-Math.exp(d5));
        double d8 = Math.exp(-Math.exp(d6));
        return d8 - d7;
    }

    public static double gumbelMaxCDF(double d, double d2, double d3, double d4) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double d5 = (d3 - d) / d2;
        double d6 = (d4 - d) / d2;
        double d7 = -Math.exp(-Math.exp(d5));
        double d8 = -Math.exp(-Math.exp(d6));
        return d8 - d7;
    }

    public static double gumbelMaxProb(double d, double d2, double d3, double d4) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double d5 = (d3 - d) / d2;
        double d6 = (d4 - d) / d2;
        double d7 = -Math.exp(-Math.exp(d5));
        double d8 = -Math.exp(-Math.exp(d6));
        return d8 - d7;
    }

    public static double gumbelMinInverseCDF(double d, double d2, double d3) {
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + d3 + ", must lie between 0 and 1 inclusive");
        }
        double d4 = 0.0;
        d4 = d3 == 0.0 ? Double.NEGATIVE_INFINITY : (d3 == 1.0 ? Double.POSITIVE_INFINITY : d + d2 * Math.log(Math.log(1.0 / (1.0 - d3))));
        return d4;
    }

    public static double gumbelMinPDF(double d, double d2, double d3) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double d4 = (d3 - d) / d2;
        return 1.0 / d2 * Math.exp(d4) * Math.exp(-Math.exp(d4));
    }

    public static double gumbelMin(double d, double d2, double d3) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double d4 = (d3 - d) / d2;
        return 1.0 / d2 * Math.exp(d4) * Math.exp(-Math.exp(d4));
    }

    public static double gumbelMaxPDF(double d, double d2, double d3) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double d4 = -(d3 - d) / d2;
        return 1.0 / d2 * Math.exp(d4) * Math.exp(-Math.exp(d4));
    }

    public static double gumbelMax(double d, double d2, double d3) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        double d4 = -(d3 - d) / d2;
        return 1.0 / d2 * Math.exp(d4) * Math.exp(-Math.exp(d4));
    }

    public static double[] gumbelMinRand(double d, double d2, int n) {
        double[] dArray = new double[n];
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.log(Math.log(1.0 / (1.0 - random.nextDouble()))) * d2 + d;
        }
        return dArray;
    }

    public static double[] gumbelMinRand(double d, double d2, int n, long l) {
        double[] dArray = new double[n];
        Random random = new Random(l);
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.log(Math.log(1.0 / (1.0 - random.nextDouble()))) * d2 + d;
        }
        return dArray;
    }

    public static double[] gumbelMaxRand(double d, double d2, int n) {
        double[] dArray = new double[n];
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            dArray[i] = d - Math.log(Math.log(1.0 / (1.0 - random.nextDouble()))) * d2;
        }
        return dArray;
    }

    public static double[] gumbelMaxRand(double d, double d2, int n, long l) {
        double[] dArray = new double[n];
        Random random = new Random(l);
        for (int i = 0; i < n; ++i) {
            dArray[i] = d - Math.log(Math.log(1.0 / (1.0 - random.nextDouble()))) * d2;
        }
        return dArray;
    }

    public static double[] gumbelMinOrderStatisticMedians(double d, double d2, int n) {
        double d3 = n;
        double[] dArray = new double[n];
        double[] dArray2 = Stat.uniformOrderStatisticMedians(n);
        for (int i = 0; i < n; ++i) {
            dArray[i] = Stat.gumbelMinInverseCDF(d, d2, dArray2[i]);
        }
        return dArray;
    }

    public static double[] gumbelMaxOrderStatisticMedians(double d, double d2, int n) {
        double d3 = n;
        double[] dArray = new double[n];
        double[] dArray2 = Stat.uniformOrderStatisticMedians(n);
        for (int i = 0; i < n; ++i) {
            dArray[i] = Stat.gumbelMaxInverseCDF(d, d2, dArray2[i]);
        }
        return dArray;
    }

    public static double gumbelMinMean(double d, double d2) {
        return d - d2 * 0.5772156649015627;
    }

    public static double gumbelMaxMean(double d, double d2) {
        return d + d2 * 0.5772156649015627;
    }

    public static double gumbelMinStandardDeviation(double d) {
        return d * Math.PI / Math.sqrt(6.0);
    }

    public static double gumbelMinStandDev(double d) {
        return d * Math.PI / Math.sqrt(6.0);
    }

    public static double gumbelMaxStandardDeviation(double d) {
        return d * Math.PI / Math.sqrt(6.0);
    }

    public static double gumbelMaxStandDev(double d) {
        return d * Math.PI / Math.sqrt(6.0);
    }

    public static double gumbelMinMode(double d, double d2) {
        return d;
    }

    public static double gumbelMaxMode(double d, double d2) {
        return d;
    }

    public static double gumbelMinMedian(double d, double d2) {
        return d + d2 * Math.log(Math.log(2.0));
    }

    public static double gumbelMaxMedian(double d, double d2) {
        return d - d2 * Math.log(Math.log(2.0));
    }

    public static double frechetProb(double d, double d2, double d3, double d4) {
        double d5 = (d4 - d) / d2;
        double d6 = 0.0;
        if (d5 > 0.0) {
            d6 = Math.exp(-Math.pow(d5, -d3));
        }
        return d6;
    }

    public static double frechetCDF(double d, double d2, double d3, double d4, double d5) {
        double d6 = (d4 - d) / d2;
        double d7 = (d5 - d) / d2;
        double d8 = 0.0;
        double d9 = 0.0;
        if (d6 >= 0.0) {
            d8 = Math.exp(-Math.pow(d6, -d3));
        }
        if (d7 >= 0.0) {
            d9 = Math.exp(-Math.pow(d7, -d3));
        }
        return d9 - d8;
    }

    public static double frechetProb(double d, double d2, double d3, double d4, double d5) {
        double d6 = (d4 - d) / d2;
        double d7 = (d5 - d) / d2;
        double d8 = 0.0;
        double d9 = 0.0;
        if (d6 >= 0.0) {
            d8 = Math.exp(-Math.pow(d6, -d3));
        }
        if (d7 >= 0.0) {
            d9 = Math.exp(-Math.pow(d7, -d3));
        }
        return d9 - d8;
    }

    public static double frechetInverseCDF(double d, double d2, double d3, double d4) {
        if (d4 < 0.0 || d4 > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + d4 + ", must lie between 0 and 1 inclusive");
        }
        double d5 = 0.0;
        d5 = d4 == 0.0 ? Double.NEGATIVE_INFINITY : (d4 == 1.0 ? Double.POSITIVE_INFINITY : d + d2 * Math.pow(Math.log(1.0 / d4), -1.0 / d3));
        return d5;
    }

    public static double frechetInverseCDF(double d, double d2, double d3) {
        return Stat.frechetInverseCDF(0.0, d, d2, d3);
    }

    public static double frechetInverseCDF(double d, double d2) {
        return Stat.frechetInverseCDF(0.0, 1.0, d, d2);
    }

    public static double frechetPDF(double d, double d2, double d3, double d4) {
        double d5 = (d4 - d) / d2;
        double d6 = 0.0;
        if (d5 >= 0.0) {
            d6 = d3 / d2 * Math.pow(d5, -d3 - 1.0) * Math.exp(-Math.pow(d5, -d3));
        }
        return d6;
    }

    public static double frechet(double d, double d2, double d3, double d4) {
        double d5 = (d4 - d) / d2;
        double d6 = 0.0;
        if (d5 >= 0.0) {
            d6 = d3 / d2 * Math.pow(d5, -d3 - 1.0) * Math.exp(-Math.pow(d5, -d3));
        }
        return d6;
    }

    public static double[] frechetOrderStatisticMedians(double d, double d2, double d3, int n) {
        double d4 = n;
        double[] dArray = new double[n];
        double[] dArray2 = Stat.uniformOrderStatisticMedians(n);
        for (int i = 0; i < n; ++i) {
            dArray[i] = Stat.frechetInverseCDF(d, d2, d3, dArray2[i]);
        }
        return dArray;
    }

    public static double[] frechetOrderStatisticMedians(double d, double d2, int n) {
        return Stat.frechetOrderStatisticMedians(0.0, d, d2, n);
    }

    public static double[] frechetOrderStatisticMedians(double d, int n) {
        return Stat.frechetOrderStatisticMedians(0.0, 1.0, d, n);
    }

    public static double frechetMean(double d, double d2, double d3) {
        double d4 = Double.NaN;
        if (d3 > 1.0) {
            d4 = d + d2 * Stat.gamma(1.0 - 1.0 / d3);
        }
        return d4;
    }

    public static double frechetStandardDeviation(double d, double d2) {
        return Stat.frechetStandDev(d, d2);
    }

    public static double frechetStandDev(double d, double d2) {
        double d3 = Double.NaN;
        if (d2 > 2.0) {
            d3 = Stat.gamma(1.0 - 2.0 / d2) - Fmath.square(Stat.gamma(1.0 - 1.0 / d2));
            d3 = d * Math.sqrt(d3);
        }
        return d3;
    }

    public static double frechetMode(double d, double d2, double d3) {
        return d + d2 * Math.pow(d3 / (1.0 + d3), 1.0 / d3);
    }

    public static double[] frechetRand(double d, double d2, double d3, int n) {
        double[] dArray = new double[n];
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.pow(1.0 / Math.log(1.0 / random.nextDouble()), 1.0 / d3) * d2 + d;
        }
        return dArray;
    }

    public static double[] frechetRand(double d, double d2, double d3, int n, long l) {
        double[] dArray = new double[n];
        Random random = new Random(l);
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.pow(1.0 / Math.log(1.0 / random.nextDouble()), 1.0 / d3) * d2 + d;
        }
        return dArray;
    }

    public static double weibullCDF(double d, double d2, double d3, double d4) {
        double d5 = (d4 - d) / d2;
        double d6 = 0.0;
        if (d5 > 0.0) {
            d6 = 1.0 - Math.exp(-Math.pow(d5, d3));
        }
        return d6;
    }

    public static double weibullProb(double d, double d2, double d3, double d4) {
        double d5 = (d4 - d) / d2;
        double d6 = 0.0;
        if (d5 > 0.0) {
            d6 = 1.0 - Math.exp(-Math.pow(d5, d3));
        }
        return d6;
    }

    public static double weibullCDF(double d, double d2, double d3, double d4, double d5) {
        double d6 = (d4 - d) / d2;
        double d7 = (d5 - d) / d2;
        double d8 = 0.0;
        double d9 = 0.0;
        if (d6 >= 0.0) {
            d8 = -Math.exp(-Math.pow(d6, d3));
        }
        if (d7 >= 0.0) {
            d9 = -Math.exp(-Math.pow(d7, d3));
        }
        return d9 - d8;
    }

    public static double weibullProb(double d, double d2, double d3, double d4, double d5) {
        double d6 = (d4 - d) / d2;
        double d7 = (d5 - d) / d2;
        double d8 = 0.0;
        double d9 = 0.0;
        if (d6 >= 0.0) {
            d8 = -Math.exp(-Math.pow(d6, d3));
        }
        if (d7 >= 0.0) {
            d9 = -Math.exp(-Math.pow(d7, d3));
        }
        return d9 - d8;
    }

    public static double weibullInverseCDF(double d, double d2, double d3, double d4) {
        if (d4 < 0.0 || d4 > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + d4 + ", must lie between 0 and 1 inclusive");
        }
        double d5 = 0.0;
        d5 = d4 == 0.0 ? d : (d4 == 1.0 ? Double.POSITIVE_INFINITY : d + d2 * Math.pow(-Math.log(1.0 - d4), 1.0 / d3));
        return d5;
    }

    public static double inverseWeibullCDF(double d, double d2, double d3, double d4) {
        return Stat.weibullInverseCDF(d, d2, d3, d4);
    }

    public static double weibullInverseCDF(double d, double d2, double d3) {
        return Stat.weibullInverseCDF(0.0, d, d2, d3);
    }

    public static double inverseWeibullCDF(double d, double d2, double d3) {
        return Stat.weibullInverseCDF(0.0, d, d2, d3);
    }

    public static double weibullInverseCDF(double d, double d2) {
        return Stat.weibullInverseCDF(0.0, 1.0, d, d2);
    }

    public static double inverseWeibullCDF(double d, double d2) {
        return Stat.weibullInverseCDF(0.0, 1.0, d, d2);
    }

    public static double weibullPDF(double d, double d2, double d3, double d4) {
        double d5 = (d4 - d) / d2;
        double d6 = 0.0;
        if (d5 >= 0.0) {
            d6 = d3 / d2 * Math.pow(d5, d3 - 1.0) * Math.exp(-Math.pow(d5, d3));
        }
        return d6;
    }

    public static double weibull(double d, double d2, double d3, double d4) {
        double d5 = (d4 - d) / d2;
        double d6 = 0.0;
        if (d5 >= 0.0) {
            d6 = d3 / d2 * Math.pow(d5, d3 - 1.0) * Math.exp(-Math.pow(d5, d3));
        }
        return d6;
    }

    public static double weibullMean(double d, double d2, double d3) {
        return d + d2 * Stat.gamma(1.0 / d3 + 1.0);
    }

    public static double weibullStandardDeviation(double d, double d2) {
        return Stat.weibullStandDev(d, d2);
    }

    public static double weibullStandDev(double d, double d2) {
        double d3 = Stat.gamma(2.0 / d2 + 1.0) - Fmath.square(Stat.gamma(1.0 / d2 + 1.0));
        return d * Math.sqrt(d3);
    }

    public static double weibullMode(double d, double d2, double d3) {
        double d4 = d;
        if (d3 > 1.0) {
            d4 = d + d2 * Math.pow((d3 - 1.0) / d3, 1.0 / d3);
        }
        return d4;
    }

    public static double weibullMedian(double d, double d2, double d3) {
        return d + d2 * Math.pow(Math.log(2.0), 1.0 / d3);
    }

    public static double[] weibullRand(double d, double d2, double d3, int n) {
        double[] dArray = new double[n];
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.pow(-Math.log(1.0 - random.nextDouble()), 1.0 / d3) * d2 + d;
        }
        return dArray;
    }

    public static double[] weibullRand(double d, double d2, double d3, int n, long l) {
        double[] dArray = new double[n];
        Random random = new Random(l);
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.pow(-Math.log(1.0 - random.nextDouble()), 1.0 / d3) * d2 + d;
        }
        return dArray;
    }

    public static double[] weibullOrderStatisticMedians(double d, double d2, double d3, int n) {
        double d4 = n;
        double[] dArray = new double[n];
        double[] dArray2 = Stat.uniformOrderStatisticMedians(n);
        for (int i = 0; i < n; ++i) {
            dArray[i] = Stat.inverseWeibullCDF(d, d2, d3, dArray2[i]);
        }
        return dArray;
    }

    public static double[] weibullOrderStatisticMedians(double d, double d2, int n) {
        return Stat.weibullOrderStatisticMedians(0.0, d, d2, n);
    }

    public static double[] weibullOrderStatisticMedians(double d, int n) {
        return Stat.weibullOrderStatisticMedians(0.0, 1.0, d, n);
    }

    public static double exponentialCDF(double d, double d2, double d3) {
        double d4 = (d3 - d) / d2;
        double d5 = 0.0;
        if (d4 > 0.0) {
            d5 = 1.0 - Math.exp(-d4);
        }
        return d5;
    }

    public static double exponentialProb(double d, double d2, double d3) {
        double d4 = (d3 - d) / d2;
        double d5 = 0.0;
        if (d4 > 0.0) {
            d5 = 1.0 - Math.exp(-d4);
        }
        return d5;
    }

    public static double exponentialCDF(double d, double d2, double d3, double d4) {
        double d5 = (d3 - d) / d2;
        double d6 = (d4 - d) / d2;
        double d7 = 0.0;
        double d8 = 0.0;
        if (d5 >= 0.0) {
            d7 = -Math.exp(-d5);
        }
        if (d6 >= 0.0) {
            d8 = -Math.exp(-d6);
        }
        return d8 - d7;
    }

    public static double exponentialProb(double d, double d2, double d3, double d4) {
        double d5 = (d3 - d) / d2;
        double d6 = (d4 - d) / d2;
        double d7 = 0.0;
        double d8 = 0.0;
        if (d5 >= 0.0) {
            d7 = -Math.exp(-d5);
        }
        if (d6 >= 0.0) {
            d8 = -Math.exp(-d6);
        }
        return d8 - d7;
    }

    public static double exponentialInverseCDF(double d, double d2, double d3) {
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + d3 + ", must lie between 0 and 1 inclusive");
        }
        double d4 = 0.0;
        d4 = d3 == 0.0 ? d : (d3 == 1.0 ? Double.POSITIVE_INFINITY : d - d2 * Math.log(1.0 - d3));
        return d4;
    }

    public static double inverseExponentialCDF(double d, double d2, double d3) {
        return Stat.exponentialInverseCDF(d, d2, d3);
    }

    public static double exponentialPDF(double d, double d2, double d3) {
        double d4 = (d3 - d) / d2;
        double d5 = 0.0;
        if (d4 >= 0.0) {
            d5 = Math.exp(-d4) / d2;
        }
        return d5;
    }

    public static double exponential(double d, double d2, double d3) {
        double d4 = (d3 - d) / d2;
        double d5 = 0.0;
        if (d4 >= 0.0) {
            d5 = Math.exp(-d4) / d2;
        }
        return d5;
    }

    public static double exponentialMean(double d, double d2) {
        return d + d2;
    }

    public static double exponentialStandardDeviation(double d) {
        return d;
    }

    public static double exponentialStandDev(double d) {
        return d;
    }

    public static double exponentialMode(double d) {
        return d;
    }

    public static double exponentialMedian(double d, double d2) {
        return d + d2 * Math.log(2.0);
    }

    public static double[] exponentialRand(double d, double d2, int n) {
        double[] dArray = new double[n];
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            dArray[i] = d - Math.log(1.0 - random.nextDouble()) * d2;
        }
        return dArray;
    }

    public static double[] exponentialRand(double d, double d2, int n, long l) {
        double[] dArray = new double[n];
        Random random = new Random(l);
        for (int i = 0; i < n; ++i) {
            dArray[i] = d - Math.log(1.0 - random.nextDouble()) * d2;
        }
        return dArray;
    }

    public static double[] exponentialOrderStatisticMedians(double d, double d2, int n) {
        double d3 = n;
        double[] dArray = new double[n];
        double[] dArray2 = Stat.uniformOrderStatisticMedians(n);
        for (int i = 0; i < n; ++i) {
            dArray[i] = Stat.inverseExponentialCDF(d, d2, dArray2[i]);
        }
        return dArray;
    }

    public static double rayleighCDF(double d, double d2) {
        double d3 = d2 / d;
        double d4 = 0.0;
        if (d3 > 0.0) {
            d4 = 1.0 - Math.exp(-d3 * d3 / 2.0);
        }
        return d4;
    }

    public static double rayleighProb(double d, double d2) {
        double d3 = d2 / d;
        double d4 = 0.0;
        if (d3 > 0.0) {
            d4 = 1.0 - Math.exp(-d3 * d3 / 2.0);
        }
        return d4;
    }

    public static double rayleighCDF(double d, double d2, double d3) {
        double d4 = d2 / d;
        double d5 = d3 / d;
        double d6 = 0.0;
        double d7 = 0.0;
        if (d4 >= 0.0) {
            d6 = -Math.exp(-d4 * d4 / 2.0);
        }
        if (d5 >= 0.0) {
            d7 = -Math.exp(-d5 * d5 / 2.0);
        }
        return d7 - d6;
    }

    public static double rayleighProb(double d, double d2, double d3) {
        double d4 = d2 / d;
        double d5 = d3 / d;
        double d6 = 0.0;
        double d7 = 0.0;
        if (d4 >= 0.0) {
            d6 = -Math.exp(-d4 * d4 / 2.0);
        }
        if (d5 >= 0.0) {
            d7 = -Math.exp(-d5 * d5 / 2.0);
        }
        return d7 - d6;
    }

    public static double rayleighInverseCDF(double d, double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + d2 + ", must lie between 0 and 1 inclusive");
        }
        double d3 = 0.0;
        d3 = d2 == 0.0 ? 0.0 : (d2 == 1.0 ? Double.POSITIVE_INFINITY : d * Math.sqrt(-Math.log(1.0 - d2)));
        return d3;
    }

    public static double inverseRayleighCDF(double d, double d2) {
        return Stat.rayleighInverseCDF(d, d2);
    }

    public static double rayleighPDF(double d, double d2) {
        double d3 = d2 / d;
        double d4 = 0.0;
        if (d3 >= 0.0) {
            d4 = d3 / d * Math.exp(-d3 * d3 / 2.0) / d;
        }
        return d4;
    }

    public static double rayleigh(double d, double d2) {
        double d3 = d2 / d;
        double d4 = 0.0;
        if (d3 >= 0.0) {
            d4 = d3 / d * Math.exp(-d3 * d3 / 2.0) / d;
        }
        return d4;
    }

    public static double rayleighMean(double d) {
        return d * Math.sqrt(1.5707963267948966);
    }

    public static double rayleighStandardDeviation(double d) {
        return d * Math.sqrt(0.42920367320510344);
    }

    public static double rayleighStandDev(double d) {
        return d * Math.sqrt(0.42920367320510344);
    }

    public static double rayleighMode(double d) {
        return d;
    }

    public static double rayleighMedian(double d) {
        return d * Math.sqrt(Math.log(2.0));
    }

    public static double[] rayleighRand(double d, int n) {
        double[] dArray = new double[n];
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.sqrt(-2.0 * Math.log(1.0 - random.nextDouble())) * d;
        }
        return dArray;
    }

    public static double[] rayleighRand(double d, int n, long l) {
        double[] dArray = new double[n];
        Random random = new Random(l);
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.sqrt(-2.0 * Math.log(1.0 - random.nextDouble())) * d;
        }
        return dArray;
    }

    public static double[] rayleighOrderStatisticMedians(double d, int n) {
        double d2 = n;
        double[] dArray = new double[n];
        double[] dArray2 = Stat.uniformOrderStatisticMedians(n);
        for (int i = 0; i < n; ++i) {
            dArray[i] = Stat.inverseRayleighCDF(d, dArray2[i]);
        }
        return dArray;
    }

    public static double paretoCDF(double d, double d2, double d3) {
        double d4 = 0.0;
        if (d3 >= d2) {
            d4 = 1.0 - Math.pow(d2 / d3, d);
        }
        return d4;
    }

    public static double paretoProb(double d, double d2, double d3) {
        double d4 = 0.0;
        if (d3 >= d2) {
            d4 = 1.0 - Math.pow(d2 / d3, d);
        }
        return d4;
    }

    public static double paretoCDF(double d, double d2, double d3, double d4) {
        double d5 = 0.0;
        double d6 = 0.0;
        if (d3 >= d2) {
            d5 = -Math.pow(d2 / d3, d);
        }
        if (d4 >= d2) {
            d6 = -Math.pow(d2 / d4, d);
        }
        return d6 - d5;
    }

    public static double paretoProb(double d, double d2, double d3, double d4) {
        double d5 = 0.0;
        double d6 = 0.0;
        if (d3 >= d2) {
            d5 = -Math.pow(d2 / d3, d);
        }
        if (d4 >= d2) {
            d6 = -Math.pow(d2 / d4, d);
        }
        return d6 - d5;
    }

    public static double paretoInverseCDF(double d, double d2, double d3) {
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("Entered cdf value, " + d3 + ", must lie between 0 and 1 inclusive");
        }
        double d4 = 0.0;
        d4 = d3 == 0.0 ? d2 : (d3 == 1.0 ? Double.POSITIVE_INFINITY : d2 / Math.pow(1.0 - d3, 1.0 / d));
        return d4;
    }

    public static double inverseParetoCDF(double d, double d2, double d3) {
        return Stat.paretoInverseCDF(d, d2, d3);
    }

    public static double paretoPDF(double d, double d2, double d3) {
        double d4 = 0.0;
        if (d3 >= d2) {
            d4 = d * Math.pow(d2, d) / Math.pow(d3, d + 1.0);
        }
        return d4;
    }

    public static double pareto(double d, double d2, double d3) {
        double d4 = 0.0;
        if (d3 >= d2) {
            d4 = d * Math.pow(d2, d) / Math.pow(d3, d + 1.0);
        }
        return d4;
    }

    public static double paretoMean(double d, double d2) {
        double d3 = Double.NaN;
        if (d > 1.0) {
            d3 = d * d2 / (d - 1.0);
        }
        return d3;
    }

    public static double paretoStandardDeviation(double d, double d2) {
        double d3 = Double.NaN;
        if (d > 1.0) {
            d3 = d * Fmath.square(d2) / (Fmath.square(d - 1.0) * (d - 2.0));
        }
        return d3;
    }

    public static double paretoStandDev(double d, double d2) {
        double d3 = Double.NaN;
        if (d > 1.0) {
            d3 = d * Fmath.square(d2) / (Fmath.square(d - 1.0) * (d - 2.0));
        }
        return d3;
    }

    public static double paretoMode(double d) {
        return d;
    }

    public static double[] paretoRand(double d, double d2, int n) {
        double[] dArray = new double[n];
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.pow(1.0 - random.nextDouble(), -1.0 / d) * d2;
        }
        return dArray;
    }

    public static double[] paretoRand(double d, double d2, int n, long l) {
        double[] dArray = new double[n];
        Random random = new Random(l);
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.pow(1.0 - random.nextDouble(), -1.0 / d) * d2;
        }
        return dArray;
    }

    public static double[] paretoOrderStatisticMedians(double d, double d2, int n) {
        double d3 = n;
        double[] dArray = new double[n];
        double[] dArray2 = Stat.uniformOrderStatisticMedians(n);
        for (int i = 0; i < n; ++i) {
            dArray[i] = Stat.inverseParetoCDF(d, d2, dArray2[i]);
        }
        return dArray;
    }

    public void fitOneOrSeveralDistributions() {
        double[] dArray = this.getArray_as_double();
        Regression.fitOneOrSeveralDistributions(dArray);
    }

    public static void fitOneOrSeveralDistributions(double[] dArray) {
        Regression.fitOneOrSeveralDistributions(dArray);
    }

    public static double getGrubbsOneSidedCriticalT(double d, int n) {
        return Stat.getGrubbsCriticalT(d, n, 1);
    }

    public static double getGrubbsTwoSidedCriticalT(double d, int n) {
        return Stat.getGrubbsCriticalT(d, n, 2);
    }

    public static double getGrubbsCriticalT(double d, int n, int n2) {
        double d2 = Stat.studentstValue(d / (double)(n * n2), n - 2);
        double d3 = d2 * d2;
        return (double)(n - 1) * Math.sqrt(d3 / ((double)(n - 2) + d3) / (double)n);
    }

    public ArrayList<Object> outlierGrubbs(double d) {
        return Stat.outlierGrubbs(super.array_as_double(), d);
    }

    public static ArrayList<Object> outlierGrubbs(double[] dArray, double d) {
        Stat.denominatorSwap();
        int n = dArray.length;
        double d2 = Stat.mean(dArray);
        double d3 = Stat.standardDeviation(dArray);
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        arrayMaths = arrayMaths.minus(d2);
        arrayMaths = arrayMaths.abs();
        arrayMaths = arrayMaths.sort();
        int[] nArray = arrayMaths.originalIndices();
        double[] dArray2 = arrayMaths.getArray_as_double();
        double d4 = dArray[nArray[n - 1]];
        double d5 = Stat.getGrubbsTwoSidedCriticalT(d, n);
        double d6 = dArray2[n - 1] / d3;
        Stat.denominatorUnswap();
        return Stat.outlierGrubbsCore(d4, dArray, dArray2, n, d, d5, d6);
    }

    public ArrayList<Object> upperOutlierGrubbs(double d) {
        return Stat.upperOutlierGrubbs(super.array_as_double(), d);
    }

    public static ArrayList<Object> upperOutlierGrubbs(double[] dArray, double d) {
        Stat.denominatorSwap();
        int n = dArray.length;
        double d2 = Stat.mean(dArray);
        double d3 = Stat.standardDeviation(dArray);
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        arrayMaths = arrayMaths.sort();
        double[] dArray2 = arrayMaths.getArray_as_double();
        double d4 = dArray2[n - 1];
        double d5 = Stat.getGrubbsOneSidedCriticalT(d, n);
        double d6 = (d4 - d2) / d3;
        Stat.denominatorUnswap();
        return Stat.outlierGrubbsCore(d4, dArray, dArray2, n, d, d5, d6);
    }

    public ArrayList<Object> lowerOutlierGrubbs(double d) {
        return Stat.lowerOutlierGrubbs(super.array_as_double(), d);
    }

    public static ArrayList<Object> lowerOutlierGrubbs(double[] dArray, double d) {
        Stat.denominatorSwap();
        int n = dArray.length;
        double d2 = Stat.mean(dArray);
        double d3 = Stat.standardDeviation(dArray);
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        arrayMaths = arrayMaths.sort();
        double[] dArray2 = arrayMaths.getArray_as_double();
        double d4 = dArray2[0];
        double d5 = Stat.getGrubbsOneSidedCriticalT(d, n);
        double d6 = (d2 - d4) / d3;
        Stat.denominatorUnswap();
        return Stat.outlierGrubbsCore(d4, dArray, dArray2, n, d, d5, d6);
    }

    public static ArrayList<Object> outlierGrubbsCore(double d, double[] dArray, double[] dArray2, int n, double d2, double d3, double d4) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        double d5 = Double.NaN;
        int n2 = -1;
        if (d4 > d3) {
            int n3;
            d5 = d;
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            for (n3 = 0; n3 < n; ++n3) {
                if (dArray[n3] == d) {
                    n2 = n3;
                    continue;
                }
                arrayList2.add(dArray[n3]);
            }
            n3 = arrayList2.size();
            double[] dArray3 = new double[n3];
            for (int i = 0; i < n3; ++i) {
                dArray3[i] = (Double)arrayList2.get(i);
            }
            arrayList.add(true);
            arrayList.add(d5);
            arrayList.add(n2);
            arrayList.add(dArray3);
        } else {
            arrayList.add(false);
            arrayList.add(d5);
            arrayList.add(n2);
            arrayList.add(dArray);
        }
        arrayList.add(d4);
        arrayList.add(d3);
        arrayList.add(d2);
        arrayList.add(n);
        return arrayList;
    }

    public static Vector<Object> upperOutliersAnscombeAsVector(double[] dArray, double d) {
        ArrayList<Object> arrayList = Stat.upperOutliersAnscombeAsArrayList(dArray, d);
        Vector<Object> vector = null;
        if (arrayList != null) {
            int n = arrayList.size();
            vector = new Vector<Object>(n);
            for (int i = 0; i < n; ++i) {
                vector.add(arrayList.get(i));
            }
        }
        return vector;
    }

    public static Vector<Object> upperOutliersAnscombe(double[] dArray, double d) {
        return Stat.upperOutliersAnscombeAsVector(dArray, d);
    }

    public static ArrayList<Object> upperOutliersAnscombeAsArrayList(double[] dArray, double d) {
        int n;
        Stat stat = new Stat(dArray);
        double[] dArray2 = stat.getArray_as_double();
        double[] dArray3 = stat.getArray_as_double();
        int n2 = n = dArray.length;
        ArrayList<Number> arrayList = new ArrayList<Number>();
        int n3 = 0;
        boolean bl = true;
        while (bl) {
            double d2 = stat.mean_as_double();
            double d3 = stat.standardDeviation_as_double();
            double d4 = stat.getMaximum_as_double();
            int n4 = stat.getMaximumIndex();
            double d5 = (d4 - d2) / d3;
            if (d5 > d) {
                arrayList.add(new Double(d4));
                arrayList.add(new Integer(n4));
                ++n3;
                dArray3 = new double[n - 1];
                for (int i = n4; i < n - 1; ++i) {
                    dArray3[i] = dArray2[i + 1];
                }
                --n;
                stat = new Stat(Conv.copy(dArray3));
                continue;
            }
            bl = false;
        }
        double[] dArray4 = null;
        int[] nArray = null;
        if (n3 > 0) {
            dArray4 = new double[n3];
            nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                dArray4[i] = (Double)arrayList.get(2 * i);
                nArray[i] = (Integer)arrayList.get(2 * i + 1);
            }
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>(4);
        arrayList2.add(new Integer(n3));
        arrayList2.add(dArray4);
        arrayList2.add(nArray);
        arrayList2.add(dArray3);
        return arrayList2;
    }

    public static Vector<Object> upperOutliersAnscombeAsVector(BigDecimal[] bigDecimalArray, BigDecimal bigDecimal) {
        ArrayList<Object> arrayList = Stat.upperOutliersAnscombeAsArrayList(bigDecimalArray, bigDecimal);
        Vector<Object> vector = null;
        if (arrayList != null) {
            int n = arrayList.size();
            vector = new Vector<Object>(n);
            for (int i = 0; i < n; ++i) {
                vector.add(arrayList.get(i));
            }
        }
        return vector;
    }

    public static Vector<Object> upperOutliersAnscombe(BigDecimal[] bigDecimalArray, BigDecimal bigDecimal) {
        return Stat.upperOutliersAnscombeAsVector(bigDecimalArray, bigDecimal);
    }

    public static ArrayList<Object> upperOutliersAnscombeAsArrayList(BigDecimal[] bigDecimalArray, BigDecimal bigDecimal) {
        Object object;
        BigDecimal[] bigDecimalArray2;
        int n;
        Stat stat = new Stat(bigDecimalArray);
        BigDecimal[] bigDecimalArray3 = stat.getArray_as_BigDecimal();
        BigDecimal[] bigDecimalArray4 = stat.getArray_as_BigDecimal();
        int n2 = n = bigDecimalArray.length;
        ArrayList<Number> arrayList = new ArrayList<Number>();
        int n3 = 0;
        boolean bl = true;
        while (bl) {
            bigDecimalArray2 = stat.mean_as_BigDecimal();
            object = stat.variance_as_BigDecimal();
            BigDecimal bigDecimal2 = stat.getMaximum_as_BigDecimal();
            int n4 = stat.getMaximumIndex();
            BigDecimal bigDecimal3 = bigDecimal2.subtract((BigDecimal)bigDecimalArray2).divide((BigDecimal)object, 4);
            if (bigDecimal3.compareTo(bigDecimal.multiply(bigDecimal)) == 1) {
                arrayList.add(bigDecimal2);
                arrayList.add(new Integer(n4));
                ++n3;
                bigDecimalArray4 = new BigDecimal[n - 1];
                for (int i = n4; i < n - 1; ++i) {
                    bigDecimalArray4[i] = bigDecimalArray3[i + 1];
                }
                --n;
                stat = new Stat(Conv.copy(bigDecimalArray4));
                continue;
            }
            bigDecimalArray2 = null;
            object = null;
            bigDecimal3 = null;
            bigDecimalArray3 = null;
            bl = false;
        }
        bigDecimalArray2 = null;
        object = null;
        if (n3 > 0) {
            bigDecimalArray2 = new BigDecimal[n3];
            object = new int[n3];
            for (int i = 0; i < n3; ++i) {
                bigDecimalArray2[i] = (BigDecimal)arrayList.get(2 * i);
                object[i] = (Integer)arrayList.get(2 * i + 1);
            }
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>(4);
        arrayList2.add(new Integer(n3));
        arrayList2.add(bigDecimalArray2);
        arrayList2.add(object);
        arrayList2.add(bigDecimalArray4);
        return arrayList2;
    }

    public static Vector<Object> upperOutliersAnscombeAsVector(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        ArrayList<Object> arrayList = Stat.upperOutliersAnscombeAsArrayList(bigIntegerArray, bigInteger);
        Vector<Object> vector = null;
        if (arrayList != null) {
            int n = arrayList.size();
            vector = new Vector<Object>(n);
            for (int i = 0; i < n; ++i) {
                vector.add(arrayList.get(i));
            }
        }
        return vector;
    }

    public static Vector<Object> upperOutliersAnscombe(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        return Stat.upperOutliersAnscombeAsVector(bigIntegerArray, bigInteger);
    }

    public static ArrayList<Object> upperOutliersAnscombeAsArrayList(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        BigDecimal[] bigDecimalArray = arrayMaths.getArray_as_BigDecimal();
        BigDecimal bigDecimal = new BigDecimal(bigInteger);
        return Stat.upperOutliersAnscombeAsArrayList(bigDecimalArray, bigDecimal);
    }

    public static Vector<Object> lowerOutliersAnscombeAsVector(double[] dArray, double d) {
        ArrayList<Object> arrayList = Stat.lowerOutliersAnscombeAsArrayList(dArray, d);
        Vector<Object> vector = null;
        if (arrayList != null) {
            int n = arrayList.size();
            vector = new Vector<Object>(n);
            for (int i = 0; i < n; ++i) {
                vector.add(arrayList.get(i));
            }
        }
        return vector;
    }

    public static Vector<Object> lowerOutliersAnscombe(double[] dArray, double d) {
        return Stat.upperOutliersAnscombeAsVector(dArray, d);
    }

    public static ArrayList<Object> lowerOutliersAnscombeAsArrayList(double[] dArray, double d) {
        int n;
        Stat stat = new Stat(dArray);
        double[] dArray2 = stat.getArray_as_double();
        double[] dArray3 = stat.getArray_as_double();
        int n2 = n = dArray.length;
        ArrayList<Number> arrayList = new ArrayList<Number>();
        int n3 = 0;
        boolean bl = true;
        while (bl) {
            double d2 = stat.mean_as_double();
            double d3 = stat.standardDeviation_as_double();
            double d4 = stat.getMinimum_as_double();
            int n4 = stat.getMinimumIndex();
            double d5 = (d2 - d4) / d3;
            if (d5 > d) {
                arrayList.add(new Double(d4));
                arrayList.add(new Integer(n4));
                ++n3;
                dArray3 = new double[n - 1];
                for (int i = n4; i < n - 1; ++i) {
                    dArray3[i] = dArray2[i + 1];
                }
                --n;
                stat = new Stat(Conv.copy(dArray3));
                continue;
            }
            bl = false;
        }
        double[] dArray4 = null;
        int[] nArray = null;
        if (n3 > 0) {
            dArray4 = new double[n3];
            nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                dArray4[i] = (Double)arrayList.get(2 * i);
                nArray[i] = (Integer)arrayList.get(2 * i + 1);
            }
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add(new Integer(n3));
        arrayList2.add(dArray4);
        arrayList2.add(nArray);
        arrayList2.add(dArray3);
        return arrayList2;
    }

    public static Vector<Object> lowerOutliersAnscombeAsVector(BigDecimal[] bigDecimalArray, BigDecimal bigDecimal) {
        ArrayList<Object> arrayList = Stat.lowerOutliersAnscombeAsArrayList(bigDecimalArray, bigDecimal);
        Vector<Object> vector = null;
        if (arrayList != null) {
            int n = arrayList.size();
            vector = new Vector<Object>(n);
            for (int i = 0; i < n; ++i) {
                vector.add(arrayList.get(i));
            }
        }
        return vector;
    }

    public static Vector<Object> lowerOutliersAnscombe(BigDecimal[] bigDecimalArray, BigDecimal bigDecimal) {
        return Stat.upperOutliersAnscombeAsVector(bigDecimalArray, bigDecimal);
    }

    public static ArrayList<Object> lowerOutliersAnscombeAsArrayList(BigDecimal[] bigDecimalArray, BigDecimal bigDecimal) {
        Object object;
        BigDecimal[] bigDecimalArray2;
        int n;
        Stat stat = new Stat(bigDecimalArray);
        BigDecimal[] bigDecimalArray3 = stat.getArray_as_BigDecimal();
        BigDecimal[] bigDecimalArray4 = stat.getArray_as_BigDecimal();
        int n2 = n = bigDecimalArray.length;
        ArrayList<Number> arrayList = new ArrayList<Number>();
        int n3 = 0;
        boolean bl = true;
        while (bl) {
            bigDecimalArray2 = stat.mean_as_BigDecimal();
            object = stat.variance_as_BigDecimal();
            BigDecimal bigDecimal2 = stat.getMinimum_as_BigDecimal();
            int n4 = stat.getMinimumIndex();
            BigDecimal bigDecimal3 = bigDecimalArray2.subtract(bigDecimal2).divide((BigDecimal)object, 4);
            if (bigDecimal3.compareTo(bigDecimal.multiply(bigDecimal)) == 1) {
                arrayList.add(bigDecimal2);
                arrayList.add(new Integer(n4));
                ++n3;
                bigDecimalArray4 = new BigDecimal[n - 1];
                for (int i = n4; i < n - 1; ++i) {
                    bigDecimalArray4[i] = bigDecimalArray3[i + 1];
                }
                --n;
                stat = new Stat(Conv.copy(bigDecimalArray4));
                continue;
            }
            bigDecimalArray2 = null;
            object = null;
            bigDecimal3 = null;
            bigDecimalArray3 = null;
            bl = false;
        }
        bigDecimalArray2 = null;
        object = null;
        if (n3 > 0) {
            bigDecimalArray2 = new BigDecimal[n3];
            object = new int[n3];
            for (int i = 0; i < n3; ++i) {
                bigDecimalArray2[i] = (BigDecimal)arrayList.get(2 * i);
                object[i] = (Integer)arrayList.get(2 * i + 1);
            }
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add(new Integer(n3));
        arrayList2.add(bigDecimalArray2);
        arrayList2.add(object);
        arrayList2.add(bigDecimalArray4);
        return arrayList2;
    }

    public static Vector<Object> lowerOutliersAnscombeAsVector(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        ArrayList<Object> arrayList = Stat.lowerOutliersAnscombeAsArrayList(bigIntegerArray, bigInteger);
        Vector<Object> vector = null;
        if (arrayList != null) {
            int n = arrayList.size();
            vector = new Vector<Object>(n);
            for (int i = 0; i < n; ++i) {
                vector.add(arrayList.get(i));
            }
        }
        return vector;
    }

    public static Vector<Object> lowerOutliersAnscombe(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        return Stat.upperOutliersAnscombeAsVector(bigIntegerArray, bigInteger);
    }

    public static ArrayList<Object> lowerOutliersAnscombeAsArrayList(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        BigDecimal[] bigDecimalArray = arrayMaths.getArray_as_BigDecimal();
        BigDecimal bigDecimal = new BigDecimal(bigInteger);
        return Stat.lowerOutliersAnscombeAsArrayList(bigDecimalArray, bigDecimal);
    }

    @Override
    public Stat copy() {
        Object object;
        int n;
        Phasor[] phasorArray;
        Complex[] complexArray;
        int n2;
        int n3;
        long l;
        Object[] objectArray;
        Integer n4;
        Stat stat = new Stat();
        stat.amWeights = this.amWeights == null ? null : this.amWeights;
        stat.weightsSupplied = this.weightsSupplied;
        stat.upperOutlierDetails = new ArrayList();
        if (this.upperOutlierDetails.size() != 0) {
            n4 = (Integer)this.upperOutlierDetails.get(0);
            stat.upperOutlierDetails.add(n4);
            stat.upperOutlierDetails.add(this.upperOutlierDetails.get(1));
            objectArray = (int[])this.upperOutlierDetails.get(2);
            stat.upperOutlierDetails.add(objectArray);
            stat.upperOutlierDetails.add(this.upperOutlierDetails.get(3));
        }
        stat.upperDone = this.upperDone;
        stat.lowerOutlierDetails = new ArrayList();
        if (this.lowerOutlierDetails.size() != 0) {
            n4 = (Integer)this.lowerOutlierDetails.get(0);
            stat.lowerOutlierDetails.add(n4);
            stat.lowerOutlierDetails.add(this.lowerOutlierDetails.get(1));
            objectArray = (int[])this.lowerOutlierDetails.get(2);
            stat.lowerOutlierDetails.add(objectArray);
            stat.lowerOutlierDetails.add(this.lowerOutlierDetails.get(3));
        }
        stat.lowerDone = this.lowerDone;
        stat.length = this.length;
        stat.maxIndex = this.maxIndex;
        stat.minIndex = this.minIndex;
        stat.sumDone = this.sumDone;
        stat.productDone = this.productDone;
        stat.sumlongToDouble = this.sumlongToDouble;
        stat.productlongToDouble = this.productlongToDouble;
        stat.type = this.type;
        stat.originalTypes = (int[])(this.originalTypes == null ? null : Conv.copy(this.originalTypes));
        stat.sortedIndices = (int[])(this.sortedIndices == null ? null : Conv.copy(this.sortedIndices));
        stat.suppressMessages = this.suppressMessages;
        stat.minmax = new ArrayList();
        if (this.minmax.size() != 0) {
            switch (this.type) {
                case 0: 
                case 1: {
                    double d = (Double)this.minmax.get(0);
                    stat.minmax.add(new Double(d));
                    d = (Double)this.minmax.get(1);
                    stat.minmax.add(new Double(d));
                    break;
                }
                case 4: 
                case 5: {
                    l = (Long)this.minmax.get(0);
                    stat.minmax.add(new Double(l));
                    l = (Long)this.minmax.get(1);
                    stat.minmax.add(new Long(l));
                    break;
                }
                case 2: 
                case 3: {
                    float f = ((Float)this.minmax.get(0)).floatValue();
                    stat.minmax.add(new Double(f));
                    f = ((Float)this.minmax.get(1)).floatValue();
                    stat.minmax.add(new Double(f));
                    break;
                }
                case 6: 
                case 7: {
                    int n5 = (Integer)this.minmax.get(0);
                    stat.minmax.add(new Integer(n5));
                    n5 = ((Double)this.minmax.get(1)).intValue();
                    stat.minmax.add(new Integer(n5));
                    break;
                }
                case 8: 
                case 9: {
                    n3 = ((Short)this.minmax.get(0)).shortValue();
                    stat.minmax.add(new Short((short)n3));
                    n3 = ((Double)this.minmax.get(1)).shortValue();
                    stat.minmax.add(new Short((short)n3));
                    break;
                }
                case 10: 
                case 11: {
                    n2 = ((Byte)this.minmax.get(0)).byteValue();
                    stat.minmax.add(new Byte((byte)n2));
                    n3 = ((Byte)this.minmax.get(1)).byteValue();
                    stat.minmax.add(new Byte((byte)n2));
                    break;
                }
                case 12: {
                    complexArray = (Complex[])this.minmax.get(0);
                    stat.minmax.add(complexArray);
                    complexArray = (BigDecimal)this.minmax.get(1);
                    stat.minmax.add(complexArray);
                    complexArray = null;
                    break;
                }
                case 13: {
                    phasorArray = (Phasor[])this.minmax.get(0);
                    stat.minmax.add(phasorArray);
                    phasorArray = (BigInteger)this.minmax.get(1);
                    stat.minmax.add(phasorArray);
                    phasorArray = null;
                    break;
                }
                case 16: 
                case 17: {
                    n = (Integer)this.minmax.get(0);
                    stat.minmax.add(new Integer(n));
                    n = ((Double)this.minmax.get(1)).intValue();
                    stat.minmax.add(new Integer(n));
                }
            }
        }
        stat.summ = new ArrayList();
        if (this.summ.size() != 0) {
            switch (this.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 18: {
                    double d = (Double)this.summ.get(0);
                    stat.summ.add(new Double(d));
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 16: 
                case 17: {
                    if (this.sumlongToDouble) {
                        double d = (Double)this.summ.get(0);
                        stat.summ.add(new Double(d));
                        break;
                    }
                    l = (Long)this.summ.get(0);
                    stat.summ.add(new Long(l));
                    break;
                }
                case 12: {
                    BigDecimal bigDecimal = (BigDecimal)this.summ.get(0);
                    stat.summ.add(bigDecimal);
                    break;
                }
                case 13: {
                    object = (BigInteger)this.summ.get(0);
                    stat.summ.add(object);
                    break;
                }
                case 14: {
                    Complex complex = (Complex)this.summ.get(0);
                    stat.summ.add(complex);
                    break;
                }
                case 15: {
                    Phasor phasor = (Phasor)this.summ.get(0);
                    stat.summ.add(phasor);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Data type not identified by this method");
                }
            }
        }
        stat.productt = new ArrayList();
        if (this.productt.size() != 0) {
            switch (this.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 18: {
                    double d = (Double)this.productt.get(0);
                    stat.productt.add(new Double(d));
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 16: 
                case 17: {
                    if (this.sumlongToDouble) {
                        double d = (Double)this.productt.get(0);
                        stat.productt.add(new Double(d));
                        break;
                    }
                    long l2 = (Long)this.productt.get(0);
                    stat.productt.add(new Long(l2));
                    break;
                }
                case 12: {
                    BigDecimal bigDecimal = (BigDecimal)this.productt.get(0);
                    stat.productt.add(bigDecimal);
                    break;
                }
                case 13: {
                    object = (BigInteger)this.productt.get(0);
                    stat.productt.add(object);
                    break;
                }
                case 14: {
                    Complex complex = (Complex)this.productt.get(0);
                    stat.productt.add(complex);
                    break;
                }
                case 15: {
                    Phasor phasor = (Phasor)this.productt.get(0);
                    stat.productt.add(phasor);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Data type not identified by this method");
                }
            }
        }
        switch (this.type) {
            case 0: 
            case 1: {
                double[] dArray = Conv.copy(this.getArray_as_double());
                for (int i = 0; i < this.length; ++i) {
                    stat.array.add(new Double(dArray[i]));
                }
                break;
            }
            case 2: 
            case 3: {
                objectArray = Conv.copy(this.getArray_as_float());
                for (int i = 0; i < this.length; ++i) {
                    stat.array.add(new Float(objectArray[i]));
                }
                break;
            }
            case 4: 
            case 5: {
                long[] lArray = Conv.copy(this.getArray_as_long());
                for (int i = 0; i < this.length; ++i) {
                    stat.array.add(new Long(lArray[i]));
                }
                break;
            }
            case 6: 
            case 7: {
                object = Conv.copy(this.getArray_as_int());
                for (int i = 0; i < this.length; ++i) {
                    stat.array.add(new Integer((int)object[i]));
                }
                break;
            }
            case 8: 
            case 9: {
                short[] sArray = Conv.copy(this.getArray_as_short());
                for (int i = 0; i < this.length; ++i) {
                    stat.array.add(new Short(sArray[i]));
                }
                break;
            }
            case 10: 
            case 11: {
                byte[] byArray = Conv.copy(this.getArray_as_byte());
                for (n3 = 0; n3 < this.length; ++n3) {
                    stat.array.add(new Byte(byArray[n3]));
                }
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = Conv.copy(this.getArray_as_BigDecimal());
                for (n2 = 0; n2 < this.length; ++n2) {
                    stat.array.add(bigDecimalArray[n2]);
                }
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = Conv.copy(this.getArray_as_BigInteger());
                for (int i = 0; i < this.length; ++i) {
                    stat.array.add(bigIntegerArray[i]);
                }
                break;
            }
            case 14: {
                complexArray = this.getArray_as_Complex();
                for (int i = 0; i < this.length; ++i) {
                    stat.array.add(complexArray[i].copy());
                }
                break;
            }
            case 15: {
                phasorArray = this.getArray_as_Phasor();
                for (n = 0; n < this.length; ++n) {
                    stat.array.add(phasorArray[n].copy());
                }
                break;
            }
            case 16: 
            case 17: {
                char[] cArray = Conv.copy(this.getArray_as_char());
                for (int i = 0; i < this.length; ++i) {
                    stat.array.add(new Character(cArray[i]));
                }
                break;
            }
            case 18: {
                String[] stringArray = Conv.copy(this.getArray_as_String());
                for (int i = 0; i < this.length; ++i) {
                    stat.array.add(stringArray[i]);
                }
                break;
            }
        }
        return stat;
    }
}

