/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.Cronbach;
import flanagan.analysis.PCA;
import flanagan.analysis.Stat;
import flanagan.io.Db;
import flanagan.io.FileChooser;
import flanagan.io.FileInput;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import flanagan.plot.PlotGraph;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;

public class Scores {
    protected String[] title = null;
    protected int titleLines = 0;
    protected String inputFilename = null;
    protected String outputFilename = null;
    protected int fileOption = 1;
    protected boolean fileOptionSet = false;
    protected String[] fileExtensions = new String[]{".txt", ".xls"};
    protected boolean fileNumberingSet = false;
    protected int trunc = 6;
    protected boolean truncAll = false;
    protected int originalDataType = -1;
    protected int originalDataOrder = -1;
    protected Object originalData = null;
    protected double[][] scores0 = null;
    protected double[][] originalScores0 = null;
    protected double[][] standardizedScores0 = null;
    protected boolean[][] missingScores0 = null;
    protected double[][] scores1 = null;
    protected double[][] originalScores1 = null;
    protected double[][] standardizedScores1 = null;
    protected boolean[][] missingRespones1 = null;
    protected int readFlag = -1;
    protected boolean dataEntered = false;
    protected boolean dataPreprocessed = false;
    protected int nItems = 0;
    protected int originalNitems = 0;
    protected String[] itemNames = null;
    protected String[] originalItemNames = null;
    protected boolean itemNamesSet = false;
    protected int nPersons = 0;
    protected int originalNpersons = 0;
    protected String[] personNames = null;
    protected String[] originalPersonNames = null;
    protected boolean personNamesSet = false;
    protected int nScores = 0;
    protected int originalNscores = 0;
    protected String otherFalse = null;
    protected String otherTrue = null;
    protected boolean otherDichotomousDataSet = false;
    protected boolean[] dichotomous = null;
    protected double[] dichotomousPercentage = null;
    protected boolean dichotomousOverall = false;
    protected boolean dichotomousCheckDone = false;
    protected double dichotTrue = 1.0;
    protected double dichotFalse = -1.0;
    protected boolean dichotSet = false;
    protected boolean letterToNumeralSet = true;
    protected boolean ignoreNoResponseRequests = false;
    protected double itemDeletionPercentage = 100.0;
    protected boolean itemDeletionPercentageSet = false;
    protected double personDeletionPercentage = 100.0;
    protected boolean personDeletionPercentageSet = false;
    protected ArrayList<String> almrDeletedPersons = new ArrayList();
    protected int replacementOption = 3;
    protected String[] replacementOptionNames = new String[]{"score replaced by zero", "score replaced by person's mean", "score replaced by item mean", "score replaced by overall mean", "user supplied score for each 'no response'"};
    protected boolean replacementOptionSet = false;
    protected boolean allNoResponseOptionsSet = false;
    protected boolean noResponseHandlingSet = false;
    protected int nNaN = 0;
    protected boolean[] deletedItems = null;
    protected int nDeletedItems = 0;
    protected int[] deletedItemsIndices = null;
    protected int[] itemIndices = null;
    protected ArrayList<String> almrDeletedItems = new ArrayList();
    protected boolean[] deletedPersons = null;
    protected int nDeletedPersons = 0;
    protected int[] deletedPersonsIndices = null;
    protected int[] personIndices = null;
    protected int nReplacements = 0;
    protected String[] replacementIndices = null;
    protected double[] rawItemMeans = null;
    protected double rawItemMeansMean = Double.NaN;
    protected double rawItemMeansSd = Double.NaN;
    protected double rawItemMeansVar = Double.NaN;
    protected double rawItemMeansMin = Double.NaN;
    protected double rawItemMeansMax = Double.NaN;
    protected double rawItemMeansRange = Double.NaN;
    protected double[] rawItemStandardDeviations = null;
    protected double rawItemStandardDeviationsMean = Double.NaN;
    protected double rawItemStandardDeviationsSd = Double.NaN;
    protected double rawItemStandardDeviationsVar = Double.NaN;
    protected double rawItemStandardDeviationsMin = Double.NaN;
    protected double rawItemStandardDeviationsMax = Double.NaN;
    protected double rawItemStandardDeviationsRange = Double.NaN;
    protected double[] rawItemVariances = null;
    protected double rawItemVariancesMean = Double.NaN;
    protected double rawItemVariancesSd = Double.NaN;
    protected double rawItemVariancesVar = Double.NaN;
    protected double rawItemVariancesMin = Double.NaN;
    protected double rawItemVariancesMax = Double.NaN;
    protected double rawItemVariancesRange = Double.NaN;
    protected double[] rawItemMinima = null;
    protected double rawItemMinimaMean = Double.NaN;
    protected double rawItemMinimaSd = Double.NaN;
    protected double rawItemMinimaVar = Double.NaN;
    protected double rawItemMinimaMin = Double.NaN;
    protected double rawItemMinimaMax = Double.NaN;
    protected double rawItemMinimaRange = Double.NaN;
    protected double[] rawItemMaxima = null;
    protected double rawItemMaximaMean = Double.NaN;
    protected double rawItemMaximaSd = Double.NaN;
    protected double rawItemMaximaVar = Double.NaN;
    protected double rawItemMaximaMin = Double.NaN;
    protected double rawItemMaximaMax = Double.NaN;
    protected double rawItemMaximaRange = Double.NaN;
    protected double[] rawItemRanges = null;
    protected double rawItemRangesMean = Double.NaN;
    protected double rawItemRangesSd = Double.NaN;
    protected double rawItemRangesVar = Double.NaN;
    protected double rawItemRangesMin = Double.NaN;
    protected double rawItemRangesMax = Double.NaN;
    protected double rawItemRangesRange = Double.NaN;
    protected double[] rawItemTotals = null;
    protected double rawItemTotalsMean = Double.NaN;
    protected double rawItemTotalsSd = Double.NaN;
    protected double rawItemTotalsVar = Double.NaN;
    protected double rawItemTotalsMin = Double.NaN;
    protected double rawItemTotalsMax = Double.NaN;
    protected double rawItemTotalsRange = Double.NaN;
    protected double[] rawItemMedians = null;
    protected double rawItemMediansMean = Double.NaN;
    protected double rawItemMediansSd = Double.NaN;
    protected double rawItemMediansVar = Double.NaN;
    protected double rawItemMediansMin = Double.NaN;
    protected double rawItemMediansMax = Double.NaN;
    protected double rawItemMediansRange = Double.NaN;
    protected double[] rawItemMomentSkewness = null;
    protected double[] rawItemMedianSkewness = null;
    protected double[] rawItemQuartileSkewness = null;
    protected double[] rawItemKurtosisExcess = null;
    protected double[] rawPersonMeans = null;
    protected double[] rawPersonStandardDeviations = null;
    protected double[] rawPersonVariances = null;
    protected double[] rawPersonMinima = null;
    protected double[] rawPersonMaxima = null;
    protected double[] rawPersonRanges = null;
    protected double[] rawPersonTotals = null;
    protected double rawAllResponsesMean = Double.NaN;
    protected double rawAllResponsesStandardDeviation = Double.NaN;
    protected double rawAllResponsesVariance = Double.NaN;
    protected double rawAllResponsesMinimum = Double.NaN;
    protected double rawAllResponsesMaximum = Double.NaN;
    protected double rawAllResponsesRange = Double.NaN;
    protected double rawAllResponsesTotal = Double.NaN;
    protected double[][] rawCovariances = null;
    protected double[][] rawCorrelationCoefficients = null;
    protected double[] rawRhosWithTotal = null;
    protected double rawMeanRhoWithTotals = Double.NaN;
    protected double rawStandardDeviationRhoWithTotals = Double.NaN;
    protected double rawMeanRhoWithoutTotals = Double.NaN;
    protected double rawStandardDeviationRhoWithoutTotals = Double.NaN;
    protected double[] standardizedItemMeans = null;
    protected double standardizedItemMeansMean = Double.NaN;
    protected double standardizedItemMeansSd = Double.NaN;
    protected double standardizedItemMeansVar = Double.NaN;
    protected double standardizedItemMeansMin = Double.NaN;
    protected double standardizedItemMeansMax = Double.NaN;
    protected double standardizedItemMeansRange = Double.NaN;
    protected double[] standardizedItemStandardDeviations = null;
    protected double standardizedItemStandardDeviationsMean = Double.NaN;
    protected double standardizedItemStandardDeviationsSd = Double.NaN;
    protected double standardizedItemStandardDeviationsVar = Double.NaN;
    protected double standardizedItemStandardDeviationsMin = Double.NaN;
    protected double standardizedItemStandardDeviationsMax = Double.NaN;
    protected double standardizedItemStandardDeviationsRange = Double.NaN;
    protected double[] standardizedItemVariances = null;
    protected double standardizedItemVariancesMean = Double.NaN;
    protected double standardizedItemVariancesSd = Double.NaN;
    protected double standardizedItemVariancesVar = Double.NaN;
    protected double standardizedItemVariancesMin = Double.NaN;
    protected double standardizedItemVariancesMax = Double.NaN;
    protected double standardizedItemVariancesRange = Double.NaN;
    protected double[] standardizedItemMinima = null;
    protected double standardizedItemMinimaMean = Double.NaN;
    protected double standardizedItemMinimaSd = Double.NaN;
    protected double standardizedItemMinimaVar = Double.NaN;
    protected double standardizedItemMinimaMin = Double.NaN;
    protected double standardizedItemMinimaMax = Double.NaN;
    protected double standardizedItemMinimaRange = Double.NaN;
    protected double[] standardizedItemMaxima = null;
    protected double standardizedItemMaximaMean = Double.NaN;
    protected double standardizedItemMaximaSd = Double.NaN;
    protected double standardizedItemMaximaVar = Double.NaN;
    protected double standardizedItemMaximaMin = Double.NaN;
    protected double standardizedItemMaximaMax = Double.NaN;
    protected double standardizedItemMaximaRange = Double.NaN;
    protected double[] standardizedItemRanges = null;
    protected double standardizedItemRangesMean = Double.NaN;
    protected double standardizedItemRangesSd = Double.NaN;
    protected double standardizedItemRangesVar = Double.NaN;
    protected double standardizedItemRangesMin = Double.NaN;
    protected double standardizedItemRangesMax = Double.NaN;
    protected double standardizedItemRangesRange = Double.NaN;
    protected double[] standardizedItemTotals = null;
    protected double standardizedItemTotalsMean = Double.NaN;
    protected double standardizedItemTotalsSd = Double.NaN;
    protected double standardizedItemTotalsVar = Double.NaN;
    protected double standardizedItemTotalsMin = Double.NaN;
    protected double standardizedItemTotalsMax = Double.NaN;
    protected double standardizedItemTotalsRange = Double.NaN;
    protected double[] standardizedItemMedians = null;
    protected double standardizedItemMediansMean = Double.NaN;
    protected double standardizedItemMediansSd = Double.NaN;
    protected double standardizedItemMediansVar = Double.NaN;
    protected double standardizedItemMediansMin = Double.NaN;
    protected double standardizedItemMediansMax = Double.NaN;
    protected double standardizedItemMediansRange = Double.NaN;
    protected double[] standardizedItemMomentSkewness = null;
    protected double[] standardizedItemMedianSkewness = null;
    protected double[] standardizedItemQuartileSkewness = null;
    protected double[] standardizedItemKurtosisExcess = null;
    protected double[] standardizedPersonMeans = null;
    protected double[] standardizedPersonStandardDeviations = null;
    protected double[] standardizedPersonVariances = null;
    protected double[] standardizedPersonMinima = null;
    protected double[] standardizedPersonMaxima = null;
    protected double[] standardizedPersonRanges = null;
    protected double[] standardizedPersonTotals = null;
    protected double standardizedAllResponsesMean = Double.NaN;
    protected double standardizedAllResponsesStandardDeviation = Double.NaN;
    protected double standardizedAllResponsesVariance = Double.NaN;
    protected double standardizedAllResponsesMinimum = Double.NaN;
    protected double standardizedAllResponsesMaximum = Double.NaN;
    protected double standardizedAllResponsesRange = Double.NaN;
    protected double standardizedAllResponsesTotal = Double.NaN;
    protected double[][] standardizedCovariances = null;
    protected double[][] standardizedCorrelationCoefficients = null;
    protected double[] standardizedRhosWithTotal = null;
    protected double standardizedMeanRhoWithTotals = Double.NaN;
    protected double standardizedStandardDeviationRhoWithTotals = Double.NaN;
    protected double standardizedMeanRhoWithoutTotals = Double.NaN;
    protected double standardizedStandardDeviationRhoWithoutTotals = Double.NaN;
    protected boolean variancesCalculated = false;
    protected boolean covariancesCalculated = false;
    protected boolean nFactorOption = false;
    protected int sameCheck = 0;

    public void enterTitle(String string) {
        if (this.title == null) {
            this.title = new String[2];
            this.title[0] = "Title: " + string;
            Date date = new Date();
            String string2 = DateFormat.getDateInstance().format(date);
            String string3 = DateFormat.getTimeInstance().format(date);
            this.title[1] = "Program execution initiated at " + string3 + " on " + string2;
        } else {
            this.title[0] = string;
        }
    }

    public void setPersonDeletionPercentage(double d) {
        this.personDeletionPercentage = d;
        this.personDeletionPercentageSet = true;
        if (this.itemDeletionPercentageSet && this.replacementOptionSet) {
            this.allNoResponseOptionsSet = true;
            if (this.dataEntered) {
                this.preprocessData();
            }
        }
    }

    public void setItemDeletionPercentage(double d) {
        this.itemDeletionPercentage = d;
        this.itemDeletionPercentageSet = true;
        if (this.personDeletionPercentageSet && this.replacementOptionSet) {
            this.allNoResponseOptionsSet = true;
            if (this.dataEntered) {
                this.preprocessData();
            }
        }
    }

    public void setMissingDataOption(int n) {
        if (n < 1 || n > 5) {
            throw new IllegalArgumentException("The missing response option entered is " + n + "; the option must be 1, 2, 3, 4 or 5");
        }
        this.replacementOption = n;
        this.replacementOptionSet = true;
        if (this.personDeletionPercentageSet && this.itemDeletionPercentageSet) {
            this.allNoResponseOptionsSet = true;
            if (this.dataEntered) {
                this.preprocessData();
            }
        }
    }

    public void ignoreMissingDataOptionRequests() {
        this.ignoreNoResponseRequests = true;
        this.allNoResponseOptionsSet = true;
        this.itemDeletionPercentageSet = true;
        this.personDeletionPercentageSet = true;
        this.allNoResponseOptionsSet = true;
    }

    protected void noResponseHandling() {
        if (this.nNaN > 0 && !this.noResponseHandlingSet) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            this.nDeletedPersons = 0;
            this.missingScores0 = new boolean[this.nItems][this.nPersons];
            for (n5 = 0; n5 < this.nItems; ++n5) {
                for (n4 = 0; n4 < this.nPersons; ++n4) {
                    this.missingScores0[n5][n4] = false;
                }
            }
            for (n5 = 0; n5 < this.nPersons; ++n5) {
                n4 = 0;
                this.deletedPersons[n5] = false;
                for (n3 = 0; n3 < this.nItems; ++n3) {
                    if (!Double.isNaN(this.scores0[n3][n5])) continue;
                    ++n4;
                }
                if (n4 != this.nItems) continue;
                this.deletedPersons[n5] = true;
            }
            for (n5 = 0; n5 < this.nPersons; ++n5) {
                if (this.deletedPersons[n5]) continue;
                n4 = 0;
                for (n3 = 0; n3 < this.nItems; ++n3) {
                    double d;
                    if (!Double.isNaN(this.scores0[n3][n5]) || !((d = (double)(++n4) * 100.0 / (double)this.nItems) > this.personDeletionPercentage)) continue;
                    this.deletedPersons[n5] = true;
                }
            }
            for (n5 = 0; n5 < this.nPersons; ++n5) {
                if (!this.deletedPersons[n5]) continue;
                ++this.nDeletedPersons;
            }
            if (this.nDeletedPersons > 0) {
                n5 = 0;
                this.deletedPersonsIndices = new int[this.nDeletedPersons];
                for (n4 = 0; n4 < this.nPersons; ++n4) {
                    if (!this.deletedPersons[n4]) continue;
                    this.deletedPersonsIndices[n5] = n4;
                    ++n5;
                }
                double[][] dArray = new double[this.nItems][this.nPersons - this.nDeletedPersons];
                boolean[][] blArray = new boolean[this.nItems][this.nPersons - this.nDeletedPersons];
                String[] stringArray = new String[this.nPersons - this.nDeletedItems];
                this.personIndices = new int[this.nPersons - this.nDeletedPersons];
                n5 = 0;
                for (n2 = 0; n2 < this.nPersons; ++n2) {
                    stringArray[n2] = this.personNames[n2];
                    if (this.deletedPersons[n2]) continue;
                    this.almrDeletedPersons.add(this.personNames[n2]);
                    for (n = 0; n < this.nItems; ++n) {
                        dArray[n][n5] = this.scores0[n][n2];
                        blArray[n][n5] = this.missingScores0[n][n2];
                    }
                    this.personIndices[n5] = n2;
                    ++n5;
                }
                this.nPersons -= this.nDeletedPersons;
                this.nScores = this.nPersons * this.nItems;
                this.scores0 = dArray;
                this.missingScores0 = blArray;
                this.personNames = stringArray;
                this.scores1 = this.transpose(this.scores0);
            }
            if (this.nDeletedPersons == 0) {
                this.personIndices = new int[this.nPersons];
                for (n5 = 0; n5 < this.nPersons; ++n5) {
                    this.personIndices[n5] = n5;
                }
            }
            this.deletedItems = new boolean[this.nItems];
            this.nDeletedItems = 0;
            for (n5 = 0; n5 < this.nItems; ++n5) {
                int n6 = 0;
                this.deletedItems[n5] = false;
                for (int i = 0; i < this.nPersons; ++i) {
                    if (!Double.isNaN(this.scores0[n5][i])) continue;
                    ++n6;
                }
                if (n6 != this.nPersons) continue;
                this.deletedItems[n5] = true;
            }
            for (n5 = 0; n5 < this.nItems; ++n5) {
                this.deletedItems[n5] = false;
                int n7 = 0;
                for (int i = 0; i < this.nPersons; ++i) {
                    double d;
                    if (!Double.isNaN(this.scores0[n5][i]) || !((d = (double)(++n7) * 100.0 / (double)this.nPersons) > this.itemDeletionPercentage)) continue;
                    this.deletedItems[n5] = true;
                }
            }
            for (n5 = 0; n5 < this.nItems; ++n5) {
                if (!this.deletedItems[n5]) continue;
                ++this.nDeletedItems;
            }
            if (this.nDeletedItems > 0) {
                n5 = 0;
                this.deletedItemsIndices = new int[this.nDeletedItems];
                for (int i = 0; i < this.nItems; ++i) {
                    if (!this.deletedItems[i]) continue;
                    this.deletedItemsIndices[n5] = i;
                    ++n5;
                }
                if (this.nItems - this.nDeletedItems <= 1) {
                    throw new IllegalArgumentException("You have deleted " + this.nDeletedItems + " items leaving " + (this.nItems - this.nDeletedItems) + " items and hence no possibility calculation of alpha");
                }
                double[][] dArray = new double[this.nItems - this.nDeletedItems][this.nPersons];
                boolean[][] blArray = new boolean[this.nItems - this.nDeletedItems][this.nPersons];
                String[] stringArray = new String[this.nItems - this.nDeletedItems];
                this.itemIndices = new int[this.nItems - this.nDeletedItems];
                n5 = 0;
                for (n2 = 0; n2 < this.nItems; ++n2) {
                    if (this.deletedItems[n2]) continue;
                    this.almrDeletedItems.add(this.itemNames[n2]);
                    stringArray[n5] = this.itemNames[n2];
                    for (n = 0; n < this.nPersons; ++n) {
                        dArray[n5][n] = this.scores0[n2][n];
                        blArray[n5][n] = this.missingScores0[n2][n];
                    }
                    this.itemIndices[n5] = n2;
                    ++n5;
                }
                this.nItems -= this.nDeletedItems;
                this.nScores = this.nPersons * this.nItems;
                this.scores0 = dArray;
                this.missingScores0 = blArray;
                this.scores1 = this.transpose(this.scores0);
                this.itemNames = stringArray;
            }
            if (this.nDeletedItems == 0) {
                this.itemIndices = new int[this.nItems];
                for (n5 = 0; n5 < this.nItems; ++n5) {
                    this.itemIndices[n5] = n5;
                }
            }
            n5 = 0;
            for (int i = 0; i < this.nPersons; ++i) {
                for (int j = 0; j < this.nItems; ++j) {
                    if (!Double.isNaN(this.scores0[j][i])) continue;
                    this.missingScores0[j][i] = true;
                    ++n5;
                }
            }
            if (n5 > 0) {
                int n8;
                int n9;
                int n10;
                double[] dArray = new double[this.nItems];
                double d = 0.0;
                n2 = 0;
                n = 0;
                while (n < this.nItems) {
                    dArray[n] = 0.0;
                    n10 = 0;
                    for (n9 = 0; n9 < this.nPersons; ++n9) {
                        if (Double.isNaN(this.scores0[n][n9])) continue;
                        int n11 = n;
                        dArray[n11] = dArray[n11] + this.scores0[n][n9];
                        ++n10;
                        d += this.scores0[n][n9];
                        ++n2;
                    }
                    int n12 = n++;
                    dArray[n12] = dArray[n12] / (double)n10;
                    d /= (double)n2;
                }
                double[] dArray2 = new double[this.nPersons];
                n10 = 0;
                while (n10 < this.nPersons) {
                    dArray2[n10] = 0.0;
                    n9 = 0;
                    for (n8 = 0; n8 < this.nItems; ++n8) {
                        if (Double.isNaN(this.scores0[n8][n10])) continue;
                        int n13 = n10;
                        dArray2[n13] = dArray2[n13] + this.scores0[n8][n10];
                        ++n9;
                    }
                    int n14 = n10++;
                    dArray2[n14] = dArray2[n14] / (double)n9;
                }
                this.replacementIndices = new String[n5];
                n10 = 0;
                switch (this.replacementOption) {
                    case 1: {
                        for (n9 = 0; n9 < this.nItems; ++n9) {
                            for (n8 = 0; n8 < this.nPersons; ++n8) {
                                if (!Double.isNaN(this.scores0[n9][n8])) continue;
                                this.scores0[n9][n8] = this.dichotSet ? this.dichotFalse : 0.0;
                                this.replacementIndices[n10] = this.itemNames[n9] + ", " + (n8 + 1) + ";";
                                ++n10;
                            }
                        }
                        break;
                    }
                    case 2: {
                        for (n9 = 0; n9 < this.nItems; ++n9) {
                            for (n8 = 0; n8 < this.nPersons; ++n8) {
                                if (!Double.isNaN(this.scores0[n9][n8])) continue;
                                this.scores0[n9][n8] = dArray2[n9];
                                this.replacementIndices[n10] = this.itemNames[n9] + ", " + (n8 + 1) + ";";
                                ++n10;
                            }
                        }
                        break;
                    }
                    case 3: {
                        for (n9 = 0; n9 < this.nItems; ++n9) {
                            for (n8 = 0; n8 < this.nPersons; ++n8) {
                                if (!Double.isNaN(this.scores0[n9][n8])) continue;
                                this.scores0[n9][n8] = dArray[n9];
                                this.replacementIndices[n10] = this.itemNames[n9] + ", " + (n8 + 1) + ";";
                                ++n10;
                            }
                        }
                        break;
                    }
                    case 4: {
                        for (n9 = 0; n9 < this.nItems; ++n9) {
                            for (n8 = 0; n8 < this.nPersons; ++n8) {
                                if (!Double.isNaN(this.scores0[n9][n8])) continue;
                                this.scores0[n9][n8] = d;
                                this.replacementIndices[n10] = this.itemNames[n9] + ", " + (n8 + 1) + ";";
                                ++n10;
                            }
                        }
                        break;
                    }
                    case 5: {
                        for (n9 = 0; n9 < this.nItems; ++n9) {
                            for (n8 = 0; n8 < this.nPersons; ++n8) {
                                if (!Double.isNaN(this.scores0[n9][n8])) continue;
                                String string = "Missing response:";
                                String string2 = "\nItem index = " + n9 + ",    item mean = " + Fmath.truncate(dArray[n9], 4);
                                String string3 = "\nPerson index = " + n8 + ",    person's responses mean = " + Fmath.truncate(dArray2[n8], 4);
                                String string4 = "\nTotal mean = " + Fmath.truncate(d, 4);
                                String string5 = "\nEnter the replacement value";
                                String string6 = string + string2 + string3 + string4 + string5;
                                this.scores0[n9][n8] = Db.readDouble(string6);
                                this.replacementIndices[n10] = this.itemNames[n9] + ", " + (n8 + 1) + ";";
                                ++n10;
                            }
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("!! It should not be possible to have an option choice (replacementOption) = " + this.replacementOption);
                    }
                }
                this.nReplacements = n10--;
            }
        }
        this.scores1 = this.transpose(this.scores0);
        this.noResponseHandlingSet = true;
        if (this.dichotSet) {
            this.resetDichotomousMissingValues();
        }
    }

    public void resetDichotomousMissingValues() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("No data has been entered");
        }
        if (!this.noResponseHandlingSet) {
            this.noResponseHandling();
        }
        if (this.nReplacements > 0) {
            switch (this.replacementOption) {
                case 2: {
                    double[][] dArray = this.transpose(this.scores0);
                    boolean[][] blArray = this.transpose(this.missingScores0);
                    for (int i = 0; i < this.nPersons; ++i) {
                        double d = Fmath.maximum(dArray[i]);
                        double d2 = Fmath.minimum(dArray[i]);
                        double d3 = (d + d2) / 2.0;
                        for (int j = 0; j < this.nItems; ++j) {
                            if (!blArray[i][j]) continue;
                            dArray[i][j] = dArray[i][j] >= d3 ? d : d2;
                        }
                    }
                    this.scores0 = this.transpose(dArray);
                    break;
                }
                case 3: {
                    for (int i = 0; i < this.nItems; ++i) {
                        double d = Fmath.maximum(this.scores0[i]);
                        double d4 = Fmath.minimum(this.scores0[i]);
                        double d5 = (d + d4) / 2.0;
                        for (int j = 0; j < this.nPersons; ++j) {
                            if (!this.missingScores0[i][j]) continue;
                            this.scores0[i][j] = this.scores0[i][j] >= d5 ? d : d4;
                        }
                    }
                    break;
                }
                case 4: {
                    double d = Fmath.maximum(this.scores0[0]);
                    double d6 = Fmath.minimum(this.scores0[0]);
                    for (int i = 1; i < this.nItems; ++i) {
                        double d7 = Fmath.maximum(this.scores0[i]);
                        double d8 = Fmath.minimum(this.scores0[i]);
                        if (d7 > d) {
                            d = d7;
                        }
                        if (!(d8 < d6)) continue;
                        d6 = d8;
                    }
                    double d9 = (d + d6) / 2.0;
                    for (int i = 0; i < this.nItems; ++i) {
                        for (int j = 0; j < this.nPersons; ++j) {
                            if (!this.missingScores0[i][j]) continue;
                            this.scores0[i][j] = this.scores0[i][j] >= d9 ? d : d6;
                        }
                    }
                    break;
                }
            }
        }
        this.scores1 = this.transpose(this.scores0);
        this.dichotomousOverall = true;
    }

    private void frequencyCount() {
        int n;
        int n2;
        int n3;
        ArrayList<Number> arrayList = new ArrayList<Number>();
        boolean[][] blArray = new boolean[this.nItems][this.nPersons];
        for (n3 = 0; n3 < this.nItems; ++n3) {
            for (n2 = 0; n2 < this.nPersons; ++n2) {
                blArray[n3][n2] = this.scores0[n3][n2] == this.scores0[n3][n2];
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < this.nItems; ++n2) {
            for (int i = 0; i < this.nPersons; ++i) {
                n3 = 0;
                if (!blArray[n2][i]) continue;
                blArray[n2][i] = false;
                ++n3;
                for (int j = 0; j < this.nItems; ++j) {
                    for (n = 0; n < this.nPersons; ++n) {
                        if (!blArray[j][n] || this.scores0[j][n] != this.scores0[n2][i]) continue;
                        ++n3;
                        blArray[j][n] = false;
                    }
                }
                arrayList.add(new Double(this.scores0[n2][i]));
                arrayList.add(new Integer(n3));
            }
        }
        n2 = arrayList.size() / 2;
        if (n2 > 0) {
            int n4;
            double[] dArray = new double[n2];
            int[] nArray = new int[n2];
            n = 0;
            for (int i = 0; i < n2; ++i) {
                dArray[i] = (Double)arrayList.get(n++);
                nArray[i] = (Integer)arrayList.get(n++);
            }
            ArrayMaths arrayMaths = new ArrayMaths(nArray);
            arrayMaths = arrayMaths.descendingSort();
            int[] nArray2 = arrayMaths.originalIndices();
            double[] dArray2 = new double[n2];
            int[] nArray3 = new int[n2];
            for (int i = 0; i < n2; ++i) {
                dArray2[i] = dArray[nArray2[i]];
                nArray3[i] = nArray[nArray2[i]];
            }
            if (dArray2[0] < dArray2[1]) {
                double d = dArray2[0];
                dArray2[0] = dArray2[1];
                dArray2[1] = d;
            }
            double[] dArray3 = new double[n2];
            dArray3[0] = this.dichotTrue;
            dArray3[1] = this.dichotFalse;
            for (n4 = 2; n4 < n2; ++n4) {
                dArray3[n4] = Double.NaN;
                this.nNaN += nArray3[n4];
                this.nReplacements += nArray3[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                for (int i = 0; i < this.nItems; ++i) {
                    for (int j = 0; j < this.nPersons; ++j) {
                        if (this.scores0[i][j] != dArray2[n4]) continue;
                        this.scores0[i][j] = dArray3[n4];
                    }
                }
            }
        }
    }

    protected void noResponseRequests() {
        if (!this.allNoResponseOptionsSet) {
            if (!this.ignoreNoResponseRequests) {
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                String string6;
                String string7;
                if (this.personDeletionPercentage != 0.0 && !this.itemDeletionPercentageSet) {
                    string7 = "There are missing responses in this data set";
                    string6 = "\nYou have not set the percentage of no responses at which you will delete an item";
                    string5 = "\n(0% = item deleted if a single 'no response' present in the item)";
                    string4 = "\n(100% = item never deleted)";
                    string3 = "\nEnter the required value and click OK ";
                    string2 = "\nor simply click OK for default value";
                    string = string7 + string6 + string5 + string4 + string3 + string2;
                    this.itemDeletionPercentage = Db.readDouble(string, this.itemDeletionPercentage);
                }
                this.itemDeletionPercentageSet = true;
                if (this.itemDeletionPercentage != 0.0 && !this.personDeletionPercentageSet) {
                    string7 = "There are missing responses in this data set";
                    string6 = "\nYou have not set the percentage of no responses at which you will delete a person";
                    string5 = "\n(0% = person deleted if gives a single 'no response')";
                    string4 = "\n(100% = person never deleted)";
                    string3 = "\nEnter the required value and click OK ";
                    string2 = "\nor simply click OK for default value";
                    string = string7 + string6 + string5 + string4 + string3 + string2;
                    this.personDeletionPercentage = Db.readDouble(string, this.personDeletionPercentage);
                }
                this.personDeletionPercentageSet = true;
                if (this.itemDeletionPercentage != 0.0 && this.personDeletionPercentage != 0.0 && !this.replacementOptionSet) {
                    string7 = "There are missing responses in this data set";
                    string6 = "\nYou have not set the option flag for replacing a missing score";
                    string5 = "\n  option = 1 - score replaced by zero or lower dichotomous pair";
                    string4 = "\n  option = 2 - score replaced by person's mean or rounded mean";
                    string3 = "\n  option = 3 - score replaced by item mean or rounded mean (default option)";
                    string2 = "\n  option = 4 - score replaced by overall mean or rounded mean";
                    string = "\n  option = 5 - user supplied score for each 'missing response'";
                    String string8 = "\nEnter the required value and click OK ";
                    String string9 = "\nor simply click OK for default value";
                    String string10 = string7 + string6 + string5 + string4 + string3 + string2 + string + string8 + string9;
                    this.replacementOption = Db.readInt(string10, this.replacementOption);
                }
                this.replacementOptionSet = true;
            }
            this.allNoResponseOptionsSet = true;
        }
    }

    public void setDenominatorToN() {
        this.nFactorOption = true;
    }

    public void setDenominatorToNminusOne() {
        this.nFactorOption = false;
    }

    public int[] deletedPersonsIndices() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (this.nDeletedPersons == 0) {
            System.out.println("Method - deletedPersonsIndices: there are no deleted persons; null returned");
            return null;
        }
        ArrayMaths arrayMaths = new ArrayMaths(this.deletedPersonsIndices);
        ArrayMaths arrayMaths2 = arrayMaths.plus(1);
        return arrayMaths2.array_as_int();
    }

    public int numberOfDeletedPersons() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.nDeletedPersons;
    }

    public int[] deletedItemsIndices() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (this.nDeletedItems == 0) {
            System.out.println("Method - deletedItemsIndices: there are no deleted items; null returned");
            return null;
        }
        ArrayMaths arrayMaths = new ArrayMaths(this.deletedItemsIndices);
        ArrayMaths arrayMaths2 = arrayMaths.plus(1);
        return arrayMaths2.array_as_int();
    }

    public String[] deletedItemsNames() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (this.nDeletedItems == 0) {
            System.out.println("Method - deletedItemsIndices: there are no deleted items; null returned");
            return null;
        }
        String[] stringArray = new String[this.nDeletedItems];
        for (int i = 0; i < this.nDeletedItems; ++i) {
            stringArray[i] = this.originalItemNames[this.deletedItemsIndices[i]];
        }
        return stringArray;
    }

    public int numberOfDeletedItems() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.nDeletedItems;
    }

    public void readScoresAsRowPerItemA() {
        this.readFlag = 2;
        this.readScoresAsRowPerItemCore();
    }

    public void readScoresAsRowPerItemA(String string) {
        this.readFlag = 3;
        this.inputFilename = string;
        this.readScoresAsRowPerItemCore();
    }

    public void readScoresAsRowPerItemB() {
        this.readFlag = 4;
        this.readScoresAsRowPerItemCore();
    }

    public void readScoresAsRowPerItemB(String string) {
        this.readFlag = 5;
        this.inputFilename = string;
        this.readScoresAsRowPerItemCore();
    }

    public void readScoresAsRowPerItemC() {
        this.readFlag = 6;
        this.readScoresOnlyAsRowPerItemCore();
    }

    public void readScoresAsRowPerItemC(String string) {
        this.readFlag = 7;
        this.inputFilename = string;
        this.readScoresOnlyAsRowPerItemCore();
    }

    public void readScoresAsRowPerItemD() {
        this.readFlag = 8;
        this.readScoresOnlyAsRowPerItemCore();
    }

    public void readScoresAsRowPerItemD(String string) {
        this.readFlag = 9;
        this.inputFilename = string;
        this.readScoresOnlyAsRowPerItemCore();
    }

    public void readScoresAsRowPerItem() {
        this.readFlag = 0;
        this.readScoresAsRowPerItemCore();
    }

    public void readScoresAsRowPerItem(String string) {
        this.readFlag = 1;
        this.inputFilename = string;
        this.readScoresAsRowPerItemCore();
    }

    protected void readScoresAsRowPerItemCore() {
        int n;
        FileInput fileInput;
        if (this.readFlag == 0 || this.readFlag == 2 || this.readFlag == 4) {
            fileInput = new FileChooser();
            this.inputFilename = ((FileChooser)fileInput).selectFile();
            fileInput.close();
        }
        fileInput = new FileInput(this.inputFilename);
        this.setTitle0(fileInput);
        int n2 = 1;
        this.nItems = fileInput.readInt();
        if (fileInput.eol()) {
            ++n2;
        }
        this.itemNames = new String[this.nItems];
        this.nPersons = fileInput.readInt();
        if (fileInput.eol()) {
            ++n2;
        }
        this.nScores = this.nItems * this.nPersons;
        if (this.readFlag == 4 || this.readFlag == 5) {
            this.itemNames = new String[this.nItems + 1];
            for (n = 0; n < this.nItems; ++n) {
                this.itemNames[n] = fileInput.readWord();
                if (!fileInput.eol()) continue;
                ++n2;
            }
            this.itemNames[this.nItems] = "total";
            this.originalItemNames = (String[])this.itemNames.clone();
            this.itemNamesSet = true;
        }
        this.personNames = new String[this.nPersons + 1];
        for (n = 0; n < this.nPersons; ++n) {
            this.personNames[n] = fileInput.readWord();
            if (!fileInput.eol()) continue;
            ++n2;
        }
        this.personNames[this.nPersons] = "total";
        this.originalPersonNames = (String[])this.personNames.clone();
        this.personNamesSet = true;
        String[][] stringArray = new String[this.nItems][this.nPersons];
        for (int i = 0; i < this.nItems; ++i) {
            int n3 = 1;
            if (this.readFlag == 2 || this.readFlag == 3) {
                this.itemNames[i] = fileInput.readWord();
            }
            for (int j = 0; j < this.nPersons; ++j) {
                stringArray[i][j] = fileInput.readWord();
                if (fileInput.eol()) {
                    if (n3 != this.nPersons) {
                        throw new IllegalArgumentException("Line " + n2 + ": the number of scores in this row, " + n3 + ", does not equal the total number of persons, " + this.nPersons);
                    }
                    ++n2;
                    continue;
                }
                ++n3;
            }
        }
        if (this.readFlag == 2 || this.readFlag == 3) {
            this.itemNamesSet = true;
        }
        fileInput.close();
        if (this.readFlag == 0 || this.readFlag == 1) {
            this.defaultItemNames();
        }
        this.storeData(stringArray, 1, 0);
    }

    protected void readScoresOnlyAsRowPerItemCore() {
        int n;
        Object object;
        int n2;
        FileInput fileInput;
        if (this.readFlag == 6 || this.readFlag == 8) {
            fileInput = new FileChooser();
            this.inputFilename = ((FileChooser)fileInput).selectFile();
            fileInput.close();
        }
        fileInput = new FileInput(this.inputFilename);
        this.setTitle1();
        this.nItems = fileInput.numberOfLines();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.readFlag == 6 || this.readFlag == 7) {
            for (n2 = 0; n2 < this.nItems; ++n2) {
                boolean bl = true;
                object = new ArrayList<String>();
                while (bl) {
                    ((ArrayList)object).add(fileInput.readWord());
                    if (!fileInput.eol()) continue;
                    bl = false;
                    n = ((ArrayList)object).size();
                    if (n2 == 0) {
                        this.nPersons = n;
                        this.originalData = new String[this.nItems][this.nPersons];
                    } else if (n != this.nPersons) {
                        throw new IllegalArgumentException("Line " + n2 + ": the number of scores in this row, " + n + ", does not equal the total number of persons, " + this.nPersons + ", calculated from the first row");
                    }
                    arrayList.add(object);
                }
            }
        } else {
            for (n2 = 0; n2 < this.nItems; ++n2) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                object = fileInput.readLine();
                n = ((String)object).length();
                if (n2 == 0) {
                    this.nPersons = n;
                } else if (n != this.nPersons) {
                    throw new IllegalArgumentException("Line " + n2 + ": the number of scores in this row, " + n + ", does not equal the total number of persons, " + this.nPersons + ", calculated from the first row");
                }
                for (int i = 0; i < this.nPersons; ++i) {
                    arrayList2.add(String.valueOf(((String)object).charAt(i)));
                }
                arrayList.add(arrayList2);
            }
        }
        String[][] stringArray = new String[this.nItems][this.nPersons];
        ArrayList arrayList3 = new ArrayList();
        for (int i = 0; i < this.nItems; ++i) {
            arrayList3 = (ArrayList)arrayList.get(i);
            for (n = 0; n < this.nPersons; ++n) {
                stringArray[i][n] = (String)arrayList3.get(n);
            }
        }
        this.defaultPersonNames();
        this.defaultItemNames();
        this.storeData(stringArray, 1, 0);
    }

    protected void setTitle0(FileInput fileInput) {
        this.title = new String[3];
        this.titleLines = 3;
        this.title[0] = fileInput.readLine();
        this.title[1] = "Data read from file: " + this.inputFilename;
        Date date = new Date();
        String string = DateFormat.getDateInstance().format(date);
        String string2 = DateFormat.getTimeInstance().format(date);
        this.title[2] = "Program execution initiated at " + string2 + " on " + string;
    }

    protected void setTitle1() {
        this.title = new String[2];
        this.title[0] = "Untitled Scores Analysis";
        Date date = new Date();
        String string = DateFormat.getDateInstance().format(date);
        String string2 = DateFormat.getTimeInstance().format(date);
        this.title[1] = "Program execution initiated at " + string2 + " on " + string;
    }

    protected void storeData(Object object, int n, int n2) {
        this.originalData = object;
        this.originalDataType = n;
        this.originalDataOrder = n2;
        this.dataEntered = true;
    }

    public void enterScoresAsRowPerItem(String[][] stringArray) {
        this.nItems = stringArray.length;
        this.nPersons = stringArray[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.setTitle1();
        }
        this.defaultPersonNames();
        this.defaultItemNames();
        this.storeData(Conv.copy(stringArray), 1, 0);
    }

    public void enterScoresAsRowPerItem(double[][] dArray) {
        this.nItems = dArray.length;
        this.nPersons = dArray[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.setTitle1();
        }
        this.defaultPersonNames();
        this.defaultItemNames();
        this.storeData(Conv.copy(dArray), 2, 0);
    }

    public void enterScoresAsRowPerItem(Matrix matrix) {
        double[][] dArray = matrix.getArrayCopy();
        this.nItems = dArray.length;
        this.nPersons = dArray[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.setTitle1();
        }
        this.defaultPersonNames();
        this.defaultItemNames();
        this.storeData(Conv.copy(matrix), 3, 0);
        this.originalData = matrix.copy();
    }

    public void enterScoresAsRowPerItem(float[][] fArray) {
        this.nItems = fArray.length;
        this.nPersons = fArray[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.setTitle1();
        }
        this.defaultPersonNames();
        this.defaultItemNames();
        this.storeData(Conv.copy(fArray), 4, 0);
    }

    public void enterScoresAsRowPerItem(int[][] nArray) {
        this.nItems = nArray.length;
        this.nPersons = nArray[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.setTitle1();
        }
        this.defaultPersonNames();
        this.defaultItemNames();
        this.storeData(Conv.copy(nArray), 5, 0);
    }

    public void enterScoresAsRowPerItem(char[][] cArray) {
        this.nItems = cArray.length;
        this.nPersons = cArray[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.setTitle1();
        }
        this.defaultPersonNames();
        this.defaultItemNames();
        this.storeData(Conv.copy(cArray), 6, 0);
    }

    public void enterScoresAsRowPerItem(boolean[][] blArray) {
        this.nItems = blArray.length;
        this.nPersons = blArray[0].length;
        this.nScores = this.nItems * this.nPersons;
        this.dichotomous = new boolean[this.nItems];
        if (this.title == null) {
            this.setTitle1();
        }
        this.defaultPersonNames();
        this.defaultItemNames();
        this.storeData(Conv.copy(blArray), 7, 0);
    }

    public void readScoresAsRowPerPersonA() {
        this.readFlag = 2;
        this.readScoresAsRowPerPersonCore();
    }

    public void readScoresAsRowPerPersonA(String string) {
        this.readFlag = 3;
        this.inputFilename = string;
        this.readScoresAsRowPerPersonCore();
    }

    public void readScoresAsRowPerPersonB() {
        this.readFlag = 4;
        this.readScoresAsRowPerPersonCore();
    }

    public void readScoresAsRowPerPersonB(String string) {
        this.readFlag = 5;
        this.inputFilename = string;
        this.readScoresAsRowPerPersonCore();
    }

    public void readScoresAsRowPerPersonC() {
        this.readFlag = 6;
        this.readScoresOnlyAsRowPerPersonCore();
    }

    public void readScoresAsRowPerPersonC(String string) {
        this.readFlag = 7;
        this.inputFilename = string;
        this.readScoresOnlyAsRowPerPersonCore();
    }

    public void readScoresAsRowPerPersonD() {
        this.readFlag = 8;
        this.readScoresOnlyAsRowPerPersonCore();
    }

    public void readScoresAsRowPerPersonD(String string) {
        this.readFlag = 9;
        this.inputFilename = string;
        this.readScoresOnlyAsRowPerPersonCore();
    }

    public void readScoresAsRowPerPerson() {
        this.readFlag = 0;
        this.readScoresAsRowPerPersonCore();
    }

    public void readScoresAsRowPerPerson(String string) {
        this.readFlag = 1;
        this.inputFilename = string;
        this.readScoresAsRowPerPersonCore();
    }

    protected void readScoresAsRowPerPersonCore() {
        int n;
        FileInput fileInput;
        if (this.readFlag == 0 || this.readFlag == 2 || this.readFlag == 4) {
            fileInput = new FileChooser();
            this.inputFilename = ((FileChooser)fileInput).selectFile();
            fileInput.close();
        }
        fileInput = new FileInput(this.inputFilename);
        this.setTitle0(fileInput);
        int n2 = 1;
        this.nItems = fileInput.readInt();
        if (fileInput.eol()) {
            ++n2;
        }
        this.nPersons = fileInput.readInt();
        if (fileInput.eol()) {
            ++n2;
        }
        this.nScores = this.nItems * this.nPersons;
        this.itemNames = new String[this.nItems + 1];
        for (n = 0; n < this.nItems; ++n) {
            this.itemNames[n] = fileInput.readWord();
            if (!fileInput.eol()) continue;
            ++n2;
        }
        this.itemNames[this.nItems] = "total";
        this.originalItemNames = this.itemNames;
        this.itemNamesSet = true;
        if (this.readFlag == 4 || this.readFlag == 5) {
            this.personNames = new String[this.nPersons + 1];
            for (n = 0; n < this.nPersons; ++n) {
                this.personNames[n] = fileInput.readWord();
                if (!fileInput.eol()) continue;
                ++n2;
            }
            this.personNames[this.nPersons] = "total";
            this.originalPersonNames = (String[])this.personNames.clone();
            this.personNamesSet = true;
        }
        String[][] stringArray = new String[this.nPersons][this.nItems];
        this.personNames = new String[this.nPersons];
        for (int i = 0; i < this.nPersons; ++i) {
            int n3 = 1;
            if (this.readFlag == 2 || this.readFlag == 3) {
                this.personNames[i] = fileInput.readWord();
            }
            for (int j = 0; j < this.nItems; ++j) {
                stringArray[i][j] = fileInput.readWord();
                if (fileInput.eol()) {
                    if (n3 != this.nItems) {
                        throw new IllegalArgumentException("Line " + n2 + ": the number of scores in this row, " + n3 + ", does not equal the total number of items, " + this.nItems);
                    }
                    ++n2;
                    continue;
                }
                ++n3;
            }
        }
        if (this.readFlag == 2 || this.readFlag == 3) {
            this.personNamesSet = true;
        }
        fileInput.close();
        if (this.readFlag == 0 || this.readFlag == 1) {
            this.defaultPersonNames();
        }
        this.storeData(stringArray, 1, 1);
    }

    protected void readScoresOnlyAsRowPerPersonCore() {
        int n;
        Object object;
        int n2;
        FileInput fileInput;
        if (this.readFlag == 6 || this.readFlag == 8) {
            fileInput = new FileChooser();
            this.inputFilename = ((FileChooser)fileInput).selectFile();
            fileInput.close();
        }
        fileInput = new FileInput(this.inputFilename);
        this.setTitle1();
        this.nPersons = fileInput.numberOfLines();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.readFlag == 6 || this.readFlag == 7) {
            for (n2 = 0; n2 < this.nPersons; ++n2) {
                boolean bl = true;
                object = new ArrayList<String>();
                while (bl) {
                    ((ArrayList)object).add(fileInput.readWord());
                    if (!fileInput.eol()) continue;
                    bl = false;
                    n = ((ArrayList)object).size();
                    if (n2 == 0) {
                        this.nItems = n;
                        this.originalData = new String[this.nPersons][this.nItems];
                    } else if (n != this.nItems) {
                        throw new IllegalArgumentException("Line " + n2 + ": the number of scores in this row, " + n + ", does not equal the total number of persons, " + this.nPersons + ", calculated from the first row (line 0)");
                    }
                    arrayList.add(object);
                }
            }
        } else {
            for (n2 = 0; n2 < this.nPersons; ++n2) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                object = fileInput.readLine();
                n = ((String)object).length();
                if (n2 == 0) {
                    this.nItems = n;
                } else if (n != this.nItems) {
                    throw new IllegalArgumentException("Line " + n2 + ": the number of scores in this row, " + n + ", does not equal the total number of persons, " + this.nPersons + ", calculated from the first row");
                }
                for (int i = 0; i < this.nItems; ++i) {
                    arrayList2.add(String.valueOf(((String)object).charAt(i)));
                }
                arrayList.add(arrayList2);
            }
        }
        String[][] stringArray = new String[this.nPersons][this.nItems];
        ArrayList arrayList3 = new ArrayList();
        for (int i = 0; i < this.nPersons; ++i) {
            arrayList3 = (ArrayList)arrayList.get(i);
            for (n = 0; n < this.nItems; ++n) {
                stringArray[i][n] = (String)arrayList3.get(n);
            }
        }
        this.defaultPersonNames();
        this.defaultItemNames();
        this.storeData(stringArray, 1, 1);
    }

    public void enterScoresAsRowPerPerson(String[][] stringArray) {
        this.nPersons = stringArray.length;
        this.nItems = stringArray[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.setTitle1();
        }
        this.storeData(Conv.copy(stringArray), 1, 1);
        this.defaultPersonNames();
        this.defaultItemNames();
    }

    public void enterScoresAsRowPerIperson(String[][] stringArray) {
        this.enterScoresAsRowPerPerson(stringArray);
    }

    public void enterScoresAsRowPerPerson(double[][] dArray) {
        this.nPersons = dArray.length;
        this.nItems = dArray[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.setTitle1();
        }
        this.storeData(Conv.copy(dArray), 2, 1);
        this.defaultPersonNames();
        this.defaultItemNames();
    }

    public void enterScoresAsRowPerPerson(Matrix matrix) {
        double[][] dArray = matrix.getArrayCopy();
        this.nPersons = dArray.length;
        this.nItems = dArray[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.setTitle1();
        }
        this.storeData(Conv.copy(matrix), 3, 1);
        this.defaultPersonNames();
        this.defaultItemNames();
    }

    public void enterScoresAsRowPerPerson(float[][] fArray) {
        this.nPersons = fArray.length;
        this.nItems = fArray[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.setTitle1();
        }
        this.storeData(Conv.copy(fArray), 4, 1);
        this.defaultPersonNames();
        this.defaultItemNames();
    }

    public void enterScoresAsRowPerPerson(int[][] nArray) {
        this.nPersons = nArray.length;
        this.nItems = nArray[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.setTitle1();
        }
        this.storeData(Conv.copy(nArray), 5, 1);
        this.defaultPersonNames();
        this.defaultItemNames();
    }

    public void enterScoresAsRowPerPerson(char[][] cArray) {
        this.nPersons = cArray.length;
        this.nItems = cArray[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.setTitle1();
        }
        this.storeData(Conv.copy(cArray), 6, 1);
        this.defaultPersonNames();
        this.defaultItemNames();
    }

    public void enterScoresAsRowPerPerson(boolean[][] blArray) {
        this.nPersons = blArray.length;
        this.nItems = blArray[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.setTitle1();
        }
        this.storeData(Conv.copy(blArray), 7, 1);
        this.defaultPersonNames();
        this.defaultItemNames();
    }

    public void enterItemNames(String[] stringArray) {
        int n = stringArray.length;
        this.itemNames = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            this.itemNames[i] = stringArray[i];
        }
        this.itemNames[n] = "total";
        this.originalItemNames = (String[])this.itemNames.clone();
        this.itemNamesSet = true;
    }

    private void defaultItemNames() {
        if (!this.itemNamesSet) {
            this.itemNames = new String[this.nItems + 1];
            for (int i = 0; i < this.nItems; ++i) {
                this.itemNames[i] = "item" + i;
            }
            this.itemNames[this.nItems] = "total";
            this.originalItemNames = (String[])this.itemNames.clone();
        }
    }

    public void enterPersonNames(String[] stringArray) {
        int n = stringArray.length;
        this.personNames = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            this.personNames[i] = stringArray[i];
        }
        this.personNames[n] = "total";
        this.originalPersonNames = (String[])this.personNames.clone();
        this.personNamesSet = true;
    }

    private void defaultPersonNames() {
        if (!this.personNamesSet) {
            this.personNames = new String[this.nPersons + 1];
            for (int i = 0; i < this.nPersons; ++i) {
                this.personNames[i] = "person" + i;
            }
            this.personNames[this.nPersons] = "total";
            this.originalPersonNames = (String[])this.personNames.clone();
        }
    }

    public void letterToNumeral() {
        this.letterToNumeralSet = true;
    }

    public void suspendLetterToNumeral() {
        this.letterToNumeralSet = false;
    }

    public void declareDataDichotomous() {
        this.dichotSet = true;
    }

    public void additionalDichotomousPairs(String string, String string2) {
        this.otherFalse = string;
        this.otherTrue = string2;
        this.otherDichotomousDataSet = true;
    }

    public void otherDichotomousData(String string, String string2) {
        this.otherFalse = string;
        this.otherTrue = string2;
        this.otherDichotomousDataSet = true;
    }

    public void resetDichotomousNoFalse(double d) {
        this.dichotFalse = d;
    }

    public void resetDichotomousYesTrue(double d) {
        this.dichotTrue = d;
    }

    public double getDichotomousNoFalse() {
        return this.dichotFalse;
    }

    public double getDichotomousYesTrue() {
        return this.dichotTrue;
    }

    protected double[] checkWhetherRawItemsDichotomous() {
        if (!this.dichotomousCheckDone) {
            this.dichotomous = new boolean[this.nItems];
            this.dichotomousPercentage = new double[this.nItems];
            int n = 0;
            for (int i = 0; i < this.nItems; ++i) {
                this.dichotomousPercentage[i] = this.checkWhetherDichotomous(this.scores0[i]);
                if (this.dichotomousPercentage[i] != 100.0) continue;
                this.dichotomous[i] = true;
                ++n;
            }
            if (n == this.nItems) {
                this.dichotomousOverall = true;
            }
            this.dichotomousCheckDone = false;
        }
        return this.dichotomousPercentage;
    }

    protected double checkWhetherDichotomous(double[] dArray) {
        int n;
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        boolean[] blArray = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            dArray2[n] = 0.0;
            blArray[n] = false;
        }
        for (n = 0; n < n2; ++n) {
            dArray2[n] = 0.0;
            for (int i = 0; i < n2; ++i) {
                if (dArray[n] != dArray[i] || blArray[i]) continue;
                int n3 = n;
                dArray2[n3] = dArray2[n3] + 1.0;
                blArray[i] = true;
            }
        }
        ArrayMaths arrayMaths = new ArrayMaths(dArray2);
        ArrayMaths arrayMaths2 = arrayMaths.sort();
        double[] dArray3 = arrayMaths2.array();
        double d = (dArray3[n2 - 1] + dArray3[n2 - 2]) * 100.0 / (double)n2;
        return d;
    }

    protected double[][] transpose(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n2][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[j][i] = dArray[i][j];
            }
        }
        return dArray2;
    }

    protected String[][] transpose(String[][] stringArray) {
        int n = stringArray.length;
        int n2 = stringArray[0].length;
        String[][] stringArray2 = new String[n2][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                stringArray2[j][i] = stringArray[i][j];
            }
        }
        return stringArray2;
    }

    protected boolean[][] transpose(boolean[][] blArray) {
        int n = blArray.length;
        int n2 = blArray[0].length;
        boolean[][] blArray2 = new boolean[n2][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                blArray2[j][i] = blArray[i][j];
            }
        }
        return blArray2;
    }

    protected void checkLengths(String[][] stringArray) {
        int n = stringArray.length;
        int n2 = stringArray[0].length;
        for (int i = 1; i < n; ++i) {
            if (stringArray[i].length == n2) continue;
            throw new IllegalArgumentException("The length of each item and of each person's responses must be identical (missing responses must be included - see documentation web page)");
        }
    }

    protected void checkLengths(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 1; i < n; ++i) {
            if (dArray[i].length == n2) continue;
            throw new IllegalArgumentException("The length of each item and of each person's responses must be identical (missing responses must be included - see documentation web page)");
        }
    }

    protected void checkLengths(char[][] cArray) {
        int n = cArray.length;
        int n2 = cArray[0].length;
        for (int i = 1; i < n; ++i) {
            if (cArray[i].length == n2) continue;
            throw new IllegalArgumentException("The length of each item and of each person's responses must be identical (missing responses must be included - see documentation web page)");
        }
    }

    protected void checkLengths(float[][] fArray) {
        int n = fArray.length;
        int n2 = fArray[0].length;
        for (int i = 1; i < n; ++i) {
            if (fArray[i].length == n2) continue;
            throw new IllegalArgumentException("The length of each item and of each person's responses must be identical (missing responses must be included - see documentation web page)");
        }
    }

    protected void checkLengths(int[][] nArray) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        for (int i = 1; i < n; ++i) {
            if (nArray[i].length == n2) continue;
            throw new IllegalArgumentException("The length of each item and of each person's responses must be identical (missing responses must be included - see documentation web page)");
        }
    }

    protected void checkLengths(boolean[][] blArray) {
        int n = blArray.length;
        int n2 = blArray[0].length;
        for (int i = 1; i < n; ++i) {
            if (blArray[i].length == n2) continue;
            throw new IllegalArgumentException("The length of each item and of each person's responses must be identical (missing responses must be included - see documentation web page)");
        }
    }

    protected void trimScores(String[][] stringArray) {
        int n = stringArray.length;
        int n2 = stringArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                stringArray[i][j].trim();
            }
        }
    }

    public void preprocessData() {
        if (!this.dataPreprocessed) {
            int n;
            int n2;
            int n3;
            int n4;
            if (!this.dataEntered) {
                throw new IllegalArgumentException("No data has been entered");
            }
            this.scores0 = new double[this.nItems][this.nPersons];
            this.originalScores0 = new double[this.nItems][this.nPersons];
            this.scores1 = new double[this.nPersons][this.nItems];
            this.originalScores1 = new double[this.nPersons][this.nItems];
            this.deletedPersons = new boolean[this.nPersons];
            this.deletedItems = new boolean[this.nItems];
            this.personIndices = new int[this.nPersons];
            for (n4 = 0; n4 < this.nPersons; ++n4) {
                this.personIndices[n4] = n4;
            }
            this.itemIndices = new int[this.nItems];
            for (n4 = 0; n4 < this.nItems; ++n4) {
                this.itemIndices[n4] = n4;
            }
            this.nNaN = 0;
            this.nDeletedPersons = 0;
            this.nDeletedItems = 0;
            String[][] stringArray = null;
            double[][] dArray = null;
            boolean[][] blArray = null;
            int n5 = 0;
            int n6 = 0;
            switch (this.originalDataType) {
                case 1: {
                    stringArray = (String[][])this.originalData;
                    this.checkLengths(stringArray);
                    if (this.originalDataOrder == 1) {
                        stringArray = this.transpose(stringArray);
                    }
                    this.trimScores(stringArray);
                    break;
                }
                case 2: {
                    dArray = (double[][])this.originalData;
                    this.checkLengths(dArray);
                    if (this.originalDataOrder == 1) {
                        dArray = this.transpose(dArray);
                    }
                    stringArray = this.dataToString(dArray);
                    break;
                }
                case 3: {
                    dArray = ((Matrix)this.originalData).getArrayCopy();
                    this.checkLengths(dArray);
                    if (this.originalDataOrder == 1) {
                        dArray = this.transpose(dArray);
                    }
                    stringArray = this.dataToString(dArray);
                    break;
                }
                case 4: {
                    float[][] fArray = (float[][])this.originalData;
                    this.checkLengths(fArray);
                    n5 = fArray.length;
                    n6 = fArray[0].length;
                    for (n3 = 0; n3 < n5; ++n3) {
                        for (int i = 0; i < n6; ++i) {
                            dArray[n3][i] = new Float(fArray[n3][i]).doubleValue();
                        }
                    }
                    if (this.originalDataOrder == 1) {
                        dArray = this.transpose(dArray);
                    }
                    stringArray = this.dataToString(dArray);
                    break;
                }
                case 5: {
                    int[][] nArray = (int[][])this.originalData;
                    this.checkLengths(nArray);
                    n5 = nArray.length;
                    n6 = nArray[0].length;
                    for (int i = 0; i < n5; ++i) {
                        for (n2 = 0; n2 < n6; ++n2) {
                            dArray[i][n2] = new Integer(nArray[i][n2]).doubleValue();
                        }
                    }
                    if (this.originalDataOrder == 1) {
                        dArray = this.transpose(dArray);
                    }
                    stringArray = this.dataToString(dArray);
                    break;
                }
                case 6: {
                    char[][] cArray = (char[][])this.originalData;
                    this.checkLengths(cArray);
                    n5 = cArray.length;
                    n6 = cArray[0].length;
                    stringArray = new String[n5][n6];
                    for (n2 = 0; n2 < n5; ++n2) {
                        for (int i = 0; i < n6; ++i) {
                            stringArray[n2][i] = Character.toString(cArray[n2][i]);
                        }
                    }
                    if (this.originalDataOrder == 1) {
                        stringArray = this.transpose(stringArray);
                    }
                    this.trimScores(stringArray);
                    break;
                }
                case 7: {
                    blArray = (boolean[][])this.originalData;
                    this.checkLengths(blArray);
                    if (this.originalDataOrder == 1) {
                        blArray = this.transpose(blArray);
                    }
                    stringArray = this.dataToString(blArray);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Original data type, " + this.originalDataType + ", not recognised");
                }
            }
            if (this.letterToNumeralSet) {
                for (int i = 0; i < this.nItems; ++i) {
                    int n7;
                    n3 = 0;
                    for (n7 = 0; n7 < this.nPersons; ++n7) {
                        n2 = stringArray[i][n7].charAt(0);
                        if (n2 != 121 && n2 != 110 && n2 != 89 && n2 != 78 && n2 != 32 || stringArray[i][n7].length() != 1) continue;
                        ++n3;
                    }
                    if (n3 != this.nPersons) continue;
                    for (n7 = 0; n7 < this.nPersons; ++n7) {
                        n2 = stringArray[i][n7].charAt(0);
                        if ((n2 == 121 || n2 == 89) && stringArray[i][n7].length() == 1) {
                            stringArray[i][n7] = String.valueOf(this.dichotTrue);
                            continue;
                        }
                        if (n2 != 110 && n2 != 78 || stringArray[i][n7].length() != 1) continue;
                        stringArray[i][n7] = String.valueOf(this.dichotFalse);
                    }
                }
            }
            if (this.letterToNumeralSet) {
                for (int i = 0; i < this.nItems; ++i) {
                    for (n3 = 0; n3 < this.nPersons; ++n3) {
                        char c = stringArray[i][n3].charAt(0);
                        if (c > '@' && c < '[' && stringArray[i][n3].length() == 1) {
                            stringArray[i][n3] = "" + (c - 63);
                            continue;
                        }
                        if (c <= '`' || c >= '{' || stringArray[i][n3].length() != 1) continue;
                        stringArray[i][n3] = "" + (c - 96);
                    }
                }
                this.letterToNumeralSet = false;
            }
            switch (this.originalDataType) {
                case 1: 
                case 6: {
                    for (int i = 0; i < this.nItems; ++i) {
                        for (n3 = 0; n3 < this.nPersons; ++n3) {
                            boolean bl = false;
                            if (this.otherDichotomousDataSet) {
                                if (stringArray[i][n3].equalsIgnoreCase(this.otherTrue)) {
                                    this.scores0[i][n3] = this.dichotTrue;
                                    bl = true;
                                } else if (stringArray[i][n3].equalsIgnoreCase(this.otherFalse)) {
                                    this.scores0[i][n3] = this.dichotFalse;
                                    bl = true;
                                } else {
                                    this.scores0[i][n3] = Double.NaN;
                                    bl = true;
                                }
                            }
                            if (!bl) {
                                if (stringArray[i][n3].equalsIgnoreCase("yes") || stringArray[i][n3].equalsIgnoreCase("y") || stringArray[i][n3].equalsIgnoreCase("true")) {
                                    this.scores0[i][n3] = this.dichotTrue;
                                    bl = true;
                                } else if (stringArray[i][n3].equalsIgnoreCase("no") || stringArray[i][n3].equalsIgnoreCase("n") || stringArray[i][n3].equalsIgnoreCase("false")) {
                                    this.scores0[i][n3] = this.dichotFalse;
                                    bl = true;
                                }
                            }
                            if (bl) continue;
                            try {
                                this.scores0[i][n3] = Double.valueOf(stringArray[i][n3]);
                                continue;
                            }
                            catch (Exception exception) {
                                this.scores0[i][n3] = Double.NaN;
                                ++this.nNaN;
                            }
                        }
                    }
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    for (int i = 0; i < this.nItems; ++i) {
                        for (n3 = 0; n3 < this.nPersons; ++n3) {
                            try {
                                this.scores0[i][n3] = dArray[i][n3];
                                continue;
                            }
                            catch (Exception exception) {
                                this.scores0[i][n3] = Double.NaN;
                                ++this.nNaN;
                            }
                        }
                    }
                    break;
                }
                case 7: {
                    for (int i = 0; i < this.nItems; ++i) {
                        for (n3 = 0; n3 < this.nPersons; ++n3) {
                            this.scores0[i][n3] = blArray[i][n3] ? this.dichotTrue : this.dichotFalse;
                        }
                    }
                    break;
                }
            }
            int n8 = 0;
            n3 = 0;
            for (n = 0; n < this.nItems; ++n) {
                for (int i = 0; i < this.nPersons; ++i) {
                    n3 = Fmath.checkPrecision(this.scores0[n][i]);
                    if (n3 <= n8) continue;
                    n8 = n3;
                }
            }
            if (n8 > this.trunc && !this.truncAll) {
                this.trunc = n8;
            }
            this.originalScores0 = Conv.copy(this.scores0);
            this.originalScores1 = this.transpose(this.scores0);
            this.originalNitems = this.nItems;
            this.originalNpersons = this.nPersons;
            this.originalNscores = this.originalNitems * this.originalNpersons;
            if (this.dichotSet) {
                this.frequencyCount();
            }
            if (this.nNaN > 0) {
                this.noResponseHandling();
                this.scores1 = this.transpose(this.scores0);
            }
            this.scores1 = new double[this.nPersons][this.nItems];
            for (n = 0; n < this.nItems; ++n) {
                for (int i = 0; i < this.nPersons; ++i) {
                    this.scores1[i][n] = this.scores0[n][i];
                }
            }
            this.checkWhetherRawItemsDichotomous();
            this.standardizedScores0 = new double[this.nItems][this.nPersons];
            this.standardizedScores1 = new double[this.nPersons][this.nItems];
            for (n = 0; n < this.nItems; ++n) {
                Stat stat = new Stat(this.scores0[n]);
                this.standardizedScores0[n] = stat.standardize();
            }
            this.standardizedScores1 = this.transpose(this.standardizedScores0);
            this.checkForIdenticalElements();
            this.meansAndVariances();
            this.covariancesAndCorrelationCoefficients();
            this.dataPreprocessed = true;
        }
    }

    private void checkForIdenticalElements() {
        int n;
        double d;
        int n2;
        int n3;
        boolean bl = false;
        for (n3 = 0; n3 < this.nItems; ++n3) {
            n2 = 0;
            d = this.scores0[n3][0];
            for (n = 0; n < this.nPersons; ++n) {
                if (this.scores0[n3][n] != d) continue;
                ++n2;
            }
            if (n2 != this.nPersons) continue;
            this.sameCheck = 1;
            bl = true;
        }
        for (n3 = 0; n3 < this.nPersons; ++n3) {
            n2 = 0;
            d = this.scores0[0][n3];
            for (n = 0; n < this.nItems; ++n) {
                if (this.scores0[n][n3] != d) continue;
                ++n2;
            }
            if (n2 != this.nItems) continue;
            this.sameCheck = 2;
            if (!bl) continue;
            this.sameCheck = 3;
        }
    }

    private String[][] dataToString(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        String[][] stringArray = new String[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                stringArray[i][j] = new Double(dArray[i][j]).toString();
            }
        }
        return stringArray;
    }

    private String[][] dataToString(boolean[][] blArray) {
        int n = blArray.length;
        int n2 = blArray[0].length;
        String[][] stringArray = new String[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                stringArray[i][j] = new Boolean(blArray[i][j]).toString();
            }
        }
        return stringArray;
    }

    public Object originalResponses() {
        return this.originalScores();
    }

    public Object originalScores() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("No data has been entered");
        }
        return this.originalData;
    }

    public double[][] originalResponsesAsRowPerPerson() {
        return this.originalScoresAsRowPerPerson();
    }

    public double[][] originalScoresAsRowPerPerson() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.originalScores1;
    }

    public double[][] originalResponsesAsRowPerItem() {
        return this.originalScoresAsRowPerItem();
    }

    public double[][] originalScoresAsRowPerItem() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.originalScores0;
    }

    public double[][] usedresponsesAsRowPerPerson() {
        return this.usedScoresAsRowPerPerson();
    }

    public double[][] usedScoresAsRowPerPerson() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.scores1;
    }

    public double[][] usedScoresAsRowPerItem() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.scores0;
    }

    public double[][] standardizedScoresAsRowPerPerson() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.standardizedScores1;
    }

    public double[][] standardisedScoresAsRowPerPerson() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.standardizedScores1;
    }

    public double[][] standardizedScoresAsRowPerItem() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.standardizedScores0;
    }

    public double[][] standardisedScoresAsRowPerItem() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.standardizedScores0;
    }

    public int originalNumberOfItems() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.originalNitems;
    }

    public int originalNumberOfPersons() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.originalNpersons;
    }

    public int usedNumberOfItems() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.nItems;
    }

    public int usedNumberOfPersons() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.nPersons;
    }

    public int originalTotalNumberOfScores() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.originalNscores;
    }

    public int usedTotalNumberOfScores() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.nScores;
    }

    public int numberOfDeletedScores() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.originalNscores - this.nScores;
    }

    public int numberOfReplacedScores() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.nReplacements;
    }

    public String[] indicesOfReplacedScores() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.replacementIndices;
    }

    public String[] personNames() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("no data has been entered");
        }
        String[] stringArray = new String[this.nPersons];
        for (int i = 0; i < this.nPersons; ++i) {
            stringArray[i] = this.personNames[i];
        }
        return stringArray;
    }

    public String[] originalPersonNames() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("no data has been entered");
        }
        String[] stringArray = new String[this.originalNpersons];
        for (int i = 0; i < this.originalNpersons; ++i) {
            stringArray[i] = this.originalPersonNames[i];
        }
        return stringArray;
    }

    public String[] itemNames() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("no data has been entered");
        }
        String[] stringArray = new String[this.nItems];
        for (int i = 0; i < this.nItems; ++i) {
            stringArray[i] = this.itemNames[i];
        }
        return stringArray;
    }

    public String[] originalItemNames() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("no data has been entered");
        }
        String[] stringArray = new String[this.originalNitems];
        for (int i = 0; i < this.originalNitems; ++i) {
            stringArray[i] = this.originalItemNames[i];
        }
        return stringArray;
    }

    public int itemIndex(String string) {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("no data has been entered");
        }
        int n = -1;
        int n2 = 0;
        boolean bl = true;
        while (bl) {
            if (string.trim().equalsIgnoreCase(this.itemNames[n2].trim())) {
                n = n2;
                bl = false;
                continue;
            }
            if (++n2 <= this.nItems) continue;
            throw new IllegalArgumentException("Item name, " + string + ", is not present in the list of entered item names");
        }
        return n + 1;
    }

    public String itemName(int n) {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("no data has been entered");
        }
        return this.itemNames[n - 1];
    }

    protected void meansAndVariances() {
        ArrayMaths arrayMaths;
        ArrayMaths arrayMaths2;
        this.rawItemMeans = new double[this.nItems];
        this.rawItemMedians = new double[this.nItems];
        this.rawItemStandardDeviations = new double[this.nItems];
        this.rawItemVariances = new double[this.nItems];
        this.rawItemMinima = new double[this.nItems];
        this.rawItemMaxima = new double[this.nItems];
        this.rawItemRanges = new double[this.nItems];
        this.rawItemTotals = new double[this.nItems];
        this.rawItemMomentSkewness = new double[this.nItems];
        this.rawItemMedianSkewness = new double[this.nItems];
        this.rawItemQuartileSkewness = new double[this.nItems];
        this.rawItemKurtosisExcess = new double[this.nItems];
        for (int i = 0; i < this.nItems; ++i) {
            Stat stat = new Stat(this.scores0[i]);
            if (this.nFactorOption) {
                stat.setDenominatorToN();
            } else {
                stat.setDenominatorToNminusOne();
            }
            this.rawItemMeans[i] = stat.mean_as_double();
            this.rawItemVariances[i] = stat.variance_as_double();
            this.rawItemStandardDeviations[i] = Math.sqrt(this.rawItemVariances[i]);
            this.rawItemMinima[i] = stat.minimum_as_double();
            this.rawItemMaxima[i] = stat.maximum_as_double();
            this.rawItemRanges[i] = this.rawItemMaxima[i] - this.rawItemMinima[i];
            this.rawItemTotals[i] = stat.sum_as_double();
            arrayMaths2 = stat.sort();
            arrayMaths = new Stat(arrayMaths2.array());
            this.rawItemMedians[i] = ((Stat)arrayMaths).median_as_double();
            this.rawItemMomentSkewness[i] = stat.momentSkewness_as_double();
            this.rawItemMedianSkewness[i] = stat.medianSkewness_as_double();
            this.rawItemQuartileSkewness[i] = stat.quartileSkewness_as_double();
            this.rawItemKurtosisExcess[i] = stat.kurtosisExcess_as_double();
        }
        Stat stat = new Stat(this.rawItemMeans);
        if (this.nFactorOption) {
            stat.setDenominatorToN();
        } else {
            stat.setDenominatorToNminusOne();
        }
        this.rawItemMeansMean = stat.mean_as_double();
        this.rawItemMeansVar = stat.variance_as_double();
        this.rawItemMeansSd = Math.sqrt(this.rawItemMeansVar);
        this.rawItemMeansMin = stat.minimum_as_double();
        this.rawItemMeansMax = stat.maximum_as_double();
        this.rawItemMeansRange = this.rawItemMeansMax - this.rawItemMeansMin;
        stat = new Stat(this.rawItemStandardDeviations);
        if (this.nFactorOption) {
            stat.setDenominatorToN();
        } else {
            stat.setDenominatorToNminusOne();
        }
        this.rawItemStandardDeviationsMean = stat.mean_as_double();
        this.rawItemStandardDeviationsVar = stat.variance_as_double();
        this.rawItemStandardDeviationsSd = Math.sqrt(this.rawItemStandardDeviationsVar);
        this.rawItemStandardDeviationsMin = stat.minimum_as_double();
        this.rawItemStandardDeviationsMax = stat.maximum_as_double();
        this.rawItemStandardDeviationsRange = this.rawItemStandardDeviationsMax - this.rawItemStandardDeviationsMin;
        stat = new Stat(this.rawItemVariances);
        if (this.nFactorOption) {
            stat.setDenominatorToN();
        } else {
            stat.setDenominatorToNminusOne();
        }
        this.rawItemVariancesMean = stat.mean_as_double();
        this.rawItemVariancesVar = stat.variance_as_double();
        this.rawItemVariancesSd = Math.sqrt(this.rawItemVariancesVar);
        this.rawItemVariancesMin = stat.minimum_as_double();
        this.rawItemVariancesMax = stat.maximum_as_double();
        this.rawItemVariancesRange = this.rawItemVariancesMax - this.rawItemVariancesMin;
        stat = new Stat(this.rawItemMinima);
        if (this.nFactorOption) {
            stat.setDenominatorToN();
        } else {
            stat.setDenominatorToNminusOne();
        }
        this.rawItemMinimaMean = stat.mean_as_double();
        this.rawItemMinimaVar = stat.variance_as_double();
        this.rawItemMinimaSd = Math.sqrt(this.rawItemMinimaVar);
        this.rawItemMinimaMin = stat.minimum_as_double();
        this.rawItemMinimaMax = stat.maximum_as_double();
        this.rawItemMinimaRange = this.rawItemMinimaMax - this.rawItemMinimaMin;
        stat = new Stat(this.rawItemMaxima);
        if (this.nFactorOption) {
            stat.setDenominatorToN();
        } else {
            stat.setDenominatorToNminusOne();
        }
        this.rawItemMaximaMean = stat.mean_as_double();
        this.rawItemMaximaVar = stat.variance_as_double();
        this.rawItemMaximaSd = Math.sqrt(this.rawItemMaximaVar);
        this.rawItemMaximaMin = stat.minimum_as_double();
        this.rawItemMaximaMax = stat.maximum_as_double();
        this.rawItemMaximaRange = this.rawItemMaximaMax - this.rawItemMaximaMin;
        stat = new Stat(this.rawItemRanges);
        if (this.nFactorOption) {
            stat.setDenominatorToN();
        } else {
            stat.setDenominatorToNminusOne();
        }
        this.rawItemRangesMean = stat.mean_as_double();
        this.rawItemRangesVar = stat.variance_as_double();
        this.rawItemRangesSd = Math.sqrt(this.rawItemRangesVar);
        this.rawItemRangesMin = stat.minimum_as_double();
        this.rawItemRangesMax = stat.maximum_as_double();
        this.rawItemRangesRange = this.rawItemRangesMax - this.rawItemRangesMin;
        stat = new Stat(this.rawItemTotals);
        if (this.nFactorOption) {
            stat.setDenominatorToN();
        } else {
            stat.setDenominatorToNminusOne();
        }
        this.rawItemTotalsMean = stat.mean_as_double();
        this.rawItemTotalsVar = stat.variance_as_double();
        this.rawItemTotalsSd = Math.sqrt(this.rawItemTotalsVar);
        this.rawItemTotalsMin = stat.minimum_as_double();
        this.rawItemTotalsMax = stat.maximum_as_double();
        this.rawItemTotalsRange = this.rawItemTotalsMax - this.rawItemTotalsMin;
        stat = new Stat(this.rawItemMedians);
        if (this.nFactorOption) {
            stat.setDenominatorToN();
        } else {
            stat.setDenominatorToNminusOne();
        }
        this.rawItemMediansMean = stat.mean_as_double();
        this.rawItemMediansVar = stat.variance_as_double();
        this.rawItemMediansSd = Math.sqrt(this.rawItemMediansVar);
        this.rawItemMediansMin = stat.minimum_as_double();
        this.rawItemMediansMax = stat.maximum_as_double();
        this.rawItemMediansRange = this.rawItemMediansMax - this.rawItemMediansMin;
        this.standardizedItemMeans = new double[this.nItems];
        this.standardizedItemMedians = new double[this.nItems];
        this.standardizedItemStandardDeviations = new double[this.nItems];
        this.standardizedItemVariances = new double[this.nItems];
        this.standardizedItemMinima = new double[this.nItems];
        this.standardizedItemMaxima = new double[this.nItems];
        this.standardizedItemRanges = new double[this.nItems];
        this.standardizedItemTotals = new double[this.nItems];
        this.standardizedItemMomentSkewness = new double[this.nItems];
        this.standardizedItemMedianSkewness = new double[this.nItems];
        this.standardizedItemQuartileSkewness = new double[this.nItems];
        this.standardizedItemKurtosisExcess = new double[this.nItems];
        for (int i = 0; i < this.nItems; ++i) {
            arrayMaths2 = new Stat(this.standardizedScores0[i]);
            if (this.nFactorOption) {
                ((Stat)arrayMaths2).setDenominatorToN();
            } else {
                ((Stat)arrayMaths2).setDenominatorToNminusOne();
            }
            this.standardizedItemMeans[i] = 0.0;
            this.standardizedItemVariances[i] = 1.0;
            this.standardizedItemStandardDeviations[i] = 1.0;
            this.standardizedItemMinima[i] = arrayMaths2.minimum_as_double();
            this.standardizedItemMaxima[i] = arrayMaths2.maximum_as_double();
            this.standardizedItemRanges[i] = this.standardizedItemMaxima[i] - this.standardizedItemMinima[i];
            this.standardizedItemTotals[i] = 0.0;
            arrayMaths = arrayMaths2.sort();
            Stat stat2 = new Stat(arrayMaths.array());
            this.standardizedItemMedians[i] = stat2.median_as_double();
            this.standardizedItemMomentSkewness[i] = ((Stat)arrayMaths2).momentSkewness_as_double();
            this.standardizedItemMedianSkewness[i] = ((Stat)arrayMaths2).medianSkewness_as_double();
            this.standardizedItemQuartileSkewness[i] = ((Stat)arrayMaths2).quartileSkewness_as_double();
            this.standardizedItemKurtosisExcess[i] = ((Stat)arrayMaths2).kurtosisExcess_as_double();
        }
        stat = new Stat(this.standardizedItemMeans);
        if (this.nFactorOption) {
            stat.setDenominatorToN();
        } else {
            stat.setDenominatorToNminusOne();
        }
        this.standardizedItemMeansMean = stat.mean_as_double();
        this.standardizedItemMeansVar = stat.variance_as_double();
        this.standardizedItemMeansSd = Math.sqrt(this.standardizedItemMeansVar);
        this.standardizedItemMeansMin = stat.minimum_as_double();
        this.standardizedItemMeansMax = stat.maximum_as_double();
        this.standardizedItemMeansRange = this.standardizedItemMeansMax - this.standardizedItemMeansMin;
        stat = new Stat(this.standardizedItemStandardDeviations);
        if (this.nFactorOption) {
            stat.setDenominatorToN();
        } else {
            stat.setDenominatorToNminusOne();
        }
        this.standardizedItemStandardDeviationsMean = stat.mean_as_double();
        this.standardizedItemStandardDeviationsVar = stat.variance_as_double();
        this.standardizedItemStandardDeviationsSd = Math.sqrt(this.standardizedItemStandardDeviationsVar);
        this.standardizedItemStandardDeviationsMin = stat.minimum_as_double();
        this.standardizedItemStandardDeviationsMax = stat.maximum_as_double();
        this.standardizedItemStandardDeviationsRange = this.standardizedItemStandardDeviationsMax - this.standardizedItemStandardDeviationsMin;
        stat = new Stat(this.standardizedItemVariances);
        if (this.nFactorOption) {
            stat.setDenominatorToN();
        } else {
            stat.setDenominatorToNminusOne();
        }
        this.standardizedItemVariancesMean = stat.mean_as_double();
        this.standardizedItemVariancesVar = stat.variance_as_double();
        this.standardizedItemVariancesSd = Math.sqrt(this.standardizedItemVariancesVar);
        this.standardizedItemVariancesMin = stat.minimum_as_double();
        this.standardizedItemVariancesMax = stat.maximum_as_double();
        this.standardizedItemVariancesRange = this.standardizedItemVariancesMax - this.standardizedItemVariancesMin;
        stat = new Stat(this.standardizedItemMinima);
        if (this.nFactorOption) {
            stat.setDenominatorToN();
        } else {
            stat.setDenominatorToNminusOne();
        }
        this.standardizedItemMinimaMean = stat.mean_as_double();
        this.standardizedItemMinimaVar = stat.variance_as_double();
        this.standardizedItemMinimaSd = Math.sqrt(this.standardizedItemMinimaVar);
        this.standardizedItemMinimaMin = stat.minimum_as_double();
        this.standardizedItemMinimaMax = stat.maximum_as_double();
        this.standardizedItemMinimaRange = this.standardizedItemMinimaMax - this.standardizedItemMinimaMin;
        stat = new Stat(this.standardizedItemMaxima);
        if (this.nFactorOption) {
            stat.setDenominatorToN();
        } else {
            stat.setDenominatorToNminusOne();
        }
        this.standardizedItemMaximaMean = stat.mean_as_double();
        this.standardizedItemMaximaVar = stat.variance_as_double();
        this.standardizedItemMaximaSd = Math.sqrt(this.standardizedItemMaximaVar);
        this.standardizedItemMaximaMin = stat.minimum_as_double();
        this.standardizedItemMaximaMax = stat.maximum_as_double();
        this.standardizedItemMaximaRange = this.standardizedItemMaximaMax - this.standardizedItemMaximaMin;
        stat = new Stat(this.standardizedItemRanges);
        if (this.nFactorOption) {
            stat.setDenominatorToN();
        } else {
            stat.setDenominatorToNminusOne();
        }
        this.standardizedItemRangesMean = stat.mean_as_double();
        this.standardizedItemRangesVar = stat.variance_as_double();
        this.standardizedItemRangesSd = Math.sqrt(this.standardizedItemRangesVar);
        this.standardizedItemRangesMin = stat.minimum_as_double();
        this.standardizedItemRangesMax = stat.maximum_as_double();
        this.standardizedItemRangesRange = this.standardizedItemRangesMax - this.standardizedItemRangesMin;
        this.standardizedItemTotalsMean = 0.0;
        this.standardizedItemTotalsVar = 0.0;
        this.standardizedItemTotalsSd = 0.0;
        this.standardizedItemTotalsMin = 0.0;
        this.standardizedItemTotalsMax = 0.0;
        this.standardizedItemTotalsRange = 0.0;
        stat = new Stat(this.standardizedItemMedians);
        if (this.nFactorOption) {
            stat.setDenominatorToN();
        } else {
            stat.setDenominatorToNminusOne();
        }
        this.standardizedItemMediansMean = stat.mean_as_double();
        this.standardizedItemMediansVar = stat.variance_as_double();
        this.standardizedItemMediansSd = Math.sqrt(this.standardizedItemMediansVar);
        this.standardizedItemMediansMin = stat.minimum_as_double();
        this.standardizedItemMediansMax = stat.maximum_as_double();
        this.standardizedItemMediansRange = this.standardizedItemMediansMax - this.standardizedItemMediansMin;
        this.rawPersonMeans = new double[this.nPersons];
        this.rawPersonStandardDeviations = new double[this.nPersons];
        this.rawPersonVariances = new double[this.nPersons];
        this.rawPersonMinima = new double[this.nPersons];
        this.rawPersonMaxima = new double[this.nPersons];
        this.rawPersonRanges = new double[this.nPersons];
        this.rawPersonTotals = new double[this.nPersons];
        Stat[] statArray = new Stat[this.nPersons];
        for (int i = 0; i < this.nPersons; ++i) {
            statArray[i] = new Stat(this.scores1[i]);
            if (this.nFactorOption) {
                statArray[i].setDenominatorToN();
            } else {
                statArray[i].setDenominatorToNminusOne();
            }
            this.rawPersonMeans[i] = statArray[i].mean_as_double();
            this.rawPersonVariances[i] = statArray[i].variance_as_double();
            this.rawPersonStandardDeviations[i] = Math.sqrt(this.rawPersonVariances[i]);
            this.rawPersonMinima[i] = statArray[i].minimum_as_double();
            this.rawPersonMaxima[i] = statArray[i].maximum_as_double();
            this.rawPersonRanges[i] = this.rawPersonMaxima[i] - this.rawPersonMinima[i];
            this.rawPersonTotals[i] = statArray[i].sum_as_double();
        }
        this.standardizedPersonMeans = new double[this.nPersons];
        this.standardizedPersonStandardDeviations = new double[this.nPersons];
        this.standardizedPersonVariances = new double[this.nPersons];
        this.standardizedPersonMinima = new double[this.nPersons];
        this.standardizedPersonMaxima = new double[this.nPersons];
        this.standardizedPersonRanges = new double[this.nPersons];
        this.standardizedPersonTotals = new double[this.nPersons];
        Stat[] statArray2 = new Stat[this.nPersons];
        for (int i = 0; i < this.nPersons; ++i) {
            statArray2[i] = new Stat(this.standardizedScores1[i]);
            if (this.nFactorOption) {
                statArray2[i].setDenominatorToN();
            } else {
                statArray2[i].setDenominatorToNminusOne();
            }
            this.standardizedPersonMeans[i] = statArray2[i].mean_as_double();
            this.standardizedPersonVariances[i] = statArray2[i].variance_as_double();
            this.standardizedPersonStandardDeviations[i] = Math.sqrt(this.standardizedPersonVariances[i]);
            this.standardizedPersonMinima[i] = statArray2[i].minimum_as_double();
            this.standardizedPersonMaxima[i] = statArray2[i].maximum_as_double();
            this.standardizedPersonRanges[i] = this.standardizedPersonMaxima[i] - this.standardizedPersonMinima[i];
            this.standardizedPersonTotals[i] = statArray2[i].sum_as_double();
        }
        ArrayMaths arrayMaths3 = new ArrayMaths(this.scores0[0]);
        for (int i = 1; i < this.nItems; ++i) {
            arrayMaths3 = arrayMaths3.concatenate(this.scores0[i]);
        }
        Stat stat3 = new Stat(arrayMaths3.array());
        if (this.nFactorOption) {
            stat3.setDenominatorToN();
        } else {
            stat3.setDenominatorToNminusOne();
        }
        this.rawAllResponsesMean = stat3.mean_as_double();
        this.rawAllResponsesVariance = stat3.variance_as_double();
        this.rawAllResponsesStandardDeviation = Math.sqrt(this.rawAllResponsesVariance);
        this.rawAllResponsesMinimum = stat3.minimum_as_double();
        this.rawAllResponsesMaximum = stat3.maximum_as_double();
        this.rawAllResponsesRange = this.rawAllResponsesMaximum - this.rawAllResponsesMinimum;
        this.rawAllResponsesTotal = stat3.sum_as_double();
        ArrayMaths arrayMaths4 = new ArrayMaths(this.standardizedScores0[0]);
        for (int i = 1; i < this.nItems; ++i) {
            arrayMaths4 = arrayMaths4.concatenate(this.standardizedScores0[i]);
        }
        Stat stat4 = new Stat(arrayMaths4.array());
        if (this.nFactorOption) {
            stat4.setDenominatorToN();
        } else {
            stat4.setDenominatorToNminusOne();
        }
        this.standardizedAllResponsesMean = stat4.mean_as_double();
        this.standardizedAllResponsesVariance = stat4.variance_as_double();
        this.standardizedAllResponsesStandardDeviation = Math.sqrt(this.standardizedAllResponsesVariance);
        this.standardizedAllResponsesMinimum = stat4.minimum_as_double();
        this.standardizedAllResponsesMaximum = stat4.maximum_as_double();
        this.standardizedAllResponsesRange = this.standardizedAllResponsesMaximum - this.standardizedAllResponsesMinimum;
        this.standardizedAllResponsesTotal = 0.0;
        this.variancesCalculated = true;
    }

    public double[] rawItemMeans() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMeans;
    }

    public double[] standardizedItemMeans() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMeans;
    }

    public double[] standardisedItemMeans() {
        return this.standardizedItemMeans();
    }

    public double rawItemMean(String string) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int n = this.itemIndex(string);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMeans[n - 1];
    }

    public double rawItemMean(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The item index, " + n + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMeans[n - 1];
    }

    public double rawMeanOfItemMeans() {
        return this.rawItemMeansMean;
    }

    public double rawStandardDeviationOfItemMeans() {
        return this.rawItemMeansSd;
    }

    public double rawVarianceOfItemMeans() {
        return this.rawItemMeansVar;
    }

    public double rawMaximumOfItemMeans() {
        return this.rawItemMeansMax;
    }

    public double rawMinimumOfItemMeans() {
        return this.rawItemMeansMin;
    }

    public double rawRangeOfItemMeans() {
        return this.rawItemMeansRange;
    }

    public double standardizedItemMean(String string) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int n = this.itemIndex(string);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMeans[n - 1];
    }

    public double standardisedItemMean(String string) {
        return this.standardizedItemMean(string);
    }

    public double standardizedItemMean(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The item index, " + n + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMeans[n - 1];
    }

    public double standardisedItemMean(int n) {
        return this.standardizedItemMean(n);
    }

    public double standardizedMeanOfItemMeans() {
        return this.standardizedItemMeansMean;
    }

    public double standardisedMeanOfItemMeans() {
        return this.standardizedItemMeansMean;
    }

    public double standardizedStanadarDeviationOfItemMeans() {
        return this.standardizedItemMeansSd;
    }

    public double standardisedStanadarDeviationOfItemMeans() {
        return this.standardizedItemMeansSd;
    }

    public double standardizedVarianceOfItemMeans() {
        return this.standardizedItemMeansVar;
    }

    public double standardizedMaximumOfItemMeans() {
        return this.standardizedItemMeansMax;
    }

    public double standardisedVarianceOfItemMeans() {
        return this.standardizedItemMeansVar;
    }

    public double standardizedMinimumOfItemMeans() {
        return this.standardizedItemMeansMin;
    }

    public double standardisedMinimumOfItemMeans() {
        return this.standardizedItemMeansMin;
    }

    public double standardizedRangeOfItemMeans() {
        return this.standardizedItemMeansRange;
    }

    public double standardisedRangeOfItemMeans() {
        return this.standardizedItemMeansRange;
    }

    public double[] rawItemStandardDeviations() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemStandardDeviations;
    }

    public double rawItemStandardDeviation(String string) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int n = this.itemIndex(string);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemStandardDeviations[n - 1];
    }

    public double rawItemStandardDeviation(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The item index, " + n + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemStandardDeviations[n - 1];
    }

    public double rawMeanOfItemStandardDeviations() {
        return this.rawItemStandardDeviationsMean;
    }

    public double rawStanadarDeviationOfItemStandardDeviations() {
        return this.rawItemStandardDeviationsSd;
    }

    public double rawVarianceOfItemStandardDeviations() {
        return this.rawItemStandardDeviationsVar;
    }

    public double rawMaximumOfItemStandardDeviations() {
        return this.rawItemStandardDeviationsMax;
    }

    public double rawMinimumOfItemStandardDeviations() {
        return this.rawItemStandardDeviationsMin;
    }

    public double rawRangeOfItemStandardDeviations() {
        return this.rawItemStandardDeviationsRange;
    }

    public double[] standardizedItemStandardDeviations() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemStandardDeviations;
    }

    public double[] standardisedItemStandardDeviations() {
        return this.standardizedItemStandardDeviations();
    }

    public double standardizedItemStandardDeviation(String string) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int n = this.itemIndex(string);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemStandardDeviations[n - 1];
    }

    public double standardisedItemStandardDeviation(String string) {
        return this.standardizedItemStandardDeviation(string);
    }

    public double standardizedItemStandardDeviation(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The item index, " + n + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemStandardDeviations[n - 1];
    }

    public double standardisedItemStandardDeviation(int n) {
        return this.standardizedItemStandardDeviation(n);
    }

    public double standardizedMeanOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsMean;
    }

    public double standardisedMeanOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsMean;
    }

    public double standardizedStanadarDeviationOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsSd;
    }

    public double standardisedStanadarDeviationOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsSd;
    }

    public double standardizedVarianceOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsVar;
    }

    public double standardisedVarianceOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsVar;
    }

    public double standardizedMaximumOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsMax;
    }

    public double standardisedMaximumOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsMax;
    }

    public double standardizedMinimumOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsMin;
    }

    public double standardisedMinimumOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsMin;
    }

    public double standardizedRangeOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsRange;
    }

    public double standardisedRangeOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsRange;
    }

    public double[] rawItemVariances() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemVariances;
    }

    public double[] standardizedItemVariances() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemVariances;
    }

    public double[] standardisedItemVariances() {
        return this.standardizedItemVariances();
    }

    public double rawItemVariance(String string) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int n = this.itemIndex(string);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemVariances[n - 1];
    }

    public double rawItemVariance(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The item index, " + n + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemVariances[n - 1];
    }

    public double standardizedItemVariance(String string) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int n = this.itemIndex(string);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemVariances[n - 1];
    }

    public double standardisedItemVariance(String string) {
        return this.standardizedItemVariance(string);
    }

    public double standardizedItemVariance(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The item index, " + n + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemVariances[n - 1];
    }

    public double standardisedItemVariance(int n) {
        return this.standardizedItemVariance(n);
    }

    public double rawMeanOfItemVariances() {
        return this.rawItemVariancesMean;
    }

    public double rawStanadarDeviationOfItemVariances() {
        return this.rawItemVariancesSd;
    }

    public double rawVarianceOfItemVariances() {
        return this.rawItemVariancesVar;
    }

    public double rawMaximumOfItemVariances() {
        return this.rawItemVariancesMax;
    }

    public double rawMinimumOfItemVariances() {
        return this.rawItemVariancesMin;
    }

    public double rawRangeOfItemVariances() {
        return this.rawItemVariancesRange;
    }

    public double standardizedMeanOfItemVariances() {
        return this.standardizedItemVariancesMean;
    }

    public double standardisedMeanOfItemVariances() {
        return this.standardizedItemVariancesMean;
    }

    public double standardizedStanadarDeviationOfItemVariances() {
        return this.standardizedItemVariancesSd;
    }

    public double standardisedStanadarDeviationOfItemVariances() {
        return this.standardizedItemVariancesSd;
    }

    public double standardizedVarianceOfItemVariances() {
        return this.standardizedItemVariancesVar;
    }

    public double standardisedVarianceOfItemVariances() {
        return this.standardizedItemVariancesVar;
    }

    public double standardizedMaximumOfItemVariances() {
        return this.standardizedItemVariancesMax;
    }

    public double standardisedMaximumOfItemVariances() {
        return this.standardizedItemVariancesMax;
    }

    public double standardizedMinimumOfItemVariances() {
        return this.standardizedItemVariancesMin;
    }

    public double standardisedMinimumOfItemVariances() {
        return this.standardizedItemVariancesMin;
    }

    public double standardizedRangeOfItemVariances() {
        return this.standardizedItemVariancesRange;
    }

    public double standardisedRangeOfItemVariances() {
        return this.standardizedItemVariancesRange;
    }

    public double[] rawItemMinima() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMinima;
    }

    public double[] standardizedItemMinima() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMinima;
    }

    public double[] standardisedItemMinima() {
        return this.standardizedItemMinima();
    }

    public double rawItemMinimum(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The item index, " + n + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMinima[n - 1];
    }

    public double standardizedItemMinimum(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The item index, " + n + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMinima[n - 1];
    }

    public double standardisedItemMinimum(int n) {
        return this.standardizedItemMinimum(n);
    }

    public double rawMeanOfItemMinima() {
        return this.rawItemMinimaMean;
    }

    public double rawStanadarDeviationOfItemMinima() {
        return this.rawItemMinimaSd;
    }

    public double rawVarianceOfItemMinima() {
        return this.rawItemMinimaVar;
    }

    public double rawMaximumOfItemMinima() {
        return this.rawItemMinimaMax;
    }

    public double rawMinimumOfItemMinima() {
        return this.rawItemMinimaMin;
    }

    public double rawRangeOfItemMinima() {
        return this.rawItemMinimaRange;
    }

    public double standardizedMeanOfItemMinima() {
        return this.standardizedItemMinimaMean;
    }

    public double standardisedMeanOfItemMinima() {
        return this.standardizedItemMinimaMean;
    }

    public double standardizedStanadarDeviationOfItemMinima() {
        return this.standardizedItemMinimaSd;
    }

    public double standardisedStanadarDeviationOfItemMinima() {
        return this.standardizedItemMinimaSd;
    }

    public double standardizedVarianceOfItemMinima() {
        return this.standardizedItemMinimaVar;
    }

    public double standardisedVarianceOfItemMinima() {
        return this.standardizedItemMinimaVar;
    }

    public double standardizedMaximumOfItemMinima() {
        return this.standardizedItemMinimaMax;
    }

    public double standardisedMaximumOfItemMinima() {
        return this.standardizedItemMinimaMax;
    }

    public double standardizedMinimumOfItemMinima() {
        return this.standardizedItemMinimaMin;
    }

    public double standardisedMinimumOfItemMinima() {
        return this.standardizedItemMinimaMin;
    }

    public double standardizedRangeOfItemMinima() {
        return this.standardizedItemMinimaRange;
    }

    public double standardisedRangeOfItemMinima() {
        return this.standardizedItemMinimaRange;
    }

    public double[] rawItemMaxima() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMaxima;
    }

    public double[] standardizedItemMaxima() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMaxima;
    }

    public double[] standardisedItemMaxima() {
        return this.standardizedItemMaxima();
    }

    public double rawItemMaximum(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The item index, " + n + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMaxima[n - 1];
    }

    public double standardizedItemMaximum(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The item index, " + n + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMaxima[n - 1];
    }

    public double standardisedItemMaximum(int n) {
        return this.standardizedItemMaximum(n);
    }

    public double rawMeanOfItemMaxima() {
        return this.rawItemMaximaMean;
    }

    public double rawStanadarDeviationOfItemMaxima() {
        return this.rawItemMaximaSd;
    }

    public double rawVarianceOfItemMaxima() {
        return this.rawItemMaximaVar;
    }

    public double rawMaximumOfItemMaxima() {
        return this.rawItemMaximaMax;
    }

    public double rawMinimumOfItemMaxima() {
        return this.rawItemMaximaMin;
    }

    public double rawRangeOfItemMaxima() {
        return this.rawItemMaximaRange;
    }

    public double standardizedMeanOfItemMaxima() {
        return this.standardizedItemMaximaMean;
    }

    public double standardisedMeanOfItemMaxima() {
        return this.standardizedItemMaximaMean;
    }

    public double standardizedStanadarDeviationOfItemMaxima() {
        return this.standardizedItemMaximaSd;
    }

    public double standardisedStanadarDeviationOfItemMaxima() {
        return this.standardizedItemMaximaSd;
    }

    public double standardizedVarianceOfItemMaxima() {
        return this.standardizedItemMaximaVar;
    }

    public double standardisedVarianceOfItemMaxima() {
        return this.standardizedItemMaximaVar;
    }

    public double standardizedMaximumOfItemMaxima() {
        return this.standardizedItemMaximaMax;
    }

    public double standardisedMaximumOfItemMaxima() {
        return this.standardizedItemMaximaMax;
    }

    public double standardizedMinimumOfItemMaxima() {
        return this.standardizedItemMaximaMin;
    }

    public double standardisedMinimumOfItemMaxima() {
        return this.standardizedItemMaximaMin;
    }

    public double standardizedRangeOfItemMaxima() {
        return this.standardizedItemMaximaRange;
    }

    public double standardisedRangeOfItemMaxima() {
        return this.standardizedItemMaximaRange;
    }

    public double[] rawItemRanges() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemRanges;
    }

    public double[] standardizedItemRanges() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemRanges;
    }

    public double[] standardisedItemRanges() {
        return this.standardizedItemRanges();
    }

    public double rawItemRange(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The item index, " + n + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemRanges[n - 1];
    }

    public double standardizedItemRange(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The item index, " + n + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemRanges[n - 1];
    }

    public double standardisedItemRange(int n) {
        return this.standardizedItemRange(n);
    }

    public double rawMeanOfItemRanges() {
        return this.rawItemRangesMean;
    }

    public double rawStanadarDeviationOfItemRanges() {
        return this.rawItemRangesSd;
    }

    public double rawVarianceOfItemRanges() {
        return this.rawItemRangesVar;
    }

    public double rawMaximumOfItemRanges() {
        return this.rawItemRangesMax;
    }

    public double rawMinimumOfItemRanges() {
        return this.rawItemRangesMin;
    }

    public double rawRangeOfItemRanges() {
        return this.rawItemRangesRange;
    }

    public double standardizedMeanOfItemRanges() {
        return this.standardizedItemRangesMean;
    }

    public double standardisedMeanOfItemRanges() {
        return this.standardizedItemRangesMean;
    }

    public double standardizedStanadarDeviationOfItemRanges() {
        return this.standardizedItemRangesSd;
    }

    public double standardisedStanadarDeviationOfItemRanges() {
        return this.standardizedItemRangesSd;
    }

    public double standardizedVarianceOfItemRanges() {
        return this.standardizedItemRangesVar;
    }

    public double standardisedVarianceOfItemRanges() {
        return this.standardizedItemRangesVar;
    }

    public double standardizedMaximumOfItemRanges() {
        return this.standardizedItemRangesMax;
    }

    public double standardisedMaximumOfItemRanges() {
        return this.standardizedItemRangesMax;
    }

    public double standardizedMinimumOfItemRanges() {
        return this.standardizedItemRangesMin;
    }

    public double standardisedMinimumOfItemRanges() {
        return this.standardizedItemRangesMin;
    }

    public double standardizedRangeOfItemRanges() {
        return this.standardizedItemRangesRange;
    }

    public double standardisedRangeOfItemRanges() {
        return this.standardizedItemRangesRange;
    }

    public double[] rawItemTotals() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemTotals;
    }

    public double[] standardizedItemTotals() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemTotals;
    }

    public double[] standardisedItemTotals() {
        return this.standardizedItemTotals();
    }

    public double rawItemTotal(String string) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int n = this.itemIndex(string);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemTotals[n - 1];
    }

    public double rawItemTotal(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The item index, " + n + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemTotals[n - 1];
    }

    public double standardizedItemTotal(String string) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int n = this.itemIndex(string);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemTotals[n - 1];
    }

    public double standardisedItemTotal(String string) {
        return this.standardizedItemTotal(string);
    }

    public double standardizedItemTotal(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The item index, " + n + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemTotals[n - 1];
    }

    public double standardisedItemTotal(int n) {
        return this.standardizedItemTotal(n);
    }

    public double rawMeanOfItemTotals() {
        return this.rawItemTotalsMean;
    }

    public double rawStanadarDeviationOfItemTotals() {
        return this.rawItemTotalsSd;
    }

    public double rawVarianceOfItemTotals() {
        return this.rawItemTotalsVar;
    }

    public double rawMaximumOfItemTotals() {
        return this.rawItemTotalsMax;
    }

    public double rawMinimumOfItemTotals() {
        return this.rawItemTotalsMin;
    }

    public double rawRangeOfItemTotals() {
        return this.rawItemTotalsRange;
    }

    public double standardizedMeanOfItemTotals() {
        return this.standardizedItemTotalsMean;
    }

    public double standardisedMeanOfItemTotals() {
        return this.standardizedItemTotalsMean;
    }

    public double standardizedStanadarDeviationOfItemTotals() {
        return this.standardizedItemTotalsSd;
    }

    public double standardisedStanadarDeviationOfItemTotals() {
        return this.standardizedItemTotalsSd;
    }

    public double standardizedVarianceOfItemTotals() {
        return this.standardizedItemTotalsVar;
    }

    public double standardisedVarianceOfItemTotals() {
        return this.standardizedItemTotalsVar;
    }

    public double standardizedMaximumOfItemTotals() {
        return this.standardizedItemTotalsMax;
    }

    public double standardisedMaximumOfItemTotals() {
        return this.standardizedItemTotalsMax;
    }

    public double standardizedMinimumOfItemTotals() {
        return this.standardizedItemTotalsMin;
    }

    public double standardisedMinimumOfItemTotals() {
        return this.standardizedItemTotalsMin;
    }

    public double standardizedRangeOfItemTotals() {
        return this.standardizedItemTotalsRange;
    }

    public double standardisedRangeOfItemTotals() {
        return this.standardizedItemTotalsRange;
    }

    public double[] rawPersonMeans() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonMeans;
    }

    public double[] standardizedPersonMeans() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonMeans;
    }

    public double[] standardisedPersonMeans() {
        return this.standardizedPersonMeans();
    }

    public double rawPersonMean(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + n + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonMeans[n - 1];
    }

    public double standardizedPersonMean(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + n + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonMeans[n - 1];
    }

    public double standardisedPersonMean(int n) {
        return this.standardizedPersonMean(n);
    }

    public double[] rawPersonStandardDeviations() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonStandardDeviations;
    }

    public double[] standardizedPersonStandardDeviations() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonStandardDeviations;
    }

    public double[] standardisedPersonStandardDeviations() {
        return this.standardizedPersonStandardDeviations();
    }

    public double rawPersonStandardDeviation(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + n + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonStandardDeviations[n - 1];
    }

    public double standardizedPersonStandardDeviation(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + n + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonStandardDeviations[n - 1];
    }

    public double standardisedPersonStandardDeviation(int n) {
        return this.standardizedPersonStandardDeviation(n);
    }

    public double[] rawPersonVariances() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonVariances;
    }

    public double[] standardizedPersonVariances() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonVariances;
    }

    public double[] standardisedPersonVariances() {
        return this.standardizedPersonVariances();
    }

    public double rawPersonVariance(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + n + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonVariances[n - 1];
    }

    public double standardizedPersonVariance(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + n + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonVariances[n - 1];
    }

    public double standardisedPersonVariance(int n) {
        return this.standardizedPersonVariance(n);
    }

    public double[] rawPersonMinima() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonMinima;
    }

    public double[] standardizedPersonMinima() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonMinima;
    }

    public double[] standardisedPersonMinima() {
        return this.standardisedPersonMinima();
    }

    public double rawPersonMinimum(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The person index, " + n + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonMinima[n - 1];
    }

    public double standardizedPersonMinimum(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + n + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonMinima[n - 1];
    }

    public double standardisedPersonMinimum(int n) {
        return this.standardizedPersonMinimum(n);
    }

    public double[] rawPersonMaxima() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonMaxima;
    }

    public double[] standardizedPersonMaxima() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonMaxima;
    }

    public double[] standardisedPersonMaxima() {
        return this.standardizedPersonMaxima();
    }

    public double rawPersonMaximum(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The person index, " + n + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonMaxima[n - 1];
    }

    public double standardizedPersonMaximum(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + n + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonMaxima[n - 1];
    }

    public double standardisedPersonMaximum(int n) {
        return this.standardizedPersonMaximum(n);
    }

    public double[] rawPersonRanges() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonRanges;
    }

    public double[] standardizedPersonRanges() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonRanges;
    }

    public double[] standardisedPersonRanges() {
        return this.standardizedPersonRanges();
    }

    public double rawPersonRange(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The person index, " + n + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonRanges[n - 1];
    }

    public double standardizedPersonRange(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + n + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonRanges[n - 1];
    }

    public double standardisedPersonRange(int n) {
        return this.standardizedPersonRange(n);
    }

    public double[] rawItemMedians() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMedians;
    }

    public double[] standardizedItemMedians() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMedians;
    }

    public double[] standardisedItemMedians() {
        return this.standardizedItemMedians();
    }

    public double rawItemMedian(String string) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int n = this.itemIndex(string);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMedians[n - 1];
    }

    public double rawItemMedian(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The item index, " + n + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMedians[n - 1];
    }

    public double standardizedItemMedian(String string) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int n = this.itemIndex(string);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMedians[n - 1];
    }

    public double standardisedItemMedian(String string) {
        return this.standardizedItemMedian(string);
    }

    public double standardizedItemMedian(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The item index, " + n + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMedians[n - 1];
    }

    public double standardisedItemMedian(int n) {
        return this.standardizedItemMedian(n);
    }

    public double rawMeanOfItemMedians() {
        return this.rawItemMediansMean;
    }

    public double rawStanadarDeviationOfItemMedians() {
        return this.rawItemMediansSd;
    }

    public double rawVarianceOfItemMedians() {
        return this.rawItemMediansVar;
    }

    public double rawMaximumOfItemMedians() {
        return this.rawItemMediansMax;
    }

    public double rawMinimumOfItemMedians() {
        return this.rawItemMediansMin;
    }

    public double rawRangeOfItemMedians() {
        return this.rawItemMediansRange;
    }

    public double standardizedMeanOfItemMedians() {
        return this.standardizedItemMediansMean;
    }

    public double standardisedMeanOfItemMedians() {
        return this.standardizedItemMediansMean;
    }

    public double standardizedStanadarDeviationOfItemMedians() {
        return this.standardizedItemMediansSd;
    }

    public double standardisedStanadarDeviationOfItemMedians() {
        return this.standardizedItemMediansSd;
    }

    public double standardizedVarianceOfItemMedians() {
        return this.standardizedItemMediansVar;
    }

    public double standardisedVarianceOfItemMedians() {
        return this.standardizedItemMediansVar;
    }

    public double standardizedMaximumOfItemMedians() {
        return this.standardizedItemMediansMax;
    }

    public double standardisedMaximumOfItemMedians() {
        return this.standardizedItemMediansMax;
    }

    public double standardizedMinimumOfItemMedians() {
        return this.standardizedItemMediansMin;
    }

    public double standardisedMinimumOfItemMedians() {
        return this.standardizedItemMediansMin;
    }

    public double standardizedRangeOfItemMedians() {
        return this.standardizedItemMediansRange;
    }

    public double standardisedRangeOfItemMedians() {
        return this.standardizedItemMediansRange;
    }

    public double[] rawPersonTotals() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonTotals;
    }

    public double[] standardizedPersonTotals() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonTotals;
    }

    public double[] standardisedPersonTotals() {
        return this.standardizedPersonTotals();
    }

    public double rawPersonTotal(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The person index, " + n + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonTotals[n - 1];
    }

    public double standardizedPersonTotal(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + n + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonTotals[n - 1];
    }

    public double standardisedPersonTotal(int n) {
        return this.standardizedPersonTotal(n);
    }

    public double rawAllResponsesMean() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawAllResponsesMean;
    }

    public double standardizedAllResponsesMean() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedAllResponsesMean;
    }

    public double standardisedTotalMean() {
        return this.standardizedAllResponsesMean();
    }

    public double rawAllResponsesStandardDeviation() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawAllResponsesStandardDeviation;
    }

    public double standardizedAllResponsesStandardDeviation() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedAllResponsesStandardDeviation;
    }

    public double standardisedTotalStandardDeviation() {
        return this.standardizedAllResponsesStandardDeviation();
    }

    public double rawAllResponsesVariance() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawAllResponsesVariance;
    }

    public double standardizedAllResponsesVariance() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedAllResponsesVariance;
    }

    public double standardisedTotalVariance() {
        return this.standardizedAllResponsesVariance();
    }

    public double rawAllResponsesMinimum() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawAllResponsesMinimum;
    }

    public double standardizedAllResponsesMinimum() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedAllResponsesMinimum;
    }

    public double standardisedTotalMinimum() {
        return this.standardizedAllResponsesMinimum();
    }

    public double rawAllResponsesMaximum() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawAllResponsesMaximum;
    }

    public double standardizedAllResponsesMaximum() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedAllResponsesMaximum;
    }

    public double standardisedTotalMaximum() {
        return this.standardizedAllResponsesMaximum();
    }

    public double rawAllResponsesRange() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawAllResponsesRange;
    }

    public double standardizedAllResponsesRange() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedAllResponsesRange;
    }

    public double standardisedTotalRange() {
        return this.standardizedAllResponsesRange();
    }

    public double rawAllResponsesTotal() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawAllResponsesTotal;
    }

    public double standardizedAllResponsesTotal() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedAllResponsesTotal;
    }

    public double standardisedTotalTotal() {
        return this.standardizedAllResponsesTotal();
    }

    protected void covariancesAndCorrelationCoefficients() {
        int n;
        int n2;
        int n3;
        int n4;
        this.rawCovariances = new double[this.nItems + 1][this.nItems + 1];
        for (n4 = 0; n4 < this.nItems; ++n4) {
            for (n3 = n4; n3 < this.nItems; ++n3) {
                this.rawCovariances[n4][n3] = Stat.covariance(this.scores0[n4], this.scores0[n3]);
                if (n4 == n3) continue;
                this.rawCovariances[n3][n4] = this.rawCovariances[n4][n3];
            }
        }
        for (n4 = 0; n4 < this.nItems; ++n4) {
            this.rawCovariances[n4][this.nItems] = Stat.covariance(this.scores0[n4], this.rawPersonTotals);
            this.rawCovariances[this.nItems][n4] = this.rawCovariances[n4][this.nItems];
        }
        this.rawCovariances[this.nItems][this.nItems] = Stat.covariance(this.rawPersonTotals, this.rawPersonTotals);
        this.standardizedCovariances = new double[this.nItems + 1][this.nItems + 1];
        for (n4 = 0; n4 < this.nItems; ++n4) {
            for (n3 = n4; n3 < this.nItems; ++n3) {
                this.standardizedCovariances[n4][n3] = Stat.covariance(this.scores0[n4], this.scores0[n3]);
                if (n4 == n3) continue;
                this.standardizedCovariances[n3][n4] = this.standardizedCovariances[n4][n3];
            }
        }
        for (n4 = 0; n4 < this.nItems; ++n4) {
            this.standardizedCovariances[n4][this.nItems] = Stat.covariance(this.scores0[n4], this.standardizedPersonTotals);
            this.standardizedCovariances[this.nItems][n4] = this.standardizedCovariances[n4][this.nItems];
        }
        this.standardizedCovariances[this.nItems][this.nItems] = Stat.covariance(this.standardizedPersonTotals, this.standardizedPersonTotals);
        this.rawCorrelationCoefficients = new double[this.nItems + 1][this.nItems + 1];
        for (n4 = 0; n4 < this.nItems; ++n4) {
            this.rawCorrelationCoefficients[n4][n4] = 1.0;
            for (n3 = n4 + 1; n3 < this.nItems; ++n3) {
                this.rawCorrelationCoefficients[n4][n3] = this.rawCovariances[n4][n3] / Math.sqrt(this.rawCovariances[n4][n4] * this.rawCovariances[n3][n3]);
                if (Fmath.isNaN(this.rawCorrelationCoefficients[n4][n3])) {
                    this.rawCorrelationCoefficients[n4][n3] = 0.0;
                }
                this.rawCorrelationCoefficients[n3][n4] = this.rawCorrelationCoefficients[n4][n3];
            }
        }
        for (n4 = 0; n4 < this.nItems; ++n4) {
            this.rawCorrelationCoefficients[n4][this.nItems] = this.rawCovariances[n4][this.nItems] / Math.sqrt(this.rawCovariances[n4][n4] * this.rawCovariances[this.nItems][this.nItems]);
            if (Fmath.isNaN(this.rawCorrelationCoefficients[n4][this.nItems])) {
                this.rawCorrelationCoefficients[n4][this.nItems] = 0.0;
            }
            this.rawCorrelationCoefficients[this.nItems][n4] = this.rawCorrelationCoefficients[n4][this.nItems];
        }
        this.rawCorrelationCoefficients[this.nItems][this.nItems] = 1.0;
        double[] dArray = new double[this.nItems * (this.nItems - 1) / 2];
        n3 = 0;
        for (int i = 0; i < this.nItems; ++i) {
            for (n2 = i + 1; n2 < this.nItems; ++n2) {
                dArray[n3] = this.rawCorrelationCoefficients[i][n2];
                ++n3;
            }
        }
        Stat stat = new Stat(dArray);
        if (this.nFactorOption) {
            stat.setDenominatorToN();
        } else {
            stat.setDenominatorToNminusOne();
        }
        this.rawMeanRhoWithoutTotals = stat.mean_as_double();
        this.rawStandardDeviationRhoWithoutTotals = stat.standardDeviation_as_double();
        dArray = new double[this.nItems * (this.nItems + 1) / 2];
        n3 = 0;
        for (n2 = 0; n2 <= this.nItems; ++n2) {
            for (n = n2 + 1; n <= this.nItems; ++n) {
                dArray[n3] = this.rawCorrelationCoefficients[n2][n];
                ++n3;
            }
        }
        stat = new Stat(dArray);
        if (this.nFactorOption) {
            stat.setDenominatorToN();
        } else {
            stat.setDenominatorToNminusOne();
        }
        this.rawMeanRhoWithTotals = stat.mean_as_double();
        this.rawStandardDeviationRhoWithTotals = stat.standardDeviation_as_double();
        this.standardizedCorrelationCoefficients = new double[this.nItems + 1][this.nItems + 1];
        for (n2 = 0; n2 < this.nItems; ++n2) {
            this.standardizedCorrelationCoefficients[n2][n2] = 1.0;
            for (n = n2 + 1; n < this.nItems; ++n) {
                this.standardizedCorrelationCoefficients[n2][n] = this.standardizedCovariances[n2][n] / Math.sqrt(this.standardizedCovariances[n2][n2] * this.standardizedCovariances[n][n]);
                if (Fmath.isNaN(this.standardizedCorrelationCoefficients[n2][n])) {
                    this.standardizedCorrelationCoefficients[n2][n] = 0.0;
                }
                this.standardizedCorrelationCoefficients[n][n2] = this.standardizedCorrelationCoefficients[n2][n];
            }
        }
        for (n2 = 0; n2 < this.nItems; ++n2) {
            this.standardizedCorrelationCoefficients[n2][this.nItems] = this.standardizedCovariances[n2][this.nItems] / Math.sqrt(this.standardizedCovariances[n2][n2] * this.standardizedCovariances[this.nItems][this.nItems]);
            if (Fmath.isNaN(this.standardizedCorrelationCoefficients[n2][this.nItems])) {
                this.standardizedCorrelationCoefficients[n2][this.nItems] = 0.0;
            }
            this.standardizedCorrelationCoefficients[this.nItems][n2] = this.standardizedCorrelationCoefficients[n2][this.nItems];
        }
        this.standardizedCorrelationCoefficients[this.nItems][this.nItems] = 1.0;
        dArray = new double[this.nItems * (this.nItems - 1) / 2];
        n3 = 0;
        for (n2 = 0; n2 < this.nItems; ++n2) {
            for (n = n2 + 1; n < this.nItems; ++n) {
                dArray[n3] = this.standardizedCorrelationCoefficients[n2][n];
                ++n3;
            }
        }
        stat = new Stat(dArray);
        if (this.nFactorOption) {
            stat.setDenominatorToN();
        } else {
            stat.setDenominatorToNminusOne();
        }
        this.standardizedMeanRhoWithoutTotals = stat.mean_as_double();
        this.standardizedStandardDeviationRhoWithoutTotals = stat.standardDeviation_as_double();
        dArray = new double[this.nItems * (this.nItems + 1) / 2];
        n3 = 0;
        for (n2 = 0; n2 <= this.nItems; ++n2) {
            for (n = n2 + 1; n <= this.nItems; ++n) {
                dArray[n3] = this.standardizedCorrelationCoefficients[n2][n];
                ++n3;
            }
        }
        stat = new Stat(dArray);
        if (this.nFactorOption) {
            stat.setDenominatorToN();
        } else {
            stat.setDenominatorToNminusOne();
        }
        this.standardizedMeanRhoWithTotals = stat.mean_as_double();
        this.standardizedStandardDeviationRhoWithTotals = stat.standardDeviation_as_double();
        this.covariancesCalculated = true;
    }

    public double[][] rawCovariances() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawCovariances;
    }

    public double[][] standardizedCovariances() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedCovariances;
    }

    public double[][] standardisedCovariances() {
        return this.standardizedCovariances();
    }

    public double rawCovariance(String string, String string2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        int n = this.itemIndex(string);
        int n2 = this.itemIndex(string2);
        return this.rawCovariances[n - 1][n2 - 1];
    }

    public double rawCovariance(int n, int n2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The first item index, " + n + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (n2 < 1 || n2 > this.nItems) {
            throw new IllegalArgumentException("The second item index, " + n2 + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawCovariances[n - 1][n2 - 1];
    }

    public double rawCovariance(String string) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        int n = this.itemIndex(string);
        return this.rawCovariances[n - 1][this.nItems];
    }

    public double rawCovariance(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The first item index, " + n + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawCovariances[n - 1][this.nItems];
    }

    public double standardizedCovariance(String string, String string2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        int n = this.itemIndex(string);
        int n2 = this.itemIndex(string2);
        return this.standardizedCovariances[n + 1][n2 + 1];
    }

    public double standardisedCovariance(String string, String string2) {
        return this.standardizedCovariance(string, string2);
    }

    public double standardizedCovariance(int n, int n2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The first item index, " + n + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (n2 < 1 || n2 > this.nItems) {
            throw new IllegalArgumentException("The second item index, " + n2 + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedCovariances[n + 1][n2 + 1];
    }

    public double standardisedCovariance(int n, int n2) {
        return this.standardizedCovariance(n, n2);
    }

    public double standardizedCovariance(String string) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        int n = this.itemIndex(string);
        return this.standardizedCovariances[n + 1][this.nItems];
    }

    public double standardisedCovariance(String string) {
        return this.standardizedCovariance(string);
    }

    public double standardizedCovariance(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The first item index, " + n + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedCovariances[n + 1][this.nItems];
    }

    public double standardisedCovariance(int n) {
        return this.standardizedCovariance(n);
    }

    public double rawAverageCorrelationCoefficients() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawMeanRhoWithoutTotals;
    }

    public double rawStandardDeviationCorrelationCoefficients() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawStandardDeviationRhoWithoutTotals;
    }

    public double standardizedAverageCorrelationCoefficients() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedMeanRhoWithoutTotals;
    }

    public double standardisedAverageCorrelationCoefficients() {
        return this.standardizedAverageCorrelationCoefficients();
    }

    public double standardizedStandardDeviationCorrelationCoefficients() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedStandardDeviationRhoWithoutTotals;
    }

    public double standardisedStandardDeviationCorrelationCoefficients() {
        return this.standardizedStandardDeviationCorrelationCoefficients();
    }

    public double rawAverageCorrelationCoefficientsWithTotals() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawMeanRhoWithTotals;
    }

    public double rawStandardDeviationCorrelationCoefficientsWithTotals() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawStandardDeviationRhoWithTotals;
    }

    public double standardizedAverageCorrelationCoefficientsWithTotals() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedMeanRhoWithTotals;
    }

    public double standardisedAverageCorrelationCoefficientsWithTotals() {
        return this.standardizedAverageCorrelationCoefficientsWithTotals();
    }

    public double standardizedStandardDeviationCorrelationCoefficientsWithTotals() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedStandardDeviationRhoWithTotals;
    }

    public double standardisedStandardDeviationCorrelationCoefficientsWithTotals() {
        return this.standardizedStandardDeviationCorrelationCoefficientsWithTotals();
    }

    public double[][] rawCorrelationCoefficients() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawCorrelationCoefficients;
    }

    public double[][] standardizedCorrelationCoefficients() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedCorrelationCoefficients;
    }

    public double[][] standardisedCorrelationCoefficients() {
        return this.standardizedCorrelationCoefficients();
    }

    public double rawCorrelationCoefficient(String string, String string2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        int n = this.itemIndex(string);
        int n2 = this.itemIndex(string2);
        return this.rawCorrelationCoefficients[n - 1][n2 - 1];
    }

    public double rawCorrelationCoefficient(int n, int n2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The first item index, " + n + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (n2 < 1 || n2 > this.nItems) {
            throw new IllegalArgumentException("The second item index, " + n2 + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawCorrelationCoefficients[n - 1][n2 - 1];
    }

    public double rawCorrelationCoefficient(String string) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        int n = this.itemIndex(string);
        return this.rawCorrelationCoefficients[n - 1][this.nItems];
    }

    public double rawCorrelationCoefficient(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The first item index, " + n + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawCorrelationCoefficients[n - 1][this.nItems];
    }

    public double standardizedCorrelationCoefficient(String string, String string2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        int n = this.itemIndex(string);
        int n2 = this.itemIndex(string2);
        return this.standardizedCorrelationCoefficients[n + 1][n2 + 1];
    }

    public double standardisedCorrelationCoefficient(String string, String string2) {
        return this.standardizedCorrelationCoefficient(string, string2);
    }

    public double standardizedCorrelationCoefficient(int n, int n2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The first item index, " + n + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (n2 < 1 || n2 > this.nItems) {
            throw new IllegalArgumentException("The second item index, " + n2 + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedCorrelationCoefficients[n + 1][n2 + 1];
    }

    public double standardisedCorrelationCoefficient(int n, int n2) {
        return this.standardizedCorrelationCoefficient(n, n2);
    }

    public double standardizedCorrelationCoefficient(String string) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        int n = this.itemIndex(string);
        return this.standardizedCorrelationCoefficients[n + 1][this.nItems];
    }

    public double standardisedCorrelationCoefficient(String string) {
        return this.standardizedCorrelationCoefficient(string);
    }

    public double standardizedCorrelationCoefficient(int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (n < 1 || n > this.nItems) {
            throw new IllegalArgumentException("The first item index, " + n + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedCorrelationCoefficients[n + 1][this.nItems];
    }

    public double standardisedCorrelationCoefficient(int n) {
        return this.standardizedCorrelationCoefficient(n);
    }

    public double[][] deleteItem(String string) {
        int n = this.itemIndex(string);
        return this.deleteItem(n);
    }

    public double[][] deleteItem(int n) {
        --n;
        int n2 = 0;
        double[][] dArray = new double[this.nItems - 1][this.nPersons];
        for (int i = 0; i < this.nItems; ++i) {
            if (i == n) continue;
            dArray[n2] = this.scores0[i];
            ++n2;
        }
        return this.transpose(dArray);
    }

    public void rawItemItemPlot(String string, String string2) {
        int n = this.itemIndex(string);
        int n2 = this.itemIndex(string2);
        this.rawItemItemPlot(n, n2);
    }

    public void rawItemItemPlot(int n, int n2) {
        PlotGraph plotGraph = new PlotGraph(this.scores0[--n], this.scores0[--n2]);
        String string = "Scores: plot of responses to the item, " + this.itemNames[n] + ", against those to the item, " + this.itemNames[n2];
        plotGraph.setGraphTitle(string);
        plotGraph.setXaxisLegend("Responses to the item, " + this.itemNames[n]);
        plotGraph.setYaxisLegend("Responses to the item, " + this.itemNames[n2]);
        plotGraph.setLine(0);
        plotGraph.setPoint(4);
        plotGraph.plot();
    }

    public void rawItemMeansPlot(String string) {
        int n = this.itemIndex(string);
        this.rawItemMeansPlot(n);
    }

    public void rawItemMeansPlot(int n) {
        PlotGraph plotGraph = new PlotGraph(this.rawPersonMeans, this.scores0[--n]);
        String string = "Scores: plot of responses to the item, " + this.itemNames[n] + ", against the means of the responses to all items";
        plotGraph.setGraphTitle(string);
        plotGraph.setXaxisLegend("Mean of the responses to all the items, ");
        plotGraph.setYaxisLegend("Responses to the item, " + this.itemNames[n]);
        plotGraph.setLine(0);
        plotGraph.setPoint(4);
        plotGraph.plot();
    }

    public void standardizedItemItemPlot(String string, String string2) {
        int n = this.itemIndex(string);
        int n2 = this.itemIndex(string2);
        this.standardizedItemItemPlot(n, n2);
    }

    public void standardisedItemItemPlot(String string, String string2) {
        this.standardizedItemItemPlot(string, string2);
    }

    public void standardizedItemItemPlot(int n, int n2) {
        PlotGraph plotGraph = new PlotGraph(this.standardizedScores0[--n], this.standardizedScores0[--n2]);
        String string = "Scores: plot of responses to the item, " + this.itemNames[n] + ", against those to the item, " + this.itemNames[n2];
        plotGraph.setGraphTitle(string);
        plotGraph.setXaxisLegend("Responses to the item, " + this.itemNames[n]);
        plotGraph.setYaxisLegend("Responses to the item, " + this.itemNames[n2]);
        plotGraph.setLine(0);
        plotGraph.setPoint(4);
        plotGraph.plot();
    }

    public void standardisedItemItemPlot(int n, int n2) {
        this.standardizedItemItemPlot(n, n2);
    }

    public void standardizedItemMeansPlot(String string) {
        int n = this.itemIndex(string);
        this.standardizedItemMeansPlot(n);
    }

    public void standardisedItemMeansPlot(String string) {
        this.standardizedItemMeansPlot(string);
    }

    public void standardizedItemMeansPlot(int n) {
        PlotGraph plotGraph = new PlotGraph(this.standardizedPersonMeans, this.standardizedScores0[--n]);
        String string = "Scores: plot of responses to the item, " + this.itemNames[n] + ", against the means of the responses to all items";
        plotGraph.setGraphTitle(string);
        plotGraph.setXaxisLegend("Mean of the responses to all the items, ");
        plotGraph.setYaxisLegend("Responses to the item, " + this.itemNames[n]);
        plotGraph.setLine(0);
        plotGraph.setPoint(4);
        plotGraph.plot();
    }

    public void standardisedItemMeansPlot(int n) {
        this.standardizedItemMeansPlot(n);
    }

    public void numberOfDecimalPlaces(int n) {
        this.trunc = n;
    }

    public void numberOfDecimalPlacesAll(int n) {
        this.trunc = n;
        this.truncAll = true;
    }

    public void setOutputFileType(int n) {
        this.fileOption = n;
        this.fileOptionSet = true;
    }

    public void setFileNumbering() {
        this.fileNumberingSet = true;
    }

    public void removeFileNumbering() {
        this.fileNumberingSet = false;
    }

    public String getTitle() {
        return this.title[0];
    }

    public String getInputFileName() {
        return this.inputFilename;
    }

    public void outputProcessedData() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        this.outputFilename = "ScoresOutput";
        this.outputFilename = this.fileOption == 1 ? this.outputFilename + ".txt" : this.outputFilename + ".xls";
        String string = "Output file name for the processes scores:";
        String string2 = "\nEnter the required name (as a single word) and click OK ";
        String string3 = "\nor simply click OK for default value";
        String string4 = string + string2 + string3;
        String string5 = this.outputFilename;
        this.outputFilename = Db.readLine(string4, string5);
        this.outputProcessedData(this.outputFilename);
    }

    public void outputProcessedData(String string) {
        this.outputProcessedDataCommon(string, this.originalDataOrder);
    }

    public void outputProcessedDataAlternate() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        this.outputFilename = "ScoresOutput";
        this.outputFilename = this.fileOption == 1 ? this.outputFilename + ".txt" : this.outputFilename + ".xls";
        String string = "Output file name for the processes scores:";
        String string2 = "\nEnter the required name (as a single word) and click OK ";
        String string3 = "\nor simply click OK for default value";
        String string4 = string + string2 + string3;
        String string5 = this.outputFilename;
        this.outputFilename = Db.readLine(string4, string5);
        this.outputProcessedDataAlternate(this.outputFilename);
    }

    public void outputProcessedDataAlternate(String string) {
        int n = 0;
        if (this.originalDataOrder == 0) {
            n = 1;
        }
        this.outputProcessedDataCommon(string, n);
    }

    private void outputProcessedDataCommon(String string, int n) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        this.outputFilename = string;
        String string2 = null;
        String string3 = null;
        int n2 = string.indexOf(46);
        if (n2 == -1) {
            string2 = string;
            this.outputFilename = this.fileOption == 1 ? this.outputFilename + ".txt" : this.outputFilename + ".xls";
        } else {
            int n3;
            int n4;
            String[] stringArray;
            String[] stringArray2;
            String string4;
            String string5;
            String string6;
            String string7;
            string3 = string.substring(n2).trim();
            string2 = string.substring(0, n2).trim();
            if (string3.equalsIgnoreCase(".xls") && this.fileOption == 1) {
                if (this.fileOptionSet) {
                    string7 = "Your entered output file type is .xls";
                    string6 = "\nbut you have chosen a .txt output";
                    string5 = "Your output file name extension";
                    string4 = string7 + string6;
                    stringArray2 = new String[]{string4, "replace it with .txt [text file]"};
                    n3 = Db.optionBox(string5, stringArray2, stringArray = new String[]{"Retain", ".txt"}, n4 = 1);
                    if (n3 == 2) {
                        this.outputFilename = string2 + ".txt";
                    }
                } else {
                    this.fileOption = 2;
                }
            }
            if (string3.equalsIgnoreCase(".txt") && this.fileOption == 2) {
                if (this.fileOptionSet) {
                    string7 = "Your entered output file type is .txt";
                    string6 = "\nbut you have chosen a .xls output";
                    string5 = "Your output file name extension";
                    string4 = string7 + string6;
                    stringArray2 = new String[]{string4, "replace it with .xls [Excel file]"};
                    n3 = Db.optionBox(string5, stringArray2, stringArray = new String[]{"Retain", ".xls"}, n4 = 1);
                    if (n3 == 2) {
                        this.outputFilename = string2 + ".xls";
                    }
                } else {
                    this.fileOption = 1;
                }
            }
            if (!string3.equalsIgnoreCase(".txt") && !string3.equalsIgnoreCase(".xls")) {
                string7 = "Your extension is " + string3;
                string6 = "\n    Do you wish to retain it:";
                string4 = string7 + string6;
                string5 = "Your output file name extension";
                stringArray2 = new String[]{string4, "replace it with .txt [text file]", "replace it with .xls [MS Excel file]"};
                stringArray = new String[]{"Retain", ".txt", ".xls"};
                n4 = 1;
                n3 = Db.optionBox(string5, stringArray2, stringArray, n4);
                switch (n3) {
                    case 1: {
                        this.fileOption = 1;
                        break;
                    }
                    case 2: {
                        this.outputFilename = string2 + ".txt";
                        this.fileOption = 1;
                        break;
                    }
                    case 3: {
                        this.outputFilename = string2 + ".xls";
                        this.fileOption = 2;
                    }
                }
            }
        }
        this.title[0] = n == 0 ? this.title[0] + "   (output: row per item)" : this.title[0] + "   (output: row per person)";
        if (this.fileOption == 1) {
            this.outputText(n);
        } else {
            this.outputExcel(n);
        }
    }

    private void outputText(int n) {
        FileOutput fileOutput = new FileOutput(this.outputFilename);
        fileOutput.println(this.title[0]);
        fileOutput.println("Number of items =   " + this.nItems);
        fileOutput.println("Number of persons = " + this.nPersons);
        fileOutput.println();
        if (n == 0) {
            int n2;
            fileOutput.printtab("     ");
            for (n2 = 0; n2 < this.nPersons; ++n2) {
                fileOutput.printtab(this.personNames[n2]);
            }
            fileOutput.println();
            for (n2 = 0; n2 < this.nItems; ++n2) {
                fileOutput.printtab(this.itemNames[n2]);
                for (int i = 0; i < this.nPersons; ++i) {
                    fileOutput.printtab(Fmath.truncate(this.scores0[n2][i], this.trunc));
                }
                fileOutput.println();
            }
        } else {
            int n3;
            fileOutput.printtab("     ");
            for (n3 = 0; n3 < this.nItems; ++n3) {
                fileOutput.printtab(this.itemNames[n3]);
            }
            fileOutput.println();
            for (n3 = 0; n3 < this.nPersons; ++n3) {
                fileOutput.printtab(this.personNames[n3]);
                for (int i = 0; i < this.nItems; ++i) {
                    fileOutput.printtab(Fmath.truncate(this.scores1[n3][i], this.trunc));
                }
                fileOutput.println();
            }
        }
        fileOutput.close();
    }

    private void outputExcel(int n) {
        this.outputText(n);
    }

    public PCA toPCA() {
        PCA pCA = new PCA();
        pCA.title = this.title;
        pCA.titleLines = this.titleLines;
        pCA.inputFilename = this.inputFilename;
        pCA.outputFilename = this.outputFilename;
        pCA.fileOption = this.fileOption;
        pCA.fileOptionSet = this.fileOptionSet;
        pCA.fileExtensions = this.fileExtensions;
        pCA.fileNumberingSet = this.fileNumberingSet;
        pCA.originalDataType = this.originalDataType;
        pCA.originalDataOrder = this.originalDataOrder;
        pCA.originalData = this.originalData;
        pCA.scores0 = Conv.copy(this.scores0);
        pCA.originalScores0 = Conv.copy(this.originalScores0);
        pCA.standardizedScores0 = Conv.copy(this.standardizedScores0);
        pCA.scores1 = Conv.copy(this.scores1);
        pCA.originalScores1 = Conv.copy(this.originalScores1);
        pCA.standardizedScores1 = Conv.copy(this.standardizedScores1);
        pCA.dataEntered = this.dataEntered;
        pCA.nItems = this.nItems;
        pCA.originalNitems = this.originalNitems;
        pCA.itemNames = Conv.copy(this.itemNames);
        pCA.originalItemNames = Conv.copy(this.originalItemNames);
        pCA.itemNamesSet = this.itemNamesSet;
        pCA.nPersons = this.nPersons;
        pCA.originalNpersons = this.originalNpersons;
        pCA.nScores = this.nScores;
        pCA.originalNscores = this.originalNscores;
        pCA.otherFalse = this.otherFalse;
        pCA.otherTrue = this.otherTrue;
        pCA.otherDichotomousDataSet = this.otherDichotomousDataSet;
        pCA.dichotomous = Conv.copy(this.dichotomous);
        pCA.dichotomousPercentage = Conv.copy(this.dichotomousPercentage);
        pCA.dichotomousOverall = this.dichotomousOverall;
        pCA.dichotomousCheckDone = this.dichotomousCheckDone;
        pCA.letterToNumeralSet = this.letterToNumeralSet;
        pCA.ignoreNoResponseRequests = this.ignoreNoResponseRequests;
        pCA.itemDeletionPercentage = this.itemDeletionPercentage;
        pCA.itemDeletionPercentageSet = this.itemDeletionPercentageSet;
        pCA.personDeletionPercentage = this.personDeletionPercentage;
        pCA.personDeletionPercentageSet = this.personDeletionPercentageSet;
        pCA.replacementOption = this.replacementOption;
        pCA.replacementOptionNames = Conv.copy(this.replacementOptionNames);
        pCA.replacementOptionSet = this.replacementOptionSet;
        pCA.allNoResponseOptionsSet = this.allNoResponseOptionsSet;
        pCA.noResponseHandlingSet = this.noResponseHandlingSet;
        pCA.nNaN = this.nNaN;
        pCA.deletedItems = Conv.copy(this.deletedItems);
        pCA.nDeletedItems = this.nDeletedItems;
        pCA.deletedItemsIndices = Conv.copy(this.deletedItemsIndices);
        pCA.itemIndices = Conv.copy(this.itemIndices);
        pCA.deletedPersons = Conv.copy(this.deletedPersons);
        pCA.nDeletedPersons = this.nDeletedPersons;
        pCA.deletedPersonsIndices = Conv.copy(this.deletedPersonsIndices);
        pCA.personIndices = Conv.copy(this.personIndices);
        pCA.nReplacements = this.nReplacements;
        pCA.replacementIndices = Conv.copy(this.replacementIndices);
        pCA.nFactorOption = this.nFactorOption;
        if (this.dataEntered) {
            pCA.dataPreprocessed = false;
            pCA.preprocessData();
        }
        return pCA;
    }

    public Cronbach toCronbach() {
        Cronbach cronbach = new Cronbach();
        cronbach.title = this.title;
        cronbach.titleLines = this.titleLines;
        cronbach.inputFilename = this.inputFilename;
        cronbach.outputFilename = this.outputFilename;
        cronbach.fileOption = this.fileOption;
        cronbach.fileOptionSet = this.fileOptionSet;
        cronbach.fileExtensions = this.fileExtensions;
        cronbach.fileNumberingSet = this.fileNumberingSet;
        cronbach.originalDataType = this.originalDataType;
        cronbach.originalDataOrder = this.originalDataOrder;
        cronbach.originalData = this.originalData;
        cronbach.scores0 = Conv.copy(this.scores0);
        cronbach.originalScores0 = Conv.copy(this.originalScores0);
        cronbach.standardizedScores0 = Conv.copy(this.standardizedScores0);
        cronbach.scores1 = Conv.copy(this.scores1);
        cronbach.originalScores1 = Conv.copy(this.originalScores1);
        cronbach.standardizedScores1 = Conv.copy(this.standardizedScores1);
        cronbach.dataEntered = this.dataEntered;
        cronbach.nItems = this.nItems;
        cronbach.originalNitems = this.originalNitems;
        cronbach.itemNames = Conv.copy(this.itemNames);
        cronbach.originalItemNames = Conv.copy(this.originalItemNames);
        cronbach.itemNamesSet = this.itemNamesSet;
        cronbach.nPersons = this.nPersons;
        cronbach.originalNpersons = this.originalNpersons;
        cronbach.nScores = this.nScores;
        cronbach.originalNscores = this.originalNscores;
        cronbach.otherFalse = this.otherFalse;
        cronbach.otherTrue = this.otherTrue;
        cronbach.otherDichotomousDataSet = this.otherDichotomousDataSet;
        cronbach.dichotomous = Conv.copy(this.dichotomous);
        cronbach.dichotomousPercentage = Conv.copy(this.dichotomousPercentage);
        cronbach.dichotomousOverall = this.dichotomousOverall;
        cronbach.dichotomousCheckDone = this.dichotomousCheckDone;
        cronbach.letterToNumeralSet = this.letterToNumeralSet;
        cronbach.ignoreNoResponseRequests = this.ignoreNoResponseRequests;
        cronbach.itemDeletionPercentage = this.itemDeletionPercentage;
        cronbach.itemDeletionPercentageSet = this.itemDeletionPercentageSet;
        cronbach.personDeletionPercentage = this.personDeletionPercentage;
        cronbach.personDeletionPercentageSet = this.personDeletionPercentageSet;
        cronbach.replacementOption = this.replacementOption;
        cronbach.replacementOptionNames = Conv.copy(this.replacementOptionNames);
        cronbach.replacementOptionSet = this.replacementOptionSet;
        cronbach.allNoResponseOptionsSet = this.allNoResponseOptionsSet;
        cronbach.noResponseHandlingSet = this.noResponseHandlingSet;
        cronbach.nNaN = this.nNaN;
        cronbach.deletedItems = Conv.copy(this.deletedItems);
        cronbach.nDeletedItems = this.nDeletedItems;
        cronbach.deletedItemsIndices = Conv.copy(this.deletedItemsIndices);
        cronbach.itemIndices = Conv.copy(this.itemIndices);
        cronbach.deletedPersons = Conv.copy(this.deletedPersons);
        cronbach.nDeletedPersons = this.nDeletedPersons;
        cronbach.deletedPersonsIndices = Conv.copy(this.deletedPersonsIndices);
        cronbach.personIndices = Conv.copy(this.personIndices);
        cronbach.nReplacements = this.nReplacements;
        cronbach.replacementIndices = Conv.copy(this.replacementIndices);
        cronbach.nFactorOption = this.nFactorOption;
        if (this.dataEntered) {
            cronbach.dataPreprocessed = false;
            cronbach.preprocessData();
        }
        return cronbach;
    }
}

