/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.RegressionFunction;
import flanagan.analysis.Stat;

class PoissonFunction
implements RegressionFunction {
    private boolean scaleOption = true;
    private double scaleFactor = 1.0;

    PoissonFunction() {
    }

    @Override
    public double function(double[] dArray, double[] dArray2) {
        double d = this.scaleFactor;
        if (this.scaleOption) {
            d = dArray[1];
        }
        double d2 = d * Math.pow(dArray[0], dArray2[0]) * Math.exp(-dArray[0]) / Stat.factorial(dArray2[0]);
        return d2;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public void setScaleOption(boolean bl) {
        this.scaleOption = bl;
    }
}

