/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.Normality;
import flanagan.analysis.ProbabilityPlot;
import flanagan.analysis.Stat;
import flanagan.io.FileChooser;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.DeepCopy;
import flanagan.math.Fmath;
import flanagan.math.TimeAndDate;
import flanagan.util.Strings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;

public class Outliers {
    private double[] data = null;
    private double[] orderedData = null;
    private int[] originalIndices = null;
    private double[] orderStatisticMedians = null;
    private double[] strippedData = null;
    private double[] strippedOrderStatisticMedians = null;
    private int nPoints = 0;
    private double meanAll = Double.NaN;
    private double sdAll = Double.NaN;
    private double significance = 0.05;
    private int nTietjenMooreSimulations = 10000;
    private static int nTietjenMooreSimulationsStatic = 10000;
    private int nDixonSimulations = 10000;
    private static int nDixonSimulationsStatic = 10000;
    private int bluOption = -1;
    private int luOption = -1;
    private boolean pointsIgnored = false;
    private int nPointsIgnored = 0;
    private double[] ignoredPoints = null;
    private double[] esdLambdas = null;
    private double[] esdRvalues = null;
    private double[] esdMaxValues = null;
    private boolean[] esdTests = null;
    private boolean suppressPrint = false;
    private boolean suppressDisplay = false;
    private String filenameout = "OutlierDetectionResults.txt";
    private String filenamein = null;
    private TimeAndDate tad = new TimeAndDate();
    private String time_date;
    private int trunc = 4;
    private int field0 = 30;
    private int field = 15;

    public Outliers(double[] dArray) {
        this.data = dArray;
        this.initialise();
    }

    public Outliers(float[] fArray) {
        ArrayMaths arrayMaths = new ArrayMaths(fArray);
        this.data = arrayMaths.array_as_double();
        this.initialise();
    }

    public Outliers(long[] lArray) {
        ArrayMaths arrayMaths = new ArrayMaths(lArray);
        this.data = arrayMaths.array_as_double();
        this.initialise();
    }

    public Outliers(int[] nArray) {
        ArrayMaths arrayMaths = new ArrayMaths(nArray);
        this.data = arrayMaths.array_as_double();
        this.initialise();
    }

    public Outliers(BigDecimal[] bigDecimalArray) {
        ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray);
        this.data = arrayMaths.array_as_double();
        this.initialise();
    }

    public Outliers(BigInteger[] bigIntegerArray) {
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        this.data = arrayMaths.array_as_double();
        this.initialise();
    }

    public Outliers() {
        this.data = null;
        this.initialise();
    }

    private void initialise() {
        if (this.data != null) {
            this.nPoints = this.data.length;
            this.meanAll = Stat.mean(this.data);
            this.sdAll = Stat.standardDeviation(this.data);
        }
        this.time_date = this.tad.getShortTime24() + ", ";
        this.time_date = this.time_date + this.tad.getDate();
    }

    public void readDataFromTextFile() {
        int n;
        FileChooser fileChooser = new FileChooser();
        this.filenamein = fileChooser.selectFile();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n2 = fileChooser.numberOfLines();
        for (n = 0; n < n2; ++n) {
            String string = fileChooser.readLine();
            string = this.replacements(string);
            String[] stringArray = Strings.tokens(string);
            int n3 = stringArray.length;
            for (int i = 0; i < n3; ++i) {
                double d = Double.parseDouble(stringArray[i]);
                arrayList.add(d);
            }
        }
        fileChooser.close();
        this.nPoints = arrayList.size();
        this.data = new double[this.nPoints];
        for (n = 0; n < this.nPoints; ++n) {
            this.data[n] = (Double)arrayList.get(n);
        }
        this.meanAll = Stat.mean(this.data);
        this.sdAll = Stat.standardDeviation(this.data);
    }

    public String replacements(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            cArray[i] = string.charAt(i);
            if (cArray[i] == ',') {
                cArray[i] = 32;
            }
            if (cArray[i] == ';') {
                cArray[i] = 32;
            }
            if (cArray[i] == ':') {
                cArray[i] = 32;
            }
            if (cArray[i] == '\t') {
                cArray[i] = 32;
            }
            string2 = string2 + cArray[i];
        }
        return string2;
    }

    public void resetSignificanceLevel(double d) {
        this.significance = d;
    }

    public double getSignificanceLevel() {
        return this.significance;
    }

    private void setNpoints(int n) {
        this.nPoints = n;
    }

    public int getNpoints() {
        return this.nPoints;
    }

    public void suppressPrint() {
        this.suppressPrint = true;
    }

    public void restorePrint() {
        this.suppressPrint = false;
    }

    public void resetTextFileName(String string) {
        this.filenameout = string;
        int n = string.indexOf(".");
        if (n == -1) {
            string = string + ".txt";
        }
    }

    public void suppressDisplay() {
        this.suppressDisplay = true;
    }

    public void restoreDisplay() {
        this.suppressDisplay = false;
    }

    private ArrayList<Object> orderData(double[] dArray, int n) {
        ArrayList<Object> arrayList = null;
        switch (n) {
            case 0: {
                arrayList = this.orderAbsoluteResiduals(dArray);
                break;
            }
            case 1: {
                arrayList = this.orderDescending(dArray);
                break;
            }
            case 2: {
                arrayList = this.orderAscending(dArray);
            }
        }
        return arrayList;
    }

    public ArrayList<Object> orderAbsoluteResiduals(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = DeepCopy.copy(dArray);
        double d = Stat.mean(dArray2);
        ArrayMaths arrayMaths = new ArrayMaths(dArray2);
        arrayMaths = arrayMaths.minus(d);
        arrayMaths = arrayMaths.abs();
        arrayMaths = arrayMaths.sort();
        int[] nArray = arrayMaths.originalIndices();
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = dArray[nArray[i]];
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(dArray3);
        arrayList.add(nArray);
        return arrayList;
    }

    public ArrayList<Object> orderDescending(double[] dArray) {
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        arrayMaths = arrayMaths.sort();
        double[] dArray2 = arrayMaths.array();
        int[] nArray = arrayMaths.originalIndices();
        double[] dArray3 = DeepCopy.copy(dArray2);
        int[] nArray2 = DeepCopy.copy(nArray);
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray3[n - 1 - i];
            nArray[i] = nArray2[n - 1 - i];
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(dArray2);
        arrayList.add(nArray);
        return arrayList;
    }

    public ArrayList<Object> orderAscending(double[] dArray) {
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        arrayMaths = arrayMaths.sort();
        double[] dArray2 = arrayMaths.array();
        int[] nArray = arrayMaths.originalIndices();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(dArray2);
        arrayList.add(nArray);
        return arrayList;
    }

    public double[] getOriginalData() {
        return this.data;
    }

    public double[] getOrderedOriginalData() {
        ArrayMaths arrayMaths = new ArrayMaths(this.data);
        arrayMaths.sort();
        return arrayMaths.array();
    }

    public double[] getDataOrderStatisticMedians() {
        return this.orderStatisticMedians;
    }

    public double[] getStrippedData() {
        return this.strippedData;
    }

    public double[] getOrderedStrippedData() {
        ArrayMaths arrayMaths = new ArrayMaths(this.strippedData);
        arrayMaths.sort();
        return arrayMaths.array();
    }

    public double[] getStrippedDataOrderStatisticMedians() {
        return this.strippedOrderStatisticMedians;
    }

    public static double getGrubbsOneTailedCriticalT(double d, int n) {
        return Outliers.getGrubbsCriticalT(d, n, 1);
    }

    public static double getGrubbsOneSidedCriticalT(double d, int n) {
        return Outliers.getGrubbsCriticalT(d, n, 1);
    }

    public double getGrubbsOneTailedCriticalT() {
        return Outliers.getGrubbsCriticalT(this.significance, this.nPoints, 1);
    }

    public double getGrubbsOneSidedCriticalT() {
        return Outliers.getGrubbsCriticalT(this.significance, this.nPoints, 1);
    }

    public static double getGrubbsTwoTailedCriticalT(double d, int n) {
        return Outliers.getGrubbsCriticalT(d, n, 2);
    }

    public static double getGrubbsTwoSidedCriticalT(double d, int n) {
        return Outliers.getGrubbsCriticalT(d, n, 2);
    }

    public double getGrubbsTwoTailedCriticalT() {
        return Outliers.getGrubbsCriticalT(this.significance, this.nPoints, 2);
    }

    public double getGrubbsTwoSidedCriticalT() {
        return Outliers.getGrubbsCriticalT(this.significance, this.nPoints, 2);
    }

    private static double getGrubbsCriticalT(double d, int n, int n2) {
        double d2 = Stat.studentstValue(d / (double)(n * n2), n - 2);
        double d3 = d2 * d2;
        return (double)(n - 1) * Math.sqrt(d3 / ((double)(n - 2) + d3) / (double)n);
    }

    public ArrayList<Object> outlierGrubbs(double[] dArray) {
        Outliers outliers = new Outliers(dArray);
        return outliers.outlierGrubbs();
    }

    public ArrayList<Object> outlierGrubbs() {
        Stat.denominatorSwap();
        this.bluOption = 0;
        ArrayMaths arrayMaths = new ArrayMaths(this.data);
        arrayMaths = arrayMaths.minus(this.meanAll);
        arrayMaths = arrayMaths.abs();
        arrayMaths = arrayMaths.sort();
        int[] nArray = arrayMaths.originalIndices();
        this.orderedData = arrayMaths.getArray_as_double();
        double d = this.data[nArray[this.nPoints - 1]];
        double d2 = Outliers.getGrubbsTwoTailedCriticalT(this.significance, this.nPoints);
        double d3 = this.orderedData[this.nPoints - 1] / this.sdAll;
        Stat.denominatorUnswap();
        return this.outlierGrubbsCore(d, d2, d3);
    }

    public static ArrayList<Object> upperOutlierGrubbs(double[] dArray) {
        Outliers outliers = new Outliers(dArray);
        return outliers.upperOutlierGrubbs();
    }

    public ArrayList<Object> upperOutlierGrubbs() {
        Stat.denominatorSwap();
        this.bluOption = 2;
        ArrayMaths arrayMaths = new ArrayMaths(this.data);
        arrayMaths = arrayMaths.sort();
        this.orderedData = arrayMaths.getArray_as_double();
        double d = this.orderedData[this.nPoints - 1];
        double d2 = Outliers.getGrubbsOneTailedCriticalT(this.significance, this.nPoints);
        double d3 = (d - this.meanAll) / this.sdAll;
        Stat.denominatorUnswap();
        return this.outlierGrubbsCore(d, d2, d3);
    }

    public static ArrayList<Object> lowerOutlierGrubbs(double[] dArray) {
        Outliers outliers = new Outliers(dArray);
        return outliers.lowerOutlierGrubbs();
    }

    public ArrayList<Object> lowerOutlierGrubbs() {
        Stat.denominatorSwap();
        this.bluOption = 1;
        ArrayMaths arrayMaths = new ArrayMaths(this.data);
        arrayMaths = arrayMaths.sort();
        this.orderedData = arrayMaths.getArray_as_double();
        double d = this.orderedData[0];
        double d2 = Outliers.getGrubbsOneTailedCriticalT(this.significance, this.nPoints);
        double d3 = (this.meanAll - d) / this.sdAll;
        Stat.denominatorUnswap();
        return this.outlierGrubbsCore(d, d2, d3);
    }

    private ArrayList<Object> outlierGrubbsCore(double d, double d2, double d3) {
        Object object;
        ArrayList<Object> arrayList;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        double d4 = Double.NaN;
        int n = -1;
        boolean bl = false;
        if (d3 > d2) {
            int n2;
            bl = true;
            d4 = d;
            arrayList = new ArrayList<Double>();
            for (n2 = 0; n2 < this.nPoints; ++n2) {
                if (this.data[n2] == d) {
                    n = n2;
                    continue;
                }
                arrayList.add(this.data[n2]);
            }
            n2 = arrayList.size();
            this.strippedData = new double[n2];
            for (int i = 0; i < n2; ++i) {
                this.strippedData[i] = (Double)arrayList.get(i);
            }
            arrayList2.add(bl);
            arrayList2.add(d4);
            arrayList2.add(n);
            arrayList2.add(this.strippedData);
        } else {
            arrayList2.add(bl);
            arrayList2.add(d4);
            arrayList2.add(n);
            arrayList2.add(this.data);
        }
        arrayList2.add(d3);
        arrayList2.add(d2);
        arrayList2.add(this.significance);
        arrayList2.add(this.nPoints);
        arrayList = this.probabilityPlots(bl, this.data, this.strippedData);
        arrayList2.add(arrayList.get(0));
        arrayList2.add(arrayList.get(1));
        arrayList2.add(arrayList.get(2));
        arrayList2.add(arrayList.get(3));
        if (bl) {
            arrayList2.add(arrayList.get(4));
            arrayList2.add(arrayList.get(5));
            arrayList2.add(arrayList.get(6));
            arrayList2.add(arrayList.get(7));
        } else {
            arrayList2.add(Double.NaN);
            arrayList2.add(Double.NaN);
            arrayList2.add(Double.NaN);
            arrayList2.add(Double.NaN);
        }
        ArrayList<Object> arrayList3 = this.shapiroWilkTest(this.data);
        double d5 = (Double)arrayList3.get(0);
        double d6 = (Double)arrayList3.get(1);
        double d7 = (Double)arrayList3.get(2);
        String string = (String)arrayList3.get(3);
        double d8 = Double.NaN;
        double d9 = Double.NaN;
        double d10 = Double.NaN;
        String string2 = null;
        if (bl) {
            object = this.shapiroWilkTest(this.strippedData);
            d8 = (Double)((ArrayList)object).get(0);
            d9 = (Double)((ArrayList)object).get(1);
            d10 = (Double)((ArrayList)object).get(2);
            string2 = (String)((ArrayList)object).get(3);
        }
        arrayList2.add(d5);
        arrayList2.add(d6);
        arrayList2.add(d7);
        if (bl) {
            arrayList2.add(d8);
            arrayList2.add(d9);
            arrayList2.add(d10);
        } else {
            arrayList2.add(Double.NaN);
            arrayList2.add(Double.NaN);
            arrayList2.add(Double.NaN);
        }
        if (!this.suppressPrint) {
            object = new FileOutput(this.filenameout);
            ((FileOutput)object).println("Outlier Detection Results");
            ((FileOutput)object).println("Outlier Detection Method: Grubbs' Test");
            switch (this.bluOption) {
                case 0: {
                    ((FileOutput)object).println("Lower or upper outlier");
                    break;
                }
                case 1: {
                    ((FileOutput)object).println("Lower outlier");
                    break;
                }
                case 2: {
                    ((FileOutput)object).println("Upper outlier");
                }
            }
            if (this.filenamein != null) {
                ((FileOutput)object).println("Input file: " + this.filenamein);
            }
            ((FileOutput)object).println();
            ((FileOutput)object).println("File name: " + this.filenameout);
            ((FileOutput)object).println("Run date: " + this.time_date);
            ((FileOutput)object).println();
            if (bl) {
                ((FileOutput)object).println("Extreme outlier indicated");
            } else {
                ((FileOutput)object).println("No outlier indicated");
            }
            ((FileOutput)object).println();
            ((FileOutput)object).println("Significance level: " + this.significance + " [" + this.significance * 100.0 + "%]");
            ((FileOutput)object).println("Test Statistic, G:  " + Fmath.truncate(d3, this.trunc));
            ((FileOutput)object).println("Critical value, T:  " + Fmath.truncate(d2, this.trunc));
            ((FileOutput)object).println();
            if (bl) {
                ((FileOutput)object).print("Outlier: ");
                ((FileOutput)object).println(Fmath.truncate(d4, this.trunc));
                ((FileOutput)object).print("Outlier index in the original inputted data [indices start at 0]: ");
                ((FileOutput)object).println(n);
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print(" ", this.field0);
            ((FileOutput)object).print("Original data ", this.field);
            if (bl) {
                ((FileOutput)object).println("Data with outlier removed");
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print("Number of data points: ", this.field0);
            ((FileOutput)object).print(this.nPoints, this.field);
            if (bl) {
                ((FileOutput)object).println(this.nPoints - 1);
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print("Sample mean: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(Stat.mean(this.data), this.trunc), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(Stat.mean(this.strippedData), this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print("Sample standard deviation: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(Stat.standardDeviation(this.data), this.trunc), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(Stat.standardDeviation(this.strippedData), this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print("Maximum: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(Fmath.maximum(this.data), this.trunc), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(Fmath.maximum(this.strippedData), this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print("Minimum: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(Fmath.minimum(this.data), this.trunc), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(Fmath.minimum(this.strippedData), this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).println();
            ((FileOutput)object).println("Shapiro-Wilk Test:");
            ((FileOutput)object).print(" Shapiro-Wilk W value: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(d5, this.trunc), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(d8, this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).println(" Critical value for W: ");
            ((FileOutput)object).print("  (" + this.significance * 100.0 + "% Significance level)", this.field0);
            ((FileOutput)object).print(Fmath.truncate(d6, this.trunc), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(d9, this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print(" Shapiro-Wilk P value: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(d7, this.trunc), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(d10, this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print(" Data possibly Gaussian: ", this.field0);
            ((FileOutput)object).print(string, this.field);
            if (bl) {
                ((FileOutput)object).println(string2);
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).println();
            ((FileOutput)object).println("Probability plot:");
            ((FileOutput)object).print(" Correlation coefficient, r: ", this.field0);
            double d11 = (Double)arrayList.get(2);
            double d12 = Double.NaN;
            ((FileOutput)object).print(Fmath.truncate(d11, this.trunc), this.field);
            if (bl) {
                d12 = (Double)arrayList.get(6);
                ((FileOutput)object).println(Fmath.truncate(d12, this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).println(" Critical value for r: ");
            ((FileOutput)object).print("  (" + this.significance * 100.0 + "% Significance level)", this.field0);
            double d13 = (Double)arrayList.get(3);
            double d14 = Double.NaN;
            ((FileOutput)object).print(Fmath.truncate(d13, this.trunc), this.field);
            if (bl) {
                d14 = (Double)arrayList.get(7);
                ((FileOutput)object).println(Fmath.truncate(d14, this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print(" Data possibly Gaussian: ", this.field0);
            String string3 = "Rejected";
            if (d11 >= d13) {
                string3 = "Accepted";
            }
            ((FileOutput)object).print(string3, this.field);
            if (bl) {
                string3 = "Rejected";
                if (d12 >= d14) {
                    string3 = "Accepted";
                }
                ((FileOutput)object).println(string3);
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print(" Gradient: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate((Double)arrayList.get(0), this.trunc), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate((Double)arrayList.get(4), this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print(" Intercept: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate((Double)arrayList.get(1), this.trunc), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate((Double)arrayList.get(5), this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).println();
            ((FileOutput)object).println("Input data: ");
            int n3 = 0;
            for (int i = 0; i < this.nPoints; ++i) {
                ((FileOutput)object).print(this.data[i] + "  ");
                if (++n3 != 10) continue;
                ((FileOutput)object).println();
                n3 = 0;
            }
            ((FileOutput)object).close();
        }
        return arrayList2;
    }

    public void resetNumberTietjenMooreSimulations(int n) {
        this.nTietjenMooreSimulations = n;
    }

    public int getNumberTietjenMooreSimulations() {
        return this.nTietjenMooreSimulations;
    }

    public ArrayList<Object> outliersTietjenMoore(int n) {
        return this.outliersTietjenMooreCore(n, 0);
    }

    public static ArrayList<Object> outliersTietjenMoore(double[] dArray, int n) {
        Outliers outliers = new Outliers(dArray);
        return outliers.outliersTietjenMoore(n);
    }

    public ArrayList<Object> upperOutliersTietjenMoore(int n) {
        return this.outliersTietjenMooreCore(n, 2);
    }

    public static ArrayList<Object> upperOutliersTietjenMoore(double[] dArray, int n) {
        Outliers outliers = new Outliers(dArray);
        return outliers.upperOutliersTietjenMoore(n);
    }

    public ArrayList<Object> lowerOutliersTietjenMoore(int n) {
        return this.outliersTietjenMooreCore(n, 1);
    }

    public static ArrayList<Object> lowerOutliersTietjenMoore(double[] dArray, int n) {
        Outliers outliers = new Outliers(dArray);
        return outliers.lowerOutliersTietjenMoore(n);
    }

    private ArrayList<Object> outliersTietjenMooreCore(int n, int n2) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Stat.denominatorSwap();
        ArrayList<Object> arrayList2 = this.orderData(this.data, n2);
        this.orderedData = (double[])arrayList2.get(0);
        this.originalIndices = (int[])arrayList2.get(1);
        double[] dArray = new double[n];
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.orderedData[this.nPoints - n + i];
            nArray[i] = this.originalIndices[this.nPoints - n + i];
        }
        double d = this.getTietjenMooreLvalue(this.orderedData, this.nPoints, n);
        double[] dArray2 = new double[this.nTietjenMooreSimulations];
        double[] dArray3 = null;
        double d2 = 0.0;
        for (int i = 0; i < this.nTietjenMooreSimulations; ++i) {
            double[] dArray4 = Stat.gaussianRand(0.0, 1.0, this.nPoints);
            ArrayList<Object> arrayList3 = this.orderData(dArray4, 0);
            dArray3 = DeepCopy.copy((double[])arrayList3.get(0));
            dArray2[i] = this.getTietjenMooreLvalue(dArray3, this.nPoints, n);
            if (!(dArray2[i] >= d)) continue;
            d2 += 1.0;
        }
        double d3 = d2 / (double)this.nTietjenMooreSimulations;
        double d4 = 1.0 - d3;
        ArrayMaths arrayMaths = new ArrayMaths(dArray2);
        arrayMaths = arrayMaths.sort();
        dArray2 = arrayMaths.array();
        int n3 = (int)(this.significance * (double)this.nTietjenMooreSimulations);
        double d5 = dArray2[n3];
        boolean bl = false;
        if (d < d5) {
            bl = true;
        }
        arrayList.add(bl);
        arrayList.add(dArray);
        arrayList.add(nArray);
        if (bl) {
            this.strippedData = new double[this.nPoints - n];
            int n4 = 0;
            for (int i = 0; i < this.nPoints; ++i) {
                boolean bl2 = true;
                for (int j = 0; j < n; ++j) {
                    if (i != nArray[j]) continue;
                    bl2 = false;
                }
                if (!bl2) continue;
                this.strippedData[n4] = this.data[i];
                ++n4;
            }
            arrayList.add(this.strippedData);
        } else {
            arrayList.add(this.data);
        }
        arrayList.add(d);
        arrayList.add(d5);
        arrayList.add(this.significance);
        arrayList.add(d4);
        arrayList.add(this.nPoints);
        arrayList.add(n);
        ArrayList<Double> arrayList4 = this.probabilityPlots(bl, this.data, this.strippedData);
        arrayList.add(arrayList4.get(0));
        arrayList.add(arrayList4.get(1));
        arrayList.add(arrayList4.get(2));
        arrayList.add(arrayList4.get(3));
        if (bl) {
            arrayList.add(arrayList4.get(4));
            arrayList.add(arrayList4.get(5));
            arrayList.add(arrayList4.get(6));
            arrayList.add(arrayList4.get(7));
        } else {
            arrayList.add(Double.NaN);
            arrayList.add(Double.NaN);
            arrayList.add(Double.NaN);
            arrayList.add(Double.NaN);
        }
        ArrayList<Object> arrayList5 = this.shapiroWilkTest(this.data);
        double d6 = (Double)arrayList5.get(0);
        double d7 = (Double)arrayList5.get(1);
        double d8 = (Double)arrayList5.get(2);
        String string = (String)arrayList5.get(3);
        double d9 = Double.NaN;
        double d10 = Double.NaN;
        double d11 = Double.NaN;
        String string2 = null;
        if (bl) {
            object = this.shapiroWilkTest(this.strippedData);
            d9 = (Double)((ArrayList)object).get(0);
            d10 = (Double)((ArrayList)object).get(1);
            d11 = (Double)((ArrayList)object).get(2);
            string2 = (String)((ArrayList)object).get(3);
        }
        arrayList.add(d6);
        arrayList.add(d7);
        arrayList.add(d8);
        if (bl) {
            arrayList.add(d9);
            arrayList.add(d10);
            arrayList.add(d11);
        } else {
            arrayList.add(Double.NaN);
            arrayList.add(Double.NaN);
            arrayList.add(Double.NaN);
        }
        if (!this.suppressPrint) {
            object = new FileOutput(this.filenameout);
            ((FileOutput)object).println("Outlier Detection Results");
            ((FileOutput)object).println("Outlier Detection Method: Tietjen-Moore Test");
            switch (n2) {
                case 0: {
                    ((FileOutput)object).println("Lower and upper outliers");
                    break;
                }
                case 1: {
                    ((FileOutput)object).println("Lower outliers");
                    break;
                }
                case 2: {
                    ((FileOutput)object).println("Upper outliers");
                }
            }
            if (this.filenamein != null) {
                ((FileOutput)object).println("Input file: " + this.filenamein);
            }
            ((FileOutput)object).println();
            ((FileOutput)object).println("File name: " + this.filenameout);
            ((FileOutput)object).println("Run date: " + this.time_date);
            ((FileOutput)object).println();
            ((FileOutput)object).println("Number of outliers checked: " + n);
            if (bl) {
                ((FileOutput)object).println(n + " outliers indicated");
            } else {
                ((FileOutput)object).println("No outliers indicated");
            }
            ((FileOutput)object).println();
            ((FileOutput)object).println("Significance level:    " + this.significance + " [" + this.significance * 100.0 + "%]");
            ((FileOutput)object).println("Test Statistic, Lk:    " + Fmath.truncate(d, this.trunc));
            ((FileOutput)object).println("Critical value, Lcrit: " + Fmath.truncate(d5, this.trunc));
            ((FileOutput)object).println("Significance level at which Lk = Lcrit:  " + Fmath.truncate(d4, this.trunc) + " [" + Fmath.truncate(d4 * 100.0, 8) + "%]");
            ((FileOutput)object).println();
            if (bl) {
                int n5;
                ((FileOutput)object).println("Outliers: ");
                for (n5 = 0; n5 < n; ++n5) {
                    ((FileOutput)object).print(Fmath.truncate(dArray[n5], this.trunc) + "  ");
                }
                ((FileOutput)object).println();
                ((FileOutput)object).println("Outlier indices in the original inputted data [indices start at 0]: ");
                for (n5 = 0; n5 < n; ++n5) {
                    ((FileOutput)object).print(nArray[n5] + "  ");
                }
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print(" ", this.field0);
            ((FileOutput)object).print("Original data ", this.field);
            if (bl) {
                ((FileOutput)object).println("Data with outlier/s removed");
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print("Number of data points: ", this.field0);
            ((FileOutput)object).print(this.nPoints, this.field);
            if (bl) {
                ((FileOutput)object).println(this.nPoints - n);
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print("Sample mean: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(Stat.mean(this.data), this.trunc), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(Stat.mean(this.strippedData), this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print("Sample standard deviation: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(Stat.standardDeviation(this.data), this.trunc), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(Stat.standardDeviation(this.strippedData), this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print("Maximum: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(Fmath.maximum(this.data), this.trunc), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(Fmath.maximum(this.strippedData), this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print("Minimum: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(Fmath.minimum(this.data), this.trunc), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(Fmath.minimum(this.strippedData), this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).println();
            ((FileOutput)object).println("Shapiro-Wilk Test:");
            ((FileOutput)object).print(" Shapiro-Wilk W value: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(d6, this.trunc), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(d9, this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).println(" Critical value for W: ");
            ((FileOutput)object).print("  (" + this.significance * 100.0 + "% Significance level)", this.field0);
            ((FileOutput)object).print(Fmath.truncate(d7, this.trunc), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(d10, this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print(" Shapiro-Wilk P value: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(d8, this.trunc), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(d11, this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print(" Data possibly Gaussian: ", this.field0);
            ((FileOutput)object).print(string, this.field);
            if (bl) {
                ((FileOutput)object).println(string2);
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).println();
            ((FileOutput)object).println("Probability plot:");
            ((FileOutput)object).print(" Correlation coefficient, r: ", this.field0);
            double d12 = arrayList4.get(2);
            double d13 = Double.NaN;
            ((FileOutput)object).print(Fmath.truncate(d12, this.trunc), this.field);
            if (bl) {
                d13 = arrayList4.get(6);
                ((FileOutput)object).println(Fmath.truncate(d13, this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).println(" Critical value for r: ");
            ((FileOutput)object).print("  (" + this.significance * 100.0 + "% Significance level)", this.field0);
            double d14 = arrayList4.get(3);
            double d15 = Double.NaN;
            ((FileOutput)object).print(Fmath.truncate(d14, this.trunc), this.field);
            if (bl) {
                d15 = arrayList4.get(7);
                ((FileOutput)object).println(Fmath.truncate(d15, this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print(" Data possibly Gaussian: ", this.field0);
            String string3 = "Rejected";
            if (d12 >= d14) {
                string3 = "Accepted";
            }
            ((FileOutput)object).print(string3, this.field);
            if (bl) {
                string3 = "Rejected";
                if (d13 >= d15) {
                    string3 = "Accepted";
                }
                ((FileOutput)object).println(string3);
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print(" Gradient: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(arrayList4.get(0), this.trunc), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(arrayList4.get(4), this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print(" Intercept: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(arrayList4.get(1), this.trunc), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(arrayList4.get(5), this.trunc));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).println();
            ((FileOutput)object).println("Input data: ");
            int n6 = 0;
            for (int i = 0; i < this.nPoints; ++i) {
                ((FileOutput)object).print(this.data[i] + "  ");
                if (++n6 != 10) continue;
                ((FileOutput)object).println();
                n6 = 0;
            }
            ((FileOutput)object).close();
        }
        Stat.denominatorUnswap();
        return arrayList;
    }

    public double getTietjenMooreCriticalL(int n) {
        return this.getTietjenMooreCriticalLcore(n, 0);
    }

    public static double getTietjenMooreCriticalL(int n, int n2, int n3, double d) {
        Outliers outliers = new Outliers();
        outliers.setNpoints(n2);
        outliers.resetNumberTietjenMooreSimulations(n3);
        outliers.resetSignificanceLevel(d);
        return outliers.getTietjenMooreCriticalL(n);
    }

    public static double getTietjenMooreCriticalL(int n, int n2, double d) {
        Outliers outliers = new Outliers();
        outliers.setNpoints(n2);
        outliers.resetSignificanceLevel(d);
        return outliers.getTietjenMooreCriticalL(n);
    }

    public double getTietjenMooreLowerCriticalL(int n) {
        return this.getTietjenMooreCriticalLcore(n, 1);
    }

    public static double getTietjenMooreLowerCriticalL(int n, int n2, int n3, double d) {
        Outliers outliers = new Outliers();
        outliers.setNpoints(n2);
        outliers.resetNumberTietjenMooreSimulations(n3);
        outliers.resetSignificanceLevel(d);
        return outliers.getTietjenMooreLowerCriticalL(n);
    }

    public static double getTietjenMooreLowerCriticalL(int n, int n2, double d) {
        Outliers outliers = new Outliers();
        outliers.setNpoints(n2);
        outliers.resetSignificanceLevel(d);
        return outliers.getTietjenMooreLowerCriticalL(n);
    }

    public double getTietjenMooreUpperCriticalL(int n) {
        return this.getTietjenMooreCriticalLcore(n, 2);
    }

    public static double getTietjenMooreUpperCriticalL(int n, int n2, int n3, double d) {
        Outliers outliers = new Outliers();
        outliers.setNpoints(n2);
        outliers.resetNumberTietjenMooreSimulations(n3);
        outliers.resetSignificanceLevel(d);
        return outliers.getTietjenMooreUpperCriticalL(n);
    }

    public static double getTietjenMooreUpperCriticalL(int n, int n2, double d) {
        Outliers outliers = new Outliers();
        outliers.setNpoints(n2);
        outliers.resetSignificanceLevel(d);
        return outliers.getTietjenMooreUpperCriticalL(n);
    }

    private double getTietjenMooreCriticalLcore(int n, int n2) {
        double d = Double.NaN;
        Stat.denominatorSwap();
        double[] dArray = new double[this.nTietjenMooreSimulations];
        double[] dArray2 = null;
        for (int i = 0; i < this.nTietjenMooreSimulations; ++i) {
            double[] dArray3 = Stat.gaussianRand(0.0, 1.0, this.nPoints);
            ArrayList<Object> arrayList = this.orderData(dArray3, n2);
            dArray2 = (double[])arrayList.get(0);
            dArray[i] = this.getTietjenMooreLvalue(dArray2, this.nPoints, n);
        }
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        arrayMaths = arrayMaths.sort();
        dArray = arrayMaths.array();
        int n3 = (int)(this.significance * (double)this.nTietjenMooreSimulations);
        d = dArray[n3];
        Stat.denominatorUnswap();
        return d;
    }

    private double getTietjenMooreLvalue(double[] dArray, int n, int n2) {
        int n3;
        double d = Double.NaN;
        int n4 = n - n2;
        double[] dArray2 = new double[n4];
        for (int i = 0; i < n4; ++i) {
            dArray2[i] = dArray[i];
        }
        double d2 = Stat.mean(dArray2);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = Stat.mean(dArray);
        for (n3 = 0; n3 < n4; ++n3) {
            d3 += Fmath.square(dArray[n3] - d2);
        }
        for (n3 = 0; n3 < this.nPoints; ++n3) {
            d4 += Fmath.square(dArray[n3] - d5);
        }
        d = d3 / d4;
        return d;
    }

    public ArrayList<Object> outliersTeitjenMoore(int n) {
        return this.outliersTietjenMoore(n);
    }

    public ArrayList<Object> lowerOutliersTeitjenMoore(int n) {
        return this.lowerOutliersTietjenMoore(n);
    }

    public ArrayList<Object> upperOutliersTeitjenMoore(int n) {
        return this.upperOutliersTietjenMoore(n);
    }

    public double getTeitjenMooreCriticalL(int n) {
        return this.getTietjenMooreCriticalL(n);
    }

    public double getTeitjenMooreLowerCriticalL(int n) {
        return this.getTietjenMooreLowerCriticalL(n);
    }

    public double getTeitjenMooreUpperCriticalL(int n) {
        return this.getTietjenMooreUpperCriticalL(n);
    }

    public void resetNumberTeitjenMooreSimulations(int n) {
        this.resetNumberTietjenMooreSimulations(n);
    }

    public int getNumberTeitjenMooreSimulations() {
        return this.getNumberTietjenMooreSimulations();
    }

    public static ArrayList<Object> outliersTeitjenMoore(double[] dArray, int n) {
        return Outliers.outliersTietjenMoore(dArray, n);
    }

    public static ArrayList<Object> lowerOutliersTeitjenMoore(double[] dArray, int n) {
        return Outliers.lowerOutliersTietjenMoore(dArray, n);
    }

    public static ArrayList<Object> upperOutliersTeitjenMoore(double[] dArray, int n) {
        return Outliers.upperOutliersTietjenMoore(dArray, n);
    }

    public static double getTeitjenMooreCriticalL(int n, int n2, int n3, double d) {
        return Outliers.getTietjenMooreCriticalL(n, n2, n3, d);
    }

    public static double getTeitjenMooreCriticalL(int n, int n2, double d) {
        return Outliers.getTietjenMooreCriticalL(n, n2, d);
    }

    public static double getTeitjenMooreLowerCriticalL(int n, int n2, int n3, double d) {
        return Outliers.getTietjenMooreLowerCriticalL(n, n2, n3, d);
    }

    public static double getTeitjenMooreLowerCriticalL(int n, int n2, double d) {
        return Outliers.getTietjenMooreLowerCriticalL(n, n2, d);
    }

    public static double getTeitjenMooreUpperCriticalL(int n, int n2, int n3, double d) {
        return Outliers.getTietjenMooreUpperCriticalL(n, n2, n3, d);
    }

    public static double getTeitjenMooreUpperCriticalL(int n, int n2, double d) {
        return Outliers.getTietjenMooreUpperCriticalL(n, n2, d);
    }

    public ArrayList<Object> outliersESD(int n) {
        return this.outliersESDcore(n, 0);
    }

    public ArrayList<Object> outliersESDcore(int n, int n2) {
        Object object;
        Object[] objectArray;
        if (this.nPoints - n <= 1) {
            System.out.println("Number of suggested outliers, " + n + ", must be less than the number of points minus two, " + (this.nPoints - 2));
            System.out.println("The number of outliers has been reduced to " + --n);
        }
        this.esdLambdas = this.getESDlambdas(n);
        this.esdRvalues = new double[n];
        this.esdTests = new boolean[n];
        this.esdMaxValues = new double[n];
        double[] dArray = (double[])this.orderData(this.data, n2).get(0);
        boolean bl = false;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            this.esdRvalues[i] = Math.abs(dArray[this.nPoints - i - 1] - Stat.mean(dArray)) / Stat.standardDeviation(dArray);
            this.esdTests[i] = false;
            if (this.esdRvalues[i] > this.esdLambdas[i]) {
                this.esdTests[i] = true;
                bl = true;
                n3 = i + 1;
            }
            objectArray = DeepCopy.copy(dArray);
            this.esdMaxValues[i] = dArray[this.nPoints - 1 - i];
            dArray = new double[this.nPoints - i - 1];
            for (int j = 0; j < this.nPoints - i - 1; ++j) {
                dArray[j] = objectArray[j];
            }
            dArray = (double[])this.orderData(dArray, n2).get(0);
        }
        double[] dArray2 = null;
        objectArray = null;
        boolean[] blArray = null;
        if (bl) {
            int n4;
            int n5;
            dArray2 = new double[n3];
            objectArray = new int[n3];
            blArray = new boolean[this.nPoints];
            for (n5 = 0; n5 < this.nPoints; ++n5) {
                blArray[n5] = true;
            }
            block3: for (n5 = 0; n5 < n3; ++n5) {
                dArray2[n5] = this.esdMaxValues[n5];
                for (n4 = 0; n4 < this.nPoints; ++n4) {
                    if (!blArray[n4] || dArray2[n5] != this.data[n4]) continue;
                    objectArray[n5] = n4;
                    blArray[n4] = false;
                    continue block3;
                }
            }
            n5 = this.nPoints - n3;
            this.strippedData = new double[n5];
            n4 = 0;
            for (int i = 0; i < this.nPoints; ++i) {
                if (!blArray[i]) continue;
                this.strippedData[n4] = this.data[i];
                ++n4;
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(bl);
        arrayList.add(dArray2);
        arrayList.add(objectArray);
        arrayList.add(this.strippedData);
        arrayList.add(this.esdRvalues);
        arrayList.add(this.esdLambdas);
        arrayList.add(this.esdTests);
        arrayList.add(this.esdMaxValues);
        arrayList.add(this.significance);
        arrayList.add(this.nPoints);
        arrayList.add(n);
        ArrayList<Double> arrayList2 = this.probabilityPlots(bl, this.data, this.strippedData);
        arrayList.add(arrayList2.get(0));
        arrayList.add(arrayList2.get(1));
        arrayList.add(arrayList2.get(2));
        arrayList.add(arrayList2.get(3));
        if (bl) {
            arrayList.add(arrayList2.get(4));
            arrayList.add(arrayList2.get(5));
            arrayList.add(arrayList2.get(6));
            arrayList.add(arrayList2.get(7));
        } else {
            arrayList.add(Double.NaN);
            arrayList.add(Double.NaN);
            arrayList.add(Double.NaN);
            arrayList.add(Double.NaN);
        }
        ArrayList<Object> arrayList3 = this.shapiroWilkTest(this.data);
        double d = (Double)arrayList3.get(0);
        double d2 = (Double)arrayList3.get(1);
        double d3 = (Double)arrayList3.get(2);
        String string = (String)arrayList3.get(3);
        double d4 = Double.NaN;
        double d5 = Double.NaN;
        double d6 = Double.NaN;
        String string2 = null;
        if (bl) {
            object = this.shapiroWilkTest(this.strippedData);
            d4 = (Double)((ArrayList)object).get(0);
            d5 = (Double)((ArrayList)object).get(1);
            d6 = (Double)((ArrayList)object).get(2);
            string2 = (String)((ArrayList)object).get(3);
        }
        arrayList.add(d);
        arrayList.add(d2);
        arrayList.add(d3);
        if (bl) {
            arrayList.add(d4);
            arrayList.add(d5);
            arrayList.add(d6);
        } else {
            arrayList.add(Double.NaN);
            arrayList.add(Double.NaN);
            arrayList.add(Double.NaN);
        }
        if (!this.suppressPrint) {
            int n6;
            object = new FileOutput(this.filenameout);
            ((FileOutput)object).println("Outlier Detection Results");
            ((FileOutput)object).println("Outlier Detection Method: Generalised ESD (Extreme Studentised Deviate) Test");
            ((FileOutput)object).println("Lower and upper outliers");
            if (this.filenamein != null) {
                ((FileOutput)object).println("Input file: " + this.filenamein);
            }
            ((FileOutput)object).println();
            ((FileOutput)object).println("File name: " + this.filenameout);
            ((FileOutput)object).println("Run date: " + this.time_date);
            ((FileOutput)object).println();
            if (bl) {
                ((FileOutput)object).println(n3 + " outliers indicated");
            } else {
                ((FileOutput)object).println("No outliers indicated");
            }
            ((FileOutput)object).println();
            ((FileOutput)object).println("Significance level: " + this.significance + " [" + this.significance * 100.0 + "%]");
            ((FileOutput)object).println();
            int n7 = 12;
            int n8 = 4;
            ((FileOutput)object).println("Potential   Test        Critical    R>lambda    Maximum");
            ((FileOutput)object).println("number of   Statistic,  Value,                  deviate");
            ((FileOutput)object).println("outliers    R           lambda                  data value");
            for (n6 = 0; n6 < n; ++n6) {
                ((FileOutput)object).print(n6 + 1, n7);
                ((FileOutput)object).print(Fmath.truncate(this.esdRvalues[n6], n8), n7);
                ((FileOutput)object).print(Fmath.truncate(this.esdLambdas[n6], n8), n7);
                ((FileOutput)object).print(this.esdTests[n6], n7);
                ((FileOutput)object).print(Fmath.truncate(this.esdMaxValues[n6], n8), n7);
                ((FileOutput)object).println();
            }
            ((FileOutput)object).println();
            if (bl) {
                ((FileOutput)object).println("Outliers: ");
                for (n6 = 0; n6 < n3; ++n6) {
                    ((FileOutput)object).print(Fmath.truncate(dArray2[n6], n8) + "  ");
                }
                ((FileOutput)object).println();
                ((FileOutput)object).println("Outlier indices in the original inputted data [indices start at 0]: ");
                for (n6 = 0; n6 < n3; ++n6) {
                    ((FileOutput)object).print(objectArray[n6] + "  ");
                }
                ((FileOutput)object).println();
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print(" ", this.field0);
            ((FileOutput)object).print("Original data ", this.field);
            if (bl) {
                ((FileOutput)object).println("Data with outlier/s removed");
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print("Number of data points: ", this.field0);
            ((FileOutput)object).print(this.nPoints, this.field);
            if (bl) {
                ((FileOutput)object).println(this.nPoints - n3);
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print("Sample mean: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(Stat.mean(this.data), n8), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(Stat.mean(this.strippedData), n8));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print("Sample standard deviation: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(Stat.standardDeviation(this.data), n8), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(Stat.standardDeviation(this.strippedData), n8));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print("Maximum: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(Fmath.maximum(this.data), n8), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(Fmath.maximum(this.strippedData), n8));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print("Minimum: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(Fmath.minimum(this.data), n8), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(Fmath.minimum(this.strippedData), n8));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).println();
            ((FileOutput)object).println("Shapiro-Wilk Test:");
            ((FileOutput)object).print(" Shapiro-Wilk W value: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(d, n8), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(d4, n8));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).println(" Critical value for W: ");
            ((FileOutput)object).print("  (" + this.significance * 100.0 + "% Significance level)", this.field0);
            ((FileOutput)object).print(Fmath.truncate(d2, n8), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(d5, n8));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print(" Shapiro-Wilk P value: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(d3, n8), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(d6, n8));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print(" Data possibly Gaussian: ", this.field0);
            ((FileOutput)object).print(string, this.field);
            if (bl) {
                ((FileOutput)object).println(string2);
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).println();
            ((FileOutput)object).println("Probability plot:");
            ((FileOutput)object).print(" Correlation coefficient, r: ", this.field0);
            double d7 = arrayList2.get(2);
            double d8 = Double.NaN;
            ((FileOutput)object).print(Fmath.truncate(d7, n8), this.field);
            if (bl) {
                d8 = arrayList2.get(6);
                ((FileOutput)object).println(Fmath.truncate(d8, n8));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).println(" Critical value for r: ");
            ((FileOutput)object).print("  (" + this.significance * 100.0 + "% Significance level)", this.field0);
            double d9 = arrayList2.get(3);
            double d10 = Double.NaN;
            ((FileOutput)object).print(Fmath.truncate(d9, n8), this.field);
            if (bl) {
                d10 = arrayList2.get(7);
                ((FileOutput)object).println(Fmath.truncate(d10, n8));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print(" Data possibly Gaussian: ", this.field0);
            String string3 = "Rejected";
            if (d7 >= d9) {
                string3 = "Accepted";
            }
            ((FileOutput)object).print(string3, this.field);
            if (bl) {
                string3 = "Rejected";
                if (d8 >= d10) {
                    string3 = "Accepted";
                }
                ((FileOutput)object).println(string3);
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print(" Gradient: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(arrayList2.get(0), n8), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(arrayList2.get(4), n8));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).print(" Intercept: ", this.field0);
            ((FileOutput)object).print(Fmath.truncate(arrayList2.get(1), n8), this.field);
            if (bl) {
                ((FileOutput)object).println(Fmath.truncate(arrayList2.get(5), n8));
            } else {
                ((FileOutput)object).println();
            }
            ((FileOutput)object).println();
            ((FileOutput)object).println("Input data: ");
            int n9 = 0;
            for (int i = 0; i < this.nPoints; ++i) {
                ((FileOutput)object).print(this.data[i] + "  ");
                if (++n9 != 10) continue;
                ((FileOutput)object).println();
                n9 = 0;
            }
            ((FileOutput)object).close();
        }
        return arrayList;
    }

    public static ArrayList<Object> outliersESD(double[] dArray, int n) {
        Outliers outliers = new Outliers(dArray);
        return outliers.outliersESD(n);
    }

    public double[] getESDlambdas(int n) {
        this.esdLambdas = new double[n];
        for (int i = 1; i <= n; ++i) {
            this.esdLambdas[i - 1] = this.getESDlambda(i);
        }
        return this.esdLambdas;
    }

    private double getESDlambda(int n) {
        return this.getESDlambdaCore(n, 2);
    }

    private double getESDlambdaCore(int n, int n2) {
        double d = Double.NaN;
        int n3 = this.nPoints - n;
        double d2 = 1.0 - this.significance / (double)(n3 + 1) / (double)n2;
        double d3 = Stat.studentstValue(d2, n3 - 1);
        d = (double)n3 * d3 / Math.sqrt(((double)(n3 - 1) + d3 * d3) * (double)(n3 + 1));
        return d;
    }

    public static double[] getESDlambdas(int n, int n2, double d) {
        Outliers outliers = new Outliers();
        outliers.resetSignificanceLevel(d);
        outliers.setNpoints(n2);
        return outliers.getESDlambdas(n);
    }

    public double[] calcIgnoredPoints(int n, int n2, int[] nArray, int n3) {
        int n4;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (n3 == 0) {
            for (n4 = 1; n4 < n; ++n4) {
                arrayList.add(this.data[nArray[n4]]);
            }
            for (n4 = this.nPoints - n2; n4 < this.nPoints; ++n4) {
                arrayList.add(this.data[nArray[n4]]);
            }
        } else {
            for (n4 = 0; n4 < n2; ++n4) {
                arrayList.add(this.data[nArray[n4]]);
            }
            for (n4 = this.nPoints - n; n4 < this.nPoints - 1; ++n4) {
                arrayList.add(this.data[nArray[n4]]);
            }
        }
        this.pointsIgnored = false;
        this.ignoredPoints = null;
        this.nPointsIgnored = arrayList.size();
        if (this.nPointsIgnored > 0) {
            this.ignoredPoints = new double[this.nPointsIgnored];
            this.pointsIgnored = true;
            for (n4 = 0; n4 < this.nPointsIgnored; ++n4) {
                this.ignoredPoints[n4] = (Double)arrayList.get(n4);
            }
        }
        return this.ignoredPoints;
    }

    public static int[] ignoredIndicesLowerTest(int n, int n2, int n3) {
        int n4;
        int[] nArray = null;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n4 = 1; n4 < n; ++n4) {
            arrayList.add(n4 + 1);
        }
        for (n4 = n3 - n2; n4 < n3; ++n4) {
            arrayList.add(n4 + 1);
        }
        n4 = arrayList.size();
        if (n4 > 0) {
            nArray = new int[n4];
            for (int i = 0; i < n4; ++i) {
                nArray[i] = (Integer)arrayList.get(i);
            }
        }
        return nArray;
    }

    public static int[] ignoredIndicesUpperTest(int n, int n2, int n3) {
        int n4;
        int[] nArray = null;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n4 = 0; n4 < n2; ++n4) {
            arrayList.add(n4 + 1);
        }
        for (n4 = n3 - n; n4 < n3 - 1; ++n4) {
            arrayList.add(n4 + 1);
        }
        n4 = arrayList.size();
        if (n4 > 0) {
            nArray = new int[n4];
            for (int i = 0; i < n4; ++i) {
                nArray[i] = (Integer)arrayList.get(i);
            }
        }
        return nArray;
    }

    public void resetNumberDixonSimulations(int n) {
        this.nDixonSimulations = n;
    }

    public int getNumberDixonSimulations() {
        return this.nDixonSimulations;
    }

    private int[] getSubscripts(int n, int n2, int n3) {
        int[] nArray = new int[4];
        if (n3 == 0) {
            nArray[0] = n;
            nArray[1] = 0;
            nArray[2] = this.nPoints - n2 - 1;
            nArray[3] = 0;
        } else {
            nArray[0] = this.nPoints - 1;
            nArray[1] = this.nPoints - n - 1;
            nArray[2] = this.nPoints - 1;
            nArray[3] = n2;
        }
        return nArray;
    }

    private static int[] getSubscripts(int n, int n2, int n3, int n4) {
        int[] nArray = new int[4];
        if (n3 == 0) {
            nArray[0] = n;
            nArray[1] = 0;
            nArray[2] = n4 - n2 - 1;
            nArray[3] = 0;
        } else {
            nArray[0] = n4 - 1;
            nArray[1] = n4 - n - 1;
            nArray[2] = n4 - 1;
            nArray[3] = n2;
        }
        return nArray;
    }

    public ArrayList<Object> outlierDixon(int n, int n2) {
        this.bluOption = 0;
        ArrayList arrayList = new ArrayList();
        double[] dArray = (double[])this.orderData(DeepCopy.copy(this.data), 2).get(0);
        int[] nArray = (int[])this.orderData(dArray, 2).get(1);
        int n3 = 0;
        int[] nArray2 = this.getSubscripts(n, n2, n3);
        double d = dArray[nArray2[0]] - dArray[nArray2[1]];
        double d2 = dArray[nArray2[2]] - dArray[nArray2[3]];
        double d3 = d / d2;
        n3 = 1;
        int[] nArray3 = this.getSubscripts(n, n2, n3);
        d = dArray[nArray3[0]] - dArray[nArray3[1]];
        d2 = dArray[nArray3[2]] - dArray[nArray3[3]];
        double d4 = d / d2;
        n3 = 0;
        if (d4 > d3) {
            n3 = 1;
        }
        int n4 = -1;
        double d5 = Double.NaN;
        double d6 = Double.NaN;
        boolean bl = false;
        if (n3 == 0) {
            d6 = d3;
            n4 = nArray[0];
            d5 = Outliers.getDixonCritical(nArray2, this.nPoints, this.nDixonSimulations, this.significance, 2);
            if (d3 >= d5) {
                bl = true;
            }
        } else {
            d6 = d4;
            n4 = nArray[this.nPoints - 1];
            d5 = Outliers.getDixonCritical(nArray3, this.nPoints, this.nDixonSimulations, this.significance, 2);
            if (d4 >= d5) {
                bl = true;
            }
        }
        double d7 = this.data[n4];
        this.calcIgnoredPoints(n, n2, nArray, n3);
        this.strippedData(bl, n4);
        ArrayList<Double> arrayList2 = this.probabilityPlots(bl, this.data, this.strippedData);
        ArrayList<Object> arrayList3 = this.shapiroWilkTest(this.data);
        ArrayList<Object> arrayList4 = null;
        if (bl) {
            arrayList4 = this.shapiroWilkTest(this.strippedData);
        }
        if (!this.suppressPrint) {
            this.dixonTextFile(bl, n, n2, d6, d5, n4, d7, arrayList2, arrayList3, arrayList4);
        }
        return this.dixonRetArray(bl, d6, d5, n4, n, n2, arrayList2, arrayList3, arrayList4);
    }

    public static ArrayList<Object> outlierDixon(double[] dArray, int n, int n2) {
        Outliers outliers = new Outliers(dArray);
        return outliers.outlierDixon(n, n2);
    }

    public ArrayList<Object> outlierDixon() {
        return this.outlierDixon(1, 0);
    }

    public static ArrayList<Object> outlierDixon(double[] dArray) {
        Outliers outliers = new Outliers(dArray);
        return outliers.outlierDixon(1, 0);
    }

    public ArrayList<Object> lowerOutlierDixon(int n, int n2) {
        this.bluOption = 1;
        int n3 = 0;
        int[] nArray = this.getSubscripts(n, n2, n3);
        ArrayList arrayList = new ArrayList();
        double[] dArray = (double[])this.orderData(DeepCopy.copy(this.data), 2).get(0);
        int[] nArray2 = (int[])this.orderData(dArray, 2).get(1);
        double d = dArray[nArray[0]] - dArray[nArray[1]];
        double d2 = dArray[nArray[2]] - dArray[nArray[3]];
        double d3 = d / d2;
        int n4 = nArray2[0];
        double d4 = Outliers.getDixonCritical(nArray, this.nPoints, this.nDixonSimulations, this.significance, 1);
        boolean bl = false;
        if (d3 >= d4) {
            bl = true;
        }
        double d5 = this.data[n4];
        this.calcIgnoredPoints(n, n2, nArray2, n3);
        this.strippedData(bl, n4);
        ArrayList<Double> arrayList2 = this.probabilityPlots(bl, this.data, this.strippedData);
        ArrayList<Object> arrayList3 = this.shapiroWilkTest(this.data);
        ArrayList<Object> arrayList4 = null;
        if (bl) {
            arrayList4 = this.shapiroWilkTest(this.strippedData);
        }
        if (!this.suppressPrint) {
            this.dixonTextFile(bl, n, n2, d3, d4, n4, d5, arrayList2, arrayList3, arrayList4);
        }
        return this.dixonRetArray(bl, d3, d4, n4, n, n2, arrayList2, arrayList3, arrayList4);
    }

    private ArrayList<Object> dixonRetArray(boolean bl, double d, double d2, int n, int n2, int n3, ArrayList<Double> arrayList, ArrayList<Object> arrayList2, ArrayList<Object> arrayList3) {
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        double d3 = (Double)arrayList2.get(0);
        double d4 = (Double)arrayList2.get(1);
        double d5 = (Double)arrayList2.get(2);
        String string = (String)arrayList2.get(3);
        double d6 = Double.NaN;
        double d7 = Double.NaN;
        double d8 = Double.NaN;
        String string2 = null;
        if (bl) {
            d6 = (Double)arrayList3.get(0);
            d7 = (Double)arrayList3.get(1);
            d8 = (Double)arrayList3.get(2);
            string2 = (String)arrayList3.get(3);
        }
        double d9 = Double.NaN;
        double[] dArray = null;
        int n4 = -1;
        if (bl) {
            d9 = this.data[n];
            dArray = new double[this.nPoints - 1];
            int n5 = 0;
            for (int i = 0; i < this.nPoints - 2; ++i) {
                if (i != n) {
                    dArray[n5] = this.data[i];
                }
                ++n5;
            }
            n4 = n;
        } else {
            dArray = DeepCopy.copy(this.data);
        }
        arrayList4.add(bl);
        arrayList4.add(d9);
        arrayList4.add(n4);
        arrayList4.add(dArray);
        arrayList4.add(d);
        arrayList4.add(d2);
        arrayList4.add(this.significance);
        arrayList4.add(this.nPoints);
        arrayList4.add(n2);
        arrayList4.add(n3);
        arrayList4.add(this.nPointsIgnored);
        arrayList4.add(this.ignoredPoints);
        arrayList4.add(arrayList.get(0));
        arrayList4.add(arrayList.get(1));
        arrayList4.add(arrayList.get(2));
        arrayList4.add(arrayList.get(3));
        if (bl) {
            arrayList4.add(arrayList.get(4));
            arrayList4.add(arrayList.get(5));
            arrayList4.add(arrayList.get(6));
            arrayList4.add(arrayList.get(7));
        } else {
            arrayList4.add(Double.NaN);
            arrayList4.add(Double.NaN);
            arrayList4.add(Double.NaN);
            arrayList4.add(Double.NaN);
        }
        arrayList4.add(d3);
        arrayList4.add(d4);
        arrayList4.add(d5);
        if (bl) {
            arrayList4.add(d6);
            arrayList4.add(d7);
            arrayList4.add(d8);
        } else {
            arrayList4.add(Double.NaN);
            arrayList4.add(Double.NaN);
            arrayList4.add(Double.NaN);
        }
        return arrayList4;
    }

    public static ArrayList<Object> lowerOutlierDixon(double[] dArray, int n, int n2) {
        Outliers outliers = new Outliers(dArray);
        return outliers.lowerOutlierDixon(n, n2);
    }

    public ArrayList<Object> lower0outlierDixon() {
        return this.lowerOutlierDixon(1, 0);
    }

    public static ArrayList<Object> lowerOutlierDixon(double[] dArray) {
        Outliers outliers = new Outliers(dArray);
        return outliers.lowerOutlierDixon(1, 0);
    }

    public ArrayList<Object> upperOutlierDixon(int n, int n2) {
        this.bluOption = 2;
        int n3 = 1;
        int[] nArray = this.getSubscripts(n, n2, n3);
        ArrayList arrayList = new ArrayList();
        double[] dArray = (double[])this.orderData(DeepCopy.copy(this.data), 2).get(0);
        int[] nArray2 = (int[])this.orderData(dArray, 2).get(1);
        double d = dArray[nArray[0]] - dArray[nArray[1]];
        double d2 = dArray[nArray[2]] - dArray[nArray[3]];
        double d3 = d / d2;
        int n4 = nArray2[this.nPoints - 1];
        double d4 = Outliers.getDixonCritical(nArray, this.nPoints, this.nDixonSimulations, this.significance, 1);
        boolean bl = false;
        if (d3 >= d4) {
            bl = true;
        }
        double d5 = this.data[n4];
        this.calcIgnoredPoints(n, n2, nArray2, n3);
        this.strippedData(bl, n4);
        ArrayList<Double> arrayList2 = this.probabilityPlots(bl, this.data, this.strippedData);
        ArrayList<Object> arrayList3 = this.shapiroWilkTest(this.data);
        ArrayList<Object> arrayList4 = null;
        if (bl) {
            arrayList4 = this.shapiroWilkTest(this.strippedData);
        }
        if (!this.suppressPrint) {
            this.dixonTextFile(bl, n, n2, d3, d4, n4, d5, arrayList2, arrayList3, arrayList4);
        }
        return this.dixonRetArray(bl, d3, d4, n4, n, n2, arrayList2, arrayList3, arrayList4);
    }

    public static ArrayList<Object> upperOutlierDixon(double[] dArray, int n, int n2) {
        Outliers outliers = new Outliers(dArray);
        return outliers.upperOutlierDixon(n, n2);
    }

    public ArrayList<Object> upperOutlierDixon() {
        return this.upperOutlierDixon(1, 0);
    }

    public static ArrayList<Object> upperOutlierDixon(double[] dArray) {
        Outliers outliers = new Outliers(dArray);
        return outliers.upperOutlierDixon(1, 0);
    }

    public static double getDixonOneTailedCriticalQ(int n, int n2, int n3, int n4, double d) {
        int[] nArray = Outliers.getSubscripts(n, n2, 0, n3);
        return Outliers.getDixonCritical(nArray, n3, n4, d, 1);
    }

    public static double getDixonOneTailedCriticalQ(int n, int n2, int n3, double d) {
        int[] nArray = Outliers.getSubscripts(n, n2, 0, n3);
        return Outliers.getDixonCritical(nArray, n3, nDixonSimulationsStatic, d, 1);
    }

    public static double getDixonOneTailedCriticalQ(int n, int n2, double d) {
        int[] nArray = Outliers.getSubscripts(1, 0, 0, n);
        return Outliers.getDixonCritical(nArray, n, n2, d, 1);
    }

    public static double getDixonOneTailedCriticalQ(int n, double d) {
        int[] nArray = Outliers.getSubscripts(1, 0, 0, n);
        return Outliers.getDixonCritical(nArray, n, nDixonSimulationsStatic, d, 1);
    }

    public static double getDixonTwoTailedCriticalQ(int n, int n2, int n3, int n4, double d) {
        int[] nArray = Outliers.getSubscripts(n, n2, 0, n3);
        return Outliers.getDixonCritical(nArray, n3, n4, d, 2);
    }

    public static double getDixonTwoTailedCriticalQ(int n, int n2, int n3, double d) {
        int[] nArray = Outliers.getSubscripts(n, n2, 0, n3);
        return Outliers.getDixonCritical(nArray, n3, nDixonSimulationsStatic, d, 2);
    }

    public static double getDixonTwoTailedCriticalQ(int n, int n2, double d) {
        int[] nArray = Outliers.getSubscripts(1, 0, 0, n);
        return Outliers.getDixonCritical(nArray, n, n2, d, 2);
    }

    public static double getDixonTwoTailedCriticalQ(int n, double d) {
        int[] nArray = Outliers.getSubscripts(1, 0, 0, n);
        return Outliers.getDixonCritical(nArray, n, nDixonSimulationsStatic, d, 2);
    }

    private static double getDixonCritical(int n, int n2, int n3, int n4, double d, int n5) {
        int[] nArray = Outliers.getSubscripts(n, n2, 0, n3);
        return Outliers.getDixonCritical(nArray, n3, n4, d, n5);
    }

    private static double getDixonCritical(int n, int n2, int n3, int n4, int n5, double d, int n6) {
        int[] nArray = Outliers.getSubscripts(n, n2, n3, n4);
        return Outliers.getDixonCritical(nArray, n4, n5, d, n6);
    }

    private static double getDixonCritical(int[] nArray, int n, int n2, double d, int n3) {
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            double[] dArray2 = Stat.gaussianRand(0.0, 1.0, n);
            ArrayMaths arrayMaths = new ArrayMaths(dArray2);
            dArray2 = arrayMaths.sort().array();
            double d2 = dArray2[nArray[0]] - dArray2[nArray[1]];
            double d3 = dArray2[nArray[2]] - dArray2[nArray[3]];
            dArray[i] = d2 / d3;
        }
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        dArray = arrayMaths.sort().array();
        int n4 = (int)Math.round((double)n2 * (1.0 - d / (double)n3));
        double d4 = dArray[n4];
        return d4;
    }

    private void dixonTextFile(boolean bl, int n, int n2, double d, double d2, int n3, double d3, ArrayList<Double> arrayList, ArrayList<Object> arrayList2, ArrayList<Object> arrayList3) {
        String string = "r" + n + n2;
        double d4 = (Double)arrayList2.get(0);
        double d5 = (Double)arrayList2.get(1);
        double d6 = (Double)arrayList2.get(2);
        String string2 = (String)arrayList2.get(3);
        double d7 = Double.NaN;
        double d8 = Double.NaN;
        double d9 = Double.NaN;
        String string3 = null;
        if (bl) {
            d7 = (Double)arrayList3.get(0);
            d8 = (Double)arrayList3.get(1);
            d9 = (Double)arrayList3.get(2);
            string3 = (String)arrayList3.get(3);
        }
        FileOutput fileOutput = new FileOutput(this.filenameout);
        fileOutput.println("Outlier Detection Results");
        fileOutput.println("Outlier Detection Method: Dixon's Q Test with " + string);
        String string4 = "";
        switch (this.bluOption) {
            case 0: {
                fileOutput.println("Lower or upper outlier");
                break;
            }
            case 1: {
                fileOutput.println("Lower outlier");
                string4 = " lower ";
                break;
            }
            case 2: {
                fileOutput.println("Upper outlier");
                string4 = " upper ";
            }
        }
        if (this.filenamein != null) {
            fileOutput.println("Input file: " + this.filenamein);
        }
        fileOutput.println();
        fileOutput.println("File name: " + this.filenameout);
        fileOutput.println("Run date: " + this.time_date);
        fileOutput.println();
        if (this.pointsIgnored) {
            if (this.nPointsIgnored == 1) {
                fileOutput.print("1 point ignored: ");
            } else {
                fileOutput.print(this.nPointsIgnored + " points ignored: ");
            }
            for (int i = 0; i < this.nPointsIgnored; ++i) {
                fileOutput.print(this.ignoredPoints[i] + "   ");
            }
            fileOutput.println();
            fileOutput.println();
        } else {
            fileOutput.println("No points ignored");
            fileOutput.println();
        }
        if (bl) {
            fileOutput.println("Extreme outlier indicated");
        } else {
            fileOutput.println("No" + string4 + "outlier indicated");
        }
        fileOutput.println();
        fileOutput.println("Significance level:    " + this.significance + " [" + this.significance * 100.0 + "%]");
        fileOutput.println("Test Statistic, " + string + ":   " + Fmath.truncate(d, this.trunc));
        fileOutput.println("Critical value, Qcrit: " + Fmath.truncate(d2, this.trunc));
        fileOutput.println();
        if (bl) {
            fileOutput.print("Outlier: ");
            fileOutput.println(Fmath.truncate(d3, this.trunc));
            fileOutput.print("Outlier index in the original inputted data [indices start at 0]: ");
            fileOutput.println(n3);
            fileOutput.println();
        }
        fileOutput.print(" ", this.field0);
        fileOutput.print("Original data ", this.field);
        if (bl) {
            fileOutput.println("Data with outlier removed");
        } else {
            fileOutput.println();
        }
        fileOutput.print("Number of data points: ", this.field0);
        fileOutput.print(this.nPoints, this.field);
        if (bl) {
            fileOutput.println(this.nPoints - 1);
        } else {
            fileOutput.println();
        }
        fileOutput.print("Sample mean: ", this.field0);
        fileOutput.print(Fmath.truncate(Stat.mean(this.data), this.trunc), this.field);
        if (bl) {
            fileOutput.println(Fmath.truncate(Stat.mean(this.strippedData), this.trunc));
        } else {
            fileOutput.println();
        }
        fileOutput.print("Sample standard deviation: ", this.field0);
        fileOutput.print(Fmath.truncate(Stat.standardDeviation(this.data), this.trunc), this.field);
        if (bl) {
            fileOutput.println(Fmath.truncate(Stat.standardDeviation(this.strippedData), this.trunc));
        } else {
            fileOutput.println();
        }
        fileOutput.print("Maximum: ", this.field0);
        fileOutput.print(Fmath.truncate(Fmath.maximum(this.data), this.trunc), this.field);
        if (bl) {
            fileOutput.println(Fmath.truncate(Fmath.maximum(this.strippedData), this.trunc));
        } else {
            fileOutput.println();
        }
        fileOutput.print("Minimum: ", this.field0);
        fileOutput.print(Fmath.truncate(Fmath.minimum(this.data), this.trunc), this.field);
        if (bl) {
            fileOutput.println(Fmath.truncate(Fmath.minimum(this.strippedData), this.trunc));
        } else {
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.println("Shapiro-Wilk Test:");
        fileOutput.print(" Shapiro-Wilk W value: ", this.field0);
        fileOutput.print(Fmath.truncate(d4, this.trunc), this.field);
        if (bl) {
            fileOutput.println(Fmath.truncate(d7, this.trunc));
        } else {
            fileOutput.println();
        }
        fileOutput.println(" Critical value for W: ");
        fileOutput.print("  (" + this.significance * 100.0 + "% Significance level)", this.field0);
        fileOutput.print(Fmath.truncate(d5, this.trunc), this.field);
        if (bl) {
            fileOutput.println(Fmath.truncate(d8, this.trunc));
        } else {
            fileOutput.println();
        }
        fileOutput.print(" Shapiro-Wilk P value: ", this.field0);
        fileOutput.print(Fmath.truncate(d6, this.trunc), this.field);
        if (bl) {
            fileOutput.println(Fmath.truncate(d9, this.trunc));
        } else {
            fileOutput.println();
        }
        fileOutput.print(" Data possibly Gaussian: ", this.field0);
        fileOutput.print(string2, this.field);
        if (bl) {
            fileOutput.println(string3);
        } else {
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.println("Probability plot:");
        fileOutput.print(" Correlation coefficient, r: ", this.field0);
        double d10 = arrayList.get(2);
        double d11 = Double.NaN;
        fileOutput.print(Fmath.truncate(d10, this.trunc), this.field);
        if (bl) {
            d11 = arrayList.get(6);
            fileOutput.println(Fmath.truncate(d11, this.trunc));
        } else {
            fileOutput.println();
        }
        fileOutput.println(" Critical value for r: ");
        fileOutput.print("  (" + this.significance * 100.0 + "% Significance level)", this.field0);
        double d12 = arrayList.get(3);
        double d13 = Double.NaN;
        fileOutput.print(Fmath.truncate(d12, this.trunc), this.field);
        if (bl) {
            d13 = arrayList.get(7);
            fileOutput.println(Fmath.truncate(d13, this.trunc));
        } else {
            fileOutput.println();
        }
        fileOutput.print(" Data possibly Gaussian: ", this.field0);
        String string5 = "Rejected";
        if (d10 >= d12) {
            string5 = "Accepted";
        }
        fileOutput.print(string5, this.field);
        if (bl) {
            string5 = "Rejected";
            if (d11 >= d13) {
                string5 = "Accepted";
            }
            fileOutput.println(string5);
        } else {
            fileOutput.println();
        }
        fileOutput.print(" Gradient: ", this.field0);
        fileOutput.print(Fmath.truncate(arrayList.get(0), this.trunc), this.field);
        if (bl) {
            fileOutput.println(Fmath.truncate(arrayList.get(4), this.trunc));
        } else {
            fileOutput.println();
        }
        fileOutput.print(" Intercept: ", this.field0);
        fileOutput.print(Fmath.truncate(arrayList.get(1), this.trunc), this.field);
        if (bl) {
            fileOutput.println(Fmath.truncate(arrayList.get(5), this.trunc));
        } else {
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.println("Input data: ");
        int n4 = 0;
        for (int i = 0; i < this.nPoints; ++i) {
            fileOutput.print(this.data[i] + "  ");
            if (++n4 != 10) continue;
            fileOutput.println();
            n4 = 0;
        }
        fileOutput.close();
    }

    public double[] strippedData(boolean bl, int n) {
        int[] nArray = new int[]{n};
        return this.strippedData(bl, 1, nArray);
    }

    public double[] strippedData(boolean bl, int n, int[] nArray) {
        this.strippedData = null;
        if (bl) {
            this.strippedData = new double[this.nPoints - n];
            int n2 = 0;
            for (int i = 0; i < this.nPoints; ++i) {
                boolean bl2 = true;
                for (int j = 0; j < n; ++j) {
                    if (i != nArray[j]) continue;
                    bl2 = false;
                }
                if (!bl2) continue;
                this.strippedData[n2] = this.data[i];
                ++n2;
            }
        } else {
            this.strippedData = DeepCopy.copy(this.data);
        }
        return this.strippedData;
    }

    public ArrayList<Double> probabilityPlots(boolean bl, double[] dArray, double[] dArray2) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ProbabilityPlot probabilityPlot = new ProbabilityPlot(dArray);
        probabilityPlot.setStartOfGraphTitle("Original data: ");
        probabilityPlot.resetSignificance(this.significance);
        probabilityPlot.suppressFileOutput();
        probabilityPlot.suppressErrorMessages();
        if (this.suppressDisplay) {
            probabilityPlot.suppressDisplay();
        }
        probabilityPlot.gaussianProbabilityPlot();
        arrayList.add(probabilityPlot.gaussianGradient());
        arrayList.add(probabilityPlot.gaussianIntercept());
        arrayList.add(probabilityPlot.gaussianCorrelationCoefficient());
        arrayList.add(probabilityPlot.correlationCoefficientCriticalValue());
        this.orderStatisticMedians = probabilityPlot.gaussianOrderStatisticMedians();
        this.strippedOrderStatisticMedians = this.orderStatisticMedians;
        if (bl) {
            probabilityPlot = new ProbabilityPlot(dArray2);
            probabilityPlot.setStartOfGraphTitle("Stripped data: ");
            probabilityPlot.resetSignificance(this.significance);
            probabilityPlot.suppressFileOutput();
            probabilityPlot.suppressErrorMessages();
            if (this.suppressDisplay) {
                probabilityPlot.suppressDisplay();
            }
            probabilityPlot.gaussianProbabilityPlot();
            arrayList.add(probabilityPlot.gaussianGradient());
            arrayList.add(probabilityPlot.gaussianIntercept());
            arrayList.add(probabilityPlot.gaussianCorrelationCoefficient());
            arrayList.add(probabilityPlot.correlationCoefficientCriticalValue());
            this.strippedOrderStatisticMedians = probabilityPlot.gaussianOrderStatisticMedians();
        }
        return arrayList;
    }

    public ArrayList<Object> shapiroWilkTest(double[] dArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Normality normality = new Normality(dArray);
        double d = normality.shapiroWilkWvalue();
        arrayList.add(d);
        double d2 = normality.shapiroWilkCriticalW();
        arrayList.add(d2);
        double d3 = normality.shapiroWilkPvalue();
        arrayList.add(d3);
        String string = "Rejected";
        if (d >= d2) {
            string = "Accepted";
        }
        arrayList.add(string);
        return arrayList;
    }
}

