/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.RegressionFunction;
import flanagan.math.Fmath;

class MultipleGaussianFunction
implements RegressionFunction {
    private boolean scaleOption = true;
    private double scaleFactor = 1.0;
    private int nGaussians = 1;

    MultipleGaussianFunction() {
    }

    @Override
    public double function(double[] dArray, double[] dArray2) {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < this.nGaussians; ++i) {
            d += dArray[n + 2] / (dArray[n + 1] * Math.sqrt(Math.PI * 2)) * Math.exp(-0.5 * Fmath.square((dArray2[0] - dArray[n]) / dArray[n + 1]));
            n += 3;
        }
        return d;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public void setScaleOption(boolean bl) {
        this.scaleOption = bl;
    }

    public void setNgaussians(int n) {
        this.nGaussians = n;
    }
}

