/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.RegressionFunction;
import flanagan.math.Fmath;

class LogisticFunction
implements RegressionFunction {
    private boolean scaleOption = true;
    private double scaleFactor = 1.0;

    LogisticFunction() {
    }

    @Override
    public double function(double[] dArray, double[] dArray2) {
        double d = this.scaleFactor;
        if (this.scaleOption) {
            d = dArray[2];
        }
        double d2 = d * Fmath.square(Fmath.sech((dArray2[0] - dArray[0]) / (2.0 * dArray[1]))) / (4.0 * dArray[1]);
        return d2;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public void setScaleOption(boolean bl) {
        this.scaleOption = bl;
    }
}

