/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.Stat;
import flanagan.math.Fmath;
import flanagan.math.MinimizationFunction;

class GaussStandardProbPlotFunc
implements MinimizationFunction {
    private double[] dataArray = null;
    private double[] medians = null;
    private double[] weights = null;
    private boolean weighted = false;

    GaussStandardProbPlotFunc() {
    }

    @Override
    public double function(double[] dArray) {
        int n = this.dataArray.length;
        if (this.weighted) {
            for (int i = 0; i < n; ++i) {
                this.weights[i] = 1.0 / Math.sqrt(Stat.gaussianPDF(dArray[0], dArray[1], this.dataArray[i]));
            }
        }
        this.medians = Stat.gaussianOrderStatisticMedians(n);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += Fmath.square((this.medians[i] - this.dataArray[i]) / this.weights[i]);
        }
        return d;
    }

    public void setDataArray(double[] dArray, double[] dArray2, boolean bl) {
        this.dataArray = dArray;
        this.weights = dArray2;
        this.weighted = bl;
    }
}

