/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.RegressionFunction3;

class ExponentialFunctionDual
implements RegressionFunction3 {
    private boolean scaleOption = true;
    private double scaleFactor = 1.0;
    private int typeFlag = 0;
    private double[][] xErrors = null;
    private double[] yErrors = null;

    ExponentialFunctionDual() {
    }

    @Override
    public double[] function(double[] dArray, double[] dArray2, int n) {
        double[] dArray3 = new double[2];
        boolean bl = false;
        double d = this.scaleFactor;
        switch (this.typeFlag) {
            case 0: {
                if (!(dArray2[0] >= dArray[0])) break;
                if (this.scaleOption) {
                    d = dArray[2];
                }
                double d2 = (dArray2[0] - dArray[0]) / dArray[1];
                dArray3[0] = d / dArray[1] * Math.exp(-d2);
                if (n < 0) break;
                dArray3[1] = -(d / dArray[1]) * Math.exp(-d2) / dArray[1];
                dArray3[1] = this.yErrors[n] * this.yErrors[n] + this.xErrors[0][n] * this.xErrors[0][n] * dArray3[1] * dArray3[1];
                break;
            }
            case 1: {
                if (!(dArray2[0] >= 0.0)) break;
                double d3 = dArray2[0] / dArray[0];
                if (this.scaleOption) {
                    d = dArray[1];
                }
                dArray3[0] = d / dArray[0] * Math.exp(-d3);
                if (n < 0) break;
                dArray3[1] = -(d / dArray[0]) * Math.exp(-d3) / dArray[0];
                dArray3[1] = this.yErrors[n] * this.yErrors[n] + this.xErrors[0][n] * this.xErrors[0][n] * dArray3[1] * dArray3[1];
                break;
            }
            case 2: {
                if (!(dArray2[0] >= 0.0)) break;
                double d4 = dArray2[0];
                if (this.scaleOption) {
                    d = dArray[0];
                }
                dArray3[0] = d * Math.exp(-d4);
                if (n < 0) break;
                dArray3[1] = -d * Math.exp(-d4);
                dArray3[1] = this.yErrors[n] * this.yErrors[n] + this.xErrors[0][n] * this.xErrors[0][n] * dArray3[1] * dArray3[1];
            }
        }
        return dArray3;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public void setScaleOption(boolean bl) {
        this.scaleOption = bl;
    }

    public void setTypeFlag(int n) {
        this.typeFlag = n;
    }

    public void setXerrors(double[][] dArray) {
        this.xErrors = dArray;
    }

    public void setYerrors(double[] dArray) {
        this.yErrors = dArray;
    }
}

