/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.RegressionFunction;

class ExponentialFunction
implements RegressionFunction {
    private boolean scaleOption = true;
    private double scaleFactor = 1.0;
    private int typeFlag = 0;

    ExponentialFunction() {
    }

    @Override
    public double function(double[] dArray, double[] dArray2) {
        double d = 0.0;
        boolean bl = false;
        double d2 = this.scaleFactor;
        switch (this.typeFlag) {
            case 0: {
                if (!(dArray2[0] >= dArray[0])) break;
                if (this.scaleOption) {
                    d2 = dArray[2];
                }
                double d3 = (dArray2[0] - dArray[0]) / dArray[1];
                d = d2 / dArray[1] * Math.exp(-d3);
                break;
            }
            case 1: {
                if (!(dArray2[0] >= 0.0)) break;
                double d4 = dArray2[0] / dArray[0];
                if (this.scaleOption) {
                    d2 = dArray[1];
                }
                d = d2 / dArray[0] * Math.exp(-d4);
                break;
            }
            case 2: {
                if (!(dArray2[0] >= 0.0)) break;
                double d5 = dArray2[0];
                if (this.scaleOption) {
                    d2 = dArray[0];
                }
                d = d2 * Math.exp(-d5);
            }
        }
        return d;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public void setScaleOption(boolean bl) {
        this.scaleOption = bl;
    }

    public void setTypeFlag(int n) {
        this.typeFlag = n;
    }
}

