/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.Scores;
import flanagan.analysis.Stat;
import flanagan.io.Db;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Fmath;
import java.text.DateFormat;
import java.util.Date;

public class Cronbach
extends Scores {
    private double rawAlpha = Double.NaN;
    private boolean rawAlphaCalculated = false;
    private double standardizedAlpha = Double.NaN;
    private boolean standardizedAlphaCalculated = false;
    private int deletedItemIndex = -1;
    private String deletedFilename = null;

    public double rawAlpha() {
        if (!this.rawAlphaCalculated) {
            if (this.nItems == 1) {
                System.out.println("Method rawAlpha: only one item - alpha cannot be calculated - NaN returned");
                this.rawAlpha = Double.NaN;
            } else {
                if (!this.dataPreprocessed) {
                    this.preprocessData();
                }
                double d = this.rawAllResponsesTotal * this.rawAllResponsesTotal;
                double d2 = 0.0;
                for (int i = 0; i < this.nItems; ++i) {
                    for (int j = 0; j < this.nPersons; ++j) {
                        d2 += this.scores1[j][i] * this.scores1[j][i];
                    }
                }
                double d3 = 0.0;
                for (int i = 0; i < this.nItems; ++i) {
                    d3 += this.rawItemTotals[i] * this.rawItemTotals[i] / (double)this.nPersons;
                }
                double d4 = 0.0;
                for (int i = 0; i < this.nPersons; ++i) {
                    d4 += this.rawPersonTotals[i] * this.rawPersonTotals[i] / (double)this.nItems;
                }
                double d5 = d4 - d / (double)this.nScores;
                double d6 = d2 - d3 - d4 + d / (double)this.nScores;
                int n = this.nItems - 1;
                int n2 = this.nPersons - 1;
                int n3 = n * n2;
                double d7 = d5 / (double)n2;
                double d8 = d6 / (double)n3;
                this.rawAlpha = (d7 - d8) / d7;
                this.rawAlphaCalculated = true;
            }
        }
        return this.rawAlpha;
    }

    public double standardizedAlpha() {
        if (!this.standardizedAlphaCalculated) {
            if (this.nItems == 1) {
                System.out.println("Method standardizedAlpha: only one item - alpha cannot be calculated - NaN returned");
                this.rawAlpha = Double.NaN;
            } else {
                if (!this.dataPreprocessed) {
                    this.preprocessData();
                }
                if (!this.covariancesCalculated) {
                    this.covariancesAndCorrelationCoefficients();
                }
                this.standardizedAlpha = (double)this.nItems * this.rawMeanRhoWithoutTotals / (1.0 + (double)(this.nItems - 1) * this.rawMeanRhoWithoutTotals);
                this.standardizedAlphaCalculated = true;
            }
        }
        return this.standardizedAlpha;
    }

    public double standardisedAlpha() {
        return this.standardizedAlpha();
    }

    public void analysis() {
        this.outputFilename = "CronbachOutput";
        this.outputFilename = this.fileOption == 1 ? this.outputFilename + ".txt" : this.outputFilename + ".xls";
        String string = "Output file name for the analysis details:";
        String string2 = "\nEnter the required name (as a single word) and click OK ";
        String string3 = "\nor simply click OK for default value";
        String string4 = string + string2 + string3;
        String string5 = this.outputFilename;
        this.outputFilename = Db.readLine(string4, string5);
        this.analysis(this.outputFilename);
    }

    public void analysis(String string) {
        this.outputFilename = string;
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(46);
        if (n == -1) {
            string2 = string;
            this.outputFilename = this.fileOption == 1 ? this.outputFilename + ".txt" : this.outputFilename + ".xls";
        } else {
            int n2;
            int n3;
            String[] stringArray;
            String[] stringArray2;
            String string4;
            String string5;
            String string6;
            String string7;
            string3 = string.substring(n).trim();
            string2 = string.substring(0, n).trim();
            if (string3.equalsIgnoreCase(".xls") && this.fileOption == 1) {
                if (this.fileOptionSet) {
                    string7 = "Your entered output file type is .xls";
                    string6 = "\nbut you have chosen a .txt output";
                    string5 = "Your output file name extension";
                    string4 = string7 + string6;
                    stringArray2 = new String[]{string4, "replace it with .txt [text file]"};
                    n2 = Db.optionBox(string5, stringArray2, stringArray = new String[]{"Retain", ".txt"}, n3 = 1);
                    if (n2 == 2) {
                        this.outputFilename = string2 + ".txt";
                    }
                } else {
                    this.fileOption = 2;
                }
            }
            if (string3.equalsIgnoreCase(".txt") && this.fileOption == 2) {
                if (this.fileOptionSet) {
                    string7 = "Your entered output file type is .txt";
                    string6 = "\nbut you have chosen a .xls output";
                    string5 = "Your output file name extension";
                    string4 = string7 + string6;
                    stringArray2 = new String[]{string4, "replace it with .xls [Excel file]"};
                    n2 = Db.optionBox(string5, stringArray2, stringArray = new String[]{"Retain", ".xls"}, n3 = 1);
                    if (n2 == 2) {
                        this.outputFilename = string2 + ".xls";
                    }
                } else {
                    this.fileOption = 1;
                }
            }
            if (!string3.equalsIgnoreCase(".txt") && !string3.equalsIgnoreCase(".xls")) {
                string7 = "Your extension is " + string3;
                string6 = "\n    Do you wish to retain it:";
                string4 = string7 + string6;
                string5 = "Your output file name extension";
                stringArray2 = new String[]{string4, "replace it with .txt [text file]", "replace it with .xls [MS Excel file]"};
                stringArray = new String[]{"Retain", ".txt", ".xls"};
                n3 = 1;
                n2 = Db.optionBox(string5, stringArray2, stringArray, n3);
                switch (n2) {
                    case 1: {
                        this.fileOption = 1;
                        break;
                    }
                    case 2: {
                        this.outputFilename = string2 + ".txt";
                        this.fileOption = 1;
                        break;
                    }
                    case 3: {
                        this.outputFilename = string2 + ".xls";
                        this.fileOption = 2;
                    }
                }
            }
        }
        if (this.fileOption == 1) {
            this.analysisText();
        } else {
            this.analysisExcel();
        }
    }

    private void analysisExcel() {
        int n;
        int n2;
        int n3;
        int n4;
        FileOutput fileOutput = null;
        fileOutput = this.fileNumberingSet ? new FileOutput(this.outputFilename, 'n') : new FileOutput(this.outputFilename);
        if (!this.rawAlphaCalculated) {
            this.rawAlpha();
        }
        if (!this.standardizedAlphaCalculated) {
            this.standardizedAlpha();
        }
        fileOutput.println("CRONBACH'S ALPHA RELIABILITY ESTIMATOR");
        fileOutput.println("Program: Cronbach - Analysis Output");
        for (int i = 0; i < this.titleLines; ++i) {
            fileOutput.println(this.title[i]);
        }
        Date date = new Date();
        String string = DateFormat.getDateInstance().format(date);
        String string2 = DateFormat.getTimeInstance().format(date);
        fileOutput.println("Program executed at " + string2 + " on " + string);
        fileOutput.println();
        fileOutput.println("RELIABILITY ESTIMATORS");
        fileOutput.println("Cronbach's coefficient alpha");
        fileOutput.printtab("Raw data                  ");
        fileOutput.println(Fmath.truncate(this.rawAlpha, this.trunc));
        fileOutput.printtab("Standardized data           ");
        fileOutput.println(Fmath.truncate(this.standardizedAlpha, this.trunc));
        fileOutput.println();
        fileOutput.println("Average of the inter-item correlation coefficients, excluding item totals");
        fileOutput.printtab("Raw data                  ");
        fileOutput.println(Fmath.truncate(this.rawMeanRhoWithoutTotals, this.trunc));
        fileOutput.printtab("Standardized data           ");
        fileOutput.println(Fmath.truncate(this.standardizedMeanRhoWithoutTotals, this.trunc));
        fileOutput.println();
        fileOutput.println("Average of the inter-item correlation coefficients, including item totals");
        fileOutput.printtab("Raw data                  ");
        fileOutput.println(Fmath.truncate(this.rawMeanRhoWithTotals, this.trunc));
        fileOutput.printtab("Standardized data           ");
        fileOutput.println(Fmath.truncate(this.standardizedMeanRhoWithTotals, this.trunc));
        fileOutput.println();
        fileOutput.println("'NO RESPONSE' DELETIONS AND REPLACEMENTS");
        boolean bl = false;
        if (this.nDeletedPersons != 0) {
            bl = true;
            fileOutput.printtab("Number of persons deleted ");
            fileOutput.println(this.nDeletedPersons);
            fileOutput.printtab("Indices of deleted persons: ");
            for (n4 = 0; n4 < this.nDeletedPersons; ++n4) {
                fileOutput.printtab(this.deletedPersonsIndices[n4] + 1);
            }
            fileOutput.println();
        } else {
            fileOutput.println("No persons were deleted ");
        }
        if (this.nDeletedItems != 0) {
            bl = true;
            fileOutput.printtab("Number of items deleted ");
            fileOutput.println(this.nDeletedItems);
            fileOutput.printtab("Names of deleted items: ");
            for (n4 = 0; n4 < this.nDeletedItems; ++n4) {
                fileOutput.printtab(this.originalItemNames[this.deletedItemsIndices[n4]]);
            }
            fileOutput.println();
        } else {
            fileOutput.println("No items were deleted ");
        }
        if (this.nReplacements != 0) {
            fileOutput.printtab("Number of 'no responses' replaced ");
            fileOutput.println(this.nReplacements);
            fileOutput.printtab("Item name and person index of replacements: ");
            for (n4 = 0; n4 < this.nReplacements; ++n4) {
                fileOutput.printtab(this.replacementIndices[n4] + " ");
            }
            fileOutput.println();
            fileOutput.printtab("Replacement option: ");
            fileOutput.println(this.replacementOptionNames[this.replacementOption - 1]);
            fileOutput.println();
        } else if (bl) {
            fileOutput.println("No 'no response' replacements, other than any above deletions, were made ");
        } else {
            fileOutput.println("No 'no response' replacements were made ");
        }
        fileOutput.println();
        fileOutput.printtab("Number of items used         ");
        fileOutput.println(this.nItems);
        fileOutput.printtab("Number of persons used   ");
        fileOutput.println(this.nPersons);
        fileOutput.println();
        fileOutput.println("CORRELATION COEFFICIENTS");
        fileOutput.println("Correlation coefficients between items  -  raw data");
        fileOutput.printtab("    ");
        for (n4 = 0; n4 <= this.nItems; ++n4) {
            fileOutput.printtab(this.itemNames[n4]);
        }
        fileOutput.println();
        for (n4 = 0; n4 <= this.nItems; ++n4) {
            fileOutput.printtab(this.itemNames[n4]);
            for (n3 = 0; n3 <= this.nItems; ++n3) {
                fileOutput.printtab(Fmath.truncate(this.rawCorrelationCoefficients[n4][n3], this.trunc));
            }
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.print("Average inter-item correlation coefficient (excluding total)                    ");
        fileOutput.println(Fmath.truncate(this.rawMeanRhoWithoutTotals, this.trunc));
        fileOutput.print("Standard deviation of the inter-item correlation coefficient (excluding total)  ");
        fileOutput.println(Fmath.truncate(this.rawStandardDeviationRhoWithoutTotals, this.trunc));
        fileOutput.print("Average inter-item correlation coefficient (including total)                    ");
        fileOutput.println(Fmath.truncate(this.rawMeanRhoWithTotals, this.trunc));
        fileOutput.print("Standard deviation of the inter-item correlation coefficient (including total)  ");
        fileOutput.println(Fmath.truncate(this.rawStandardDeviationRhoWithTotals, this.trunc));
        fileOutput.println();
        fileOutput.println("Correlation coefficients between items  -  standardized data");
        fileOutput.printtab("    ");
        for (n4 = 0; n4 <= this.nItems; ++n4) {
            fileOutput.printtab(this.itemNames[n4]);
        }
        fileOutput.println();
        for (n4 = 0; n4 <= this.nItems; ++n4) {
            fileOutput.printtab(this.itemNames[n4]);
            for (n3 = 0; n3 <= this.nItems; ++n3) {
                fileOutput.printtab(Fmath.truncate(this.standardizedCorrelationCoefficients[n4][n3], this.trunc));
            }
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.print("Average inter-item correlation coefficient (excluding total)                    ");
        fileOutput.println(Fmath.truncate(this.standardizedMeanRhoWithoutTotals, this.trunc));
        fileOutput.print("Standard deviation of the inter-item correlation coefficient (excluding total)  ");
        fileOutput.println(Fmath.truncate(this.standardizedStandardDeviationRhoWithoutTotals, this.trunc));
        fileOutput.print("Average inter-item correlation coefficient (including total)                    ");
        fileOutput.println(Fmath.truncate(this.standardizedMeanRhoWithTotals, this.trunc));
        fileOutput.print("Standard deviation of the inter-item correlation coefficient (including total)  ");
        fileOutput.println(Fmath.truncate(this.standardizedStandardDeviationRhoWithTotals, this.trunc));
        fileOutput.println();
        fileOutput.println("ITEMS: MEANS, STANDARD DEVIATIONS, SKEWNESS AND KURTOSIS");
        fileOutput.println("Raw data");
        fileOutput.printtab("item ");
        fileOutput.printtab("mean");
        fileOutput.printtab("standard");
        fileOutput.printtab("moment");
        fileOutput.printtab("median");
        fileOutput.printtab("quartile");
        fileOutput.printtab("kurtosis");
        fileOutput.println("dichotomous");
        fileOutput.printtab("    ");
        fileOutput.printtab("    ");
        fileOutput.printtab("deviation");
        fileOutput.printtab("skewness");
        fileOutput.printtab("skewness");
        fileOutput.printtab("skewness");
        fileOutput.printtab("excess  ");
        fileOutput.println("percentage");
        for (n4 = 0; n4 < this.nItems; ++n4) {
            fileOutput.printtab(this.itemNames[n4]);
            fileOutput.printtab(Fmath.truncate(this.rawItemMeans[n4], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.rawItemStandardDeviations[n4], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.rawItemMomentSkewness[n4], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.rawItemMedianSkewness[n4], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.rawItemQuartileSkewness[n4], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.rawItemKurtosisExcess[n4], this.trunc));
            fileOutput.println(Fmath.truncate(this.dichotomousPercentage[n4], 1));
        }
        fileOutput.println();
        fileOutput.println("ITEMS: MINIMA, MAXIMA, MEDIANS, RANGES AND TOTALS");
        fileOutput.println("raw data");
        fileOutput.printtab("item ");
        fileOutput.printtab("minimum");
        fileOutput.printtab("maximum");
        fileOutput.printtab("median");
        fileOutput.printtab("range");
        fileOutput.printtab("total");
        fileOutput.println("dichotomous");
        fileOutput.printtab("    ");
        fileOutput.printtab("    ");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        fileOutput.println("percentage");
        for (n4 = 0; n4 < this.nItems; ++n4) {
            fileOutput.printtab(this.itemNames[n4]);
            fileOutput.printtab(Fmath.truncate(this.rawItemMinima[n4], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.rawItemMaxima[n4], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.rawItemMedians[n4], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.rawItemRanges[n4], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.rawItemTotals[n4], this.trunc));
            fileOutput.println(Fmath.truncate(this.dichotomousPercentage[n4], 1));
        }
        fileOutput.println();
        fileOutput.printtab("item");
        fileOutput.printtab("mean");
        fileOutput.printtab("standard");
        fileOutput.printtab("variance");
        fileOutput.printtab("minimum");
        fileOutput.printtab("maximum");
        fileOutput.println("range");
        fileOutput.printtab("statistic    ");
        fileOutput.printtab("    ");
        fileOutput.printtab("deviation");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        fileOutput.println("     ");
        fileOutput.printtab("item means");
        fileOutput.printtab(Fmath.truncate(this.rawItemMeansMean, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemMeansSd, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemMeansVar, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemMeansMin, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemMeansMax, this.trunc));
        fileOutput.println(Fmath.truncate(this.rawItemMeansRange, this.trunc));
        fileOutput.printtab("item standard deviations");
        fileOutput.printtab(Fmath.truncate(this.rawItemStandardDeviationsMean, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemStandardDeviationsSd, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemStandardDeviationsVar, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemStandardDeviationsMin, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemStandardDeviationsMax, this.trunc));
        fileOutput.println(Fmath.truncate(this.rawItemStandardDeviationsRange, this.trunc));
        fileOutput.printtab("item variances");
        fileOutput.printtab(Fmath.truncate(this.rawItemVariancesMean, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemVariancesSd, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemVariancesVar, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemVariancesMin, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemVariancesMax, this.trunc));
        fileOutput.println(Fmath.truncate(this.rawItemVariancesRange, this.trunc));
        fileOutput.printtab("item mimima");
        fileOutput.printtab(Fmath.truncate(this.rawItemMinimaMean, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemMinimaSd, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemMinimaVar, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemMinimaMin, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemMinimaMax, this.trunc));
        fileOutput.println(Fmath.truncate(this.rawItemMinimaRange, this.trunc));
        fileOutput.printtab("item maxima");
        fileOutput.printtab(Fmath.truncate(this.rawItemMaximaMean, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemMaximaSd, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemMaximaVar, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemMaximaMin, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemMaximaMax, this.trunc));
        fileOutput.println(Fmath.truncate(this.rawItemMaximaRange, this.trunc));
        fileOutput.printtab("item medians");
        fileOutput.printtab(Fmath.truncate(this.rawItemMediansMean, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemMediansSd, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemMediansVar, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemMediansMin, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemMediansMax, this.trunc));
        fileOutput.println(Fmath.truncate(this.rawItemMediansRange, this.trunc));
        fileOutput.printtab("item ranges");
        fileOutput.printtab(Fmath.truncate(this.rawItemRangesMean, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemRangesSd, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemRangesVar, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemRangesMin, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemRangesMax, this.trunc));
        fileOutput.println(Fmath.truncate(this.rawItemRangesRange, this.trunc));
        fileOutput.printtab("item totals");
        fileOutput.printtab(Fmath.truncate(this.rawItemTotalsMean, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemTotalsSd, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemTotalsVar, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemTotalsMin, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawItemTotalsMax, this.trunc));
        fileOutput.println(Fmath.truncate(this.rawItemTotalsRange, this.trunc));
        fileOutput.println();
        fileOutput.println("Standardized data");
        fileOutput.println("ITEMS: MEANS, STANDARD DEVIATIONS, SKEWNESS AND KURTOSIS");
        fileOutput.printtab("item ");
        fileOutput.printtab("mean");
        fileOutput.printtab("standard");
        fileOutput.printtab("moment");
        fileOutput.printtab("median");
        fileOutput.printtab("quartile");
        fileOutput.println("kurtosis");
        fileOutput.printtab("    ");
        fileOutput.printtab("    ");
        fileOutput.printtab("deviation");
        fileOutput.printtab("skewness");
        fileOutput.printtab("skewness");
        fileOutput.printtab("skewness");
        fileOutput.println("excess  ");
        for (n4 = 0; n4 < this.nItems; ++n4) {
            fileOutput.printtab(this.itemNames[n4]);
            fileOutput.printtab(Fmath.truncate(this.standardizedItemMeans[n4], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.standardizedItemStandardDeviations[n4], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.standardizedItemMomentSkewness[n4], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.standardizedItemMedianSkewness[n4], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.standardizedItemQuartileSkewness[n4], this.trunc));
            fileOutput.println(Fmath.truncate(this.standardizedItemKurtosisExcess[n4], this.trunc));
        }
        fileOutput.println();
        fileOutput.println("ITEMS: MINIMA, MAXIMA, MEDIANS, RANGES AND TOTALS");
        fileOutput.println("Standardized data");
        fileOutput.printtab("item ");
        fileOutput.printtab("minimum");
        fileOutput.printtab("maximum");
        fileOutput.printtab("median");
        fileOutput.printtab("range");
        fileOutput.println("total");
        fileOutput.printtab("    ");
        fileOutput.printtab("    ");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        fileOutput.println("     ");
        for (n4 = 0; n4 < this.nItems; ++n4) {
            fileOutput.printtab(this.itemNames[n4]);
            fileOutput.printtab(Fmath.truncate(this.standardizedItemMinima[n4], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.standardizedItemMaxima[n4], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.standardizedItemMedians[n4], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.standardizedItemRanges[n4], this.trunc));
            fileOutput.println(Fmath.truncate(this.standardizedItemTotals[n4], this.trunc));
        }
        fileOutput.println();
        fileOutput.printtab("item");
        fileOutput.printtab("mean");
        fileOutput.printtab("standard");
        fileOutput.printtab("variance");
        fileOutput.printtab("minimum");
        fileOutput.printtab("maximum");
        fileOutput.println("range");
        fileOutput.printtab("statistic    ");
        fileOutput.printtab("    ");
        fileOutput.printtab("deviation");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        fileOutput.println("     ");
        fileOutput.printtab("item means");
        fileOutput.printtab(Fmath.truncate(this.standardizedItemMeansMean, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemMeansSd, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemMeansVar, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemMeansMin, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemMeansMax, this.trunc));
        fileOutput.println(Fmath.truncate(this.standardizedItemMeansRange, this.trunc));
        fileOutput.printtab("item standard deviations");
        fileOutput.printtab(Fmath.truncate(this.standardizedItemStandardDeviationsMean, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemStandardDeviationsSd, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemStandardDeviationsVar, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemStandardDeviationsMin, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemStandardDeviationsMax, this.trunc));
        fileOutput.println(Fmath.truncate(this.standardizedItemStandardDeviationsRange, this.trunc));
        fileOutput.printtab("item variances");
        fileOutput.printtab(Fmath.truncate(this.standardizedItemVariancesMean, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemVariancesSd, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemVariancesVar, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemVariancesMin, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemVariancesMax, this.trunc));
        fileOutput.println(Fmath.truncate(this.standardizedItemVariancesRange, this.trunc));
        fileOutput.printtab("item mimima");
        fileOutput.printtab(Fmath.truncate(this.standardizedItemMinimaMean, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemMinimaSd, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemMinimaVar, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemMinimaMin, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemMinimaMax, this.trunc));
        fileOutput.println(Fmath.truncate(this.standardizedItemMinimaRange, this.trunc));
        fileOutput.printtab("item maxima");
        fileOutput.printtab(Fmath.truncate(this.standardizedItemMaximaMean, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemMaximaSd, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemMaximaVar, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemMaximaMin, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemMaximaMax, this.trunc));
        fileOutput.println(Fmath.truncate(this.standardizedItemMaximaRange, this.trunc));
        fileOutput.print("item medians");
        fileOutput.print(Fmath.truncate(this.rawItemMediansMean, this.trunc));
        fileOutput.print(Fmath.truncate(this.rawItemMediansSd, this.trunc));
        fileOutput.print(Fmath.truncate(this.rawItemMediansVar, this.trunc));
        fileOutput.print(Fmath.truncate(this.rawItemMediansMin, this.trunc));
        fileOutput.print(Fmath.truncate(this.rawItemMediansMax, this.trunc));
        fileOutput.println(Fmath.truncate(this.rawItemMediansRange, this.trunc));
        fileOutput.printtab("item ranges");
        fileOutput.printtab(Fmath.truncate(this.standardizedItemRangesMean, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemRangesSd, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemRangesVar, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemRangesMin, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemRangesMax, this.trunc));
        fileOutput.println(Fmath.truncate(this.standardizedItemRangesRange, this.trunc));
        fileOutput.printtab("item totals");
        fileOutput.printtab(Fmath.truncate(this.standardizedItemTotalsMean, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemTotalsSd, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemTotalsVar, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemTotalsMin, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedItemTotalsMax, this.trunc));
        fileOutput.println(Fmath.truncate(this.standardizedItemTotalsRange, this.trunc));
        fileOutput.println();
        fileOutput.println("DELETION OF ITEMS");
        fileOutput.printtab("                ");
        fileOutput.printtab("Raw data        ");
        fileOutput.printtab("                ");
        fileOutput.printtab("                ");
        fileOutput.printtab("                ");
        fileOutput.println("Standardized data");
        fileOutput.printtab("Deleted item");
        fileOutput.printtab("Alpha       ");
        fileOutput.printtab("Correlation ");
        fileOutput.printtab("Average     ");
        fileOutput.printtab("Average     ");
        fileOutput.printtab("Alpha       ");
        fileOutput.printtab("Correlation ");
        fileOutput.printtab("Average     ");
        fileOutput.println("Average     ");
        fileOutput.printtab("           ");
        fileOutput.printtab("           ");
        fileOutput.printtab("coefficient");
        fileOutput.printtab("inter-item ");
        fileOutput.printtab("inter-item ");
        fileOutput.printtab("           ");
        fileOutput.printtab("coefficient ");
        fileOutput.printtab("inter-item ");
        fileOutput.println("inter-item ");
        fileOutput.printtab("           ");
        fileOutput.printtab("           ");
        fileOutput.printtab("with total ");
        fileOutput.printtab("correlation");
        fileOutput.printtab("correlation");
        fileOutput.printtab("           ");
        fileOutput.printtab("with total ");
        fileOutput.printtab("correlation");
        fileOutput.println("correlation");
        fileOutput.printtab("           ");
        fileOutput.printtab("           ");
        fileOutput.printtab("           ");
        fileOutput.printtab("coefficient");
        fileOutput.printtab("coefficient");
        fileOutput.printtab("           ");
        fileOutput.printtab("           ");
        fileOutput.printtab("coefficient");
        fileOutput.println("coefficient");
        fileOutput.printtab("              ");
        fileOutput.printtab("              ");
        fileOutput.printtab("              ");
        fileOutput.printtab("without totals");
        fileOutput.printtab("with totals   ");
        fileOutput.printtab("              ");
        fileOutput.printtab("              ");
        fileOutput.printtab("without totals");
        fileOutput.println("with totals   ");
        double[] dArray = new double[this.nItems];
        double[] dArray2 = new double[this.nItems];
        double[] dArray3 = new double[this.nItems];
        double[] dArray4 = new double[this.nItems];
        for (n2 = 0; n2 < this.nItems; ++n2) {
            double d;
            double d2;
            double d3;
            double d4;
            n = n2 + 1;
            double[][] dArray5 = this.deleteItem(n);
            Cronbach cronbach = new Cronbach();
            cronbach.enterScoresAsRowPerPerson(dArray5);
            dArray[n2] = d4 = cronbach.rawAlpha();
            double d5 = cronbach.rawAverageCorrelationCoefficientsWithTotals();
            double d6 = cronbach.rawAverageCorrelationCoefficients();
            double[] dArray6 = cronbach.rawPersonTotals();
            dArray3[n2] = d3 = Stat.corrCoeff(dArray6, this.scores0[n2]);
            dArray2[n2] = d2 = cronbach.standardizedAlpha();
            double d7 = cronbach.standardizedAverageCorrelationCoefficientsWithTotals();
            double d8 = cronbach.standardizedAverageCorrelationCoefficients();
            double[] dArray7 = cronbach.standardizedPersonTotals();
            dArray4[n2] = d = Stat.corrCoeff(dArray7, this.scores0[n2]);
            fileOutput.printtab(this.itemNames[n2]);
            fileOutput.printtab(Fmath.truncate(d4, this.trunc));
            fileOutput.printtab(Fmath.truncate(d3, this.trunc));
            fileOutput.printtab(Fmath.truncate(d6, this.trunc));
            fileOutput.printtab(Fmath.truncate(d5, this.trunc));
            fileOutput.printtab(Fmath.truncate(d2, this.trunc));
            fileOutput.printtab(Fmath.truncate(d, this.trunc));
            fileOutput.printtab(Fmath.truncate(d8, this.trunc));
            fileOutput.println(Fmath.truncate(d7, this.trunc));
        }
        fileOutput.println();
        fileOutput.printtab("No item deleted");
        fileOutput.printtab(Fmath.truncate(this.rawAlpha, this.trunc));
        fileOutput.printtab("   ");
        fileOutput.printtab(Fmath.truncate(this.rawMeanRhoWithoutTotals, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawMeanRhoWithTotals, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedAlpha, this.trunc));
        fileOutput.printtab("   ");
        fileOutput.printtab(Fmath.truncate(this.standardizedMeanRhoWithoutTotals, this.trunc));
        fileOutput.println(Fmath.truncate(this.standardizedMeanRhoWithTotals, this.trunc));
        fileOutput.println();
        this.deletedItemDataFile(dArray, dArray3, dArray2, dArray4);
        fileOutput.println("INDIVIDUALS - raw data");
        fileOutput.printtab("person ");
        fileOutput.printtab("mean");
        fileOutput.printtab("standard");
        fileOutput.printtab("minimum");
        fileOutput.printtab("maximum");
        fileOutput.printtab("range");
        fileOutput.printtab("total");
        fileOutput.println("scores:");
        fileOutput.printtab("    ");
        fileOutput.printtab("    ");
        fileOutput.printtab("deviation");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        for (n2 = 0; n2 < this.nItems; ++n2) {
            fileOutput.printtab(this.itemNames[n2]);
        }
        fileOutput.println();
        for (n2 = 0; n2 < this.nPersons; ++n2) {
            fileOutput.printtab(this.personIndices[n2] + 1);
            fileOutput.printtab(Fmath.truncate(this.rawPersonMeans[n2], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.rawPersonStandardDeviations[n2], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.rawPersonMinima[n2], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.rawPersonMaxima[n2], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.rawPersonRanges[n2], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.rawPersonTotals[n2], this.trunc));
            for (n = 0; n < this.nItems; ++n) {
                fileOutput.printtab(Fmath.truncate(this.scores1[n2][n], this.trunc));
            }
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.println("INDIVIDUALS - standardized data");
        fileOutput.printtab("person ");
        fileOutput.printtab("mean");
        fileOutput.printtab("standard");
        fileOutput.printtab("minimum");
        fileOutput.printtab("maximum");
        fileOutput.printtab("range");
        fileOutput.printtab("total");
        fileOutput.println("scores:");
        fileOutput.printtab("    ");
        fileOutput.printtab("    ");
        fileOutput.printtab("deviation");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        for (n2 = 0; n2 < this.nItems; ++n2) {
            fileOutput.printtab(this.itemNames[n2]);
        }
        fileOutput.println();
        for (n2 = 0; n2 < this.nPersons; ++n2) {
            fileOutput.printtab(this.personIndices[n2] + 1);
            fileOutput.printtab(Fmath.truncate(this.standardizedPersonMeans[n2], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.standardizedPersonStandardDeviations[n2], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.standardizedPersonMinima[n2], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.standardizedPersonMaxima[n2], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.standardizedPersonRanges[n2], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.standardizedPersonTotals[n2], this.trunc));
            for (n = 0; n < this.nItems; ++n) {
                fileOutput.printtab(Fmath.truncate(this.standardizedScores1[n2][n], this.trunc));
            }
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.println("ALL SCORES - raw data");
        fileOutput.printtab("mean");
        fileOutput.printtab("standard");
        fileOutput.printtab("minimum");
        fileOutput.printtab("maximum");
        fileOutput.printtab("range");
        fileOutput.println("overall");
        fileOutput.printtab("    ");
        fileOutput.printtab("deviation");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        fileOutput.println("total");
        fileOutput.printtab(Fmath.truncate(this.rawAllResponsesMean, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawAllResponsesStandardDeviation, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawAllResponsesMinimum, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawAllResponsesMaximum, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.rawAllResponsesRange, this.trunc));
        fileOutput.println(Fmath.truncate(this.rawAllResponsesTotal, this.trunc));
        fileOutput.println();
        fileOutput.println("ALL SCORES - standardized data");
        fileOutput.printtab("mean");
        fileOutput.printtab("standard");
        fileOutput.printtab("minimum");
        fileOutput.printtab("maximum");
        fileOutput.printtab("range");
        fileOutput.println("overall");
        fileOutput.printtab("    ");
        fileOutput.printtab("deviation");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        fileOutput.printtab("     ");
        fileOutput.println("total");
        fileOutput.printtab(Fmath.truncate(this.standardizedAllResponsesMean, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedAllResponsesStandardDeviation, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedAllResponsesMinimum, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedAllResponsesMaximum, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.standardizedAllResponsesRange, this.trunc));
        fileOutput.println(Fmath.truncate(this.standardizedAllResponsesTotal, this.trunc));
        fileOutput.println();
        fileOutput.close();
    }

    private void analysisText() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        FileOutput fileOutput = null;
        fileOutput = this.fileNumberingSet ? new FileOutput(this.outputFilename, 'n') : new FileOutput(this.outputFilename);
        if (!this.rawAlphaCalculated) {
            this.rawAlpha();
        }
        if (!this.standardizedAlphaCalculated) {
            this.standardizedAlpha();
        }
        fileOutput.println("CRONBACH'S ALPHA RELIABILITY ESTIMATOR");
        fileOutput.println("Program: Cronbach - Analysis Output");
        for (int i = 0; i < this.titleLines; ++i) {
            fileOutput.println(this.title[i]);
        }
        Date date = new Date();
        String string = DateFormat.getDateInstance().format(date);
        String string2 = DateFormat.getTimeInstance().format(date);
        fileOutput.println("Program executed at " + string2 + " on " + string);
        fileOutput.println();
        int n8 = 36;
        fileOutput.println("RELIABILITY ESTIMATORS");
        fileOutput.println("Cronbach's coefficient alpha");
        fileOutput.print("Raw data ", n8);
        fileOutput.println(Fmath.truncate(this.rawAlpha, this.trunc));
        fileOutput.print("Standardized data ", n8);
        fileOutput.println(Fmath.truncate(this.standardizedAlpha, this.trunc));
        fileOutput.println();
        fileOutput.println("Average of the inter-item correlation coefficients, excluding item totals");
        fileOutput.print("Raw data ", n8);
        fileOutput.println(Fmath.truncate(this.rawMeanRhoWithoutTotals, this.trunc));
        fileOutput.print("Standardized data ", n8);
        fileOutput.println(Fmath.truncate(this.standardizedMeanRhoWithoutTotals, this.trunc));
        fileOutput.println();
        fileOutput.println("Average of the inter-item correlation coefficients, including item totals");
        fileOutput.print("Raw data ", n8);
        fileOutput.println(Fmath.truncate(this.rawMeanRhoWithTotals, this.trunc));
        fileOutput.print("Standardized data ", n8);
        fileOutput.println(Fmath.truncate(this.standardizedMeanRhoWithTotals, this.trunc));
        fileOutput.println();
        fileOutput.println("'NO RESPONSE' DELETIONS AND REPLACEMENTS");
        n8 = 34;
        int n9 = 6;
        boolean bl = false;
        if (this.nDeletedPersons != 0) {
            bl = true;
            fileOutput.print("Number of persons deleted ", n8);
            fileOutput.println(this.nDeletedPersons);
            fileOutput.print("Indices of deleted persons: ", n8);
            for (n7 = 0; n7 < this.nDeletedPersons; ++n7) {
                fileOutput.print(this.deletedPersonsIndices[n7] + 1, n9);
            }
            fileOutput.println();
        } else {
            fileOutput.println("No persons were deleted ");
        }
        if (this.nDeletedItems != 0) {
            bl = true;
            fileOutput.print("Number of items deleted ", n8);
            fileOutput.println(this.nDeletedItems);
            fileOutput.print("Names of deleted items: ", n8);
            for (n7 = 0; n7 < this.nDeletedItems; ++n7) {
                fileOutput.print(this.originalItemNames[this.deletedItemsIndices[n7]], n9);
            }
            fileOutput.println();
        } else {
            fileOutput.println("No items were deleted ");
        }
        if (this.nReplacements != 0) {
            fileOutput.printtab("Number of 'no responses' replaced ");
            fileOutput.println(this.nReplacements);
            fileOutput.print("Item name and person index of replacements: ", 50);
            for (n7 = 0; n7 < this.nReplacements; ++n7) {
                fileOutput.print(this.replacementIndices[n7] + " ", n9);
            }
            fileOutput.println();
            fileOutput.print("Replacement option: ", n8);
            fileOutput.println(this.replacementOptionNames[this.replacementOption - 1]);
            fileOutput.println();
        } else if (bl) {
            fileOutput.println("No 'no response' replacements, other than any above deletions, were made ");
        } else {
            fileOutput.println("No 'no response' replacements were made ");
        }
        fileOutput.println();
        fileOutput.print("Number of items used", 35);
        fileOutput.println(this.nItems);
        fileOutput.print("Number of persons used", 35);
        fileOutput.println(this.nPersons);
        fileOutput.println();
        n7 = this.trunc + 8;
        int n10 = 0;
        for (n6 = 0; n6 <= this.nItems; ++n6) {
            if (this.itemNames[n6].length() <= n10) continue;
            n10 = this.itemNames[n6].length();
        }
        n6 = n10;
        if (n7 > n6) {
            n6 = n7;
        }
        ++n6;
        fileOutput.println("CORRELATION COEFFICIENTS");
        fileOutput.println("Correlation coefficients between items  -  raw data");
        fileOutput.print("    ", ++n10);
        for (n5 = 0; n5 <= this.nItems; ++n5) {
            fileOutput.print(this.itemNames[n5], n6);
        }
        fileOutput.println();
        for (n5 = 0; n5 <= this.nItems; ++n5) {
            fileOutput.print(this.itemNames[n5], n10);
            for (n4 = 0; n4 <= this.nItems; ++n4) {
                fileOutput.print(Fmath.truncate(this.rawCorrelationCoefficients[n5][n4], this.trunc), n6);
            }
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.print("Average inter-item correlation coefficient (excluding total) ", 80);
        fileOutput.println(Fmath.truncate(this.rawMeanRhoWithoutTotals, this.trunc));
        fileOutput.print("Standard deviation of the inter-item correlation coefficient (excluding total) ", 80);
        fileOutput.println(Fmath.truncate(this.rawStandardDeviationRhoWithoutTotals, this.trunc));
        fileOutput.print("Average inter-item correlation coefficient (including total) ", 80);
        fileOutput.println(Fmath.truncate(this.rawMeanRhoWithTotals, this.trunc));
        fileOutput.print("Standard deviation of the inter-item correlation coefficient (including total) ", 80);
        fileOutput.println(Fmath.truncate(this.rawStandardDeviationRhoWithTotals, this.trunc));
        fileOutput.println();
        fileOutput.println("Correlation coefficients between items  -  standardized data");
        fileOutput.print("    ", n10);
        for (n5 = 0; n5 <= this.nItems; ++n5) {
            fileOutput.print(this.itemNames[n5], n6);
        }
        fileOutput.println();
        for (n5 = 0; n5 <= this.nItems; ++n5) {
            fileOutput.print(this.itemNames[n5], n10);
            for (n4 = 0; n4 <= this.nItems; ++n4) {
                fileOutput.print(Fmath.truncate(this.standardizedCorrelationCoefficients[n5][n4], this.trunc), n6);
            }
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.print("Average inter-item correlation coefficient (excluding total) ", 80);
        fileOutput.println(Fmath.truncate(this.standardizedMeanRhoWithoutTotals, this.trunc));
        fileOutput.print("Standard deviation of the inter-item correlation coefficient (excluding total) ", 80);
        fileOutput.println(Fmath.truncate(this.standardizedStandardDeviationRhoWithoutTotals, this.trunc));
        fileOutput.print("Average inter-item correlation coefficient (including total) ", 80);
        fileOutput.println(Fmath.truncate(this.standardizedMeanRhoWithTotals, this.trunc));
        fileOutput.print("Standard deviation of the inter-item correlation coefficient (including total) ", 80);
        fileOutput.println(Fmath.truncate(this.standardizedStandardDeviationRhoWithTotals, this.trunc));
        fileOutput.println();
        if (n6 < 12) {
            n6 = 12;
        }
        fileOutput.println("ITEMS: MEANS, STANDARD DEVIATIONS, SKEWNESS AND KURTOSIS");
        fileOutput.println("Raw data");
        fileOutput.print("item ", n10);
        fileOutput.print("mean", n6);
        fileOutput.print("standard", n6);
        fileOutput.print("moment", n6);
        fileOutput.print("median", n6);
        fileOutput.print("quartile", n6);
        fileOutput.print("kurtosis", n6);
        fileOutput.println("dichotomous");
        fileOutput.print("    ", n10);
        fileOutput.print("    ", n6);
        fileOutput.print("deviation", n6);
        fileOutput.print("skewness", n6);
        fileOutput.print("skewness", n6);
        fileOutput.print("skewness", n6);
        fileOutput.print("excess  ", n6);
        fileOutput.println("percentage");
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.print(this.itemNames[n5], n10);
            fileOutput.print(Fmath.truncate(this.rawItemMeans[n5], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.rawItemStandardDeviations[n5], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.rawItemMomentSkewness[n5], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.rawItemMedianSkewness[n5], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.rawItemQuartileSkewness[n5], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.rawItemKurtosisExcess[n5], this.trunc), n6);
            fileOutput.println(Fmath.truncate(this.dichotomousPercentage[n5], 1));
        }
        fileOutput.println();
        fileOutput.println("ITEMS: MINIMA, MAXIMA, MEDIANS, RANGES AND TOTALS");
        fileOutput.println("Raw data");
        fileOutput.print("item ", n10);
        fileOutput.print("minimum", n6);
        fileOutput.print("maximum", n6);
        fileOutput.print("median", n6);
        fileOutput.print("range", n6);
        fileOutput.print("total", n6);
        fileOutput.println("dichotomous");
        fileOutput.print("    ", n10);
        fileOutput.print("    ", n6);
        fileOutput.print("     ", n6);
        fileOutput.print("     ", n6);
        fileOutput.print("     ", n6);
        fileOutput.print("     ", n6);
        fileOutput.println("percentage");
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.print(this.itemNames[n5], n10);
            fileOutput.print(Fmath.truncate(this.rawItemMinima[n5], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.rawItemMaxima[n5], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.rawItemMedians[n5], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.rawItemRanges[n5], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.rawItemTotals[n5], this.trunc), n6);
            fileOutput.println(Fmath.truncate(this.dichotomousPercentage[n5], 1));
        }
        fileOutput.println();
        n5 = 25;
        fileOutput.print("item", n5);
        fileOutput.print("mean", n6);
        fileOutput.print("standard", n6);
        fileOutput.print("variance", n6);
        fileOutput.print("minimum", n6);
        fileOutput.print("maximum", n6);
        fileOutput.println("range");
        fileOutput.print("statistic    ", n5);
        fileOutput.print("    ", n6);
        fileOutput.print("deviation", n6);
        fileOutput.print("     ", n6);
        fileOutput.print("     ", n6);
        fileOutput.print("     ", n6);
        fileOutput.print("     ", n6);
        fileOutput.println("     ");
        fileOutput.print("item means", n5);
        fileOutput.print(Fmath.truncate(this.rawItemMeansMean, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemMeansSd, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemMeansVar, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemMeansMin, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemMeansMax, this.trunc), n6);
        fileOutput.println(Fmath.truncate(this.rawItemMeansRange, this.trunc));
        fileOutput.print("item standard deviations", n5);
        fileOutput.print(Fmath.truncate(this.rawItemStandardDeviationsMean, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemStandardDeviationsSd, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemStandardDeviationsVar, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemStandardDeviationsMin, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemStandardDeviationsMax, this.trunc), n6);
        fileOutput.println(Fmath.truncate(this.rawItemStandardDeviationsRange, this.trunc));
        fileOutput.print("item variances", n5);
        fileOutput.print(Fmath.truncate(this.rawItemVariancesMean, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemVariancesSd, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemVariancesVar, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemVariancesMin, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemVariancesMax, this.trunc), n6);
        fileOutput.println(Fmath.truncate(this.rawItemVariancesRange, this.trunc));
        fileOutput.print("item mimima", n5);
        fileOutput.print(Fmath.truncate(this.rawItemMinimaMean, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemMinimaSd, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemMinimaVar, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemMinimaMin, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemMinimaMax, this.trunc), n6);
        fileOutput.println(Fmath.truncate(this.rawItemMinimaRange, this.trunc));
        fileOutput.print("item maxima", n5);
        fileOutput.print(Fmath.truncate(this.rawItemMaximaMean, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemMaximaSd, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemMaximaVar, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemMaximaMin, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemMaximaMax, this.trunc), n6);
        fileOutput.println(Fmath.truncate(this.rawItemMaximaRange, this.trunc));
        fileOutput.print("item medians", n5);
        fileOutput.print(Fmath.truncate(this.rawItemMediansMean, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemMediansSd, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemMediansVar, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemMediansMin, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemMediansMax, this.trunc), n6);
        fileOutput.println(Fmath.truncate(this.rawItemMediansRange, this.trunc));
        fileOutput.print("item ranges", n5);
        fileOutput.print(Fmath.truncate(this.rawItemRangesMean, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemRangesSd, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemRangesVar, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemRangesMin, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemRangesMax, this.trunc), n6);
        fileOutput.println(Fmath.truncate(this.rawItemRangesRange, this.trunc));
        fileOutput.print("item totals", n5);
        fileOutput.print(Fmath.truncate(this.rawItemTotalsMean, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemTotalsSd, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemTotalsVar, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemTotalsMin, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawItemTotalsMax, this.trunc), n6);
        fileOutput.println(Fmath.truncate(this.rawItemTotalsRange, this.trunc));
        fileOutput.println();
        fileOutput.println("standardized data");
        fileOutput.print("item ", n10);
        fileOutput.print("mean", n6);
        fileOutput.print("standard", n6);
        fileOutput.print("moment", n6);
        fileOutput.print("median", n6);
        fileOutput.print("quartile", n6);
        fileOutput.println("kurtosis");
        fileOutput.print("    ", n10);
        fileOutput.print("    ", n6);
        fileOutput.print("deviation", n6);
        fileOutput.print("skewness", n6);
        fileOutput.print("skewness", n6);
        fileOutput.print("skewness", n6);
        fileOutput.println("excess  ");
        for (n4 = 0; n4 < this.nItems; ++n4) {
            fileOutput.print(this.itemNames[n4], n10);
            fileOutput.print(Fmath.truncate(this.standardizedItemMeans[n4], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.standardizedItemStandardDeviations[n4], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.standardizedItemMomentSkewness[n4], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.standardizedItemMedianSkewness[n4], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.standardizedItemQuartileSkewness[n4], this.trunc), n6);
            fileOutput.println(Fmath.truncate(this.standardizedItemKurtosisExcess[n4], this.trunc));
        }
        fileOutput.println();
        fileOutput.print("item ", n10);
        fileOutput.print("minimum", n6);
        fileOutput.print("maximum", n6);
        fileOutput.print("median", n6);
        fileOutput.print("range", n6);
        fileOutput.println("total");
        fileOutput.print("    ", n10);
        fileOutput.print("    ", n6);
        fileOutput.print("     ", n6);
        fileOutput.print("     ", n6);
        fileOutput.print("     ", n6);
        fileOutput.println("     ");
        for (n4 = 0; n4 < this.nItems; ++n4) {
            fileOutput.print(this.itemNames[n4], n10);
            fileOutput.print(Fmath.truncate(this.standardizedItemMinima[n4], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.standardizedItemMaxima[n4], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.standardizedItemMedians[n4], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.standardizedItemRanges[n4], this.trunc), n6);
            fileOutput.println(Fmath.truncate(this.standardizedItemTotals[n4], this.trunc));
        }
        fileOutput.println();
        fileOutput.print("item", n5);
        fileOutput.print("mean", n6);
        fileOutput.print("standard", n6);
        fileOutput.print("variance", n6);
        fileOutput.print("minimum", n6);
        fileOutput.print("maximum", n6);
        fileOutput.println("range");
        fileOutput.print("statistic    ", n5);
        fileOutput.print("    ", n6);
        fileOutput.print("deviation", n6);
        fileOutput.print("     ", n6);
        fileOutput.print("     ", n6);
        fileOutput.print("     ", n6);
        fileOutput.print("     ", n6);
        fileOutput.println("     ");
        fileOutput.print("item means", n5);
        fileOutput.print(Fmath.truncate(this.standardizedItemMeansMean, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemMeansSd, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemMeansVar, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemMeansMin, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemMeansMax, this.trunc), n6);
        fileOutput.println(Fmath.truncate(this.standardizedItemMeansRange, this.trunc));
        fileOutput.print("item standard deviations", n5);
        fileOutput.print(Fmath.truncate(this.standardizedItemStandardDeviationsMean, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemStandardDeviationsSd, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemStandardDeviationsVar, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemStandardDeviationsMin, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemStandardDeviationsMax, this.trunc), n6);
        fileOutput.println(Fmath.truncate(this.standardizedItemStandardDeviationsRange, this.trunc));
        fileOutput.print("item variances", n5);
        fileOutput.print(Fmath.truncate(this.standardizedItemVariancesMean, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemVariancesSd, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemVariancesVar, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemVariancesMin, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemVariancesMax, this.trunc), n6);
        fileOutput.println(Fmath.truncate(this.standardizedItemVariancesRange, this.trunc));
        fileOutput.print("item mimima", n5);
        fileOutput.print(Fmath.truncate(this.standardizedItemMinimaMean, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemMinimaSd, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemMinimaVar, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemMinimaMin, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemMinimaMax, this.trunc), n6);
        fileOutput.println(Fmath.truncate(this.standardizedItemMinimaRange, this.trunc));
        fileOutput.print("item maxima", n5);
        fileOutput.print(Fmath.truncate(this.standardizedItemMaximaMean, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemMaximaSd, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemMaximaVar, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemMaximaMin, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemMaximaMax, this.trunc), n6);
        fileOutput.println(Fmath.truncate(this.standardizedItemMaximaRange, this.trunc));
        fileOutput.print("item medians", n5);
        fileOutput.print(Fmath.truncate(this.standardizedItemMediansMean, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemMediansSd, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemMediansVar, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemMediansMin, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemMediansMax, this.trunc), n6);
        fileOutput.println(Fmath.truncate(this.standardizedItemMediansRange, this.trunc));
        fileOutput.print("item ranges", n5);
        fileOutput.print(Fmath.truncate(this.standardizedItemRangesMean, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemRangesSd, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemRangesVar, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemRangesMin, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemRangesMax, this.trunc), n6);
        fileOutput.println(Fmath.truncate(this.standardizedItemRangesRange, this.trunc));
        fileOutput.print("item totals", n5);
        fileOutput.print(Fmath.truncate(this.standardizedItemTotalsMean, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemTotalsSd, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemTotalsVar, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemTotalsMin, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedItemTotalsMax, this.trunc), n6);
        fileOutput.println(Fmath.truncate(this.standardizedItemTotalsRange, this.trunc));
        fileOutput.println();
        fileOutput.println("DELETION OF ITEMS");
        n4 = 16;
        if (n10 > n4) {
            n4 = n10;
        }
        fileOutput.print("   ", n4);
        fileOutput.print("Raw data", n6);
        fileOutput.print("   ", n6);
        fileOutput.print("   ", n6);
        fileOutput.print("   ", n6);
        fileOutput.println("Standardized data");
        fileOutput.print("Deleted item", n4);
        fileOutput.print("Alpha", n6);
        fileOutput.print("Correlation", n6);
        fileOutput.print("Average", n6);
        fileOutput.print("Average", n6);
        fileOutput.print("Alpha", n6);
        fileOutput.print("Correlation", n6);
        fileOutput.print("Average", n6);
        fileOutput.println("Average");
        fileOutput.print("       ", n4);
        fileOutput.print("       ", n6);
        fileOutput.print("coefficient", n6);
        fileOutput.print("inter-item", n6);
        fileOutput.print("inter-item", n6);
        fileOutput.print("      ", n6);
        fileOutput.print("coefficient", n6);
        fileOutput.print("inter-item", n6);
        fileOutput.println("inter-item");
        fileOutput.print("       ", n4);
        fileOutput.print("       ", n6);
        fileOutput.print("with total", n6);
        fileOutput.print("correlation", n6);
        fileOutput.print("correlation", n6);
        fileOutput.print("      ", n6);
        fileOutput.print("with total", n6);
        fileOutput.print("correlation", n6);
        fileOutput.println("correlation");
        fileOutput.print("       ", n4);
        fileOutput.print("       ", n6);
        fileOutput.print("       ", n6);
        fileOutput.print("coefficient", n6);
        fileOutput.print("coefficient", n6);
        fileOutput.print("        ", n6);
        fileOutput.print("        ", n6);
        fileOutput.print("coefficient", n6);
        fileOutput.println("coefficient");
        fileOutput.print("       ", n4);
        fileOutput.print("       ", n6);
        fileOutput.print("       ", n6);
        fileOutput.print("without totals", n6);
        fileOutput.print("with totals", n6);
        fileOutput.print("        ", n6);
        fileOutput.print("        ", n6);
        fileOutput.print("without totals", n6);
        fileOutput.println("with totals");
        double[] dArray = new double[this.nItems];
        double[] dArray2 = new double[this.nItems];
        double[] dArray3 = new double[this.nItems];
        double[] dArray4 = new double[this.nItems];
        for (n3 = 0; n3 < this.nItems; ++n3) {
            double d;
            double d2;
            n2 = n3 + 1;
            double[][] dArray5 = this.deleteItem(n2);
            Cronbach cronbach = new Cronbach();
            cronbach.enterScoresAsRowPerPerson(dArray5);
            dArray[n3] = d2 = cronbach.rawAlpha();
            double d3 = cronbach.rawAverageCorrelationCoefficientsWithTotals();
            double[] dArray6 = cronbach.rawPersonTotals();
            double d4 = Stat.corrCoeff(dArray6, this.scores0[n3]);
            double d5 = cronbach.rawAverageCorrelationCoefficients();
            dArray3[n3] = d4;
            dArray2[n3] = d = cronbach.standardizedAlpha();
            double d6 = cronbach.standardizedAverageCorrelationCoefficients();
            double[] dArray7 = cronbach.standardizedPersonTotals();
            double d7 = Stat.corrCoeff(dArray7, this.scores0[n3]);
            double d8 = cronbach.standardizedAverageCorrelationCoefficients();
            dArray4[n3] = d7;
            fileOutput.print(this.itemNames[n3], n4);
            fileOutput.print(Fmath.truncate(d2, this.trunc), n6);
            fileOutput.print(Fmath.truncate(d4, this.trunc), n6);
            fileOutput.print(Fmath.truncate(d5, this.trunc), n6);
            fileOutput.print(Fmath.truncate(d3, this.trunc), n6);
            fileOutput.print(Fmath.truncate(d, this.trunc), n6);
            fileOutput.print(Fmath.truncate(d7, this.trunc), n6);
            fileOutput.print(Fmath.truncate(d8, this.trunc), n6);
            fileOutput.print(Fmath.truncate(d6, this.trunc), n6);
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.print("No item deleted", n4);
        fileOutput.print(Fmath.truncate(this.rawAlpha, this.trunc), n6);
        fileOutput.print("   ", n6);
        fileOutput.print(Fmath.truncate(this.rawMeanRhoWithoutTotals, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawMeanRhoWithTotals, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedAlpha, this.trunc), n6);
        fileOutput.print("   ", n6);
        fileOutput.print(Fmath.truncate(this.standardizedMeanRhoWithoutTotals, this.trunc), n6);
        fileOutput.println(Fmath.truncate(this.standardizedMeanRhoWithTotals, this.trunc));
        fileOutput.println();
        this.deletedItemDataFile(dArray, dArray3, dArray2, dArray4);
        n3 = 12;
        fileOutput.println("INDIVIDUALS - raw data");
        fileOutput.print("person", n3);
        fileOutput.print("mean", n6);
        fileOutput.print("standard", n6);
        fileOutput.print("minimum", n6);
        fileOutput.print("maximum", n6);
        fileOutput.print("range", n6);
        fileOutput.println("total");
        fileOutput.print("    ", n3);
        fileOutput.print("    ", n6);
        fileOutput.print("deviation", n6);
        fileOutput.print("     ", n6);
        fileOutput.print("     ", n6);
        fileOutput.print("     ", n6);
        fileOutput.println("     ");
        n2 = 0;
        for (n = 0; n < this.nItems; ++n) {
            for (int i = 0; i < this.nPersons; ++i) {
                int n11 = Double.toString(this.scores0[n][i]).length();
                if (n11 <= n2) continue;
                n2 = n11;
            }
        }
        if (++n2 < n10) {
            n2 = n10;
        }
        for (n = 0; n < this.nPersons; ++n) {
            fileOutput.print(this.personIndices[n] + 1, n3);
            fileOutput.print(Fmath.truncate(this.rawPersonMeans[n], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.rawPersonStandardDeviations[n], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.rawPersonMinima[n], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.rawPersonMaxima[n], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.rawPersonRanges[n], this.trunc), n6);
            fileOutput.println(Fmath.truncate(this.rawPersonTotals[n], this.trunc));
        }
        fileOutput.println();
        fileOutput.println("scores:");
        fileOutput.print("person ", n3);
        for (n = 0; n < this.nItems; ++n) {
            fileOutput.print(this.itemNames[n], n6);
        }
        fileOutput.println();
        for (n = 0; n < this.nPersons; ++n) {
            fileOutput.print(this.personIndices[n] + 1, n3);
            for (int i = 0; i < this.nItems; ++i) {
                fileOutput.print(Fmath.truncate(this.scores1[n][i], this.trunc), n6);
            }
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.println("INDIVIDUALS - standardized data");
        fileOutput.print("person ", n3);
        fileOutput.print("mean", n6);
        fileOutput.print("standard", n6);
        fileOutput.print("minimum", n6);
        fileOutput.print("maximum", n6);
        fileOutput.print("range", n6);
        fileOutput.println("total");
        fileOutput.print("    ", n3);
        fileOutput.print("    ", n6);
        fileOutput.print("deviation", n6);
        fileOutput.print("     ", n6);
        fileOutput.print("     ", n6);
        fileOutput.print("     ", n6);
        fileOutput.println("     ");
        for (n = 0; n < this.nPersons; ++n) {
            fileOutput.print(this.personIndices[n] + 1, n3);
            fileOutput.print(Fmath.truncate(this.standardizedPersonMeans[n], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.standardizedPersonStandardDeviations[n], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.standardizedPersonMinima[n], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.standardizedPersonMaxima[n], this.trunc), n6);
            fileOutput.print(Fmath.truncate(this.standardizedPersonRanges[n], this.trunc), n6);
            fileOutput.println(Fmath.truncate(this.standardizedPersonTotals[n], this.trunc));
        }
        fileOutput.println();
        fileOutput.println("scores:");
        fileOutput.print("person ", n3);
        for (n = 0; n < this.nItems; ++n) {
            fileOutput.print(this.itemNames[n], n6);
        }
        fileOutput.println();
        for (n = 0; n < this.nPersons; ++n) {
            fileOutput.print(this.personIndices[n] + 1, n3);
            for (int i = 0; i < this.nItems; ++i) {
                fileOutput.print(Fmath.truncate(this.standardizedScores1[n][i], this.trunc), n6);
            }
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.println("ALL SCORES - raw data");
        fileOutput.print("mean", n6);
        fileOutput.print("standard", n6);
        fileOutput.print("minimum", n6);
        fileOutput.print("maximum", n6);
        fileOutput.print("range", n6);
        fileOutput.println("overall");
        fileOutput.print("    ", n6);
        fileOutput.print("deviation", n6);
        fileOutput.print("     ", n6);
        fileOutput.print("     ", n6);
        fileOutput.print("     ", n6);
        fileOutput.println("total");
        fileOutput.print(Fmath.truncate(this.rawAllResponsesMean, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawAllResponsesStandardDeviation, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawAllResponsesMinimum, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawAllResponsesMaximum, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.rawAllResponsesRange, this.trunc), n6);
        fileOutput.println(Fmath.truncate(this.rawAllResponsesTotal, this.trunc));
        fileOutput.println();
        fileOutput.println("ALL SCORES - standardized data");
        fileOutput.print("mean", n6);
        fileOutput.print("standard", n6);
        fileOutput.print("minimum", n6);
        fileOutput.print("maximum", n6);
        fileOutput.print("range", n6);
        fileOutput.println("overall");
        fileOutput.print("    ", n6);
        fileOutput.print("deviation", n6);
        fileOutput.print("     ", n6);
        fileOutput.print("     ", n6);
        fileOutput.print("     ", n6);
        fileOutput.println("total");
        fileOutput.print(Fmath.truncate(this.standardizedAllResponsesMean, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedAllResponsesStandardDeviation, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedAllResponsesMinimum, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedAllResponsesMaximum, this.trunc), n6);
        fileOutput.print(Fmath.truncate(this.standardizedAllResponsesRange, this.trunc), n6);
        fileOutput.println(Fmath.truncate(this.standardizedAllResponsesTotal, this.trunc));
        fileOutput.println();
        fileOutput.close();
    }

    private void deletedItemDataFile(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n;
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        int n2 = arrayMaths.maximumIndex();
        arrayMaths = new ArrayMaths(dArray3);
        int n3 = arrayMaths.maximumIndex();
        arrayMaths = new ArrayMaths(dArray2);
        int n4 = arrayMaths.minimumIndex();
        arrayMaths = new ArrayMaths(dArray4);
        int n5 = arrayMaths.minimumIndex();
        this.deletedItemIndex = n4;
        if (n2 == n3 && n2 == n4 && n2 == n5) {
            this.deletedItemIndex = n2;
        } else if (n2 == n3 && (n2 == n4 || n2 == n5)) {
            this.deletedItemIndex = n2;
        } else if (n5 == n4 && (n5 == n2 || n5 == n3)) {
            this.deletedItemIndex = n5;
        } else if (n2 == n3 && n4 == n5) {
            this.deletedItemIndex = n4;
        } else if (n2 == n4 && n3 == n5) {
            this.deletedItemIndex = n2;
        } else if (n2 != n3 && n3 != n4 && n4 != n5) {
            this.deletedItemIndex = n4;
        }
        this.deletedFilename = null;
        if (this.inputFilename != null) {
            this.deletedFilename = this.inputFilename;
            int n6 = this.deletedFilename.indexOf(".");
            if (n6 != -1) {
                this.deletedFilename = this.deletedFilename.substring(0, n6);
            }
            this.deletedFilename = this.deletedFilename + "_" + this.itemNames[this.deletedItemIndex] + "_deleted";
            this.deletedFilename = this.deletedFilename + ".txt";
        } else {
            this.deletedFilename = "DeletedItemFile.txt";
        }
        FileOutput fileOutput = new FileOutput(this.deletedFilename);
        String string = this.title[0] + " - Item " + this.itemNames[this.deletedItemIndex] + " deleted";
        fileOutput.println(string);
        fileOutput.println(this.nItems - 1);
        fileOutput.println(this.nPersons);
        for (n = 0; n < this.nItems; ++n) {
            if (n == this.deletedItemIndex) continue;
            fileOutput.printtab(this.itemNames[n]);
        }
        fileOutput.println();
        if (this.originalDataType == 0) {
            for (n = 0; n < this.nItems; ++n) {
                if (n == this.deletedItemIndex) continue;
                for (int i = 0; i < this.nPersons; ++i) {
                    fileOutput.printtab(this.scores0[n][i]);
                }
                fileOutput.println();
            }
        } else {
            for (n = 0; n < this.nPersons; ++n) {
                for (int i = 0; i < this.nItems; ++i) {
                    if (i == this.deletedItemIndex) continue;
                    fileOutput.printtab(this.scores1[n][i]);
                }
                fileOutput.println();
            }
        }
        fileOutput.close();
    }

    public String getDeletionFileName() {
        return this.deletedFilename;
    }

    public String getLeastConsistentItemName() {
        return this.itemNames[this.deletedItemIndex];
    }
}

