/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.BoxCoxFunction;
import flanagan.analysis.Regression;
import flanagan.analysis.Stat;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Maximization;
import flanagan.math.MaximizationFunction;
import flanagan.plot.PlotGraph;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class BoxCox {
    private double[] originalData = null;
    private double[] sortedOriginalData = null;
    private double[] standardizedOriginalData = null;
    private Stat sod = null;
    private double[] shiftedStandardizedOriginalData = null;
    private int[] originalIndices = null;
    private int nData = 0;
    private double originalRange = 0.0;
    private double originalMinimum = 0.0;
    private double originalMaximum = 0.0;
    private double originalMean = 0.0;
    private double originalMedian = 0.0;
    private double originalStandardDeviation = 0.0;
    private double originalVariance = 0.0;
    private double originalMomentSkewness = 0.0;
    private double originalMedianSkewness = 0.0;
    private double originalQuartileSkewness = 0.0;
    private double originalExcessKurtosis = 0.0;
    private double standardizedOriginalRange = 0.0;
    private double standardizedOriginalMinimum = 0.0;
    private double standardizedOriginalMaximum = 0.0;
    private double standardizedOriginalMean = 0.0;
    private double standardizedOriginalMedian = 0.0;
    private double standardizedOriginalStandardDeviation = 1.0;
    private double standardizedOriginalVariance = 1.0;
    private double standardizedOriginalMomentSkewness = 0.0;
    private double standardizedOriginalMedianSkewness = 0.0;
    private double standardizedOriginalQuartileSkewness = 0.0;
    private double standardizedOriginalExcessKurtosis = 0.0;
    private double originalSampleR = 0.0;
    private double originalIntercept = 0.0;
    private double originalGradient = 0.0;
    private double originalInterceptError = 0.0;
    private double originalGradientError = 0.0;
    private boolean initializationDone = false;
    private double[] transformedData = null;
    private double[] standardizedTransformedData = null;
    private double[] scaledTransformedData = null;
    private double[] sortedScaledTransformedData = null;
    private double transformedRange = 0.0;
    private double transformedMinimum = 0.0;
    private double transformedMaximum = 0.0;
    private double transformedMean = 0.0;
    private double transformedStandardDeviation = 0.0;
    private double transformedMedian = 0.0;
    private double transformedVariance = 0.0;
    private double transformedMomentSkewness = 0.0;
    private double transformedMedianSkewness = 0.0;
    private double transformedQuartileSkewness = 0.0;
    private double transformedExcessKurtosis = 0.0;
    private double standardizedTransformedRange = 0.0;
    private double standardizedTransformedMinimum = 0.0;
    private double standardizedTransformedMaximum = 0.0;
    private double standardizedTransformedMean = 0.0;
    private double standardizedTransformedMedian = 0.0;
    private double standardizedTransformedStandardDeviation = 1.0;
    private double standardizedTransformedVariance = 1.0;
    private double standardizedTransformedMomentSkewness = 0.0;
    private double standardizedTransformedMedianSkewness = 0.0;
    private double standardizedTransformedQuartileSkewness = 0.0;
    private double standardizedTransformedExcessKurtosis = 0.0;
    private double[] inverseData = null;
    private double lambdaThree = 0.0;
    private double lambdaOne = 0.0;
    private double lambdaTwo = 0.0;
    private double transformedSampleR = 0.0;
    private double transformedIntercept = 0.0;
    private double transformedGradient = 0.0;
    private double transformedInterceptError = 0.0;
    private double transformedGradientError = 0.0;
    private double[] uniformOrderMedians = null;
    private double[] gaussianOrderMedians = null;
    private boolean transformDone = false;
    private boolean inverseDone = false;

    public BoxCox(double[] dArray) {
        this.sod = new Stat(dArray);
    }

    public BoxCox(float[] fArray) {
        this.sod = new Stat(fArray);
    }

    public BoxCox(int[] nArray) {
        this.sod = new Stat(nArray);
    }

    public BoxCox(long[] lArray) {
        this.sod = new Stat(lArray);
    }

    public BoxCox(short[] sArray) {
        this.sod = new Stat(sArray);
    }

    public BoxCox(byte[] byArray) {
        this.sod = new Stat(byArray);
    }

    public BoxCox(BigDecimal[] bigDecimalArray) {
        this.sod = new Stat(bigDecimalArray);
    }

    public BoxCox(BigInteger[] bigIntegerArray) {
        this.sod = new Stat(bigIntegerArray);
    }

    public BoxCox(Stat stat) {
        this.sod = stat;
    }

    public BoxCox(ArrayMaths arrayMaths) {
        double[] dArray = arrayMaths.array();
        this.sod = new Stat(dArray);
    }

    public BoxCox(ArrayList<Object> arrayList) {
        this.sod = new Stat(arrayList);
    }

    public BoxCox(Vector<Object> vector) {
        this.sod = new Stat(vector);
    }

    public void setDenominatorToN() {
        Stat.setStaticDenominatorToN();
    }

    private void initialize() {
        this.originalData = this.sod.array_as_double();
        this.originalMinimum = this.sod.minimum();
        this.originalMaximum = this.sod.maximum();
        this.originalMedian = this.sod.median();
        if (this.originalMinimum == this.originalMaximum) {
            throw new IllegalArgumentException("A Box-Cox transformation cannot be performed on a data array of identical values");
        }
        this.originalRange = this.originalMaximum - this.originalMinimum;
        this.originalMean = this.sod.mean();
        this.originalStandardDeviation = this.sod.standardDeviation();
        this.originalVariance = this.sod.variance();
        this.originalMomentSkewness = this.sod.momentSkewness();
        this.originalMedianSkewness = this.sod.medianSkewness();
        this.originalQuartileSkewness = this.sod.quartileSkewness();
        this.originalExcessKurtosis = this.sod.excessKurtosis();
        ArrayMaths arrayMaths = this.sod.sort();
        this.sortedOriginalData = arrayMaths.array();
        this.originalIndices = arrayMaths.originalIndices();
        this.standardizedOriginalData = this.sod.standardize();
        this.standardizedOriginalMinimum = this.sod.minimum();
        this.standardizedOriginalMaximum = this.sod.maximum();
        this.standardizedOriginalMedian = this.sod.median();
        this.standardizedOriginalRange = this.standardizedOriginalMaximum - this.standardizedOriginalMinimum;
        this.standardizedOriginalMean = 0.0;
        this.standardizedOriginalStandardDeviation = 1.0;
        this.standardizedOriginalVariance = 1.0;
        this.standardizedOriginalMomentSkewness = this.sod.momentSkewness();
        this.standardizedOriginalMedianSkewness = this.sod.medianSkewness();
        this.standardizedOriginalQuartileSkewness = this.sod.quartileSkewness();
        this.standardizedOriginalExcessKurtosis = this.sod.excessKurtosis();
        this.nData = this.originalData.length;
        this.uniformOrderMedians = Stat.uniformOrderStatisticMedians(this.nData);
        this.gaussianOrderMedians = Stat.gaussianOrderStatisticMedians(this.nData);
        Regression regression = new Regression(this.gaussianOrderMedians, new ArrayMaths(this.standardizedOriginalData).sort().array());
        regression.linear();
        this.originalSampleR = regression.getSampleR();
        double[] dArray = regression.getBestEstimates();
        this.originalIntercept = dArray[0];
        this.originalGradient = dArray[1];
        dArray = regression.getBestEstimatesErrors();
        this.originalInterceptError = dArray[0];
        this.originalGradientError = dArray[1];
        this.initializationDone = true;
    }

    private double[] transform() {
        int n;
        if (!this.initializationDone) {
            this.initialize();
        }
        this.lambdaTwo = 0.1 * this.standardizedOriginalRange - this.standardizedOriginalMinimum;
        ArrayMaths arrayMaths = this.sod.plus(this.lambdaTwo);
        this.shiftedStandardizedOriginalData = arrayMaths.getArray_as_double();
        BoxCoxFunction boxCoxFunction = new BoxCoxFunction();
        boxCoxFunction.shiftedData = this.shiftedStandardizedOriginalData;
        boxCoxFunction.nData = this.nData;
        boxCoxFunction.yTransform = new double[this.nData];
        boxCoxFunction.gaussianOrderMedians = this.gaussianOrderMedians;
        Maximization maximization = new Maximization();
        double[] dArray = new double[]{1.0};
        double[] dArray2 = new double[]{0.3};
        double d = 1.0E-9;
        maximization.nelderMead((MaximizationFunction)boxCoxFunction, dArray, dArray2, d);
        double[] dArray3 = maximization.getParamValues();
        double d2 = dArray3[0];
        double d3 = maximization.getMaximum();
        dArray[0] = d2 - (dArray[0] - d2);
        maximization.nelderMead((MaximizationFunction)boxCoxFunction, dArray, dArray2, d);
        dArray3 = maximization.getParamValues();
        this.lambdaOne = dArray3[0];
        this.transformedSampleR = maximization.getMaximum();
        if (d3 > this.transformedSampleR) {
            this.transformedSampleR = d3;
            this.lambdaOne = d2;
        }
        this.transformedData = new double[this.nData];
        if (this.lambdaOne == 0.0) {
            for (n = 0; n < this.nData; ++n) {
                this.transformedData[n] = Math.exp(this.shiftedStandardizedOriginalData[n]);
            }
        } else {
            for (n = 0; n < this.nData; ++n) {
                this.transformedData[n] = (Math.pow(this.shiftedStandardizedOriginalData[n], this.lambdaOne) - 1.0) / this.lambdaOne;
            }
        }
        this.standardizedTransformedData = new Stat(this.transformedData).standardize();
        this.standardizedTransformedDataStatistics(this.standardizedTransformedData);
        ArrayMaths arrayMaths2 = new ArrayMaths(this.standardizedTransformedData);
        arrayMaths2 = arrayMaths2.sort();
        double[] dArray4 = arrayMaths2.array();
        Regression regression = new Regression(this.gaussianOrderMedians, dArray4);
        regression.linear();
        dArray3 = regression.getBestEstimates();
        this.transformedIntercept = dArray3[0];
        this.transformedGradient = dArray3[1];
        dArray3 = regression.getBestEstimatesErrors();
        this.transformedInterceptError = dArray3[0];
        this.transformedGradientError = dArray3[1];
        this.scaledTransformedData = Stat.scale(this.standardizedTransformedData, this.originalMean, this.originalStandardDeviation);
        this.transformedDataStatistics(this.scaledTransformedData);
        this.transformDone = true;
        return this.transformedData;
    }

    private void transformedDataStatistics(double[] dArray) {
        Stat stat = new Stat(dArray);
        this.transformedMinimum = stat.minimum();
        this.transformedMaximum = stat.maximum();
        this.transformedMedian = stat.median();
        this.transformedRange = this.transformedMaximum - this.transformedMinimum;
        this.transformedMean = stat.mean();
        this.transformedStandardDeviation = stat.standardDeviation();
        this.transformedVariance = stat.variance();
        this.transformedMomentSkewness = stat.momentSkewness();
        this.transformedMedianSkewness = stat.medianSkewness();
        this.transformedQuartileSkewness = stat.quartileSkewness();
        this.transformedExcessKurtosis = stat.excessKurtosis();
        Stat stat2 = new Stat(dArray);
        this.sortedScaledTransformedData = stat2.sort().array();
    }

    private void standardizedTransformedDataStatistics(double[] dArray) {
        Stat stat = new Stat(dArray);
        this.standardizedTransformedMinimum = stat.minimum();
        this.standardizedTransformedMaximum = stat.maximum();
        this.standardizedTransformedMedian = stat.median();
        this.standardizedTransformedRange = this.standardizedTransformedMaximum - this.standardizedTransformedMinimum;
        this.standardizedTransformedMean = 0.0;
        this.standardizedTransformedStandardDeviation = 1.0;
        this.standardizedTransformedVariance = 1.0;
        this.standardizedTransformedMomentSkewness = stat.momentSkewness();
        this.standardizedTransformedMedianSkewness = stat.medianSkewness();
        this.standardizedTransformedQuartileSkewness = stat.quartileSkewness();
        this.standardizedTransformedExcessKurtosis = stat.excessKurtosis();
    }

    public double[] inverseTransform(double d, double d2) {
        int n;
        this.lambdaOne = d;
        this.lambdaTwo = d2;
        if (!this.initializationDone) {
            this.initialize();
        }
        if (this.originalData == null) {
            throw new IllegalArgumentException("No data has been entered (via a constructor)");
        }
        this.inverseData = new double[this.nData];
        double[] dArray = Conv.copy(this.originalData);
        if (this.originalMinimum < 0.0 && Fmath.isNaN(Math.pow(this.originalMinimum * this.lambdaOne + 1.0, 1.0 / this.lambdaOne))) {
            this.lambdaThree = -0.999 / this.lambdaOne - this.originalMinimum;
            n = 0;
            while (n < this.nData) {
                int n2 = n++;
                dArray[n2] = dArray[n2] + this.lambdaThree;
            }
        }
        if (this.lambdaOne == 0.0) {
            for (n = 0; n < this.nData; ++n) {
                this.inverseData[n] = Math.exp(dArray[n]) - this.lambdaTwo;
            }
        } else {
            for (n = 0; n < this.nData; ++n) {
                this.inverseData[n] = Math.pow(dArray[n] * this.lambdaOne + 1.0, 1.0 / this.lambdaOne) - this.lambdaTwo;
            }
        }
        this.transformedData = Conv.copy(this.inverseData);
        this.transformedDataStatistics(this.inverseData);
        this.standardizedTransformedData = new Stat(this.transformedData).standardize();
        this.standardizedTransformedDataStatistics(this.standardizedTransformedData);
        this.inverseDone = true;
        return this.inverseData;
    }

    public double[] inverseTransform(double d) {
        return this.inverseTransform(d, 0.0);
    }

    public double[] fixedValueTransform(double d, double d2) {
        int n;
        this.lambdaOne = d;
        this.lambdaTwo = d2;
        if (!this.initializationDone) {
            this.initialize();
        }
        if (this.originalData == null) {
            throw new IllegalArgumentException("No data has been entered (via a constructor)");
        }
        if (this.originalMinimum + this.lambdaTwo < 0.0) {
            throw new IllegalArgumentException("Negative (data plus lambdaTwo) value, " + (this.originalMinimum + this.lambdaTwo));
        }
        this.transformedData = new double[this.nData];
        if (this.lambdaOne == 0.0) {
            for (n = 0; n < this.nData; ++n) {
                this.transformedData[n] = Math.exp(this.shiftedStandardizedOriginalData[n]);
            }
        } else {
            for (n = 0; n < this.nData; ++n) {
                this.transformedData[n] = (Math.pow(this.shiftedStandardizedOriginalData[n], this.lambdaOne) - 1.0) / this.lambdaOne;
            }
        }
        this.standardizedTransformedData = new Stat(this.transformedData).standardize();
        this.standardizedTransformedDataStatistics(this.standardizedTransformedData);
        ArrayMaths arrayMaths = new ArrayMaths(this.standardizedTransformedData);
        arrayMaths = arrayMaths.sort();
        double[] dArray = arrayMaths.array();
        Regression regression = new Regression(this.gaussianOrderMedians, dArray);
        regression.linear();
        double[] dArray2 = regression.getBestEstimates();
        this.transformedIntercept = dArray2[0];
        this.transformedGradient = dArray2[1];
        this.scaledTransformedData = Stat.scale(this.standardizedTransformedData, this.originalMean, this.originalStandardDeviation);
        this.transformedDataStatistics(this.scaledTransformedData);
        this.transformDone = true;
        return this.transformedData;
    }

    public double[] fixedValueTransform(double d) {
        return this.fixedValueTransform(d, 0.0);
    }

    public double lambdaOne() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.lambdaOne;
    }

    public double lambdaTwo() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.lambdaTwo;
    }

    public double lambdaThree() {
        if (!this.inverseDone) {
            System.out.println("BoxCox: method lambdaThree: no inverse transform has been performed, zero returned");
        }
        return this.lambdaThree;
    }

    public double transformedCorrelationCoefficient() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedSampleR;
    }

    public double transformedGradient() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedGradient;
    }

    public double transformedGradientError() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedGradientError;
    }

    public double transformedIntercept() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedIntercept;
    }

    public double transformedInterceptError() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedInterceptError;
    }

    public double originalCorrelationCoefficient() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalSampleR;
    }

    public double originalGradient() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalGradient;
    }

    public double originalGradientError() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalGradientError;
    }

    public double originalIntercept() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalIntercept;
    }

    public double originalInterceptError() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalInterceptError;
    }

    public double[] originalData() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalData;
    }

    public double[] standardizedOriginalData() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.standardizedOriginalData;
    }

    public double[] sortedOriginalData() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.sortedOriginalData;
    }

    public double[] shiftedStandardizedOriginalata() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.shiftedStandardizedOriginalData;
    }

    public double[] transformedData() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedData;
    }

    public double[] scaledTransformedData() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.scaledTransformedData;
    }

    public double[] standardizedTransformedData() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.standardizedTransformedData;
    }

    public double[] orderedTransformedData() {
        if (!this.transformDone) {
            this.transform();
        }
        ArrayMaths arrayMaths = new ArrayMaths(this.transformedData);
        double[] dArray = arrayMaths.sort().array();
        return dArray;
    }

    public double[] orderedScaledTransformedData() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.sortedScaledTransformedData;
    }

    public double originalMean() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalMean;
    }

    public double originalMedian() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalMedian;
    }

    public double originalStandardDeviation() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalStandardDeviation;
    }

    public double originalStandardError() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalStandardDeviation / Math.sqrt(this.nData);
    }

    public double originalVariance() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalVariance;
    }

    public double originalMomentSkewness() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalMomentSkewness;
    }

    public double originalMedianSkewness() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalMedianSkewness;
    }

    public double originalQuartiletSkewness() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalQuartileSkewness;
    }

    public double originalExcessKurtosis() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalExcessKurtosis;
    }

    public double originalMaximum() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalMaximum;
    }

    public double originalMinimum() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalMinimum;
    }

    public double originalRange() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalRange;
    }

    public double transformedMean() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedMean;
    }

    public double transformedMedian() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedMedian;
    }

    public double transformedStandardDeviation() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedStandardDeviation;
    }

    public double transformedStandardError() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedStandardDeviation / Math.sqrt(this.nData);
    }

    public double transformedVariance() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedVariance;
    }

    public double transformedMomentSkewness() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedMomentSkewness;
    }

    public double transformedMedianSkewness() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedMedianSkewness;
    }

    public double transformedQuartileSkewness() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedQuartileSkewness;
    }

    public double transformedExcessKurtosis() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedExcessKurtosis;
    }

    public double transformedMaximum() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedMaximum;
    }

    public double transformedMinimum() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedMinimum;
    }

    public double transformedRange() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedRange;
    }

    public void transformedProbabilityPlot() {
        if (!this.transformDone) {
            this.transform();
        }
        double[][] dArray = PlotGraph.data(2, this.nData);
        dArray[0] = this.gaussianOrderMedians;
        dArray[1] = new ArrayMaths(this.standardizedTransformedData).sort().array();
        dArray[2] = this.gaussianOrderMedians;
        for (int i = 0; i < this.nData; ++i) {
            dArray[3][i] = this.transformedIntercept + this.transformedGradient * this.gaussianOrderMedians[i];
        }
        PlotGraph plotGraph = new PlotGraph(dArray);
        int[] nArray = new int[]{4, 0};
        plotGraph.setPoint(nArray);
        int[] nArray2 = new int[]{0, 3};
        plotGraph.setLine(nArray2);
        plotGraph.setXaxisLegend("Gaussian [0,1] Order Statistic Medians");
        plotGraph.setYaxisLegend("Ordered Response Values");
        String string = "Gausssian probability plot:  Box-Cox transformed data";
        String string2 = "lambdaOne = " + Fmath.truncate(this.lambdaOne, 4) + ",  lambdaTwo = " + Fmath.truncate(this.lambdaTwo, 4) + ",   gradient = " + Fmath.truncate(this.transformedGradient, 4) + ", intercept = " + Fmath.truncate(this.transformedIntercept, 4) + ",  R = " + Fmath.truncate(this.transformedSampleR, 4);
        plotGraph.setGraphTitle(string);
        plotGraph.setGraphTitle2(string2);
        plotGraph.plot();
    }

    public void originalProbabilityPlot() {
        if (!this.initializationDone) {
            this.initialize();
        }
        double[][] dArray = PlotGraph.data(2, this.nData);
        dArray[0] = this.gaussianOrderMedians;
        dArray[1] = new ArrayMaths(this.standardizedOriginalData).sort().array();
        dArray[2] = this.gaussianOrderMedians;
        for (int i = 0; i < this.nData; ++i) {
            dArray[3][i] = this.originalIntercept + this.originalGradient * this.gaussianOrderMedians[i];
        }
        PlotGraph plotGraph = new PlotGraph(dArray);
        int[] nArray = new int[]{4, 0};
        plotGraph.setPoint(nArray);
        int[] nArray2 = new int[]{0, 3};
        plotGraph.setLine(nArray2);
        plotGraph.setXaxisLegend("Gaussian [0,1] Order Statistic Medians");
        plotGraph.setYaxisLegend("Ordered Response Values");
        String string = "Gausssian probability plot: original data for a Box-Cox transformation";
        String string2 = "gradient = " + Fmath.truncate(this.originalGradient, 4) + ", intercept = " + Fmath.truncate(this.originalIntercept, 4) + ",  R = " + Fmath.truncate(this.originalSampleR, 4);
        plotGraph.setGraphTitle(string);
        plotGraph.setGraphTitle2(string2);
        plotGraph.plot();
    }

    public void analysis() {
        this.analysis("BoxCoxAnalysis.txt");
    }

    public void analysis(String string) {
        if (!this.transformDone) {
            this.transform();
        }
        this.originalProbabilityPlot();
        this.transformedProbabilityPlot();
        int n = string.indexOf(".");
        if (n == -1) {
            string = string + ".txt";
        }
        FileOutput fileOutput = new FileOutput(string);
        fileOutput.println("Box-Cox Analysis");
        fileOutput.println("File name:   " + string);
        Date date = new Date();
        String string2 = DateFormat.getDateInstance().format(date);
        String string3 = DateFormat.getTimeInstance().format(date);
        fileOutput.println("Program executed at " + string3 + " on " + string2);
        fileOutput.println();
        int n2 = 30;
        int n3 = 15;
        fileOutput.print("Box-Cox lambda one", n2);
        fileOutput.println(Fmath.truncate(this.lambdaOne, 4));
        fileOutput.print("Box-Cox lambda two", n2);
        fileOutput.println(Fmath.truncate(this.lambdaTwo, 4));
        fileOutput.println();
        fileOutput.print("  ", n2);
        fileOutput.print("Transformed", n3);
        fileOutput.print("  ", n3);
        fileOutput.println("Original   ");
        fileOutput.print("  ", n2);
        fileOutput.print("scaled data", n3);
        fileOutput.print("  ", n3);
        fileOutput.println("data   ");
        fileOutput.println();
        fileOutput.print("                            ", n2);
        fileOutput.print("Value", n3);
        fileOutput.print("Error", n3);
        fileOutput.print("Value", n3);
        fileOutput.println("Error");
        fileOutput.println();
        fileOutput.println("Gaussian Probability plot ");
        fileOutput.print("  Correlation coefficient", n2);
        fileOutput.print(Fmath.truncate(this.transformedSampleR, 4), n3);
        fileOutput.print(" ", n3);
        fileOutput.println(Fmath.truncate(this.originalSampleR, 4));
        fileOutput.print("  Gradient", n2);
        fileOutput.print(Fmath.truncate(this.transformedGradient, 4), n3);
        fileOutput.print(Fmath.truncate(this.transformedGradientError, 4), n3);
        fileOutput.print(Fmath.truncate(this.originalGradient, 4), n3);
        fileOutput.println(Fmath.truncate(this.originalGradientError, 4));
        fileOutput.print("  Intercept", n2);
        fileOutput.print(Fmath.truncate(this.transformedIntercept, 4), n3);
        fileOutput.print(Fmath.truncate(this.transformedInterceptError, 4), n3);
        fileOutput.print(Fmath.truncate(this.originalIntercept, 4), n3);
        fileOutput.println(Fmath.truncate(this.originalInterceptError, 4));
        fileOutput.println();
        fileOutput.print("Data ");
        fileOutput.println();
        fileOutput.print("  Mean", n2);
        fileOutput.print(Fmath.truncate(this.transformedMean, 4), n3);
        fileOutput.print("  ", n3);
        fileOutput.println(Fmath.truncate(this.originalMean, 4));
        fileOutput.print("  Median", n2);
        fileOutput.print(Fmath.truncate(this.transformedMedian, 4), n3);
        fileOutput.print("  ", n3);
        fileOutput.println(Fmath.truncate(this.originalMedian, 4));
        fileOutput.print("  Standard deviation", n2);
        fileOutput.print(Fmath.truncate(this.transformedStandardDeviation, 4), n3);
        fileOutput.print("  ", n3);
        fileOutput.println(Fmath.truncate(this.originalStandardDeviation, 4));
        fileOutput.print("  Standard error", n2);
        fileOutput.print(Fmath.truncate(this.transformedStandardDeviation / Math.sqrt(this.nData), 4), n3);
        fileOutput.print("  ", n3);
        fileOutput.println(Fmath.truncate(this.originalStandardDeviation / Math.sqrt(this.nData), 4));
        fileOutput.print("  Moment skewness", n2);
        fileOutput.print(Fmath.truncate(this.transformedMomentSkewness, 4), n3);
        fileOutput.print("  ", n3);
        fileOutput.println(Fmath.truncate(this.originalMomentSkewness, 4));
        fileOutput.print("  Median skewness", n2);
        fileOutput.print(Fmath.truncate(this.transformedMedianSkewness, 4), n3);
        fileOutput.print("  ", n3);
        fileOutput.println(Fmath.truncate(this.originalMedianSkewness, 4));
        fileOutput.print("  Quartile skewness", n2);
        fileOutput.print(Fmath.truncate(this.transformedQuartileSkewness, 4), n3);
        fileOutput.print("  ", n3);
        fileOutput.println(Fmath.truncate(this.originalQuartileSkewness, 4));
        fileOutput.print("  Excess kurtosis", n2);
        fileOutput.print(Fmath.truncate(this.transformedExcessKurtosis, 4), n3);
        fileOutput.print("  ", n3);
        fileOutput.println(Fmath.truncate(this.originalExcessKurtosis, 4));
        fileOutput.print("  Minimum", n2);
        fileOutput.print(Fmath.truncate(this.transformedMinimum, 4), n3);
        fileOutput.print("  ", n3);
        fileOutput.println(Fmath.truncate(this.originalMinimum, 4));
        fileOutput.print("  Maximum", n2);
        fileOutput.print(Fmath.truncate(this.transformedMaximum, 4), n3);
        fileOutput.print("  ", n3);
        fileOutput.println(Fmath.truncate(this.originalMaximum, 4));
        fileOutput.print("  Range", n2);
        fileOutput.print(Fmath.truncate(this.transformedRange, 4), n3);
        fileOutput.print("  ", n3);
        fileOutput.println(Fmath.truncate(this.originalRange, 4));
        fileOutput.close();
    }
}

