/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.ProbabilityPlot;
import flanagan.analysis.Stat;
import flanagan.io.Db;
import flanagan.io.FileChooser;
import flanagan.io.FileInput;
import flanagan.io.FileOutput;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ANOVA {
    private String[] title = new String[3];
    private int nTitle = 0;
    private boolean titleCheck = false;
    private String inputFilename = null;
    private String outputFilename = null;
    private int fileOption = 1;
    private boolean fileOptionSet = false;
    private int trunc = 6;
    private int fieldD = 13;
    private boolean truncAll = false;
    private int originalDataType = -1;
    private Object originalData = null;
    private double[][] responses0 = null;
    private BigDecimal[][] responsesBD = null;
    private boolean dataEntered = false;
    private boolean bigDecimal = false;
    private int nGroups = 0;
    private String[] groupNames = null;
    private boolean groupNamesSet = false;
    private int nTotalResponses = 0;
    private int[] nResponsesPerGroup = null;
    private int[] typePerGroup = null;
    private String[] dichotomousS = new String[]{"yes", "no", "y", "n", "true", "false"};
    private char[] dichotomousC = new char[]{'y', 'n'};
    private double dichotTrue = 1.0;
    private double dichotFalse = -1.0;
    private double[] dichotomousDoubleS = new double[]{this.dichotTrue, this.dichotFalse, this.dichotTrue, this.dichotFalse, this.dichotTrue, this.dichotFalse};
    private double[] dichotomousDoubleC = new double[]{this.dichotTrue, this.dichotFalse};
    private int nDichotomousS = 6;
    private int nDichotomousC = 2;
    private boolean nFactorOption = false;
    private double[] groupMeans = null;
    private BigDecimal[] groupMeansBD = null;
    private double[] groupSD = null;
    private double[] groupSE = null;
    private double[] groupClb = null;
    private double[] groupCub = null;
    private double[] groupMinimum = null;
    private BigDecimal[] groupMinimumBD = null;
    private double[] groupMaximum = null;
    private BigDecimal[] groupMaximumBD = null;
    private double[] groupSS = null;
    private BigDecimal[] groupSSBD = null;
    private double[] groupMedians = null;
    private BigDecimal[] groupMediansBD = null;
    private double[] groupMomentSkewness = null;
    private double[] groupMedianSkewness = null;
    private double[] groupQuartileSkewness = null;
    private BigDecimal[] groupQuartileSkewnessBD = null;
    private double[] groupKurtosis = null;
    private BigDecimal[] groupKurtosisBD = null;
    private double[] groupExcessKurtosis = null;
    private BigDecimal[] groupExcessKurtosisBD = null;
    private double[] groupProbPlotR = null;
    private double[] groupProbPlotGradient = null;
    private double[] groupProbPlotIntercept = null;
    private double[] groupProbPlotMu = null;
    private double[] groupProbPlotSigma = null;
    private boolean groupStatsDone = false;
    private double totalMean = 0.0;
    private BigDecimal totalMeanBD = new BigDecimal(0.0);
    private double totalSD = 0.0;
    private double totalSE = 0.0;
    private double totalClb = 0.0;
    private double totalCub = 0.0;
    private double totalMinimum = 0.0;
    private BigDecimal totalMinimumBD = new BigDecimal("0.0");
    private double totalMaximum = 0.0;
    private BigDecimal totalMaximumBD = new BigDecimal("0.0");
    private double totalSS = 0.0;
    private BigDecimal totalSSBD = new BigDecimal("0.0");
    private double totalMedian = 0.0;
    private BigDecimal totalMedianBD = new BigDecimal("0.0");
    private double totalMomentSkewness = 0.0;
    private double totalMedianSkewness = 0.0;
    private double totalQuartileSkewness = 0.0;
    private BigDecimal totalQuartileSkewnessBD = new BigDecimal("0.0");
    private double totalKurtosis = 0.0;
    private BigDecimal totalKurtosisBD = new BigDecimal("0.0");
    private double totalExcessKurtosis = 0.0;
    private BigDecimal totalExcessKurtosisBD = new BigDecimal("0.0");
    private double totalProbPlotR = 0.0;
    private double totalProbPlotGradient = 0.0;
    private double totalProbPlotIntercept = 0.0;
    private double totalProbPlotMu = 0.0;
    private double totalProbPlotSigma = 0.0;
    private int dofTotal = 0;
    private int dofWithinGroups = 0;
    private int dofBetweenGroups = 0;
    private double ssTotal = 0.0;
    private double ssWithin = 0.0;
    private double ssBetween = 0.0;
    private BigDecimal ssTotalBD = new BigDecimal("0.0");
    private BigDecimal ssWithinBD = new BigDecimal("0.0");
    private BigDecimal ssBetweenBD = new BigDecimal("0.0");
    private double meanSquareTotal = 0.0;
    private double meanSquareWithin = 0.0;
    private double meanSquareBetween = 0.0;
    private BigDecimal meanSquareTotalBD = new BigDecimal("0.0");
    private BigDecimal meanSquareWithinBD = new BigDecimal("0.0");
    private BigDecimal meanSquareBetweenBD = new BigDecimal("0.0");
    private double fRatio = 0.0;
    private BigDecimal fRatioBD = new BigDecimal("0.0");
    private double fRatioP = 0.0;
    private boolean oneWayDone = false;
    private double criticalSignificance = 0.95;
    private String criticalSignificanceS = "95%";
    private String criticalSignificanceF = "5%";
    private double criticalFratio = 0.0;
    private boolean[] compGroups = null;
    private boolean comparison = false;
    private int nComparisons = 0;
    private int[][] pairIndices = null;
    private double[] meanSquareTotalG = null;
    private double[] meanSquareWithinG = null;
    private double[] meanSquareBetweenG = null;
    private BigDecimal[] meanSquareTotalBDG = null;
    private BigDecimal[] meanSquareWithinBDG = null;
    private BigDecimal[] meanSquareBetweenBDG = null;
    private double[] fRatioG = null;
    private BigDecimal[] fRatioBDG = null;
    private double[] fRatioPG = null;
    private double[] criticalFratioG = null;
    private double[] ssTotalG = null;
    private double[] ssWithinG = null;
    private double[] ssBetweenG = null;
    private BigDecimal[] ssTotalBDG = null;
    private BigDecimal[] ssWithinBDG = null;
    private BigDecimal[] ssBetweenBDG = null;
    private int[] dofTotalG = null;
    private int[] dofBetweenG = null;
    private int[] dofWithinG = null;
    private boolean allCalcn = true;

    public ANOVA() {
        this.setTitle("Untitled data", false);
    }

    public ANOVA(String string) {
        this.setTitle(string, true);
    }

    public void enterTitle(String string) {
        this.setTitle(string, true);
    }

    private void setTitle(String string, boolean bl) {
        if (!bl) {
            this.title[0] = string;
            ++this.nTitle;
            this.titleCheck = bl;
        } else if (!this.titleCheck) {
            this.title[0] = string;
            ++this.nTitle;
            this.titleCheck = bl;
        } else {
            this.titleCheck = bl;
            this.title[this.nTitle] = string;
            ++this.nTitle;
        }
    }

    public void setCriticalSignificance(double d) {
        this.criticalSignificance = 1.0 - d;
        this.criticalSignificanceF = Double.toString(100.0 * d) + "%";
        this.criticalSignificanceS = Double.toString(100.0 * (1.0 - d)) + "%";
    }

    public double getCriticalSignificance() {
        return 1.0 - this.criticalSignificance;
    }

    public void addDichotomousPair(String string, String string2) {
        String[] stringArray = (String[])this.dichotomousS.clone();
        double[] dArray = (double[])this.dichotomousDoubleS.clone();
        this.dichotomousS = new String[this.nDichotomousS + 2];
        this.dichotomousDoubleS = new double[this.nDichotomousS + 2];
        for (int i = 0; i < this.nDichotomousS; ++i) {
            this.dichotomousS[i] = stringArray[i];
            this.dichotomousDoubleS[i] = dArray[i];
        }
        this.dichotomousS[this.nDichotomousS] = string;
        this.dichotomousDoubleS[this.nDichotomousS] = this.dichotTrue;
        ++this.nDichotomousS;
        this.dichotomousS[this.nDichotomousS] = string2;
        this.dichotomousDoubleS[this.nDichotomousS] = this.dichotFalse;
        ++this.nDichotomousS;
        if (string.length() == 1 && string2.length() == 1) {
            char[] cArray = (char[])this.dichotomousC.clone();
            dArray = (double[])this.dichotomousDoubleC.clone();
            this.dichotomousC = new char[this.nDichotomousC + 2];
            this.dichotomousDoubleC = new double[this.nDichotomousC + 2];
            for (int i = 0; i < this.nDichotomousC; ++i) {
                this.dichotomousC[i] = cArray[i];
                this.dichotomousDoubleC[i] = dArray[i];
            }
            this.dichotomousC[this.nDichotomousC] = string.charAt(0);
            this.dichotomousDoubleC[this.nDichotomousC] = this.dichotTrue;
            ++this.nDichotomousC;
            this.dichotomousC[this.nDichotomousC] = string2.charAt(0);
            this.dichotomousDoubleC[this.nDichotomousC] = this.dichotFalse;
            ++this.nDichotomousC;
        }
    }

    public void addDichotomousPair(char c, char c2) {
        char[] cArray = (char[])this.dichotomousC.clone();
        double[] dArray = (double[])this.dichotomousDoubleC.clone();
        this.dichotomousC = new char[this.nDichotomousC + 2];
        this.dichotomousDoubleC = new double[this.nDichotomousC + 2];
        for (int i = 0; i < this.nDichotomousC; ++i) {
            this.dichotomousC[i] = cArray[i];
            this.dichotomousDoubleC[i] = dArray[i];
        }
        this.dichotomousC[this.nDichotomousC] = c;
        this.dichotomousDoubleC[this.nDichotomousC] = this.dichotTrue;
        ++this.nDichotomousC;
        this.dichotomousC[this.nDichotomousC] = c2;
        this.dichotomousDoubleC[this.nDichotomousC] = this.dichotFalse;
        ++this.nDichotomousC;
        String[] stringArray = (String[])this.dichotomousS.clone();
        dArray = (double[])this.dichotomousDoubleS.clone();
        this.dichotomousS = new String[this.nDichotomousS + 2];
        this.dichotomousDoubleS = new double[this.nDichotomousS + 2];
        for (int i = 0; i < this.nDichotomousS; ++i) {
            this.dichotomousS[i] = stringArray[i];
            this.dichotomousDoubleS[i] = dArray[i];
        }
        this.dichotomousS[this.nDichotomousS] = String.valueOf(c);
        this.dichotomousDoubleS[this.nDichotomousS] = this.dichotTrue;
        ++this.nDichotomousS;
        this.dichotomousS[this.nDichotomousS] = String.valueOf(c2);
        this.dichotomousDoubleS[this.nDichotomousS] = this.dichotFalse;
        ++this.nDichotomousS;
    }

    public void setDichotomousPairValues(double d, double d2) {
        this.dichotTrue = d;
        this.dichotFalse = d2;
    }

    public double[] getDichotomousPairValues() {
        double[] dArray = new double[]{this.dichotTrue, this.dichotFalse};
        return dArray;
    }

    private void setAllCalcn(boolean bl) {
        this.allCalcn = bl;
    }

    public void readResponseData() {
        FileChooser fileChooser = new FileChooser();
        String string = fileChooser.selectFile();
        fileChooser.close();
        this.readResponseData(string);
    }

    public void readResponseData(String string) {
        int n;
        this.inputFilename = string;
        FileInput fileInput = new FileInput(string);
        String string2 = fileInput.readLine();
        this.setTitle(string2, true);
        this.nGroups = fileInput.readInt();
        this.groupNames = new String[this.nGroups + 1];
        for (n = 0; n < this.nGroups; ++n) {
            this.groupNames[n] = fileInput.readWord();
        }
        this.groupNames[this.nGroups] = "total";
        this.groupNamesSet = true;
        this.nResponsesPerGroup = new int[this.nGroups];
        for (n = 0; n < this.nGroups; ++n) {
            this.nResponsesPerGroup[n] = fileInput.readInt();
        }
        String[][] stringArrayArray = new String[this.nGroups][];
        String[] stringArray = null;
        for (int i = 0; i < this.nGroups; ++i) {
            stringArray = new String[this.nResponsesPerGroup[i]];
            for (int j = 0; j < this.nResponsesPerGroup[i]; ++j) {
                stringArray[j] = fileInput.readWord();
            }
            stringArrayArray[i] = Conv.copy(stringArray);
        }
        fileInput.close();
        this.originalDataType = 1;
        this.setVariables(stringArrayArray, this.originalDataType);
    }

    public void enterResponseData(String[][] stringArray) {
        this.nGroups = stringArray.length;
        this.nResponsesPerGroup = new int[this.nGroups];
        for (int i = 0; i < this.nGroups; ++i) {
            this.nResponsesPerGroup[i] = stringArray[i].length;
        }
        this.originalDataType = 1;
        this.setVariables(stringArray, this.originalDataType);
    }

    public void enterResponseData(double[][] dArray) {
        this.nGroups = dArray.length;
        this.nResponsesPerGroup = new int[this.nGroups];
        for (int i = 0; i < this.nGroups; ++i) {
            this.nResponsesPerGroup[i] = dArray[i].length;
        }
        this.originalDataType = 2;
        this.setVariables(dArray, this.originalDataType);
    }

    public void enterResponseData(Matrix matrix) {
        double[][] dArray = matrix.getArrayCopy();
        this.nGroups = dArray.length;
        this.nResponsesPerGroup = new int[this.nGroups];
        for (int i = 0; i < this.nGroups; ++i) {
            this.nResponsesPerGroup[i] = dArray[i].length;
        }
        this.originalDataType = 3;
        this.setVariables(matrix, this.originalDataType);
    }

    public void enterResponseData(BigDecimal[][] bigDecimalArray) {
        this.nGroups = bigDecimalArray.length;
        this.nResponsesPerGroup = new int[this.nGroups];
        for (int i = 0; i < this.nGroups; ++i) {
            this.nResponsesPerGroup[i] = bigDecimalArray[i].length;
        }
        this.originalDataType = 9;
        this.setVariables(bigDecimalArray, this.originalDataType);
    }

    public void enterResponseData(float[][] fArray) {
        this.nGroups = fArray.length;
        this.nResponsesPerGroup = new int[this.nGroups];
        for (int i = 0; i < this.nGroups; ++i) {
            this.nResponsesPerGroup[i] = fArray[i].length;
        }
        this.originalDataType = 4;
        this.setVariables(fArray, this.originalDataType);
    }

    public void enterResponseData(long[][] lArray) {
        this.nGroups = lArray.length;
        this.nResponsesPerGroup = new int[this.nGroups];
        for (int i = 0; i < this.nGroups; ++i) {
            this.nResponsesPerGroup[i] = lArray[i].length;
        }
        this.originalDataType = 8;
        this.setVariables(lArray, this.originalDataType);
    }

    public void enterResponseData(int[][] nArray) {
        this.nGroups = nArray.length;
        this.nResponsesPerGroup = new int[this.nGroups];
        for (int i = 0; i < this.nGroups; ++i) {
            this.nResponsesPerGroup[i] = nArray[i].length;
        }
        this.originalDataType = 5;
        this.setVariables(nArray, this.originalDataType);
    }

    public void enterResponseData(char[][] cArray) {
        this.nGroups = cArray.length;
        this.nResponsesPerGroup = new int[this.nGroups];
        for (int i = 0; i < this.nGroups; ++i) {
            this.nResponsesPerGroup[i] = cArray[i].length;
        }
        this.originalDataType = 6;
        this.setVariables(cArray, this.originalDataType);
    }

    public void enterResponseData(boolean[][] blArray) {
        this.nGroups = blArray.length;
        this.nResponsesPerGroup = new int[this.nGroups];
        for (int i = 0; i < this.nGroups; ++i) {
            this.nResponsesPerGroup[i] = blArray[i].length;
        }
        this.originalDataType = 7;
        this.setVariables(blArray, this.originalDataType);
    }

    private void setVariables(Object object, int n) {
        if (!this.groupNamesSet) {
            this.groupNames = new String[this.nGroups];
            for (int i = 0; i < this.nGroups; ++i) {
                this.groupNames[i] = "group " + (i + 1);
            }
        }
        this.originalData = Conv.copy(object);
        this.originalDataType = n;
        this.dataEntered = true;
        this.convertDataType(n);
    }

    private void convertDataType(int n) {
        this.bigDecimal = false;
        switch (n) {
            case 1: {
                this.responses0 = new double[this.nGroups][];
                String[][] stringArray = (String[][])this.originalData;
                stringArray = this.trimResponses(stringArray);
                for (int i = 0; i < this.nGroups; ++i) {
                    boolean bl;
                    boolean bl2 = this.testIfDichotomous(stringArray[i]);
                    this.responses0[i] = bl2 ? this.dichotStringToDouble(stringArray[i]) : ((bl = this.testIfAlphabetic(stringArray[i])) ? this.alphabeticToDouble(stringArray[i]) : this.stringToDouble(stringArray[i]));
                }
                this.doubleToBD();
                break;
            }
            case 2: {
                this.responses0 = new double[this.nGroups][];
                double[][] dArray = (double[][])this.originalData;
                for (int i = 0; i < this.nGroups; ++i) {
                    this.responses0[i] = (double[])dArray[i].clone();
                }
                this.doubleToBD();
                break;
            }
            case 3: {
                this.responses0 = new double[this.nGroups][];
                double[][] dArray = ((Matrix)this.originalData).getArrayCopy();
                for (int i = 0; i < this.nGroups; ++i) {
                    this.responses0[i] = (double[])dArray[i].clone();
                }
                this.doubleToBD();
                break;
            }
            case 4: {
                this.responses0 = new double[this.nGroups][];
                float[][] fArray = (float[][])this.originalData;
                for (int i = 0; i < this.nGroups; ++i) {
                    this.responses0[i] = new double[this.nResponsesPerGroup[i]];
                    for (int j = 0; j < this.nResponsesPerGroup[i]; ++j) {
                        this.responses0[i][j] = fArray[i][j];
                    }
                }
                this.doubleToBD();
                break;
            }
            case 5: {
                this.responses0 = new double[this.nGroups][];
                int[][] nArray = (int[][])this.originalData;
                for (int i = 0; i < this.nGroups; ++i) {
                    this.responses0[i] = new double[this.nResponsesPerGroup[i]];
                    for (int j = 0; j < this.nResponsesPerGroup[i]; ++j) {
                        this.responses0[i][j] = nArray[i][j];
                    }
                }
                this.doubleToBD();
                break;
            }
            case 6: {
                this.responses0 = new double[this.nGroups][];
                char[][] cArray = (char[][])this.originalData;
                for (int i = 0; i < this.nGroups; ++i) {
                    boolean bl;
                    boolean bl3 = this.testIfDichotomous(cArray[i]);
                    this.responses0[i] = bl3 ? this.dichotCharToDouble(cArray[i]) : ((bl = this.testIfAlphabetic(cArray[i])) ? this.alphabeticToDouble(cArray[i]) : this.charToDouble(cArray[i]));
                }
                this.doubleToBD();
                break;
            }
            case 7: {
                this.responses0 = new double[this.nGroups][];
                boolean[][] blArray = (boolean[][])this.originalData;
                for (int i = 0; i < this.nGroups; ++i) {
                    this.responses0[i] = new double[this.nResponsesPerGroup[i]];
                    for (int j = 0; j < this.nResponsesPerGroup[i]; ++j) {
                        this.responses0[i][j] = blArray[i][j] ? 1.0 : -1.0;
                    }
                }
                this.doubleToBD();
                break;
            }
            case 8: {
                this.responses0 = new double[this.nGroups][];
                long[][] lArray = (long[][])this.originalData;
                for (int i = 0; i < this.nGroups; ++i) {
                    this.responses0[i] = new double[this.nResponsesPerGroup[i]];
                    for (int j = 0; j < this.nResponsesPerGroup[i]; ++j) {
                        this.responses0[i][j] = lArray[i][j];
                    }
                }
                this.doubleToBD();
                break;
            }
            case 9: {
                this.responsesBD = new BigDecimal[this.nGroups][];
                BigDecimal[][] bigDecimalArray = (BigDecimal[][])this.originalData;
                for (int i = 0; i < this.nGroups; ++i) {
                    this.responsesBD[i] = (BigDecimal[])bigDecimalArray[i].clone();
                }
                this.bDtodouble();
                this.bigDecimal = true;
                break;
            }
            case 10: {
                this.responsesBD = new BigDecimal[this.nGroups][];
                BigInteger[][] bigIntegerArray = (BigInteger[][])this.originalData;
                for (int i = 0; i < this.nGroups; ++i) {
                    this.responsesBD[i] = new BigDecimal[this.nResponsesPerGroup[i]];
                    for (int j = 0; j < this.nResponsesPerGroup[i]; ++j) {
                        this.responsesBD[i][j] = new BigDecimal(bigIntegerArray[i][j]);
                    }
                }
                this.bDtodouble();
                this.bigDecimal = true;
            }
        }
        this.nTotalResponses = 0;
        for (int i = 0; i < this.nGroups; ++i) {
            this.nTotalResponses += this.nResponsesPerGroup[i];
        }
    }

    private void doubleToBD() {
        this.responsesBD = new BigDecimal[this.nGroups][];
        for (int i = 0; i < this.nGroups; ++i) {
            this.responsesBD[i] = new BigDecimal[this.nResponsesPerGroup[i]];
            for (int j = 0; j < this.nResponsesPerGroup[i]; ++j) {
                this.responsesBD[i][j] = new BigDecimal(this.responses0[i][j]);
            }
        }
    }

    private void bDtodouble() {
        this.responses0 = new double[this.nGroups][];
        for (int i = 0; i < this.nGroups; ++i) {
            this.responses0[i] = new double[this.nResponsesPerGroup[i]];
            for (int j = 0; j < this.nResponsesPerGroup[i]; ++j) {
                this.responses0[i][j] = this.responsesBD[i][j].doubleValue();
            }
        }
    }

    private boolean testIfDichotomous(String[] stringArray) {
        boolean bl = false;
        int n = stringArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            boolean bl2 = false;
            for (int j = 0; j < this.nDichotomousS; ++j) {
                if (!stringArray[i].equalsIgnoreCase(this.dichotomousS[j])) continue;
                bl2 = true;
            }
            if (!bl2) continue;
            ++n2;
        }
        if (n2 == n) {
            bl = true;
        }
        return bl;
    }

    private boolean testIfDichotomous(char[] cArray) {
        boolean bl = false;
        int n = cArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            boolean bl2 = false;
            for (int j = 0; j < this.nDichotomousC; ++j) {
                if (cArray[i] != this.dichotomousC[j]) continue;
                bl2 = true;
            }
            if (!bl2) continue;
            ++n2;
        }
        if (n2 == n) {
            bl = true;
        }
        return bl;
    }

    private boolean testIfAlphabetic(String[] stringArray) {
        boolean bl = false;
        int n = stringArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            boolean bl2 = false;
            if (stringArray[i].length() == 1) {
                char c = stringArray[i].charAt(0);
                if (c > '@' && c < '[') {
                    bl2 = true;
                } else if (c > '`' && c < '{') {
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            ++n2;
        }
        if (n2 == n) {
            bl = true;
        }
        return bl;
    }

    private boolean testIfAlphabetic(char[] cArray) {
        boolean bl = false;
        int n = cArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            boolean bl2 = false;
            char c = cArray[i];
            if (c > '@' && c < '[') {
                bl2 = true;
            } else if (c > '`' && c < '{') {
                bl2 = true;
            }
            if (!bl2) continue;
            ++n2;
        }
        if (n2 == n) {
            bl = true;
        }
        return bl;
    }

    private double[] dichotStringToDouble(String[] stringArray) {
        boolean bl = false;
        int n = stringArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            boolean bl2 = false;
            for (int j = 0; j < this.nDichotomousS; j += 2) {
                if (!stringArray[i].equalsIgnoreCase(this.dichotomousS[j])) continue;
                bl2 = true;
            }
            dArray[i] = bl2 ? 1.0 : -1.0;
        }
        return dArray;
    }

    private double[] dichotCharToDouble(char[] cArray) {
        boolean bl = false;
        int n = cArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            boolean bl2 = false;
            for (int j = 0; j < this.nDichotomousC; j += 2) {
                if (cArray[i] != this.dichotomousC[j]) continue;
                bl2 = true;
            }
            dArray[i] = bl2 ? 1.0 : -1.0;
        }
        return dArray;
    }

    private double[] alphabeticToDouble(String[] stringArray) {
        int n = stringArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = stringArray[i].charAt(0);
            dArray[i] = d > 96.0 ? d - 96.0 : d - 64.0;
        }
        return dArray;
    }

    private double[] alphabeticToDouble(char[] cArray) {
        int n = cArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = cArray[i];
            dArray[i] = d > 96.0 ? d - 96.0 : d - 64.0;
        }
        return dArray;
    }

    private double[] stringToDouble(String[] stringArray) {
        int n = stringArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Double.parseDouble(stringArray[i]);
        }
        return dArray;
    }

    private double[] charToDouble(char[] cArray) {
        int n = cArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = cArray[i];
            dArray[i] = d > 96.0 ? d - 96.0 : d - 64.0;
        }
        return dArray;
    }

    private String[][] trimResponses(String[][] stringArray) {
        String[][] stringArray2 = (String[][])stringArray.clone();
        int n = stringArray.length;
        int n2 = stringArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                stringArray2[i][j].trim();
            }
        }
        return stringArray2;
    }

    public Object getResponsesAsEntered() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("No data has been entered");
        }
        return Conv.copy(this.originalData);
    }

    public double[][] getResponses() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("No data has been entered");
        }
        return Conv.copy(this.responses0);
    }

    public double[][] getResponsesAsdouble() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("No data has been entered");
        }
        return Conv.copy(this.responses0);
    }

    public BigDecimal[][] getResponsesAsBigDecimal() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("No data has been entered");
        }
        return Conv.copy(this.responsesBD);
    }

    public String[] getTitle() {
        String[] stringArray = new String[this.nTitle];
        for (int i = 0; i < this.nTitle; ++i) {
            stringArray[i] = this.title[i];
        }
        return stringArray;
    }

    public String getInputFileName() {
        return this.inputFilename;
    }

    public void enterGroupNames(String[] stringArray) {
        int n = stringArray.length;
        this.groupNames = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            this.groupNames[i] = stringArray[i];
        }
        this.groupNames[n] = "total";
        this.groupNamesSet = true;
    }

    public int getNumberOfGroups() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("No data has been entered");
        }
        return this.nGroups;
    }

    public String[] getGroupNames() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("no data has been entered");
        }
        String[] stringArray = new String[this.nGroups];
        for (int i = 0; i < this.nGroups; ++i) {
            stringArray[i] = this.groupNames[i];
        }
        return stringArray;
    }

    public String getGroupName(int n) {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("no data has been entered");
        }
        return this.groupNames[n - 1];
    }

    private void groupStatistics() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("no data has been entered");
        }
        this.groupMeansBD = new BigDecimal[this.nGroups];
        this.groupMeans = new double[this.nGroups];
        this.groupSD = new double[this.nGroups];
        this.groupSE = new double[this.nGroups];
        this.groupClb = new double[this.nGroups];
        this.groupCub = new double[this.nGroups];
        this.groupMinimumBD = new BigDecimal[this.nGroups];
        this.groupMinimum = new double[this.nGroups];
        this.groupMaximumBD = new BigDecimal[this.nGroups];
        this.groupMaximum = new double[this.nGroups];
        this.groupSSBD = new BigDecimal[this.nGroups];
        this.groupSS = new double[this.nGroups];
        this.groupMedians = new double[this.nGroups];
        this.groupMediansBD = new BigDecimal[this.nGroups];
        this.groupMomentSkewness = new double[this.nGroups];
        this.groupMedianSkewness = new double[this.nGroups];
        this.groupQuartileSkewness = new double[this.nGroups];
        this.groupQuartileSkewnessBD = new BigDecimal[this.nGroups];
        this.groupKurtosis = new double[this.nGroups];
        this.groupKurtosisBD = new BigDecimal[this.nGroups];
        this.groupExcessKurtosis = new double[this.nGroups];
        this.groupExcessKurtosisBD = new BigDecimal[this.nGroups];
        this.groupProbPlotR = new double[this.nGroups];
        this.groupProbPlotGradient = new double[this.nGroups];
        this.groupProbPlotIntercept = new double[this.nGroups];
        this.groupProbPlotMu = new double[this.nGroups];
        this.groupProbPlotSigma = new double[this.nGroups];
        Stat stat = null;
        ProbabilityPlot probabilityPlot = null;
        for (int i = 0; i < this.nGroups; ++i) {
            stat = new Stat(this.responses0[i]);
            this.groupMeans[i] = stat.mean();
            this.groupMeansBD[i] = new BigDecimal(this.groupMeans[i]);
            this.groupSD[i] = stat.standardDeviation();
            this.groupSE[i] = stat.standardError();
            double[] dArray = stat.meanConfidenceLimits(this.criticalSignificance);
            this.groupClb[i] = dArray[0];
            this.groupCub[i] = dArray[1];
            this.groupMinimum[i] = stat.minimum();
            this.groupMinimumBD[i] = new BigDecimal(this.groupMinimum[i]);
            this.groupMaximum[i] = stat.maximum();
            this.groupMaximumBD[i] = new BigDecimal(this.groupMaximum[i]);
            double d = 0.0;
            for (int j = 0; j < this.nResponsesPerGroup[i]; ++j) {
                double d2 = this.responses0[i][j] - this.groupMeans[i];
                d += d2 * d2;
            }
            this.groupSS[i] = d;
            this.groupSSBD[i] = new BigDecimal(d);
            this.groupMedians[i] = stat.median_as_double();
            this.groupMediansBD[i] = new BigDecimal(this.groupMedians[i]);
            this.groupMomentSkewness[i] = stat.momentSkewness_as_double();
            this.groupMedianSkewness[i] = stat.medianSkewness_as_double();
            this.groupQuartileSkewness[i] = stat.quartileSkewness_as_double();
            this.groupQuartileSkewnessBD[i] = new BigDecimal(this.groupQuartileSkewness[i]);
            this.groupKurtosis[i] = stat.kurtosis_as_double();
            this.groupKurtosisBD[i] = new BigDecimal(this.groupKurtosis[i]);
            this.groupExcessKurtosis[i] = stat.excessKurtosis_as_double();
            this.groupExcessKurtosisBD[i] = new BigDecimal(this.groupExcessKurtosis[i]);
            probabilityPlot = new ProbabilityPlot(this.responses0[i]);
            probabilityPlot.supressDisplay();
            probabilityPlot.gaussianProbabilityPlot();
            this.groupProbPlotR[i] = probabilityPlot.gaussianCorrelationCoefficient();
            this.groupProbPlotGradient[i] = probabilityPlot.gaussianGradient();
            this.groupProbPlotIntercept[i] = probabilityPlot.gaussianIntercept();
            this.groupProbPlotMu[i] = probabilityPlot.gaussianMu();
            this.groupProbPlotSigma[i] = probabilityPlot.gaussianSigma();
        }
        double[] dArray = new double[this.nTotalResponses];
        int n = 0;
        for (int i = 0; i < this.nGroups; ++i) {
            for (int j = 0; j < this.nResponsesPerGroup[i]; ++j) {
                dArray[n++] = this.responses0[i][j];
            }
        }
        Stat stat2 = new Stat(dArray);
        this.totalMean = stat2.mean();
        this.totalMeanBD = new BigDecimal(this.totalMean);
        this.totalSD = stat2.standardDeviation();
        this.totalSE = stat2.standardError();
        double[] dArray2 = stat2.meanConfidenceLimits(this.criticalSignificance);
        this.totalClb = dArray2[0];
        this.totalCub = dArray2[1];
        this.totalMinimum = stat2.minimum();
        this.totalMinimumBD = new BigDecimal(this.totalMinimum);
        this.totalMaximum = stat2.maximum();
        this.totalMaximumBD = new BigDecimal(this.totalMaximum);
        double d = 0.0;
        for (int i = 0; i < this.nTotalResponses; ++i) {
            double d3 = dArray[i] - this.totalMean;
            d += d3 * d3;
        }
        this.totalSS = d;
        this.totalSSBD = new BigDecimal(d);
        this.totalMedian = stat2.median_as_double();
        this.totalMedianBD = new BigDecimal(this.totalMedian);
        this.totalMomentSkewness = stat2.momentSkewness_as_double();
        this.totalMedianSkewness = stat2.medianSkewness_as_double();
        this.totalQuartileSkewness = stat2.quartileSkewness_as_double();
        this.totalQuartileSkewnessBD = new BigDecimal(this.totalQuartileSkewness);
        this.totalKurtosis = stat2.kurtosis_as_double();
        this.totalKurtosisBD = new BigDecimal(this.totalKurtosis);
        this.totalExcessKurtosis = stat2.excessKurtosis_as_double();
        this.totalExcessKurtosisBD = new BigDecimal(this.totalExcessKurtosis);
        ProbabilityPlot probabilityPlot2 = new ProbabilityPlot(dArray);
        probabilityPlot2.supressDisplay();
        probabilityPlot2.gaussianProbabilityPlot();
        this.totalProbPlotR = probabilityPlot2.gaussianCorrelationCoefficient();
        this.totalProbPlotGradient = probabilityPlot2.gaussianGradient();
        this.totalProbPlotIntercept = probabilityPlot2.gaussianIntercept();
        this.totalProbPlotMu = probabilityPlot2.gaussianMu();
        this.totalProbPlotSigma = probabilityPlot2.gaussianSigma();
        this.groupStatsDone = true;
    }

    private void groupStatisticsBD() {
        BigDecimal bigDecimal;
        int n;
        if (!this.dataEntered) {
            throw new IllegalArgumentException("no data has been entered");
        }
        this.groupMeansBD = new BigDecimal[this.nGroups];
        this.groupMeans = new double[this.nGroups];
        this.groupSD = new double[this.nGroups];
        this.groupSE = new double[this.nGroups];
        this.groupClb = new double[this.nGroups];
        this.groupCub = new double[this.nGroups];
        this.groupMinimumBD = new BigDecimal[this.nGroups];
        this.groupMinimum = new double[this.nGroups];
        this.groupMaximumBD = new BigDecimal[this.nGroups];
        this.groupMaximum = new double[this.nGroups];
        this.groupSSBD = new BigDecimal[this.nGroups];
        this.groupSS = new double[this.nGroups];
        this.groupMedians = new double[this.nGroups];
        this.groupMediansBD = new BigDecimal[this.nGroups];
        this.groupMomentSkewness = new double[this.nGroups];
        this.groupMedianSkewness = new double[this.nGroups];
        this.groupQuartileSkewness = new double[this.nGroups];
        this.groupQuartileSkewnessBD = new BigDecimal[this.nGroups];
        this.groupKurtosis = new double[this.nGroups];
        this.groupKurtosisBD = new BigDecimal[this.nGroups];
        this.groupExcessKurtosis = new double[this.nGroups];
        this.groupExcessKurtosisBD = new BigDecimal[this.nGroups];
        this.groupProbPlotR = new double[this.nGroups];
        this.groupProbPlotGradient = new double[this.nGroups];
        this.groupProbPlotIntercept = new double[this.nGroups];
        this.groupProbPlotMu = new double[this.nGroups];
        this.groupProbPlotSigma = new double[this.nGroups];
        Stat stat = null;
        ProbabilityPlot probabilityPlot = null;
        for (int i = 0; i < this.nGroups; ++i) {
            stat = new Stat(this.responsesBD[i]);
            this.groupMeansBD[i] = stat.mean_as_BigDecimal();
            this.groupMeans[i] = this.groupMeansBD[i].doubleValue();
            this.groupSD[i] = stat.standardDeviation();
            this.groupSE[i] = stat.standardError();
            double[] dArray = stat.meanConfidenceLimits(this.criticalSignificance);
            this.groupClb[i] = dArray[0];
            this.groupCub[i] = dArray[1];
            this.groupMinimumBD[i] = stat.minimum_as_BigDecimal();
            this.groupMinimum[i] = stat.minimum_as_double();
            this.groupMaximumBD[i] = stat.maximum_as_BigDecimal();
            this.groupMaximum[i] = stat.maximum_as_double();
            BigDecimal bigDecimal2 = new BigDecimal("0.0");
            for (n = 0; n < this.nResponsesPerGroup[i]; ++n) {
                bigDecimal = this.responsesBD[i][n].subtract(this.groupMeansBD[i]);
                bigDecimal2 = bigDecimal2.add(bigDecimal.multiply(bigDecimal));
            }
            this.groupSSBD[i] = bigDecimal2;
            this.groupSS[i] = bigDecimal2.doubleValue();
            this.groupMediansBD[i] = stat.median_as_BigDecimal();
            this.groupMedians[i] = this.groupMediansBD[i].doubleValue();
            this.groupMomentSkewness[i] = stat.momentSkewness_as_double();
            this.groupMedianSkewness[i] = stat.medianSkewness_as_double();
            this.groupQuartileSkewnessBD[i] = stat.quartileSkewness_as_BigDecimal();
            this.groupQuartileSkewness[i] = this.groupQuartileSkewnessBD[i].doubleValue();
            this.groupKurtosis[i] = stat.kurtosis_as_double();
            this.groupKurtosisBD[i] = new BigDecimal(this.groupKurtosis[i]);
            this.groupExcessKurtosisBD[i] = stat.excessKurtosis_as_BigDecimal();
            this.groupExcessKurtosis[i] = this.groupExcessKurtosisBD[i].doubleValue();
            probabilityPlot = new ProbabilityPlot(this.responses0[i]);
            probabilityPlot.supressDisplay();
            probabilityPlot.gaussianProbabilityPlot();
            this.groupProbPlotR[i] = probabilityPlot.gaussianCorrelationCoefficient();
            this.groupProbPlotGradient[i] = probabilityPlot.gaussianGradient();
            this.groupProbPlotIntercept[i] = probabilityPlot.gaussianIntercept();
            this.groupProbPlotMu[i] = probabilityPlot.gaussianMu();
            this.groupProbPlotSigma[i] = probabilityPlot.gaussianSigma();
        }
        BigDecimal[] bigDecimalArray = new BigDecimal[this.nTotalResponses];
        int n2 = 0;
        for (int i = 0; i < this.nGroups; ++i) {
            for (n = 0; n < this.nResponsesPerGroup[i]; ++n) {
                bigDecimalArray[n2++] = this.responsesBD[i][n];
            }
        }
        Stat stat2 = new Stat(bigDecimalArray);
        this.totalMeanBD = stat2.mean_as_BigDecimal();
        this.totalMean = this.totalMeanBD.doubleValue();
        this.totalSD = stat2.standardDeviation();
        this.totalSE = stat2.standardError();
        double[] dArray = stat2.meanConfidenceLimits(this.criticalSignificance);
        this.totalClb = dArray[0];
        this.totalCub = dArray[1];
        this.totalMinimumBD = stat2.minimum_as_BigDecimal();
        this.totalMinimum = this.totalMinimumBD.doubleValue();
        this.totalMaximumBD = stat2.maximum_as_BigDecimal();
        this.totalMaximum = this.totalMaximumBD.doubleValue();
        bigDecimal = new BigDecimal("0.0");
        for (int i = 0; i < this.nTotalResponses; ++i) {
            BigDecimal bigDecimal3 = bigDecimalArray[i].subtract(this.totalMeanBD);
            bigDecimal = bigDecimal.add(bigDecimal3.multiply(bigDecimal3));
        }
        this.totalSSBD = bigDecimal;
        this.totalSS = this.totalSSBD.doubleValue();
        this.totalMedianBD = stat2.median_as_BigDecimal();
        this.totalMedian = this.totalMedianBD.doubleValue();
        this.totalMomentSkewness = stat2.momentSkewness_as_double();
        this.totalMedianSkewness = stat2.medianSkewness_as_double();
        this.totalQuartileSkewnessBD = stat2.quartileSkewness_as_BigDecimal();
        this.totalQuartileSkewness = this.totalQuartileSkewnessBD.doubleValue();
        this.totalKurtosis = stat2.kurtosis_as_double();
        this.totalKurtosisBD = new BigDecimal(this.totalKurtosis);
        this.totalExcessKurtosisBD = stat2.excessKurtosis_as_BigDecimal();
        this.totalExcessKurtosis = this.totalExcessKurtosisBD.doubleValue();
        ProbabilityPlot probabilityPlot2 = new ProbabilityPlot(bigDecimalArray);
        probabilityPlot2.supressDisplay();
        probabilityPlot2.gaussianProbabilityPlot();
        this.totalProbPlotR = probabilityPlot2.gaussianCorrelationCoefficient();
        this.totalProbPlotGradient = probabilityPlot2.gaussianGradient();
        this.totalProbPlotIntercept = probabilityPlot2.gaussianIntercept();
        this.totalProbPlotMu = probabilityPlot2.gaussianMu();
        this.totalProbPlotSigma = probabilityPlot2.gaussianSigma();
        this.groupStatsDone = true;
    }

    public int[] numberOfResponsesPerGroup() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("No data has been entered");
        }
        return this.nResponsesPerGroup;
    }

    public double[] groupMeans() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupMeans);
    }

    public BigDecimal[] groupMeans_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return Conv.copy(this.groupMeansBD);
    }

    public double[] groupStandardDeviations() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupSD);
    }

    public double[] groupStandardErrors() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupSE);
    }

    public double[] groupMeanLowerConfidenceLimits() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupClb);
    }

    public double[] groupMeanUpperConfidenceLimits() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupCub);
    }

    public double[] groupMaxima() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupMaximum);
    }

    public BigDecimal[] groupMaxima_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return Conv.copy(this.groupMaximumBD);
    }

    public double[] groupMinima() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupMinimum);
    }

    public BigDecimal[] groupMinima_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return Conv.copy(this.groupMinimumBD);
    }

    public double[] groupMedians() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupMedians);
    }

    public BigDecimal[] groupMedians_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return Conv.copy(this.groupMediansBD);
    }

    public double[] groupMomentSkewnesses() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupMomentSkewness);
    }

    public double[] groupMedianSkewnesses() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupMedianSkewness);
    }

    public double[] groupQuartileSkewnesses() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupQuartileSkewness);
    }

    public BigDecimal[] groupQuartileSkewnesses_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return Conv.copy(this.groupQuartileSkewnessBD);
    }

    public double[] groupKurtoses() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupKurtosis);
    }

    public BigDecimal[] groupKurtoses_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return Conv.copy(this.groupKurtosisBD);
    }

    public double[] groupExcessKurtoses() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupExcessKurtosis);
    }

    public BigDecimal[] groupExcessKurtoses_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return Conv.copy(this.groupExcessKurtosisBD);
    }

    public double[] groupGPPcorrelationCoefficient() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupProbPlotR);
    }

    public double[] groupGPPgradient() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupProbPlotGradient);
    }

    public double[] groupGPPintercept() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupProbPlotIntercept);
    }

    public double[] groupGPPmu() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupProbPlotMu);
    }

    public double[] groupGPPsigma() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupProbPlotSigma);
    }

    public double[] groupSumOfSquares() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return Conv.copy(this.groupSS);
    }

    public BigDecimal[] groupSumOfSquares_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return Conv.copy(this.groupSSBD);
    }

    public double totalMean() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalMean;
    }

    public BigDecimal totalMean_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return this.totalMeanBD;
    }

    public double totalStandardDeviation() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalSD;
    }

    public double totalStandardError() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalSE;
    }

    public double totalMeanLowerConfidenceLimit() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalClb;
    }

    public double totalMeanUpperConfidenceLimit() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalCub;
    }

    public double totalMaximum() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalMaximum;
    }

    public BigDecimal totalMaxima_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return this.totalMaximumBD;
    }

    public double totalMinimum() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalMinimum;
    }

    public BigDecimal totalMinimum_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return this.totalMinimumBD;
    }

    public double totalMedian() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalMedian;
    }

    public BigDecimal totalMedian_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return this.totalMedianBD;
    }

    public double totalMomentSkewness() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalMomentSkewness;
    }

    public double totalMedianSkewness() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalMedianSkewness;
    }

    public double totalQuartileSkewness() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalQuartileSkewness;
    }

    public BigDecimal totalQuartileSkewness_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return this.totalQuartileSkewnessBD;
    }

    public double totalKurtosis() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalKurtosis;
    }

    public BigDecimal totalKurtosis_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return this.totalKurtosisBD;
    }

    public double totalExcessKurtosis() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalExcessKurtosis;
    }

    public BigDecimal totalExcessKurtosis_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return this.totalExcessKurtosisBD;
    }

    public double totalGPPcorrelationCoefficient() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalProbPlotR;
    }

    public double totalGPPgradient() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalProbPlotGradient;
    }

    public double totalGPPintercept() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalProbPlotIntercept;
    }

    public double totalGPPmu() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalProbPlotMu;
    }

    public double totalGPPsigma() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalProbPlotSigma;
    }

    public double totalSumOfSquares() {
        if (!this.groupStatsDone) {
            this.groupStatistics();
        }
        return this.totalSS;
    }

    public BigDecimal totalSumOfSquares_as_BD() {
        if (!this.groupStatsDone) {
            this.groupStatisticsBD();
        }
        return this.totalSSBD;
    }

    public void oneWayAnalysis() {
        if (!this.bigDecimal) {
            this.oneWayAnalysis_d();
        } else {
            this.oneWayAnalysis_BD();
        }
    }

    public void oneWayAnalysisWithPairComparison() {
        this.comparison = true;
        this.nComparisons = this.nGroups * (this.nGroups - 1) / 2;
        this.compGroups = new boolean[this.nGroups];
        for (int i = 0; i < this.nGroups; ++i) {
            this.compGroups[i] = true;
        }
        if (!this.bigDecimal) {
            this.oneWayAnalysis_d();
        } else {
            this.oneWayAnalysis_BD();
        }
    }

    public void oneWayAnalysisWithPairComparison(int n, int n2) {
        if (n == n2) {
            throw new IllegalArgumentException("the two groups must be different");
        }
        if (n < 1 || n > this.nGroups) {
            throw new IllegalArgumentException("The group index, " + n + ", must be greater than 0 and less than " + (this.nGroups + 1));
        }
        if (n2 < 1 || n2 > this.nGroups) {
            throw new IllegalArgumentException("The group index, " + n2 + ", must be greater than 0 and less than " + (this.nGroups + 1));
        }
        this.comparison = true;
        this.compGroups = new boolean[this.nGroups];
        this.nComparisons = 1;
        --n;
        --n2;
        for (int i = 0; i < this.nGroups; ++i) {
            this.compGroups[i] = false;
            if (i == n) {
                this.compGroups[i] = true;
            }
            if (i != n2) continue;
            this.compGroups[i] = true;
        }
        if (!this.bigDecimal) {
            this.oneWayAnalysis_d();
        } else {
            this.oneWayAnalysis_BD();
        }
    }

    private void oneWayAnalysis_d() {
        this.oneWayANOVA_d();
        this.outputAnalysis();
    }

    private void oneWayAnalysis_BD() {
        this.oneWayANOVA_d();
        this.outputAnalysis();
    }

    public void oneWayAnalysis(String string) {
        if (!this.bigDecimal) {
            this.oneWayAnalysis_d(string);
        } else {
            this.oneWayAnalysis_BD(string);
        }
    }

    public void oneWayAnalysisWithPairComparison(String string) {
        this.comparison = true;
        this.nComparisons = this.nGroups * (this.nGroups - 1) / 2;
        this.compGroups = new boolean[this.nGroups];
        for (int i = 0; i < this.nGroups; ++i) {
            this.compGroups[i] = true;
        }
        if (!this.bigDecimal) {
            this.oneWayAnalysis_d(string);
        } else {
            this.oneWayAnalysis_BD(string);
        }
    }

    public void oneWayAnalysisWithPairComparison(int n, int n2, String string) {
        if (n == n2) {
            throw new IllegalArgumentException("the two groups must be different");
        }
        if (n < 1 || n > this.nGroups) {
            throw new IllegalArgumentException("The group index, " + n + ", must be greater than 0 and less than " + (this.nGroups + 1));
        }
        if (n2 < 1 || n2 > this.nGroups) {
            throw new IllegalArgumentException("The group index, " + n2 + ", must be greater than 0 and less than " + (this.nGroups + 1));
        }
        this.comparison = true;
        this.compGroups = new boolean[this.nGroups];
        this.nComparisons = 1;
        --n;
        --n2;
        for (int i = 0; i < this.nGroups; ++i) {
            this.compGroups[i] = false;
            if (i == n) {
                this.compGroups[i] = true;
            }
            if (i != n2) continue;
            this.compGroups[i] = true;
        }
        if (!this.bigDecimal) {
            this.oneWayAnalysis_d(string);
        } else {
            this.oneWayAnalysis_BD(string);
        }
    }

    private void oneWayAnalysis_d(String string) {
        this.oneWayANOVA_d();
        this.outputAnalysis(string);
    }

    private void oneWayAnalysis_BD(String string) {
        this.oneWayANOVA_BD();
        this.outputAnalysis(string);
    }

    public void oneWayANOVA() {
        if (!this.bigDecimal) {
            this.oneWayANOVA_d();
        } else {
            this.oneWayANOVA_BD();
        }
    }

    public void oneWayANOVAwithPairComparison() {
        this.comparison = true;
        this.nComparisons = this.nGroups * (this.nGroups - 1) / 2;
        this.compGroups = new boolean[this.nGroups];
        for (int i = 0; i < this.nGroups; ++i) {
            this.compGroups[i] = true;
        }
        if (!this.bigDecimal) {
            this.oneWayANOVA_d();
        } else {
            this.oneWayANOVA_BD();
        }
    }

    public void oneWayANOVAwithPairComparison(int n, int n2) {
        if (n == n2) {
            throw new IllegalArgumentException("the two groups must be different");
        }
        if (n < 1 || n > this.nGroups) {
            throw new IllegalArgumentException("The group index, " + n + ", must be greater than 0 and less than " + (this.nGroups + 1));
        }
        if (n2 < 1 || n2 > this.nGroups) {
            throw new IllegalArgumentException("The group index, " + n2 + ", must be greater than 0 and less than " + (this.nGroups + 1));
        }
        this.comparison = true;
        this.compGroups = new boolean[this.nGroups];
        this.nComparisons = 1;
        --n;
        --n2;
        for (int i = 0; i < this.nGroups; ++i) {
            this.compGroups[i] = false;
            if (i == n) {
                this.compGroups[i] = true;
            }
            if (i != n2) continue;
            this.compGroups[i] = true;
        }
        if (!this.bigDecimal) {
            this.oneWayANOVA_d();
        } else {
            this.oneWayANOVA_BD();
        }
    }

    private void oneWayANOVA_d() {
        int n;
        if (!this.groupStatsDone) {
            if (this.allCalcn) {
                this.groupStatistics();
            } else {
                int n2;
                int n3;
                this.totalMean = 0.0;
                for (n3 = 0; n3 < this.nGroups; ++n3) {
                    for (n2 = 0; n2 < this.nResponsesPerGroup[n3]; ++n2) {
                        this.totalMean += this.responses0[n3][n2];
                    }
                }
                this.totalMean /= (double)this.nTotalResponses;
                this.totalMeanBD = new BigDecimal(this.totalMean);
                this.groupMeans = new double[this.nGroups];
                this.groupMeansBD = new BigDecimal[this.nGroups];
                for (n3 = 0; n3 < this.nGroups; ++n3) {
                    this.groupMeans[n3] = 0.0;
                    for (n2 = 0; n2 < this.nResponsesPerGroup[n3]; ++n2) {
                        int n4 = n3;
                        this.groupMeans[n4] = this.groupMeans[n4] + this.responses0[n3][n2];
                    }
                    int n5 = n3;
                    this.groupMeans[n5] = this.groupMeans[n5] / (double)this.nResponsesPerGroup[n3];
                    this.groupMeansBD[n3] = new BigDecimal(this.groupMeans[n3]);
                }
            }
        }
        this.dofTotal = this.nTotalResponses - 1;
        this.dofBetweenGroups = this.nGroups - 1;
        this.dofWithinGroups = this.nTotalResponses - this.nGroups;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.nGroups; ++i) {
            for (n = 0; n < this.nResponsesPerGroup[i]; ++n) {
                d4 = this.responses0[i][n] - this.totalMean;
                d += d4 * d4;
                d4 = this.groupMeans[i] - this.totalMean;
                d2 += d4 * d4;
                d4 = this.responses0[i][n] - this.groupMeans[i];
                d3 += d4 * d4;
            }
        }
        this.ssTotal = d;
        this.ssTotalBD = new BigDecimal(d);
        this.meanSquareTotal = d / (double)this.dofTotal;
        this.meanSquareTotalBD = new BigDecimal(this.meanSquareTotal);
        this.ssBetween = d2;
        this.ssBetweenBD = new BigDecimal(d2);
        this.meanSquareBetween = d2 / (double)this.dofBetweenGroups;
        this.meanSquareBetweenBD = new BigDecimal(this.meanSquareBetween);
        this.ssWithin = d3;
        this.ssWithinBD = new BigDecimal(d3);
        this.meanSquareWithin = d3 / (double)this.dofWithinGroups;
        this.meanSquareWithinBD = new BigDecimal(this.meanSquareWithin);
        this.fRatio = this.meanSquareBetween / this.meanSquareWithin;
        this.fRatioBD = new BigDecimal(this.fRatio);
        this.fRatioP = Stat.fCompCDF(this.fRatio, this.dofBetweenGroups, this.dofWithinGroups);
        this.criticalFratio = Stat.fDistributionInverseCDF(this.dofBetweenGroups, this.dofWithinGroups, this.criticalSignificance);
        if (this.nGroups > 2 && this.comparison) {
            this.meanSquareTotalG = new double[this.nComparisons];
            this.meanSquareWithinG = new double[this.nComparisons];
            this.meanSquareBetweenG = new double[this.nComparisons];
            this.meanSquareTotalBDG = new BigDecimal[this.nComparisons];
            this.meanSquareWithinBDG = new BigDecimal[this.nComparisons];
            this.meanSquareBetweenBDG = new BigDecimal[this.nComparisons];
            this.fRatioG = new double[this.nComparisons];
            this.fRatioBDG = new BigDecimal[this.nComparisons];
            this.fRatioPG = new double[this.nComparisons];
            this.criticalFratioG = new double[this.nComparisons];
            this.ssTotalG = new double[this.nComparisons];
            this.ssWithinG = new double[this.nComparisons];
            this.ssBetweenG = new double[this.nComparisons];
            this.ssTotalBDG = new BigDecimal[this.nComparisons];
            this.ssWithinBDG = new BigDecimal[this.nComparisons];
            this.ssBetweenBDG = new BigDecimal[this.nComparisons];
            this.dofTotalG = new int[this.nComparisons];
            this.dofBetweenG = new int[this.nComparisons];
            this.dofWithinG = new int[this.nComparisons];
            this.pairIndices = new int[this.nComparisons][2];
            double[][] dArrayArray = new double[2][];
            n = 0;
            for (int i = 0; i < this.nGroups - 1; ++i) {
                for (int j = i + 1; j < this.nGroups; ++j) {
                    if (!this.compGroups[i] || !this.compGroups[j]) continue;
                    dArrayArray[0] = this.responses0[i];
                    dArrayArray[1] = this.responses0[j];
                    this.pairIndices[n][0] = i;
                    this.pairIndices[n][1] = j;
                    ANOVA aNOVA = new ANOVA();
                    aNOVA.setAllCalcn(false);
                    aNOVA.enterResponseData(dArrayArray);
                    aNOVA.oneWayANOVA();
                    this.ssTotalG[n] = aNOVA.totalSumOfSquares();
                    this.ssWithinG[n] = aNOVA.withinGroupsSumOfSquares();
                    this.ssBetweenG[n] = aNOVA.betweenGroupsSumOfSquares();
                    this.ssTotalBDG[n] = new BigDecimal(this.ssTotalG[n]);
                    this.ssWithinBDG[n] = new BigDecimal(this.ssWithinG[n]);
                    this.ssBetweenBDG[n] = new BigDecimal(this.ssBetweenG[n]);
                    this.meanSquareTotalG[n] = aNOVA.totalMeanSquare();
                    this.meanSquareWithinG[n] = aNOVA.withinGroupsMeanSquare();
                    this.meanSquareBetweenG[n] = aNOVA.betweenGroupsMeanSquare();
                    this.meanSquareTotalBDG[n] = new BigDecimal(this.meanSquareTotalG[n]);
                    this.meanSquareWithinBDG[n] = new BigDecimal(this.meanSquareWithinG[n]);
                    this.meanSquareBetweenBDG[n] = new BigDecimal(this.meanSquareBetweenG[n]);
                    this.fRatioG[n] = aNOVA.oneWayFratio();
                    this.fRatioBDG[n] = new BigDecimal(this.fRatioG[n]);
                    this.fRatioPG[n] = aNOVA.oneWaySignificance();
                    this.criticalFratioG[n] = aNOVA.criticalFratio();
                    this.dofTotalG[n] = aNOVA.totalDoF();
                    this.dofBetweenG[n] = aNOVA.betweenGroupsDoF();
                    this.dofWithinG[n] = aNOVA.withinGroupsDoF();
                    ++n;
                }
            }
        }
        this.oneWayDone = true;
    }

    private void oneWayANOVA_BD() {
        int n;
        if (!this.groupStatsDone) {
            if (this.allCalcn) {
                this.groupStatisticsBD();
            } else {
                int n2;
                int n3;
                this.totalMeanBD = new BigDecimal("0.0");
                for (n3 = 0; n3 < this.nGroups; ++n3) {
                    for (n2 = 0; n2 < this.nResponsesPerGroup[n3]; ++n2) {
                        this.totalMeanBD = this.totalMeanBD.add(this.responsesBD[n3][n2]);
                    }
                }
                this.totalMeanBD = this.totalMeanBD.divide(new BigDecimal(this.nTotalResponses), 4);
                this.totalMean = this.totalMeanBD.doubleValue();
                this.groupMeans = new double[this.nGroups];
                this.groupMeansBD = new BigDecimal[this.nGroups];
                for (n3 = 0; n3 < this.nGroups; ++n3) {
                    this.groupMeansBD[n3] = new BigDecimal("0.0");
                    for (n2 = 0; n2 < this.nResponsesPerGroup[n3]; ++n2) {
                        this.groupMeansBD[n3] = this.groupMeansBD[n3].add(this.responsesBD[n3][n2]);
                    }
                    this.groupMeansBD[n3] = this.groupMeansBD[n3].divide(new BigDecimal(this.nResponsesPerGroup[n3]), 4);
                    this.groupMeans[n3] = this.groupMeansBD[n3].doubleValue();
                }
            }
        }
        this.dofTotal = this.nTotalResponses - 1;
        this.dofBetweenGroups = this.nGroups - 1;
        this.dofWithinGroups = this.nTotalResponses - this.nGroups;
        BigDecimal bigDecimal = new BigDecimal("0.0");
        BigDecimal bigDecimal2 = new BigDecimal("0.0");
        BigDecimal bigDecimal3 = new BigDecimal("0.0");
        BigDecimal bigDecimal4 = new BigDecimal("0.0");
        for (int i = 0; i < this.nGroups; ++i) {
            for (n = 0; n < this.nResponsesPerGroup[i]; ++n) {
                bigDecimal4 = this.responsesBD[i][n].subtract(this.totalMeanBD);
                bigDecimal = bigDecimal.add(bigDecimal4.multiply(bigDecimal4));
                bigDecimal4 = this.groupMeansBD[i].subtract(this.totalMeanBD);
                bigDecimal2 = bigDecimal2.add(bigDecimal4.multiply(bigDecimal4));
                bigDecimal4 = this.responsesBD[i][n].subtract(this.groupMeansBD[i]);
                bigDecimal3 = bigDecimal3.add(bigDecimal4.multiply(bigDecimal4));
            }
        }
        this.ssTotalBD = bigDecimal;
        this.ssTotal = bigDecimal.doubleValue();
        this.meanSquareTotalBD = bigDecimal.divide(new BigDecimal((double)this.dofTotal), 4);
        this.meanSquareTotal = this.meanSquareTotalBD.doubleValue();
        this.totalSD = Math.sqrt(this.meanSquareTotalBD.doubleValue());
        this.ssBetweenBD = bigDecimal2;
        this.ssBetween = bigDecimal2.doubleValue();
        this.meanSquareBetweenBD = bigDecimal2.divide(new BigDecimal((double)this.dofBetweenGroups), 4);
        this.meanSquareBetween = this.meanSquareBetweenBD.doubleValue();
        this.ssWithinBD = bigDecimal3;
        this.ssWithin = bigDecimal3.doubleValue();
        this.meanSquareWithinBD = bigDecimal3.divide(new BigDecimal((double)this.dofWithinGroups), 4);
        this.meanSquareWithin = this.meanSquareWithinBD.doubleValue();
        this.fRatioBD = this.meanSquareBetweenBD.divide(this.meanSquareWithinBD, 4);
        this.fRatio = this.fRatioBD.doubleValue();
        this.fRatioP = Stat.fCompCDF(this.fRatio, this.dofBetweenGroups, this.dofWithinGroups);
        this.criticalFratio = Stat.fDistributionInverseCDF(this.dofBetweenGroups, this.dofWithinGroups, this.criticalSignificance);
        if (this.nGroups > 2 && this.comparison) {
            this.meanSquareTotalG = new double[this.nComparisons];
            this.meanSquareWithinG = new double[this.nComparisons];
            this.meanSquareBetweenG = new double[this.nComparisons];
            this.meanSquareTotalBDG = new BigDecimal[this.nComparisons];
            this.meanSquareWithinBDG = new BigDecimal[this.nComparisons];
            this.meanSquareBetweenBDG = new BigDecimal[this.nComparisons];
            this.fRatioG = new double[this.nComparisons];
            this.fRatioBDG = new BigDecimal[this.nComparisons];
            this.fRatioPG = new double[this.nComparisons];
            this.criticalFratioG = new double[this.nComparisons];
            this.ssTotalG = new double[this.nComparisons];
            this.ssWithinG = new double[this.nComparisons];
            this.ssBetweenG = new double[this.nComparisons];
            this.ssTotalBDG = new BigDecimal[this.nComparisons];
            this.ssWithinBDG = new BigDecimal[this.nComparisons];
            this.ssBetweenBDG = new BigDecimal[this.nComparisons];
            this.dofTotalG = new int[this.nComparisons];
            this.dofBetweenG = new int[this.nComparisons];
            this.dofWithinG = new int[this.nComparisons];
            this.pairIndices = new int[this.nComparisons][2];
            BigDecimal[][] bigDecimalArray = new BigDecimal[2][];
            n = 0;
            for (int i = 0; i < this.nGroups - 1; ++i) {
                for (int j = i + 1; j < this.nGroups; ++j) {
                    if (!this.compGroups[i] || !this.compGroups[j]) continue;
                    bigDecimalArray[0] = this.responsesBD[i];
                    bigDecimalArray[1] = this.responsesBD[j];
                    this.pairIndices[n][0] = i;
                    this.pairIndices[n][1] = j;
                    ANOVA aNOVA = new ANOVA();
                    aNOVA.setAllCalcn(false);
                    aNOVA.enterResponseData(bigDecimalArray);
                    aNOVA.oneWayANOVA();
                    this.ssTotalBDG[n] = aNOVA.totalSumOfSquares_as_BD();
                    this.ssWithinBDG[n] = aNOVA.withinGroupsSumOfSquares_as_BD();
                    this.ssBetweenBDG[n] = aNOVA.betweenGroupsSumOfSquares_as_BD();
                    this.ssTotalG[n] = this.ssTotalBDG[n].doubleValue();
                    this.ssWithinG[n] = this.ssWithinBDG[n].doubleValue();
                    this.ssBetweenG[n] = this.ssBetweenBDG[n].doubleValue();
                    this.meanSquareTotalBDG[n] = aNOVA.totalMeanSquare_as_BD();
                    this.meanSquareWithinBDG[n] = aNOVA.withinGroupsMeanSquare_as_BD();
                    this.meanSquareBetweenBDG[n] = aNOVA.betweenGroupsMeanSquare_as_BD();
                    this.meanSquareTotalG[n] = this.meanSquareTotalBDG[n].doubleValue();
                    this.meanSquareWithinG[n] = this.meanSquareWithinBDG[n].doubleValue();
                    this.meanSquareBetweenG[n] = this.meanSquareBetweenBDG[n].doubleValue();
                    this.fRatioBDG[n] = aNOVA.oneWayFratio_as_BD();
                    this.fRatioG[n] = this.fRatioBDG[n].doubleValue();
                    this.fRatioPG[n] = aNOVA.oneWaySignificance();
                    this.criticalFratioG[n] = aNOVA.criticalFratio();
                    this.dofTotalG[n] = aNOVA.totalDoF();
                    this.dofBetweenG[n] = aNOVA.betweenGroupsDoF();
                    this.dofWithinG[n] = aNOVA.withinGroupsDoF();
                    ++n;
                }
            }
        }
        this.oneWayDone = true;
    }

    public double oneWayFratio() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.fRatio;
    }

    public double oneWayFratio(int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 0;
        double d = 0.0;
        if (this.comparison) {
            if (this.compGroups[n3] && this.compGroups[n4]) {
                n5 = this.pairIndex(n3, n4);
                d = this.fRatioG[n5];
            } else {
                ANOVA aNOVA = new ANOVA();
                aNOVA.enterResponseData(this.responses0);
                aNOVA.oneWayANOVAwithPairComparison(n, n2);
                d = aNOVA.fRatioG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(n, n2);
            d = this.fRatioG[0];
        }
        return d;
    }

    public BigDecimal oneWayFratio_as_BD() {
        if (!this.oneWayDone) {
            this.oneWayANOVA_BD();
        }
        return this.fRatioBD;
    }

    public BigDecimal oneWayFratio_as_BD(int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 0;
        BigDecimal bigDecimal = new BigDecimal("0.0");
        if (this.comparison) {
            if (this.compGroups[n3] && this.compGroups[n4]) {
                n5 = this.pairIndex(n3, n4);
                bigDecimal = this.fRatioBDG[n5];
            } else {
                ANOVA aNOVA = new ANOVA();
                aNOVA.enterResponseData(this.responses0);
                aNOVA.oneWayANOVAwithPairComparison(n, n2);
                bigDecimal = aNOVA.fRatioBDG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(n, n2);
            bigDecimal = this.fRatioBDG[0];
        }
        return bigDecimal;
    }

    public double oneWaySignificance() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.fRatioP;
    }

    public double oneWaySignificance(int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 0;
        double d = 0.0;
        if (this.comparison) {
            if (this.compGroups[n3] && this.compGroups[n4]) {
                n5 = this.pairIndex(n3, n4);
                d = this.fRatioPG[n5];
            } else {
                ANOVA aNOVA = new ANOVA();
                aNOVA.enterResponseData(this.responses0);
                aNOVA.oneWayANOVAwithPairComparison(n, n2);
                d = aNOVA.fRatioPG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(n, n2);
            d = this.fRatioPG[0];
        }
        return d;
    }

    public double criticalFratio() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.criticalFratio;
    }

    public double criticalFratio(int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 0;
        double d = 0.0;
        if (this.comparison) {
            if (this.compGroups[n3] && this.compGroups[n4]) {
                n5 = this.pairIndex(n3, n4);
                d = this.criticalFratioG[n5];
            } else {
                ANOVA aNOVA = new ANOVA();
                aNOVA.enterResponseData(this.responses0);
                aNOVA.oneWayANOVAwithPairComparison(n, n2);
                d = aNOVA.criticalFratioG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(n, n2);
            d = this.criticalFratioG[0];
        }
        return d;
    }

    public double totalMeanSquare() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.meanSquareTotal;
    }

    public double totalMeanSquare(int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 0;
        double d = 0.0;
        if (this.comparison) {
            if (this.compGroups[n3] && this.compGroups[n4]) {
                n5 = this.pairIndex(n3, n4);
                d = this.meanSquareTotalG[n5];
            } else {
                ANOVA aNOVA = new ANOVA();
                aNOVA.enterResponseData(this.responses0);
                aNOVA.oneWayANOVAwithPairComparison(n, n2);
                d = aNOVA.meanSquareTotalG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(n, n2);
            d = this.meanSquareTotalG[0];
        }
        return d;
    }

    public BigDecimal totalMeanSquare_as_BD() {
        if (!this.oneWayDone) {
            this.oneWayANOVA_BD();
        }
        return this.meanSquareTotalBD;
    }

    public BigDecimal totalMeanSquare_as_BD(int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 0;
        BigDecimal bigDecimal = new BigDecimal("0.0");
        if (this.comparison) {
            if (this.compGroups[n3] && this.compGroups[n4]) {
                n5 = this.pairIndex(n3, n4);
                bigDecimal = this.meanSquareTotalBDG[n5];
            } else {
                ANOVA aNOVA = new ANOVA();
                aNOVA.enterResponseData(this.responses0);
                aNOVA.oneWayANOVAwithPairComparison(n, n2);
                bigDecimal = aNOVA.meanSquareTotalBDG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(n, n2);
            bigDecimal = this.meanSquareTotalBDG[0];
        }
        return bigDecimal;
    }

    public double betweenGroupsMeanSquare() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.meanSquareBetween;
    }

    public double betweenGroupsMeanSquare(int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 0;
        double d = 0.0;
        if (this.comparison) {
            if (this.compGroups[n3] && this.compGroups[n4]) {
                n5 = this.pairIndex(n3, n4);
                d = this.meanSquareBetweenG[n5];
            } else {
                ANOVA aNOVA = new ANOVA();
                aNOVA.enterResponseData(this.responses0);
                aNOVA.oneWayANOVAwithPairComparison(n, n2);
                d = aNOVA.meanSquareBetweenG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(n, n2);
            d = this.meanSquareBetweenG[0];
        }
        return d;
    }

    public BigDecimal betweenGroupsMeanSquare_as_BD() {
        if (!this.oneWayDone) {
            this.oneWayANOVA_BD();
        }
        return this.meanSquareBetweenBD;
    }

    public BigDecimal betweenGroupsMeanSquare_as_BD(int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 0;
        BigDecimal bigDecimal = new BigDecimal("0.0");
        if (this.comparison) {
            if (this.compGroups[n3] && this.compGroups[n4]) {
                n5 = this.pairIndex(n3, n4);
                bigDecimal = this.meanSquareBetweenBDG[n5];
            } else {
                ANOVA aNOVA = new ANOVA();
                aNOVA.enterResponseData(this.responses0);
                aNOVA.oneWayANOVAwithPairComparison(n, n2);
                bigDecimal = aNOVA.meanSquareBetweenBDG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(n, n2);
            bigDecimal = this.meanSquareBetweenBDG[0];
        }
        return bigDecimal;
    }

    public double withinGroupsMeanSquare() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.meanSquareWithin;
    }

    public double withinGroupsMeanSquare(int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 0;
        double d = 0.0;
        if (this.comparison) {
            if (this.compGroups[n3] && this.compGroups[n4]) {
                n5 = this.pairIndex(n3, n4);
                d = this.meanSquareWithinG[n5];
            } else {
                ANOVA aNOVA = new ANOVA();
                aNOVA.enterResponseData(this.responses0);
                aNOVA.oneWayANOVAwithPairComparison(n, n2);
                d = aNOVA.meanSquareWithinG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(n, n2);
            d = this.meanSquareWithinG[0];
        }
        return d;
    }

    public BigDecimal withinGroupsMeanSquare_as_BD() {
        if (!this.oneWayDone) {
            this.oneWayANOVA_BD();
        }
        return this.meanSquareWithinBD;
    }

    public BigDecimal withinGroupsMeanSquare_as_BD(int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 0;
        BigDecimal bigDecimal = new BigDecimal("0.0");
        if (this.comparison) {
            if (this.compGroups[n3] && this.compGroups[n4]) {
                n5 = this.pairIndex(n3, n4);
                bigDecimal = this.meanSquareWithinBDG[n5];
            } else {
                ANOVA aNOVA = new ANOVA();
                aNOVA.enterResponseData(this.responses0);
                aNOVA.oneWayANOVAwithPairComparison(n, n2);
                bigDecimal = aNOVA.meanSquareWithinBDG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(n, n2);
            bigDecimal = this.meanSquareWithinBDG[0];
        }
        return bigDecimal;
    }

    public double betweenGroupsSumOfSquares() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.ssBetween;
    }

    public double betweenGroupsSumOfSquares(int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 0;
        double d = 0.0;
        if (this.comparison) {
            if (this.compGroups[n3] && this.compGroups[n4]) {
                n5 = this.pairIndex(n3, n4);
                d = this.ssBetweenG[n5];
            } else {
                ANOVA aNOVA = new ANOVA();
                aNOVA.enterResponseData(this.responses0);
                aNOVA.oneWayANOVAwithPairComparison(n, n2);
                d = aNOVA.ssBetweenG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(n, n2);
            d = this.ssBetweenG[0];
        }
        return d;
    }

    public BigDecimal betweenGroupsSumOfSquares_as_BD() {
        if (!this.oneWayDone) {
            this.oneWayANOVA_BD();
        }
        return this.ssBetweenBD;
    }

    public BigDecimal betweenGroupsSumOfSquares_as_BD(int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 0;
        BigDecimal bigDecimal = new BigDecimal("0.0");
        if (this.comparison) {
            if (this.compGroups[n3] && this.compGroups[n4]) {
                n5 = this.pairIndex(n3, n4);
                bigDecimal = this.ssBetweenBDG[n5];
            } else {
                ANOVA aNOVA = new ANOVA();
                aNOVA.enterResponseData(this.responses0);
                aNOVA.oneWayANOVAwithPairComparison(n, n2);
                bigDecimal = aNOVA.ssBetweenBDG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(n, n2);
            bigDecimal = this.ssBetweenBDG[0];
        }
        return bigDecimal;
    }

    public double withinGroupsSumOfSquares() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.ssWithin;
    }

    public double withinGroupsSumOfSquares(int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 0;
        double d = 0.0;
        if (this.comparison) {
            if (this.compGroups[n3] && this.compGroups[n4]) {
                n5 = this.pairIndex(n3, n4);
                d = this.ssWithinG[n5];
            } else {
                ANOVA aNOVA = new ANOVA();
                aNOVA.enterResponseData(this.responses0);
                aNOVA.oneWayANOVAwithPairComparison(n, n2);
                d = aNOVA.ssWithinG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(n, n2);
            d = this.ssWithinG[0];
        }
        return d;
    }

    public BigDecimal withinGroupsSumOfSquares_as_BD() {
        if (!this.oneWayDone) {
            this.oneWayANOVA_BD();
        }
        return this.ssWithinBD;
    }

    public BigDecimal withinGroupsSumOfSquares_as_BD(int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 0;
        BigDecimal bigDecimal = new BigDecimal("0.0");
        if (this.comparison) {
            if (this.compGroups[n3] && this.compGroups[n4]) {
                n5 = this.pairIndex(n3, n4);
                bigDecimal = this.ssWithinBDG[n5];
            } else {
                ANOVA aNOVA = new ANOVA();
                aNOVA.enterResponseData(this.responses0);
                aNOVA.oneWayANOVAwithPairComparison(n, n2);
                bigDecimal = aNOVA.ssWithinBDG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(n, n2);
            bigDecimal = this.ssWithinBDG[0];
        }
        return bigDecimal;
    }

    public double totalSumOfSquares(int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 0;
        double d = 0.0;
        if (this.comparison) {
            if (this.compGroups[n3] && this.compGroups[n4]) {
                n5 = this.pairIndex(n3, n4);
                d = this.ssTotalG[n5];
            } else {
                ANOVA aNOVA = new ANOVA();
                aNOVA.enterResponseData(this.responses0);
                aNOVA.oneWayANOVAwithPairComparison(n, n2);
                d = aNOVA.ssTotalG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(n, n2);
            d = this.ssTotalG[0];
        }
        return d;
    }

    public BigDecimal totalSumOfSquares_as_BD(int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 0;
        BigDecimal bigDecimal = new BigDecimal("0.0");
        if (this.comparison) {
            if (this.compGroups[n3] && this.compGroups[n4]) {
                n5 = this.pairIndex(n3, n4);
                bigDecimal = this.ssTotalBDG[n5];
            } else {
                ANOVA aNOVA = new ANOVA();
                aNOVA.enterResponseData(this.responses0);
                aNOVA.oneWayANOVAwithPairComparison(n, n2);
                bigDecimal = aNOVA.ssTotalBDG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(n, n2);
            bigDecimal = this.ssTotalBDG[0];
        }
        return bigDecimal;
    }

    public int totalDoF() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.dofTotal;
    }

    public int totalDoF(int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 0;
        int n6 = 0;
        if (this.comparison) {
            if (this.compGroups[n3] && this.compGroups[n4]) {
                n5 = this.pairIndex(n3, n4);
                n6 = this.dofTotalG[n5];
            } else {
                ANOVA aNOVA = new ANOVA();
                aNOVA.enterResponseData(this.responses0);
                aNOVA.oneWayANOVAwithPairComparison(n, n2);
                n6 = aNOVA.dofTotalG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(n, n2);
            n6 = this.dofTotalG[0];
        }
        return n6;
    }

    public int withinGroupsDoF() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.dofWithinGroups;
    }

    public int withinGroupsDoF(int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 0;
        int n6 = 0;
        if (this.comparison) {
            if (this.compGroups[n3] && this.compGroups[n4]) {
                n5 = this.pairIndex(n3, n4);
                n6 = this.dofWithinG[n5];
            } else {
                ANOVA aNOVA = new ANOVA();
                aNOVA.enterResponseData(this.responses0);
                aNOVA.oneWayANOVAwithPairComparison(n, n2);
                n6 = aNOVA.dofWithinG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(n, n2);
            n6 = this.dofWithinG[0];
        }
        return n6;
    }

    public int betweenGroupsDoF() {
        if (!this.oneWayDone) {
            this.oneWayANOVA();
        }
        return this.dofBetweenGroups;
    }

    public int betweenGroupsDoF(int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 0;
        int n6 = 0;
        if (this.comparison) {
            if (this.compGroups[n3] && this.compGroups[n4]) {
                n5 = this.pairIndex(n3, n4);
                n6 = this.dofBetweenG[n5];
            } else {
                ANOVA aNOVA = new ANOVA();
                aNOVA.enterResponseData(this.responses0);
                aNOVA.oneWayANOVAwithPairComparison(n, n2);
                n6 = aNOVA.dofBetweenG[0];
            }
        } else {
            this.oneWayANOVAwithPairComparison(n, n2);
            n6 = this.dofBetweenG[0];
        }
        return n6;
    }

    private int pairIndex(int n, int n2) {
        int n3 = -1;
        int n4 = 0;
        boolean bl = true;
        while (bl) {
            if (this.pairIndices[n4][0] == n && this.pairIndices[n4][1] == n2) {
                n3 = n4;
                bl = false;
                continue;
            }
            if (this.pairIndices[n4][0] == n2 && this.pairIndices[n4][1] == n) {
                n3 = n4;
                bl = false;
                continue;
            }
            if (++n4 < this.nComparisons) continue;
            throw new IllegalArgumentException("No index found " + n + " and " + n2);
        }
        return n3;
    }

    public void outputAnalysis() {
        if (!this.oneWayDone) {
            System.out.println("Method outputAnalysis: As no ANOVA peforming method had been called a ANOVA of all groups, withour pair comparison, has now been performed");
            this.oneWayANOVA();
        }
        this.outputFilename = "OneWayANOVAoutput";
        switch (this.fileOption) {
            case 1: {
                this.outputFilename = this.outputFilename + ".txt";
                break;
            }
            case 2: {
                this.outputFilename = this.outputFilename + ".xls";
            }
        }
        String string = "Output file name for the one way ANOVA:";
        String string2 = "\nEnter the required name (as a single word) and click OK ";
        String string3 = "\nor simply click OK for default value";
        String string4 = string + string2 + string3;
        String string5 = this.outputFilename;
        this.outputFilename = Db.readLine(string4, string5);
        this.outputAnalysis(this.outputFilename);
    }

    public void outputAnalysis(String string) {
        if (!this.oneWayDone) {
            System.out.println("Method outputAnalysis: As no ANOVA peforming method had been called a ANOVA of all groups, withour pair comparison, has now been performed");
            this.oneWayANOVA();
        }
        this.outputFilename = string;
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(46);
        if (n == -1) {
            string2 = string;
            switch (this.fileOption) {
                case 1: {
                    this.outputFilename = this.outputFilename + ".txt";
                    break;
                }
                case 2: {
                    this.outputFilename = this.outputFilename + ".xls";
                }
            }
        } else {
            int n2;
            int n3;
            String[] stringArray;
            String[] stringArray2;
            String string4;
            String string5;
            String string6;
            String string7;
            string3 = string.substring(n).trim();
            string2 = string.substring(0, n).trim();
            if (string3.equalsIgnoreCase(".xlsx")) {
                string3 = ".xls";
                this.outputFilename = string2 + string3;
            }
            if (string3.equalsIgnoreCase(".xls") && this.fileOption == 1) {
                if (this.fileOptionSet) {
                    string7 = "Your entered output file type is " + string3;
                    string6 = "\nbut you have chosen a .txt output";
                    string5 = "Your output file name extension";
                    string4 = string7 + string6;
                    stringArray2 = new String[]{string4, "replace it with .txt [text file]"};
                    n2 = Db.optionBox(string5, stringArray2, stringArray = new String[]{"Retain", ".txt"}, n3 = 1);
                    if (n2 == 2) {
                        this.outputFilename = string2 + ".txt";
                    }
                } else {
                    this.fileOption = 2;
                }
            }
            if (string3.equalsIgnoreCase(".txt") && this.fileOption == 2) {
                if (this.fileOptionSet) {
                    string7 = "Your entered output file type is .txt";
                    string6 = "\nbut you have chosen a .xls output";
                    string5 = "Your output file name extension";
                    string4 = string7 + string6;
                    stringArray2 = new String[]{string4, "replace it with .xls [Excel file]"};
                    n2 = Db.optionBox(string5, stringArray2, stringArray = new String[]{"Retain", ".xls"}, n3 = 1);
                    if (n2 == 2) {
                        this.outputFilename = string2 + ".xls";
                    }
                } else {
                    this.fileOption = 1;
                }
            }
            if (!string3.equalsIgnoreCase(".txt") && !string3.equalsIgnoreCase(".xls")) {
                string7 = "Your extension is " + string3;
                string6 = "\n    Do you wish to retain it:";
                string4 = string7 + string6;
                string5 = "Your output file name extension";
                stringArray2 = new String[]{string4, "replace it with .txt [text file]", "replace it with .xls [MS Excel file]"};
                stringArray = new String[]{"Retain", ".txt", ".xls"};
                n3 = 1;
                n2 = Db.optionBox(string5, stringArray2, stringArray, n3);
                switch (n2) {
                    case 1: {
                        this.fileOption = 1;
                        break;
                    }
                    case 2: {
                        this.outputFilename = string2 + ".txt";
                        this.fileOption = 1;
                        break;
                    }
                    case 3: {
                        this.outputFilename = string2 + ".xls";
                        this.fileOption = 2;
                    }
                }
            }
        }
        if (!this.truncAll) {
            this.setOutputPrecision();
        }
        if (this.fileOption == 1) {
            this.outputText();
        } else {
            this.outputExcel();
        }
        System.out.println("The ANOVA summary has been written to the file " + this.outputFilename);
    }

    private void setOutputPrecision() {
        int n;
        int n2 = n = Fmath.checkPrecision(this.responses0[0][0]);
        for (int i = 0; i < this.nGroups; ++i) {
            for (int j = 0; j < this.nResponsesPerGroup[i]; ++j) {
                n2 = Fmath.checkPrecision(this.responses0[i][j]);
                if (n2 <= n) continue;
                n = n2;
            }
        }
        if (!this.truncAll && n > this.trunc) {
            this.trunc = n;
        }
    }

    private void outputText() {
        int n;
        FileOutput fileOutput = new FileOutput(this.outputFilename);
        fileOutput.println("PROGRAM ANOVA");
        for (n = 0; n < this.nTitle; ++n) {
            fileOutput.println(this.title[n]);
        }
        if (this.inputFilename != null) {
            fileOutput.println("Input file name: " + this.inputFilename);
        }
        fileOutput.println("This output file name: " + this.outputFilename);
        fileOutput.println();
        fileOutput.println("ALL GROUPS: One-Way Analysis of Variance");
        fileOutput.print(" ", 16);
        fileOutput.print(" ", this.fieldD);
        fileOutput.print("  ", this.fieldD);
        fileOutput.print(" ", this.fieldD);
        fileOutput.print(" ", this.fieldD);
        fileOutput.print("F-ratio at", this.fieldD);
        fileOutput.println(" ");
        fileOutput.print(" ", 16);
        fileOutput.print("Sum of", this.fieldD);
        fileOutput.print("Degrees of ", this.fieldD);
        fileOutput.print("Mean ", this.fieldD);
        fileOutput.print(" ", this.fieldD);
        fileOutput.print(this.criticalSignificanceF + " critical", this.fieldD);
        fileOutput.println(" ");
        fileOutput.print(" ", 16);
        fileOutput.print("squares", this.fieldD);
        fileOutput.print("freedom ", this.fieldD);
        fileOutput.print("square ", this.fieldD);
        fileOutput.print("F-ratio ", this.fieldD);
        fileOutput.print("level", this.fieldD);
        fileOutput.println("Significance");
        fileOutput.print("Between groups", 16);
        fileOutput.print(Fmath.truncate(this.ssBetween, this.trunc), this.fieldD);
        fileOutput.print(this.dofBetweenGroups, this.fieldD);
        fileOutput.print(Fmath.truncate(this.meanSquareBetween, this.trunc), this.fieldD);
        fileOutput.print(Fmath.truncate(this.fRatio, this.trunc), this.fieldD);
        fileOutput.print(Fmath.truncate(this.criticalFratio, this.trunc), this.fieldD);
        fileOutput.println(Fmath.truncate(this.fRatioP, this.trunc));
        fileOutput.print("Within groups", 16);
        fileOutput.print(Fmath.truncate(this.ssWithin, this.trunc), this.fieldD);
        fileOutput.print(this.dofWithinGroups, this.fieldD);
        fileOutput.println(Fmath.truncate(this.meanSquareWithin, this.trunc));
        fileOutput.print("Total", 16);
        fileOutput.print(Fmath.truncate(this.ssTotal, this.trunc), this.fieldD);
        fileOutput.print(this.dofTotal, this.fieldD);
        fileOutput.println(Fmath.truncate(this.meanSquareTotal, this.trunc));
        fileOutput.println();
        fileOutput.println();
        fileOutput.println("ALL GROUPS: Individual Group Statistics");
        fileOutput.print(" ", this.fieldD);
        fileOutput.print(" ", this.fieldD);
        fileOutput.print(" ", this.fieldD);
        fileOutput.print(" ", this.fieldD);
        fileOutput.print(" ", this.fieldD);
        fileOutput.println(this.criticalSignificanceS + " confidence interval");
        fileOutput.print(" ", this.fieldD);
        fileOutput.print(" ", this.fieldD);
        fileOutput.print(" ", this.fieldD);
        fileOutput.print(" ", this.fieldD);
        fileOutput.print(" ", this.fieldD);
        fileOutput.println("of the mean");
        fileOutput.print(" ", this.fieldD);
        fileOutput.print("Number of", this.fieldD);
        fileOutput.print(" ", this.fieldD);
        fileOutput.print("Standard", this.fieldD);
        fileOutput.print("Standard", this.fieldD);
        fileOutput.print("lower", this.fieldD);
        fileOutput.println("upper");
        fileOutput.print(" ", this.fieldD);
        fileOutput.print("responses", this.fieldD);
        fileOutput.print("Mean", this.fieldD);
        fileOutput.print("deviation", this.fieldD);
        fileOutput.print("error", this.fieldD);
        fileOutput.print("bound ", this.fieldD);
        fileOutput.println("bound ");
        for (n = 0; n < this.nGroups; ++n) {
            fileOutput.print(this.groupNames[n], this.fieldD);
            fileOutput.print(this.nResponsesPerGroup[n], this.fieldD);
            fileOutput.print(Fmath.truncate(this.groupMeans[n], this.trunc), this.fieldD);
            fileOutput.print(Fmath.truncate(this.groupSD[n], this.trunc), this.fieldD);
            fileOutput.print(Fmath.truncate(this.groupSE[n], this.trunc), this.fieldD);
            fileOutput.print(Fmath.truncate(this.groupClb[n], this.trunc), this.fieldD);
            fileOutput.println(Fmath.truncate(this.groupCub[n], this.trunc));
        }
        fileOutput.println(" ");
        fileOutput.print("Total", this.fieldD);
        fileOutput.print(this.nTotalResponses, this.fieldD);
        fileOutput.print(Fmath.truncate(this.totalMean, this.trunc), this.fieldD);
        fileOutput.print(Fmath.truncate(this.totalSD, this.trunc), this.fieldD);
        fileOutput.print(Fmath.truncate(this.totalSE, this.trunc), this.fieldD);
        fileOutput.print(Fmath.truncate(this.totalClb, this.trunc), this.fieldD);
        fileOutput.println(Fmath.truncate(this.totalCub, this.trunc));
        fileOutput.println();
        fileOutput.print("       ", this.fieldD);
        fileOutput.print("minimum", this.fieldD);
        fileOutput.print("median ", this.fieldD);
        fileOutput.print("maximum ", this.fieldD);
        fileOutput.print("moment ", this.fieldD);
        fileOutput.print("median ", this.fieldD);
        fileOutput.print("quartile ", this.fieldD);
        fileOutput.print("kurtosis ", this.fieldD);
        fileOutput.println("excess ");
        fileOutput.print("       ", this.fieldD);
        fileOutput.print("       ", this.fieldD);
        fileOutput.print("       ", this.fieldD);
        fileOutput.print("       ", this.fieldD);
        fileOutput.print("skewness", this.fieldD);
        fileOutput.print("skewness", this.fieldD);
        fileOutput.print("skewness", this.fieldD);
        fileOutput.print("        ", this.fieldD);
        fileOutput.println("kurtosis");
        for (n = 0; n < this.nGroups; ++n) {
            fileOutput.print(this.groupNames[n], this.fieldD);
            fileOutput.print(Fmath.truncate(this.groupMinimum[n], this.trunc), this.fieldD);
            fileOutput.print(Fmath.truncate(this.groupMedians[n], this.trunc), this.fieldD);
            fileOutput.print(Fmath.truncate(this.groupMaximum[n], this.trunc), this.fieldD);
            fileOutput.print(Fmath.truncate(this.groupMomentSkewness[n], this.trunc), this.fieldD);
            fileOutput.print(Fmath.truncate(this.groupMedianSkewness[n], this.trunc), this.fieldD);
            fileOutput.print(Fmath.truncate(this.groupQuartileSkewness[n], this.trunc), this.fieldD);
            fileOutput.print(Fmath.truncate(this.groupKurtosis[n], this.trunc), this.fieldD);
            fileOutput.println(Fmath.truncate(this.groupExcessKurtosis[n], this.trunc));
        }
        fileOutput.println(" ");
        fileOutput.print("Total", this.fieldD);
        fileOutput.print(Fmath.truncate(this.totalMinimum, this.trunc), this.fieldD);
        fileOutput.print(Fmath.truncate(this.totalMedian, this.trunc), this.fieldD);
        fileOutput.print(Fmath.truncate(this.totalMaximum, this.trunc), this.fieldD);
        fileOutput.print(Fmath.truncate(this.totalMomentSkewness, this.trunc), this.fieldD);
        fileOutput.print(Fmath.truncate(this.totalMedianSkewness, this.trunc), this.fieldD);
        fileOutput.print(Fmath.truncate(this.totalQuartileSkewness, this.trunc), this.fieldD);
        fileOutput.print(Fmath.truncate(this.totalKurtosis, this.trunc), this.fieldD);
        fileOutput.print(Fmath.truncate(this.totalExcessKurtosis, this.trunc), this.fieldD);
        fileOutput.println(Fmath.truncate(this.totalProbPlotR, this.trunc));
        fileOutput.println();
        fileOutput.println("Gaussian Probability Plot");
        fileOutput.print("       ", this.fieldD);
        fileOutput.print("Correlation", this.fieldD);
        fileOutput.print("Gradient", this.fieldD);
        fileOutput.print("Intercept", this.fieldD);
        fileOutput.print("mu", this.fieldD);
        fileOutput.println("sigma");
        fileOutput.print("       ", this.fieldD);
        fileOutput.print("coefficient", this.fieldD);
        fileOutput.print("       ", this.fieldD);
        fileOutput.print("       ", this.fieldD);
        fileOutput.print("       ", this.fieldD);
        fileOutput.println("     ");
        for (n = 0; n < this.nGroups; ++n) {
            fileOutput.print(this.groupNames[n], this.fieldD);
            fileOutput.print(Fmath.truncate(this.groupProbPlotR[n], this.trunc), this.fieldD);
            fileOutput.print(Fmath.truncate(this.groupProbPlotGradient[n], this.trunc), this.fieldD);
            fileOutput.print(Fmath.truncate(this.groupProbPlotIntercept[n], this.trunc), this.fieldD);
            fileOutput.print(Fmath.truncate(this.groupProbPlotMu[n], this.trunc), this.fieldD);
            fileOutput.println(Fmath.truncate(this.groupProbPlotSigma[n], this.trunc));
        }
        fileOutput.println(" ");
        fileOutput.print("total", this.fieldD);
        fileOutput.print(Fmath.truncate(this.totalProbPlotR, this.trunc), this.fieldD);
        fileOutput.print(Fmath.truncate(this.totalProbPlotGradient, this.trunc), this.fieldD);
        fileOutput.print(Fmath.truncate(this.totalProbPlotIntercept, this.trunc), this.fieldD);
        fileOutput.print(Fmath.truncate(this.totalProbPlotMu, this.trunc), this.fieldD);
        fileOutput.println(Fmath.truncate(this.totalProbPlotSigma, this.trunc));
        if (this.nGroups > 2 && this.comparison) {
            fileOutput.println(" ");
            fileOutput.println(" ");
            fileOutput.println("COMPARISON OF PAIRS OF GROUPS: One-Way Analysis of Variance");
            n = 0;
            for (int i = 0; i < this.nGroups - 1; ++i) {
                for (int j = i + 1; j < this.nGroups; ++j) {
                    if (!this.compGroups[i] || !this.compGroups[j]) continue;
                    fileOutput.println("Group" + (i + 1) + " and Group" + (j + 1));
                    fileOutput.print(" ", 16);
                    fileOutput.print(" ", this.fieldD);
                    fileOutput.print("  ", this.fieldD);
                    fileOutput.print(" ", this.fieldD);
                    fileOutput.print(" ", this.fieldD);
                    fileOutput.print("F-ratio at", this.fieldD);
                    fileOutput.println(" ");
                    fileOutput.print(" ", 16);
                    fileOutput.print("Sum of", this.fieldD);
                    fileOutput.print("Degrees of ", this.fieldD);
                    fileOutput.print("Mean ", this.fieldD);
                    fileOutput.print(" ", this.fieldD);
                    fileOutput.print(this.criticalSignificanceF + " critical", this.fieldD);
                    fileOutput.println(" ");
                    fileOutput.print(" ", 16);
                    fileOutput.print("squares", this.fieldD);
                    fileOutput.print("freedom ", this.fieldD);
                    fileOutput.print("square ", this.fieldD);
                    fileOutput.print("F-ratio ", this.fieldD);
                    fileOutput.print("level", this.fieldD);
                    fileOutput.println("Significance");
                    fileOutput.print("Between groups", 16);
                    fileOutput.print(Fmath.truncate(this.ssBetweenG[n], this.trunc), this.fieldD);
                    fileOutput.print(this.dofBetweenG[n], this.fieldD);
                    fileOutput.print(Fmath.truncate(this.meanSquareBetweenG[n], this.trunc), this.fieldD);
                    fileOutput.print(Fmath.truncate(this.fRatioG[n], this.trunc), this.fieldD);
                    fileOutput.print(Fmath.truncate(this.criticalFratioG[n], this.trunc), this.fieldD);
                    fileOutput.println(Fmath.truncate(this.fRatioPG[n], this.trunc));
                    fileOutput.print("Within groups", 16);
                    fileOutput.print(Fmath.truncate(this.ssWithinG[n], this.trunc), this.fieldD);
                    fileOutput.print(this.dofWithinG[n], this.fieldD);
                    fileOutput.println(Fmath.truncate(this.meanSquareWithinG[n], this.trunc));
                    fileOutput.print("Total", 16);
                    fileOutput.print(Fmath.truncate(this.ssTotalG[n], this.trunc), this.fieldD);
                    fileOutput.print(this.dofTotalG[n], this.fieldD);
                    fileOutput.println(Fmath.truncate(this.meanSquareTotalG[n], this.trunc));
                    ++n;
                    fileOutput.println();
                    fileOutput.println();
                }
            }
        }
        fileOutput.close();
    }

    private void outputExcel() {
        int n;
        FileOutput fileOutput = new FileOutput(this.outputFilename);
        fileOutput.println("PROGRAM ANOVA");
        for (n = 0; n < this.nTitle; ++n) {
            fileOutput.println(this.title[n]);
        }
        if (this.inputFilename != null) {
            fileOutput.println("Input file name: " + this.inputFilename);
        }
        fileOutput.println("This output file name: " + this.outputFilename);
        fileOutput.println();
        fileOutput.println("ALL GROUPS: One-Way Analysis of Variance");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab("  ");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab("F-ratio at");
        fileOutput.println(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab("Sum of");
        fileOutput.printtab("Degrees of ");
        fileOutput.printtab("Mean ");
        fileOutput.printtab(" ");
        fileOutput.printtab(this.criticalSignificanceF + " critical");
        fileOutput.println(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab("squares");
        fileOutput.printtab("freedom ");
        fileOutput.printtab("square ");
        fileOutput.printtab("F-ratio ");
        fileOutput.printtab("level");
        fileOutput.println("Significance");
        fileOutput.printtab("Between groups");
        fileOutput.printtab(Fmath.truncate(this.ssBetween, this.trunc));
        fileOutput.printtab(this.dofBetweenGroups);
        fileOutput.printtab(Fmath.truncate(this.meanSquareBetween, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.fRatio, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.criticalFratio, this.trunc));
        fileOutput.println(Fmath.truncate(this.fRatioP, this.trunc));
        fileOutput.printtab("Within groups");
        fileOutput.printtab(Fmath.truncate(this.ssWithin, this.trunc));
        fileOutput.printtab(this.dofWithinGroups);
        fileOutput.println(Fmath.truncate(this.meanSquareWithin, this.trunc));
        fileOutput.printtab("Total");
        fileOutput.printtab(Fmath.truncate(this.ssTotal, this.trunc));
        fileOutput.printtab(this.dofTotal);
        fileOutput.println(Fmath.truncate(this.meanSquareTotal, this.trunc));
        fileOutput.println();
        fileOutput.println();
        fileOutput.println("ALL GROUPS: Individual Group Statistics");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.println(this.criticalSignificanceS + " confidence interval");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.println("of the mean");
        fileOutput.printtab(" ");
        fileOutput.printtab("Number of");
        fileOutput.printtab(" ");
        fileOutput.printtab("Standard");
        fileOutput.printtab("Standard");
        fileOutput.printtab("lower");
        fileOutput.println("upper");
        fileOutput.printtab(" ");
        fileOutput.printtab("responses");
        fileOutput.printtab("Mean");
        fileOutput.printtab("deviation");
        fileOutput.printtab("error");
        fileOutput.printtab("bound ");
        fileOutput.println("bound ");
        for (n = 0; n < this.nGroups; ++n) {
            fileOutput.printtab(this.groupNames[n]);
            fileOutput.printtab(this.nResponsesPerGroup[n]);
            fileOutput.printtab(Fmath.truncate(this.groupMeans[n], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.groupSD[n], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.groupSE[n], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.groupClb[n], this.trunc));
            fileOutput.println(Fmath.truncate(this.groupCub[n], this.trunc));
        }
        fileOutput.println(" ");
        fileOutput.printtab("Total");
        fileOutput.printtab(this.nTotalResponses);
        fileOutput.printtab(Fmath.truncate(this.totalMean, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.totalSD, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.totalSE, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.totalClb, this.trunc));
        fileOutput.println(Fmath.truncate(this.totalCub, this.trunc));
        fileOutput.println();
        fileOutput.printtab("       ");
        fileOutput.printtab("minimum");
        fileOutput.printtab("median ");
        fileOutput.printtab("maximum ");
        fileOutput.printtab("moment ");
        fileOutput.printtab("median ");
        fileOutput.printtab("quartile ");
        fileOutput.printtab("kurtosis ");
        fileOutput.println("excess ");
        fileOutput.printtab("       ");
        fileOutput.printtab("       ");
        fileOutput.printtab("       ");
        fileOutput.printtab("       ");
        fileOutput.printtab("skewness");
        fileOutput.printtab("skewness");
        fileOutput.printtab("skewness");
        fileOutput.printtab("        ");
        fileOutput.println("kurtosis");
        for (n = 0; n < this.nGroups; ++n) {
            fileOutput.printtab(this.groupNames[n]);
            fileOutput.printtab(Fmath.truncate(this.groupMinimum[n], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.groupMedians[n], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.groupMaximum[n], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.groupMomentSkewness[n], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.groupMedianSkewness[n], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.groupQuartileSkewness[n], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.groupKurtosis[n], this.trunc));
            fileOutput.println(Fmath.truncate(this.groupExcessKurtosis[n], this.trunc));
        }
        fileOutput.println(" ");
        fileOutput.printtab("Total");
        fileOutput.printtab(Fmath.truncate(this.totalMinimum, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.totalMedian, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.totalMaximum, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.totalMomentSkewness, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.totalMedianSkewness, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.totalQuartileSkewness, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.totalKurtosis, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.totalExcessKurtosis, this.trunc));
        fileOutput.println(Fmath.truncate(this.totalProbPlotR, this.trunc));
        fileOutput.println();
        fileOutput.println("Gaussian Probability Plot");
        fileOutput.printtab("       ");
        fileOutput.printtab("Correlation");
        fileOutput.printtab("Gradient");
        fileOutput.printtab("Intercept");
        fileOutput.printtab("mu");
        fileOutput.println("sigma");
        fileOutput.printtab("       ");
        fileOutput.printtab("coefficient");
        fileOutput.printtab("       ");
        fileOutput.printtab("       ");
        fileOutput.printtab("       ");
        fileOutput.println("     ");
        for (n = 0; n < this.nGroups; ++n) {
            fileOutput.printtab(this.groupNames[n]);
            fileOutput.printtab(Fmath.truncate(this.groupProbPlotR[n], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.groupProbPlotGradient[n], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.groupProbPlotIntercept[n], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.groupProbPlotMu[n], this.trunc));
            fileOutput.println(Fmath.truncate(this.groupProbPlotSigma[n], this.trunc));
        }
        fileOutput.println(" ");
        fileOutput.printtab("total");
        fileOutput.printtab(Fmath.truncate(this.totalProbPlotR, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.totalProbPlotGradient, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.totalProbPlotIntercept, this.trunc));
        fileOutput.printtab(Fmath.truncate(this.totalProbPlotMu, this.trunc));
        fileOutput.println(Fmath.truncate(this.totalProbPlotSigma, this.trunc));
        if (this.nGroups > 2 && this.comparison) {
            fileOutput.println(" ");
            fileOutput.println(" ");
            fileOutput.println("COMPARISON OF PAIRS OF GROUPS: One-Way Analysis of Variance");
            n = 0;
            for (int i = 0; i < this.nGroups - 1; ++i) {
                for (int j = i + 1; j < this.nGroups; ++j) {
                    if (!this.compGroups[i] || !this.compGroups[j]) continue;
                    fileOutput.println("Group" + (i + 1) + " and Group" + (j + 1));
                    fileOutput.printtab(" ");
                    fileOutput.printtab(" ");
                    fileOutput.printtab("  ");
                    fileOutput.printtab(" ");
                    fileOutput.printtab(" ");
                    fileOutput.printtab("F-ratio at");
                    fileOutput.println(" ");
                    fileOutput.printtab(" ");
                    fileOutput.printtab("Sum of");
                    fileOutput.printtab("Degrees of ");
                    fileOutput.printtab("Mean ");
                    fileOutput.printtab(" ");
                    fileOutput.printtab(this.criticalSignificanceF + " critical");
                    fileOutput.println(" ");
                    fileOutput.printtab(" ");
                    fileOutput.printtab("squares");
                    fileOutput.printtab("freedom ");
                    fileOutput.printtab("square ");
                    fileOutput.printtab("F-ratio ");
                    fileOutput.printtab("level");
                    fileOutput.println("Significance");
                    fileOutput.printtab("Between groups");
                    fileOutput.printtab(Fmath.truncate(this.ssBetweenG[n], this.trunc));
                    fileOutput.printtab(this.dofBetweenG[n]);
                    fileOutput.printtab(Fmath.truncate(this.meanSquareBetweenG[n], this.trunc));
                    fileOutput.printtab(Fmath.truncate(this.fRatioG[n], this.trunc));
                    fileOutput.printtab(Fmath.truncate(this.criticalFratioG[n], this.trunc));
                    fileOutput.println(Fmath.truncate(this.fRatioPG[n], this.trunc));
                    fileOutput.printtab("Within groups");
                    fileOutput.printtab(Fmath.truncate(this.ssWithinG[n], this.trunc));
                    fileOutput.printtab(this.dofWithinG[n]);
                    fileOutput.println(Fmath.truncate(this.meanSquareWithinG[n], this.trunc));
                    fileOutput.printtab("Total");
                    fileOutput.printtab(Fmath.truncate(this.ssTotalG[n], this.trunc));
                    fileOutput.printtab(this.dofTotalG[n], this.fieldD);
                    fileOutput.println(Fmath.truncate(this.meanSquareTotalG[n], this.trunc));
                    ++n;
                    fileOutput.println();
                    fileOutput.println();
                }
            }
        }
        fileOutput.close();
    }

    public void numberOfDecimalPlaces(int n) {
        this.trunc = n;
    }

    public void numberOfDecimalPlacesAll(int n) {
        this.trunc = n;
        this.truncAll = true;
    }
}

