/*
 * Decompiled with CFR 0.152.
 */
package utils.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XmlIO {
    public static void WriteJdom(Document document, Format format, String name) throws IOException {
        XMLOutputter output = new XMLOutputter(Format.getPrettyFormat());
        output.output(document, (OutputStream)new FileOutputStream(name));
    }

    public static Document ReadJdom(String file) throws IOException, JDOMException {
        SAXBuilder sxb = new SAXBuilder();
        return sxb.build(new File(file));
    }

    public static void WriteXStream(Object object, String name) throws FileNotFoundException {
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        xstream.toXML(object, (OutputStream)new FileOutputStream(name));
        xstream = null;
    }

    public static Object ReadXStream(String file) throws IOException {
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        return xstream.fromXML((InputStream)new FileInputStream(file));
    }

    public static void Display(Document document) {
        XmlIO.Display(document.getRootElement(), "", "\t");
    }

    public static void Display(Element element, String marge, String increment) {
        System.out.print(marge + "\u001b[35m<\u001b[34m" + element.getName());
        List children = element.getChildren();
        if (element.hasAttributes()) {
            System.out.print(" ");
            List attributes = element.getAttributes();
            for (Attribute att : attributes) {
                System.out.print("\u001b[30m" + att.getName() + "=\u001b[32m\"\u001b[31m" + att.getValue() + "\u001b[32m\" ");
                att = null;
            }
            if (children.isEmpty() && element.getValue().isEmpty()) {
                System.out.print("\u001b[35m/");
            }
        }
        System.out.print("\u001b[35m>");
        if (!children.isEmpty()) {
            System.out.println();
        }
        Iterator iterchildren = children.iterator();
        while (iterchildren.hasNext()) {
            XmlIO.Display((Element)iterchildren.next(), marge + increment, increment);
        }
        if (children.isEmpty()) {
            System.out.print(element.getValue());
            if (!element.getValue().isEmpty()) {
                System.out.println("\u001b[35m</\u001b[34m" + element.getName() + "\u001b[35m>");
            } else {
                System.out.println();
            }
        } else {
            System.out.println(marge + "\u001b[35m</\u001b[34m" + element.getName() + "\u001b[35m>");
        }
    }
}

