/*
 * Decompiled with CFR 0.152.
 */
package utils.times;

import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Chronometer {
    private List<TimeMarker> Markers = new LinkedList<TimeMarker>();
    private int nbMarkers;

    public Chronometer() {
        this.Reset();
    }

    public void Reset() {
        this.Markers.clear();
        this.nbMarkers = 0;
        this.Markers.add(new TimeMarker(this.nbMarkers++));
    }

    public int NewMarker() {
        this.Markers.add(new TimeMarker(this.nbMarkers++));
        return this.nbMarkers - 1;
    }

    @Deprecated
    public int setMarker() {
        return this.NewMarker();
    }

    public Calendar Marker(int marker) {
        return this.Markers.get((int)marker).time;
    }

    public void FreeMarker(int marker) {
        if (marker == 0) {
            throw new IllegalArgumentException("The original marker (index 0) cannot be removed!");
        }
        TimeMarker tm = this.Find(marker);
        if (tm == null) {
            throw new IllegalArgumentException("Marker not found!");
        }
        if (!this.Markers.remove(tm)) {
            throw new IllegalStateException("Marker not removed from the list.");
        }
        tm = null;
    }

    private TimeMarker Find(int marker) {
        Iterator<TimeMarker> iter = this.Markers.iterator();
        while (iter.hasNext()) {
            TimeMarker tm = iter.next();
            if (tm.number == marker) {
                iter = null;
                return tm;
            }
            Object var3_3 = null;
        }
        iter = null;
        return null;
    }

    public long getTimeSinceMarkerMilliSeconds(int marker) {
        Calendar now = Calendar.getInstance();
        Calendar cal = this.Find((int)marker).time;
        long time = now.getTimeInMillis() - cal.getTimeInMillis();
        cal = null;
        now = null;
        return time;
    }

    public double getTimeSinceMarker(int marker) {
        return (double)this.getTimeSinceMarkerMilliSeconds(marker) / 1000.0;
    }

    public long getTimeBetweenMilliSeconds(int marker1, int marker2) {
        TimeMarker tm1 = this.Find(marker1);
        TimeMarker tm2 = this.Find(marker2);
        long time = tm1.number < tm2.number ? tm2.time.getTimeInMillis() - tm1.time.getTimeInMillis() : tm1.time.getTimeInMillis() - tm2.time.getTimeInMillis();
        tm2 = null;
        tm1 = null;
        return time;
    }

    public double getTimeBetween(int marker1, int marker2) {
        return (double)this.getTimeBetweenMilliSeconds(marker1, marker2) / 1000.0;
    }

    private class TimeMarker {
        public final int number;
        public final Calendar time;

        public TimeMarker(int number) {
            this.number = number;
            this.time = Calendar.getInstance();
        }
    }
}

