/*
 * Decompiled with CFR 0.152.
 */
package utils.strings;

public class IntGenerator {
    private int nbnumbers;
    private int value;
    private int max;

    public IntGenerator(int start, int max) {
        if (max < start) {
            throw new IllegalArgumentException("max < start.");
        }
        this.value = start;
        this.max = max;
        this.nbnumbers = (int)Math.log10(max - 1) + 1;
    }

    public String Next() {
        return this.Next(1);
    }

    public String Next(int step) {
        if (this.max <= this.value) {
            throw new SecurityException("Maximum value reached.");
        }
        StringBuilder sb = new StringBuilder(this.nbnumbers);
        int length = this.value == 0 ? this.nbnumbers - 1 : this.nbnumbers - ((int)Math.log10(this.value) + 1);
        for (int i2 = 0; i2 < length; ++i2) {
            sb.append('0');
        }
        sb.append(this.value);
        this.value += step;
        return sb.toString();
    }
}

