/*
 * Decompiled with CFR 0.152.
 */
package utils.sorts;

import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;

public class QuickSort {
    public static void Sort(double[] TabDouble, int[] TabInt, int g, int d) {
        if (g < d) {
            int p = QuickSort.Partition(TabDouble, TabInt, g, d);
            QuickSort.Sort(TabDouble, TabInt, g, p - 1);
            QuickSort.Sort(TabDouble, TabInt, p + 1, d);
        }
    }

    private static int Partition(double[] TabDouble, int[] TabInt, int g, int d) {
        double c = TabDouble[g];
        int C = TabInt[g];
        int i2 = g + 1;
        int j = d;
        while (i2 <= j) {
            if (TabDouble[i2] > c) {
                int tam = TabInt[j];
                TabInt[j] = TabInt[i2];
                TabInt[i2] = tam;
                double tamp = TabDouble[j];
                TabDouble[j] = TabDouble[i2];
                TabDouble[i2] = tamp;
                --j;
                continue;
            }
            ++i2;
        }
        TabInt[g] = TabInt[j];
        TabDouble[g] = TabDouble[j];
        TabInt[j] = C;
        TabDouble[j] = c;
        return j;
    }

    public static void Sort(float[] TabDouble, int[] TabInt, int g, int d) {
        if (g < d) {
            int p = QuickSort.Partition(TabDouble, TabInt, g, d);
            QuickSort.Sort(TabDouble, TabInt, g, p - 1);
            QuickSort.Sort(TabDouble, TabInt, p + 1, d);
        }
    }

    private static int Partition(float[] TabDouble, int[] TabInt, int g, int d) {
        float c = TabDouble[g];
        int C = TabInt[g];
        int i2 = g + 1;
        int j = d;
        while (i2 <= j) {
            if (TabDouble[i2] > c) {
                int tam = TabInt[j];
                TabInt[j] = TabInt[i2];
                TabInt[i2] = tam;
                float tamp = TabDouble[j];
                TabDouble[j] = TabDouble[i2];
                TabDouble[i2] = tamp;
                --j;
                continue;
            }
            ++i2;
        }
        TabInt[g] = TabInt[j];
        TabDouble[g] = TabDouble[j];
        TabInt[j] = C;
        TabDouble[j] = c;
        return j;
    }

    public static void Sort(int[] TabInt1, int[] TabInt2, int g, int d) {
        if (g < d) {
            int p = QuickSort.Partition(TabInt1, TabInt2, g, d);
            QuickSort.Sort(TabInt1, TabInt2, g, p - 1);
            QuickSort.Sort(TabInt1, TabInt2, p + 1, d);
        }
    }

    private static int Partition(int[] TabInt1, int[] TabInt2, int g, int d) {
        int c = TabInt1[g];
        int C = TabInt2[g];
        int i2 = g + 1;
        int j = d;
        while (i2 <= j) {
            if (TabInt1[i2] > c) {
                int tam = TabInt2[j];
                TabInt2[j] = TabInt2[i2];
                TabInt2[i2] = tam;
                int tamp = TabInt1[j];
                TabInt1[j] = TabInt1[i2];
                TabInt1[i2] = tamp;
                --j;
                continue;
            }
            ++i2;
        }
        TabInt2[g] = TabInt2[j];
        TabInt1[g] = TabInt1[j];
        TabInt2[j] = C;
        TabInt1[j] = c;
        return j;
    }

    public static void Sort(int[] TabInt, boolean[] TabBool, int g, int d) {
        if (g < d) {
            int p = QuickSort.Partition(TabInt, TabBool, g, d);
            QuickSort.Sort(TabInt, TabBool, g, p - 1);
            QuickSort.Sort(TabInt, TabBool, p + 1, d);
        }
    }

    private static int Partition(int[] TabInt, boolean[] TabBool, int g, int d) {
        int c = TabInt[g];
        boolean C = TabBool[g];
        int i2 = g + 1;
        int j = d;
        while (i2 <= j) {
            if (c < TabInt[i2]) {
                boolean tam = TabBool[j];
                TabBool[j] = TabBool[i2];
                TabBool[i2] = tam;
                int tamp = TabInt[j];
                TabInt[j] = TabInt[i2];
                TabInt[i2] = tamp;
                --j;
                continue;
            }
            ++i2;
        }
        TabBool[g] = TabBool[j];
        TabInt[g] = TabInt[j];
        TabBool[j] = C;
        TabInt[j] = c;
        return j;
    }

    public static void Sort(FichierTabule file, int column, int g, int d) {
        int p = 0;
        FichierTabule mono = FichierTabuleTools.Same(file, 1);
        if (g < d) {
            switch (file.ColumnType(column)) {
                case 1: {
                    p = QuickSort.Partition(file, file.getColumnDouble(column), g, d, mono);
                    break;
                }
                case 0: {
                    p = QuickSort.Partition(file, file.getColumnInt(column), g, d, mono);
                    break;
                }
                case 2: {
                    p = QuickSort.Partition(file, file.getColumnString(column), g, d, mono);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Impossible to sort the file according to the given column type.");
                }
            }
            QuickSort.Sort(file, column, g, p - 1);
            QuickSort.Sort(file, column, p + 1, d);
        }
    }

    private static int Partition(FichierTabule file, int[] array, int g, int d, FichierTabule instance) {
        int c = array[g];
        FichierTabuleTools.CopyInstance(file, g, instance, 0);
        int i2 = g + 1;
        int j = d;
        while (i2 <= j) {
            if (c < array[i2]) {
                FichierTabuleTools.Swap(file, i2, j--);
                continue;
            }
            ++i2;
        }
        FichierTabuleTools.CopyInstance(file, j, file, g);
        FichierTabuleTools.CopyInstance(instance, 0, file, j);
        return j;
    }

    private static int Partition(FichierTabule file, double[] array, int g, int d, FichierTabule instance) {
        double c = array[g];
        FichierTabuleTools.CopyInstance(file, g, instance, 0);
        int i2 = g + 1;
        int j = d;
        while (i2 <= j) {
            if (c < array[i2]) {
                FichierTabuleTools.Swap(file, i2, j--);
                continue;
            }
            ++i2;
        }
        FichierTabuleTools.CopyInstance(file, j, file, g);
        FichierTabuleTools.CopyInstance(instance, 0, file, j);
        return j;
    }

    private static int Partition(FichierTabule file, String[] array, int g, int d, FichierTabule instance) {
        String c = array[g];
        FichierTabuleTools.CopyInstance(file, g, instance, 0);
        int i2 = g + 1;
        int j = d;
        while (i2 <= j) {
            if (c.compareTo(array[i2]) < 0) {
                FichierTabuleTools.Swap(file, i2, j--);
                continue;
            }
            ++i2;
        }
        FichierTabuleTools.CopyInstance(file, j, file, g);
        FichierTabuleTools.CopyInstance(instance, 0, file, j);
        return j;
    }
}

