/*
 * Decompiled with CFR 0.152.
 */
package utils.sorts;

import arrayTiTi.ArrayFeatures;

public class BucketSort {
    public static void Sort(int[] array, int first, int last) {
        ArrayFeatures AF = new ArrayFeatures();
        BucketSort.Sort(array, first, last, AF.Maximum(array) + 1);
    }

    public static void Sort(int[] array, int first, int last, int bucket) {
        int x;
        int[] hist = new int[bucket];
        for (x = first; x < last; ++x) {
            int n = array[x];
            hist[n] = hist[n] + 1;
        }
        int pos = 0;
        for (x = first; x < bucket; ++x) {
            while (0 < hist[x]) {
                array[pos++] = x;
                int n = x;
                hist[n] = hist[n] - 1;
            }
        }
    }

    public static void SortUnsigned(byte[] array, int first, int last) {
        ArrayFeatures AF = new ArrayFeatures();
        BucketSort.SortUnsigned(array, first, last, AF.Maximum(array) + 1);
    }

    public static void SortUnsigned(byte[] array, int first, int last, int bucket) {
        int x;
        int[] hist = new int[bucket];
        for (x = first; x < last; ++x) {
            int n = array[x] & 0xFF;
            hist[n] = hist[n] + 1;
        }
        int pos = 0;
        for (x = first; x < bucket; ++x) {
            while (0 < hist[x]) {
                array[pos++] = (byte)x;
                int n = x;
                hist[n] = hist[n] - 1;
            }
        }
    }

    public static void SortUnsigned(short[] array, int first, int last) {
        ArrayFeatures AF = new ArrayFeatures();
        BucketSort.SortUnsigned(array, first, last, AF.Maximum(array) + 1);
    }

    public static void SortUnsigned(short[] array, int first, int last, int bucket) {
        int x;
        int[] hist = new int[bucket];
        for (x = first; x < last; ++x) {
            int n = array[x] & 0xFFFF;
            hist[n] = hist[n] + 1;
        }
        int pos = 0;
        for (x = first; x < bucket; ++x) {
            while (0 < hist[x]) {
                array[pos++] = (byte)x;
                int n = x;
                hist[n] = hist[n] - 1;
            }
        }
    }
}

