/*
 * Decompiled with CFR 0.152.
 */
package utils.python;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import utils.LogFile;
import utils.process.ProcessUtils;

public class PythonLauncher {
    private final String Python_Path;

    public PythonLauncher(String Python_Path) {
        this.Python_Path = Python_Path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Run(String ScriptFile, StringBuilder ScriptText, String options, LogFile log, boolean DeleteAfterUse) throws IOException {
        File script = new File(ScriptFile);
        File dir = script.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        boolean success = false;
        try {
            try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(script));){
                dos.write(ScriptText.toString().getBytes("ISO-8859-1"));
                dos.close();
            }
            System.out.println("Python Launcher - Script successfully written.");
            success = this.Run(script, options, log, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (log != null) {
                log.addNewException(ex, "Python Launcher - Python script exception.");
            }
            success = false;
        }
        catch (Error e) {
            e.printStackTrace();
            if (log != null) {
                log.addNewError(e, "Python Launcher - Python script error");
            }
            success = false;
        }
        finally {
            if (DeleteAfterUse) {
                script.delete();
            }
            dir = null;
            script = null;
        }
        System.out.flush();
        System.err.flush();
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Run(File Script, String options, LogFile log, boolean DeleteAfterUse) throws IOException {
        block14: {
            try {
                String[] cmd;
                String[] opt;
                String[] stringArray = opt = options != null ? options.split(" ") : null;
                if (opt == null) {
                    cmd = new String[]{this.Python_Path, Script.getAbsolutePath()};
                } else {
                    cmd = new String[opt.length + 2];
                    cmd[0] = this.Python_Path;
                    System.arraycopy(opt, 0, cmd, 1, opt.length);
                    cmd[cmd.length - 1] = Script.getAbsolutePath();
                }
                System.out.print("Python Launcher - Running command: ");
                for (int i2 = 0; i2 < cmd.length - 1; ++i2) {
                    System.out.print(cmd[i2] + " ");
                }
                System.out.println(" \"" + cmd[cmd.length - 1] + "\"");
                System.out.flush();
                Process process = Runtime.getRuntime().exec(cmd);
                String Errors = ProcessUtils.ListenErrors(process, false);
                String Outputs = ProcessUtils.ListenOutputs(process, false);
                int Exit = process.waitFor();
                System.out.println("Python Launcher -");
                System.out.println("<Outputs>\n" + Outputs + "</Outputs>\n");
                if (Exit == 0) {
                    System.out.println("Python Launcher - Python script successfully executed.");
                    break block14;
                }
                System.out.println("Python Launcher - Python script failed with exit code: " + Exit);
                System.out.println("<Errors>\n" + Errors + "</Errors>\n\n");
                log.addNewError(new Error("Python script failed with exit code: " + Exit), Errors);
                boolean bl = false;
                return bl;
            }
            catch (IOException | InterruptedException ex) {
                ex.printStackTrace();
                if (log != null) {
                    log.addNewException(ex, "PyTorch script exception.");
                }
                boolean bl = false;
                return bl;
            }
            catch (Error e) {
                e.printStackTrace();
                if (log != null) {
                    log.addNewError(e, "PyTorch script error.");
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (DeleteAfterUse) {
                    Script.delete();
                }
            }
        }
        return true;
    }
}

