/*
 * Decompiled with CFR 0.152.
 */
package utils.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProcessUtils {
    public static List<String> getEnvironmentVariableNames() {
        Map<String, String> map = System.getenv();
        ArrayList<String> list = new ArrayList<String>(map.size());
        map.entrySet().forEach(entry -> list.add((String)entry.getKey()));
        return list;
    }

    public static String getEnvironmentVariableValues() {
        StringBuilder sb = new StringBuilder(1000);
        Map<String, String> map = System.getenv();
        map.entrySet().forEach(entry -> sb.append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append("\n"));
        return sb.toString();
    }

    public static String ListenErrors(Process process, boolean Display2) throws IOException {
        StringBuilder sb = new StringBuilder(1000);
        InputStream stderr = process.getErrorStream();
        InputStreamReader isr = new InputStreamReader(stderr);
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line).append("\n");
            if (!Display2) continue;
            System.out.println("Error: " + line);
        }
        return sb.toString();
    }

    public static String ListenOutputs(Process process, boolean Display2) throws IOException {
        StringBuilder sb = new StringBuilder(1000);
        InputStream stdin = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(stdin);
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line).append("\n");
            if (!Display2) continue;
            System.out.println("Outputs: " + line);
        }
        return sb.toString();
    }
}

