/*
 * Decompiled with CFR 0.152.
 */
package utils.jar;

import arrayTiTi.ArrayFeatures;
import filesAndFolders.FilesFolders;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;

public class SmallestJar {
    private final List<String> classes = new LinkedList<String>();
    private final List<String> classpath = new LinkedList<String>();
    private final List<String> toprocess = new LinkedList<String>();
    private boolean[] processed = null;
    private final ArrayFeatures AF = new ArrayFeatures();

    public void Process(List<String> targets, String rootpath, String output) throws IOException {
        File f;
        this.classes.clear();
        this.classpath.clear();
        this.FindClasses(rootpath);
        this.Initializations();
        this.toprocess.clear();
        for (int t = 0; t < targets.size(); ++t) {
            this.toprocess.add(targets.get(t));
        }
        while (0 < this.toprocess.size()) {
            f = new File(rootpath + "/" + this.toprocess.get(0));
            this.toprocess.remove(0);
            this.Process(f.getName(), f.getParent(), rootpath);
            f = null;
        }
        System.out.println("Analyze done, " + this.AF.Integral(this.processed) + " classes found.");
        for (int c = 0; c < this.processed.length; ++c) {
            if (!this.processed[c]) continue;
            String str = this.classpath.get(c).substring(rootpath.length());
            f = new File(output + "/" + str);
            if (!f.exists()) {
                f.mkdirs();
            }
            f = null;
            f = new File(output + "/" + str + "/" + this.classes.get(c));
            if (!f.exists()) {
                f.createNewFile();
            }
            FilesFolders.CopyFile(new File(rootpath + "/" + str + "/" + this.classes.get(c)), f);
            str = null;
            f = null;
        }
    }

    private void Process(String target, String path, String rootpath) {
        int pos = this.FindPosition(target, path);
        if (pos == -1) {
            return;
        }
        if (this.processed[pos]) {
            return;
        }
        this.processed[pos] = true;
        System.out.print("Processing '" + path + "/" + target + "'... ");
        System.out.flush();
        try {
            List<String> neighbors = this.FindNeighbors(target, path);
            Scanner input = new Scanner(new FileInputStream(new File(path + "/" + target)));
            while (input.hasNext()) {
                String line = input.nextLine();
                if (line.contains("import ")) {
                    String subline = line.substring(7, line.length() - 1);
                    subline = subline.replace('.', '/');
                    this.toprocess.add(subline + ".java");
                    continue;
                }
                int n = 0;
                while (n < neighbors.size()) {
                    if (line.contains(neighbors.get(n))) {
                        int p = this.FindPosition(neighbors.get(n) + ".java", path);
                        String str = this.classpath.get(p);
                        pos = str.indexOf(rootpath);
                        if (0 <= pos) {
                            str = str.substring(rootpath.length());
                        }
                        this.toprocess.add(str + "/" + this.classes.get(p));
                        neighbors.remove(n);
                        continue;
                    }
                    ++n;
                }
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("FAIL!");
            System.out.flush();
            System.err.println("Unable to read: '" + path + "/" + target + "'");
            System.err.flush();
        }
        System.out.println("successfully.");
        System.out.flush();
    }

    private List<String> FindNeighbors(String name, String path) {
        File file = new File(path);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("This path is not a folder: '" + path + "'.");
        }
        File[] files = file.listFiles();
        LinkedList<String> neighbors = new LinkedList<String>();
        for (int f = 0; f < files.length; ++f) {
            if (!files[f].isFile() || !files[f].getName().contains(".java") || files[f].getName().equalsIgnoreCase(name)) continue;
            neighbors.add(files[f].getName().substring(0, files[f].getName().length() - 5));
        }
        return neighbors;
    }

    private int FindPosition(String name, String path) {
        for (int i2 = 0; i2 < this.classes.size(); ++i2) {
            if (!this.classes.get(i2).equalsIgnoreCase(name) || !this.classpath.get(i2).equalsIgnoreCase(path)) continue;
            return i2;
        }
        return -1;
    }

    private void Initializations() {
        this.processed = new boolean[this.classes.size()];
        Arrays.fill(this.processed, false);
    }

    private void FindClasses(String rootpath) {
        File[] files;
        for (File file : files = new File(rootpath).listFiles()) {
            if (file.isDirectory()) {
                this.FindClasses(file.getAbsolutePath());
                continue;
            }
            if (!file.isFile() || !file.getName().contains(".java")) continue;
            this.classes.add(file.getName());
            this.classpath.add(file.getParent());
        }
    }
}

