/*
 * Decompiled with CFR 0.152.
 */
package utils.cmd;

import java.io.IOException;
import utils.LogFile;
import utils.process.ProcessUtils;

public class LaunchCMD {
    public boolean Run(String cmd, LogFile log) throws IOException {
        try {
            System.out.println(" - Executing command: " + cmd + "\"");
            Process process = Runtime.getRuntime().exec(cmd);
            String Errors = ProcessUtils.ListenErrors(process, false);
            String Outputs = ProcessUtils.ListenOutputs(process, false);
            int Exit = process.waitFor();
            if (Exit == 0) {
                System.out.println(" - Command successfully executed.");
            } else {
                System.out.println(" - Command failed with exit code: " + Exit);
                System.out.println("<Errors>\n" + Errors + "</Errors>\n\n");
                log.addNewError(new Error("Command failed with exit code: " + Exit), Errors);
            }
            System.out.println(" - Executed command -");
            System.out.println("<Outputs>\n" + Outputs + "</Outputs>\n\n");
        }
        catch (IOException | InterruptedException ex) {
            ex.printStackTrace();
            if (log != null) {
                log.addNewException(ex, "PyTorch script exception.");
            }
            return false;
        }
        catch (Error e) {
            e.printStackTrace();
            if (log != null) {
                log.addNewError(e, "PyTorch script error.");
            }
            return false;
        }
        return true;
    }

    public boolean Run(String cmd, String[] env, LogFile log) throws IOException {
        try {
            System.out.println(" - Executing command: " + cmd + "\"");
            System.out.print(" - Variables: ");
            for (String s : env) {
                System.out.print("'" + s + "' ");
            }
            System.out.println();
            Process process = Runtime.getRuntime().exec(cmd, env);
            String Errors = ProcessUtils.ListenErrors(process, false);
            String Outputs = ProcessUtils.ListenOutputs(process, false);
            int Exit = process.waitFor();
            System.out.println(" - Commmand Executed.");
            System.out.println("<Outputs>\n" + Outputs + "</Outputs>\n\n");
            if (Exit != 0) {
                System.out.println(" - Command failed with exit code: " + Exit);
                System.out.println("<Errors>\n" + Errors + "</Errors>\n\n");
                log.addNewError(new Error("Command failed with exit code: " + Exit), Errors);
                return false;
            }
            System.out.println(" - Command successfully executed.");
        }
        catch (IOException | InterruptedException ex) {
            ex.printStackTrace();
            if (log != null) {
                log.addNewException(ex, "PyTorch script exception.");
            }
            return false;
        }
        catch (Error e) {
            e.printStackTrace();
            if (log != null) {
                log.addNewError(e, "PyTorch script error.");
            }
            return false;
        }
        return true;
    }

    public boolean Run(String[] cmd, String[] env, LogFile log) throws IOException {
        try {
            System.out.print(" - Executing command: ");
            for (String s : cmd) {
                System.out.print("'" + s + "' ");
            }
            System.out.println();
            System.out.print(" - Variables: ");
            for (String s : env) {
                System.out.print("'" + s + "' ");
            }
            System.out.println();
            Process process = Runtime.getRuntime().exec(cmd, env);
            String Errors = ProcessUtils.ListenErrors(process, false);
            String Outputs = ProcessUtils.ListenOutputs(process, false);
            int Exit = process.waitFor();
            System.out.println(" - Commmand Executed.");
            System.out.println("<Outputs>\n" + Outputs + "</Outputs>\n");
            if (Exit != 0) {
                System.out.println(" - Command failed with exit code: " + Exit);
                System.out.println("<Errors>\n" + Errors + "</Errors>\n\n");
                log.addNewError(new Error("Command failed with exit code: " + Exit), Errors);
                return false;
            }
            System.out.println(" - Command successfully executed.");
        }
        catch (IOException | InterruptedException ex) {
            ex.printStackTrace();
            if (log != null) {
                log.addNewException(ex, "PyTorch script exception.");
            }
            return false;
        }
        catch (Error e) {
            e.printStackTrace();
            if (log != null) {
                log.addNewError(e, "PyTorch script error.");
            }
            return false;
        }
        return true;
    }
}

