/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ProjectLineCounter {
    public boolean verbose = false;
    public boolean DebugMode = false;
    private FileFilter ff = pathname -> pathname.isDirectory() || pathname.isFile() && pathname.getName().charAt(0) != '.' && (pathname.getName().endsWith(".java") || pathname.getName().endsWith(".cpp") || pathname.getName().endsWith(".cc") || pathname.getName().endsWith(".cxx") || pathname.getName().endsWith(".h") || pathname.getName().endsWith(".hpp") || pathname.getName().endsWith(".hxx"));
    private StreamTokenizer st = null;
    private int count = 0;
    private int countfiles = 0;
    private int countclasses = 0;
    private int countbraces = 0;
    private int countat = 0;
    private int countimport = 0;
    private int countifdef = 0;
    private int countdefine = 0;
    private int countinclude = 0;
    private int global = 0;
    private int globalfiles = 0;
    private int globalclasses = 0;
    private int globalbraces = 0;
    private int globalat = 0;
    private int globalimport = 0;
    private int globalifdef = 0;
    private int globaldefine = 0;
    private int globalinclude = 0;
    private boolean newline = false;
    private List<File> projects = new LinkedList<File>();
    private Type cft;

    public void AddProject(String file) {
        this.AddProject(new File(file));
    }

    public void AddProject(File file) {
        this.projects.add(file);
    }

    public void ClearProjets() {
        this.projects.clear();
    }

    public void Start() throws IOException {
        this.globalinclude = 0;
        this.globalifdef = 0;
        this.globalimport = 0;
        this.globalat = 0;
        this.globalbraces = 0;
        this.global = 0;
        this.globalclasses = 0;
        this.globalfiles = 0;
        Iterator<File> iter = this.projects.iterator();
        while (iter.hasNext()) {
            this.Count(iter.next());
            this.globalfiles += this.countfiles;
            this.globalclasses += this.countclasses;
            this.global += this.count;
            this.globalbraces += this.countbraces;
            this.globalat += this.countat;
            this.globalimport += this.countimport;
            this.globalifdef += this.countifdef;
            this.globalinclude += this.countinclude;
            this.globaldefine += this.countdefine;
            if (!this.verbose) continue;
            System.out.print("Sub-total:\n\t- " + this.countfiles + " files\n\t- " + this.countclasses + " classes\n\t- " + this.count + " lines\n\t- " + this.countbraces + " braces\n");
            switch (this.cft) {
                case CPP: {
                    System.out.println("\t- " + this.countifdef + " #ifdef/#endif\n\t- " + this.countinclude + " #include\n\t- " + this.countdefine + " #define\n");
                    break;
                }
                case JAVA: {
                    System.out.println("\t- " + this.countat + " @\n\t- " + this.countimport + " imports\n");
                    break;
                }
                default: {
                    throw new IllegalStateException("Must not occur.");
                }
            }
            System.out.println();
        }
        iter = null;
    }

    private void Count(File file) throws IOException {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("The file must be a directory");
        }
        this.countinclude = 0;
        this.countifdef = 0;
        this.countimport = 0;
        this.countat = 0;
        this.countbraces = 0;
        this.count = 0;
        this.countclasses = 0;
        this.countfiles = 0;
        this.CountRecursive(file);
    }

    private void CountRecursive(File file) throws IOException {
        int oldcount = 0;
        int oldclasses = 0;
        int oldbraces = 0;
        int oldat = 0;
        int oldimport = 0;
        int oldifdef = 0;
        int oldinclude = 0;
        int olddefine = 0;
        File[] files = file.listFiles(this.ff);
        if (files == null) {
            return;
        }
        block4: for (int i2 = 0; i2 < files.length; ++i2) {
            if (files[i2].isDirectory()) {
                this.CountRecursive(files[i2]);
                continue;
            }
            if (this.verbose) {
                oldcount = this.count;
                oldclasses = this.countclasses;
                oldbraces = this.countbraces;
                oldat = this.countat;
                oldimport = this.countimport;
                oldifdef = this.countifdef;
                oldinclude = this.countinclude;
                olddefine = this.countdefine;
                System.out.print(files[i2]);
            }
            this.CountSingleFile(files[i2]);
            if (!this.verbose) continue;
            System.out.print(", " + (this.countclasses - oldclasses) + " classes, " + (this.count - oldcount) + " lines, " + (this.countbraces - oldbraces) + " braces, ");
            switch (this.cft) {
                case CPP: {
                    System.out.println(this.countifdef - oldifdef + " #ifndef/#endif, " + (this.countinclude - oldinclude) + " #include, " + (this.countdefine - olddefine) + " #define");
                    continue block4;
                }
                case JAVA: {
                    System.out.println(this.countat - oldat + " @, " + (this.countimport - oldimport) + " imports");
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Must not occur.");
                }
            }
        }
        files = null;
    }

    public void CountSingleFile(File file) throws FileNotFoundException, IOException {
        int token;
        if (file.getName().endsWith(".java")) {
            this.cft = Type.JAVA;
        } else if (file.getName().endsWith(".cpp")) {
            this.cft = Type.CPP;
        } else if (file.getName().endsWith(".cc")) {
            this.cft = Type.CPP;
        } else if (file.getName().endsWith(".cxx")) {
            this.cft = Type.CPP;
        } else if (file.getName().endsWith(".h")) {
            this.cft = Type.CPP;
        } else if (file.getName().endsWith(".hpp")) {
            this.cft = Type.CPP;
        } else if (file.getName().endsWith(".hxx")) {
            this.cft = Type.CPP;
        }
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader br = new BufferedReader(isr);
        this.st = new StreamTokenizer(br);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.st.eolIsSignificant(true);
        ++this.countfiles;
        this.newline = true;
        block30: do {
            token = this.st.nextToken();
            if (this.DebugMode) {
                System.out.println(this.st.toString() + " " + token + "     count = " + this.count);
            }
            block0 : switch (token) {
                case -3: {
                    switch (this.st.sval) {
                        case "class": {
                            ++this.countclasses;
                            this.SkipLine(this.st);
                            break block0;
                        }
                        case "import": {
                            ++this.countimport;
                            this.SkipLine(this.st);
                            break block0;
                        }
                    }
                    if (!this.newline) continue block30;
                    if (this.DebugMode) {
                        System.out.println("NewLine.");
                    }
                    ++this.count;
                    this.newline = false;
                    break;
                }
                case -1: 
                case 10: {
                    this.newline = true;
                    break;
                }
                case -2: {
                    if (!this.newline) continue block30;
                    ++this.count;
                    this.newline = false;
                    if (!this.DebugMode) continue block30;
                    System.out.println("NewLine.");
                    break;
                }
                case 64: {
                    ++this.countat;
                    this.SkipLine(this.st);
                    break;
                }
                case 123: 
                case 125: {
                    if (!this.newline) continue block30;
                    switch (this.st.nextToken()) {
                        case 10: 
                        case 59: {
                            ++this.countbraces;
                            break block0;
                        }
                    }
                    ++this.count;
                    if (!this.DebugMode) continue block30;
                    System.out.println("NewLine.");
                    break;
                }
                case 35: {
                    token = this.st.nextToken();
                    if (token != -3) continue block30;
                    switch (this.st.sval) {
                        case "ifndef": 
                        case "endif": {
                            ++this.countifdef;
                            this.SkipLine(this.st);
                            break block0;
                        }
                        case "include": {
                            ++this.countinclude;
                            this.SkipLine(this.st);
                            break block0;
                        }
                        case "define": {
                            ++this.countdefine;
                            this.SkipLine(this.st);
                            break block0;
                        }
                    }
                    if (!this.newline) continue block30;
                    if (this.DebugMode) {
                        System.out.println("NewLine.");
                    }
                    ++this.count;
                    this.newline = false;
                    break;
                }
                default: {
                    if (!this.newline) continue block30;
                    ++this.count;
                    this.newline = false;
                    if (!this.DebugMode) continue block30;
                    System.out.println("NewLine.");
                }
            }
        } while (token != -1);
        this.st = null;
    }

    private void SkipLine(StreamTokenizer st) throws IOException {
        while (st.nextToken() != 10) {
        }
        this.newline = true;
    }

    public int Count() {
        return this.count;
    }

    public int Braces() {
        return this.countbraces;
    }

    public int Imports() {
        return this.countimport;
    }

    public int Classes() {
        return this.countclasses;
    }

    public int At() {
        return this.countat;
    }

    public int Ifdef() {
        return this.countifdef;
    }

    public String toString() {
        return "Total:\n\t- " + this.globalfiles + " files\n\t- " + this.globalclasses + " classes\n\t- " + this.global + " lines\n\t- " + this.globalbraces + " braces\n\t- " + this.globalat + " @\n\t- " + this.globalimport + " imports\n\t- " + this.globalifdef + " #ifdef/#endif\n\t- " + this.globalinclude + " #include\n\t- " + this.globaldefine + " #define\n";
    }

    private static enum Type {
        JAVA,
        CPP;

    }
}

