/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.google.common.base.Throwables;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import utils.times.Dates;

public class LogFile {
    private int nbErrors;
    private int nbExceptions;
    private DataOutputStream out = null;

    public void StartNewLog(Object object, String output) throws FileNotFoundException, IllegalStateException {
        if (this.out != null) {
            throw new IllegalStateException("Log file already opened, therefore an execution is still running.\nCall method 'Stop()' before starting a new one.");
        }
        this.nbExceptions = 0;
        this.nbErrors = 0;
        this.out = new DataOutputStream(new FileOutputStream(output + "/Log_" + (object != null ? object.getClass().getSimpleName() : "null") + "_" + Dates.DateAAAAMMJJ("_") + "_" + Dates.Time("_") + ".log"));
    }

    public void Stop() throws IOException, IllegalStateException {
        if (this.out == null) {
            throw new IllegalStateException("Any log file running.");
        }
        this.out.flush();
        this.out.write("\n\n\n".getBytes("ASCII"));
        this.out.write("Resume:\n".getBytes("ASCII"));
        this.out.write(this.Resume().toString().getBytes("ASCII"));
        this.out.flush();
        this.out.close();
        this.out = null;
    }

    public synchronized void addNewError(Error e, String ... comments) throws UnsupportedEncodingException, IOException {
        ++this.nbErrors;
        System.out.flush();
        System.err.flush();
        this.out.flush();
        this.out.write(String.valueOf(this.nbErrors + " - " + Dates.DateAAAAMMJJ("/") + "=> " + Dates.Time(":") + "\n").getBytes("ASCII"));
        this.out.write(String.valueOf(" - " + e.getMessage() + "\n").getBytes("ASCII"));
        this.out.write(String.valueOf(" - " + e.getLocalizedMessage() + "\n").getBytes("ASCII"));
        this.out.write(String.valueOf(" - " + e.fillInStackTrace().toString() + "\n").getBytes("ASCII"));
        this.out.write(String.valueOf(" - " + Throwables.getStackTraceAsString((Throwable)e) + "\n\n").getBytes("ASCII"));
        this.out.flush();
        if (comments != null) {
            for (String comment : comments) {
                this.addComment(comment);
            }
        }
    }

    public synchronized void addNewException(Exception e, String ... comments) throws UnsupportedEncodingException, IOException {
        ++this.nbExceptions;
        System.out.flush();
        System.err.flush();
        this.out.flush();
        this.out.write(String.valueOf(this.nbExceptions + " - " + Dates.DateAAAAMMJJ("/") + "=> " + Dates.Time(":") + "\n").getBytes("ASCII"));
        this.out.write(String.valueOf(" - " + e.getMessage() + "\n").getBytes("ASCII"));
        this.out.write(String.valueOf(" - " + e.getLocalizedMessage() + "\n").getBytes("ASCII"));
        this.out.write(String.valueOf(" - " + e.fillInStackTrace().toString() + "\n").getBytes("ASCII"));
        this.out.write(String.valueOf(" - " + Throwables.getStackTraceAsString((Throwable)e) + "\n\n").getBytes("ASCII"));
        this.out.flush();
        if (comments != null) {
            for (String comment : comments) {
                this.addComment(comment);
            }
        }
    }

    public synchronized void addComment(String comment) throws UnsupportedEncodingException, IOException {
        System.out.flush();
        System.err.flush();
        this.out.flush();
        this.out.write((comment + "\n\n").getBytes("ASCII"));
        this.out.flush();
    }

    public Appendable Resume() {
        StringBuilder sb = new StringBuilder(1013);
        sb.append("Number of errors = ").append(this.nbErrors).append('\n');
        sb.append("Number of exceptions = ").append(this.nbExceptions).append('\n');
        return sb;
    }

    public boolean isRunning() {
        return this.out != null;
    }
}

