/*
 * Decompiled with CFR 0.152.
 */
package tracking.texturetracker.tt_matrix;

import tracking.texturetracker.tt_matrix.TT_Maths;
import tracking.texturetracker.tt_matrix.TT_Matrix;

public class TT_SingularValueDecomposition {
    private double[][] U;
    private double[][] V;
    private double[] s;
    private int m;
    private int n;

    public TT_SingularValueDecomposition(TT_Matrix Arg) {
        int i2;
        double t;
        int k;
        int j;
        double[][] A = Arg.getArrayCopy();
        this.m = Arg.getRowDimension();
        this.n = Arg.getColumnDimension();
        int nu = Math.min(this.m, this.n);
        this.s = new double[Math.min(this.m + 1, this.n)];
        this.U = new double[this.m][nu];
        this.V = new double[this.n][this.n];
        double[] e = new double[this.n];
        double[] work = new double[this.m];
        boolean wantu = true;
        boolean wantv = true;
        int nct = Math.min(this.m - 1, this.n);
        int nrt = Math.max(0, Math.min(this.n - 2, this.m));
        for (int k2 = 0; k2 < Math.max(nct, nrt); ++k2) {
            int i3;
            int i4;
            if (k2 < nct) {
                this.s[k2] = 0.0;
                for (i4 = k2; i4 < this.m; ++i4) {
                    this.s[k2] = TT_Maths.hypot(this.s[k2], A[i4][k2]);
                }
                if (this.s[k2] != 0.0) {
                    if (A[k2][k2] < 0.0) {
                        this.s[k2] = -this.s[k2];
                    }
                    for (i4 = k2; i4 < this.m; ++i4) {
                        double[] dArray = A[i4];
                        int n = k2;
                        dArray[n] = dArray[n] / this.s[k2];
                    }
                    double[] dArray = A[k2];
                    int n = k2;
                    dArray[n] = dArray[n] + 1.0;
                }
                this.s[k2] = -this.s[k2];
            }
            for (j = k2 + 1; j < this.n; ++j) {
                if (k2 < nct & this.s[k2] != 0.0) {
                    double t2 = 0.0;
                    for (i3 = k2; i3 < this.m; ++i3) {
                        t2 += A[i3][k2] * A[i3][j];
                    }
                    t2 = -t2 / A[k2][k2];
                    for (i3 = k2; i3 < this.m; ++i3) {
                        double[] dArray = A[i3];
                        int n = j;
                        dArray[n] = dArray[n] + t2 * A[i3][k2];
                    }
                }
                e[j] = A[k2][j];
            }
            if (wantu & k2 < nct) {
                for (i4 = k2; i4 < this.m; ++i4) {
                    this.U[i4][k2] = A[i4][k2];
                }
            }
            if (k2 >= nrt) continue;
            e[k2] = 0.0;
            for (i4 = k2 + 1; i4 < this.n; ++i4) {
                e[k2] = TT_Maths.hypot(e[k2], e[i4]);
            }
            if (e[k2] != 0.0) {
                if (e[k2 + 1] < 0.0) {
                    e[k2] = -e[k2];
                }
                i4 = k2 + 1;
                while (i4 < this.n) {
                    int n = i4++;
                    e[n] = e[n] / e[k2];
                }
                int n = k2 + 1;
                e[n] = e[n] + 1.0;
            }
            e[k2] = -e[k2];
            if (k2 + 1 < this.m & e[k2] != 0.0) {
                for (i4 = k2 + 1; i4 < this.m; ++i4) {
                    work[i4] = 0.0;
                }
                for (j = k2 + 1; j < this.n; ++j) {
                    for (int i5 = k2 + 1; i5 < this.m; ++i5) {
                        int n = i5;
                        work[n] = work[n] + e[j] * A[i5][j];
                    }
                }
                for (j = k2 + 1; j < this.n; ++j) {
                    double t3 = -e[j] / e[k2 + 1];
                    for (i3 = k2 + 1; i3 < this.m; ++i3) {
                        double[] dArray = A[i3];
                        int n = j;
                        dArray[n] = dArray[n] + t3 * work[i3];
                    }
                }
            }
            if (!wantv) continue;
            for (i4 = k2 + 1; i4 < this.n; ++i4) {
                this.V[i4][k2] = e[i4];
            }
        }
        int p = Math.min(this.n, this.m + 1);
        if (nct < this.n) {
            this.s[nct] = A[nct][nct];
        }
        if (this.m < p) {
            this.s[p - 1] = 0.0;
        }
        if (nrt + 1 < p) {
            e[nrt] = A[nrt][p - 1];
        }
        e[p - 1] = 0.0;
        if (wantu) {
            for (j = nct; j < nu; ++j) {
                for (int i6 = 0; i6 < this.m; ++i6) {
                    this.U[i6][j] = 0.0;
                }
                this.U[j][j] = 1.0;
            }
            for (k = nct - 1; k >= 0; --k) {
                int i7;
                if (this.s[k] != 0.0) {
                    for (int j2 = k + 1; j2 < nu; ++j2) {
                        t = 0.0;
                        for (i2 = k; i2 < this.m; ++i2) {
                            t += this.U[i2][k] * this.U[i2][j2];
                        }
                        t = -t / this.U[k][k];
                        for (i2 = k; i2 < this.m; ++i2) {
                            double[] dArray = this.U[i2];
                            int n = j2;
                            dArray[n] = dArray[n] + t * this.U[i2][k];
                        }
                    }
                    for (i7 = k; i7 < this.m; ++i7) {
                        this.U[i7][k] = -this.U[i7][k];
                    }
                    this.U[k][k] = 1.0 + this.U[k][k];
                    for (i7 = 0; i7 < k - 1; ++i7) {
                        this.U[i7][k] = 0.0;
                    }
                    continue;
                }
                for (i7 = 0; i7 < this.m; ++i7) {
                    this.U[i7][k] = 0.0;
                }
                this.U[k][k] = 1.0;
            }
        }
        if (wantv) {
            for (k = this.n - 1; k >= 0; --k) {
                if (k < nrt & e[k] != 0.0) {
                    for (int j3 = k + 1; j3 < nu; ++j3) {
                        t = 0.0;
                        for (i2 = k + 1; i2 < this.n; ++i2) {
                            t += this.V[i2][k] * this.V[i2][j3];
                        }
                        t = -t / this.V[k + 1][k];
                        for (i2 = k + 1; i2 < this.n; ++i2) {
                            double[] dArray = this.V[i2];
                            int n = j3;
                            dArray[n] = dArray[n] + t * this.V[i2][k];
                        }
                    }
                }
                for (int i8 = 0; i8 < this.n; ++i8) {
                    this.V[i8][k] = 0.0;
                }
                this.V[k][k] = 1.0;
            }
        }
        int pp = p - 1;
        int iter = 0;
        double eps = Math.pow(2.0, -52.0);
        double tiny = Math.pow(2.0, -966.0);
        block35: while (p > 0) {
            int kase;
            int k3;
            for (k3 = p - 2; k3 >= -1 && k3 != -1; --k3) {
                if (!(Math.abs(e[k3]) <= tiny + eps * (Math.abs(this.s[k3]) + Math.abs(this.s[k3 + 1])))) continue;
                e[k3] = 0.0;
                break;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k3 && ks != k3; --ks) {
                    double t4 = (ks != p ? Math.abs(e[ks]) : 0.0) + (ks != k3 + 1 ? Math.abs(e[ks - 1]) : 0.0);
                    if (!(Math.abs(this.s[ks]) <= tiny + eps * t4)) continue;
                    this.s[ks] = 0.0;
                    break;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (kase) {
                case 1: {
                    int i9;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[p - 2];
                    e[p - 2] = 0.0;
                    for (int j4 = p - 2; j4 >= k3; --j4) {
                        t5 = TT_Maths.hypot(this.s[j4], f);
                        cs = this.s[j4] / t5;
                        sn = f / t5;
                        this.s[j4] = t5;
                        if (j4 != k3) {
                            f = -sn * e[j4 - 1];
                            e[j4 - 1] = cs * e[j4 - 1];
                        }
                        if (!wantv) continue;
                        for (i9 = 0; i9 < this.n; ++i9) {
                            t5 = cs * this.V[i9][j4] + sn * this.V[i9][p - 1];
                            this.V[i9][p - 1] = -sn * this.V[i9][j4] + cs * this.V[i9][p - 1];
                            this.V[i9][j4] = t5;
                        }
                    }
                    continue block35;
                }
                case 2: {
                    int i9;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[k3 - 1];
                    e[k3 - 1] = 0.0;
                    for (int j5 = k3; j5 < p; ++j5) {
                        t5 = TT_Maths.hypot(this.s[j5], f);
                        cs = this.s[j5] / t5;
                        sn = f / t5;
                        this.s[j5] = t5;
                        f = -sn * e[j5];
                        e[j5] = cs * e[j5];
                        if (!wantu) continue;
                        for (i9 = 0; i9 < this.m; ++i9) {
                            t5 = cs * this.U[i9][j5] + sn * this.U[i9][k3 - 1];
                            this.U[i9][k3 - 1] = -sn * this.U[i9][j5] + cs * this.U[i9][k3 - 1];
                            this.U[i9][j5] = t5;
                        }
                    }
                    continue block35;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.s[p - 1]), Math.abs(this.s[p - 2])), Math.abs(e[p - 2])), Math.abs(this.s[k3])), Math.abs(e[k3]));
                    double sp = this.s[p - 1] / scale;
                    double spm1 = this.s[p - 2] / scale;
                    double epm1 = e[p - 2] / scale;
                    double sk = this.s[k3] / scale;
                    double ek = e[k3] / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b != 0.0 | c != 0.0) {
                        shift = Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    for (int j6 = k3; j6 < p - 1; ++j6) {
                        int i10;
                        double t6 = TT_Maths.hypot(f, g);
                        double cs = f / t6;
                        double sn = g / t6;
                        if (j6 != k3) {
                            e[j6 - 1] = t6;
                        }
                        f = cs * this.s[j6] + sn * e[j6];
                        e[j6] = cs * e[j6] - sn * this.s[j6];
                        g = sn * this.s[j6 + 1];
                        this.s[j6 + 1] = cs * this.s[j6 + 1];
                        if (wantv) {
                            for (i10 = 0; i10 < this.n; ++i10) {
                                t6 = cs * this.V[i10][j6] + sn * this.V[i10][j6 + 1];
                                this.V[i10][j6 + 1] = -sn * this.V[i10][j6] + cs * this.V[i10][j6 + 1];
                                this.V[i10][j6] = t6;
                            }
                        }
                        t6 = TT_Maths.hypot(f, g);
                        cs = f / t6;
                        sn = g / t6;
                        this.s[j6] = t6;
                        f = cs * e[j6] + sn * this.s[j6 + 1];
                        this.s[j6 + 1] = -sn * e[j6] + cs * this.s[j6 + 1];
                        g = sn * e[j6 + 1];
                        e[j6 + 1] = cs * e[j6 + 1];
                        if (!wantu || j6 >= this.m - 1) continue;
                        for (i10 = 0; i10 < this.m; ++i10) {
                            t6 = cs * this.U[i10][j6] + sn * this.U[i10][j6 + 1];
                            this.U[i10][j6 + 1] = -sn * this.U[i10][j6] + cs * this.U[i10][j6 + 1];
                            this.U[i10][j6] = t6;
                        }
                    }
                    e[p - 2] = f;
                    ++iter;
                    break;
                }
                case 4: {
                    if (this.s[k3] <= 0.0) {
                        double d = this.s[k3] = this.s[k3] < 0.0 ? -this.s[k3] : 0.0;
                        if (wantv) {
                            for (int i11 = 0; i11 <= pp; ++i11) {
                                this.V[i11][k3] = -this.V[i11][k3];
                            }
                        }
                    }
                    while (k3 < pp && !(this.s[k3] >= this.s[k3 + 1])) {
                        int i12;
                        double t7 = this.s[k3];
                        this.s[k3] = this.s[k3 + 1];
                        this.s[k3 + 1] = t7;
                        if (wantv && k3 < this.n - 1) {
                            for (i12 = 0; i12 < this.n; ++i12) {
                                t7 = this.V[i12][k3 + 1];
                                this.V[i12][k3 + 1] = this.V[i12][k3];
                                this.V[i12][k3] = t7;
                            }
                        }
                        if (wantu && k3 < this.m - 1) {
                            for (i12 = 0; i12 < this.m; ++i12) {
                                t7 = this.U[i12][k3 + 1];
                                this.U[i12][k3 + 1] = this.U[i12][k3];
                                this.U[i12][k3] = t7;
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
    }

    public TT_Matrix getU() {
        return new TT_Matrix(this.U, this.m, Math.min(this.m + 1, this.n));
    }

    public TT_Matrix getV() {
        return new TT_Matrix(this.V, this.n, this.n);
    }

    public double[] getSingularValues() {
        return this.s;
    }

    public TT_Matrix getS() {
        TT_Matrix X = new TT_Matrix(this.n, this.n);
        double[][] S = X.getArray();
        for (int i2 = 0; i2 < this.n; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                S[i2][j] = 0.0;
            }
            S[i2][i2] = this.s[i2];
        }
        return X;
    }

    public double norm2() {
        return this.s[0];
    }

    public double cond() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    public int rank() {
        double eps = Math.pow(2.0, -52.0);
        double tol = (double)Math.max(this.m, this.n) * this.s[0] * eps;
        int r = 0;
        for (int i2 = 0; i2 < this.s.length; ++i2) {
            if (!(this.s[i2] > tol)) continue;
            ++r;
        }
        return r;
    }
}

