/*
 * Decompiled with CFR 0.152.
 */
package tracking.texturetracker.tt_matrix;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;
import tracking.texturetracker.tt_matrix.TT_CholeskyDecomposition;
import tracking.texturetracker.tt_matrix.TT_EigenvalueDecomposition;
import tracking.texturetracker.tt_matrix.TT_LUDecomposition;
import tracking.texturetracker.tt_matrix.TT_Maths;
import tracking.texturetracker.tt_matrix.TT_QRDecomposition;
import tracking.texturetracker.tt_matrix.TT_SingularValueDecomposition;

public class TT_Matrix {
    private double[][] A;
    private int m;
    private int n;

    public TT_Matrix(int m, int n) {
        this.m = m;
        this.n = n;
        this.A = new double[m][n];
    }

    public TT_Matrix(int m, int n, double s) {
        this.m = m;
        this.n = n;
        this.A = new double[m][n];
        for (int i2 = 0; i2 < m; ++i2) {
            for (int j = 0; j < n; ++j) {
                this.A[i2][j] = s;
            }
        }
    }

    public TT_Matrix(double[][] A) {
        this.m = A.length;
        this.n = A[0].length;
        for (int i2 = 0; i2 < this.m; ++i2) {
            if (A[i2].length == this.n) continue;
            throw new IllegalArgumentException("All rows must have the same length.");
        }
        this.A = A;
    }

    public TT_Matrix(double[][] A, int m, int n) {
        this.A = A;
        this.m = m;
        this.n = n;
    }

    public TT_Matrix(double[] vals, int m) {
        this.m = m;
        int n = this.n = m != 0 ? vals.length / m : 0;
        if (m * this.n != vals.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        this.A = new double[m][this.n];
        for (int i2 = 0; i2 < m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i2][j] = vals[i2 + j * m];
            }
        }
    }

    public static TT_Matrix constructWithCopy(double[][] A) {
        int m = A.length;
        int n = A[0].length;
        TT_Matrix X = new TT_Matrix(m, n);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < m; ++i2) {
            if (A[i2].length != n) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            System.arraycopy(A[i2], 0, C[i2], 0, n);
        }
        return X;
    }

    public TT_Matrix copy() {
        TT_Matrix X = new TT_Matrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            System.arraycopy(this.A[i2], 0, C[i2], 0, this.n);
        }
        return X;
    }

    public Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    public double[][] getArray() {
        return this.A;
    }

    public double[][] getArrayCopy() {
        double[][] C = new double[this.m][this.n];
        for (int i2 = 0; i2 < this.m; ++i2) {
            System.arraycopy(this.A[i2], 0, C[i2], 0, this.n);
        }
        return C;
    }

    public double[] getColumnPackedCopy() {
        double[] vals = new double[this.m * this.n];
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                vals[i2 + j * this.m] = this.A[i2][j];
            }
        }
        return vals;
    }

    public double[] getRowPackedCopy() {
        double[] vals = new double[this.m * this.n];
        for (int i2 = 0; i2 < this.m; ++i2) {
            System.arraycopy(this.A[i2], 0, vals, i2 * this.n, this.n);
        }
        return vals;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public double get(int i2, int j) {
        return this.A[i2][j];
    }

    public TT_Matrix getMatrix(int i0, int i1, int j0, int j1) {
        TT_Matrix X = new TT_Matrix(i1 - i0 + 1, j1 - j0 + 1);
        double[][] B = X.getArray();
        try {
            for (int i2 = i0; i2 <= i1; ++i2) {
                for (int j = j0; j <= j1; ++j) {
                    B[i2 - i0][j - j0] = this.A[i2][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public TT_Matrix getMatrix(int[] r, int[] c) {
        TT_Matrix X = new TT_Matrix(r.length, c.length);
        double[][] B = X.getArray();
        try {
            for (int i2 = 0; i2 < r.length; ++i2) {
                for (int j = 0; j < c.length; ++j) {
                    B[i2][j] = this.A[r[i2]][c[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public TT_Matrix getMatrix(int i0, int i1, int[] c) {
        TT_Matrix X = new TT_Matrix(i1 - i0 + 1, c.length);
        double[][] B = X.getArray();
        try {
            for (int i2 = i0; i2 <= i1; ++i2) {
                for (int j = 0; j < c.length; ++j) {
                    B[i2 - i0][j] = this.A[i2][c[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public TT_Matrix getMatrix(int[] r, int j0, int j1) {
        TT_Matrix X = new TT_Matrix(r.length, j1 - j0 + 1);
        double[][] B = X.getArray();
        try {
            for (int i2 = 0; i2 < r.length; ++i2) {
                for (int j = j0; j <= j1; ++j) {
                    B[i2][j - j0] = this.A[r[i2]][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public void set(int i2, int j, double s) {
        this.A[i2][j] = s;
    }

    public void setTT_Matrix(int i0, int i1, int j0, int j1, TT_Matrix X) {
        try {
            for (int i2 = i0; i2 <= i1; ++i2) {
                for (int j = j0; j <= j1; ++j) {
                    this.A[i2][j] = X.get(i2 - i0, j - j0);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setTT_Matrix(int[] r, int[] c, TT_Matrix X) {
        try {
            for (int i2 = 0; i2 < r.length; ++i2) {
                for (int j = 0; j < c.length; ++j) {
                    this.A[r[i2]][c[j]] = X.get(i2, j);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setTT_Matrix(int[] r, int j0, int j1, TT_Matrix X) {
        try {
            for (int i2 = 0; i2 < r.length; ++i2) {
                for (int j = j0; j <= j1; ++j) {
                    this.A[r[i2]][j] = X.get(i2, j - j0);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setTT_Matrix(int i0, int i1, int[] c, TT_Matrix X) {
        try {
            for (int i2 = i0; i2 <= i1; ++i2) {
                for (int j = 0; j < c.length; ++j) {
                    this.A[i2][c[j]] = X.get(i2 - i0, j);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public TT_Matrix transpose() {
        TT_Matrix X = new TT_Matrix(this.n, this.m);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                C[j][i2] = this.A[i2][j];
            }
        }
        return X;
    }

    public double norm1() {
        double f = 0.0;
        for (int j = 0; j < this.n; ++j) {
            double s = 0.0;
            for (int i2 = 0; i2 < this.m; ++i2) {
                s += Math.abs(this.A[i2][j]);
            }
            f = Math.max(f, s);
        }
        return f;
    }

    public double norm2() {
        return new TT_SingularValueDecomposition(this).norm2();
    }

    public double normInf() {
        double f = 0.0;
        for (int i2 = 0; i2 < this.m; ++i2) {
            double s = 0.0;
            for (int j = 0; j < this.n; ++j) {
                s += Math.abs(this.A[i2][j]);
            }
            f = Math.max(f, s);
        }
        return f;
    }

    public double normF() {
        double f = 0.0;
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                f = TT_Maths.hypot(f, this.A[i2][j]);
            }
        }
        return f;
    }

    public TT_Matrix uminus() {
        TT_Matrix X = new TT_Matrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                C[i2][j] = -this.A[i2][j];
            }
        }
        return X;
    }

    public TT_Matrix plus(TT_Matrix B) {
        this.checkTT_MatrixDimensions(B);
        TT_Matrix X = new TT_Matrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                C[i2][j] = this.A[i2][j] + B.A[i2][j];
            }
        }
        return X;
    }

    public TT_Matrix plusEquals(TT_Matrix B) {
        this.checkTT_MatrixDimensions(B);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                double[] dArray = this.A[i2];
                int n = j;
                dArray[n] = dArray[n] + B.A[i2][j];
            }
        }
        return this;
    }

    public TT_Matrix minus(TT_Matrix B) {
        this.checkTT_MatrixDimensions(B);
        TT_Matrix X = new TT_Matrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                C[i2][j] = this.A[i2][j] - B.A[i2][j];
            }
        }
        return X;
    }

    public TT_Matrix minusEquals(TT_Matrix B) {
        this.checkTT_MatrixDimensions(B);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                double[] dArray = this.A[i2];
                int n = j;
                dArray[n] = dArray[n] - B.A[i2][j];
            }
        }
        return this;
    }

    public TT_Matrix arrayTimes(TT_Matrix B) {
        this.checkTT_MatrixDimensions(B);
        TT_Matrix X = new TT_Matrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                C[i2][j] = this.A[i2][j] * B.A[i2][j];
            }
        }
        return X;
    }

    public TT_Matrix arrayTimesEquals(TT_Matrix B) {
        this.checkTT_MatrixDimensions(B);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                double[] dArray = this.A[i2];
                int n = j;
                dArray[n] = dArray[n] * B.A[i2][j];
            }
        }
        return this;
    }

    public TT_Matrix arrayRightDivide(TT_Matrix B) {
        this.checkTT_MatrixDimensions(B);
        TT_Matrix X = new TT_Matrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                C[i2][j] = this.A[i2][j] / B.A[i2][j];
            }
        }
        return X;
    }

    public TT_Matrix arrayRightDivideEquals(TT_Matrix B) {
        this.checkTT_MatrixDimensions(B);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                double[] dArray = this.A[i2];
                int n = j;
                dArray[n] = dArray[n] / B.A[i2][j];
            }
        }
        return this;
    }

    public TT_Matrix arrayLeftDivide(TT_Matrix B) {
        this.checkTT_MatrixDimensions(B);
        TT_Matrix X = new TT_Matrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                C[i2][j] = B.A[i2][j] / this.A[i2][j];
            }
        }
        return X;
    }

    public TT_Matrix arrayLeftDivideEquals(TT_Matrix B) {
        this.checkTT_MatrixDimensions(B);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i2][j] = B.A[i2][j] / this.A[i2][j];
            }
        }
        return this;
    }

    public TT_Matrix times(double s) {
        TT_Matrix X = new TT_Matrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                C[i2][j] = s * this.A[i2][j];
            }
        }
        return X;
    }

    public TT_Matrix timesEquals(double s) {
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i2][j] = s * this.A[i2][j];
            }
        }
        return this;
    }

    public TT_Matrix times(TT_Matrix B) {
        if (B.m != this.n) {
            throw new IllegalArgumentException("TT_Matrix inner dimensions must agree.");
        }
        TT_Matrix X = new TT_Matrix(this.m, B.n);
        double[][] C = X.getArray();
        double[] Bcolj = new double[this.n];
        for (int j = 0; j < B.n; ++j) {
            for (int k = 0; k < this.n; ++k) {
                Bcolj[k] = B.A[k][j];
            }
            for (int i2 = 0; i2 < this.m; ++i2) {
                double[] Arowi = this.A[i2];
                double s = 0.0;
                for (int k = 0; k < this.n; ++k) {
                    s += Arowi[k] * Bcolj[k];
                }
                C[i2][j] = s;
            }
        }
        return X;
    }

    public TT_LUDecomposition lu() {
        return new TT_LUDecomposition(this);
    }

    public TT_QRDecomposition qr() {
        return new TT_QRDecomposition(this);
    }

    public TT_CholeskyDecomposition chol() {
        return new TT_CholeskyDecomposition(this);
    }

    public TT_SingularValueDecomposition svd() {
        return new TT_SingularValueDecomposition(this);
    }

    public TT_EigenvalueDecomposition eig() {
        return new TT_EigenvalueDecomposition(this);
    }

    public TT_Matrix solve(TT_Matrix B) {
        return this.m == this.n ? new TT_LUDecomposition(this).solve(B) : new TT_QRDecomposition(this).solve(B);
    }

    public TT_Matrix solveTranspose(TT_Matrix B) {
        return this.transpose().solve(B.transpose());
    }

    public TT_Matrix inverse() {
        return this.solve(TT_Matrix.identity(this.m, this.m));
    }

    public double det() {
        return new TT_LUDecomposition(this).det();
    }

    public int rank() {
        return new TT_SingularValueDecomposition(this).rank();
    }

    public double cond() {
        return new TT_SingularValueDecomposition(this).cond();
    }

    public double trace() {
        double t = 0.0;
        for (int i2 = 0; i2 < Math.min(this.m, this.n); ++i2) {
            t += this.A[i2][i2];
        }
        return t;
    }

    public static TT_Matrix random(int m, int n) {
        TT_Matrix A = new TT_Matrix(m, n);
        double[][] X = A.getArray();
        for (int i2 = 0; i2 < m; ++i2) {
            for (int j = 0; j < n; ++j) {
                X[i2][j] = Math.random();
            }
        }
        return A;
    }

    public static TT_Matrix identity(int m, int n) {
        TT_Matrix A = new TT_Matrix(m, n);
        double[][] X = A.getArray();
        for (int i2 = 0; i2 < m; ++i2) {
            for (int j = 0; j < n; ++j) {
                X[i2][j] = i2 == j ? 1.0 : 0.0;
            }
        }
        return A;
    }

    public void print(int w, int d) {
        this.print(new PrintWriter(System.out, true), w, d);
    }

    public void print(PrintWriter output, int w, int d) {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(d);
        format.setMinimumFractionDigits(d);
        format.setGroupingUsed(false);
        this.print(output, format, w + 2);
    }

    public void print(NumberFormat format, int width) {
        this.print(new PrintWriter(System.out, true), format, width);
    }

    public void print(PrintWriter output, NumberFormat format, int width) {
        output.println();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                String s = format.format(this.A[i2][j]);
                int padding = Math.max(1, width - s.length());
                for (int k = 0; k < padding; ++k) {
                    output.print(' ');
                }
                output.print(s);
            }
            output.println();
        }
        output.println();
    }

    public static TT_Matrix read(BufferedReader input) throws IOException {
        int j;
        StreamTokenizer tokenizer = new StreamTokenizer(input);
        tokenizer.resetSyntax();
        tokenizer.wordChars(0, 255);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.eolIsSignificant(true);
        Vector<Object> v = new Vector<Object>();
        while (tokenizer.nextToken() == 10) {
        }
        if (tokenizer.ttype == -1) {
            throw new IOException("Unexpected EOF on matrix read.");
        }
        do {
            v.addElement(Double.valueOf(tokenizer.sval));
        } while (tokenizer.nextToken() == -3);
        int n = v.size();
        double[] row = new double[n];
        for (j = 0; j < n; ++j) {
            row[j] = (Double)v.elementAt(j);
        }
        v.removeAllElements();
        v.addElement(row);
        while (tokenizer.nextToken() == -3) {
            row = new double[n];
            v.addElement(row);
            j = 0;
            do {
                if (j >= n) {
                    throw new IOException("Row " + v.size() + " is too long.");
                }
                row[j++] = Double.valueOf(tokenizer.sval);
            } while (tokenizer.nextToken() == -3);
            if (j >= n) continue;
            throw new IOException("Row " + v.size() + " is too short.");
        }
        int m = v.size();
        double[][] A = new double[m][];
        v.copyInto((Object[])A);
        return new TT_Matrix(A);
    }

    private void checkTT_MatrixDimensions(TT_Matrix B) {
        if (B.m != this.m || B.n != this.n) {
            throw new IllegalArgumentException("TT_Matrix dimensions must agree.");
        }
    }
}

