/*
 * Decompiled with CFR 0.152.
 */
package tracking.texturetracker;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import mathematics.metrics.Euclidian;
import mathematics.metrics.Metric;
import tracking.texturetracker.TT_DetectDescribe;
import tracking.texturetracker.TT_Homography;
import tracking.texturetracker.TT_IntegralImage;
import tracking.texturetracker.TT_InterestPoint;
import tracking.texturetracker.TT_Matcher;
import tracking.texturetracker.TT_Parameters;
import utils.times.Chronometer;

public class TT_SearchInMovie {
    private List<TT_InterestPoint> list = null;
    private List<TT_InterestPoint> movielist = null;
    public Map<TT_InterestPoint, TT_InterestPoint> matchedPoints = null;
    public TT_DetectDescribe detdes = null;
    public TT_Homography homography = new TT_Homography();
    public TT_IntegralImage intimg = null;
    private TT_Matcher matcher = new TT_Matcher();
    public TT_Parameters params = null;
    private int nbGlobalPoints = -1;
    public int found = 0;
    public int notfound = 0;
    public int nbmatched = 0;
    public int sumsize = 0;
    public double timeIntIm;
    public double timeDetection;
    public double timeDescription;
    public double timeReduction;
    public double timeMatching;
    public double timeWindow;
    public double timeHomography;
    public double timeIntImNF;
    public double timeDetectionNF;
    public double timeDescriptionNF;
    public double timeReductionNF;
    public double timeMatchingNF;
    public Chronometer chrono = new Chronometer();
    private List<Float> tmp = new ArrayList<Float>(113);
    private int order = 0;
    private double sigma = 0.0;
    private double[][] distancespoints = null;
    private int width = 0;
    private int height = 0;
    private float ipminx;
    private float ipminy;
    private float ipmaxx;
    private float ipmaxy;
    private int marginsecurity = 0;
    private int border = 0;
    private TT_InterestPoint[] ip = null;
    private TT_InterestPoint[] ipnew = null;
    private Metric metric = new Euclidian();
    public boolean bordel = true;

    public TT_SearchInMovie(int order, double sigma) {
        this.order = order;
        this.sigma = sigma;
        this.ClearTimes();
    }

    public void run(byte[] data, int width, int height, int distancesecurity, double descriptorsecurity, boolean reducedlist, boolean doReverseComparisonToo, boolean reducedwindow, boolean computehomography) {
        if (this.list == null) {
            throw new Error("Initialisation or Read method required before use run method.");
        }
        int marker = this.chrono.NewMarker();
        if (this.intimg == null) {
            this.intimg = new TT_IntegralImage(data, width, height, 0, 0, width, height);
        } else {
            this.intimg.setFromYUV420(data, width, height, this.detdes.detector.startx, this.detdes.detector.starty, this.detdes.detector.endx, this.detdes.detector.endy);
        }
        if (this.bordel) {
            this.timeIntImNF += this.chrono.getTimeSinceMarker(marker);
        } else {
            this.timeIntIm += this.chrono.getTimeSinceMarker(marker);
        }
        this.chrono.FreeMarker(marker);
        this.movielist = this.detdes.detectAndDescribeInterestPoints(this.intimg, this.params, distancesecurity);
        this.sumsize += this.movielist.size();
        marker = this.chrono.NewMarker();
        if (descriptorsecurity > 0.0) {
            this.CleanListDescriptor(this.movielist, descriptorsecurity);
        }
        if (reducedlist) {
            this.ReducedList();
        }
        if (this.bordel) {
            this.timeReductionNF += this.chrono.getTimeSinceMarker(marker);
        } else {
            this.timeReduction += this.chrono.getTimeSinceMarker(marker);
        }
        this.chrono.FreeMarker(marker);
        marker = this.chrono.NewMarker();
        this.matchedPoints = this.matcher.findMathes(this.list, this.movielist, this.params, doReverseComparisonToo);
        if (this.bordel) {
            this.timeMatchingNF += this.chrono.getTimeSinceMarker(marker);
        } else {
            this.timeMatching += this.chrono.getTimeSinceMarker(marker);
        }
        this.chrono.FreeMarker(marker);
        this.nbmatched += this.matchedPoints.size();
        if (reducedwindow) {
            this.ReducedWindow();
        }
        if (computehomography) {
            marker = this.chrono.NewMarker();
            this.homography.Compute(this.matchedPoints);
            this.timeHomography += this.chrono.getTimeSinceMarker(marker);
            this.chrono.FreeMarker(marker);
        }
        if (this.matchedPoints.isEmpty()) {
            ++this.notfound;
            this.bordel = true;
        } else {
            ++this.found;
            this.bordel = false;
        }
    }

    private void ReducedList() {
        int marker = this.chrono.NewMarker();
        if (this.movielist.size() > this.nbGlobalPoints) {
            float d;
            int i2;
            float min = 0.0f;
            for (i2 = 0; i2 < this.nbGlobalPoints; ++i2) {
                d = this.movielist.get((int)i2).strength;
                for (int j = 0; j < this.tmp.size() && d < this.tmp.get(j).floatValue(); ++j) {
                }
                min = this.Insert(d, this.nbGlobalPoints);
            }
            for (i2 = this.nbGlobalPoints; i2 < this.movielist.size(); ++i2) {
                if (!(this.movielist.get((int)i2).strength > min)) continue;
                min = this.Insert(this.movielist.get((int)i2).strength, this.nbGlobalPoints);
            }
            d = this.tmp.get(this.nbGlobalPoints - 1).floatValue();
            this.tmp.clear();
            i2 = 0;
            while (i2 < this.movielist.size()) {
                if (this.movielist.get((int)i2).strength < d) {
                    this.movielist.remove(i2);
                    continue;
                }
                ++i2;
            }
        }
        this.timeReduction += this.chrono.getTimeSinceMarker(marker);
        this.chrono.FreeMarker(marker);
    }

    private void ReducedWindow() {
        int marker = this.chrono.NewMarker();
        if (this.matchedPoints.size() > 1) {
            int x;
            int minx = this.width;
            int miny = this.height;
            int maxx = 0;
            int maxy = 0;
            int size = this.matchedPoints.size();
            double average = 0.0;
            if (this.matchedPoints.size() >= 3) {
                this.detdes.detector.ResetSecurity();
            }
            int nb = 0;
            for (Map.Entry<TT_InterestPoint, TT_InterestPoint> pair : this.matchedPoints.entrySet()) {
                this.ip[nb] = pair.getKey();
                this.ipnew[nb++] = pair.getValue();
            }
            average = 0.0;
            nb = 0;
            for (x = 0; x < size - 1; ++x) {
                if ((float)minx > this.ipnew[x].x) {
                    minx = (int)this.ipnew[x].x;
                }
                if ((float)miny > this.ipnew[x].y) {
                    miny = (int)this.ipnew[x].y;
                }
                if ((float)maxx < this.ipnew[x].x) {
                    maxx = (int)(this.ipnew[x].x + 0.5f);
                }
                if ((float)maxy < this.ipnew[x].y) {
                    maxy = (int)(this.ipnew[x].y + 0.5f);
                }
                for (int y = x + 1; y < size; ++y) {
                    double d = this.metric.Distance((double)this.ipnew[x].x, (double)this.ipnew[x].y, 0.0, (double)this.ipnew[y].x, (double)this.ipnew[y].y, 0.0);
                    if (!(d > 0.0)) continue;
                    average += this.distancespoints[this.ip[x].number][this.ip[y].number] / d;
                    ++nb;
                }
            }
            if (nb > 0) {
                average /= (double)nb;
                double strength = this.ipnew[0].strength;
                int num = 0;
                for (x = 1; x < size; ++x) {
                    if (!((double)this.ipnew[x].strength > strength)) continue;
                    strength = this.ipnew[x].strength;
                    num = x;
                }
                this.detdes.detector.FindWindowSize(this.ip[num].x - this.ipminx, this.ip[num].y - this.ipminy, this.ipmaxx - this.ip[num].x, this.ipmaxy - this.ip[num].y, (int)this.ipnew[num].x, (int)this.ipnew[num].y, average, minx, miny, maxx, maxy);
            }
            if (this.matchedPoints.size() < 3) {
                this.detdes.detector.ActivateSecurity();
            }
        } else {
            this.detdes.detector.ActivateSecurity();
        }
        this.timeWindow += this.chrono.getTimeSinceMarker(marker);
        this.chrono.FreeMarker(marker);
    }

    protected float Insert(float strength, int nbPoints) {
        int i2;
        if (this.tmp.size() == nbPoints) {
            this.tmp.remove(nbPoints - 1);
        }
        int size = this.tmp.size();
        for (i2 = 0; i2 < size && this.tmp.get(i2).floatValue() > strength; ++i2) {
        }
        this.tmp.add(i2, Float.valueOf(strength));
        return this.tmp.get(this.tmp.size() - 1).floatValue();
    }

    private void CleanListDescriptor(List<TT_InterestPoint> list, double security) {
        for (int x = 0; x < list.size() - 1; ++x) {
            int y = x + 1;
            while (y < list.size()) {
                if (this.metric.Distance(list.get((int)x).descriptor, list.get((int)y).descriptor) < security) {
                    if (list.get((int)x).strength < list.get((int)y).strength) {
                        list.remove(x);
                        y = x + 1;
                        continue;
                    }
                    list.remove(y);
                    continue;
                }
                ++y;
            }
        }
    }

    public void Write(String name) throws UnsupportedEncodingException, IOException {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(name));
        out.write((this.width + "\t" + this.height + "\n").getBytes("ASCII"));
        out.write((this.order + "\t" + this.sigma + "\n").getBytes("ASCII"));
        out.write((this.list.size() + "\t" + this.nbGlobalPoints + "\t" + this.marginsecurity + "\t" + this.border + "\n").getBytes("ASCII"));
        out.write("\n".getBytes("ASCII"));
        for (int i2 = 0; i2 < this.list.size(); ++i2) {
            this.list.get(i2).Write(out);
        }
        out.write("\n".getBytes("ASCII"));
        this.params.Write(out);
        out.write("\n".getBytes("ASCII"));
    }

    public void Read(InputStream fis) throws Exception {
        int i2;
        Scanner in = new Scanner(fis);
        this.width = in.nextInt();
        this.height = in.nextInt();
        this.order = in.nextInt();
        this.sigma = Double.valueOf(in.next());
        int size = in.nextInt();
        this.nbGlobalPoints = in.nextInt();
        this.marginsecurity = in.nextInt();
        this.border = in.nextInt();
        this.list = new ArrayList<TT_InterestPoint>(113);
        for (i2 = 0; i2 < size; ++i2) {
            this.list.add(new TT_InterestPoint(in));
            this.list.get((int)i2).number = i2;
        }
        this.params = new TT_Parameters(in);
        this.distancespoints = new double[size][size];
        i2 = 0;
        while (i2 < this.list.size()) {
            TT_InterestPoint p1 = this.list.get(i2);
            for (int j = i2 + 1; j < this.list.size(); ++j) {
                TT_InterestPoint p2 = this.list.get(j);
                double d = this.metric.Distance((double)p1.x, (double)p1.y, 0.0, (double)p2.x, (double)p2.y, 0.0);
                this.distancespoints[j][i2] = d;
                this.distancespoints[i2][j] = d;
            }
            p1.number = i2++;
        }
        this.detdes = new TT_DetectDescribe(this, this.order, this.sigma, this.marginsecurity, this.border);
        this.ip = new TT_InterestPoint[this.list.size()];
        this.ipnew = new TT_InterestPoint[this.list.size()];
        this.ipminx = this.width;
        this.ipminy = this.height;
        this.ipmaxy = 0.0f;
        this.ipmaxx = 0.0f;
        for (i2 = 0; i2 < this.list.size(); ++i2) {
            if (this.ipminx > this.list.get((int)i2).x) {
                this.ipminx = this.list.get((int)i2).x;
            }
            if (this.ipminy > this.list.get((int)i2).y) {
                this.ipminy = this.list.get((int)i2).y;
            }
            if (this.ipmaxx < this.list.get((int)i2).x) {
                this.ipmaxx = this.list.get((int)i2).x;
            }
            if (!(this.ipmaxy < this.list.get((int)i2).y)) continue;
            this.ipmaxy = this.list.get((int)i2).y;
        }
        for (i2 = 0; i2 < this.list.size(); ++i2) {
            this.homography.computeNormalisedCoordinates(this.list.get(i2), this.width, this.height);
        }
        this.ClearTimes();
    }

    private void ClearTimes() {
        this.timeHomography = 0.0;
        this.timeWindow = 0.0;
        this.timeMatching = 0.0;
        this.timeReduction = 0.0;
        this.timeDescription = 0.0;
        this.timeDetection = 0.0;
        this.timeIntIm = 0.0;
        this.timeMatchingNF = 0.0;
        this.timeReductionNF = 0.0;
        this.timeDescriptionNF = 0.0;
        this.timeDetectionNF = 0.0;
        this.timeIntImNF = 0.0;
    }
}

