/*
 * Decompiled with CFR 0.152.
 */
package tracking.texturetracker;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Scanner;

public class TT_Parameters {
    public static final String programVersion = "ImageJ SURF v2009-12-01";
    private int[][] filterSizes = new int[][]{{9, 15, 21, 27}, {15, 27, 39, 51}, {27, 51, 75, 99}, {51, 99, 147, 195}};
    private int[] maxFilterSizes = new int[]{27, 51, 99, 195};
    private int octaves = 4;
    private int layers = 4;
    private float threshold = 0.005f;
    private int initStep = 2;
    private int stepIncFactor = 2;
    private boolean upright = false;
    private int descSize = -1;
    private int lineWidth = 1;

    public TT_Parameters() {
    }

    public TT_Parameters(int size, int octaves, int layers, float threshold, int initStep, int stepIncFactor, boolean upright, int lineWidth, boolean displayStatistics) {
        this.descSize = size;
        this.octaves = this.validate(octaves, 3, 4);
        this.layers = this.validate(layers, 3, 4);
        this.threshold = this.validate(threshold, 0.0f, 1.0f);
        this.initStep = this.validate(initStep, 1, 6);
        this.stepIncFactor = this.validate(stepIncFactor, 1, 6);
        this.upright = upright;
        this.lineWidth = this.validate(lineWidth, 0, 5);
    }

    public TT_Parameters(TT_Parameters p) {
        this.descSize = p.descSize;
        this.octaves = p.octaves;
        this.layers = p.layers;
        this.threshold = p.threshold;
        this.initStep = p.initStep;
        this.stepIncFactor = p.stepIncFactor;
        this.upright = p.upright;
        this.lineWidth = p.lineWidth;
    }

    public TT_Parameters(Scanner in) {
        this.descSize = in.nextInt();
        this.octaves = in.nextInt();
        this.layers = in.nextInt();
        this.threshold = Float.valueOf(in.next()).floatValue();
        this.initStep = in.nextInt();
        this.stepIncFactor = in.nextInt();
        this.upright = in.nextBoolean();
        this.lineWidth = in.nextInt();
    }

    public void Write(DataOutputStream out) throws UnsupportedEncodingException, IOException {
        out.write((this.descSize + "\t" + this.octaves + "\t" + this.layers + "\t" + this.threshold + "\t" + this.initStep + "\t" + this.stepIncFactor + "\t" + this.upright + "\t" + this.lineWidth + "\n").getBytes("ASCII"));
    }

    private float validate(float val, float lowerBound, float upperBound) {
        if (val < lowerBound) {
            return lowerBound;
        }
        if (val > upperBound) {
            return upperBound;
        }
        return val;
    }

    private int validate(int val, int lowerBound, int upperBound) {
        if (val < lowerBound) {
            return lowerBound;
        }
        if (val > upperBound) {
            return upperBound;
        }
        return val;
    }

    public int getOctaves() {
        return this.octaves;
    }

    public int getLayers() {
        return this.layers;
    }

    public int getFilterSize(int octave, int layer) {
        return this.filterSizes[octave][layer];
    }

    public int getMaxFilterSize(int octave) {
        return this.maxFilterSizes[octave];
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public int getInitStep() {
        return this.initStep;
    }

    public int getStepIncFactor() {
        return this.stepIncFactor;
    }

    public boolean isUpright() {
        return this.upright;
    }

    public int getDescSize() {
        return this.descSize;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }
}

