/*
 * Decompiled with CFR 0.152.
 */
package tracking.texturetracker;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import tracking.texturetracker.TT_InterestPoint;
import tracking.texturetracker.TT_Parameters;

public class TT_Matcher {
    public Map<TT_InterestPoint, TT_InterestPoint> findMathes(List<TT_InterestPoint> ipts1, List<TT_InterestPoint> ipts2, TT_Parameters params, boolean doReverseComparisonToo) {
        Map<TT_InterestPoint, TT_InterestPoint> matchedPoints = this.findMathes(ipts1, ipts2, params);
        if (doReverseComparisonToo) {
            Map<TT_InterestPoint, TT_InterestPoint> matchedPointsReverse = this.findMathes(ipts2, ipts1, params);
            HashMap<TT_InterestPoint, TT_InterestPoint> matchedPointsBoth = new HashMap<TT_InterestPoint, TT_InterestPoint>();
            Iterator<Map.Entry<TT_InterestPoint, TT_InterestPoint>> iter = matchedPoints.entrySet().iterator();
            Iterator<Map.Entry<TT_InterestPoint, TT_InterestPoint>> iterReverse = null;
            while (iter.hasNext()) {
                Map.Entry<TT_InterestPoint, TT_InterestPoint> entry = iter.next();
                TT_InterestPoint p1 = entry.getKey();
                TT_InterestPoint p2 = entry.getValue();
                boolean found = false;
                iterReverse = matchedPointsReverse.entrySet().iterator();
                while (!found && iterReverse.hasNext()) {
                    Map.Entry<TT_InterestPoint, TT_InterestPoint> entryReverse = iterReverse.next();
                    TT_InterestPoint p3 = entryReverse.getKey();
                    TT_InterestPoint p4 = entryReverse.getValue();
                    if (p1.number != p4.number || p2.number != p3.number) continue;
                    matchedPointsBoth.put(p1, p2);
                    found = true;
                }
            }
            matchedPoints = matchedPointsBoth;
        }
        return matchedPoints;
    }

    private Map<TT_InterestPoint, TT_InterestPoint> findMathes(List<TT_InterestPoint> ipts1, List<TT_InterestPoint> ipts2, TT_Parameters params) {
        TT_InterestPoint p1 = null;
        TT_InterestPoint p2 = null;
        TT_InterestPoint bestMatch = null;
        int descSize = params.getDescSize();
        HashMap<TT_InterestPoint, TT_InterestPoint> res = new HashMap<TT_InterestPoint, TT_InterestPoint>(113);
        for (int x = 0; x < ipts1.size(); ++x) {
            float secondBest = Float.MAX_VALUE;
            float bestDistance = Float.MAX_VALUE;
            bestMatch = null;
            p1 = ipts1.get(x);
            for (int y = 0; y < ipts2.size(); ++y) {
                p2 = ipts2.get(y);
                if (p1.sign != p2.sign) continue;
                float distance = 0.0f;
                float[] v1 = p1.descriptor;
                float[] v2 = p2.descriptor;
                for (int i2 = 0; i2 < descSize; ++i2) {
                    float delta = v1[i2] - v2[i2];
                    if (!((distance += delta * delta) >= secondBest)) continue;
                    i2 = descSize;
                }
                if (distance < bestDistance) {
                    secondBest = bestDistance;
                    bestDistance = distance;
                    bestMatch = p2;
                    continue;
                }
                if (!(distance < secondBest)) continue;
                secondBest = distance;
            }
            if (!(bestDistance < 0.5f * secondBest)) continue;
            res.put(p1, bestMatch);
        }
        return res;
    }
}

