/*
 * Decompiled with CFR 0.152.
 */
package tracking.texturetracker;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Formatter;
import java.util.Locale;
import java.util.Scanner;

public class TT_InterestPoint {
    public float x;
    public float y;
    public float xnorm;
    public float ynorm;
    public float strength;
    public float trace;
    public boolean sign;
    public float scale;
    public float orientation;
    public float[] descriptor = null;
    public int number;

    public TT_InterestPoint(Scanner in) {
        this.Read(in);
    }

    public TT_InterestPoint(int size, float x, float y, float strength, float trace, float scale, int number) {
        this.descriptor = new float[size];
        this.x = x;
        this.y = y;
        this.strength = strength;
        this.trace = trace;
        this.scale = scale;
        this.sign = trace >= 0.0f;
        this.number = number;
    }

    public TT_InterestPoint(int size, float x, float y, float strength, float trace, float scale) {
        this.descriptor = new float[size];
        this.x = x;
        this.y = y;
        this.strength = strength;
        this.trace = trace;
        this.scale = scale;
        this.sign = trace >= 0.0f;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb, Locale.US);
        f.format("%12f %12f %12f %12f %12f %12f ", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.strength), Float.valueOf(this.trace), Float.valueOf(this.scale), Float.valueOf(this.orientation));
        int descSize = this.descriptor == null ? 0 : this.descriptor.length;
        f.format("%12d ", descSize);
        if (descSize > 0) {
            for (int i2 = 0; i2 < descSize; ++i2) {
                if (i2 % 8 == 0) {
                    f.format("\n", new Object[0]);
                }
                f.format("%12f ", Float.valueOf(this.descriptor[i2]));
            }
            f.format("\n", new Object[0]);
        }
        return f.toString();
    }

    public void Write(DataOutputStream out) throws UnsupportedEncodingException, IOException {
        out.write((this.x + "\t" + this.y + "\t").getBytes("ASCII"));
        out.write((this.orientation + "\t" + this.scale + "\t" + this.sign + "\t" + this.strength + "\t" + this.trace + "\n").getBytes("ASCII"));
        out.write((this.descriptor.length + "\t").getBytes("ASCII"));
        for (int i2 = 0; i2 < this.descriptor.length; ++i2) {
            out.write((this.descriptor[i2] + "\t").getBytes("ASCII"));
        }
        out.write("\n".getBytes("ASCII"));
    }

    public void Read(Scanner in) {
        this.x = Float.valueOf(in.next()).floatValue();
        this.y = Float.valueOf(in.next()).floatValue();
        this.orientation = Float.valueOf(in.next()).floatValue();
        this.scale = Float.valueOf(in.next()).floatValue();
        this.sign = in.nextBoolean();
        this.strength = Float.valueOf(in.next()).floatValue();
        this.trace = Float.valueOf(in.next()).floatValue();
        int size = in.nextInt();
        this.descriptor = new float[size];
        for (int i2 = 0; i2 < size; ++i2) {
            this.descriptor[i2] = Float.valueOf(in.next()).floatValue();
        }
    }
}

