/*
 * Decompiled with CFR 0.152.
 */
package tracking.texturetracker;

public class TT_IntegralImage {
    public float[][] data = null;
    private int width;
    private int height;
    private int maxX;
    private int maxY;

    public TT_IntegralImage(byte[] src, int width, int height, int startx, int starty, int endx, int endy) {
        this.setFromYUV420(src, width, height, startx, starty, endx, endy);
    }

    private void convertInternalBufferToIntegralImage(int startx, int starty, int endx, int endy) {
        float rowSum = 0.0f;
        for (int x = startx; x < endx; ++x) {
            this.data[x][starty] = rowSum += this.data[x][starty];
        }
        for (int y = starty + 1; y < endy; ++y) {
            rowSum = 0.0f;
            for (int x = startx; x < endx; ++x) {
                this.data[x][y] = (rowSum += this.data[x][y]) + this.data[x][y - 1];
            }
        }
    }

    public void setFromYUV420(byte[] src, int width, int height, int startx, int starty, int endx, int endy) {
        float val;
        int x;
        int y;
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        if (this.data == null || this.data.length != width || this.data[0].length != height) {
            this.data = null;
            this.data = new float[width][height];
            this.setData();
        }
        for (y = starty; y < endy; ++y) {
            for (x = startx; x < endx; ++x) {
                float v = src[y * width + x];
                this.data[x][y] = val = 0.0f <= v ? v : 256.0f + v;
                if (val < min) {
                    min = val;
                    continue;
                }
                if (!(val > max)) continue;
                max = val;
            }
        }
        float scale = 1.0f / (max - min);
        for (x = startx; x < endx; ++x) {
            float[] col = this.data[x];
            for (y = starty; y < endy; ++y) {
                val = col[y] - min;
                if (val < 0.0f) {
                    val = 0.0f;
                }
                if ((val *= scale) > 1.0f) {
                    val = 1.0f;
                }
                col[y] = val;
            }
        }
        this.setData();
        this.convertInternalBufferToIntegralImage(startx, starty, endx, endy);
    }

    protected void setData() {
        this.width = this.data.length;
        this.height = this.data[0].length;
        this.maxX = this.width - 1;
        this.maxY = this.height - 1;
    }

    public float area(int x, int y, int width, int height) {
        int x2 = --x + width;
        int y2 = --y + height;
        if (x > this.maxX) {
            x = this.maxX;
        }
        if (y > this.maxY) {
            y = this.maxY;
        }
        if (x2 > this.maxX) {
            x2 = this.maxX;
        }
        if (y2 > this.maxY) {
            y2 = this.maxY;
        }
        float A = x < 0 || y < 0 ? 0.0f : this.data[x][y];
        float B = x2 < 0 || y < 0 ? 0.0f : this.data[x2][y];
        float C = x < 0 || y2 < 0 ? 0.0f : this.data[x][y2];
        float D = x2 < 0 || y2 < 0 ? 0.0f : this.data[x2][y2];
        return D - B - C + A;
    }

    public float get(int x, int y) {
        return this.data[x][y];
    }

    public int Width() {
        return this.width;
    }

    public int Height() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

