/*
 * Decompiled with CFR 0.152.
 */
package tracking.texturetracker;

import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import mathematics.Geometry2D;
import mathematics.metrics.Euclidian;
import mathematics.metrics.Metric;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.Point3DF;
import tracking.texturetracker.TT_DetectDescribe;
import tracking.texturetracker.TT_Drawer2;
import tracking.texturetracker.TT_Homography;
import tracking.texturetracker.TT_IntegralImage;
import tracking.texturetracker.TT_InterestPoint;
import tracking.texturetracker.TT_Parameters;

public class TT_Initializations {
    private List<TT_InterestPoint> list = null;
    public Map<TT_InterestPoint, TT_InterestPoint> matchedPoints = null;
    public TT_DetectDescribe detdes1 = null;
    public TT_DetectDescribe detdes2 = null;
    private TT_Drawer2 drawer = new TT_Drawer2();
    public TT_Homography homography = new TT_Homography();
    public TT_IntegralImage intimg = null;
    public TT_Parameters params = null;
    private int nbGlobalPoints = -1;
    public int found = 0;
    public int notfound = 0;
    public int nbmatched = 0;
    public int sumsize = 0;
    private List<Float> tmp = new Vector<Float>(113);
    private int order = 0;
    private double sigma = 0.0;
    private double[][] distancespoints = null;
    private int width = 0;
    private int height = 0;
    private float ipminx;
    private float ipminy;
    private float ipmaxx;
    private float ipmaxy;
    private int marginsecurity = 0;
    private int border = 0;
    private Metric metric = new Euclidian();

    public TT_Initializations(int order, double sigma) {
        this.order = order;
        this.sigma = sigma;
    }

    public void Initialize(BufferedImage image, int size, int octaves, int layers, int initStep, int stepIncFactor, boolean upright, int nbInterestPoints, int nbGlobalPoints, int delta, int distancesecurity, double descriptorsecurity, int anglesecurity, int marginsecurity, int border, int lineWidth) throws IOException {
        int j;
        int i2;
        int wid = image.getWidth();
        int hei = image.getHeight();
        this.nbGlobalPoints = nbGlobalPoints;
        this.marginsecurity = marginsecurity;
        byte[] src = null;
        TT_IntegralImage intim = new TT_IntegralImage(src, wid, hei, 0, 0, wid, hei);
        this.params = new TT_Parameters(size, octaves, layers, 0.005f, initStep, stepIncFactor, upright, lineWidth, false);
        this.detdes1 = new TT_DetectDescribe(null, this.order, this.sigma);
        float d = 0.001f;
        int nb = 0;
        int secu = 0;
        float threshold = 0.0f;
        do {
            this.list = this.detdes1.detectAndDescribeInterestPoints(intim, this.params);
            if (distancesecurity > 0) {
                this.CleanListDistance(this.list, distancesecurity);
            }
            if (descriptorsecurity > 0.0) {
                this.CleanListDescriptor(this.list, descriptorsecurity);
            }
            if ((nb = this.list.size()) < nbGlobalPoints) {
                if (d > 0.0f) {
                    d /= 10.0f;
                }
                d = -Math.abs(d);
            } else {
                if (d < 0.0f) {
                    d /= 10.0f;
                }
                d = Math.abs(d);
            }
            this.params.setThreshold(this.params.getThreshold() + d);
            if (secu++ <= 500 && !((double)this.params.getThreshold() < 0.0)) continue;
            throw new Error("No convergence.");
        } while (Math.abs(nbGlobalPoints - nb) > delta);
        BufferedImage im1 = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        im1.setData(image.getData());
        this.drawer.drawInterestPoints(im1, this.list, this.params, false);
        ImageIO.Write(im1, "ResultAutomaticSelection00.png", 6);
        this.drawer.drawInterestPoints(im1, this.list, this.params, true);
        ImageIO.Write(im1, "ResultAutomaticSelection01.png", 6);
        threshold = this.params.getThreshold();
        System.out.println("Initialization step 1(" + nbGlobalPoints + ", " + delta + "): " + secu + " iterations  =>  threshold=" + this.params.getThreshold());
        d = -1.0E-4f;
        secu = 0;
        do {
            this.list = this.detdes1.detectAndDescribeInterestPoints(intim, this.params);
            if (distancesecurity > 0) {
                this.CleanListDistance(this.list, distancesecurity);
            }
            if (descriptorsecurity > 0.0) {
                this.CleanListDescriptor(this.list, descriptorsecurity);
            }
            if (anglesecurity > 0) {
                this.CleanListAngles(this.list, anglesecurity);
            }
            if ((nb = this.list.size()) >= nbInterestPoints) continue;
            this.params.setThreshold(this.params.getThreshold() + d);
            if (!((double)this.params.getThreshold() <= 0.0)) continue;
            System.out.println("Error: not enough interest points found.");
            break;
        } while (nb < nbInterestPoints);
        System.out.println("Initialization step 2 (" + nbInterestPoints + "): " + secu + " iterations  =>  found " + this.list.size() + " interest points.");
        this.params.setThreshold(threshold);
        float min = 0.0f;
        for (i2 = 0; i2 < nbInterestPoints && i2 < this.list.size(); ++i2) {
            d = this.list.get((int)i2).strength;
            for (j = 0; j < this.tmp.size() && d < this.tmp.get(j).floatValue(); ++j) {
            }
            min = this.Insert(d, nbInterestPoints);
        }
        for (i2 = nbInterestPoints; i2 < this.list.size(); ++i2) {
            if (!(this.list.get((int)i2).strength > min)) continue;
            min = this.Insert(this.list.get((int)i2).strength, nbInterestPoints);
        }
        d = this.tmp.get(this.tmp.size() - 1).floatValue();
        this.tmp.clear();
        i2 = 0;
        while (i2 < this.list.size()) {
            if (this.list.get((int)i2).strength < d) {
                this.list.remove(i2);
                continue;
            }
            ++i2;
        }
        BufferedImage im2 = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        im2.setData(image.getData());
        this.drawer.drawInterestPoints(im2, this.list, this.params, false);
        ImageIO.Write(im2, "ResultAutomaticSelection02.png", 6);
        BufferedImage im3 = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        im3.setData(image.getData());
        this.drawer.drawInterestPoints(im3, this.list, this.params, true);
        ImageIO.Write(im3, "ResultAutomaticSelection03.png", 6);
        this.distancespoints = new double[this.list.size()][this.list.size()];
        i2 = 0;
        while (i2 < this.list.size()) {
            TT_InterestPoint p1 = this.list.get(i2);
            for (j = i2 + 1; j < this.list.size(); ++j) {
                TT_InterestPoint p2 = this.list.get(j);
                double d2 = this.metric.Distance((double)p1.x, (double)p1.y, 0.0, (double)p2.x, (double)p2.y, 0.0);
                this.distancespoints[j][i2] = d2;
                this.distancespoints[i2][j] = d2;
            }
            p1.number = i2++;
        }
        wid = image.getWidth();
        hei = image.getHeight();
        this.ipminx = wid;
        this.ipminy = hei;
        this.ipmaxy = 0.0f;
        this.ipmaxx = 0.0f;
        for (i2 = 0; i2 < this.list.size(); ++i2) {
            if (this.ipminx > this.list.get((int)i2).x) {
                this.ipminx = this.list.get((int)i2).x;
            }
            if (this.ipminy > this.list.get((int)i2).y) {
                this.ipminy = this.list.get((int)i2).y;
            }
            if (this.ipmaxx < this.list.get((int)i2).x) {
                this.ipmaxx = this.list.get((int)i2).x;
            }
            if (!(this.ipmaxy < this.list.get((int)i2).y)) continue;
            this.ipmaxy = this.list.get((int)i2).y;
        }
        this.detdes2 = new TT_DetectDescribe(null, this.order, this.sigma, marginsecurity, border);
        for (i2 = 0; i2 < this.list.size(); ++i2) {
            this.homography.computeNormalisedCoordinates(this.list.get(i2), wid, hei);
        }
        this.Write("ResultAutomaticSelection.txt");
    }

    protected float Insert(float strength, int nbPoints) {
        int i2;
        if (this.tmp.size() == nbPoints) {
            this.tmp.remove(nbPoints - 1);
        }
        int size = this.tmp.size();
        for (i2 = 0; i2 < size && this.tmp.get(i2).floatValue() > strength; ++i2) {
        }
        this.tmp.add(i2, Float.valueOf(strength));
        return this.tmp.get(this.tmp.size() - 1).floatValue();
    }

    private void CleanListDistance(List<TT_InterestPoint> list, double security) {
        for (int x = 0; x < list.size() - 1; ++x) {
            int y = x + 1;
            while (y < list.size()) {
                if (this.metric.Distance((double)list.get((int)x).x, (double)list.get((int)x).y, 0.0, (double)list.get((int)y).x, (double)list.get((int)y).y, 0.0) < security) {
                    if (list.get((int)x).strength < list.get((int)y).strength) {
                        list.remove(x);
                        y = x + 1;
                        continue;
                    }
                    list.remove(y);
                    continue;
                }
                ++y;
            }
        }
    }

    private void CleanListDescriptor(List<TT_InterestPoint> list, double security) {
        for (int x = 0; x < list.size() - 1; ++x) {
            int y = x + 1;
            while (y < list.size()) {
                if (this.metric.Distance(list.get((int)x).descriptor, list.get((int)y).descriptor) < security) {
                    if (list.get((int)x).strength < list.get((int)y).strength) {
                        list.remove(x);
                        y = x + 1;
                        continue;
                    }
                    list.remove(y);
                    continue;
                }
                ++y;
            }
        }
    }

    private void CleanListAngles(List<TT_InterestPoint> list, double angle) {
        Point3DF p1 = new Point3DF();
        Point3DF p2 = new Point3DF();
        Point3DF p3 = new Point3DF();
        for (int x = 0; x < list.size() - 2; ++x) {
            for (int y = x + 1; y < list.size() - 1; ++y) {
                int z = y + 1;
                while (z < list.size()) {
                    p1.setXY(list.get((int)x).x, list.get((int)x).y);
                    p2.setXY(list.get((int)y).x, list.get((int)y).y);
                    p3.setXY(list.get((int)z).x, list.get((int)z).y);
                    double a1 = Math.abs(Geometry2D.AngleBAC(p1, (Point)p2, p3, true));
                    double a2 = Math.abs(Geometry2D.AngleBAC(p2, (Point)p1, p3, true));
                    double a3 = Math.abs(Geometry2D.AngleBAC(p2, (Point)p3, p1, true));
                    if (a1 < angle || Math.abs(180.0 - a1) < angle || Math.abs(360.0 - a1) < angle || a2 < angle || Math.abs(180.0 - a2) < angle || Math.abs(360.0 - a2) < angle || a3 < angle || Math.abs(180.0 - a3) < angle || Math.abs(360.0 - a3) < angle) {
                        if (list.get((int)z).strength < list.get((int)x).strength && list.get((int)z).strength < list.get((int)y).strength) {
                            list.remove(z);
                            continue;
                        }
                        if (list.get((int)y).strength < list.get((int)x).strength && list.get((int)y).strength < list.get((int)z).strength) {
                            list.remove(y);
                            z = y + 1;
                            continue;
                        }
                        list.remove(x);
                        y = x + 1;
                        z = y + 1;
                        continue;
                    }
                    ++z;
                }
            }
        }
    }

    public void Write(String name) throws UnsupportedEncodingException, IOException {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(name));
        out.write((this.width + "\t" + this.height + "\n").getBytes("ASCII"));
        out.write((this.order + "\t" + this.sigma + "\n").getBytes("ASCII"));
        out.write((this.list.size() + "\t" + this.nbGlobalPoints + "\t" + this.marginsecurity + "\t" + this.border + "\n").getBytes("ASCII"));
        out.write("\n".getBytes("ASCII"));
        for (int i2 = 0; i2 < this.list.size(); ++i2) {
            this.list.get(i2).Write(out);
        }
        out.write("\n".getBytes("ASCII"));
        this.params.Write(out);
        out.write("\n".getBytes("ASCII"));
    }
}

