/*
 * Decompiled with CFR 0.152.
 */
package tracking.texturetracker;

import Jama.Matrix;
import displays.Colors;
import ij.process.ImageProcessor;
import imageTiTi.ImageDrawer;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.List;
import mathematics.primitives.pointsTiTi.Point;
import tracking.texturetracker.TT_Detection;
import tracking.texturetracker.TT_InterestPoint;
import tracking.texturetracker.TT_Parameters;

public class TT_Drawer2 {
    private ImageDrawer imdraw = new ImageDrawer();

    public void drawInterestPoints(BufferedImage img, List<TT_InterestPoint> ipts, TT_Parameters params, boolean direction) {
        for (TT_InterestPoint ipt : ipts) {
            this.drawSingleInterestPoint(img, params, ipt, direction);
        }
    }

    public void drawSingleInterestPoint(BufferedImage img, TT_Parameters p, TT_InterestPoint ipt, boolean direction) {
        int order = p.getLineWidth();
        int x = Math.round(ipt.x);
        int y = Math.round(ipt.y);
        if (direction) {
            float ori = ipt.orientation;
            float co = (float)Math.cos(ori);
            float si = (float)Math.sin(ori);
            float s = ipt.strength * 10000.0f;
            ImageDrawer.Line(img, x, y, Math.round(s * co + (float)x), Math.round(s * si + (float)y), order, Colors.YELLOW);
        }
        if (ipt.sign) {
            ImageDrawer.Point(img, x, y, order + 1, Colors.GREEN);
        } else {
            ImageDrawer.Point(img, x, y, order + 1, Colors.GREEN5);
        }
    }

    public void drawPoint(BufferedImage img, TT_Parameters p, Point ipt, float[] color) {
        int order = p.getLineWidth();
        int x = (int)Math.round(ipt.getX());
        int y = (int)Math.round(ipt.getY());
        ImageDrawer.Point(img, x, y, order, color);
    }

    public void drawLine(BufferedImage img, TT_Parameters p, Matrix ipt1, Matrix ipt2) {
        int order = p.getLineWidth();
        int x1 = (int)Math.round(ipt1.get(0, 0));
        int y1 = (int)Math.round(ipt1.get(0, 1));
        int x2 = (int)Math.round(ipt2.get(0, 0));
        int y2 = (int)Math.round(ipt2.get(0, 1));
        ImageDrawer.Line(img, x1, y1, x2, y2, order, Colors.GREEN);
    }

    public void drawLine2(BufferedImage img, TT_Parameters p, Matrix ipt1, Matrix ipt2, float[] color) {
        int order = p.getLineWidth();
        int x1 = (int)Math.round(ipt1.get(0, 0));
        int y1 = (int)Math.round(ipt1.get(1, 0));
        int x2 = (int)Math.round(ipt2.get(0, 0));
        int y2 = (int)Math.round(ipt2.get(1, 0));
        ImageDrawer.Line(img, x1, y1, x2, y2, order, color);
    }

    public void drawSingleInterestPoint(ImageProcessor img, TT_InterestPoint ipt, boolean orientation) {
        int x = Math.round(ipt.x);
        int y = Math.round(ipt.y);
        float ori = ipt.orientation;
        float co = (float)Math.cos(ori);
        float si = (float)Math.sin(ori);
        float s = ipt.strength * 10000.0f;
        img.setLineWidth(1);
        img.setColor(Color.yellow);
        img.drawLine(x, y, Math.round(s * co + (float)x), Math.round(s * si + (float)y));
        img.setLineWidth(3);
        if (ipt.sign) {
            img.setColor(Color.red);
        } else {
            img.setColor(Color.blue);
        }
        img.drawDot(x, y);
    }

    public void drawResearchWindow(BufferedImage img, TT_Parameters p, TT_Detection detector) {
        ImageDrawer.Line(img, detector.startx, detector.starty, detector.endx, detector.starty, p.getLineWidth(), Colors.PURPLE);
        ImageDrawer.Line(img, detector.endx, detector.starty, detector.endx, detector.endy, p.getLineWidth(), Colors.PURPLE);
        ImageDrawer.Line(img, detector.endx, detector.endy, detector.startx, detector.endy, p.getLineWidth(), Colors.PURPLE);
        ImageDrawer.Line(img, detector.startx, detector.endy, detector.startx, detector.starty, p.getLineWidth(), Colors.PURPLE);
    }
}

