/*
 * Decompiled with CFR 0.152.
 */
package tracking.texturetracker;

import Jama.Matrix;
import java.util.List;
import mathematics.primitives.pointsTiTi.Point;
import tracking.texturetracker.TT_Detection;
import tracking.texturetracker.TT_InterestPoint;
import tracking.texturetracker.TT_Parameters;

public class TT_Drawer {
    public void drawInterestPoints(byte[] img, int width, int height, List<TT_InterestPoint> ipts, TT_Parameters params, boolean direction) {
        for (TT_InterestPoint ipt : ipts) {
            this.drawSingleInterestPoint(img, width, height, params, ipt, direction);
        }
    }

    public void drawSingleInterestPoint(byte[] img, int width, int height, TT_Parameters p, TT_InterestPoint ipt, boolean direction) {
        int order = p.getLineWidth();
        int x = Math.round(ipt.x);
        int y = Math.round(ipt.y);
        if (direction) {
            float ori = ipt.orientation;
            float co = (float)Math.cos(ori);
            float si = (float)Math.sin(ori);
            float s = ipt.strength * 10000.0f;
            this.Line(img, width, height, x, y, Math.round(s * co + (float)x), Math.round(s * si + (float)y), order, 255);
        }
        if (ipt.sign) {
            this.Point(img, width, height, x, y, order + 1, 0);
        } else {
            this.Point(img, width, height, x, y, order + 1, 75);
        }
    }

    public void drawPoint(byte[] img, int width, int height, TT_Parameters p, Point ipt, int color) {
        int order = p.getLineWidth();
        int x = (int)Math.round(ipt.getX());
        int y = (int)Math.round(ipt.getY());
        this.Point(img, width, height, x, y, order, color);
    }

    public void drawLine(byte[] img, int width, int height, TT_Parameters p, Matrix ipt1, Matrix ipt2, int color) {
        int order = p.getLineWidth();
        int x1 = (int)Math.round(ipt1.get(0, 0));
        int y1 = (int)Math.round(ipt1.get(0, 1));
        int x2 = (int)Math.round(ipt2.get(0, 0));
        int y2 = (int)Math.round(ipt2.get(0, 1));
        this.Line(img, width, height, x1, y1, x2, y2, order, color);
    }

    public void drawLine2(byte[] img, int width, int height, TT_Parameters p, Matrix ipt1, Matrix ipt2, int color) {
        int order = p.getLineWidth();
        int x1 = (int)Math.round(ipt1.get(0, 0));
        int y1 = (int)Math.round(ipt1.get(1, 0));
        int x2 = (int)Math.round(ipt2.get(0, 0));
        int y2 = (int)Math.round(ipt2.get(1, 0));
        this.Line(img, width, height, x1, y1, x2, y2, order, color);
    }

    public void drawResearchWindow(byte[] img, int width, int height, TT_Parameters p, TT_Detection detector) {
        int color = 200;
        this.Line(img, width, height, detector.startx, detector.starty, detector.endx, detector.starty, p.getLineWidth(), color);
        this.Line(img, width, height, detector.starty, detector.endx, detector.endx, detector.endy, p.getLineWidth(), color);
        this.Line(img, width, height, detector.endx, detector.endy, detector.startx, detector.endy, p.getLineWidth(), color);
        this.Line(img, width, height, detector.startx, detector.endy, detector.startx, detector.starty, p.getLineWidth(), color);
    }

    public void Line(byte[] image, int width, int height, int xi, int yi, int xf, int yf, int order, int color) {
        int x = xi;
        int y = yi;
        int dx = xf - xi;
        int dy = yf - yi;
        int xinc = dx > 0 ? 1 : -1;
        int yinc = dy > 0 ? 1 : -1;
        dx = Math.abs(dx);
        dy = Math.abs(dy);
        this.Point(image, width, height, x, y, order, color);
        if (dx > dy) {
            int cumul = dx / 2;
            for (int i2 = 1; i2 <= dx; ++i2) {
                x += xinc;
                if ((cumul += dy) >= dx) {
                    cumul -= dx;
                    y += yinc;
                }
                this.Point(image, width, height, x, y, order, color);
            }
        } else {
            int cumul = dy / 2;
            for (int i3 = 1; i3 <= dy; ++i3) {
                y += yinc;
                if ((cumul += dx) >= dy) {
                    cumul -= dy;
                    x += xinc;
                }
                this.Point(image, width, height, x, y, order, color);
            }
        }
    }

    public void Point(byte[] image, int width, int height, int x, int y, int order, int color) {
        for (int i2 = y - order; i2 <= y + order; ++i2) {
            for (int j = x - order; j <= x + order; ++j) {
                if (i2 < 0 || j < 0 || i2 >= height || j >= width) continue;
                image[x + y * width] = (byte)color;
            }
        }
    }
}

