/*
 * Decompiled with CFR 0.152.
 */
package tracking.texturetracker;

import java.util.ArrayList;
import java.util.List;
import tracking.texturetracker.TT_IntegralImage;
import tracking.texturetracker.TT_InterestPoint;
import tracking.texturetracker.TT_Parameters;

public class TT_Detection {
    private float[][][] det = null;
    private float[][][] trace = null;
    private List<TT_InterestPoint> res = new ArrayList<TT_InterestPoint>(613);
    public int startx;
    public int starty;
    public int endx;
    public int endy;
    private int marginsecure = 0;
    private int msecu;
    private int border = 0;
    private float[] X = new float[3];
    private float cste = 0.13333334f;
    private int nbAlert = 0;
    private float[][] A = new float[3][3];
    private final float EPSILON = 1.4E-43f;

    public TT_Detection() {
        this.msecu = this.marginsecure;
    }

    public TT_Detection(int marginsecure, int border) {
        if (marginsecure < 0) {
            throw new IllegalArgumentException("marginsecure < 0.");
        }
        this.marginsecure = marginsecure;
        this.msecu = marginsecure;
        this.border = border;
    }

    public List<TT_InterestPoint> fastHessian(TT_IntegralImage img, TT_Parameters p) {
        if (this.det == null || this.det.length != p.getLayers() || this.det[0].length != img.Width() || this.det[0][0].length != img.Height()) {
            this.det = new float[p.getLayers()][img.Width()][img.Height()];
            this.trace = new float[p.getLayers()][img.Width()][img.Height()];
            this.starty = 0;
            this.startx = 0;
            this.endx = img.Width();
            this.endy = img.Height();
        }
        this.res.clear();
        this.X[2] = 0.0f;
        this.X[1] = 0.0f;
        this.X[0] = 0.0f;
        int nb = 0;
        int octave = 0;
        int step = p.getInitStep();
        while (octave < p.getOctaves()) {
            int x;
            int y;
            int layer;
            int margin = p.getMaxFilterSize(octave) / 2;
            int marginx = this.startx + margin;
            int marginy = this.starty + margin;
            int xBound = this.endx - margin;
            int yBound = this.endy - margin;
            for (layer = 0; layer < p.getLayers(); ++layer) {
                int w = p.getFilterSize(octave, layer);
                int L = w / 3;
                int L2 = 2 * L - 1;
                int wHalf = w / 2;
                int LHalf = L / 2;
                int Lminus1 = L - 1;
                float filterArea = w * w;
                for (y = marginy; y < yBound; y += step) {
                    for (x = marginx; x < xBound; x += step) {
                        float Dxx = img.area(x - wHalf, y - Lminus1, w, L2) - img.area(x - LHalf, y - Lminus1, L, L2) * 3.0f;
                        float Dyy = img.area(x - Lminus1, y - wHalf, L2, w) - img.area(x - Lminus1, y - LHalf, L2, L) * 3.0f;
                        float Dxy = img.area(x - L, y - L, L, L) - img.area(x + 1, y - L, L, L) + img.area(x + 1, y + 1, L, L) - img.area(x - L, y + 1, L, L);
                        this.det[layer][x][y] = (Dxx /= filterArea) * (Dyy /= filterArea) - 0.81f * (Dxy /= filterArea) * Dxy;
                        this.trace[layer][x][y] = Dxx + Dyy;
                    }
                }
            }
            margin += step;
            xBound -= step;
            yBound -= step;
            for (layer = 1; layer < p.getLayers() - 1; ++layer) {
                int filterSize = p.getFilterSize(octave, layer);
                int filterSizeIncrement = filterSize - p.getFilterSize(octave, layer - 1);
                for (y = marginy; y < yBound; y += step) {
                    for (x = marginx; x < xBound; x += step) {
                        float v = this.det[layer][x][y];
                        if (v < p.getThreshold() || !this.isLocalMaximum(v, this.det, layer, x, y, step) || !this.interpolatePoint(this.det, layer, x, y, step, this.X)) continue;
                        float xInterp = (float)x + this.X[0] * (float)step;
                        float yInterp = (float)y + this.X[1] * (float)step;
                        float scale = ((float)filterSize + this.X[2] * (float)filterSizeIncrement) * this.cste;
                        if (!(scale >= 1.0f) || !(0.0f <= xInterp) || !(xInterp < (float)img.Width()) || !(0.0f <= yInterp) || !(yInterp < (float)img.Height())) continue;
                        this.res.add(new TT_InterestPoint(p.getDescSize(), xInterp, yInterp, this.det[layer][x][y], this.trace[layer][x][y], scale, nb++));
                    }
                }
            }
            ++octave;
            step *= p.getStepIncFactor();
        }
        return this.res;
    }

    public void FindWindowSize(float infx, float infy, float supx, float supy, int newx, int newy, double ratio, int minx, int miny, int maxx, int maxy) {
        this.startx = newx - (int)((double)infx / ratio) - this.border;
        this.starty = newy - (int)((double)infy / ratio) - this.border;
        this.endx = newx + (int)((double)supx / ratio) + this.border;
        this.endy = newy + (int)((double)supy / ratio) + this.border;
        if (this.startx >= minx - this.msecu) {
            this.startx = minx - this.msecu;
        }
        if (this.starty >= miny - this.msecu) {
            this.starty = miny - this.msecu;
        }
        if (this.endx <= maxx + this.msecu) {
            this.endx = maxx + this.msecu;
        }
        if (this.endy <= maxy + this.msecu) {
            this.endy = maxy + this.msecu;
        }
        this.startx = this.startx - this.msecu < 0 ? 0 : this.startx - this.msecu;
        this.starty = this.starty - this.msecu < 0 ? 0 : this.starty - this.msecu;
        this.endx = this.endx + this.msecu >= this.det[0].length ? this.det[0].length : this.endx + this.msecu;
        this.endy = this.endy + this.msecu >= this.det[0][0].length ? this.det[0][0].length : this.endy + this.msecu;
    }

    public void ResetSecurity() {
        this.msecu = this.marginsecure;
        this.nbAlert = 0;
    }

    public void ActivateSecurity() {
        ++this.nbAlert;
        if (this.msecu <= this.nbAlert * this.marginsecure || this.msecu <= this.border) {
            this.msecu += this.marginsecure;
            this.startx = this.startx - this.msecu < 0 ? 0 : this.startx - this.msecu;
            this.starty = this.starty - this.msecu < 0 ? 0 : this.starty - this.msecu;
            this.endx = this.endx + this.msecu >= this.det[0].length ? this.det[0].length : this.endx + this.msecu;
            this.endy = this.endy + this.msecu >= this.det[0][0].length ? this.det[0][0].length : this.endy + this.msecu;
        }
    }

    private boolean isLocalMaximum(float v, float[][][] det, int s, int x, int y, int step) {
        float[][] l = det[s - 1];
        float[][] m = det[s];
        float[][] u = det[s + 1];
        int px = x - step;
        int nx = x + step;
        int py = y - step;
        int ny = y + step;
        return v >= l[px][py] && v >= l[px][y] && v >= l[px][ny] && v >= l[x][py] && v >= l[x][y] && v >= l[x][ny] && v >= l[nx][py] && v >= l[nx][y] && v >= l[nx][ny] && v >= m[px][py] && v >= m[px][y] && v >= m[px][ny] && v >= m[x][py] && v >= m[x][ny] && v >= m[nx][py] && v >= m[nx][y] && v >= m[nx][ny] && v >= u[px][py] && v >= u[px][y] && v >= u[px][ny] && v >= u[x][py] && v >= u[x][y] && v >= u[x][ny] && v >= u[nx][py] && v >= u[nx][y] && v >= u[nx][ny];
    }

    private boolean interpolatePoint(float[][][] det, int i2, int x, int y, int step, float[] X) {
        float[][] l = det[i2 - 1];
        float[][] m = det[i2];
        float[][] u = det[i2 + 1];
        int px = x - step;
        int nx = x + step;
        int py = y - step;
        int ny = y + step;
        float dx = -(m[nx][y] - m[px][y]) / 2.0f;
        float dy = -(m[x][ny] - m[x][py]) / 2.0f;
        float ds = -(u[x][y] - l[x][y]) / 2.0f;
        float[] b = new float[]{dx, dy, ds};
        float v = m[x][y];
        float dxx = m[px][y] - 2.0f * v + m[nx][y];
        float dxy = (m[nx][ny] - m[px][ny] - m[nx][py] + m[px][py]) / 4.0f;
        float dxs = (u[nx][y] - u[px][y] - l[nx][y] + l[px][y]) / 4.0f;
        float dyx = dxy;
        float dyy = m[x][py] - 2.0f * v + m[x][ny];
        float dys = (u[x][ny] - u[x][py] - l[x][ny] + l[x][py]) / 4.0f;
        float dsx = dxs;
        float dsy = dys;
        float dss = l[x][y] - 2.0f * v + u[x][y];
        this.A[0][0] = dxx;
        this.A[0][1] = dxy;
        this.A[0][2] = dxs;
        this.A[1][0] = dyx;
        this.A[1][1] = dyy;
        this.A[1][2] = dys;
        this.A[2][0] = dsx;
        this.A[2][1] = dsy;
        this.A[2][2] = dss;
        return this.solve(this.A, b, X);
    }

    public boolean solve(float[][] A, float[] B, float[] X) {
        float a = A[0][0];
        float b = A[0][1];
        float c = A[0][2];
        float d = A[1][0];
        float e = A[1][1];
        float f = A[1][2];
        float g = A[2][0];
        float h = A[2][1];
        float i2 = A[2][2];
        float r = B[0];
        float s = B[1];
        float t = B[2];
        float detA = this.det(a, b, c, d, e, f, g, h, i2);
        if (this.equal(detA, 0.0f)) {
            return false;
        }
        float detX1 = this.det(r, b, c, s, e, f, t, h, i2);
        float detX2 = this.det(a, r, c, d, s, f, g, t, i2);
        float detX3 = this.det(a, b, r, d, e, s, g, h, t);
        X[0] = detX1 / detA;
        X[1] = detX2 / detA;
        X[2] = detX3 / detA;
        return true;
    }

    private float det(float a, float b, float c, float d, float e, float f, float g, float h, float i2) {
        return a * (e * i2 - f * h) + b * (f * g - d * i2) + c * (d * h - e * g);
    }

    public boolean equal(float f1, float f2) {
        return Math.abs(f1 - f2) < 1.4E-43f;
    }
}

