/*
 * Decompiled with CFR 0.152.
 */
package tracking.texturetracker;

import java.util.List;
import mathematics.metrics.Euclidian;
import mathematics.metrics.Metric;
import tracking.texturetracker.TT_Description;
import tracking.texturetracker.TT_Detection;
import tracking.texturetracker.TT_IntegralImage;
import tracking.texturetracker.TT_InterestPoint;
import tracking.texturetracker.TT_Parameters;
import tracking.texturetracker.TT_SearchInMovie;

public class TT_DetectDescribe {
    public TT_Description descriptor = null;
    public TT_Detection detector = null;
    private Metric metric = new Euclidian();
    private TT_SearchInMovie parent = null;

    public TT_DetectDescribe(TT_SearchInMovie parent, int order, double sigma) {
        this.parent = parent;
        this.descriptor = new TT_Description(order, sigma);
        this.detector = new TT_Detection();
    }

    public TT_DetectDescribe(TT_SearchInMovie parent, int order, double sigma, int marginsecure, int border) {
        this.parent = parent;
        this.descriptor = new TT_Description(order, sigma);
        this.detector = new TT_Detection(marginsecure, border);
    }

    public List<TT_InterestPoint> detectAndDescribeInterestPoints(TT_IntegralImage intImg, TT_Parameters p) {
        return this.detectAndDescribeInterestPoints(intImg, p, 0);
    }

    public List<TT_InterestPoint> detectAndDescribeInterestPoints(TT_IntegralImage intImg, TT_Parameters p, int security) {
        int marker = this.parent.chrono.NewMarker();
        List<TT_InterestPoint> ipts = this.detector.fastHessian(intImg, p);
        if (this.parent.bordel) {
            this.parent.timeDetectionNF += this.parent.chrono.getTimeSinceMarker(marker);
        } else {
            this.parent.timeDetection += this.parent.chrono.getTimeSinceMarker(marker);
        }
        this.parent.chrono.FreeMarker(marker);
        if (security > 0) {
            this.CleanListDistance(ipts, security);
        }
        marker = this.parent.chrono.NewMarker();
        if (!p.isUpright()) {
            for (TT_InterestPoint ipt : ipts) {
                this.descriptor.computeAndSetOrientation(ipt, intImg);
            }
        }
        for (TT_InterestPoint ipt : ipts) {
            this.descriptor.computeAndSetDescriptor(ipt, intImg, p);
        }
        if (this.parent.bordel) {
            this.parent.timeDescriptionNF += this.parent.chrono.getTimeSinceMarker(marker);
        } else {
            this.parent.timeDescription += this.parent.chrono.getTimeSinceMarker(marker);
        }
        this.parent.chrono.FreeMarker(marker);
        return ipts;
    }

    private void CleanListDistance(List<TT_InterestPoint> list, double security) {
        for (int x = 0; x < list.size() - 1; ++x) {
            int y = x + 1;
            while (y < list.size()) {
                if (this.metric.Distance((double)list.get((int)x).x, (double)list.get((int)x).y, 0.0, (double)list.get((int)y).x, (double)list.get((int)y).y, 0.0) < security) {
                    if (list.get((int)x).strength < list.get((int)y).strength) {
                        list.remove(x);
                        y = x + 1;
                        continue;
                    }
                    list.remove(y);
                    continue;
                }
                ++y;
            }
        }
    }
}

