/*
 * Decompiled with CFR 0.152.
 */
package tracking.surfold;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Statistics {
    public Date startTime;
    public String imageTitle;
    public int detectedIPs;
    public float[] strengthOfIPs;
    public long timeIntegralImage;
    public long timeSURFDetector;
    public long timeSURFDescriptor;
    public long timeMatcher;
    public List<DetectorStat> detectorStatList = new ArrayList<DetectorStat>();

    public void add(int octave, int layer, int countIPCandidates, int countThresholded, int countSuppressed, int countInterpolationNotSucceed, int countBadInterpolationResult, int countIP) {
        DetectorStat ds = new DetectorStat();
        ds.octave = octave;
        ds.layer = layer;
        ds.countIPCandidates = countIPCandidates;
        ds.countThresholded = countThresholded;
        ds.countSuppressed = countSuppressed;
        ds.countInterpolationNotSucceed = countInterpolationNotSucceed;
        ds.countBadInterpolationResult = countBadInterpolationResult;
        ds.countIP = countIP;
        this.detectorStatList.add(ds);
    }

    public static String getHeadersForIJ() {
        return "Octave\tLayer\tIPCandidates\tThresholded\tSuppressed\tInterpolationNotSucceed\tBadInterpolationResult\tFinal IPs";
    }

    public static String getEmptyHeadersForIJ() {
        return " \t \t \t \t \t \t \t ";
    }

    public String[] getRowsForIJ() {
        String[] result = new String[this.detectorStatList.size()];
        for (int i2 = 0; i2 < this.detectorStatList.size(); ++i2) {
            DetectorStat ds = this.detectorStatList.get(i2);
            result[i2] = ds.octave + "\t" + ds.layer + "\t" + ds.countIPCandidates + "\t" + ds.countThresholded + "\t" + ds.countSuppressed + "\t" + ds.countInterpolationNotSucceed + "\t" + ds.countBadInterpolationResult + "\t" + ds.countIP;
        }
        return result;
    }

    public static class DetectorStat {
        public int octave;
        public int layer;
        public int countIPCandidates;
        public int countThresholded;
        public int countSuppressed;
        public int countInterpolationNotSucceed;
        public int countBadInterpolationResult;
        public int countIP;
    }
}

