/*
 * Decompiled with CFR 0.152.
 */
package tracking.surfold;

import ij.ImagePlus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tracking.surfold.IJFacade;
import tracking.surfold.IntegralImage;
import tracking.surfold.InterestPoint;
import tracking.surfold.Matcher;
import tracking.surfold.Params;
import utils.times.Chronometer;

public class SearchInMovie {
    private List<InterestPoint> list = null;
    private List<InterestPoint> movielist = null;
    private Map<InterestPoint, InterestPoint> matchedPoints = null;
    private Params params = null;
    private boolean doReverseComparisonToo = false;
    public int founded = 0;
    public int notfounded = 0;
    public double time1 = 0.0;
    public double time2 = 0.0;
    public double time3 = 0.0;
    public double time4 = 0.0;
    private Chronometer chrono = new Chronometer();

    public void Initialize(ImagePlus imp, int octaves, int layers, float threshold, int initStep, boolean upright, boolean displayOrientationVectors, boolean displayDescriptorWindows, int lineWidth, boolean doReverseComparisonToo) {
        this.params = new Params(octaves, layers, threshold, initStep, upright, displayOrientationVectors, displayDescriptorWindows, lineWidth, false);
        this.doReverseComparisonToo = doReverseComparisonToo;
        this.list = IJFacade.detectAndDescribeInterestPoints(new IntegralImage(imp.getProcessor(), true), this.params);
    }

    public void run(ImagePlus imp) {
        if (this.list == null) {
            throw new Error("Initialisation required before use run method.");
        }
        int marker = this.chrono.NewMarker();
        IntegralImage intimg = new IntegralImage(imp.getProcessor(), true);
        this.time1 += this.chrono.getTimeSinceMarker(marker);
        this.chrono.FreeMarker(marker);
        marker = this.chrono.NewMarker();
        this.movielist = IJFacade.detectAndDescribeInterestPoints(intimg, this.params);
        this.time2 += this.chrono.getTimeSinceMarker(marker);
        this.chrono.FreeMarker(marker);
        marker = this.chrono.NewMarker();
        this.matchedPoints = Matcher.findMathes(this.list, this.movielist);
        this.time4 += this.chrono.getTimeSinceMarker(marker);
        this.chrono.FreeMarker(marker);
        if (this.doReverseComparisonToo) {
            Map<InterestPoint, InterestPoint> matchedPointsReverse = Matcher.findMathes(this.list, this.movielist);
            this.matchedPoints = this.intersection(this.matchedPoints, matchedPointsReverse);
        }
        if (this.matchedPoints.isEmpty()) {
            ++this.notfounded;
            return;
        }
        ++this.founded;
        for (Map.Entry<InterestPoint, InterestPoint> pair : this.matchedPoints.entrySet()) {
            IJFacade.drawSingleInterestPoint(imp.getProcessor(), this.params, pair.getValue());
        }
    }

    Map<InterestPoint, InterestPoint> intersection(Map<InterestPoint, InterestPoint> map1, Map<InterestPoint, InterestPoint> map2) {
        HashMap<InterestPoint, InterestPoint> result = new HashMap<InterestPoint, InterestPoint>(23);
        for (InterestPoint ipt1 : map1.keySet()) {
            InterestPoint ipt2;
            if (ipt1 != map2.get(ipt2 = map1.get(ipt1))) continue;
            result.put(ipt1, ipt2);
        }
        return result;
    }
}

