/*
 * Decompiled with CFR 0.152.
 */
package tracking.surfold;

import ij.gui.GenericDialog;
import java.awt.Color;
import tracking.surfold.Statistics;

public class Params {
    public static final String programVersion = "ImageJ SURF v2009-12-01";
    private int[][] filterSizes = new int[][]{{9, 15, 21, 27}, {15, 27, 39, 51}, {27, 51, 75, 99}, {51, 99, 147, 195}};
    private int[] maxFilterSizes = new int[]{27, 51, 99, 195};
    private int octaves = 4;
    private int layers = 4;
    boolean doubleImageSize = false;
    private float threshold = 0.001f;
    private int initStep = 2;
    private int stepIncFactor = 2;
    private boolean upright;
    private int descSize = 64;
    private boolean displayOrientationVectors = true;
    private boolean displayDescriptorWindows = false;
    private int lineWidth = 1;
    boolean displayStatistics = false;
    private Statistics stat = new Statistics();

    public Params() {
    }

    public Params(int octaves, int layers, float threshold, int initStep, boolean upright, boolean displayOrientationVectors, boolean displayDescriptorWindows, int lineWidth, boolean displayStatistics) {
        this.octaves = this.validate(octaves, 3, 4);
        this.layers = this.validate(layers, 3, 4);
        this.threshold = this.validate(threshold, 0.0f, 1.0f);
        this.initStep = this.validate(initStep, 1, 6);
        this.upright = upright;
        this.displayOrientationVectors = displayOrientationVectors;
        this.displayDescriptorWindows = displayDescriptorWindows;
        this.lineWidth = this.validate(lineWidth, 1, 5);
        this.displayStatistics = displayStatistics;
    }

    public Params(Params p) {
        this.octaves = p.octaves;
        this.layers = p.layers;
        this.threshold = p.threshold;
        this.initStep = p.initStep;
        this.upright = p.upright;
        this.displayOrientationVectors = p.displayOrientationVectors;
        this.displayDescriptorWindows = p.displayDescriptorWindows;
        this.lineWidth = p.lineWidth;
        this.displayStatistics = p.displayStatistics;
    }

    private float validate(float val, float lowerBound, float upperBound) {
        if (val < lowerBound) {
            return lowerBound;
        }
        if (val > upperBound) {
            return upperBound;
        }
        return val;
    }

    int validate(int val, int lowerBound, int upperBound) {
        if (val < lowerBound) {
            return lowerBound;
        }
        if (val > upperBound) {
            return upperBound;
        }
        return val;
    }

    public int getOctaves() {
        return this.octaves;
    }

    public int getLayers() {
        return this.layers;
    }

    public int getFilterSize(int octave, int layer) {
        return this.filterSizes[octave][layer];
    }

    public int getMaxFilterSize(int octave) {
        return this.maxFilterSizes[octave];
    }

    public float getThreshold() {
        return this.threshold;
    }

    public int getInitStep() {
        return this.initStep;
    }

    public int getStepIncFactor() {
        return this.stepIncFactor;
    }

    public boolean isUpright() {
        return this.upright;
    }

    public int getDescSize() {
        return this.descSize;
    }

    public boolean isDisplayOrientationVectors() {
        return this.displayOrientationVectors;
    }

    public boolean isDisplayDescriptorWindows() {
        return this.displayDescriptorWindows;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public boolean isDisplayStatistics() {
        return this.displayStatistics;
    }

    public Statistics getStatistics() {
        return this.stat;
    }

    public static void addSurfParamsToDialog(GenericDialog gd) {
        Params p = new Params();
        gd.addMessage("=================== DETECTOR ===================");
        gd.addNumericField("Octaves (3..4) :", (double)p.getOctaves(), 0);
        gd.addNumericField("Layers per Octave (3..4) :", (double)p.getLayers(), 0);
        gd.addNumericField("Hessian Threshold (0..1) :", (double)p.getThreshold(), 5);
        gd.addNumericField("Initial Sampling Step (1..6) :", (double)p.getInitStep(), 0);
        gd.addMessage("================== DESCRIPTOR ==================");
        gd.addCheckbox("Upright SURF (slightly faster, but not rotation invariant)", p.isUpright());
        gd.addMessage("=============== DISPLAYING RESULTS ==============");
        gd.addCheckbox("Orientation Vectors (Length shows the strength of I.P.) ", p.isDisplayOrientationVectors());
        gd.addCheckbox("Descriptor Windows", p.isDisplayDescriptorWindows());
        gd.addNumericField("Line Width (1..5) :", (double)p.getLineWidth(), 0);
        gd.addCheckbox("Statistics", p.isDisplayStatistics());
    }

    public static Params getSurfParamsFromDialog(GenericDialog gd) {
        int octaves = (int)gd.getNextNumber();
        int layers = (int)gd.getNextNumber();
        float threshold = (float)gd.getNextNumber();
        int initStep = (int)gd.getNextNumber();
        boolean upright = gd.getNextBoolean();
        boolean displayOrientationVectors = gd.getNextBoolean();
        boolean displayDescriptorWindows = gd.getNextBoolean();
        int lineWidth = (int)gd.getNextNumber();
        boolean displayStatistics = gd.getNextBoolean();
        return new Params(octaves, layers, threshold, initStep, upright, displayOrientationVectors, displayDescriptorWindows, lineWidth, displayStatistics);
    }

    public Color getDescriptorWindowColor() {
        return Color.PINK;
    }

    public Color getOrientationVectorColor() {
        return Color.YELLOW;
    }

    public Color getDarkPointColor() {
        return Color.BLUE;
    }

    public Color getLightPointColor() {
        return Color.RED;
    }
}

