/*
 * Decompiled with CFR 0.152.
 */
package tracking.surfold;

import ij.ImagePlus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tracking.surfold.InterestPoint;

public class Matcher {
    public static Map<InterestPoint, InterestPoint> findMathes(List<InterestPoint> ipts1, List<InterestPoint> ipts2, boolean doReverseComparisonToo) {
        Map<InterestPoint, InterestPoint> matchedPoints = Matcher.findMathes(ipts1, ipts2);
        if (doReverseComparisonToo) {
            Map<InterestPoint, InterestPoint> matchedPointsReverse = Matcher.findMathes(ipts2, ipts1);
            HashMap<InterestPoint, InterestPoint> matchedPointsBoth = new HashMap<InterestPoint, InterestPoint>(53);
            for (InterestPoint ipt1 : matchedPoints.keySet()) {
                InterestPoint ipt2;
                if (ipt1 != matchedPointsReverse.get(ipt2 = matchedPoints.get(ipt1))) continue;
                matchedPointsBoth.put(ipt1, ipt2);
            }
            matchedPoints = matchedPointsBoth;
        }
        return matchedPoints;
    }

    public static Map<InterestPoint, InterestPoint> findMathes(List<InterestPoint> ipts1, List<InterestPoint> ipts2) {
        HashMap<InterestPoint, InterestPoint> res = new HashMap<InterestPoint, InterestPoint>(53);
        int descSize = 64;
        for (InterestPoint p1 : ipts1) {
            float secondBest = Float.MAX_VALUE;
            float bestDistance = Float.MAX_VALUE;
            InterestPoint bestMatch = null;
            block1: for (InterestPoint p2 : ipts2) {
                if (p1.sign != p2.sign) continue;
                float distance = 0.0f;
                float[] v1 = p1.descriptor;
                float[] v2 = p2.descriptor;
                for (int i2 = 0; i2 < descSize; ++i2) {
                    float delta = v1[i2] - v2[i2];
                    if ((distance += delta * delta) >= secondBest) continue block1;
                }
                if (distance < bestDistance) {
                    secondBest = bestDistance;
                    bestDistance = distance;
                    bestMatch = p2;
                    continue;
                }
                secondBest = distance;
            }
            if (!(bestDistance < 0.5f * secondBest)) continue;
            res.put(p1, bestMatch);
            bestMatch.dx = bestMatch.x - p1.x;
            bestMatch.dy = bestMatch.y - p1.y;
        }
        return res;
    }

    public static Point2Df getTargetPointByHomography(Point2Df p1, float[][] h) {
        float p1_z = 1.0f;
        float Z = h[2][0] * p1.x + h[2][1] * p1.y + h[2][2] * p1_z;
        float X = (h[0][0] * p1.x + h[0][1] * p1.y + h[0][2] * p1_z) / Z;
        float Y = (h[1][0] * p1.x + h[1][1] * p1.y + h[1][2] * p1_z) / Z;
        return new Point2Df(X, Y);
    }

    public static int countMatchesUsingHomography(Map<InterestPoint, InterestPoint> matches, ImagePlus imp1, int margin, float[][] h, ImagePlus imp2, float tolerance) {
        int count = 0;
        for (Map.Entry<InterestPoint, InterestPoint> pair : matches.entrySet()) {
            float x1 = pair.getKey().x;
            float y1 = pair.getKey().y;
            float x2 = pair.getValue().x;
            float y2 = pair.getValue().y;
            float z2H = h[2][0] * x1 + h[2][1] * y1 + h[2][2];
            float x2H = (h[0][0] * x1 + h[0][1] * y1 + h[0][2]) / z2H;
            float y2H = (h[1][0] * x1 + h[1][1] * y1 + h[1][2]) / z2H;
            float dx = Math.abs(x2H - x2);
            float dy = Math.abs(y2H - y2);
            if (!(dx <= tolerance) || !(dy <= tolerance)) continue;
            ++count;
        }
        return count;
    }

    static int translateCorners(Map<InterestPoint, InterestPoint> matches, Point2D[] src_corners, Point2D[] dst_corners) {
        int n = matches.size();
        if (n < 4) {
            return 0;
        }
        Point2Df[] pt1 = new Point2Df[n];
        Point2Df[] pt2 = new Point2Df[n];
        int i2 = 0;
        for (Map.Entry<InterestPoint, InterestPoint> pair : matches.entrySet()) {
            pt1[i2] = new Point2Df(pair.getKey().x, pair.getKey().y);
            pt2[i2] = new Point2Df(pair.getValue().x, pair.getValue().y);
            ++i2;
        }
        int CV_RANSAC = 8;
        double[] h = Matcher.cvFindHomography(pt1, pt2, 8, 5.0);
        if (h == null) {
            return 0;
        }
        for (i2 = 0; i2 < 4; ++i2) {
            double x = src_corners[i2].x;
            double y = src_corners[i2].y;
            double Z = 1.0 / (h[6] * x + h[7] * y + h[8]);
            double X = (h[0] * x + h[1] * y + h[2]) * Z;
            double Y = (h[3] * x + h[4] * y + h[5]) * Z;
            dst_corners[i2] = new Point2D((int)Math.round(X), (int)Math.round(Y));
        }
        return 1;
    }

    static double[] cvFindHomography(Point2Df[] objectPoints, Point2Df[] imagePoints, int method, double ransacReprojThreshold) {
        double[] homography = null;
        return homography;
    }

    public static class Point2Df {
        public float x;
        public float y;

        public Point2Df() {
        }

        public Point2Df(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class Point2D {
        public int x;
        public int y;

        public Point2D() {
        }

        public Point2D(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

