/*
 * Decompiled with CFR 0.152.
 */
package tracking.surfold;

import ij.IJ;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;

public class InterestPoint {
    public float x;
    public float y;
    public float strength;
    float trace;
    public boolean sign;
    public float scale;
    public float orientation;
    float[] descriptor;
    float dx;
    float dy;

    public InterestPoint() {
    }

    public InterestPoint(float x, float y, float strength, float trace, float scale) {
        this.x = x;
        this.y = y;
        this.strength = strength;
        this.trace = trace;
        this.scale = scale;
        this.sign = trace >= 0.0f;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb, Locale.US);
        f.format("%12f %12f %12f %12f %12f %12f ", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.strength), Float.valueOf(this.trace), Float.valueOf(this.scale), Float.valueOf(this.orientation));
        int descSize = this.descriptor == null ? 0 : this.descriptor.length;
        f.format("%12d ", descSize);
        if (descSize > 0) {
            for (int i2 = 0; i2 < descSize; ++i2) {
                if (i2 % 8 == 0) {
                    f.format("\n", new Object[0]);
                }
                f.format("%12f ", Float.valueOf(this.descriptor[i2]));
            }
            f.format("\n", new Object[0]);
        }
        return f.toString();
    }

    public static void saveToFile(List<InterestPoint> ipts, String fileName, boolean inclDescriptor) {
        try {
            PrintWriter out = new PrintWriter(fileName);
            if (ipts != null && ipts.size() > 0) {
                out.println(ipts.size() + "\n");
                for (InterestPoint ipt : ipts) {
                    if (inclDescriptor) {
                        out.println(ipt);
                        continue;
                    }
                    float[] temp = ipt.descriptor;
                    ipt.descriptor = null;
                    out.println(ipt);
                    ipt.descriptor = temp;
                }
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            IJ.error((String)"SURF: savePointsToFile", (String)e.getMessage());
        }
    }

    public static List<InterestPoint> loadFromFile(String fileName) {
        try {
            Scanner in = new Scanner(new File(fileName));
            int iptsSize = in.nextInt();
            ArrayList<InterestPoint> ipts = new ArrayList<InterestPoint>(iptsSize);
            for (int i2 = 0; i2 < iptsSize; ++i2) {
                float x = in.nextFloat();
                float y = in.nextFloat();
                float strength = in.nextFloat();
                float trace = in.nextFloat();
                float scale = in.nextFloat();
                float ori = in.nextFloat();
                int descSize = in.nextInt();
                InterestPoint ipt = new InterestPoint(x, y, strength, trace, scale);
                ipt.orientation = ori;
                if (descSize > 0) {
                    ipt.descriptor = new float[descSize];
                    for (int j = 0; j < descSize; ++j) {
                        ipt.descriptor[j] = in.nextFloat();
                    }
                }
                ipts.add(ipt);
            }
            in.close();
            return ipts;
        }
        catch (FileNotFoundException e) {
            IJ.error((String)"SURF: loadPointsFromFile", (String)e.getMessage());
            return null;
        }
    }
}

