/*
 * Decompiled with CFR 0.152.
 */
package tracking.surfold;

import ij.IJ;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class IntegralImage {
    public float[][] data;
    private int width;
    private int height;
    private int maxX;
    private int maxY;

    private void setData(float[][] a) {
        this.data = a;
        this.width = this.data.length;
        this.height = this.data[0].length;
        this.maxX = this.width - 1;
        this.maxY = this.height - 1;
    }

    public float get(int x, int y) {
        return this.data[x][y];
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public IntegralImage(ImageProcessor src) {
        this.setData(src.convertToByte(false).getFloatArray());
        this.convertInternalBufferToIntegralImage();
    }

    private void convertInternalBufferToIntegralImage() {
        float rowSum = 0.0f;
        for (int x = 0; x < this.width; ++x) {
            this.data[x][0] = rowSum += this.data[x][0];
        }
        for (int y = 1; y < this.height; ++y) {
            rowSum = 0.0f;
            for (int x = 0; x < this.width; ++x) {
                this.data[x][y] = (rowSum += this.data[x][y]) + this.data[x][y - 1];
            }
        }
    }

    public IntegralImage(ImageProcessor src, boolean weightedAndNormalizedConversion) {
        float val;
        int x;
        int y;
        int i2;
        int width = src.getWidth();
        int height = src.getHeight();
        float[][] a = new float[width][height];
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        if (src instanceof ByteProcessor || src instanceof ShortProcessor || src instanceof FloatProcessor) {
            i2 = 0;
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    a[x][y] = val = src.getf(i2++);
                    if (val < min) {
                        min = val;
                        continue;
                    }
                    if (!(val > max)) continue;
                    max = val;
                }
            }
        } else if (src instanceof ColorProcessor) {
            float rw = 0.299f;
            float gw = 0.587f;
            float bw = 0.114f;
            i2 = 0;
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    int intVal = src.get(i2++);
                    int r = (intVal & 0xFF0000) >> 16;
                    int g = (intVal & 0xFF00) >> 8;
                    int b = intVal & 0xFF;
                    a[x][y] = val = (float)r * rw + (float)g * gw + (float)b * bw;
                    if (val < min) {
                        min = val;
                        continue;
                    }
                    if (!(val > max)) continue;
                    max = val;
                }
            }
        } else {
            IJ.error((String)"SURF: IntegralImage", (String)"Unknown image type.\nCannot proceed.");
            return;
        }
        float scale = 1.0f / (max - min);
        i2 = 0;
        for (x = 0; x < width; ++x) {
            float[] col = a[x];
            for (y = 0; y < height; ++y) {
                val = col[y] - min;
                if (val < 0.0f) {
                    val = 0.0f;
                }
                if ((val *= scale) > 1.0f) {
                    val = 1.0f;
                }
                col[y] = val;
            }
        }
        this.setData(a);
        this.convertInternalBufferToIntegralImage();
    }

    float area(int x1, int y1, int rectWidth, int rectHeight) {
        int x2 = --x1 + rectWidth;
        int y2 = --y1 + rectHeight;
        if (x1 > this.maxX) {
            x1 = this.maxX;
        }
        if (y1 > this.maxY) {
            y1 = this.maxY;
        }
        if (x2 > this.maxX) {
            x2 = this.maxX;
        }
        if (y2 > this.maxY) {
            y2 = this.maxY;
        }
        float A = x1 < 0 || y1 < 0 ? 0.0f : this.data[x1][y1];
        float B = x2 < 0 || y1 < 0 ? 0.0f : this.data[x2][y1];
        float C = x1 < 0 || y2 < 0 ? 0.0f : this.data[x1][y2];
        float D = x2 < 0 || y2 < 0 ? 0.0f : this.data[x2][y2];
        return D - B - C + A;
    }

    float area2(int x1, int y1, int rectWidth, int rectHeight) {
        int x2 = --x1 + rectWidth;
        int y2 = --y1 + rectHeight;
        return this.data[x2][y2] - this.data[x2][y1] - this.data[x1][y2] + this.data[x1][y1];
    }
}

