/*
 * Decompiled with CFR 0.152.
 */
package tracking.surfold;

import ij.IJ;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import tracking.surfold.Descriptor;
import tracking.surfold.Detector;
import tracking.surfold.IntegralImage;
import tracking.surfold.InterestPoint;
import tracking.surfold.Params;
import tracking.surfold.Statistics;

public class IJFacade {
    private static List<InterestPoint> lastResult = null;

    private IJFacade() {
    }

    public static synchronized void setLastResult(List<InterestPoint> ipts) {
        lastResult = ipts;
    }

    public static synchronized List<InterestPoint> getLastResult() {
        return lastResult;
    }

    public static List<InterestPoint> detectAndDescribeInterestPoints(IntegralImage intImg) {
        return IJFacade.detectAndDescribeInterestPoints(intImg, new Params());
    }

    public static List<InterestPoint> detectAndDescribeInterestPoints(IntegralImage intImg, Params p) {
        long begin = System.currentTimeMillis();
        List<InterestPoint> ipts = Detector.fastHessian(intImg, p);
        long end = System.currentTimeMillis();
        p.getStatistics().timeSURFDetector = end - begin;
        p.getStatistics().detectedIPs = ipts.size();
        float[] strengthOfIPs = new float[ipts.size()];
        for (int i2 = 0; i2 < ipts.size(); ++i2) {
            strengthOfIPs[i2] = ipts.get((int)i2).strength;
        }
        Arrays.sort(strengthOfIPs);
        p.getStatistics().strengthOfIPs = strengthOfIPs;
        begin = System.currentTimeMillis();
        if (!p.isUpright()) {
            for (InterestPoint ipt : ipts) {
                Descriptor.computeAndSetOrientation(ipt, intImg);
            }
        }
        for (InterestPoint ipt : ipts) {
            Descriptor.computeAndSetDescriptor(ipt, intImg, p);
        }
        end = System.currentTimeMillis();
        p.getStatistics().timeSURFDescriptor = end - begin;
        IJFacade.setLastResult(ipts);
        return ipts;
    }

    public static void drawInterestPoints(ImageProcessor img, List<InterestPoint> ipts, Params params) {
        for (InterestPoint ipt : ipts) {
            IJFacade.drawSingleInterestPoint(img, params, ipt);
        }
    }

    public static void drawSingleInterestPoint(ImageProcessor img, Params p, InterestPoint ipt) {
        int x = Math.round(ipt.x);
        int y = Math.round(ipt.y);
        float w = ipt.scale * 10.0f;
        float ori = ipt.orientation;
        float co = (float)Math.cos(ori);
        float si = (float)Math.sin(ori);
        float s = ipt.strength * 10000.0f;
        if (p.isDisplayDescriptorWindows()) {
            img.setLineWidth(p.getLineWidth());
            img.setColor(p.getDescriptorWindowColor());
            float x0 = w * (si + co) + ipt.x;
            float y0 = w * (-co + si) + ipt.y;
            float x1 = w * (si - co) + ipt.x;
            float y1 = w * (-co - si) + ipt.y;
            float x2 = w * (-si - co) + ipt.x;
            float y2 = w * (co - si) + ipt.y;
            float x3 = w * (-si + co) + ipt.x;
            float y3 = w * (co + si) + ipt.y;
            img.moveTo(x, y);
            img.lineTo(Math.round(x0), Math.round(y0));
            img.lineTo(Math.round(x1), Math.round(y1));
            img.lineTo(Math.round(x2), Math.round(y2));
            img.lineTo(Math.round(x3), Math.round(y3));
            img.lineTo(x, y);
        }
        if (p.isDisplayOrientationVectors()) {
            img.setLineWidth(p.getLineWidth());
            img.setColor(p.getOrientationVectorColor());
            img.drawLine(x, y, Math.round(s * co + (float)x), Math.round(s * si + (float)y));
        }
        img.setLineWidth(p.getLineWidth() * 4);
        if (ipt.sign) {
            img.setColor(p.getDarkPointColor());
        } else {
            img.setColor(p.getLightPointColor());
        }
        img.drawDot(x, y);
    }

    public static void drawSingleInterestPoint(ImageProcessor img, InterestPoint ipt, boolean window, boolean orientation) {
        int x = Math.round(ipt.x);
        int y = Math.round(ipt.y);
        float w = ipt.scale * 10.0f;
        float ori = ipt.orientation;
        float co = (float)Math.cos(ori);
        float si = (float)Math.sin(ori);
        float s = ipt.strength * 10000.0f;
        if (window) {
            img.setLineWidth(1);
            img.setColor(Color.cyan);
            float x0 = w * (si + co) + ipt.x;
            float y0 = w * (-co + si) + ipt.y;
            float x1 = w * (si - co) + ipt.x;
            float y1 = w * (-co - si) + ipt.y;
            float x2 = w * (-si - co) + ipt.x;
            float y2 = w * (co - si) + ipt.y;
            float x3 = w * (-si + co) + ipt.x;
            float y3 = w * (co + si) + ipt.y;
            img.moveTo(x, y);
            img.lineTo(Math.round(x0), Math.round(y0));
            img.lineTo(Math.round(x1), Math.round(y1));
            img.lineTo(Math.round(x2), Math.round(y2));
            img.lineTo(Math.round(x3), Math.round(y3));
            img.lineTo(x, y);
        }
        if (orientation) {
            img.setLineWidth(1);
            img.setColor(Color.yellow);
            img.drawLine(x, y, Math.round(s * co + (float)x), Math.round(s * si + (float)y));
        }
        img.setLineWidth(3);
        if (ipt.sign) {
            img.setColor(Color.red);
        } else {
            img.setColor(Color.blue);
        }
        img.drawDot(x, y);
    }

    public static void displayStatistics(Params p) {
        String[] rows;
        Statistics stat = p.getStatistics();
        IJ.write((String)("Start Time:\t" + stat.startTime));
        IJ.write((String)("Image:\t" + stat.imageTitle));
        IJ.write((String)"");
        IJ.write((String)"Params");
        IJ.write((String)("Octaves:\t" + p.getOctaves()));
        IJ.write((String)("Layers:\t" + p.getLayers()));
        IJ.write((String)("Threshold:\t" + IJ.d2s((double)p.getThreshold(), (int)5)));
        IJ.write((String)("InitSamplStep:\t" + p.getInitStep()));
        IJ.write((String)"");
        IJ.write((String)"Detector Statistics");
        IJ.write((String)Statistics.getHeadersForIJ());
        for (String s : rows = stat.getRowsForIJ()) {
            IJ.write((String)s);
        }
        IJ.write((String)"");
        int detectedIPs = p.getStatistics().detectedIPs;
        IJ.write((String)("Interest Points:\t" + detectedIPs));
        IJ.write((String)"");
        IJ.write((String)"Strength of Interest Points");
        float[] strengthOfIPs = p.getStatistics().strengthOfIPs;
        IJ.write((String)("Min:\t" + IJ.d2s((double)strengthOfIPs[0], (int)10)));
        IJ.write((String)("Max:\t" + IJ.d2s((double)strengthOfIPs[detectedIPs - 1], (int)10)));
        IJ.write((String)("Median:\t" + IJ.d2s((double)strengthOfIPs[detectedIPs / 2], (int)10)));
        float sum = 0.0f;
        for (float v : strengthOfIPs) {
            sum += v;
        }
        IJ.write((String)("Average:\t" + IJ.d2s((double)(sum / (float)detectedIPs), (int)10)));
        IJ.write((String)"");
        IJ.write((String)"Time (ms)");
        IJ.write((String)("IntegralImage:\t" + stat.timeIntegralImage));
        IJ.write((String)("Detector:\t" + stat.timeSURFDetector));
        IJ.write((String)("Descriptor:\t" + stat.timeSURFDescriptor));
        IJ.write((String)"");
        IJ.write((String)"");
    }
}

