/*
 * Decompiled with CFR 0.152.
 */
package tracking.surfold;

import java.util.ArrayList;
import java.util.List;
import tracking.surfold.IntegralImage;
import tracking.surfold.InterestPoint;
import tracking.surfold.Params;

public class Detector {
    static final float EPSILON = 1.4E-43f;

    public static List<InterestPoint> fastHessian(IntegralImage img, Params p) {
        float[][][] det = new float[p.getLayers()][img.getWidth()][img.getHeight()];
        float[][][] trace = new float[p.getLayers()][img.getWidth()][img.getHeight()];
        ArrayList<InterestPoint> res = new ArrayList<InterestPoint>(2000);
        int octave = 0;
        int step = p.getInitStep();
        while (octave < p.getOctaves()) {
            int layer;
            int margin = p.getMaxFilterSize(octave) / 2;
            int xBound = img.getWidth() - margin;
            int yBound = img.getHeight() - margin;
            for (layer = 0; layer < p.getLayers(); ++layer) {
                int w = p.getFilterSize(octave, layer);
                int L = w / 3;
                int L2 = 2 * L - 1;
                int wHalf = w / 2;
                int LHalf = L / 2;
                int Lminus1 = L - 1;
                float filterArea = w * w;
                for (int y = margin; y < yBound; y += step) {
                    for (int x = margin; x < xBound; x += step) {
                        float Dxx = img.area(x - wHalf, y - Lminus1, w, L2) - img.area(x - LHalf, y - Lminus1, L, L2) * 3.0f;
                        float Dyy = img.area(x - Lminus1, y - wHalf, L2, w) - img.area(x - Lminus1, y - LHalf, L2, L) * 3.0f;
                        float Dxy = img.area(x - L, y - L, L, L) - img.area(x + 1, y - L, L, L) + img.area(x + 1, y + 1, L, L) - img.area(x - L, y + 1, L, L);
                        det[layer][x][y] = (Dxx /= filterArea) * (Dyy /= filterArea) - 0.81f * (Dxy /= filterArea) * Dxy;
                        trace[layer][x][y] = Dxx + Dyy;
                    }
                }
            }
            margin += step;
            xBound -= step;
            yBound -= step;
            for (layer = 1; layer < p.getLayers() - 1; ++layer) {
                int filterSize = p.getFilterSize(octave, layer);
                int filterSizeIncrement = filterSize - p.getFilterSize(octave, layer - 1);
                int countIPCandidates = 0;
                int countThresholded = 0;
                int countSuppressed = 0;
                int countInterpolationNotSucceed = 0;
                int countBadInterpolationResult = 0;
                int countIP = 0;
                for (int y = margin; y < yBound; y += step) {
                    for (int x = margin; x < xBound; x += step) {
                        ++countIPCandidates;
                        float v = det[layer][x][y];
                        if (v < p.getThreshold()) {
                            ++countThresholded;
                            continue;
                        }
                        if (!Detector.isLocalMaximum(v, det, layer, x, y, step)) {
                            ++countSuppressed;
                            continue;
                        }
                        float[] X = Detector.interpolatePoint(det, layer, x, y, step);
                        if (X == null) {
                            ++countInterpolationNotSucceed;
                            continue;
                        }
                        float xInterp = (float)x + X[0] * (float)step;
                        float yInterp = (float)y + X[1] * (float)step;
                        float scale = ((float)filterSize + X[2] * (float)filterSizeIncrement) * 0.13333334f;
                        if (scale >= 1.0f && xInterp >= 0.0f && xInterp < (float)img.getWidth() && yInterp >= 0.0f && yInterp < (float)img.getHeight()) {
                            ++countIP;
                            res.add(new InterestPoint(xInterp, yInterp, det[layer][x][y], trace[layer][x][y], scale));
                            continue;
                        }
                        ++countBadInterpolationResult;
                    }
                }
                p.getStatistics().add(octave, layer, countIPCandidates, countThresholded, countSuppressed, countInterpolationNotSucceed, countBadInterpolationResult, countIP);
            }
            ++octave;
            step *= p.getStepIncFactor();
        }
        return res;
    }

    private static boolean isLocalMaximum(float v, float[][][] det, int s, int x, int y, int step) {
        float[][] l = det[s - 1];
        float[][] m = det[s];
        float[][] u = det[s + 1];
        int px = x - step;
        int nx = x + step;
        int py = y - step;
        int ny = y + step;
        return v >= l[px][py] && v >= l[px][y] && v >= l[px][ny] && v >= l[x][py] && v >= l[x][y] && v >= l[x][ny] && v >= l[nx][py] && v >= l[nx][y] && v >= l[nx][ny] && v >= m[px][py] && v >= m[px][y] && v >= m[px][ny] && v >= m[x][py] && v >= m[x][ny] && v >= m[nx][py] && v >= m[nx][y] && v >= m[nx][ny] && v >= u[px][py] && v >= u[px][y] && v >= u[px][ny] && v >= u[x][py] && v >= u[x][y] && v >= u[x][ny] && v >= u[nx][py] && v >= u[nx][y] && v >= u[nx][ny];
    }

    static float[] interpolatePoint(float[][][] det, int i2, int x, int y, int step) {
        float[][] l = det[i2 - 1];
        float[][] m = det[i2];
        float[][] u = det[i2 + 1];
        int px = x - step;
        int nx = x + step;
        int py = y - step;
        int ny = y + step;
        float dx = -(m[nx][y] - m[px][y]) / 2.0f;
        float dy = -(m[x][ny] - m[x][py]) / 2.0f;
        float ds = -(u[x][y] - l[x][y]) / 2.0f;
        float[] b = new float[]{dx, dy, ds};
        float v = m[x][y];
        float dxx = m[px][y] - 2.0f * v + m[nx][y];
        float dxy = (m[nx][ny] - m[px][ny] - m[nx][py] + m[px][py]) / 4.0f;
        float dxs = (u[nx][y] - u[px][y] - l[nx][y] + l[px][y]) / 4.0f;
        float dyx = dxy;
        float dyy = m[x][py] - 2.0f * v + m[x][ny];
        float dys = (u[x][ny] - u[x][py] - l[x][ny] + l[x][py]) / 4.0f;
        float dsx = dxs;
        float dsy = dys;
        float dss = l[x][y] - 2.0f * v + u[x][y];
        float[][] A = new float[][]{{dxx, dxy, dxs}, {dyx, dyy, dys}, {dsx, dsy, dss}};
        float[] X = new float[3];
        if (Detector.solve(A, b, X)) {
            return X;
        }
        return null;
    }

    public static boolean solve(float[][] A, float[] B, float[] X) {
        float a = A[0][0];
        float b = A[0][1];
        float c = A[0][2];
        float d = A[1][0];
        float e = A[1][1];
        float f = A[1][2];
        float g = A[2][0];
        float h = A[2][1];
        float i2 = A[2][2];
        float r = B[0];
        float s = B[1];
        float t = B[2];
        float detA = Detector.det(a, b, c, d, e, f, g, h, i2);
        if (Detector.equal(detA, 0.0f)) {
            return false;
        }
        float detX1 = Detector.det(r, b, c, s, e, f, t, h, i2);
        float detX2 = Detector.det(a, r, c, d, s, f, g, t, i2);
        float detX3 = Detector.det(a, b, r, d, e, s, g, h, t);
        X[0] = detX1 / detA;
        X[1] = detX2 / detA;
        X[2] = detX3 / detA;
        return true;
    }

    static float det(float a, float b, float c, float d, float e, float f, float g, float h, float i2) {
        return a * (e * i2 - f * h) + b * (f * g - d * i2) + c * (d * h - e * g);
    }

    public static boolean equal(float f1, float f2) {
        return Math.abs(f1 - f2) < 1.4E-43f;
    }
}

