/*
 * Decompiled with CFR 0.152.
 */
package tracking.surfold;

import tracking.surfold.IntegralImage;
import tracking.surfold.InterestPoint;
import tracking.surfold.Params;

public class Descriptor {
    static final float pi = 3.14159f;
    static final double[][] gauss25 = new double[][]{{0.02350693969273, 0.01849121369071, 0.01239503121241, 0.00708015417522, 0.00344628101733, 0.00142945847484, 5.052487906E-4}, {0.02169964028389, 0.01706954162243, 0.01144205592615, 0.00653580605408, 0.00318131834134, 0.00131955648461, 4.6640341759E-4}, {0.01706954162243, 0.01342737701584, 0.00900063997939, 0.00514124713667, 0.00250251364222, 0.00103799989504, 3.6688592278E-4}, {0.01144205592615, 0.00900063997939, 0.00603330940534, 0.00344628101733, 0.00167748505986, 6.9579213743E-4, 2.4593098864E-4}, {0.00653580605408, 0.00514124713667, 0.00344628101733, 0.00196854695367, 9.5819467066E-4, 3.9744277546E-4, 1.404780098E-4}, {0.00318131834134, 0.00250251364222, 0.00167748505986, 9.5819467066E-4, 4.6640341759E-4, 1.9345616757E-4, 6.837798818E-5}, {0.00131955648461, 0.00103799989504, 6.9579213743E-4, 3.9744277546E-4, 1.9345616757E-4, 8.024231247E-5, 2.836202103E-5}};
    static final double[][] gauss33 = new double[][]{{0.014614763, 0.013958917, 0.012162744, 0.00966788, 0.00701053, 0.004637568, 0.002798657, 0.001540738, 7.73799E-4, 3.54525E-4, 1.48179E-4}, {0.013958917, 0.013332502, 0.011616933, 0.009234028, 0.006695928, 0.004429455, 0.002673066, 0.001471597, 7.39074E-4, 3.38616E-4, 1.41529E-4}, {0.012162744, 0.011616933, 0.010122116, 0.008045833, 0.005834325, 0.003859491, 0.002329107, 0.001282238, 6.43973E-4, 2.95044E-4, 1.23318E-4}, {0.00966788, 0.009234028, 0.008045833, 0.006395444, 0.004637568, 0.003067819, 0.001851353, 0.001019221, 5.11879E-4, 2.34524E-4, 9.80224E-5}, {0.00701053, 0.006695928, 0.005834325, 0.004637568, 0.003362869, 0.002224587, 0.001342483, 7.39074E-4, 3.71182E-4, 1.70062E-4, 7.10796E-5}, {0.004637568, 0.004429455, 0.003859491, 0.003067819, 0.002224587, 0.001471597, 8.88072E-4, 4.88908E-4, 2.45542E-4, 1.12498E-4, 4.70202E-5}, {0.002798657, 0.002673066, 0.002329107, 0.001851353, 0.001342483, 8.88072E-4, 5.35929E-4, 2.95044E-4, 1.48179E-4, 6.78899E-5, 2.83755E-5}, {0.001540738, 0.001471597, 0.001282238, 0.001019221, 7.39074E-4, 4.88908E-4, 2.95044E-4, 1.6243E-4, 8.15765E-5, 3.73753E-5, 1.56215E-5}, {7.73799E-4, 7.39074E-4, 6.43973E-4, 5.11879E-4, 3.71182E-4, 2.45542E-4, 1.48179E-4, 8.15765E-5, 4.09698E-5, 1.87708E-5, 7.84553E-6}, {3.54525E-4, 3.38616E-4, 2.95044E-4, 2.34524E-4, 1.70062E-4, 1.12498E-4, 6.78899E-5, 3.73753E-5, 1.87708E-5, 8.60008E-6, 3.59452E-6}, {1.48179E-4, 1.41529E-4, 1.23318E-4, 9.80224E-5, 7.10796E-5, 4.70202E-5, 2.83755E-5, 1.56215E-5, 7.84553E-6, 3.59452E-6, 1.50238E-6}};

    public static void computeAndSetDescriptor(InterestPoint ipt, IntegralImage intImg, Params p) {
        float si;
        float co;
        if (p.isUpright()) {
            co = 1.0f;
            si = 0.0f;
        } else {
            co = (float)Math.cos(ipt.orientation);
            si = (float)Math.sin(ipt.orientation);
        }
        float[] desc = new float[p.getDescSize()];
        int count = 0;
        int ix = 0;
        int jx = 0;
        int xs = 0;
        int ys = 0;
        float gauss_s1 = 0.0f;
        float gauss_s2 = 0.0f;
        float rx = 0.0f;
        float ry = 0.0f;
        float rrx = 0.0f;
        float rry = 0.0f;
        float len = 0.0f;
        float scale = ipt.scale;
        int doubledScale = 2 * Math.round(scale);
        int x = Math.round(ipt.x);
        int y = Math.round(ipt.y);
        int j = 0;
        float cx = -0.5f;
        float cy = 0.0f;
        for (int i2 = -8; i2 < 12; i2 += 9) {
            i2 -= 4;
            cx += 1.0f;
            cy = -0.5f;
            for (j = -8; j < 12; j += 9) {
                float mdy = 0.0f;
                float mdx = 0.0f;
                float dy = 0.0f;
                float dx = 0.0f;
                cy += 1.0f;
                ix = i2 + 5;
                jx = (j -= 4) + 5;
                xs = Math.round((float)x + ((float)(-jx) * scale * si + (float)ix * scale * co));
                ys = Math.round((float)y + ((float)jx * scale * co + (float)ix * scale * si));
                for (int k = i2; k < i2 + 9; ++k) {
                    for (int l = j; l < j + 9; ++l) {
                        int sample_x = Math.round((float)x + scale * ((float)(-l) * si + (float)k * co));
                        int sample_y = Math.round((float)y + scale * ((float)l * co + (float)k * si));
                        gauss_s1 = Descriptor.gaussian(xs - sample_x, ys - sample_y, 2.5f * scale);
                        rx = Descriptor.haarX(intImg, sample_x, sample_y, doubledScale);
                        ry = Descriptor.haarY(intImg, sample_x, sample_y, doubledScale);
                        rrx = gauss_s1 * (-rx * si + ry * co);
                        rry = gauss_s1 * (rx * co + ry * si);
                        dx += rrx;
                        dy += rry;
                        mdx += Math.abs(rrx);
                        mdy += Math.abs(rry);
                    }
                }
                gauss_s2 = Descriptor.gaussian(cx - 2.0f, cy - 2.0f, 1.5f);
                desc[count++] = dx * gauss_s2;
                desc[count++] = dy * gauss_s2;
                desc[count++] = mdx * gauss_s2;
                desc[count++] = mdy * gauss_s2;
                len += (dx * dx + dy * dy + mdx * mdx + mdy * mdy) * gauss_s2 * gauss_s2;
            }
        }
        len = (float)Math.sqrt(len);
        int idx = 0;
        while (idx < p.getDescSize()) {
            int n = idx++;
            desc[n] = desc[n] / len;
        }
        ipt.descriptor = desc;
    }

    public static void computeAndSetOrientation(InterestPoint ipt, IntegralImage intImg) {
        float[] resX = new float[109];
        float[] resY = new float[109];
        float[] Ang = new float[109];
        int[] id = new int[]{6, 5, 4, 3, 2, 1, 0, 1, 2, 3, 4, 5, 6};
        int x = Math.round(ipt.x);
        int y = Math.round(ipt.y);
        int s = Math.round(ipt.scale);
        int waveletSize = 4 * s;
        int i2 = 0;
        float gauss = 0.0f;
        for (int dx = -6; dx <= 6; ++dx) {
            for (int dy = -6; dy <= 6; ++dy) {
                if (dx * dx + dy * dy >= 36) continue;
                gauss = (float)gauss25[id[dx + 6]][id[dy + 6]];
                resX[i2] = gauss * Descriptor.haarX(intImg, x + dx * s, y + dy * s, waveletSize);
                resY[i2] = gauss * Descriptor.haarY(intImg, x + dx * s, y + dy * s, waveletSize);
                Ang[i2] = Descriptor.getAngle(resX[i2], resY[i2]);
                ++i2;
            }
        }
        float windowSize = 1.0471967f;
        float step = 0.15f;
        float twoPi = 6.28318f;
        float sumX = 0.0f;
        float sumY = 0.0f;
        float current = 0.0f;
        float max = 0.0f;
        float orientation = 0.0f;
        float ang1 = 0.0f;
        float ang2 = ang1 + 1.0471967f;
        while (ang1 < twoPi) {
            sumY = 0.0f;
            sumX = 0.0f;
            for (int k = 0; k < Ang.length; ++k) {
                if (!(ang1 <= Ang[k] && Ang[k] < ang2) && (!(ang1 <= Ang[k] + twoPi) || !(Ang[k] + twoPi < ang2))) continue;
                sumX += resX[k];
                sumY += resY[k];
            }
            current = sumX * sumX + sumY * sumY;
            if (current > max) {
                max = current;
                orientation = Descriptor.getAngle(sumX, sumY);
            }
            ang1 += 0.15f;
            ang2 += 0.15f;
        }
        ipt.orientation = orientation;
    }

    static float gaussian(float x, float y, float sig) {
        return (float)((double)(1.0f / (6.28318f * sig * sig)) * Math.exp(-(x * x + y * y) / (2.0f * sig * sig)));
    }

    static float haarX(IntegralImage img, int x, int y, int w) {
        int wHalf = w / 2;
        return img.area(x, y - wHalf, wHalf, w) - img.area(x - wHalf, y - wHalf, wHalf, w);
    }

    static float haarY(IntegralImage img, int x, int y, int w) {
        int wHalf = w / 2;
        return img.area(x - wHalf, y, w, wHalf) - img.area(x - wHalf, y - wHalf, w, wHalf);
    }

    static float getAngle(float x, float y) {
        if (x >= 0.0f && y >= 0.0f) {
            return (float)Math.atan(y / x);
        }
        if (x < 0.0f && y >= 0.0f) {
            return (float)((double)3.14159f - Math.atan(-y / x));
        }
        if (x < 0.0f && y < 0.0f) {
            return (float)((double)3.14159f + Math.atan(y / x));
        }
        if (x >= 0.0f && y < 0.0f) {
            return (float)((double)6.28318f - Math.atan(-y / x));
        }
        return 0.0f;
    }
}

