/*
 * Decompiled with CFR 0.152.
 */
package tracking.surfold;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import tracking.surfold.IJFacade;
import tracking.surfold.IntegralImage;
import tracking.surfold.InterestPoint;
import tracking.surfold.Matcher;
import tracking.surfold.Params;

public class Compare_Images
implements PlugIn {
    String title = "SURF: Compare Images";

    public void run(String arg) {
        int[] imageIDs = WindowManager.getIDList();
        if (imageIDs == null || imageIDs.length < 2) {
            IJ.error((String)this.title, (String)"You need at least two images, e.g. :\n1) object to find,\n2) image where to search for.\nOpen these images in ImageJ.");
            return;
        }
        String[] images = new String[imageIDs.length];
        for (int i2 = 0; i2 < imageIDs.length; ++i2) {
            images[i2] = WindowManager.getImage((int)imageIDs[i2]).getTitle();
        }
        GenericDialog gd = new GenericDialog("Parameter (" + this.title + ")");
        gd.addChoice("Image 1 (e.g. object to find):", images, images[0]);
        gd.addChoice("Image 2 (e.g. image where to search for):", images, images[1]);
        gd.addCheckbox("Perform reverse comparison too (gives more accurate results)", true);
        gd.addCheckbox("Use homography matrix to check correctness (Open File dialog will be shown)", false);
        Params.addSurfParamsToDialog(gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        ImagePlus image1 = WindowManager.getImage((String)gd.getNextChoice());
        ImagePlus image2 = WindowManager.getImage((String)gd.getNextChoice());
        boolean doReverseComparisonToo = gd.getNextBoolean();
        boolean useHomography = gd.getNextBoolean();
        float[][] homography = null;
        if (useHomography && (homography = this.loadHomographyMatrixFromFile()) == null) {
            return;
        }
        Params p1 = Params.getSurfParamsFromDialog(gd);
        Params p2 = new Params(p1);
        p1.getStatistics().startTime = new Date();
        p1.getStatistics().imageTitle = image1.getTitle();
        long begin = System.currentTimeMillis();
        IntegralImage intImg1 = new IntegralImage(image1.getProcessor(), true);
        long end = System.currentTimeMillis();
        p1.getStatistics().timeIntegralImage = end - begin;
        List<InterestPoint> ipts1 = IJFacade.detectAndDescribeInterestPoints(intImg1, p1);
        p2.getStatistics().startTime = new Date();
        p2.getStatistics().imageTitle = image2.getTitle();
        begin = System.currentTimeMillis();
        IntegralImage intImg2 = new IntegralImage(image2.getProcessor(), true);
        end = System.currentTimeMillis();
        p2.getStatistics().timeIntegralImage = end - begin;
        List<InterestPoint> ipts2 = IJFacade.detectAndDescribeInterestPoints(intImg2, p2);
        begin = System.currentTimeMillis();
        Map<InterestPoint, InterestPoint> matchedPoints = Matcher.findMathes(ipts1, ipts2);
        if (doReverseComparisonToo) {
            Map<InterestPoint, InterestPoint> matchedPointsReverse = Matcher.findMathes(ipts2, ipts1);
            matchedPoints = this.intersection(matchedPoints, matchedPointsReverse);
        }
        end = System.currentTimeMillis();
        if (matchedPoints.size() == 0) {
            IJ.showMessage((String)this.title, (String)"No matches found.");
            return;
        }
        ImageProcessor image1ProcessorCopy = image1.getProcessor().duplicate().convertToRGB();
        String image1NewTitle = String.format("%s: %d of %d Interest Points", image1.getTitle().split(":")[0], matchedPoints.size(), ipts1.size());
        ImagePlus image1Copy = new ImagePlus(image1NewTitle, image1ProcessorCopy);
        ImageProcessor imageProcessor2Copy = image2.getProcessor().duplicate().convertToRGB();
        String image2NewTitle = String.format("%s: %d of %d Interest Points", image2.getTitle().split(":")[0], matchedPoints.size(), ipts2.size());
        ImagePlus image2Copy = new ImagePlus(image2NewTitle, imageProcessor2Copy);
        for (Map.Entry<InterestPoint, InterestPoint> pair : matchedPoints.entrySet()) {
            IJFacade.drawSingleInterestPoint(image1ProcessorCopy, p1, pair.getKey());
            IJFacade.drawSingleInterestPoint(imageProcessor2Copy, p2, pair.getValue());
        }
        image1Copy.show();
        image2Copy.show();
    }

    Map<InterestPoint, InterestPoint> intersection(Map<InterestPoint, InterestPoint> map1, Map<InterestPoint, InterestPoint> map2) {
        HashMap<InterestPoint, InterestPoint> result = new HashMap<InterestPoint, InterestPoint>();
        for (InterestPoint ipt1 : map1.keySet()) {
            InterestPoint ipt2;
            if (ipt1 != map2.get(ipt2 = map1.get(ipt1))) continue;
            result.put(ipt1, ipt2);
        }
        return result;
    }

    float[][] loadHomographyMatrixFromFile() {
        OpenDialog od = new OpenDialog("Choose a file containing 3x3 Homography Matrix (" + this.title + ")", null);
        String dir = od.getDirectory();
        String fileName = od.getFileName();
        if (fileName == null) {
            return null;
        }
        String fullName = dir + fileName;
        float[][] res = new float[3][3];
        try {
            Scanner in = new Scanner(new File(fullName));
            for (int i2 = 0; i2 < 3; ++i2) {
                for (int j = 0; j < 3; ++j) {
                    res[i2][j] = in.nextFloat();
                }
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            IJ.error((String)"SURF: loadHomographyFromFile", (String)e.getMessage());
            res = null;
        }
        return res;
    }
}

